/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.HashSet;
import java.util.Set;
import org.opensearch.common.util.concurrent.ThreadContext;

public class DocumentAllowList {
    private final Set<Entry> entries = new HashSet<Entry>();

    public void add(String index, String id) {
        this.add(new Entry(index, id));
    }

    public void add(Entry entry) {
        this.entries.add(entry);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void applyTo(ThreadContext threadContext) {
        if (!this.isEmpty()) {
            threadContext.putHeader("_opendistro_security_doc_allowlist", this.toString());
        }
    }

    public boolean isAllowed(String index, String id) {
        for (Entry entry : this.entries) {
            if (!entry.index.equals(index) || !entry.id.equals(id)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.entries.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry entry : this.entries) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(entry.index).append("/").append(DocumentAllowList.escapeId(entry.id));
        }
        return stringBuilder.toString();
    }

    public static DocumentAllowList parse(String string) {
        DocumentAllowList result = new DocumentAllowList();
        int length = string.length();
        if (length == 0) {
            return result;
        }
        int entryStart = 0;
        String index = null;
        int i = 0;
        while (true) {
            int c = i < length ? (int)string.charAt(i) : 124;
            while (c == 92) {
                c = string.charAt(i += 2);
            }
            if (c == 47) {
                index = string.substring(entryStart, i);
                entryStart = i + 1;
            } else if (c == 124) {
                if (index == null) {
                    throw new IllegalArgumentException("Malformed DocumentAllowList string: " + string);
                }
                String id = DocumentAllowList.unescapeId(string.substring(entryStart, i));
                result.add(index, id);
                index = null;
                entryStart = i + 1;
            }
            if (i >= length) break;
            ++i;
        }
        return result;
    }

    private static String escapeId(String id) {
        int length = id.length();
        boolean needsEscaping = false;
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (c != '/' && c != '|' && c != '\\') continue;
            needsEscaping = true;
            break;
        }
        if (!needsEscaping) {
            return id;
        }
        StringBuilder result = new StringBuilder(id.length() + 10);
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (c == '/' || c == '|' || c == '\\') {
                result.append('\\');
            }
            result.append(c);
        }
        return result.toString();
    }

    private static String unescapeId(String id) {
        int length = id.length();
        boolean needsEscaping = false;
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (c != '\\') continue;
            needsEscaping = true;
            break;
        }
        if (!needsEscaping) {
            return id;
        }
        StringBuilder result = new StringBuilder(id.length());
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (c == '\\') {
                c = id.charAt(++i);
            }
            result.append(c);
        }
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentAllowList other = (DocumentAllowList)obj;
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public static class Entry {
        private final String index;
        private final String id;

        Entry(String index, String id) {
            if (index.indexOf(47) != -1 || index.indexOf(124) != -1) {
                throw new IllegalArgumentException("Invalid index name: " + index);
            }
            this.index = index;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.index == null ? other.index != null : !this.index.equals(other.index));
        }

        public String toString() {
            return "DocumentAllowList.Entry [index=" + this.index + ", id=" + this.id + "]";
        }
    }
}

