/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.hasher;

import com.password4j.CompressedPBKDF2Function;
import com.password4j.HashingFunction;
import com.password4j.Password;
import java.nio.CharBuffer;
import java.security.AccessController;
import java.security.Permission;
import org.opensearch.SpecialPermission;
import org.opensearch.security.hasher.AbstractPasswordHasher;

class PBKDF2PasswordHasher
extends AbstractPasswordHasher {
    private static final int DEFAULT_SALT_LENGTH = 128;

    PBKDF2PasswordHasher(String function, int iterations, int length) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)new SpecialPermission());
        }
        this.hashingFunction = AccessController.doPrivileged(() -> CompressedPBKDF2Function.getInstance((String)function, (int)iterations, (int)length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hash(char[] password) {
        this.checkPasswordNotNullOrEmpty(password);
        CharBuffer passwordBuffer = CharBuffer.wrap(password);
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission((Permission)new SpecialPermission());
            }
            String string = AccessController.doPrivileged(() -> Password.hash((CharSequence)passwordBuffer).addRandomSalt(128).with(this.hashingFunction).getResult());
            return string;
        }
        finally {
            this.cleanup(passwordBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(char[] password, String hash) {
        this.checkPasswordNotNullOrEmpty(password);
        this.checkHashNotNullOrEmpty(hash);
        CharBuffer passwordBuffer = CharBuffer.wrap(password);
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission((Permission)new SpecialPermission());
            }
            boolean bl = AccessController.doPrivileged(() -> Password.check((CharSequence)passwordBuffer, (String)hash).with(this.getPBKDF2FunctionFromHash(hash)));
            return bl;
        }
        finally {
            this.cleanup(passwordBuffer);
        }
    }

    private HashingFunction getPBKDF2FunctionFromHash(String hash) {
        return CompressedPBKDF2Function.getInstanceFromHash((String)hash);
    }
}

