/**
 * @public
 * @enum
 */
export declare const OAuth2ErrorCode: {
    /**
     * Authorization code has expired
     */
    readonly AUTHCODE_EXPIRED: "AUTHCODE_EXPIRED";
    /**
     * Insufficient permissions to perform this operation
     */
    readonly INSUFFICIENT_PERMISSIONS: "INSUFFICIENT_PERMISSIONS";
    /**
     * The request is missing a required parameter, includes an invalid parameter value, or is otherwise malformed
     */
    readonly INVALID_REQUEST: "INVALID_REQUEST";
    /**
     * Internal server error occurred
     */
    readonly SERVER_ERROR: "server_error";
    /**
     * Token has expired and needs to be refreshed
     */
    readonly TOKEN_EXPIRED: "TOKEN_EXPIRED";
    /**
     * User credentials have been changed
     */
    readonly USER_CREDENTIALS_CHANGED: "USER_CREDENTIALS_CHANGED";
};
/**
 * @public
 */
export type OAuth2ErrorCode = (typeof OAuth2ErrorCode)[keyof typeof OAuth2ErrorCode];
