/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.transforms;

import java.io.File;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.transforms.ClassTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactory;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformForAgent;
import org.gradle.internal.classpath.types.InstrumentingTypeRegistry;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scopes.UserHome.class})
public class ClasspathElementTransformFactoryForAgent
implements ClasspathElementTransformFactory {
    private static final int AGENT_INSTRUMENTATION_VERSION = 3;
    private final ClasspathBuilder classpathBuilder;
    private final ClasspathWalker classpathWalker;

    public ClasspathElementTransformFactoryForAgent(ClasspathBuilder classpathBuilder, ClasspathWalker classpathWalker) {
        this.classpathBuilder = classpathBuilder;
        this.classpathWalker = classpathWalker;
    }

    @Override
    public void applyConfigurationTo(Hasher hasher) {
        hasher.putInt(3);
    }

    @Override
    public ClasspathElementTransform createTransformer(File file, ClassTransform classTransform, InstrumentingTypeRegistry typeRegistry) {
        return new ClasspathElementTransformForAgent(file, this.classpathBuilder, this.classpathWalker, typeRegistry, classTransform);
    }

    public String toString() {
        return "TransformFactory(agent)";
    }
}

