/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.filelock.DefaultLockOptions;

public class DefaultUnscopedCacheBuilderFactory
implements UnscopedCacheBuilderFactory {
    private final CacheFactory factory;

    public DefaultUnscopedCacheBuilderFactory(CacheFactory factory) {
        this.factory = factory;
    }

    @Override
    public CacheBuilder cache(File baseDir) {
        return new PersistentCacheBuilder(baseDir);
    }

    private class PersistentCacheBuilder
    implements CacheBuilder {
        final File baseDir;
        Map<String, ?> properties = Collections.emptyMap();
        Action<? super PersistentCache> initializer;
        CacheCleanupStrategy cacheCleanupStrategy;
        LockOptions lockOptions = DefaultLockOptions.mode(FileLockManager.LockMode.Shared);
        String displayName;

        PersistentCacheBuilder(File baseDir) {
            this.baseDir = baseDir;
        }

        @Override
        public CacheBuilder withProperties(Map<String, ?> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public CacheBuilder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public CacheBuilder withInitialLockMode(FileLockManager.LockMode mode) {
            this.lockOptions = DefaultLockOptions.mode(mode);
            return this;
        }

        @Override
        public CacheBuilder withInitializer(Action<? super PersistentCache> initializer) {
            this.initializer = initializer;
            return this;
        }

        @Override
        public CacheBuilder withCleanupStrategy(CacheCleanupStrategy cacheCleanupStrategy) {
            this.cacheCleanupStrategy = cacheCleanupStrategy;
            return this;
        }

        @Override
        public PersistentCache open() {
            return DefaultUnscopedCacheBuilderFactory.this.factory.open(this.baseDir, this.displayName, this.properties, this.lockOptions, this.initializer, this.cacheCleanupStrategy);
        }
    }
}

