//========================================================================
//
// NameToUnicodeTable.h
//
// Copyright 2001-2003 Glyph & Cog, LLC
//
//========================================================================

//========================================================================
//
// Modified under the Poppler project - http://poppler.freedesktop.org
//
// All changes made under the Poppler project to this file are licensed
// under GPL version 2 or later
//
// Copyright (C) 2011, 2012, 2020, 2025 Albert Astals Cid <aacid@kde.org>
// Copyright (C) 2013 Jason Crain <jason@aquaticape.us>
// Copyright (C) 2022, 2023 Vincent Lefevre <vincent@vinc17.net>
//
// To see a description of the changes please see the Changelog file that
// came with your tarball or type make ChangeLog if you are building from git
//
//========================================================================

#include "CharTypes.h"

struct NameToUnicodeTab
{
    Unicode u;
    const char *name;
};

// map character names to Unicode
static const struct NameToUnicodeTab nameToUnicodeTextTab[] = { { .u = 0x0021, .name = "!" },
                                                                { .u = 0x0023, .name = "#" },
                                                                { .u = 0x0024, .name = "$" },
                                                                { .u = 0x0025, .name = "%" },
                                                                { .u = 0x0026, .name = "&" },
                                                                { .u = 0x0027, .name = "'" },
                                                                { .u = 0x0028, .name = "(" },
                                                                { .u = 0x0029, .name = ")" },
                                                                { .u = 0x002a, .name = "*" },
                                                                { .u = 0x002b, .name = "+" },
                                                                { .u = 0x002c, .name = "," },
                                                                { .u = 0x002d, .name = "-" },
                                                                { .u = 0x002e, .name = "." },
                                                                { .u = 0x002f, .name = "/" },
                                                                { .u = 0x0030, .name = "0" },
                                                                { .u = 0x0031, .name = "1" },
                                                                { .u = 0x0032, .name = "2" },
                                                                { .u = 0x0033, .name = "3" },
                                                                { .u = 0x0034, .name = "4" },
                                                                { .u = 0x0035, .name = "5" },
                                                                { .u = 0x0036, .name = "6" },
                                                                { .u = 0x0037, .name = "7" },
                                                                { .u = 0x0038, .name = "8" },
                                                                { .u = 0x0039, .name = "9" },
                                                                { .u = 0x003a, .name = ":" },
                                                                { .u = 0x003b, .name = ";" },
                                                                { .u = 0x003c, .name = "<" },
                                                                { .u = 0x003d, .name = "=" },
                                                                { .u = 0x003e, .name = ">" },
                                                                { .u = 0x003f, .name = "?" },
                                                                { .u = 0x0040, .name = "@" },
                                                                { .u = 0x0041, .name = "A" },
                                                                { .u = 0x00c6, .name = "AE" },
                                                                { .u = 0x01fc, .name = "AEacute" },
                                                                { .u = 0x01e2, .name = "AEmacron" },
                                                                { .u = 0xf7e6, .name = "AEsmall" },
                                                                { .u = 0x00c1, .name = "Aacute" },
                                                                { .u = 0xf7e1, .name = "Aacutesmall" },
                                                                { .u = 0x0102, .name = "Abreve" },
                                                                { .u = 0x1eae, .name = "Abreveacute" },
                                                                { .u = 0x04d0, .name = "Abrevecyrillic" },
                                                                { .u = 0x1eb6, .name = "Abrevedotbelow" },
                                                                { .u = 0x1eb0, .name = "Abrevegrave" },
                                                                { .u = 0x1eb2, .name = "Abrevehookabove" },
                                                                { .u = 0x1eb4, .name = "Abrevetilde" },
                                                                { .u = 0x01cd, .name = "Acaron" },
                                                                { .u = 0x24b6, .name = "Acircle" },
                                                                { .u = 0x00c2, .name = "Acircumflex" },
                                                                { .u = 0x1ea4, .name = "Acircumflexacute" },
                                                                { .u = 0x1eac, .name = "Acircumflexdotbelow" },
                                                                { .u = 0x1ea6, .name = "Acircumflexgrave" },
                                                                { .u = 0x1ea8, .name = "Acircumflexhookabove" },
                                                                { .u = 0xf7e2, .name = "Acircumflexsmall" },
                                                                { .u = 0x1eaa, .name = "Acircumflextilde" },
                                                                { .u = 0xf6c9, .name = "Acute" },
                                                                { .u = 0xf7b4, .name = "Acutesmall" },
                                                                { .u = 0x0410, .name = "Acyrillic" },
                                                                { .u = 0x0200, .name = "Adblgrave" },
                                                                { .u = 0x00c4, .name = "Adieresis" },
                                                                { .u = 0x04d2, .name = "Adieresiscyrillic" },
                                                                { .u = 0x01de, .name = "Adieresismacron" },
                                                                { .u = 0xf7e4, .name = "Adieresissmall" },
                                                                { .u = 0x1ea0, .name = "Adotbelow" },
                                                                { .u = 0x01e0, .name = "Adotmacron" },
                                                                { .u = 0x00c0, .name = "Agrave" },
                                                                { .u = 0xf7e0, .name = "Agravesmall" },
                                                                { .u = 0x1ea2, .name = "Ahookabove" },
                                                                { .u = 0x04d4, .name = "Aiecyrillic" },
                                                                { .u = 0x0202, .name = "Ainvertedbreve" },
                                                                { .u = 0x0391, .name = "Alpha" },
                                                                { .u = 0x0386, .name = "Alphatonos" },
                                                                { .u = 0x0100, .name = "Amacron" },
                                                                { .u = 0xff21, .name = "Amonospace" },
                                                                { .u = 0x0104, .name = "Aogonek" },
                                                                { .u = 0x00c5, .name = "Aring" },
                                                                { .u = 0x01fa, .name = "Aringacute" },
                                                                { .u = 0x1e00, .name = "Aringbelow" },
                                                                { .u = 0xf7e5, .name = "Aringsmall" },
                                                                { .u = 0xf761, .name = "Asmall" },
                                                                { .u = 0x00c3, .name = "Atilde" },
                                                                { .u = 0xf7e3, .name = "Atildesmall" },
                                                                { .u = 0x0531, .name = "Aybarmenian" },
                                                                { .u = 0x0042, .name = "B" },
                                                                { .u = 0x24b7, .name = "Bcircle" },
                                                                { .u = 0x1e02, .name = "Bdotaccent" },
                                                                { .u = 0x1e04, .name = "Bdotbelow" },
                                                                { .u = 0x0411, .name = "Becyrillic" },
                                                                { .u = 0x0532, .name = "Benarmenian" },
                                                                { .u = 0x0392, .name = "Beta" },
                                                                { .u = 0x0181, .name = "Bhook" },
                                                                { .u = 0x1e06, .name = "Blinebelow" },
                                                                { .u = 0xff22, .name = "Bmonospace" },
                                                                { .u = 0xf6f4, .name = "Brevesmall" },
                                                                { .u = 0xf762, .name = "Bsmall" },
                                                                { .u = 0x0182, .name = "Btopbar" },
                                                                { .u = 0x0043, .name = "C" },
                                                                { .u = 0x053e, .name = "Caarmenian" },
                                                                { .u = 0x0106, .name = "Cacute" },
                                                                { .u = 0xf6ca, .name = "Caron" },
                                                                { .u = 0xf6f5, .name = "Caronsmall" },
                                                                { .u = 0x010c, .name = "Ccaron" },
                                                                { .u = 0x00c7, .name = "Ccedilla" },
                                                                { .u = 0x1e08, .name = "Ccedillaacute" },
                                                                { .u = 0xf7e7, .name = "Ccedillasmall" },
                                                                { .u = 0x24b8, .name = "Ccircle" },
                                                                { .u = 0x0108, .name = "Ccircumflex" },
                                                                { .u = 0x010a, .name = "Cdot" },
                                                                { .u = 0x010a, .name = "Cdotaccent" },
                                                                { .u = 0xf7b8, .name = "Cedillasmall" },
                                                                { .u = 0x0549, .name = "Chaarmenian" },
                                                                { .u = 0x04bc, .name = "Cheabkhasiancyrillic" },
                                                                { .u = 0x0427, .name = "Checyrillic" },
                                                                { .u = 0x04be, .name = "Chedescenderabkhasiancyrillic" },
                                                                { .u = 0x04b6, .name = "Chedescendercyrillic" },
                                                                { .u = 0x04f4, .name = "Chedieresiscyrillic" },
                                                                { .u = 0x0543, .name = "Cheharmenian" },
                                                                { .u = 0x04cb, .name = "Chekhakassiancyrillic" },
                                                                { .u = 0x04b8, .name = "Cheverticalstrokecyrillic" },
                                                                { .u = 0x03a7, .name = "Chi" },
                                                                { .u = 0x0187, .name = "Chook" },
                                                                { .u = 0xf6f6, .name = "Circumflexsmall" },
                                                                { .u = 0xff23, .name = "Cmonospace" },
                                                                { .u = 0x0551, .name = "Coarmenian" },
                                                                { .u = 0xf763, .name = "Csmall" },
                                                                { .u = 0x0044, .name = "D" },
                                                                { .u = 0x01f1, .name = "DZ" },
                                                                { .u = 0x01c4, .name = "DZcaron" },
                                                                { .u = 0x0534, .name = "Daarmenian" },
                                                                { .u = 0x0189, .name = "Dafrican" },
                                                                { .u = 0x010e, .name = "Dcaron" },
                                                                { .u = 0x1e10, .name = "Dcedilla" },
                                                                { .u = 0x24b9, .name = "Dcircle" },
                                                                { .u = 0x1e12, .name = "Dcircumflexbelow" },
                                                                { .u = 0x0110, .name = "Dcroat" },
                                                                { .u = 0x1e0a, .name = "Ddotaccent" },
                                                                { .u = 0x1e0c, .name = "Ddotbelow" },
                                                                { .u = 0x0414, .name = "Decyrillic" },
                                                                { .u = 0x03ee, .name = "Deicoptic" },
                                                                { .u = 0x2206, .name = "Delta" },
                                                                { .u = 0x0394, .name = "Deltagreek" },
                                                                { .u = 0x018a, .name = "Dhook" },
                                                                { .u = 0xf6cb, .name = "Dieresis" },
                                                                { .u = 0xf6cc, .name = "DieresisAcute" },
                                                                { .u = 0xf6cd, .name = "DieresisGrave" },
                                                                { .u = 0xf7a8, .name = "Dieresissmall" },
                                                                { .u = 0x03dc, .name = "Digammagreek" },
                                                                { .u = 0x0402, .name = "Djecyrillic" },
                                                                { .u = 0x1e0e, .name = "Dlinebelow" },
                                                                { .u = 0xff24, .name = "Dmonospace" },
                                                                { .u = 0xf6f7, .name = "Dotaccentsmall" },
                                                                { .u = 0x0110, .name = "Dslash" },
                                                                { .u = 0xf764, .name = "Dsmall" },
                                                                { .u = 0x018b, .name = "Dtopbar" },
                                                                { .u = 0x01f2, .name = "Dz" },
                                                                { .u = 0x01c5, .name = "Dzcaron" },
                                                                { .u = 0x04e0, .name = "Dzeabkhasiancyrillic" },
                                                                { .u = 0x0405, .name = "Dzecyrillic" },
                                                                { .u = 0x040f, .name = "Dzhecyrillic" },
                                                                { .u = 0x0045, .name = "E" },
                                                                { .u = 0x00c9, .name = "Eacute" },
                                                                { .u = 0xf7e9, .name = "Eacutesmall" },
                                                                { .u = 0x0114, .name = "Ebreve" },
                                                                { .u = 0x011a, .name = "Ecaron" },
                                                                { .u = 0x1e1c, .name = "Ecedillabreve" },
                                                                { .u = 0x0535, .name = "Echarmenian" },
                                                                { .u = 0x24ba, .name = "Ecircle" },
                                                                { .u = 0x00ca, .name = "Ecircumflex" },
                                                                { .u = 0x1ebe, .name = "Ecircumflexacute" },
                                                                { .u = 0x1e18, .name = "Ecircumflexbelow" },
                                                                { .u = 0x1ec6, .name = "Ecircumflexdotbelow" },
                                                                { .u = 0x1ec0, .name = "Ecircumflexgrave" },
                                                                { .u = 0x1ec2, .name = "Ecircumflexhookabove" },
                                                                { .u = 0xf7ea, .name = "Ecircumflexsmall" },
                                                                { .u = 0x1ec4, .name = "Ecircumflextilde" },
                                                                { .u = 0x0404, .name = "Ecyrillic" },
                                                                { .u = 0x0204, .name = "Edblgrave" },
                                                                { .u = 0x00cb, .name = "Edieresis" },
                                                                { .u = 0xf7eb, .name = "Edieresissmall" },
                                                                { .u = 0x0116, .name = "Edot" },
                                                                { .u = 0x0116, .name = "Edotaccent" },
                                                                { .u = 0x1eb8, .name = "Edotbelow" },
                                                                { .u = 0x0424, .name = "Efcyrillic" },
                                                                { .u = 0x00c8, .name = "Egrave" },
                                                                { .u = 0xf7e8, .name = "Egravesmall" },
                                                                { .u = 0x0537, .name = "Eharmenian" },
                                                                { .u = 0x1eba, .name = "Ehookabove" },
                                                                { .u = 0x2167, .name = "Eightroman" },
                                                                { .u = 0x0206, .name = "Einvertedbreve" },
                                                                { .u = 0x0464, .name = "Eiotifiedcyrillic" },
                                                                { .u = 0x041b, .name = "Elcyrillic" },
                                                                { .u = 0x216a, .name = "Elevenroman" },
                                                                { .u = 0x0112, .name = "Emacron" },
                                                                { .u = 0x1e16, .name = "Emacronacute" },
                                                                { .u = 0x1e14, .name = "Emacrongrave" },
                                                                { .u = 0x041c, .name = "Emcyrillic" },
                                                                { .u = 0xff25, .name = "Emonospace" },
                                                                { .u = 0x041d, .name = "Encyrillic" },
                                                                { .u = 0x04a2, .name = "Endescendercyrillic" },
                                                                { .u = 0x014a, .name = "Eng" },
                                                                { .u = 0x04a4, .name = "Enghecyrillic" },
                                                                { .u = 0x04c7, .name = "Enhookcyrillic" },
                                                                { .u = 0x0118, .name = "Eogonek" },
                                                                { .u = 0x0190, .name = "Eopen" },
                                                                { .u = 0x0395, .name = "Epsilon" },
                                                                { .u = 0x0388, .name = "Epsilontonos" },
                                                                { .u = 0x0420, .name = "Ercyrillic" },
                                                                { .u = 0x018e, .name = "Ereversed" },
                                                                { .u = 0x042d, .name = "Ereversedcyrillic" },
                                                                { .u = 0x0421, .name = "Escyrillic" },
                                                                { .u = 0x04aa, .name = "Esdescendercyrillic" },
                                                                { .u = 0x01a9, .name = "Esh" },
                                                                { .u = 0xf765, .name = "Esmall" },
                                                                { .u = 0x0397, .name = "Eta" },
                                                                { .u = 0x0538, .name = "Etarmenian" },
                                                                { .u = 0x0389, .name = "Etatonos" },
                                                                { .u = 0x00d0, .name = "Eth" },
                                                                { .u = 0xf7f0, .name = "Ethsmall" },
                                                                { .u = 0x1ebc, .name = "Etilde" },
                                                                { .u = 0x1e1a, .name = "Etildebelow" },
                                                                { .u = 0x20ac, .name = "Euro" },
                                                                { .u = 0x01b7, .name = "Ezh" },
                                                                { .u = 0x01ee, .name = "Ezhcaron" },
                                                                { .u = 0x01b8, .name = "Ezhreversed" },
                                                                { .u = 0x0046, .name = "F" },
                                                                { .u = 0x24bb, .name = "Fcircle" },
                                                                { .u = 0x1e1e, .name = "Fdotaccent" },
                                                                { .u = 0x0556, .name = "Feharmenian" },
                                                                { .u = 0x03e4, .name = "Feicoptic" },
                                                                { .u = 0x0191, .name = "Fhook" },
                                                                { .u = 0x0472, .name = "Fitacyrillic" },
                                                                { .u = 0x2164, .name = "Fiveroman" },
                                                                { .u = 0xff26, .name = "Fmonospace" },
                                                                { .u = 0x2163, .name = "Fourroman" },
                                                                { .u = 0xf766, .name = "Fsmall" },
                                                                { .u = 0x0047, .name = "G" },
                                                                { .u = 0x3387, .name = "GBsquare" },
                                                                { .u = 0x01f4, .name = "Gacute" },
                                                                { .u = 0x0393, .name = "Gamma" },
                                                                { .u = 0x0194, .name = "Gammaafrican" },
                                                                { .u = 0x03ea, .name = "Gangiacoptic" },
                                                                { .u = 0x011e, .name = "Gbreve" },
                                                                { .u = 0x01e6, .name = "Gcaron" },
                                                                { .u = 0x0122, .name = "Gcedilla" },
                                                                { .u = 0x24bc, .name = "Gcircle" },
                                                                { .u = 0x011c, .name = "Gcircumflex" },
                                                                { .u = 0x0122, .name = "Gcommaaccent" },
                                                                { .u = 0x0120, .name = "Gdot" },
                                                                { .u = 0x0120, .name = "Gdotaccent" },
                                                                { .u = 0x0413, .name = "Gecyrillic" },
                                                                { .u = 0x0542, .name = "Ghadarmenian" },
                                                                { .u = 0x0494, .name = "Ghemiddlehookcyrillic" },
                                                                { .u = 0x0492, .name = "Ghestrokecyrillic" },
                                                                { .u = 0x0490, .name = "Gheupturncyrillic" },
                                                                { .u = 0x0193, .name = "Ghook" },
                                                                { .u = 0x0533, .name = "Gimarmenian" },
                                                                { .u = 0x0403, .name = "Gjecyrillic" },
                                                                { .u = 0x1e20, .name = "Gmacron" },
                                                                { .u = 0xff27, .name = "Gmonospace" },
                                                                { .u = 0xf6ce, .name = "Grave" },
                                                                { .u = 0xf760, .name = "Gravesmall" },
                                                                { .u = 0xf767, .name = "Gsmall" },
                                                                { .u = 0x029b, .name = "Gsmallhook" },
                                                                { .u = 0x01e4, .name = "Gstroke" },
                                                                { .u = 0x0048, .name = "H" },
                                                                { .u = 0x25cf, .name = "H18533" },
                                                                { .u = 0x25aa, .name = "H18543" },
                                                                { .u = 0x25ab, .name = "H18551" },
                                                                { .u = 0x25a1, .name = "H22073" },
                                                                { .u = 0x33cb, .name = "HPsquare" },
                                                                { .u = 0x04a8, .name = "Haabkhasiancyrillic" },
                                                                { .u = 0x04b2, .name = "Hadescendercyrillic" },
                                                                { .u = 0x042a, .name = "Hardsigncyrillic" },
                                                                { .u = 0x0126, .name = "Hbar" },
                                                                { .u = 0x1e2a, .name = "Hbrevebelow" },
                                                                { .u = 0x1e28, .name = "Hcedilla" },
                                                                { .u = 0x24bd, .name = "Hcircle" },
                                                                { .u = 0x0124, .name = "Hcircumflex" },
                                                                { .u = 0x1e26, .name = "Hdieresis" },
                                                                { .u = 0x1e22, .name = "Hdotaccent" },
                                                                { .u = 0x1e24, .name = "Hdotbelow" },
                                                                { .u = 0xff28, .name = "Hmonospace" },
                                                                { .u = 0x0540, .name = "Hoarmenian" },
                                                                { .u = 0x03e8, .name = "Horicoptic" },
                                                                { .u = 0xf768, .name = "Hsmall" },
                                                                { .u = 0xf6cf, .name = "Hungarumlaut" },
                                                                { .u = 0xf6f8, .name = "Hungarumlautsmall" },
                                                                { .u = 0x3390, .name = "Hzsquare" },
                                                                { .u = 0x0049, .name = "I" },
                                                                { .u = 0x042f, .name = "IAcyrillic" },
                                                                { .u = 0x0132, .name = "IJ" },
                                                                { .u = 0x042e, .name = "IUcyrillic" },
                                                                { .u = 0x00cd, .name = "Iacute" },
                                                                { .u = 0xf7ed, .name = "Iacutesmall" },
                                                                { .u = 0x012c, .name = "Ibreve" },
                                                                { .u = 0x01cf, .name = "Icaron" },
                                                                { .u = 0x24be, .name = "Icircle" },
                                                                { .u = 0x00ce, .name = "Icircumflex" },
                                                                { .u = 0xf7ee, .name = "Icircumflexsmall" },
                                                                { .u = 0x0406, .name = "Icyrillic" },
                                                                { .u = 0x0208, .name = "Idblgrave" },
                                                                { .u = 0x00cf, .name = "Idieresis" },
                                                                { .u = 0x1e2e, .name = "Idieresisacute" },
                                                                { .u = 0x04e4, .name = "Idieresiscyrillic" },
                                                                { .u = 0xf7ef, .name = "Idieresissmall" },
                                                                { .u = 0x0130, .name = "Idot" },
                                                                { .u = 0x0130, .name = "Idotaccent" },
                                                                { .u = 0x1eca, .name = "Idotbelow" },
                                                                { .u = 0x04d6, .name = "Iebrevecyrillic" },
                                                                { .u = 0x0415, .name = "Iecyrillic" },
                                                                { .u = 0x2111, .name = "Ifraktur" },
                                                                { .u = 0x00cc, .name = "Igrave" },
                                                                { .u = 0xf7ec, .name = "Igravesmall" },
                                                                { .u = 0x1ec8, .name = "Ihookabove" },
                                                                { .u = 0x0418, .name = "Iicyrillic" },
                                                                { .u = 0x020a, .name = "Iinvertedbreve" },
                                                                { .u = 0x0419, .name = "Iishortcyrillic" },
                                                                { .u = 0x012a, .name = "Imacron" },
                                                                { .u = 0x04e2, .name = "Imacroncyrillic" },
                                                                { .u = 0xff29, .name = "Imonospace" },
                                                                { .u = 0x053b, .name = "Iniarmenian" },
                                                                { .u = 0x0401, .name = "Iocyrillic" },
                                                                { .u = 0x012e, .name = "Iogonek" },
                                                                { .u = 0x0399, .name = "Iota" },
                                                                { .u = 0x0196, .name = "Iotaafrican" },
                                                                { .u = 0x03aa, .name = "Iotadieresis" },
                                                                { .u = 0x038a, .name = "Iotatonos" },
                                                                { .u = 0xf769, .name = "Ismall" },
                                                                { .u = 0x0197, .name = "Istroke" },
                                                                { .u = 0x0128, .name = "Itilde" },
                                                                { .u = 0x1e2c, .name = "Itildebelow" },
                                                                { .u = 0x0474, .name = "Izhitsacyrillic" },
                                                                { .u = 0x0476, .name = "Izhitsadblgravecyrillic" },
                                                                { .u = 0x004a, .name = "J" },
                                                                { .u = 0x0541, .name = "Jaarmenian" },
                                                                { .u = 0x24bf, .name = "Jcircle" },
                                                                { .u = 0x0134, .name = "Jcircumflex" },
                                                                { .u = 0x0408, .name = "Jecyrillic" },
                                                                { .u = 0x054b, .name = "Jheharmenian" },
                                                                { .u = 0xff2a, .name = "Jmonospace" },
                                                                { .u = 0xf76a, .name = "Jsmall" },
                                                                { .u = 0x004b, .name = "K" },
                                                                { .u = 0x3385, .name = "KBsquare" },
                                                                { .u = 0x33cd, .name = "KKsquare" },
                                                                { .u = 0x04a0, .name = "Kabashkircyrillic" },
                                                                { .u = 0x1e30, .name = "Kacute" },
                                                                { .u = 0x041a, .name = "Kacyrillic" },
                                                                { .u = 0x049a, .name = "Kadescendercyrillic" },
                                                                { .u = 0x04c3, .name = "Kahookcyrillic" },
                                                                { .u = 0x039a, .name = "Kappa" },
                                                                { .u = 0x049e, .name = "Kastrokecyrillic" },
                                                                { .u = 0x049c, .name = "Kaverticalstrokecyrillic" },
                                                                { .u = 0x01e8, .name = "Kcaron" },
                                                                { .u = 0x0136, .name = "Kcedilla" },
                                                                { .u = 0x24c0, .name = "Kcircle" },
                                                                { .u = 0x0136, .name = "Kcommaaccent" },
                                                                { .u = 0x1e32, .name = "Kdotbelow" },
                                                                { .u = 0x0554, .name = "Keharmenian" },
                                                                { .u = 0x053f, .name = "Kenarmenian" },
                                                                { .u = 0x0425, .name = "Khacyrillic" },
                                                                { .u = 0x03e6, .name = "Kheicoptic" },
                                                                { .u = 0x0198, .name = "Khook" },
                                                                { .u = 0x040c, .name = "Kjecyrillic" },
                                                                { .u = 0x1e34, .name = "Klinebelow" },
                                                                { .u = 0xff2b, .name = "Kmonospace" },
                                                                { .u = 0x0480, .name = "Koppacyrillic" },
                                                                { .u = 0x03de, .name = "Koppagreek" },
                                                                { .u = 0x046e, .name = "Ksicyrillic" },
                                                                { .u = 0xf76b, .name = "Ksmall" },
                                                                { .u = 0x004c, .name = "L" },
                                                                { .u = 0x01c7, .name = "LJ" },
                                                                { .u = 0xf6bf, .name = "LL" },
                                                                { .u = 0x0139, .name = "Lacute" },
                                                                { .u = 0x039b, .name = "Lambda" },
                                                                { .u = 0x013d, .name = "Lcaron" },
                                                                { .u = 0x013b, .name = "Lcedilla" },
                                                                { .u = 0x24c1, .name = "Lcircle" },
                                                                { .u = 0x1e3c, .name = "Lcircumflexbelow" },
                                                                { .u = 0x013b, .name = "Lcommaaccent" },
                                                                { .u = 0x013f, .name = "Ldot" },
                                                                { .u = 0x013f, .name = "Ldotaccent" },
                                                                { .u = 0x1e36, .name = "Ldotbelow" },
                                                                { .u = 0x1e38, .name = "Ldotbelowmacron" },
                                                                { .u = 0x053c, .name = "Liwnarmenian" },
                                                                { .u = 0x01c8, .name = "Lj" },
                                                                { .u = 0x0409, .name = "Ljecyrillic" },
                                                                { .u = 0x1e3a, .name = "Llinebelow" },
                                                                { .u = 0xff2c, .name = "Lmonospace" },
                                                                { .u = 0x0141, .name = "Lslash" },
                                                                { .u = 0xf6f9, .name = "Lslashsmall" },
                                                                { .u = 0xf76c, .name = "Lsmall" },
                                                                { .u = 0x004d, .name = "M" },
                                                                { .u = 0x3386, .name = "MBsquare" },
                                                                { .u = 0xf6d0, .name = "Macron" },
                                                                { .u = 0xf7af, .name = "Macronsmall" },
                                                                { .u = 0x1e3e, .name = "Macute" },
                                                                { .u = 0x24c2, .name = "Mcircle" },
                                                                { .u = 0x1e40, .name = "Mdotaccent" },
                                                                { .u = 0x1e42, .name = "Mdotbelow" },
                                                                { .u = 0x0544, .name = "Menarmenian" },
                                                                { .u = 0xff2d, .name = "Mmonospace" },
                                                                { .u = 0xf76d, .name = "Msmall" },
                                                                { .u = 0x019c, .name = "Mturned" },
                                                                { .u = 0x039c, .name = "Mu" },
                                                                { .u = 0x004e, .name = "N" },
                                                                { .u = 0x01ca, .name = "NJ" },
                                                                { .u = 0x0143, .name = "Nacute" },
                                                                { .u = 0x0147, .name = "Ncaron" },
                                                                { .u = 0x0145, .name = "Ncedilla" },
                                                                { .u = 0x24c3, .name = "Ncircle" },
                                                                { .u = 0x1e4a, .name = "Ncircumflexbelow" },
                                                                { .u = 0x0145, .name = "Ncommaaccent" },
                                                                { .u = 0x1e44, .name = "Ndotaccent" },
                                                                { .u = 0x1e46, .name = "Ndotbelow" },
                                                                { .u = 0x019d, .name = "Nhookleft" },
                                                                { .u = 0x2168, .name = "Nineroman" },
                                                                { .u = 0x01cb, .name = "Nj" },
                                                                { .u = 0x040a, .name = "Njecyrillic" },
                                                                { .u = 0x1e48, .name = "Nlinebelow" },
                                                                { .u = 0xff2e, .name = "Nmonospace" },
                                                                { .u = 0x0546, .name = "Nowarmenian" },
                                                                { .u = 0xf76e, .name = "Nsmall" },
                                                                { .u = 0x00d1, .name = "Ntilde" },
                                                                { .u = 0xf7f1, .name = "Ntildesmall" },
                                                                { .u = 0x039d, .name = "Nu" },
                                                                { .u = 0x004f, .name = "O" },
                                                                { .u = 0x0152, .name = "OE" },
                                                                { .u = 0xf6fa, .name = "OEsmall" },
                                                                { .u = 0x00d3, .name = "Oacute" },
                                                                { .u = 0xf7f3, .name = "Oacutesmall" },
                                                                { .u = 0x04e8, .name = "Obarredcyrillic" },
                                                                { .u = 0x04ea, .name = "Obarreddieresiscyrillic" },
                                                                { .u = 0x014e, .name = "Obreve" },
                                                                { .u = 0x01d1, .name = "Ocaron" },
                                                                { .u = 0x019f, .name = "Ocenteredtilde" },
                                                                { .u = 0x24c4, .name = "Ocircle" },
                                                                { .u = 0x00d4, .name = "Ocircumflex" },
                                                                { .u = 0x1ed0, .name = "Ocircumflexacute" },
                                                                { .u = 0x1ed8, .name = "Ocircumflexdotbelow" },
                                                                { .u = 0x1ed2, .name = "Ocircumflexgrave" },
                                                                { .u = 0x1ed4, .name = "Ocircumflexhookabove" },
                                                                { .u = 0xf7f4, .name = "Ocircumflexsmall" },
                                                                { .u = 0x1ed6, .name = "Ocircumflextilde" },
                                                                { .u = 0x041e, .name = "Ocyrillic" },
                                                                { .u = 0x0150, .name = "Odblacute" },
                                                                { .u = 0x020c, .name = "Odblgrave" },
                                                                { .u = 0x00d6, .name = "Odieresis" },
                                                                { .u = 0x04e6, .name = "Odieresiscyrillic" },
                                                                { .u = 0xf7f6, .name = "Odieresissmall" },
                                                                { .u = 0x1ecc, .name = "Odotbelow" },
                                                                { .u = 0xf6fb, .name = "Ogoneksmall" },
                                                                { .u = 0x00d2, .name = "Ograve" },
                                                                { .u = 0xf7f2, .name = "Ogravesmall" },
                                                                { .u = 0x0555, .name = "Oharmenian" },
                                                                { .u = 0x2126, .name = "Ohm" },
                                                                { .u = 0x1ece, .name = "Ohookabove" },
                                                                { .u = 0x01a0, .name = "Ohorn" },
                                                                { .u = 0x1eda, .name = "Ohornacute" },
                                                                { .u = 0x1ee2, .name = "Ohorndotbelow" },
                                                                { .u = 0x1edc, .name = "Ohorngrave" },
                                                                { .u = 0x1ede, .name = "Ohornhookabove" },
                                                                { .u = 0x1ee0, .name = "Ohorntilde" },
                                                                { .u = 0x0150, .name = "Ohungarumlaut" },
                                                                { .u = 0x01a2, .name = "Oi" },
                                                                { .u = 0x020e, .name = "Oinvertedbreve" },
                                                                { .u = 0x014c, .name = "Omacron" },
                                                                { .u = 0x1e52, .name = "Omacronacute" },
                                                                { .u = 0x1e50, .name = "Omacrongrave" },
                                                                { .u = 0x2126, .name = "Omega" },
                                                                { .u = 0x0460, .name = "Omegacyrillic" },
                                                                { .u = 0x03a9, .name = "Omegagreek" },
                                                                { .u = 0x047a, .name = "Omegaroundcyrillic" },
                                                                { .u = 0x047c, .name = "Omegatitlocyrillic" },
                                                                { .u = 0x038f, .name = "Omegatonos" },
                                                                { .u = 0x039f, .name = "Omicron" },
                                                                { .u = 0x038c, .name = "Omicrontonos" },
                                                                { .u = 0xff2f, .name = "Omonospace" },
                                                                { .u = 0x2160, .name = "Oneroman" },
                                                                { .u = 0x01ea, .name = "Oogonek" },
                                                                { .u = 0x01ec, .name = "Oogonekmacron" },
                                                                { .u = 0x0186, .name = "Oopen" },
                                                                { .u = 0x00d8, .name = "Oslash" },
                                                                { .u = 0x01fe, .name = "Oslashacute" },
                                                                { .u = 0xf7f8, .name = "Oslashsmall" },
                                                                { .u = 0xf76f, .name = "Osmall" },
                                                                { .u = 0x01fe, .name = "Ostrokeacute" },
                                                                { .u = 0x047e, .name = "Otcyrillic" },
                                                                { .u = 0x00d5, .name = "Otilde" },
                                                                { .u = 0x1e4c, .name = "Otildeacute" },
                                                                { .u = 0x1e4e, .name = "Otildedieresis" },
                                                                { .u = 0xf7f5, .name = "Otildesmall" },
                                                                { .u = 0x0050, .name = "P" },
                                                                { .u = 0x1e54, .name = "Pacute" },
                                                                { .u = 0x24c5, .name = "Pcircle" },
                                                                { .u = 0x1e56, .name = "Pdotaccent" },
                                                                { .u = 0x041f, .name = "Pecyrillic" },
                                                                { .u = 0x054a, .name = "Peharmenian" },
                                                                { .u = 0x04a6, .name = "Pemiddlehookcyrillic" },
                                                                { .u = 0x03a6, .name = "Phi" },
                                                                { .u = 0x01a4, .name = "Phook" },
                                                                { .u = 0x03a0, .name = "Pi" },
                                                                { .u = 0x0553, .name = "Piwrarmenian" },
                                                                { .u = 0xff30, .name = "Pmonospace" },
                                                                { .u = 0x03a8, .name = "Psi" },
                                                                { .u = 0x0470, .name = "Psicyrillic" },
                                                                { .u = 0xf770, .name = "Psmall" },
                                                                { .u = 0x0051, .name = "Q" },
                                                                { .u = 0x24c6, .name = "Qcircle" },
                                                                { .u = 0xff31, .name = "Qmonospace" },
                                                                { .u = 0xf771, .name = "Qsmall" },
                                                                { .u = 0x0052, .name = "R" },
                                                                { .u = 0x054c, .name = "Raarmenian" },
                                                                { .u = 0x0154, .name = "Racute" },
                                                                { .u = 0x0158, .name = "Rcaron" },
                                                                { .u = 0x0156, .name = "Rcedilla" },
                                                                { .u = 0x24c7, .name = "Rcircle" },
                                                                { .u = 0x0156, .name = "Rcommaaccent" },
                                                                { .u = 0x0210, .name = "Rdblgrave" },
                                                                { .u = 0x1e58, .name = "Rdotaccent" },
                                                                { .u = 0x1e5a, .name = "Rdotbelow" },
                                                                { .u = 0x1e5c, .name = "Rdotbelowmacron" },
                                                                { .u = 0x0550, .name = "Reharmenian" },
                                                                { .u = 0x211c, .name = "Rfraktur" },
                                                                { .u = 0x03a1, .name = "Rho" },
                                                                { .u = 0xf6fc, .name = "Ringsmall" },
                                                                { .u = 0x0212, .name = "Rinvertedbreve" },
                                                                { .u = 0x1e5e, .name = "Rlinebelow" },
                                                                { .u = 0xff32, .name = "Rmonospace" },
                                                                { .u = 0xf772, .name = "Rsmall" },
                                                                { .u = 0x0281, .name = "Rsmallinverted" },
                                                                { .u = 0x02b6, .name = "Rsmallinvertedsuperior" },
                                                                { .u = 0x0053, .name = "S" },
                                                                { .u = 0x250c, .name = "SF010000" },
                                                                { .u = 0x2514, .name = "SF020000" },
                                                                { .u = 0x2510, .name = "SF030000" },
                                                                { .u = 0x2518, .name = "SF040000" },
                                                                { .u = 0x253c, .name = "SF050000" },
                                                                { .u = 0x252c, .name = "SF060000" },
                                                                { .u = 0x2534, .name = "SF070000" },
                                                                { .u = 0x251c, .name = "SF080000" },
                                                                { .u = 0x2524, .name = "SF090000" },
                                                                { .u = 0x2500, .name = "SF100000" },
                                                                { .u = 0x2502, .name = "SF110000" },
                                                                { .u = 0x2561, .name = "SF190000" },
                                                                { .u = 0x2562, .name = "SF200000" },
                                                                { .u = 0x2556, .name = "SF210000" },
                                                                { .u = 0x2555, .name = "SF220000" },
                                                                { .u = 0x2563, .name = "SF230000" },
                                                                { .u = 0x2551, .name = "SF240000" },
                                                                { .u = 0x2557, .name = "SF250000" },
                                                                { .u = 0x255d, .name = "SF260000" },
                                                                { .u = 0x255c, .name = "SF270000" },
                                                                { .u = 0x255b, .name = "SF280000" },
                                                                { .u = 0x255e, .name = "SF360000" },
                                                                { .u = 0x255f, .name = "SF370000" },
                                                                { .u = 0x255a, .name = "SF380000" },
                                                                { .u = 0x2554, .name = "SF390000" },
                                                                { .u = 0x2569, .name = "SF400000" },
                                                                { .u = 0x2566, .name = "SF410000" },
                                                                { .u = 0x2560, .name = "SF420000" },
                                                                { .u = 0x2550, .name = "SF430000" },
                                                                { .u = 0x256c, .name = "SF440000" },
                                                                { .u = 0x2567, .name = "SF450000" },
                                                                { .u = 0x2568, .name = "SF460000" },
                                                                { .u = 0x2564, .name = "SF470000" },
                                                                { .u = 0x2565, .name = "SF480000" },
                                                                { .u = 0x2559, .name = "SF490000" },
                                                                { .u = 0x2558, .name = "SF500000" },
                                                                { .u = 0x2552, .name = "SF510000" },
                                                                { .u = 0x2553, .name = "SF520000" },
                                                                { .u = 0x256b, .name = "SF530000" },
                                                                { .u = 0x256a, .name = "SF540000" },
                                                                { .u = 0x015a, .name = "Sacute" },
                                                                { .u = 0x1e64, .name = "Sacutedotaccent" },
                                                                { .u = 0x03e0, .name = "Sampigreek" },
                                                                { .u = 0x0160, .name = "Scaron" },
                                                                { .u = 0x1e66, .name = "Scarondotaccent" },
                                                                { .u = 0xf6fd, .name = "Scaronsmall" },
                                                                { .u = 0x015e, .name = "Scedilla" },
                                                                { .u = 0x018f, .name = "Schwa" },
                                                                { .u = 0x04d8, .name = "Schwacyrillic" },
                                                                { .u = 0x04da, .name = "Schwadieresiscyrillic" },
                                                                { .u = 0x24c8, .name = "Scircle" },
                                                                { .u = 0x015c, .name = "Scircumflex" },
                                                                { .u = 0x0218, .name = "Scommaaccent" },
                                                                { .u = 0x1e60, .name = "Sdotaccent" },
                                                                { .u = 0x1e62, .name = "Sdotbelow" },
                                                                { .u = 0x1e68, .name = "Sdotbelowdotaccent" },
                                                                { .u = 0x054d, .name = "Seharmenian" },
                                                                { .u = 0x2166, .name = "Sevenroman" },
                                                                { .u = 0x0547, .name = "Shaarmenian" },
                                                                { .u = 0x0428, .name = "Shacyrillic" },
                                                                { .u = 0x0429, .name = "Shchacyrillic" },
                                                                { .u = 0x03e2, .name = "Sheicoptic" },
                                                                { .u = 0x04ba, .name = "Shhacyrillic" },
                                                                { .u = 0x03ec, .name = "Shimacoptic" },
                                                                { .u = 0x03a3, .name = "Sigma" },
                                                                { .u = 0x2165, .name = "Sixroman" },
                                                                { .u = 0xff33, .name = "Smonospace" },
                                                                { .u = 0x042c, .name = "Softsigncyrillic" },
                                                                { .u = 0xf773, .name = "Ssmall" },
                                                                { .u = 0x03da, .name = "Stigmagreek" },
                                                                { .u = 0x0054, .name = "T" },
                                                                { .u = 0x03a4, .name = "Tau" },
                                                                { .u = 0x0166, .name = "Tbar" },
                                                                { .u = 0x0164, .name = "Tcaron" },
                                                                { .u = 0x0162, .name = "Tcedilla" },
                                                                { .u = 0x24c9, .name = "Tcircle" },
                                                                { .u = 0x1e70, .name = "Tcircumflexbelow" },
                                                                { .u = 0x0162, .name = "Tcommaaccent" },
                                                                { .u = 0x1e6a, .name = "Tdotaccent" },
                                                                { .u = 0x1e6c, .name = "Tdotbelow" },
                                                                { .u = 0x0422, .name = "Tecyrillic" },
                                                                { .u = 0x04ac, .name = "Tedescendercyrillic" },
                                                                { .u = 0x2169, .name = "Tenroman" },
                                                                { .u = 0x04b4, .name = "Tetsecyrillic" },
                                                                { .u = 0x0398, .name = "Theta" },
                                                                { .u = 0x01ac, .name = "Thook" },
                                                                { .u = 0x00de, .name = "Thorn" },
                                                                { .u = 0xf7fe, .name = "Thornsmall" },
                                                                { .u = 0x2162, .name = "Threeroman" },
                                                                { .u = 0xf6fe, .name = "Tildesmall" },
                                                                { .u = 0x054f, .name = "Tiwnarmenian" },
                                                                { .u = 0x1e6e, .name = "Tlinebelow" },
                                                                { .u = 0xff34, .name = "Tmonospace" },
                                                                { .u = 0x0539, .name = "Toarmenian" },
                                                                { .u = 0x01bc, .name = "Tonefive" },
                                                                { .u = 0x0184, .name = "Tonesix" },
                                                                { .u = 0x01a7, .name = "Tonetwo" },
                                                                { .u = 0x01ae, .name = "Tretroflexhook" },
                                                                { .u = 0x0426, .name = "Tsecyrillic" },
                                                                { .u = 0x040b, .name = "Tshecyrillic" },
                                                                { .u = 0xf774, .name = "Tsmall" },
                                                                { .u = 0x216b, .name = "Twelveroman" },
                                                                { .u = 0x2161, .name = "Tworoman" },
                                                                { .u = 0x0055, .name = "U" },
                                                                { .u = 0x00da, .name = "Uacute" },
                                                                { .u = 0xf7fa, .name = "Uacutesmall" },
                                                                { .u = 0x016c, .name = "Ubreve" },
                                                                { .u = 0x01d3, .name = "Ucaron" },
                                                                { .u = 0x24ca, .name = "Ucircle" },
                                                                { .u = 0x00db, .name = "Ucircumflex" },
                                                                { .u = 0x1e76, .name = "Ucircumflexbelow" },
                                                                { .u = 0xf7fb, .name = "Ucircumflexsmall" },
                                                                { .u = 0x0423, .name = "Ucyrillic" },
                                                                { .u = 0x0170, .name = "Udblacute" },
                                                                { .u = 0x0214, .name = "Udblgrave" },
                                                                { .u = 0x00dc, .name = "Udieresis" },
                                                                { .u = 0x01d7, .name = "Udieresisacute" },
                                                                { .u = 0x1e72, .name = "Udieresisbelow" },
                                                                { .u = 0x01d9, .name = "Udieresiscaron" },
                                                                { .u = 0x04f0, .name = "Udieresiscyrillic" },
                                                                { .u = 0x01db, .name = "Udieresisgrave" },
                                                                { .u = 0x01d5, .name = "Udieresismacron" },
                                                                { .u = 0xf7fc, .name = "Udieresissmall" },
                                                                { .u = 0x1ee4, .name = "Udotbelow" },
                                                                { .u = 0x00d9, .name = "Ugrave" },
                                                                { .u = 0xf7f9, .name = "Ugravesmall" },
                                                                { .u = 0x1ee6, .name = "Uhookabove" },
                                                                { .u = 0x01af, .name = "Uhorn" },
                                                                { .u = 0x1ee8, .name = "Uhornacute" },
                                                                { .u = 0x1ef0, .name = "Uhorndotbelow" },
                                                                { .u = 0x1eea, .name = "Uhorngrave" },
                                                                { .u = 0x1eec, .name = "Uhornhookabove" },
                                                                { .u = 0x1eee, .name = "Uhorntilde" },
                                                                { .u = 0x0170, .name = "Uhungarumlaut" },
                                                                { .u = 0x04f2, .name = "Uhungarumlautcyrillic" },
                                                                { .u = 0x0216, .name = "Uinvertedbreve" },
                                                                { .u = 0x0478, .name = "Ukcyrillic" },
                                                                { .u = 0x016a, .name = "Umacron" },
                                                                { .u = 0x04ee, .name = "Umacroncyrillic" },
                                                                { .u = 0x1e7a, .name = "Umacrondieresis" },
                                                                { .u = 0xff35, .name = "Umonospace" },
                                                                { .u = 0x0172, .name = "Uogonek" },
                                                                { .u = 0x03a5, .name = "Upsilon" },
                                                                { .u = 0x03d2, .name = "Upsilon1" },
                                                                { .u = 0x03d3, .name = "Upsilonacutehooksymbolgreek" },
                                                                { .u = 0x01b1, .name = "Upsilonafrican" },
                                                                { .u = 0x03ab, .name = "Upsilondieresis" },
                                                                { .u = 0x03d4, .name = "Upsilondieresishooksymbolgreek" },
                                                                { .u = 0x03d2, .name = "Upsilonhooksymbol" },
                                                                { .u = 0x038e, .name = "Upsilontonos" },
                                                                { .u = 0x016e, .name = "Uring" },
                                                                { .u = 0x040e, .name = "Ushortcyrillic" },
                                                                { .u = 0xf775, .name = "Usmall" },
                                                                { .u = 0x04ae, .name = "Ustraightcyrillic" },
                                                                { .u = 0x04b0, .name = "Ustraightstrokecyrillic" },
                                                                { .u = 0x0168, .name = "Utilde" },
                                                                { .u = 0x1e78, .name = "Utildeacute" },
                                                                { .u = 0x1e74, .name = "Utildebelow" },
                                                                { .u = 0x0056, .name = "V" },
                                                                { .u = 0x24cb, .name = "Vcircle" },
                                                                { .u = 0x1e7e, .name = "Vdotbelow" },
                                                                { .u = 0x0412, .name = "Vecyrillic" },
                                                                { .u = 0x054e, .name = "Vewarmenian" },
                                                                { .u = 0x01b2, .name = "Vhook" },
                                                                { .u = 0xff36, .name = "Vmonospace" },
                                                                { .u = 0x0548, .name = "Voarmenian" },
                                                                { .u = 0xf776, .name = "Vsmall" },
                                                                { .u = 0x1e7c, .name = "Vtilde" },
                                                                { .u = 0x0057, .name = "W" },
                                                                { .u = 0x1e82, .name = "Wacute" },
                                                                { .u = 0x24cc, .name = "Wcircle" },
                                                                { .u = 0x0174, .name = "Wcircumflex" },
                                                                { .u = 0x1e84, .name = "Wdieresis" },
                                                                { .u = 0x1e86, .name = "Wdotaccent" },
                                                                { .u = 0x1e88, .name = "Wdotbelow" },
                                                                { .u = 0x1e80, .name = "Wgrave" },
                                                                { .u = 0xff37, .name = "Wmonospace" },
                                                                { .u = 0xf777, .name = "Wsmall" },
                                                                { .u = 0x0058, .name = "X" },
                                                                { .u = 0x24cd, .name = "Xcircle" },
                                                                { .u = 0x1e8c, .name = "Xdieresis" },
                                                                { .u = 0x1e8a, .name = "Xdotaccent" },
                                                                { .u = 0x053d, .name = "Xeharmenian" },
                                                                { .u = 0x039e, .name = "Xi" },
                                                                { .u = 0xff38, .name = "Xmonospace" },
                                                                { .u = 0xf778, .name = "Xsmall" },
                                                                { .u = 0x0059, .name = "Y" },
                                                                { .u = 0x00dd, .name = "Yacute" },
                                                                { .u = 0xf7fd, .name = "Yacutesmall" },
                                                                { .u = 0x0462, .name = "Yatcyrillic" },
                                                                { .u = 0x24ce, .name = "Ycircle" },
                                                                { .u = 0x0176, .name = "Ycircumflex" },
                                                                { .u = 0x0178, .name = "Ydieresis" },
                                                                { .u = 0xf7ff, .name = "Ydieresissmall" },
                                                                { .u = 0x1e8e, .name = "Ydotaccent" },
                                                                { .u = 0x1ef4, .name = "Ydotbelow" },
                                                                { .u = 0x042b, .name = "Yericyrillic" },
                                                                { .u = 0x04f8, .name = "Yerudieresiscyrillic" },
                                                                { .u = 0x1ef2, .name = "Ygrave" },
                                                                { .u = 0x01b3, .name = "Yhook" },
                                                                { .u = 0x1ef6, .name = "Yhookabove" },
                                                                { .u = 0x0545, .name = "Yiarmenian" },
                                                                { .u = 0x0407, .name = "Yicyrillic" },
                                                                { .u = 0x0552, .name = "Yiwnarmenian" },
                                                                { .u = 0xff39, .name = "Ymonospace" },
                                                                { .u = 0xf779, .name = "Ysmall" },
                                                                { .u = 0x1ef8, .name = "Ytilde" },
                                                                { .u = 0x046a, .name = "Yusbigcyrillic" },
                                                                { .u = 0x046c, .name = "Yusbigiotifiedcyrillic" },
                                                                { .u = 0x0466, .name = "Yuslittlecyrillic" },
                                                                { .u = 0x0468, .name = "Yuslittleiotifiedcyrillic" },
                                                                { .u = 0x005a, .name = "Z" },
                                                                { .u = 0x0536, .name = "Zaarmenian" },
                                                                { .u = 0x0179, .name = "Zacute" },
                                                                { .u = 0x017d, .name = "Zcaron" },
                                                                { .u = 0xf6ff, .name = "Zcaronsmall" },
                                                                { .u = 0x24cf, .name = "Zcircle" },
                                                                { .u = 0x1e90, .name = "Zcircumflex" },
                                                                { .u = 0x017b, .name = "Zdot" },
                                                                { .u = 0x017b, .name = "Zdotaccent" },
                                                                { .u = 0x1e92, .name = "Zdotbelow" },
                                                                { .u = 0x0417, .name = "Zecyrillic" },
                                                                { .u = 0x0498, .name = "Zedescendercyrillic" },
                                                                { .u = 0x04de, .name = "Zedieresiscyrillic" },
                                                                { .u = 0x0396, .name = "Zeta" },
                                                                { .u = 0x053a, .name = "Zhearmenian" },
                                                                { .u = 0x04c1, .name = "Zhebrevecyrillic" },
                                                                { .u = 0x0416, .name = "Zhecyrillic" },
                                                                { .u = 0x0496, .name = "Zhedescendercyrillic" },
                                                                { .u = 0x04dc, .name = "Zhedieresiscyrillic" },
                                                                { .u = 0x1e94, .name = "Zlinebelow" },
                                                                { .u = 0xff3a, .name = "Zmonospace" },
                                                                { .u = 0xf77a, .name = "Zsmall" },
                                                                { .u = 0x01b5, .name = "Zstroke" },
                                                                { .u = 0x0022, .name = "\"" },
                                                                { .u = 0x005c, .name = "\\" },
                                                                { .u = 0x005d, .name = "]" },
                                                                { .u = 0x005e, .name = "^" },
                                                                { .u = 0x005f, .name = "_" },
                                                                { .u = 0x0060, .name = "`" },
                                                                { .u = 0x0061, .name = "a" },
                                                                { .u = 0x0986, .name = "aabengali" },
                                                                { .u = 0x00e1, .name = "aacute" },
                                                                { .u = 0x0906, .name = "aadeva" },
                                                                { .u = 0x0a86, .name = "aagujarati" },
                                                                { .u = 0x0a06, .name = "aagurmukhi" },
                                                                { .u = 0x0a3e, .name = "aamatragurmukhi" },
                                                                { .u = 0x3303, .name = "aarusquare" },
                                                                { .u = 0x09be, .name = "aavowelsignbengali" },
                                                                { .u = 0x093e, .name = "aavowelsigndeva" },
                                                                { .u = 0x0abe, .name = "aavowelsigngujarati" },
                                                                { .u = 0x055f, .name = "abbreviationmarkarmenian" },
                                                                { .u = 0x0970, .name = "abbreviationsigndeva" },
                                                                { .u = 0x0985, .name = "abengali" },
                                                                { .u = 0x311a, .name = "abopomofo" },
                                                                { .u = 0x0103, .name = "abreve" },
                                                                { .u = 0x1eaf, .name = "abreveacute" },
                                                                { .u = 0x04d1, .name = "abrevecyrillic" },
                                                                { .u = 0x1eb7, .name = "abrevedotbelow" },
                                                                { .u = 0x1eb1, .name = "abrevegrave" },
                                                                { .u = 0x1eb3, .name = "abrevehookabove" },
                                                                { .u = 0x1eb5, .name = "abrevetilde" },
                                                                { .u = 0x01ce, .name = "acaron" },
                                                                { .u = 0x24d0, .name = "acircle" },
                                                                { .u = 0x00e2, .name = "acircumflex" },
                                                                { .u = 0x1ea5, .name = "acircumflexacute" },
                                                                { .u = 0x1ead, .name = "acircumflexdotbelow" },
                                                                { .u = 0x1ea7, .name = "acircumflexgrave" },
                                                                { .u = 0x1ea9, .name = "acircumflexhookabove" },
                                                                { .u = 0x1eab, .name = "acircumflextilde" },
                                                                { .u = 0x00b4, .name = "acute" },
                                                                { .u = 0x0317, .name = "acutebelowcmb" },
                                                                { .u = 0x0301, .name = "acutecmb" },
                                                                { .u = 0x0301, .name = "acutecomb" },
                                                                { .u = 0x0954, .name = "acutedeva" },
                                                                { .u = 0x02cf, .name = "acutelowmod" },
                                                                { .u = 0x0341, .name = "acutetonecmb" },
                                                                { .u = 0x0430, .name = "acyrillic" },
                                                                { .u = 0x0201, .name = "adblgrave" },
                                                                { .u = 0x0a71, .name = "addakgurmukhi" },
                                                                { .u = 0x0905, .name = "adeva" },
                                                                { .u = 0x00e4, .name = "adieresis" },
                                                                { .u = 0x04d3, .name = "adieresiscyrillic" },
                                                                { .u = 0x01df, .name = "adieresismacron" },
                                                                { .u = 0x1ea1, .name = "adotbelow" },
                                                                { .u = 0x01e1, .name = "adotmacron" },
                                                                { .u = 0x00e6, .name = "ae" },
                                                                { .u = 0x01fd, .name = "aeacute" },
                                                                { .u = 0x3150, .name = "aekorean" },
                                                                { .u = 0x01e3, .name = "aemacron" },
                                                                { .u = 0x2015, .name = "afii00208" },
                                                                { .u = 0x20a4, .name = "afii08941" },
                                                                { .u = 0x0410, .name = "afii10017" },
                                                                { .u = 0x0411, .name = "afii10018" },
                                                                { .u = 0x0412, .name = "afii10019" },
                                                                { .u = 0x0413, .name = "afii10020" },
                                                                { .u = 0x0414, .name = "afii10021" },
                                                                { .u = 0x0415, .name = "afii10022" },
                                                                { .u = 0x0401, .name = "afii10023" },
                                                                { .u = 0x0416, .name = "afii10024" },
                                                                { .u = 0x0417, .name = "afii10025" },
                                                                { .u = 0x0418, .name = "afii10026" },
                                                                { .u = 0x0419, .name = "afii10027" },
                                                                { .u = 0x041a, .name = "afii10028" },
                                                                { .u = 0x041b, .name = "afii10029" },
                                                                { .u = 0x041c, .name = "afii10030" },
                                                                { .u = 0x041d, .name = "afii10031" },
                                                                { .u = 0x041e, .name = "afii10032" },
                                                                { .u = 0x041f, .name = "afii10033" },
                                                                { .u = 0x0420, .name = "afii10034" },
                                                                { .u = 0x0421, .name = "afii10035" },
                                                                { .u = 0x0422, .name = "afii10036" },
                                                                { .u = 0x0423, .name = "afii10037" },
                                                                { .u = 0x0424, .name = "afii10038" },
                                                                { .u = 0x0425, .name = "afii10039" },
                                                                { .u = 0x0426, .name = "afii10040" },
                                                                { .u = 0x0427, .name = "afii10041" },
                                                                { .u = 0x0428, .name = "afii10042" },
                                                                { .u = 0x0429, .name = "afii10043" },
                                                                { .u = 0x042a, .name = "afii10044" },
                                                                { .u = 0x042b, .name = "afii10045" },
                                                                { .u = 0x042c, .name = "afii10046" },
                                                                { .u = 0x042d, .name = "afii10047" },
                                                                { .u = 0x042e, .name = "afii10048" },
                                                                { .u = 0x042f, .name = "afii10049" },
                                                                { .u = 0x0490, .name = "afii10050" },
                                                                { .u = 0x0402, .name = "afii10051" },
                                                                { .u = 0x0403, .name = "afii10052" },
                                                                { .u = 0x0404, .name = "afii10053" },
                                                                { .u = 0x0405, .name = "afii10054" },
                                                                { .u = 0x0406, .name = "afii10055" },
                                                                { .u = 0x0407, .name = "afii10056" },
                                                                { .u = 0x0408, .name = "afii10057" },
                                                                { .u = 0x0409, .name = "afii10058" },
                                                                { .u = 0x040a, .name = "afii10059" },
                                                                { .u = 0x040b, .name = "afii10060" },
                                                                { .u = 0x040c, .name = "afii10061" },
                                                                { .u = 0x040e, .name = "afii10062" },
                                                                { .u = 0xf6c4, .name = "afii10063" },
                                                                { .u = 0xf6c5, .name = "afii10064" },
                                                                { .u = 0x0430, .name = "afii10065" },
                                                                { .u = 0x0431, .name = "afii10066" },
                                                                { .u = 0x0432, .name = "afii10067" },
                                                                { .u = 0x0433, .name = "afii10068" },
                                                                { .u = 0x0434, .name = "afii10069" },
                                                                { .u = 0x0435, .name = "afii10070" },
                                                                { .u = 0x0451, .name = "afii10071" },
                                                                { .u = 0x0436, .name = "afii10072" },
                                                                { .u = 0x0437, .name = "afii10073" },
                                                                { .u = 0x0438, .name = "afii10074" },
                                                                { .u = 0x0439, .name = "afii10075" },
                                                                { .u = 0x043a, .name = "afii10076" },
                                                                { .u = 0x043b, .name = "afii10077" },
                                                                { .u = 0x043c, .name = "afii10078" },
                                                                { .u = 0x043d, .name = "afii10079" },
                                                                { .u = 0x043e, .name = "afii10080" },
                                                                { .u = 0x043f, .name = "afii10081" },
                                                                { .u = 0x0440, .name = "afii10082" },
                                                                { .u = 0x0441, .name = "afii10083" },
                                                                { .u = 0x0442, .name = "afii10084" },
                                                                { .u = 0x0443, .name = "afii10085" },
                                                                { .u = 0x0444, .name = "afii10086" },
                                                                { .u = 0x0445, .name = "afii10087" },
                                                                { .u = 0x0446, .name = "afii10088" },
                                                                { .u = 0x0447, .name = "afii10089" },
                                                                { .u = 0x0448, .name = "afii10090" },
                                                                { .u = 0x0449, .name = "afii10091" },
                                                                { .u = 0x044a, .name = "afii10092" },
                                                                { .u = 0x044b, .name = "afii10093" },
                                                                { .u = 0x044c, .name = "afii10094" },
                                                                { .u = 0x044d, .name = "afii10095" },
                                                                { .u = 0x044e, .name = "afii10096" },
                                                                { .u = 0x044f, .name = "afii10097" },
                                                                { .u = 0x0491, .name = "afii10098" },
                                                                { .u = 0x0452, .name = "afii10099" },
                                                                { .u = 0x0453, .name = "afii10100" },
                                                                { .u = 0x0454, .name = "afii10101" },
                                                                { .u = 0x0455, .name = "afii10102" },
                                                                { .u = 0x0456, .name = "afii10103" },
                                                                { .u = 0x0457, .name = "afii10104" },
                                                                { .u = 0x0458, .name = "afii10105" },
                                                                { .u = 0x0459, .name = "afii10106" },
                                                                { .u = 0x045a, .name = "afii10107" },
                                                                { .u = 0x045b, .name = "afii10108" },
                                                                { .u = 0x045c, .name = "afii10109" },
                                                                { .u = 0x045e, .name = "afii10110" },
                                                                { .u = 0x040f, .name = "afii10145" },
                                                                { .u = 0x0462, .name = "afii10146" },
                                                                { .u = 0x0472, .name = "afii10147" },
                                                                { .u = 0x0474, .name = "afii10148" },
                                                                { .u = 0xf6c6, .name = "afii10192" },
                                                                { .u = 0x045f, .name = "afii10193" },
                                                                { .u = 0x0463, .name = "afii10194" },
                                                                { .u = 0x0473, .name = "afii10195" },
                                                                { .u = 0x0475, .name = "afii10196" },
                                                                { .u = 0xf6c7, .name = "afii10831" },
                                                                { .u = 0xf6c8, .name = "afii10832" },
                                                                { .u = 0x04d9, .name = "afii10846" },
                                                                { .u = 0x200e, .name = "afii299" },
                                                                { .u = 0x200f, .name = "afii300" },
                                                                { .u = 0x200d, .name = "afii301" },
                                                                { .u = 0x066a, .name = "afii57381" },
                                                                { .u = 0x060c, .name = "afii57388" },
                                                                { .u = 0x0660, .name = "afii57392" },
                                                                { .u = 0x0661, .name = "afii57393" },
                                                                { .u = 0x0662, .name = "afii57394" },
                                                                { .u = 0x0663, .name = "afii57395" },
                                                                { .u = 0x0664, .name = "afii57396" },
                                                                { .u = 0x0665, .name = "afii57397" },
                                                                { .u = 0x0666, .name = "afii57398" },
                                                                { .u = 0x0667, .name = "afii57399" },
                                                                { .u = 0x0668, .name = "afii57400" },
                                                                { .u = 0x0669, .name = "afii57401" },
                                                                { .u = 0x061b, .name = "afii57403" },
                                                                { .u = 0x061f, .name = "afii57407" },
                                                                { .u = 0x0621, .name = "afii57409" },
                                                                { .u = 0x0622, .name = "afii57410" },
                                                                { .u = 0x0623, .name = "afii57411" },
                                                                { .u = 0x0624, .name = "afii57412" },
                                                                { .u = 0x0625, .name = "afii57413" },
                                                                { .u = 0x0626, .name = "afii57414" },
                                                                { .u = 0x0627, .name = "afii57415" },
                                                                { .u = 0x0628, .name = "afii57416" },
                                                                { .u = 0x0629, .name = "afii57417" },
                                                                { .u = 0x062a, .name = "afii57418" },
                                                                { .u = 0x062b, .name = "afii57419" },
                                                                { .u = 0x062c, .name = "afii57420" },
                                                                { .u = 0x062d, .name = "afii57421" },
                                                                { .u = 0x062e, .name = "afii57422" },
                                                                { .u = 0x062f, .name = "afii57423" },
                                                                { .u = 0x0630, .name = "afii57424" },
                                                                { .u = 0x0631, .name = "afii57425" },
                                                                { .u = 0x0632, .name = "afii57426" },
                                                                { .u = 0x0633, .name = "afii57427" },
                                                                { .u = 0x0634, .name = "afii57428" },
                                                                { .u = 0x0635, .name = "afii57429" },
                                                                { .u = 0x0636, .name = "afii57430" },
                                                                { .u = 0x0637, .name = "afii57431" },
                                                                { .u = 0x0638, .name = "afii57432" },
                                                                { .u = 0x0639, .name = "afii57433" },
                                                                { .u = 0x063a, .name = "afii57434" },
                                                                { .u = 0x0640, .name = "afii57440" },
                                                                { .u = 0x0641, .name = "afii57441" },
                                                                { .u = 0x0642, .name = "afii57442" },
                                                                { .u = 0x0643, .name = "afii57443" },
                                                                { .u = 0x0644, .name = "afii57444" },
                                                                { .u = 0x0645, .name = "afii57445" },
                                                                { .u = 0x0646, .name = "afii57446" },
                                                                { .u = 0x0648, .name = "afii57448" },
                                                                { .u = 0x0649, .name = "afii57449" },
                                                                { .u = 0x064a, .name = "afii57450" },
                                                                { .u = 0x064b, .name = "afii57451" },
                                                                { .u = 0x064c, .name = "afii57452" },
                                                                { .u = 0x064d, .name = "afii57453" },
                                                                { .u = 0x064e, .name = "afii57454" },
                                                                { .u = 0x064f, .name = "afii57455" },
                                                                { .u = 0x0650, .name = "afii57456" },
                                                                { .u = 0x0651, .name = "afii57457" },
                                                                { .u = 0x0652, .name = "afii57458" },
                                                                { .u = 0x0647, .name = "afii57470" },
                                                                { .u = 0x06a4, .name = "afii57505" },
                                                                { .u = 0x067e, .name = "afii57506" },
                                                                { .u = 0x0686, .name = "afii57507" },
                                                                { .u = 0x0698, .name = "afii57508" },
                                                                { .u = 0x06af, .name = "afii57509" },
                                                                { .u = 0x0679, .name = "afii57511" },
                                                                { .u = 0x0688, .name = "afii57512" },
                                                                { .u = 0x0691, .name = "afii57513" },
                                                                { .u = 0x06ba, .name = "afii57514" },
                                                                { .u = 0x06d2, .name = "afii57519" },
                                                                { .u = 0x06d5, .name = "afii57534" },
                                                                { .u = 0x20aa, .name = "afii57636" },
                                                                { .u = 0x05be, .name = "afii57645" },
                                                                { .u = 0x05c3, .name = "afii57658" },
                                                                { .u = 0x05d0, .name = "afii57664" },
                                                                { .u = 0x05d1, .name = "afii57665" },
                                                                { .u = 0x05d2, .name = "afii57666" },
                                                                { .u = 0x05d3, .name = "afii57667" },
                                                                { .u = 0x05d4, .name = "afii57668" },
                                                                { .u = 0x05d5, .name = "afii57669" },
                                                                { .u = 0x05d6, .name = "afii57670" },
                                                                { .u = 0x05d7, .name = "afii57671" },
                                                                { .u = 0x05d8, .name = "afii57672" },
                                                                { .u = 0x05d9, .name = "afii57673" },
                                                                { .u = 0x05da, .name = "afii57674" },
                                                                { .u = 0x05db, .name = "afii57675" },
                                                                { .u = 0x05dc, .name = "afii57676" },
                                                                { .u = 0x05dd, .name = "afii57677" },
                                                                { .u = 0x05de, .name = "afii57678" },
                                                                { .u = 0x05df, .name = "afii57679" },
                                                                { .u = 0x05e0, .name = "afii57680" },
                                                                { .u = 0x05e1, .name = "afii57681" },
                                                                { .u = 0x05e2, .name = "afii57682" },
                                                                { .u = 0x05e3, .name = "afii57683" },
                                                                { .u = 0x05e4, .name = "afii57684" },
                                                                { .u = 0x05e5, .name = "afii57685" },
                                                                { .u = 0x05e6, .name = "afii57686" },
                                                                { .u = 0x05e7, .name = "afii57687" },
                                                                { .u = 0x05e8, .name = "afii57688" },
                                                                { .u = 0x05e9, .name = "afii57689" },
                                                                { .u = 0x05ea, .name = "afii57690" },
                                                                { .u = 0xfb2a, .name = "afii57694" },
                                                                { .u = 0xfb2b, .name = "afii57695" },
                                                                { .u = 0xfb4b, .name = "afii57700" },
                                                                { .u = 0xfb1f, .name = "afii57705" },
                                                                { .u = 0x05f0, .name = "afii57716" },
                                                                { .u = 0x05f1, .name = "afii57717" },
                                                                { .u = 0x05f2, .name = "afii57718" },
                                                                { .u = 0xfb35, .name = "afii57723" },
                                                                { .u = 0x05b4, .name = "afii57793" },
                                                                { .u = 0x05b5, .name = "afii57794" },
                                                                { .u = 0x05b6, .name = "afii57795" },
                                                                { .u = 0x05bb, .name = "afii57796" },
                                                                { .u = 0x05b8, .name = "afii57797" },
                                                                { .u = 0x05b7, .name = "afii57798" },
                                                                { .u = 0x05b0, .name = "afii57799" },
                                                                { .u = 0x05b2, .name = "afii57800" },
                                                                { .u = 0x05b1, .name = "afii57801" },
                                                                { .u = 0x05b3, .name = "afii57802" },
                                                                { .u = 0x05c2, .name = "afii57803" },
                                                                { .u = 0x05c1, .name = "afii57804" },
                                                                { .u = 0x05b9, .name = "afii57806" },
                                                                { .u = 0x05bc, .name = "afii57807" },
                                                                { .u = 0x05bd, .name = "afii57839" },
                                                                { .u = 0x05bf, .name = "afii57841" },
                                                                { .u = 0x05c0, .name = "afii57842" },
                                                                { .u = 0x02bc, .name = "afii57929" },
                                                                { .u = 0x2105, .name = "afii61248" },
                                                                { .u = 0x2113, .name = "afii61289" },
                                                                { .u = 0x2116, .name = "afii61352" },
                                                                { .u = 0x202c, .name = "afii61573" },
                                                                { .u = 0x202d, .name = "afii61574" },
                                                                { .u = 0x202e, .name = "afii61575" },
                                                                { .u = 0x200c, .name = "afii61664" },
                                                                { .u = 0x066d, .name = "afii63167" },
                                                                { .u = 0x02bd, .name = "afii64937" },
                                                                { .u = 0x00e0, .name = "agrave" },
                                                                { .u = 0x0a85, .name = "agujarati" },
                                                                { .u = 0x0a05, .name = "agurmukhi" },
                                                                { .u = 0x3042, .name = "ahiragana" },
                                                                { .u = 0x1ea3, .name = "ahookabove" },
                                                                { .u = 0x0990, .name = "aibengali" },
                                                                { .u = 0x311e, .name = "aibopomofo" },
                                                                { .u = 0x0910, .name = "aideva" },
                                                                { .u = 0x04d5, .name = "aiecyrillic" },
                                                                { .u = 0x0a90, .name = "aigujarati" },
                                                                { .u = 0x0a10, .name = "aigurmukhi" },
                                                                { .u = 0x0a48, .name = "aimatragurmukhi" },
                                                                { .u = 0x0639, .name = "ainarabic" },
                                                                { .u = 0xfeca, .name = "ainfinalarabic" },
                                                                { .u = 0xfecb, .name = "aininitialarabic" },
                                                                { .u = 0xfecc, .name = "ainmedialarabic" },
                                                                { .u = 0x0203, .name = "ainvertedbreve" },
                                                                { .u = 0x09c8, .name = "aivowelsignbengali" },
                                                                { .u = 0x0948, .name = "aivowelsigndeva" },
                                                                { .u = 0x0ac8, .name = "aivowelsigngujarati" },
                                                                { .u = 0x30a2, .name = "akatakana" },
                                                                { .u = 0xff71, .name = "akatakanahalfwidth" },
                                                                { .u = 0x314f, .name = "akorean" },
                                                                { .u = 0x05d0, .name = "alef" },
                                                                { .u = 0x0627, .name = "alefarabic" },
                                                                { .u = 0xfb30, .name = "alefdageshhebrew" },
                                                                { .u = 0xfe8e, .name = "aleffinalarabic" },
                                                                { .u = 0x0623, .name = "alefhamzaabovearabic" },
                                                                { .u = 0xfe84, .name = "alefhamzaabovefinalarabic" },
                                                                { .u = 0x0625, .name = "alefhamzabelowarabic" },
                                                                { .u = 0xfe88, .name = "alefhamzabelowfinalarabic" },
                                                                { .u = 0x05d0, .name = "alefhebrew" },
                                                                { .u = 0xfb4f, .name = "aleflamedhebrew" },
                                                                { .u = 0x0622, .name = "alefmaddaabovearabic" },
                                                                { .u = 0xfe82, .name = "alefmaddaabovefinalarabic" },
                                                                { .u = 0x0649, .name = "alefmaksuraarabic" },
                                                                { .u = 0xfef0, .name = "alefmaksurafinalarabic" },
                                                                { .u = 0xfef3, .name = "alefmaksurainitialarabic" },
                                                                { .u = 0xfef4, .name = "alefmaksuramedialarabic" },
                                                                { .u = 0xfb2e, .name = "alefpatahhebrew" },
                                                                { .u = 0xfb2f, .name = "alefqamatshebrew" },
                                                                { .u = 0x2135, .name = "aleph" },
                                                                { .u = 0x224c, .name = "allequal" },
                                                                { .u = 0x03b1, .name = "alpha" },
                                                                { .u = 0x03ac, .name = "alphatonos" },
                                                                { .u = 0x0101, .name = "amacron" },
                                                                { .u = 0xff41, .name = "amonospace" },
                                                                { .u = 0x0026, .name = "ampersand" },
                                                                { .u = 0xff06, .name = "ampersandmonospace" },
                                                                { .u = 0xf726, .name = "ampersandsmall" },
                                                                { .u = 0x33c2, .name = "amsquare" },
                                                                { .u = 0x3122, .name = "anbopomofo" },
                                                                { .u = 0x3124, .name = "angbopomofo" },
                                                                { .u = 0x0e5a, .name = "angkhankhuthai" },
                                                                { .u = 0x2220, .name = "angle" },
                                                                { .u = 0x3008, .name = "anglebracketleft" },
                                                                { .u = 0xfe3f, .name = "anglebracketleftvertical" },
                                                                { .u = 0x3009, .name = "anglebracketright" },
                                                                { .u = 0xfe40, .name = "anglebracketrightvertical" },
                                                                { .u = 0x2329, .name = "angleleft" },
                                                                { .u = 0x232a, .name = "angleright" },
                                                                { .u = 0x212b, .name = "angstrom" },
                                                                { .u = 0x0387, .name = "anoteleia" },
                                                                { .u = 0x0952, .name = "anudattadeva" },
                                                                { .u = 0x0982, .name = "anusvarabengali" },
                                                                { .u = 0x0902, .name = "anusvaradeva" },
                                                                { .u = 0x0a82, .name = "anusvaragujarati" },
                                                                { .u = 0x0105, .name = "aogonek" },
                                                                { .u = 0x3300, .name = "apaatosquare" },
                                                                { .u = 0x249c, .name = "aparen" },
                                                                { .u = 0x055a, .name = "apostrophearmenian" },
                                                                { .u = 0x02bc, .name = "apostrophemod" },
                                                                { .u = 0xf8ff, .name = "apple" },
                                                                { .u = 0x2250, .name = "approaches" },
                                                                { .u = 0x2248, .name = "approxequal" },
                                                                { .u = 0x2252, .name = "approxequalorimage" },
                                                                { .u = 0x2245, .name = "approximatelyequal" },
                                                                { .u = 0x318e, .name = "araeaekorean" },
                                                                { .u = 0x318d, .name = "araeakorean" },
                                                                { .u = 0x2312, .name = "arc" },
                                                                { .u = 0x1e9a, .name = "arighthalfring" },
                                                                { .u = 0x00e5, .name = "aring" },
                                                                { .u = 0x01fb, .name = "aringacute" },
                                                                { .u = 0x1e01, .name = "aringbelow" },
                                                                { .u = 0x2194, .name = "arrowboth" },
                                                                { .u = 0x21e3, .name = "arrowdashdown" },
                                                                { .u = 0x21e0, .name = "arrowdashleft" },
                                                                { .u = 0x21e2, .name = "arrowdashright" },
                                                                { .u = 0x21e1, .name = "arrowdashup" },
                                                                { .u = 0x21d4, .name = "arrowdblboth" },
                                                                { .u = 0x21d3, .name = "arrowdbldown" },
                                                                { .u = 0x21d0, .name = "arrowdblleft" },
                                                                { .u = 0x21d2, .name = "arrowdblright" },
                                                                { .u = 0x21d1, .name = "arrowdblup" },
                                                                { .u = 0x2193, .name = "arrowdown" },
                                                                { .u = 0x2199, .name = "arrowdownleft" },
                                                                { .u = 0x2198, .name = "arrowdownright" },
                                                                { .u = 0x21e9, .name = "arrowdownwhite" },
                                                                { .u = 0x02c5, .name = "arrowheaddownmod" },
                                                                { .u = 0x02c2, .name = "arrowheadleftmod" },
                                                                { .u = 0x02c3, .name = "arrowheadrightmod" },
                                                                { .u = 0x02c4, .name = "arrowheadupmod" },
                                                                { .u = 0xf8e7, .name = "arrowhorizex" },
                                                                { .u = 0x2190, .name = "arrowleft" },
                                                                { .u = 0x21d0, .name = "arrowleftdbl" },
                                                                { .u = 0x21cd, .name = "arrowleftdblstroke" },
                                                                { .u = 0x21c6, .name = "arrowleftoverright" },
                                                                { .u = 0x21e6, .name = "arrowleftwhite" },
                                                                { .u = 0x2192, .name = "arrowright" },
                                                                { .u = 0x21cf, .name = "arrowrightdblstroke" },
                                                                { .u = 0x279e, .name = "arrowrightheavy" },
                                                                { .u = 0x21c4, .name = "arrowrightoverleft" },
                                                                { .u = 0x21e8, .name = "arrowrightwhite" },
                                                                { .u = 0x21e4, .name = "arrowtableft" },
                                                                { .u = 0x21e5, .name = "arrowtabright" },
                                                                { .u = 0x2191, .name = "arrowup" },
                                                                { .u = 0x2195, .name = "arrowupdn" },
                                                                { .u = 0x21a8, .name = "arrowupdnbse" },
                                                                { .u = 0x21a8, .name = "arrowupdownbase" },
                                                                { .u = 0x2196, .name = "arrowupleft" },
                                                                { .u = 0x21c5, .name = "arrowupleftofdown" },
                                                                { .u = 0x2197, .name = "arrowupright" },
                                                                { .u = 0x21e7, .name = "arrowupwhite" },
                                                                { .u = 0xf8e6, .name = "arrowvertex" },
                                                                { .u = 0x005e, .name = "asciicircum" },
                                                                { .u = 0xff3e, .name = "asciicircummonospace" },
                                                                { .u = 0x007e, .name = "asciitilde" },
                                                                { .u = 0xff5e, .name = "asciitildemonospace" },
                                                                { .u = 0x0251, .name = "ascript" },
                                                                { .u = 0x0252, .name = "ascriptturned" },
                                                                { .u = 0x3041, .name = "asmallhiragana" },
                                                                { .u = 0x30a1, .name = "asmallkatakana" },
                                                                { .u = 0xff67, .name = "asmallkatakanahalfwidth" },
                                                                { .u = 0x002a, .name = "asterisk" },
                                                                { .u = 0x066d, .name = "asteriskaltonearabic" },
                                                                { .u = 0x066d, .name = "asteriskarabic" },
                                                                { .u = 0x2217, .name = "asteriskmath" },
                                                                { .u = 0xff0a, .name = "asteriskmonospace" },
                                                                { .u = 0xfe61, .name = "asterisksmall" },
                                                                { .u = 0x2042, .name = "asterism" },
                                                                { .u = 0xf6e9, .name = "asuperior" },
                                                                { .u = 0x2243, .name = "asymptoticallyequal" },
                                                                { .u = 0x0040, .name = "at" },
                                                                { .u = 0x00e3, .name = "atilde" },
                                                                { .u = 0xff20, .name = "atmonospace" },
                                                                { .u = 0xfe6b, .name = "atsmall" },
                                                                { .u = 0x0250, .name = "aturned" },
                                                                { .u = 0x0994, .name = "aubengali" },
                                                                { .u = 0x3120, .name = "aubopomofo" },
                                                                { .u = 0x0914, .name = "audeva" },
                                                                { .u = 0x0a94, .name = "augujarati" },
                                                                { .u = 0x0a14, .name = "augurmukhi" },
                                                                { .u = 0x09d7, .name = "aulengthmarkbengali" },
                                                                { .u = 0x0a4c, .name = "aumatragurmukhi" },
                                                                { .u = 0x09cc, .name = "auvowelsignbengali" },
                                                                { .u = 0x094c, .name = "auvowelsigndeva" },
                                                                { .u = 0x0acc, .name = "auvowelsigngujarati" },
                                                                { .u = 0x093d, .name = "avagrahadeva" },
                                                                { .u = 0x0561, .name = "aybarmenian" },
                                                                { .u = 0x05e2, .name = "ayin" },
                                                                { .u = 0xfb20, .name = "ayinaltonehebrew" },
                                                                { .u = 0x05e2, .name = "ayinhebrew" },
                                                                { .u = 0x0062, .name = "b" },
                                                                { .u = 0x09ac, .name = "babengali" },
                                                                { .u = 0x005c, .name = "backslash" },
                                                                { .u = 0xff3c, .name = "backslashmonospace" },
                                                                { .u = 0x092c, .name = "badeva" },
                                                                { .u = 0x0aac, .name = "bagujarati" },
                                                                { .u = 0x0a2c, .name = "bagurmukhi" },
                                                                { .u = 0x3070, .name = "bahiragana" },
                                                                { .u = 0x0e3f, .name = "bahtthai" },
                                                                { .u = 0x30d0, .name = "bakatakana" },
                                                                { .u = 0x007c, .name = "bar" },
                                                                { .u = 0xff5c, .name = "barmonospace" },
                                                                { .u = 0x3105, .name = "bbopomofo" },
                                                                { .u = 0x24d1, .name = "bcircle" },
                                                                { .u = 0x1e03, .name = "bdotaccent" },
                                                                { .u = 0x1e05, .name = "bdotbelow" },
                                                                { .u = 0x266c, .name = "beamedsixteenthnotes" },
                                                                { .u = 0x2235, .name = "because" },
                                                                { .u = 0x0431, .name = "becyrillic" },
                                                                { .u = 0x0628, .name = "beharabic" },
                                                                { .u = 0xfe90, .name = "behfinalarabic" },
                                                                { .u = 0xfe91, .name = "behinitialarabic" },
                                                                { .u = 0x3079, .name = "behiragana" },
                                                                { .u = 0xfe92, .name = "behmedialarabic" },
                                                                { .u = 0xfc9f, .name = "behmeeminitialarabic" },
                                                                { .u = 0xfc08, .name = "behmeemisolatedarabic" },
                                                                { .u = 0xfc6d, .name = "behnoonfinalarabic" },
                                                                { .u = 0x30d9, .name = "bekatakana" },
                                                                { .u = 0x0562, .name = "benarmenian" },
                                                                { .u = 0x05d1, .name = "bet" },
                                                                { .u = 0x03b2, .name = "beta" },
                                                                { .u = 0x03d0, .name = "betasymbolgreek" },
                                                                { .u = 0xfb31, .name = "betdagesh" },
                                                                { .u = 0xfb31, .name = "betdageshhebrew" },
                                                                { .u = 0x05d1, .name = "bethebrew" },
                                                                { .u = 0xfb4c, .name = "betrafehebrew" },
                                                                { .u = 0x09ad, .name = "bhabengali" },
                                                                { .u = 0x092d, .name = "bhadeva" },
                                                                { .u = 0x0aad, .name = "bhagujarati" },
                                                                { .u = 0x0a2d, .name = "bhagurmukhi" },
                                                                { .u = 0x0253, .name = "bhook" },
                                                                { .u = 0x3073, .name = "bihiragana" },
                                                                { .u = 0x30d3, .name = "bikatakana" },
                                                                { .u = 0x0298, .name = "bilabialclick" },
                                                                { .u = 0x0a02, .name = "bindigurmukhi" },
                                                                { .u = 0x3331, .name = "birusquare" },
                                                                { .u = 0x25cf, .name = "blackcircle" },
                                                                { .u = 0x25c6, .name = "blackdiamond" },
                                                                { .u = 0x25bc, .name = "blackdownpointingtriangle" },
                                                                { .u = 0x25c4, .name = "blackleftpointingpointer" },
                                                                { .u = 0x25c0, .name = "blackleftpointingtriangle" },
                                                                { .u = 0x3010, .name = "blacklenticularbracketleft" },
                                                                { .u = 0xfe3b, .name = "blacklenticularbracketleftvertical" },
                                                                { .u = 0x3011, .name = "blacklenticularbracketright" },
                                                                { .u = 0xfe3c, .name = "blacklenticularbracketrightvertical" },
                                                                { .u = 0x25e3, .name = "blacklowerlefttriangle" },
                                                                { .u = 0x25e2, .name = "blacklowerrighttriangle" },
                                                                { .u = 0x25ac, .name = "blackrectangle" },
                                                                { .u = 0x25ba, .name = "blackrightpointingpointer" },
                                                                { .u = 0x25b6, .name = "blackrightpointingtriangle" },
                                                                { .u = 0x25aa, .name = "blacksmallsquare" },
                                                                { .u = 0x263b, .name = "blacksmilingface" },
                                                                { .u = 0x25a0, .name = "blacksquare" },
                                                                { .u = 0x2605, .name = "blackstar" },
                                                                { .u = 0x25e4, .name = "blackupperlefttriangle" },
                                                                { .u = 0x25e5, .name = "blackupperrighttriangle" },
                                                                { .u = 0x25b4, .name = "blackuppointingsmalltriangle" },
                                                                { .u = 0x25b2, .name = "blackuppointingtriangle" },
                                                                { .u = 0x2423, .name = "blank" },
                                                                { .u = 0x1e07, .name = "blinebelow" },
                                                                { .u = 0x2588, .name = "block" },
                                                                { .u = 0xff42, .name = "bmonospace" },
                                                                { .u = 0x0e1a, .name = "bobaimaithai" },
                                                                { .u = 0x307c, .name = "bohiragana" },
                                                                { .u = 0x30dc, .name = "bokatakana" },
                                                                { .u = 0x249d, .name = "bparen" },
                                                                { .u = 0x33c3, .name = "bqsquare" },
                                                                { .u = 0xf8f4, .name = "braceex" },
                                                                { .u = 0x007b, .name = "braceleft" },
                                                                { .u = 0xf8f3, .name = "braceleftbt" },
                                                                { .u = 0xf8f2, .name = "braceleftmid" },
                                                                { .u = 0xff5b, .name = "braceleftmonospace" },
                                                                { .u = 0xfe5b, .name = "braceleftsmall" },
                                                                { .u = 0xf8f1, .name = "bracelefttp" },
                                                                { .u = 0xfe37, .name = "braceleftvertical" },
                                                                { .u = 0x007d, .name = "braceright" },
                                                                { .u = 0xf8fe, .name = "bracerightbt" },
                                                                { .u = 0xf8fd, .name = "bracerightmid" },
                                                                { .u = 0xff5d, .name = "bracerightmonospace" },
                                                                { .u = 0xfe5c, .name = "bracerightsmall" },
                                                                { .u = 0xf8fc, .name = "bracerighttp" },
                                                                { .u = 0xfe38, .name = "bracerightvertical" },
                                                                { .u = 0x005b, .name = "bracketleft" },
                                                                { .u = 0xf8f0, .name = "bracketleftbt" },
                                                                { .u = 0xf8ef, .name = "bracketleftex" },
                                                                { .u = 0xff3b, .name = "bracketleftmonospace" },
                                                                { .u = 0xf8ee, .name = "bracketlefttp" },
                                                                { .u = 0x005d, .name = "bracketright" },
                                                                { .u = 0xf8fb, .name = "bracketrightbt" },
                                                                { .u = 0xf8fa, .name = "bracketrightex" },
                                                                { .u = 0xff3d, .name = "bracketrightmonospace" },
                                                                { .u = 0xf8f9, .name = "bracketrighttp" },
                                                                { .u = 0x02d8, .name = "breve" },
                                                                { .u = 0x032e, .name = "brevebelowcmb" },
                                                                { .u = 0x0306, .name = "brevecmb" },
                                                                { .u = 0x032f, .name = "breveinvertedbelowcmb" },
                                                                { .u = 0x0311, .name = "breveinvertedcmb" },
                                                                { .u = 0x0361, .name = "breveinverteddoublecmb" },
                                                                { .u = 0x032a, .name = "bridgebelowcmb" },
                                                                { .u = 0x033a, .name = "bridgeinvertedbelowcmb" },
                                                                { .u = 0x00a6, .name = "brokenbar" },
                                                                { .u = 0x0180, .name = "bstroke" },
                                                                { .u = 0xf6ea, .name = "bsuperior" },
                                                                { .u = 0x0183, .name = "btopbar" },
                                                                { .u = 0x3076, .name = "buhiragana" },
                                                                { .u = 0x30d6, .name = "bukatakana" },
                                                                { .u = 0x2022, .name = "bullet" },
                                                                { .u = 0x25d8, .name = "bulletinverse" },
                                                                { .u = 0x2219, .name = "bulletoperator" },
                                                                { .u = 0x25ce, .name = "bullseye" },
                                                                { .u = 0x0063, .name = "c" },
                                                                { .u = 0x056e, .name = "caarmenian" },
                                                                { .u = 0x099a, .name = "cabengali" },
                                                                { .u = 0x0107, .name = "cacute" },
                                                                { .u = 0x091a, .name = "cadeva" },
                                                                { .u = 0x0a9a, .name = "cagujarati" },
                                                                { .u = 0x0a1a, .name = "cagurmukhi" },
                                                                { .u = 0x3388, .name = "calsquare" },
                                                                { .u = 0x0981, .name = "candrabindubengali" },
                                                                { .u = 0x0310, .name = "candrabinducmb" },
                                                                { .u = 0x0901, .name = "candrabindudeva" },
                                                                { .u = 0x0a81, .name = "candrabindugujarati" },
                                                                { .u = 0x21ea, .name = "capslock" },
                                                                { .u = 0x2105, .name = "careof" },
                                                                { .u = 0x02c7, .name = "caron" },
                                                                { .u = 0x032c, .name = "caronbelowcmb" },
                                                                { .u = 0x030c, .name = "caroncmb" },
                                                                { .u = 0x21b5, .name = "carriagereturn" },
                                                                { .u = 0x3118, .name = "cbopomofo" },
                                                                { .u = 0x010d, .name = "ccaron" },
                                                                { .u = 0x00e7, .name = "ccedilla" },
                                                                { .u = 0x1e09, .name = "ccedillaacute" },
                                                                { .u = 0x24d2, .name = "ccircle" },
                                                                { .u = 0x0109, .name = "ccircumflex" },
                                                                { .u = 0x0255, .name = "ccurl" },
                                                                { .u = 0x010b, .name = "cdot" },
                                                                { .u = 0x010b, .name = "cdotaccent" },
                                                                { .u = 0x33c5, .name = "cdsquare" },
                                                                { .u = 0x00b8, .name = "cedilla" },
                                                                { .u = 0x0327, .name = "cedillacmb" },
                                                                { .u = 0x00a2, .name = "cent" },
                                                                { .u = 0x2103, .name = "centigrade" },
                                                                { .u = 0xf6df, .name = "centinferior" },
                                                                { .u = 0xffe0, .name = "centmonospace" },
                                                                { .u = 0xf7a2, .name = "centoldstyle" },
                                                                { .u = 0xf6e0, .name = "centsuperior" },
                                                                { .u = 0x0579, .name = "chaarmenian" },
                                                                { .u = 0x099b, .name = "chabengali" },
                                                                { .u = 0x091b, .name = "chadeva" },
                                                                { .u = 0x0a9b, .name = "chagujarati" },
                                                                { .u = 0x0a1b, .name = "chagurmukhi" },
                                                                { .u = 0x3114, .name = "chbopomofo" },
                                                                { .u = 0x04bd, .name = "cheabkhasiancyrillic" },
                                                                { .u = 0x2713, .name = "checkmark" },
                                                                { .u = 0x0447, .name = "checyrillic" },
                                                                { .u = 0x04bf, .name = "chedescenderabkhasiancyrillic" },
                                                                { .u = 0x04b7, .name = "chedescendercyrillic" },
                                                                { .u = 0x04f5, .name = "chedieresiscyrillic" },
                                                                { .u = 0x0573, .name = "cheharmenian" },
                                                                { .u = 0x04cc, .name = "chekhakassiancyrillic" },
                                                                { .u = 0x04b9, .name = "cheverticalstrokecyrillic" },
                                                                { .u = 0x03c7, .name = "chi" },
                                                                { .u = 0x3277, .name = "chieuchacirclekorean" },
                                                                { .u = 0x3217, .name = "chieuchaparenkorean" },
                                                                { .u = 0x3269, .name = "chieuchcirclekorean" },
                                                                { .u = 0x314a, .name = "chieuchkorean" },
                                                                { .u = 0x3209, .name = "chieuchparenkorean" },
                                                                { .u = 0x0e0a, .name = "chochangthai" },
                                                                { .u = 0x0e08, .name = "chochanthai" },
                                                                { .u = 0x0e09, .name = "chochingthai" },
                                                                { .u = 0x0e0c, .name = "chochoethai" },
                                                                { .u = 0x0188, .name = "chook" },
                                                                { .u = 0x3276, .name = "cieucacirclekorean" },
                                                                { .u = 0x3216, .name = "cieucaparenkorean" },
                                                                { .u = 0x3268, .name = "cieuccirclekorean" },
                                                                { .u = 0x3148, .name = "cieuckorean" },
                                                                { .u = 0x3208, .name = "cieucparenkorean" },
                                                                { .u = 0x321c, .name = "cieucuparenkorean" },
                                                                { .u = 0x25cb, .name = "circle" },
                                                                { .u = 0x2297, .name = "circlemultiply" },
                                                                { .u = 0x2299, .name = "circleot" },
                                                                { .u = 0x2295, .name = "circleplus" },
                                                                { .u = 0x3036, .name = "circlepostalmark" },
                                                                { .u = 0x25d0, .name = "circlewithlefthalfblack" },
                                                                { .u = 0x25d1, .name = "circlewithrighthalfblack" },
                                                                { .u = 0x02c6, .name = "circumflex" },
                                                                { .u = 0x032d, .name = "circumflexbelowcmb" },
                                                                { .u = 0x0302, .name = "circumflexcmb" },
                                                                { .u = 0x2327, .name = "clear" },
                                                                { .u = 0x01c2, .name = "clickalveolar" },
                                                                { .u = 0x01c0, .name = "clickdental" },
                                                                { .u = 0x01c1, .name = "clicklateral" },
                                                                { .u = 0x01c3, .name = "clickretroflex" },
                                                                { .u = 0x2663, .name = "club" },
                                                                { .u = 0x2663, .name = "clubsuitblack" },
                                                                { .u = 0x2667, .name = "clubsuitwhite" },
                                                                { .u = 0x33a4, .name = "cmcubedsquare" },
                                                                { .u = 0xff43, .name = "cmonospace" },
                                                                { .u = 0x33a0, .name = "cmsquaredsquare" },
                                                                { .u = 0x0581, .name = "coarmenian" },
                                                                { .u = 0x003a, .name = "colon" },
                                                                { .u = 0x20a1, .name = "colonmonetary" },
                                                                { .u = 0xff1a, .name = "colonmonospace" },
                                                                { .u = 0x20a1, .name = "colonsign" },
                                                                { .u = 0xfe55, .name = "colonsmall" },
                                                                { .u = 0x02d1, .name = "colontriangularhalfmod" },
                                                                { .u = 0x02d0, .name = "colontriangularmod" },
                                                                { .u = 0x002c, .name = "comma" },
                                                                { .u = 0x0313, .name = "commaabovecmb" },
                                                                { .u = 0x0315, .name = "commaaboverightcmb" },
                                                                { .u = 0xf6c3, .name = "commaaccent" },
                                                                { .u = 0x060c, .name = "commaarabic" },
                                                                { .u = 0x055d, .name = "commaarmenian" },
                                                                { .u = 0xf6e1, .name = "commainferior" },
                                                                { .u = 0xff0c, .name = "commamonospace" },
                                                                { .u = 0x0314, .name = "commareversedabovecmb" },
                                                                { .u = 0x02bd, .name = "commareversedmod" },
                                                                { .u = 0xfe50, .name = "commasmall" },
                                                                { .u = 0xf6e2, .name = "commasuperior" },
                                                                { .u = 0x0312, .name = "commaturnedabovecmb" },
                                                                { .u = 0x02bb, .name = "commaturnedmod" },
                                                                { .u = 0x263c, .name = "compass" },
                                                                { .u = 0x2245, .name = "congruent" },
                                                                { .u = 0x222e, .name = "contourintegral" },
                                                                { .u = 0x2303, .name = "control" },
                                                                { .u = 0x0006, .name = "controlACK" },
                                                                { .u = 0x0007, .name = "controlBEL" },
                                                                { .u = 0x0008, .name = "controlBS" },
                                                                { .u = 0x0018, .name = "controlCAN" },
                                                                { .u = 0x000d, .name = "controlCR" },
                                                                { .u = 0x0011, .name = "controlDC1" },
                                                                { .u = 0x0012, .name = "controlDC2" },
                                                                { .u = 0x0013, .name = "controlDC3" },
                                                                { .u = 0x0014, .name = "controlDC4" },
                                                                { .u = 0x007f, .name = "controlDEL" },
                                                                { .u = 0x0010, .name = "controlDLE" },
                                                                { .u = 0x0019, .name = "controlEM" },
                                                                { .u = 0x0005, .name = "controlENQ" },
                                                                { .u = 0x0004, .name = "controlEOT" },
                                                                { .u = 0x001b, .name = "controlESC" },
                                                                { .u = 0x0017, .name = "controlETB" },
                                                                { .u = 0x0003, .name = "controlETX" },
                                                                { .u = 0x000c, .name = "controlFF" },
                                                                { .u = 0x001c, .name = "controlFS" },
                                                                { .u = 0x001d, .name = "controlGS" },
                                                                { .u = 0x0009, .name = "controlHT" },
                                                                { .u = 0x000a, .name = "controlLF" },
                                                                { .u = 0x0015, .name = "controlNAK" },
                                                                { .u = 0x001e, .name = "controlRS" },
                                                                { .u = 0x000f, .name = "controlSI" },
                                                                { .u = 0x000e, .name = "controlSO" },
                                                                { .u = 0x0002, .name = "controlSOT" },
                                                                { .u = 0x0001, .name = "controlSTX" },
                                                                { .u = 0x001a, .name = "controlSUB" },
                                                                { .u = 0x0016, .name = "controlSYN" },
                                                                { .u = 0x001f, .name = "controlUS" },
                                                                { .u = 0x000b, .name = "controlVT" },
                                                                { .u = 0x00a9, .name = "copyright" },
                                                                { .u = 0xf8e9, .name = "copyrightsans" },
                                                                { .u = 0xf6d9, .name = "copyrightserif" },
                                                                { .u = 0x300c, .name = "cornerbracketleft" },
                                                                { .u = 0xff62, .name = "cornerbracketlefthalfwidth" },
                                                                { .u = 0xfe41, .name = "cornerbracketleftvertical" },
                                                                { .u = 0x300d, .name = "cornerbracketright" },
                                                                { .u = 0xff63, .name = "cornerbracketrighthalfwidth" },
                                                                { .u = 0xfe42, .name = "cornerbracketrightvertical" },
                                                                { .u = 0x337f, .name = "corporationsquare" },
                                                                { .u = 0x33c7, .name = "cosquare" },
                                                                { .u = 0x33c6, .name = "coverkgsquare" },
                                                                { .u = 0x249e, .name = "cparen" },
                                                                { .u = 0x20a2, .name = "cruzeiro" },
                                                                { .u = 0x0297, .name = "cstretched" },
                                                                { .u = 0x22cf, .name = "curlyand" },
                                                                { .u = 0x22ce, .name = "curlyor" },
                                                                { .u = 0x00a4, .name = "currency" },
                                                                { .u = 0xf6d1, .name = "cyrBreve" },
                                                                { .u = 0xf6d2, .name = "cyrFlex" },
                                                                { .u = 0xf6d4, .name = "cyrbreve" },
                                                                { .u = 0xf6d5, .name = "cyrflex" },
                                                                { .u = 0x0064, .name = "d" },
                                                                { .u = 0x0564, .name = "daarmenian" },
                                                                { .u = 0x09a6, .name = "dabengali" },
                                                                { .u = 0x0636, .name = "dadarabic" },
                                                                { .u = 0x0926, .name = "dadeva" },
                                                                { .u = 0xfebe, .name = "dadfinalarabic" },
                                                                { .u = 0xfebf, .name = "dadinitialarabic" },
                                                                { .u = 0xfec0, .name = "dadmedialarabic" },
                                                                { .u = 0x05bc, .name = "dagesh" },
                                                                { .u = 0x05bc, .name = "dageshhebrew" },
                                                                { .u = 0x2020, .name = "dagger" },
                                                                { .u = 0x2021, .name = "daggerdbl" },
                                                                { .u = 0x0aa6, .name = "dagujarati" },
                                                                { .u = 0x0a26, .name = "dagurmukhi" },
                                                                { .u = 0x3060, .name = "dahiragana" },
                                                                { .u = 0x30c0, .name = "dakatakana" },
                                                                { .u = 0x062f, .name = "dalarabic" },
                                                                { .u = 0x05d3, .name = "dalet" },
                                                                { .u = 0xfb33, .name = "daletdagesh" },
                                                                { .u = 0xfb33, .name = "daletdageshhebrew" },
                                                                { .u = 0x05d3, .name = "dalethebrew" },
                                                                { .u = 0xfeaa, .name = "dalfinalarabic" },
                                                                { .u = 0x064f, .name = "dammaarabic" },
                                                                { .u = 0x064f, .name = "dammalowarabic" },
                                                                { .u = 0x064c, .name = "dammatanaltonearabic" },
                                                                { .u = 0x064c, .name = "dammatanarabic" },
                                                                { .u = 0x0964, .name = "danda" },
                                                                { .u = 0x05a7, .name = "dargahebrew" },
                                                                { .u = 0x05a7, .name = "dargalefthebrew" },
                                                                { .u = 0x0485, .name = "dasiapneumatacyrilliccmb" },
                                                                { .u = 0xf6d3, .name = "dblGrave" },
                                                                { .u = 0x300a, .name = "dblanglebracketleft" },
                                                                { .u = 0xfe3d, .name = "dblanglebracketleftvertical" },
                                                                { .u = 0x300b, .name = "dblanglebracketright" },
                                                                { .u = 0xfe3e, .name = "dblanglebracketrightvertical" },
                                                                { .u = 0x032b, .name = "dblarchinvertedbelowcmb" },
                                                                { .u = 0x21d4, .name = "dblarrowleft" },
                                                                { .u = 0x21d2, .name = "dblarrowright" },
                                                                { .u = 0x0965, .name = "dbldanda" },
                                                                { .u = 0xf6d6, .name = "dblgrave" },
                                                                { .u = 0x030f, .name = "dblgravecmb" },
                                                                { .u = 0x222c, .name = "dblintegral" },
                                                                { .u = 0x2017, .name = "dbllowline" },
                                                                { .u = 0x0333, .name = "dbllowlinecmb" },
                                                                { .u = 0x033f, .name = "dbloverlinecmb" },
                                                                { .u = 0x02ba, .name = "dblprimemod" },
                                                                { .u = 0x2016, .name = "dblverticalbar" },
                                                                { .u = 0x030e, .name = "dblverticallineabovecmb" },
                                                                { .u = 0x3109, .name = "dbopomofo" },
                                                                { .u = 0x33c8, .name = "dbsquare" },
                                                                { .u = 0x010f, .name = "dcaron" },
                                                                { .u = 0x1e11, .name = "dcedilla" },
                                                                { .u = 0x24d3, .name = "dcircle" },
                                                                { .u = 0x1e13, .name = "dcircumflexbelow" },
                                                                { .u = 0x0111, .name = "dcroat" },
                                                                { .u = 0x09a1, .name = "ddabengali" },
                                                                { .u = 0x0921, .name = "ddadeva" },
                                                                { .u = 0x0aa1, .name = "ddagujarati" },
                                                                { .u = 0x0a21, .name = "ddagurmukhi" },
                                                                { .u = 0x0688, .name = "ddalarabic" },
                                                                { .u = 0xfb89, .name = "ddalfinalarabic" },
                                                                { .u = 0x095c, .name = "dddhadeva" },
                                                                { .u = 0x09a2, .name = "ddhabengali" },
                                                                { .u = 0x0922, .name = "ddhadeva" },
                                                                { .u = 0x0aa2, .name = "ddhagujarati" },
                                                                { .u = 0x0a22, .name = "ddhagurmukhi" },
                                                                { .u = 0x1e0b, .name = "ddotaccent" },
                                                                { .u = 0x1e0d, .name = "ddotbelow" },
                                                                { .u = 0x066b, .name = "decimalseparatorarabic" },
                                                                { .u = 0x066b, .name = "decimalseparatorpersian" },
                                                                { .u = 0x0434, .name = "decyrillic" },
                                                                { .u = 0x00b0, .name = "degree" },
                                                                { .u = 0x05ad, .name = "dehihebrew" },
                                                                { .u = 0x3067, .name = "dehiragana" },
                                                                { .u = 0x03ef, .name = "deicoptic" },
                                                                { .u = 0x30c7, .name = "dekatakana" },
                                                                { .u = 0x232b, .name = "deleteleft" },
                                                                { .u = 0x2326, .name = "deleteright" },
                                                                { .u = 0x03b4, .name = "delta" },
                                                                { .u = 0x018d, .name = "deltaturned" },
                                                                { .u = 0x09f8, .name = "denominatorminusonenumeratorbengali" },
                                                                { .u = 0x02a4, .name = "dezh" },
                                                                { .u = 0x09a7, .name = "dhabengali" },
                                                                { .u = 0x0927, .name = "dhadeva" },
                                                                { .u = 0x0aa7, .name = "dhagujarati" },
                                                                { .u = 0x0a27, .name = "dhagurmukhi" },
                                                                { .u = 0x0257, .name = "dhook" },
                                                                { .u = 0x0385, .name = "dialytikatonos" },
                                                                { .u = 0x0344, .name = "dialytikatonoscmb" },
                                                                { .u = 0x2666, .name = "diamond" },
                                                                { .u = 0x2662, .name = "diamondsuitwhite" },
                                                                { .u = 0x00a8, .name = "dieresis" },
                                                                { .u = 0xf6d7, .name = "dieresisacute" },
                                                                { .u = 0x0324, .name = "dieresisbelowcmb" },
                                                                { .u = 0x0308, .name = "dieresiscmb" },
                                                                { .u = 0xf6d8, .name = "dieresisgrave" },
                                                                { .u = 0x0385, .name = "dieresistonos" },
                                                                { .u = 0x3062, .name = "dihiragana" },
                                                                { .u = 0x30c2, .name = "dikatakana" },
                                                                { .u = 0x3003, .name = "dittomark" },
                                                                { .u = 0x00f7, .name = "divide" },
                                                                { .u = 0x2223, .name = "divides" },
                                                                { .u = 0x2215, .name = "divisionslash" },
                                                                { .u = 0x0452, .name = "djecyrillic" },
                                                                { .u = 0x2593, .name = "dkshade" },
                                                                { .u = 0x1e0f, .name = "dlinebelow" },
                                                                { .u = 0x3397, .name = "dlsquare" },
                                                                { .u = 0x0111, .name = "dmacron" },
                                                                { .u = 0xff44, .name = "dmonospace" },
                                                                { .u = 0x2584, .name = "dnblock" },
                                                                { .u = 0x0e0e, .name = "dochadathai" },
                                                                { .u = 0x0e14, .name = "dodekthai" },
                                                                { .u = 0x3069, .name = "dohiragana" },
                                                                { .u = 0x30c9, .name = "dokatakana" },
                                                                { .u = 0x0024, .name = "dollar" },
                                                                { .u = 0xf6e3, .name = "dollarinferior" },
                                                                { .u = 0xff04, .name = "dollarmonospace" },
                                                                { .u = 0xf724, .name = "dollaroldstyle" },
                                                                { .u = 0xfe69, .name = "dollarsmall" },
                                                                { .u = 0xf6e4, .name = "dollarsuperior" },
                                                                { .u = 0x20ab, .name = "dong" },
                                                                { .u = 0x3326, .name = "dorusquare" },
                                                                { .u = 0x02d9, .name = "dotaccent" },
                                                                { .u = 0x0307, .name = "dotaccentcmb" },
                                                                { .u = 0x0323, .name = "dotbelowcmb" },
                                                                { .u = 0x0323, .name = "dotbelowcomb" },
                                                                { .u = 0x30fb, .name = "dotkatakana" },
                                                                { .u = 0x0131, .name = "dotlessi" },
                                                                { .u = 0xf6be, .name = "dotlessj" },
                                                                { .u = 0x0284, .name = "dotlessjstrokehook" },
                                                                { .u = 0x22c5, .name = "dotmath" },
                                                                { .u = 0x25cc, .name = "dottedcircle" },
                                                                { .u = 0xfb1f, .name = "doubleyodpatah" },
                                                                { .u = 0xfb1f, .name = "doubleyodpatahhebrew" },
                                                                { .u = 0x031e, .name = "downtackbelowcmb" },
                                                                { .u = 0x02d5, .name = "downtackmod" },
                                                                { .u = 0x249f, .name = "dparen" },
                                                                { .u = 0xf6eb, .name = "dsuperior" },
                                                                { .u = 0x0256, .name = "dtail" },
                                                                { .u = 0x018c, .name = "dtopbar" },
                                                                { .u = 0x3065, .name = "duhiragana" },
                                                                { .u = 0x30c5, .name = "dukatakana" },
                                                                { .u = 0x01f3, .name = "dz" },
                                                                { .u = 0x02a3, .name = "dzaltone" },
                                                                { .u = 0x01c6, .name = "dzcaron" },
                                                                { .u = 0x02a5, .name = "dzcurl" },
                                                                { .u = 0x04e1, .name = "dzeabkhasiancyrillic" },
                                                                { .u = 0x0455, .name = "dzecyrillic" },
                                                                { .u = 0x045f, .name = "dzhecyrillic" },
                                                                { .u = 0x0065, .name = "e" },
                                                                { .u = 0x00e9, .name = "eacute" },
                                                                { .u = 0x2641, .name = "earth" },
                                                                { .u = 0x098f, .name = "ebengali" },
                                                                { .u = 0x311c, .name = "ebopomofo" },
                                                                { .u = 0x0115, .name = "ebreve" },
                                                                { .u = 0x090d, .name = "ecandradeva" },
                                                                { .u = 0x0a8d, .name = "ecandragujarati" },
                                                                { .u = 0x0945, .name = "ecandravowelsigndeva" },
                                                                { .u = 0x0ac5, .name = "ecandravowelsigngujarati" },
                                                                { .u = 0x011b, .name = "ecaron" },
                                                                { .u = 0x1e1d, .name = "ecedillabreve" },
                                                                { .u = 0x0565, .name = "echarmenian" },
                                                                { .u = 0x0587, .name = "echyiwnarmenian" },
                                                                { .u = 0x24d4, .name = "ecircle" },
                                                                { .u = 0x00ea, .name = "ecircumflex" },
                                                                { .u = 0x1ebf, .name = "ecircumflexacute" },
                                                                { .u = 0x1e19, .name = "ecircumflexbelow" },
                                                                { .u = 0x1ec7, .name = "ecircumflexdotbelow" },
                                                                { .u = 0x1ec1, .name = "ecircumflexgrave" },
                                                                { .u = 0x1ec3, .name = "ecircumflexhookabove" },
                                                                { .u = 0x1ec5, .name = "ecircumflextilde" },
                                                                { .u = 0x0454, .name = "ecyrillic" },
                                                                { .u = 0x0205, .name = "edblgrave" },
                                                                { .u = 0x090f, .name = "edeva" },
                                                                { .u = 0x00eb, .name = "edieresis" },
                                                                { .u = 0x0117, .name = "edot" },
                                                                { .u = 0x0117, .name = "edotaccent" },
                                                                { .u = 0x1eb9, .name = "edotbelow" },
                                                                { .u = 0x0a0f, .name = "eegurmukhi" },
                                                                { .u = 0x0a47, .name = "eematragurmukhi" },
                                                                { .u = 0x0444, .name = "efcyrillic" },
                                                                { .u = 0x00e8, .name = "egrave" },
                                                                { .u = 0x0a8f, .name = "egujarati" },
                                                                { .u = 0x0567, .name = "eharmenian" },
                                                                { .u = 0x311d, .name = "ehbopomofo" },
                                                                { .u = 0x3048, .name = "ehiragana" },
                                                                { .u = 0x1ebb, .name = "ehookabove" },
                                                                { .u = 0x311f, .name = "eibopomofo" },
                                                                { .u = 0x0038, .name = "eight" },
                                                                { .u = 0x0668, .name = "eightarabic" },
                                                                { .u = 0x09ee, .name = "eightbengali" },
                                                                { .u = 0x2467, .name = "eightcircle" },
                                                                { .u = 0x2791, .name = "eightcircleinversesansserif" },
                                                                { .u = 0x096e, .name = "eightdeva" },
                                                                { .u = 0x2471, .name = "eighteencircle" },
                                                                { .u = 0x2485, .name = "eighteenparen" },
                                                                { .u = 0x2499, .name = "eighteenperiod" },
                                                                { .u = 0x0aee, .name = "eightgujarati" },
                                                                { .u = 0x0a6e, .name = "eightgurmukhi" },
                                                                { .u = 0x0668, .name = "eighthackarabic" },
                                                                { .u = 0x3028, .name = "eighthangzhou" },
                                                                { .u = 0x266b, .name = "eighthnotebeamed" },
                                                                { .u = 0x3227, .name = "eightideographicparen" },
                                                                { .u = 0x2088, .name = "eightinferior" },
                                                                { .u = 0xff18, .name = "eightmonospace" },
                                                                { .u = 0xf738, .name = "eightoldstyle" },
                                                                { .u = 0x247b, .name = "eightparen" },
                                                                { .u = 0x248f, .name = "eightperiod" },
                                                                { .u = 0x06f8, .name = "eightpersian" },
                                                                { .u = 0x2177, .name = "eightroman" },
                                                                { .u = 0x2078, .name = "eightsuperior" },
                                                                { .u = 0x0e58, .name = "eightthai" },
                                                                { .u = 0x0207, .name = "einvertedbreve" },
                                                                { .u = 0x0465, .name = "eiotifiedcyrillic" },
                                                                { .u = 0x30a8, .name = "ekatakana" },
                                                                { .u = 0xff74, .name = "ekatakanahalfwidth" },
                                                                { .u = 0x0a74, .name = "ekonkargurmukhi" },
                                                                { .u = 0x3154, .name = "ekorean" },
                                                                { .u = 0x043b, .name = "elcyrillic" },
                                                                { .u = 0x2208, .name = "element" },
                                                                { .u = 0x246a, .name = "elevencircle" },
                                                                { .u = 0x247e, .name = "elevenparen" },
                                                                { .u = 0x2492, .name = "elevenperiod" },
                                                                { .u = 0x217a, .name = "elevenroman" },
                                                                { .u = 0x2026, .name = "ellipsis" },
                                                                { .u = 0x22ee, .name = "ellipsisvertical" },
                                                                { .u = 0x0113, .name = "emacron" },
                                                                { .u = 0x1e17, .name = "emacronacute" },
                                                                { .u = 0x1e15, .name = "emacrongrave" },
                                                                { .u = 0x043c, .name = "emcyrillic" },
                                                                { .u = 0x2014, .name = "emdash" },
                                                                { .u = 0xfe31, .name = "emdashvertical" },
                                                                { .u = 0xff45, .name = "emonospace" },
                                                                { .u = 0x055b, .name = "emphasismarkarmenian" },
                                                                { .u = 0x2205, .name = "emptyset" },
                                                                { .u = 0x3123, .name = "enbopomofo" },
                                                                { .u = 0x043d, .name = "encyrillic" },
                                                                { .u = 0x2013, .name = "endash" },
                                                                { .u = 0xfe32, .name = "endashvertical" },
                                                                { .u = 0x04a3, .name = "endescendercyrillic" },
                                                                { .u = 0x014b, .name = "eng" },
                                                                { .u = 0x3125, .name = "engbopomofo" },
                                                                { .u = 0x04a5, .name = "enghecyrillic" },
                                                                { .u = 0x04c8, .name = "enhookcyrillic" },
                                                                { .u = 0x2002, .name = "enspace" },
                                                                { .u = 0x0119, .name = "eogonek" },
                                                                { .u = 0x3153, .name = "eokorean" },
                                                                { .u = 0x025b, .name = "eopen" },
                                                                { .u = 0x029a, .name = "eopenclosed" },
                                                                { .u = 0x025c, .name = "eopenreversed" },
                                                                { .u = 0x025e, .name = "eopenreversedclosed" },
                                                                { .u = 0x025d, .name = "eopenreversedhook" },
                                                                { .u = 0x24a0, .name = "eparen" },
                                                                { .u = 0x03b5, .name = "epsilon" },
                                                                { .u = 0x03ad, .name = "epsilontonos" },
                                                                { .u = 0x003d, .name = "equal" },
                                                                { .u = 0xff1d, .name = "equalmonospace" },
                                                                { .u = 0xfe66, .name = "equalsmall" },
                                                                { .u = 0x207c, .name = "equalsuperior" },
                                                                { .u = 0x2261, .name = "equivalence" },
                                                                { .u = 0x3126, .name = "erbopomofo" },
                                                                { .u = 0x0440, .name = "ercyrillic" },
                                                                { .u = 0x0258, .name = "ereversed" },
                                                                { .u = 0x044d, .name = "ereversedcyrillic" },
                                                                { .u = 0x0441, .name = "escyrillic" },
                                                                { .u = 0x04ab, .name = "esdescendercyrillic" },
                                                                { .u = 0x0283, .name = "esh" },
                                                                { .u = 0x0286, .name = "eshcurl" },
                                                                { .u = 0x090e, .name = "eshortdeva" },
                                                                { .u = 0x0946, .name = "eshortvowelsigndeva" },
                                                                { .u = 0x01aa, .name = "eshreversedloop" },
                                                                { .u = 0x0285, .name = "eshsquatreversed" },
                                                                { .u = 0x3047, .name = "esmallhiragana" },
                                                                { .u = 0x30a7, .name = "esmallkatakana" },
                                                                { .u = 0xff6a, .name = "esmallkatakanahalfwidth" },
                                                                { .u = 0x212e, .name = "estimated" },
                                                                { .u = 0xf6ec, .name = "esuperior" },
                                                                { .u = 0x03b7, .name = "eta" },
                                                                { .u = 0x0568, .name = "etarmenian" },
                                                                { .u = 0x03ae, .name = "etatonos" },
                                                                { .u = 0x00f0, .name = "eth" },
                                                                { .u = 0x1ebd, .name = "etilde" },
                                                                { .u = 0x1e1b, .name = "etildebelow" },
                                                                { .u = 0x0591, .name = "etnahtafoukhhebrew" },
                                                                { .u = 0x0591, .name = "etnahtafoukhlefthebrew" },
                                                                { .u = 0x0591, .name = "etnahtahebrew" },
                                                                { .u = 0x0591, .name = "etnahtalefthebrew" },
                                                                { .u = 0x01dd, .name = "eturned" },
                                                                { .u = 0x3161, .name = "eukorean" },
                                                                { .u = 0x20ac, .name = "euro" },
                                                                { .u = 0x09c7, .name = "evowelsignbengali" },
                                                                { .u = 0x0947, .name = "evowelsigndeva" },
                                                                { .u = 0x0ac7, .name = "evowelsigngujarati" },
                                                                { .u = 0x0021, .name = "exclam" },
                                                                { .u = 0x055c, .name = "exclamarmenian" },
                                                                { .u = 0x203c, .name = "exclamdbl" },
                                                                { .u = 0x00a1, .name = "exclamdown" },
                                                                { .u = 0xf7a1, .name = "exclamdownsmall" },
                                                                { .u = 0x0021, .name = "exclamleft" },
                                                                { .u = 0xff01, .name = "exclammonospace" },
                                                                { .u = 0xf721, .name = "exclamsmall" },
                                                                { .u = 0x2203, .name = "existential" },
                                                                { .u = 0x0292, .name = "ezh" },
                                                                { .u = 0x01ef, .name = "ezhcaron" },
                                                                { .u = 0x0293, .name = "ezhcurl" },
                                                                { .u = 0x01b9, .name = "ezhreversed" },
                                                                { .u = 0x01ba, .name = "ezhtail" },
                                                                { .u = 0x0066, .name = "f" },
                                                                { .u = 0x095e, .name = "fadeva" },
                                                                { .u = 0x0a5e, .name = "fagurmukhi" },
                                                                { .u = 0x2109, .name = "fahrenheit" },
                                                                { .u = 0x064e, .name = "fathaarabic" },
                                                                { .u = 0x064e, .name = "fathalowarabic" },
                                                                { .u = 0x064b, .name = "fathatanarabic" },
                                                                { .u = 0x3108, .name = "fbopomofo" },
                                                                { .u = 0x24d5, .name = "fcircle" },
                                                                { .u = 0x1e1f, .name = "fdotaccent" },
                                                                { .u = 0x0641, .name = "feharabic" },
                                                                { .u = 0x0586, .name = "feharmenian" },
                                                                { .u = 0xfed2, .name = "fehfinalarabic" },
                                                                { .u = 0xfed3, .name = "fehinitialarabic" },
                                                                { .u = 0xfed4, .name = "fehmedialarabic" },
                                                                { .u = 0x03e5, .name = "feicoptic" },
                                                                { .u = 0x2640, .name = "female" },
                                                                { .u = 0xfb00, .name = "ff" },
                                                                { .u = 0xfb03, .name = "ffi" },
                                                                { .u = 0xfb04, .name = "ffl" },
                                                                { .u = 0xfb01, .name = "fi" },
                                                                { .u = 0x246e, .name = "fifteencircle" },
                                                                { .u = 0x2482, .name = "fifteenparen" },
                                                                { .u = 0x2496, .name = "fifteenperiod" },
                                                                { .u = 0x2012, .name = "figuredash" },
                                                                { .u = 0x25a0, .name = "filledbox" },
                                                                { .u = 0x25ac, .name = "filledrect" },
                                                                { .u = 0x05da, .name = "finalkaf" },
                                                                { .u = 0xfb3a, .name = "finalkafdagesh" },
                                                                { .u = 0xfb3a, .name = "finalkafdageshhebrew" },
                                                                { .u = 0x05da, .name = "finalkafhebrew" },
                                                                { .u = 0x05dd, .name = "finalmem" },
                                                                { .u = 0x05dd, .name = "finalmemhebrew" },
                                                                { .u = 0x05df, .name = "finalnun" },
                                                                { .u = 0x05df, .name = "finalnunhebrew" },
                                                                { .u = 0x05e3, .name = "finalpe" },
                                                                { .u = 0x05e3, .name = "finalpehebrew" },
                                                                { .u = 0x05e5, .name = "finaltsadi" },
                                                                { .u = 0x05e5, .name = "finaltsadihebrew" },
                                                                { .u = 0x02c9, .name = "firsttonechinese" },
                                                                { .u = 0x25c9, .name = "fisheye" },
                                                                { .u = 0x0473, .name = "fitacyrillic" },
                                                                { .u = 0x0035, .name = "five" },
                                                                { .u = 0x0665, .name = "fivearabic" },
                                                                { .u = 0x09eb, .name = "fivebengali" },
                                                                { .u = 0x2464, .name = "fivecircle" },
                                                                { .u = 0x278e, .name = "fivecircleinversesansserif" },
                                                                { .u = 0x096b, .name = "fivedeva" },
                                                                { .u = 0x215d, .name = "fiveeighths" },
                                                                { .u = 0x0aeb, .name = "fivegujarati" },
                                                                { .u = 0x0a6b, .name = "fivegurmukhi" },
                                                                { .u = 0x0665, .name = "fivehackarabic" },
                                                                { .u = 0x3025, .name = "fivehangzhou" },
                                                                { .u = 0x3224, .name = "fiveideographicparen" },
                                                                { .u = 0x2085, .name = "fiveinferior" },
                                                                { .u = 0xff15, .name = "fivemonospace" },
                                                                { .u = 0xf735, .name = "fiveoldstyle" },
                                                                { .u = 0x2478, .name = "fiveparen" },
                                                                { .u = 0x248c, .name = "fiveperiod" },
                                                                { .u = 0x06f5, .name = "fivepersian" },
                                                                { .u = 0x2174, .name = "fiveroman" },
                                                                { .u = 0x2075, .name = "fivesuperior" },
                                                                { .u = 0x0e55, .name = "fivethai" },
                                                                { .u = 0xfb02, .name = "fl" },
                                                                { .u = 0x0192, .name = "florin" },
                                                                { .u = 0xff46, .name = "fmonospace" },
                                                                { .u = 0x3399, .name = "fmsquare" },
                                                                { .u = 0x0e1f, .name = "fofanthai" },
                                                                { .u = 0x0e1d, .name = "fofathai" },
                                                                { .u = 0x0e4f, .name = "fongmanthai" },
                                                                { .u = 0x2200, .name = "forall" },
                                                                { .u = 0x0034, .name = "four" },
                                                                { .u = 0x0664, .name = "fourarabic" },
                                                                { .u = 0x09ea, .name = "fourbengali" },
                                                                { .u = 0x2463, .name = "fourcircle" },
                                                                { .u = 0x278d, .name = "fourcircleinversesansserif" },
                                                                { .u = 0x096a, .name = "fourdeva" },
                                                                { .u = 0x0aea, .name = "fourgujarati" },
                                                                { .u = 0x0a6a, .name = "fourgurmukhi" },
                                                                { .u = 0x0664, .name = "fourhackarabic" },
                                                                { .u = 0x3024, .name = "fourhangzhou" },
                                                                { .u = 0x3223, .name = "fourideographicparen" },
                                                                { .u = 0x2084, .name = "fourinferior" },
                                                                { .u = 0xff14, .name = "fourmonospace" },
                                                                { .u = 0x09f7, .name = "fournumeratorbengali" },
                                                                { .u = 0xf734, .name = "fouroldstyle" },
                                                                { .u = 0x2477, .name = "fourparen" },
                                                                { .u = 0x248b, .name = "fourperiod" },
                                                                { .u = 0x06f4, .name = "fourpersian" },
                                                                { .u = 0x2173, .name = "fourroman" },
                                                                { .u = 0x2074, .name = "foursuperior" },
                                                                { .u = 0x246d, .name = "fourteencircle" },
                                                                { .u = 0x2481, .name = "fourteenparen" },
                                                                { .u = 0x2495, .name = "fourteenperiod" },
                                                                { .u = 0x0e54, .name = "fourthai" },
                                                                { .u = 0x02cb, .name = "fourthtonechinese" },
                                                                { .u = 0x24a1, .name = "fparen" },
                                                                { .u = 0x2044, .name = "fraction" },
                                                                { .u = 0x20a3, .name = "franc" },
                                                                { .u = 0x0067, .name = "g" },
                                                                { .u = 0x0997, .name = "gabengali" },
                                                                { .u = 0x01f5, .name = "gacute" },
                                                                { .u = 0x0917, .name = "gadeva" },
                                                                { .u = 0x06af, .name = "gafarabic" },
                                                                { .u = 0xfb93, .name = "gaffinalarabic" },
                                                                { .u = 0xfb94, .name = "gafinitialarabic" },
                                                                { .u = 0xfb95, .name = "gafmedialarabic" },
                                                                { .u = 0x0a97, .name = "gagujarati" },
                                                                { .u = 0x0a17, .name = "gagurmukhi" },
                                                                { .u = 0x304c, .name = "gahiragana" },
                                                                { .u = 0x30ac, .name = "gakatakana" },
                                                                { .u = 0x03b3, .name = "gamma" },
                                                                { .u = 0x0263, .name = "gammalatinsmall" },
                                                                { .u = 0x02e0, .name = "gammasuperior" },
                                                                { .u = 0x03eb, .name = "gangiacoptic" },
                                                                { .u = 0x310d, .name = "gbopomofo" },
                                                                { .u = 0x011f, .name = "gbreve" },
                                                                { .u = 0x01e7, .name = "gcaron" },
                                                                { .u = 0x0123, .name = "gcedilla" },
                                                                { .u = 0x24d6, .name = "gcircle" },
                                                                { .u = 0x011d, .name = "gcircumflex" },
                                                                { .u = 0x0123, .name = "gcommaaccent" },
                                                                { .u = 0x0121, .name = "gdot" },
                                                                { .u = 0x0121, .name = "gdotaccent" },
                                                                { .u = 0x0433, .name = "gecyrillic" },
                                                                { .u = 0x3052, .name = "gehiragana" },
                                                                { .u = 0x30b2, .name = "gekatakana" },
                                                                { .u = 0x2251, .name = "geometricallyequal" },
                                                                { .u = 0x059c, .name = "gereshaccenthebrew" },
                                                                { .u = 0x05f3, .name = "gereshhebrew" },
                                                                { .u = 0x059d, .name = "gereshmuqdamhebrew" },
                                                                { .u = 0x00df, .name = "germandbls" },
                                                                { .u = 0x059e, .name = "gershayimaccenthebrew" },
                                                                { .u = 0x05f4, .name = "gershayimhebrew" },
                                                                { .u = 0x3013, .name = "getamark" },
                                                                { .u = 0x0998, .name = "ghabengali" },
                                                                { .u = 0x0572, .name = "ghadarmenian" },
                                                                { .u = 0x0918, .name = "ghadeva" },
                                                                { .u = 0x0a98, .name = "ghagujarati" },
                                                                { .u = 0x0a18, .name = "ghagurmukhi" },
                                                                { .u = 0x063a, .name = "ghainarabic" },
                                                                { .u = 0xfece, .name = "ghainfinalarabic" },
                                                                { .u = 0xfecf, .name = "ghaininitialarabic" },
                                                                { .u = 0xfed0, .name = "ghainmedialarabic" },
                                                                { .u = 0x0495, .name = "ghemiddlehookcyrillic" },
                                                                { .u = 0x0493, .name = "ghestrokecyrillic" },
                                                                { .u = 0x0491, .name = "gheupturncyrillic" },
                                                                { .u = 0x095a, .name = "ghhadeva" },
                                                                { .u = 0x0a5a, .name = "ghhagurmukhi" },
                                                                { .u = 0x0260, .name = "ghook" },
                                                                { .u = 0x3393, .name = "ghzsquare" },
                                                                { .u = 0x304e, .name = "gihiragana" },
                                                                { .u = 0x30ae, .name = "gikatakana" },
                                                                { .u = 0x0563, .name = "gimarmenian" },
                                                                { .u = 0x05d2, .name = "gimel" },
                                                                { .u = 0xfb32, .name = "gimeldagesh" },
                                                                { .u = 0xfb32, .name = "gimeldageshhebrew" },
                                                                { .u = 0x05d2, .name = "gimelhebrew" },
                                                                { .u = 0x0453, .name = "gjecyrillic" },
                                                                { .u = 0x01be, .name = "glottalinvertedstroke" },
                                                                { .u = 0x0294, .name = "glottalstop" },
                                                                { .u = 0x0296, .name = "glottalstopinverted" },
                                                                { .u = 0x02c0, .name = "glottalstopmod" },
                                                                { .u = 0x0295, .name = "glottalstopreversed" },
                                                                { .u = 0x02c1, .name = "glottalstopreversedmod" },
                                                                { .u = 0x02e4, .name = "glottalstopreversedsuperior" },
                                                                { .u = 0x02a1, .name = "glottalstopstroke" },
                                                                { .u = 0x02a2, .name = "glottalstopstrokereversed" },
                                                                { .u = 0x1e21, .name = "gmacron" },
                                                                { .u = 0xff47, .name = "gmonospace" },
                                                                { .u = 0x3054, .name = "gohiragana" },
                                                                { .u = 0x30b4, .name = "gokatakana" },
                                                                { .u = 0x24a2, .name = "gparen" },
                                                                { .u = 0x33ac, .name = "gpasquare" },
                                                                { .u = 0x2207, .name = "gradient" },
                                                                { .u = 0x0060, .name = "grave" },
                                                                { .u = 0x0316, .name = "gravebelowcmb" },
                                                                { .u = 0x0300, .name = "gravecmb" },
                                                                { .u = 0x0300, .name = "gravecomb" },
                                                                { .u = 0x0953, .name = "gravedeva" },
                                                                { .u = 0x02ce, .name = "gravelowmod" },
                                                                { .u = 0xff40, .name = "gravemonospace" },
                                                                { .u = 0x0340, .name = "gravetonecmb" },
                                                                { .u = 0x003e, .name = "greater" },
                                                                { .u = 0x2265, .name = "greaterequal" },
                                                                { .u = 0x22db, .name = "greaterequalorless" },
                                                                { .u = 0xff1e, .name = "greatermonospace" },
                                                                { .u = 0x2a7e, .name = "greaterorequalslant" },
                                                                { .u = 0x2273, .name = "greaterorequivalent" },
                                                                { .u = 0x2277, .name = "greaterorless" },
                                                                { .u = 0x2267, .name = "greateroverequal" },
                                                                { .u = 0xfe65, .name = "greatersmall" },
                                                                { .u = 0x0261, .name = "gscript" },
                                                                { .u = 0x01e5, .name = "gstroke" },
                                                                { .u = 0x3050, .name = "guhiragana" },
                                                                { .u = 0x00ab, .name = "guillemotleft" },
                                                                { .u = 0x00bb, .name = "guillemotright" },
                                                                { .u = 0x2039, .name = "guilsinglleft" },
                                                                { .u = 0x203a, .name = "guilsinglright" },
                                                                { .u = 0x30b0, .name = "gukatakana" },
                                                                { .u = 0x3318, .name = "guramusquare" },
                                                                { .u = 0x33c9, .name = "gysquare" },
                                                                { .u = 0x0068, .name = "h" },
                                                                { .u = 0x04a9, .name = "haabkhasiancyrillic" },
                                                                { .u = 0x06c1, .name = "haaltonearabic" },
                                                                { .u = 0x09b9, .name = "habengali" },
                                                                { .u = 0x04b3, .name = "hadescendercyrillic" },
                                                                { .u = 0x0939, .name = "hadeva" },
                                                                { .u = 0x0ab9, .name = "hagujarati" },
                                                                { .u = 0x0a39, .name = "hagurmukhi" },
                                                                { .u = 0x062d, .name = "haharabic" },
                                                                { .u = 0xfea2, .name = "hahfinalarabic" },
                                                                { .u = 0xfea3, .name = "hahinitialarabic" },
                                                                { .u = 0x306f, .name = "hahiragana" },
                                                                { .u = 0xfea4, .name = "hahmedialarabic" },
                                                                { .u = 0x332a, .name = "haitusquare" },
                                                                { .u = 0x30cf, .name = "hakatakana" },
                                                                { .u = 0xff8a, .name = "hakatakanahalfwidth" },
                                                                { .u = 0x0a4d, .name = "halantgurmukhi" },
                                                                { .u = 0x0621, .name = "hamzaarabic" },
                                                                { .u = 0x0621, .name = "hamzalowarabic" },
                                                                { .u = 0x3164, .name = "hangulfiller" },
                                                                { .u = 0x044a, .name = "hardsigncyrillic" },
                                                                { .u = 0x21bc, .name = "harpoonleftbarbup" },
                                                                { .u = 0x21c0, .name = "harpoonrightbarbup" },
                                                                { .u = 0x33ca, .name = "hasquare" },
                                                                { .u = 0x05b2, .name = "hatafpatah" },
                                                                { .u = 0x05b2, .name = "hatafpatah16" },
                                                                { .u = 0x05b2, .name = "hatafpatah23" },
                                                                { .u = 0x05b2, .name = "hatafpatah2f" },
                                                                { .u = 0x05b2, .name = "hatafpatahhebrew" },
                                                                { .u = 0x05b2, .name = "hatafpatahnarrowhebrew" },
                                                                { .u = 0x05b2, .name = "hatafpatahquarterhebrew" },
                                                                { .u = 0x05b2, .name = "hatafpatahwidehebrew" },
                                                                { .u = 0x05b3, .name = "hatafqamats" },
                                                                { .u = 0x05b3, .name = "hatafqamats1b" },
                                                                { .u = 0x05b3, .name = "hatafqamats28" },
                                                                { .u = 0x05b3, .name = "hatafqamats34" },
                                                                { .u = 0x05b3, .name = "hatafqamatshebrew" },
                                                                { .u = 0x05b3, .name = "hatafqamatsnarrowhebrew" },
                                                                { .u = 0x05b3, .name = "hatafqamatsquarterhebrew" },
                                                                { .u = 0x05b3, .name = "hatafqamatswidehebrew" },
                                                                { .u = 0x05b1, .name = "hatafsegol" },
                                                                { .u = 0x05b1, .name = "hatafsegol17" },
                                                                { .u = 0x05b1, .name = "hatafsegol24" },
                                                                { .u = 0x05b1, .name = "hatafsegol30" },
                                                                { .u = 0x05b1, .name = "hatafsegolhebrew" },
                                                                { .u = 0x05b1, .name = "hatafsegolnarrowhebrew" },
                                                                { .u = 0x05b1, .name = "hatafsegolquarterhebrew" },
                                                                { .u = 0x05b1, .name = "hatafsegolwidehebrew" },
                                                                { .u = 0x0127, .name = "hbar" },
                                                                { .u = 0x310f, .name = "hbopomofo" },
                                                                { .u = 0x1e2b, .name = "hbrevebelow" },
                                                                { .u = 0x1e29, .name = "hcedilla" },
                                                                { .u = 0x24d7, .name = "hcircle" },
                                                                { .u = 0x0125, .name = "hcircumflex" },
                                                                { .u = 0x1e27, .name = "hdieresis" },
                                                                { .u = 0x1e23, .name = "hdotaccent" },
                                                                { .u = 0x1e25, .name = "hdotbelow" },
                                                                { .u = 0x05d4, .name = "he" },
                                                                { .u = 0x2665, .name = "heart" },
                                                                { .u = 0x2665, .name = "heartsuitblack" },
                                                                { .u = 0x2661, .name = "heartsuitwhite" },
                                                                { .u = 0xfb34, .name = "hedagesh" },
                                                                { .u = 0xfb34, .name = "hedageshhebrew" },
                                                                { .u = 0x06c1, .name = "hehaltonearabic" },
                                                                { .u = 0x0647, .name = "heharabic" },
                                                                { .u = 0x05d4, .name = "hehebrew" },
                                                                { .u = 0xfba7, .name = "hehfinalaltonearabic" },
                                                                { .u = 0xfeea, .name = "hehfinalalttwoarabic" },
                                                                { .u = 0xfeea, .name = "hehfinalarabic" },
                                                                { .u = 0xfba5, .name = "hehhamzaabovefinalarabic" },
                                                                { .u = 0xfba4, .name = "hehhamzaaboveisolatedarabic" },
                                                                { .u = 0xfba8, .name = "hehinitialaltonearabic" },
                                                                { .u = 0xfeeb, .name = "hehinitialarabic" },
                                                                { .u = 0x3078, .name = "hehiragana" },
                                                                { .u = 0xfba9, .name = "hehmedialaltonearabic" },
                                                                { .u = 0xfeec, .name = "hehmedialarabic" },
                                                                { .u = 0x337b, .name = "heiseierasquare" },
                                                                { .u = 0x30d8, .name = "hekatakana" },
                                                                { .u = 0xff8d, .name = "hekatakanahalfwidth" },
                                                                { .u = 0x3336, .name = "hekutaarusquare" },
                                                                { .u = 0x0267, .name = "henghook" },
                                                                { .u = 0x3339, .name = "herutusquare" },
                                                                { .u = 0x05d7, .name = "het" },
                                                                { .u = 0x05d7, .name = "hethebrew" },
                                                                { .u = 0x0266, .name = "hhook" },
                                                                { .u = 0x02b1, .name = "hhooksuperior" },
                                                                { .u = 0x327b, .name = "hieuhacirclekorean" },
                                                                { .u = 0x321b, .name = "hieuhaparenkorean" },
                                                                { .u = 0x326d, .name = "hieuhcirclekorean" },
                                                                { .u = 0x314e, .name = "hieuhkorean" },
                                                                { .u = 0x320d, .name = "hieuhparenkorean" },
                                                                { .u = 0x3072, .name = "hihiragana" },
                                                                { .u = 0x30d2, .name = "hikatakana" },
                                                                { .u = 0xff8b, .name = "hikatakanahalfwidth" },
                                                                { .u = 0x05b4, .name = "hiriq" },
                                                                { .u = 0x05b4, .name = "hiriq14" },
                                                                { .u = 0x05b4, .name = "hiriq21" },
                                                                { .u = 0x05b4, .name = "hiriq2d" },
                                                                { .u = 0x05b4, .name = "hiriqhebrew" },
                                                                { .u = 0x05b4, .name = "hiriqnarrowhebrew" },
                                                                { .u = 0x05b4, .name = "hiriqquarterhebrew" },
                                                                { .u = 0x05b4, .name = "hiriqwidehebrew" },
                                                                { .u = 0x1e96, .name = "hlinebelow" },
                                                                { .u = 0xff48, .name = "hmonospace" },
                                                                { .u = 0x0570, .name = "hoarmenian" },
                                                                { .u = 0x0e2b, .name = "hohipthai" },
                                                                { .u = 0x307b, .name = "hohiragana" },
                                                                { .u = 0x30db, .name = "hokatakana" },
                                                                { .u = 0xff8e, .name = "hokatakanahalfwidth" },
                                                                { .u = 0x05b9, .name = "holam" },
                                                                { .u = 0x05b9, .name = "holam19" },
                                                                { .u = 0x05b9, .name = "holam26" },
                                                                { .u = 0x05b9, .name = "holam32" },
                                                                { .u = 0x05b9, .name = "holamhebrew" },
                                                                { .u = 0x05b9, .name = "holamnarrowhebrew" },
                                                                { .u = 0x05b9, .name = "holamquarterhebrew" },
                                                                { .u = 0x05b9, .name = "holamwidehebrew" },
                                                                { .u = 0x0e2e, .name = "honokhukthai" },
                                                                { .u = 0x0309, .name = "hookabovecomb" },
                                                                { .u = 0x0309, .name = "hookcmb" },
                                                                { .u = 0x0321, .name = "hookpalatalizedbelowcmb" },
                                                                { .u = 0x0322, .name = "hookretroflexbelowcmb" },
                                                                { .u = 0x3342, .name = "hoonsquare" },
                                                                { .u = 0x03e9, .name = "horicoptic" },
                                                                { .u = 0x2015, .name = "horizontalbar" },
                                                                { .u = 0x031b, .name = "horncmb" },
                                                                { .u = 0x2668, .name = "hotsprings" },
                                                                { .u = 0x2302, .name = "house" },
                                                                { .u = 0x24a3, .name = "hparen" },
                                                                { .u = 0x02b0, .name = "hsuperior" },
                                                                { .u = 0x0265, .name = "hturned" },
                                                                { .u = 0x3075, .name = "huhiragana" },
                                                                { .u = 0x3333, .name = "huiitosquare" },
                                                                { .u = 0x30d5, .name = "hukatakana" },
                                                                { .u = 0xff8c, .name = "hukatakanahalfwidth" },
                                                                { .u = 0x02dd, .name = "hungarumlaut" },
                                                                { .u = 0x030b, .name = "hungarumlautcmb" },
                                                                { .u = 0x0195, .name = "hv" },
                                                                { .u = 0x002d, .name = "hyphen" },
                                                                { .u = 0xf6e5, .name = "hypheninferior" },
                                                                { .u = 0xff0d, .name = "hyphenmonospace" },
                                                                { .u = 0xfe63, .name = "hyphensmall" },
                                                                { .u = 0xf6e6, .name = "hyphensuperior" },
                                                                { .u = 0x2010, .name = "hyphentwo" },
                                                                { .u = 0x0069, .name = "i" },
                                                                { .u = 0x00ed, .name = "iacute" },
                                                                { .u = 0x044f, .name = "iacyrillic" },
                                                                { .u = 0x0987, .name = "ibengali" },
                                                                { .u = 0x3127, .name = "ibopomofo" },
                                                                { .u = 0x012d, .name = "ibreve" },
                                                                { .u = 0x01d0, .name = "icaron" },
                                                                { .u = 0x24d8, .name = "icircle" },
                                                                { .u = 0x00ee, .name = "icircumflex" },
                                                                { .u = 0x0456, .name = "icyrillic" },
                                                                { .u = 0x0209, .name = "idblgrave" },
                                                                { .u = 0x328f, .name = "ideographearthcircle" },
                                                                { .u = 0x328b, .name = "ideographfirecircle" },
                                                                { .u = 0x323f, .name = "ideographicallianceparen" },
                                                                { .u = 0x323a, .name = "ideographiccallparen" },
                                                                { .u = 0x32a5, .name = "ideographiccentrecircle" },
                                                                { .u = 0x3006, .name = "ideographicclose" },
                                                                { .u = 0x3001, .name = "ideographiccomma" },
                                                                { .u = 0xff64, .name = "ideographiccommaleft" },
                                                                { .u = 0x3237, .name = "ideographiccongratulationparen" },
                                                                { .u = 0x32a3, .name = "ideographiccorrectcircle" },
                                                                { .u = 0x322f, .name = "ideographicearthparen" },
                                                                { .u = 0x323d, .name = "ideographicenterpriseparen" },
                                                                { .u = 0x329d, .name = "ideographicexcellentcircle" },
                                                                { .u = 0x3240, .name = "ideographicfestivalparen" },
                                                                { .u = 0x3296, .name = "ideographicfinancialcircle" },
                                                                { .u = 0x3236, .name = "ideographicfinancialparen" },
                                                                { .u = 0x322b, .name = "ideographicfireparen" },
                                                                { .u = 0x3232, .name = "ideographichaveparen" },
                                                                { .u = 0x32a4, .name = "ideographichighcircle" },
                                                                { .u = 0x3005, .name = "ideographiciterationmark" },
                                                                { .u = 0x3298, .name = "ideographiclaborcircle" },
                                                                { .u = 0x3238, .name = "ideographiclaborparen" },
                                                                { .u = 0x32a7, .name = "ideographicleftcircle" },
                                                                { .u = 0x32a6, .name = "ideographiclowcircle" },
                                                                { .u = 0x32a9, .name = "ideographicmedicinecircle" },
                                                                { .u = 0x322e, .name = "ideographicmetalparen" },
                                                                { .u = 0x322a, .name = "ideographicmoonparen" },
                                                                { .u = 0x3234, .name = "ideographicnameparen" },
                                                                { .u = 0x3002, .name = "ideographicperiod" },
                                                                { .u = 0x329e, .name = "ideographicprintcircle" },
                                                                { .u = 0x3243, .name = "ideographicreachparen" },
                                                                { .u = 0x3239, .name = "ideographicrepresentparen" },
                                                                { .u = 0x323e, .name = "ideographicresourceparen" },
                                                                { .u = 0x32a8, .name = "ideographicrightcircle" },
                                                                { .u = 0x3299, .name = "ideographicsecretcircle" },
                                                                { .u = 0x3242, .name = "ideographicselfparen" },
                                                                { .u = 0x3233, .name = "ideographicsocietyparen" },
                                                                { .u = 0x3000, .name = "ideographicspace" },
                                                                { .u = 0x3235, .name = "ideographicspecialparen" },
                                                                { .u = 0x3231, .name = "ideographicstockparen" },
                                                                { .u = 0x323b, .name = "ideographicstudyparen" },
                                                                { .u = 0x3230, .name = "ideographicsunparen" },
                                                                { .u = 0x323c, .name = "ideographicsuperviseparen" },
                                                                { .u = 0x322c, .name = "ideographicwaterparen" },
                                                                { .u = 0x322d, .name = "ideographicwoodparen" },
                                                                { .u = 0x3007, .name = "ideographiczero" },
                                                                { .u = 0x328e, .name = "ideographmetalcircle" },
                                                                { .u = 0x328a, .name = "ideographmooncircle" },
                                                                { .u = 0x3294, .name = "ideographnamecircle" },
                                                                { .u = 0x3290, .name = "ideographsuncircle" },
                                                                { .u = 0x328c, .name = "ideographwatercircle" },
                                                                { .u = 0x328d, .name = "ideographwoodcircle" },
                                                                { .u = 0x0907, .name = "ideva" },
                                                                { .u = 0x00ef, .name = "idieresis" },
                                                                { .u = 0x1e2f, .name = "idieresisacute" },
                                                                { .u = 0x04e5, .name = "idieresiscyrillic" },
                                                                { .u = 0x1ecb, .name = "idotbelow" },
                                                                { .u = 0x04d7, .name = "iebrevecyrillic" },
                                                                { .u = 0x0435, .name = "iecyrillic" },
                                                                { .u = 0x3275, .name = "ieungacirclekorean" },
                                                                { .u = 0x3215, .name = "ieungaparenkorean" },
                                                                { .u = 0x3267, .name = "ieungcirclekorean" },
                                                                { .u = 0x3147, .name = "ieungkorean" },
                                                                { .u = 0x3207, .name = "ieungparenkorean" },
                                                                { .u = 0x00ec, .name = "igrave" },
                                                                { .u = 0x0a87, .name = "igujarati" },
                                                                { .u = 0x0a07, .name = "igurmukhi" },
                                                                { .u = 0x3044, .name = "ihiragana" },
                                                                { .u = 0x1ec9, .name = "ihookabove" },
                                                                { .u = 0x0988, .name = "iibengali" },
                                                                { .u = 0x0438, .name = "iicyrillic" },
                                                                { .u = 0x0908, .name = "iideva" },
                                                                { .u = 0x0a88, .name = "iigujarati" },
                                                                { .u = 0x0a08, .name = "iigurmukhi" },
                                                                { .u = 0x0a40, .name = "iimatragurmukhi" },
                                                                { .u = 0x020b, .name = "iinvertedbreve" },
                                                                { .u = 0x0439, .name = "iishortcyrillic" },
                                                                { .u = 0x09c0, .name = "iivowelsignbengali" },
                                                                { .u = 0x0940, .name = "iivowelsigndeva" },
                                                                { .u = 0x0ac0, .name = "iivowelsigngujarati" },
                                                                { .u = 0x0133, .name = "ij" },
                                                                { .u = 0x30a4, .name = "ikatakana" },
                                                                { .u = 0xff72, .name = "ikatakanahalfwidth" },
                                                                { .u = 0x3163, .name = "ikorean" },
                                                                { .u = 0x02dc, .name = "ilde" },
                                                                { .u = 0x05ac, .name = "iluyhebrew" },
                                                                { .u = 0x012b, .name = "imacron" },
                                                                { .u = 0x04e3, .name = "imacroncyrillic" },
                                                                { .u = 0x2253, .name = "imageorapproximatelyequal" },
                                                                { .u = 0x0a3f, .name = "imatragurmukhi" },
                                                                { .u = 0xff49, .name = "imonospace" },
                                                                { .u = 0x2206, .name = "increment" },
                                                                { .u = 0x221e, .name = "infinity" },
                                                                { .u = 0x056b, .name = "iniarmenian" },
                                                                { .u = 0x222b, .name = "integral" },
                                                                { .u = 0x2321, .name = "integralbottom" },
                                                                { .u = 0x2321, .name = "integralbt" },
                                                                { .u = 0xf8f5, .name = "integralex" },
                                                                { .u = 0x2320, .name = "integraltop" },
                                                                { .u = 0x2320, .name = "integraltp" },
                                                                { .u = 0x2229, .name = "intersection" },
                                                                { .u = 0x3305, .name = "intisquare" },
                                                                { .u = 0x25d8, .name = "invbullet" },
                                                                { .u = 0x25d9, .name = "invcircle" },
                                                                { .u = 0x263b, .name = "invsmileface" },
                                                                { .u = 0x0451, .name = "iocyrillic" },
                                                                { .u = 0x012f, .name = "iogonek" },
                                                                { .u = 0x03b9, .name = "iota" },
                                                                { .u = 0x03ca, .name = "iotadieresis" },
                                                                { .u = 0x0390, .name = "iotadieresistonos" },
                                                                { .u = 0x0269, .name = "iotalatin" },
                                                                { .u = 0x03af, .name = "iotatonos" },
                                                                { .u = 0x24a4, .name = "iparen" },
                                                                { .u = 0x0a72, .name = "irigurmukhi" },
                                                                { .u = 0x3043, .name = "ismallhiragana" },
                                                                { .u = 0x30a3, .name = "ismallkatakana" },
                                                                { .u = 0xff68, .name = "ismallkatakanahalfwidth" },
                                                                { .u = 0x09fa, .name = "issharbengali" },
                                                                { .u = 0x0268, .name = "istroke" },
                                                                { .u = 0xf6ed, .name = "isuperior" },
                                                                { .u = 0x309d, .name = "iterationhiragana" },
                                                                { .u = 0x30fd, .name = "iterationkatakana" },
                                                                { .u = 0x0129, .name = "itilde" },
                                                                { .u = 0x1e2d, .name = "itildebelow" },
                                                                { .u = 0x3129, .name = "iubopomofo" },
                                                                { .u = 0x044e, .name = "iucyrillic" },
                                                                { .u = 0x09bf, .name = "ivowelsignbengali" },
                                                                { .u = 0x093f, .name = "ivowelsigndeva" },
                                                                { .u = 0x0abf, .name = "ivowelsigngujarati" },
                                                                { .u = 0x0475, .name = "izhitsacyrillic" },
                                                                { .u = 0x0477, .name = "izhitsadblgravecyrillic" },
                                                                { .u = 0x006a, .name = "j" },
                                                                { .u = 0x0571, .name = "jaarmenian" },
                                                                { .u = 0x099c, .name = "jabengali" },
                                                                { .u = 0x091c, .name = "jadeva" },
                                                                { .u = 0x0a9c, .name = "jagujarati" },
                                                                { .u = 0x0a1c, .name = "jagurmukhi" },
                                                                { .u = 0x3110, .name = "jbopomofo" },
                                                                { .u = 0x01f0, .name = "jcaron" },
                                                                { .u = 0x24d9, .name = "jcircle" },
                                                                { .u = 0x0135, .name = "jcircumflex" },
                                                                { .u = 0x029d, .name = "jcrossedtail" },
                                                                { .u = 0x025f, .name = "jdotlessstroke" },
                                                                { .u = 0x0458, .name = "jecyrillic" },
                                                                { .u = 0x062c, .name = "jeemarabic" },
                                                                { .u = 0xfe9e, .name = "jeemfinalarabic" },
                                                                { .u = 0xfe9f, .name = "jeeminitialarabic" },
                                                                { .u = 0xfea0, .name = "jeemmedialarabic" },
                                                                { .u = 0x0698, .name = "jeharabic" },
                                                                { .u = 0xfb8b, .name = "jehfinalarabic" },
                                                                { .u = 0x099d, .name = "jhabengali" },
                                                                { .u = 0x091d, .name = "jhadeva" },
                                                                { .u = 0x0a9d, .name = "jhagujarati" },
                                                                { .u = 0x0a1d, .name = "jhagurmukhi" },
                                                                { .u = 0x057b, .name = "jheharmenian" },
                                                                { .u = 0x3004, .name = "jis" },
                                                                { .u = 0xff4a, .name = "jmonospace" },
                                                                { .u = 0x24a5, .name = "jparen" },
                                                                { .u = 0x02b2, .name = "jsuperior" },
                                                                { .u = 0x006b, .name = "k" },
                                                                { .u = 0x04a1, .name = "kabashkircyrillic" },
                                                                { .u = 0x0995, .name = "kabengali" },
                                                                { .u = 0x1e31, .name = "kacute" },
                                                                { .u = 0x043a, .name = "kacyrillic" },
                                                                { .u = 0x049b, .name = "kadescendercyrillic" },
                                                                { .u = 0x0915, .name = "kadeva" },
                                                                { .u = 0x05db, .name = "kaf" },
                                                                { .u = 0x0643, .name = "kafarabic" },
                                                                { .u = 0xfb3b, .name = "kafdagesh" },
                                                                { .u = 0xfb3b, .name = "kafdageshhebrew" },
                                                                { .u = 0xfeda, .name = "kaffinalarabic" },
                                                                { .u = 0x05db, .name = "kafhebrew" },
                                                                { .u = 0xfedb, .name = "kafinitialarabic" },
                                                                { .u = 0xfedc, .name = "kafmedialarabic" },
                                                                { .u = 0xfb4d, .name = "kafrafehebrew" },
                                                                { .u = 0x0a95, .name = "kagujarati" },
                                                                { .u = 0x0a15, .name = "kagurmukhi" },
                                                                { .u = 0x304b, .name = "kahiragana" },
                                                                { .u = 0x04c4, .name = "kahookcyrillic" },
                                                                { .u = 0x30ab, .name = "kakatakana" },
                                                                { .u = 0xff76, .name = "kakatakanahalfwidth" },
                                                                { .u = 0x03ba, .name = "kappa" },
                                                                { .u = 0x03f0, .name = "kappasymbolgreek" },
                                                                { .u = 0x3171, .name = "kapyeounmieumkorean" },
                                                                { .u = 0x3184, .name = "kapyeounphieuphkorean" },
                                                                { .u = 0x3178, .name = "kapyeounpieupkorean" },
                                                                { .u = 0x3179, .name = "kapyeounssangpieupkorean" },
                                                                { .u = 0x330d, .name = "karoriisquare" },
                                                                { .u = 0x0640, .name = "kashidaautoarabic" },
                                                                { .u = 0x0640, .name = "kashidaautonosidebearingarabic" },
                                                                { .u = 0x30f5, .name = "kasmallkatakana" },
                                                                { .u = 0x3384, .name = "kasquare" },
                                                                { .u = 0x0650, .name = "kasraarabic" },
                                                                { .u = 0x064d, .name = "kasratanarabic" },
                                                                { .u = 0x049f, .name = "kastrokecyrillic" },
                                                                { .u = 0xff70, .name = "katahiraprolongmarkhalfwidth" },
                                                                { .u = 0x049d, .name = "kaverticalstrokecyrillic" },
                                                                { .u = 0x310e, .name = "kbopomofo" },
                                                                { .u = 0x3389, .name = "kcalsquare" },
                                                                { .u = 0x01e9, .name = "kcaron" },
                                                                { .u = 0x0137, .name = "kcedilla" },
                                                                { .u = 0x24da, .name = "kcircle" },
                                                                { .u = 0x0137, .name = "kcommaaccent" },
                                                                { .u = 0x1e33, .name = "kdotbelow" },
                                                                { .u = 0x0584, .name = "keharmenian" },
                                                                { .u = 0x3051, .name = "kehiragana" },
                                                                { .u = 0x30b1, .name = "kekatakana" },
                                                                { .u = 0xff79, .name = "kekatakanahalfwidth" },
                                                                { .u = 0x056f, .name = "kenarmenian" },
                                                                { .u = 0x30f6, .name = "kesmallkatakana" },
                                                                { .u = 0x0138, .name = "kgreenlandic" },
                                                                { .u = 0x0996, .name = "khabengali" },
                                                                { .u = 0x0445, .name = "khacyrillic" },
                                                                { .u = 0x0916, .name = "khadeva" },
                                                                { .u = 0x0a96, .name = "khagujarati" },
                                                                { .u = 0x0a16, .name = "khagurmukhi" },
                                                                { .u = 0x062e, .name = "khaharabic" },
                                                                { .u = 0xfea6, .name = "khahfinalarabic" },
                                                                { .u = 0xfea7, .name = "khahinitialarabic" },
                                                                { .u = 0xfea8, .name = "khahmedialarabic" },
                                                                { .u = 0x03e7, .name = "kheicoptic" },
                                                                { .u = 0x0959, .name = "khhadeva" },
                                                                { .u = 0x0a59, .name = "khhagurmukhi" },
                                                                { .u = 0x3278, .name = "khieukhacirclekorean" },
                                                                { .u = 0x3218, .name = "khieukhaparenkorean" },
                                                                { .u = 0x326a, .name = "khieukhcirclekorean" },
                                                                { .u = 0x314b, .name = "khieukhkorean" },
                                                                { .u = 0x320a, .name = "khieukhparenkorean" },
                                                                { .u = 0x0e02, .name = "khokhaithai" },
                                                                { .u = 0x0e05, .name = "khokhonthai" },
                                                                { .u = 0x0e03, .name = "khokhuatthai" },
                                                                { .u = 0x0e04, .name = "khokhwaithai" },
                                                                { .u = 0x0e5b, .name = "khomutthai" },
                                                                { .u = 0x0199, .name = "khook" },
                                                                { .u = 0x0e06, .name = "khorakhangthai" },
                                                                { .u = 0x3391, .name = "khzsquare" },
                                                                { .u = 0x304d, .name = "kihiragana" },
                                                                { .u = 0x30ad, .name = "kikatakana" },
                                                                { .u = 0xff77, .name = "kikatakanahalfwidth" },
                                                                { .u = 0x3315, .name = "kiroguramusquare" },
                                                                { .u = 0x3316, .name = "kiromeetorusquare" },
                                                                { .u = 0x3314, .name = "kirosquare" },
                                                                { .u = 0x326e, .name = "kiyeokacirclekorean" },
                                                                { .u = 0x320e, .name = "kiyeokaparenkorean" },
                                                                { .u = 0x3260, .name = "kiyeokcirclekorean" },
                                                                { .u = 0x3131, .name = "kiyeokkorean" },
                                                                { .u = 0x3200, .name = "kiyeokparenkorean" },
                                                                { .u = 0x3133, .name = "kiyeoksioskorean" },
                                                                { .u = 0x045c, .name = "kjecyrillic" },
                                                                { .u = 0x1e35, .name = "klinebelow" },
                                                                { .u = 0x3398, .name = "klsquare" },
                                                                { .u = 0x33a6, .name = "kmcubedsquare" },
                                                                { .u = 0xff4b, .name = "kmonospace" },
                                                                { .u = 0x33a2, .name = "kmsquaredsquare" },
                                                                { .u = 0x3053, .name = "kohiragana" },
                                                                { .u = 0x33c0, .name = "kohmsquare" },
                                                                { .u = 0x0e01, .name = "kokaithai" },
                                                                { .u = 0x30b3, .name = "kokatakana" },
                                                                { .u = 0xff7a, .name = "kokatakanahalfwidth" },
                                                                { .u = 0x331e, .name = "kooposquare" },
                                                                { .u = 0x0481, .name = "koppacyrillic" },
                                                                { .u = 0x327f, .name = "koreanstandardsymbol" },
                                                                { .u = 0x0343, .name = "koroniscmb" },
                                                                { .u = 0x24a6, .name = "kparen" },
                                                                { .u = 0x33aa, .name = "kpasquare" },
                                                                { .u = 0x046f, .name = "ksicyrillic" },
                                                                { .u = 0x33cf, .name = "ktsquare" },
                                                                { .u = 0x029e, .name = "kturned" },
                                                                { .u = 0x304f, .name = "kuhiragana" },
                                                                { .u = 0x30af, .name = "kukatakana" },
                                                                { .u = 0xff78, .name = "kukatakanahalfwidth" },
                                                                { .u = 0x33b8, .name = "kvsquare" },
                                                                { .u = 0x33be, .name = "kwsquare" },
                                                                { .u = 0x006c, .name = "l" },
                                                                { .u = 0x09b2, .name = "labengali" },
                                                                { .u = 0x013a, .name = "lacute" },
                                                                { .u = 0x0932, .name = "ladeva" },
                                                                { .u = 0x0ab2, .name = "lagujarati" },
                                                                { .u = 0x0a32, .name = "lagurmukhi" },
                                                                { .u = 0x0e45, .name = "lakkhangyaothai" },
                                                                { .u = 0xfefc, .name = "lamaleffinalarabic" },
                                                                { .u = 0xfef8, .name = "lamalefhamzaabovefinalarabic" },
                                                                { .u = 0xfef7, .name = "lamalefhamzaaboveisolatedarabic" },
                                                                { .u = 0xfefa, .name = "lamalefhamzabelowfinalarabic" },
                                                                { .u = 0xfef9, .name = "lamalefhamzabelowisolatedarabic" },
                                                                { .u = 0xfefb, .name = "lamalefisolatedarabic" },
                                                                { .u = 0xfef6, .name = "lamalefmaddaabovefinalarabic" },
                                                                { .u = 0xfef5, .name = "lamalefmaddaaboveisolatedarabic" },
                                                                { .u = 0x0644, .name = "lamarabic" },
                                                                { .u = 0x03bb, .name = "lambda" },
                                                                { .u = 0x019b, .name = "lambdastroke" },
                                                                { .u = 0x05dc, .name = "lamed" },
                                                                { .u = 0xfb3c, .name = "lameddagesh" },
                                                                { .u = 0xfb3c, .name = "lameddageshhebrew" },
                                                                { .u = 0x05dc, .name = "lamedhebrew" },
                                                                { .u = 0xfede, .name = "lamfinalarabic" },
                                                                { .u = 0xfcca, .name = "lamhahinitialarabic" },
                                                                { .u = 0xfedf, .name = "laminitialarabic" },
                                                                { .u = 0xfcc9, .name = "lamjeeminitialarabic" },
                                                                { .u = 0xfccb, .name = "lamkhahinitialarabic" },
                                                                { .u = 0xfdf2, .name = "lamlamhehisolatedarabic" },
                                                                { .u = 0xfee0, .name = "lammedialarabic" },
                                                                { .u = 0xfd88, .name = "lammeemhahinitialarabic" },
                                                                { .u = 0xfccc, .name = "lammeeminitialarabic" },
                                                                { .u = 0x25ef, .name = "largecircle" },
                                                                { .u = 0x019a, .name = "lbar" },
                                                                { .u = 0x026c, .name = "lbelt" },
                                                                { .u = 0x310c, .name = "lbopomofo" },
                                                                { .u = 0x013e, .name = "lcaron" },
                                                                { .u = 0x013c, .name = "lcedilla" },
                                                                { .u = 0x24db, .name = "lcircle" },
                                                                { .u = 0x1e3d, .name = "lcircumflexbelow" },
                                                                { .u = 0x013c, .name = "lcommaaccent" },
                                                                { .u = 0x0140, .name = "ldot" },
                                                                { .u = 0x0140, .name = "ldotaccent" },
                                                                { .u = 0x1e37, .name = "ldotbelow" },
                                                                { .u = 0x1e39, .name = "ldotbelowmacron" },
                                                                { .u = 0x031a, .name = "leftangleabovecmb" },
                                                                { .u = 0x0318, .name = "lefttackbelowcmb" },
                                                                { .u = 0x003c, .name = "less" },
                                                                { .u = 0x2264, .name = "lessequal" },
                                                                { .u = 0x22da, .name = "lessequalorgreater" },
                                                                { .u = 0xff1c, .name = "lessmonospace" },
                                                                { .u = 0x2a7d, .name = "lessorequalslant" },
                                                                { .u = 0x2272, .name = "lessorequivalent" },
                                                                { .u = 0x2276, .name = "lessorgreater" },
                                                                { .u = 0x2266, .name = "lessoverequal" },
                                                                { .u = 0xfe64, .name = "lesssmall" },
                                                                { .u = 0x026e, .name = "lezh" },
                                                                { .u = 0x258c, .name = "lfblock" },
                                                                { .u = 0x026d, .name = "lhookretroflex" },
                                                                { .u = 0x20a4, .name = "lira" },
                                                                { .u = 0x056c, .name = "liwnarmenian" },
                                                                { .u = 0x01c9, .name = "lj" },
                                                                { .u = 0x0459, .name = "ljecyrillic" },
                                                                { .u = 0xf6c0, .name = "ll" },
                                                                { .u = 0x0933, .name = "lladeva" },
                                                                { .u = 0x0ab3, .name = "llagujarati" },
                                                                { .u = 0x1e3b, .name = "llinebelow" },
                                                                { .u = 0x0934, .name = "llladeva" },
                                                                { .u = 0x09e1, .name = "llvocalicbengali" },
                                                                { .u = 0x0961, .name = "llvocalicdeva" },
                                                                { .u = 0x09e3, .name = "llvocalicvowelsignbengali" },
                                                                { .u = 0x0963, .name = "llvocalicvowelsigndeva" },
                                                                { .u = 0x026b, .name = "lmiddletilde" },
                                                                { .u = 0xff4c, .name = "lmonospace" },
                                                                { .u = 0x33d0, .name = "lmsquare" },
                                                                { .u = 0x0e2c, .name = "lochulathai" },
                                                                { .u = 0x2227, .name = "logicaland" },
                                                                { .u = 0x00ac, .name = "logicalnot" },
                                                                { .u = 0x2310, .name = "logicalnotreversed" },
                                                                { .u = 0x2228, .name = "logicalor" },
                                                                { .u = 0x0e25, .name = "lolingthai" },
                                                                { .u = 0x017f, .name = "longs" },
                                                                { .u = 0xfe4e, .name = "lowlinecenterline" },
                                                                { .u = 0x0332, .name = "lowlinecmb" },
                                                                { .u = 0xfe4d, .name = "lowlinedashed" },
                                                                { .u = 0x25ca, .name = "lozenge" },
                                                                { .u = 0x24a7, .name = "lparen" },
                                                                { .u = 0x0142, .name = "lslash" },
                                                                { .u = 0x2113, .name = "lsquare" },
                                                                { .u = 0xf6ee, .name = "lsuperior" },
                                                                { .u = 0x2591, .name = "ltshade" },
                                                                { .u = 0x0e26, .name = "luthai" },
                                                                { .u = 0x098c, .name = "lvocalicbengali" },
                                                                { .u = 0x090c, .name = "lvocalicdeva" },
                                                                { .u = 0x09e2, .name = "lvocalicvowelsignbengali" },
                                                                { .u = 0x0962, .name = "lvocalicvowelsigndeva" },
                                                                { .u = 0x33d3, .name = "lxsquare" },
                                                                { .u = 0x006d, .name = "m" },
                                                                { .u = 0x09ae, .name = "mabengali" },
                                                                { .u = 0x00af, .name = "macron" },
                                                                { .u = 0x0331, .name = "macronbelowcmb" },
                                                                { .u = 0x0304, .name = "macroncmb" },
                                                                { .u = 0x02cd, .name = "macronlowmod" },
                                                                { .u = 0xffe3, .name = "macronmonospace" },
                                                                { .u = 0x1e3f, .name = "macute" },
                                                                { .u = 0x092e, .name = "madeva" },
                                                                { .u = 0x0aae, .name = "magujarati" },
                                                                { .u = 0x0a2e, .name = "magurmukhi" },
                                                                { .u = 0x05a4, .name = "mahapakhhebrew" },
                                                                { .u = 0x05a4, .name = "mahapakhlefthebrew" },
                                                                { .u = 0x307e, .name = "mahiragana" },
                                                                { .u = 0xf895, .name = "maichattawalowleftthai" },
                                                                { .u = 0xf894, .name = "maichattawalowrightthai" },
                                                                { .u = 0x0e4b, .name = "maichattawathai" },
                                                                { .u = 0xf893, .name = "maichattawaupperleftthai" },
                                                                { .u = 0xf88c, .name = "maieklowleftthai" },
                                                                { .u = 0xf88b, .name = "maieklowrightthai" },
                                                                { .u = 0x0e48, .name = "maiekthai" },
                                                                { .u = 0xf88a, .name = "maiekupperleftthai" },
                                                                { .u = 0xf884, .name = "maihanakatleftthai" },
                                                                { .u = 0x0e31, .name = "maihanakatthai" },
                                                                { .u = 0xf889, .name = "maitaikhuleftthai" },
                                                                { .u = 0x0e47, .name = "maitaikhuthai" },
                                                                { .u = 0xf88f, .name = "maitholowleftthai" },
                                                                { .u = 0xf88e, .name = "maitholowrightthai" },
                                                                { .u = 0x0e49, .name = "maithothai" },
                                                                { .u = 0xf88d, .name = "maithoupperleftthai" },
                                                                { .u = 0xf892, .name = "maitrilowleftthai" },
                                                                { .u = 0xf891, .name = "maitrilowrightthai" },
                                                                { .u = 0x0e4a, .name = "maitrithai" },
                                                                { .u = 0xf890, .name = "maitriupperleftthai" },
                                                                { .u = 0x0e46, .name = "maiyamokthai" },
                                                                { .u = 0x30de, .name = "makatakana" },
                                                                { .u = 0xff8f, .name = "makatakanahalfwidth" },
                                                                { .u = 0x2642, .name = "male" },
                                                                { .u = 0x3347, .name = "mansyonsquare" },
                                                                { .u = 0x05be, .name = "maqafhebrew" },
                                                                { .u = 0x2642, .name = "mars" },
                                                                { .u = 0x05af, .name = "masoracirclehebrew" },
                                                                { .u = 0x3383, .name = "masquare" },
                                                                { .u = 0x3107, .name = "mbopomofo" },
                                                                { .u = 0x33d4, .name = "mbsquare" },
                                                                { .u = 0x24dc, .name = "mcircle" },
                                                                { .u = 0x33a5, .name = "mcubedsquare" },
                                                                { .u = 0x1e41, .name = "mdotaccent" },
                                                                { .u = 0x1e43, .name = "mdotbelow" },
                                                                { .u = 0x0645, .name = "meemarabic" },
                                                                { .u = 0xfee2, .name = "meemfinalarabic" },
                                                                { .u = 0xfee3, .name = "meeminitialarabic" },
                                                                { .u = 0xfee4, .name = "meemmedialarabic" },
                                                                { .u = 0xfcd1, .name = "meemmeeminitialarabic" },
                                                                { .u = 0xfc48, .name = "meemmeemisolatedarabic" },
                                                                { .u = 0x334d, .name = "meetorusquare" },
                                                                { .u = 0x3081, .name = "mehiragana" },
                                                                { .u = 0x337e, .name = "meizierasquare" },
                                                                { .u = 0x30e1, .name = "mekatakana" },
                                                                { .u = 0xff92, .name = "mekatakanahalfwidth" },
                                                                { .u = 0x05de, .name = "mem" },
                                                                { .u = 0xfb3e, .name = "memdagesh" },
                                                                { .u = 0xfb3e, .name = "memdageshhebrew" },
                                                                { .u = 0x05de, .name = "memhebrew" },
                                                                { .u = 0x0574, .name = "menarmenian" },
                                                                { .u = 0x05a5, .name = "merkhahebrew" },
                                                                { .u = 0x05a6, .name = "merkhakefulahebrew" },
                                                                { .u = 0x05a6, .name = "merkhakefulalefthebrew" },
                                                                { .u = 0x05a5, .name = "merkhalefthebrew" },
                                                                { .u = 0x0271, .name = "mhook" },
                                                                { .u = 0x3392, .name = "mhzsquare" },
                                                                { .u = 0xff65, .name = "middledotkatakanahalfwidth" },
                                                                { .u = 0x00b7, .name = "middot" },
                                                                { .u = 0x3272, .name = "mieumacirclekorean" },
                                                                { .u = 0x3212, .name = "mieumaparenkorean" },
                                                                { .u = 0x3264, .name = "mieumcirclekorean" },
                                                                { .u = 0x3141, .name = "mieumkorean" },
                                                                { .u = 0x3170, .name = "mieumpansioskorean" },
                                                                { .u = 0x3204, .name = "mieumparenkorean" },
                                                                { .u = 0x316e, .name = "mieumpieupkorean" },
                                                                { .u = 0x316f, .name = "mieumsioskorean" },
                                                                { .u = 0x307f, .name = "mihiragana" },
                                                                { .u = 0x30df, .name = "mikatakana" },
                                                                { .u = 0xff90, .name = "mikatakanahalfwidth" },
                                                                { .u = 0x2212, .name = "minus" },
                                                                { .u = 0x0320, .name = "minusbelowcmb" },
                                                                { .u = 0x2296, .name = "minuscircle" },
                                                                { .u = 0x02d7, .name = "minusmod" },
                                                                { .u = 0x2213, .name = "minusplus" },
                                                                { .u = 0x2032, .name = "minute" },
                                                                { .u = 0x334a, .name = "miribaarusquare" },
                                                                { .u = 0x3349, .name = "mirisquare" },
                                                                { .u = 0x0270, .name = "mlonglegturned" },
                                                                { .u = 0x3396, .name = "mlsquare" },
                                                                { .u = 0x33a3, .name = "mmcubedsquare" },
                                                                { .u = 0xff4d, .name = "mmonospace" },
                                                                { .u = 0x339f, .name = "mmsquaredsquare" },
                                                                { .u = 0x3082, .name = "mohiragana" },
                                                                { .u = 0x33c1, .name = "mohmsquare" },
                                                                { .u = 0x30e2, .name = "mokatakana" },
                                                                { .u = 0xff93, .name = "mokatakanahalfwidth" },
                                                                { .u = 0x33d6, .name = "molsquare" },
                                                                { .u = 0x0e21, .name = "momathai" },
                                                                { .u = 0x33a7, .name = "moverssquare" },
                                                                { .u = 0x33a8, .name = "moverssquaredsquare" },
                                                                { .u = 0x24a8, .name = "mparen" },
                                                                { .u = 0x33ab, .name = "mpasquare" },
                                                                { .u = 0x33b3, .name = "mssquare" },
                                                                { .u = 0xf6ef, .name = "msuperior" },
                                                                { .u = 0x026f, .name = "mturned" },
                                                                { .u = 0x00b5, .name = "mu" },
                                                                { .u = 0x00b5, .name = "mu1" },
                                                                { .u = 0x3382, .name = "muasquare" },
                                                                { .u = 0x226b, .name = "muchgreater" },
                                                                { .u = 0x226a, .name = "muchless" },
                                                                { .u = 0x338c, .name = "mufsquare" },
                                                                { .u = 0x03bc, .name = "mugreek" },
                                                                { .u = 0x338d, .name = "mugsquare" },
                                                                { .u = 0x3080, .name = "muhiragana" },
                                                                { .u = 0x30e0, .name = "mukatakana" },
                                                                { .u = 0xff91, .name = "mukatakanahalfwidth" },
                                                                { .u = 0x3395, .name = "mulsquare" },
                                                                { .u = 0x00d7, .name = "multiply" },
                                                                { .u = 0x339b, .name = "mumsquare" },
                                                                { .u = 0x05a3, .name = "munahhebrew" },
                                                                { .u = 0x05a3, .name = "munahlefthebrew" },
                                                                { .u = 0x266a, .name = "musicalnote" },
                                                                { .u = 0x266b, .name = "musicalnotedbl" },
                                                                { .u = 0x266d, .name = "musicflatsign" },
                                                                { .u = 0x266f, .name = "musicsharpsign" },
                                                                { .u = 0x33b2, .name = "mussquare" },
                                                                { .u = 0x33b6, .name = "muvsquare" },
                                                                { .u = 0x33bc, .name = "muwsquare" },
                                                                { .u = 0x33b9, .name = "mvmegasquare" },
                                                                { .u = 0x33b7, .name = "mvsquare" },
                                                                { .u = 0x33bf, .name = "mwmegasquare" },
                                                                { .u = 0x33bd, .name = "mwsquare" },
                                                                { .u = 0x006e, .name = "n" },
                                                                { .u = 0x09a8, .name = "nabengali" },
                                                                { .u = 0x2207, .name = "nabla" },
                                                                { .u = 0x0144, .name = "nacute" },
                                                                { .u = 0x0928, .name = "nadeva" },
                                                                { .u = 0x0aa8, .name = "nagujarati" },
                                                                { .u = 0x0a28, .name = "nagurmukhi" },
                                                                { .u = 0x306a, .name = "nahiragana" },
                                                                { .u = 0x30ca, .name = "nakatakana" },
                                                                { .u = 0xff85, .name = "nakatakanahalfwidth" },
                                                                { .u = 0x0149, .name = "napostrophe" },
                                                                { .u = 0x3381, .name = "nasquare" },
                                                                { .u = 0x310b, .name = "nbopomofo" },
                                                                { .u = 0x00a0, .name = "nbspace" },
                                                                { .u = 0x0148, .name = "ncaron" },
                                                                { .u = 0x0146, .name = "ncedilla" },
                                                                { .u = 0x24dd, .name = "ncircle" },
                                                                { .u = 0x1e4b, .name = "ncircumflexbelow" },
                                                                { .u = 0x0146, .name = "ncommaaccent" },
                                                                { .u = 0x1e45, .name = "ndotaccent" },
                                                                { .u = 0x1e47, .name = "ndotbelow" },
                                                                { .u = 0x306d, .name = "nehiragana" },
                                                                { .u = 0x30cd, .name = "nekatakana" },
                                                                { .u = 0xff88, .name = "nekatakanahalfwidth" },
                                                                { .u = 0x20aa, .name = "newsheqelsign" },
                                                                { .u = 0x338b, .name = "nfsquare" },
                                                                { .u = 0x0999, .name = "ngabengali" },
                                                                { .u = 0x0919, .name = "ngadeva" },
                                                                { .u = 0x0a99, .name = "ngagujarati" },
                                                                { .u = 0x0a19, .name = "ngagurmukhi" },
                                                                { .u = 0x0e07, .name = "ngonguthai" },
                                                                { .u = 0x3093, .name = "nhiragana" },
                                                                { .u = 0x0272, .name = "nhookleft" },
                                                                { .u = 0x0273, .name = "nhookretroflex" },
                                                                { .u = 0x326f, .name = "nieunacirclekorean" },
                                                                { .u = 0x320f, .name = "nieunaparenkorean" },
                                                                { .u = 0x3135, .name = "nieuncieuckorean" },
                                                                { .u = 0x3261, .name = "nieuncirclekorean" },
                                                                { .u = 0x3136, .name = "nieunhieuhkorean" },
                                                                { .u = 0x3134, .name = "nieunkorean" },
                                                                { .u = 0x3168, .name = "nieunpansioskorean" },
                                                                { .u = 0x3201, .name = "nieunparenkorean" },
                                                                { .u = 0x3167, .name = "nieunsioskorean" },
                                                                { .u = 0x3166, .name = "nieuntikeutkorean" },
                                                                { .u = 0x306b, .name = "nihiragana" },
                                                                { .u = 0x30cb, .name = "nikatakana" },
                                                                { .u = 0xff86, .name = "nikatakanahalfwidth" },
                                                                { .u = 0xf899, .name = "nikhahitleftthai" },
                                                                { .u = 0x0e4d, .name = "nikhahitthai" },
                                                                { .u = 0x0039, .name = "nine" },
                                                                { .u = 0x0669, .name = "ninearabic" },
                                                                { .u = 0x09ef, .name = "ninebengali" },
                                                                { .u = 0x2468, .name = "ninecircle" },
                                                                { .u = 0x2792, .name = "ninecircleinversesansserif" },
                                                                { .u = 0x096f, .name = "ninedeva" },
                                                                { .u = 0x0aef, .name = "ninegujarati" },
                                                                { .u = 0x0a6f, .name = "ninegurmukhi" },
                                                                { .u = 0x0669, .name = "ninehackarabic" },
                                                                { .u = 0x3029, .name = "ninehangzhou" },
                                                                { .u = 0x3228, .name = "nineideographicparen" },
                                                                { .u = 0x2089, .name = "nineinferior" },
                                                                { .u = 0xff19, .name = "ninemonospace" },
                                                                { .u = 0xf739, .name = "nineoldstyle" },
                                                                { .u = 0x247c, .name = "nineparen" },
                                                                { .u = 0x2490, .name = "nineperiod" },
                                                                { .u = 0x06f9, .name = "ninepersian" },
                                                                { .u = 0x2178, .name = "nineroman" },
                                                                { .u = 0x2079, .name = "ninesuperior" },
                                                                { .u = 0x2472, .name = "nineteencircle" },
                                                                { .u = 0x2486, .name = "nineteenparen" },
                                                                { .u = 0x249a, .name = "nineteenperiod" },
                                                                { .u = 0x0e59, .name = "ninethai" },
                                                                { .u = 0x01cc, .name = "nj" },
                                                                { .u = 0x045a, .name = "njecyrillic" },
                                                                { .u = 0x30f3, .name = "nkatakana" },
                                                                { .u = 0xff9d, .name = "nkatakanahalfwidth" },
                                                                { .u = 0x019e, .name = "nlegrightlong" },
                                                                { .u = 0x1e49, .name = "nlinebelow" },
                                                                { .u = 0xff4e, .name = "nmonospace" },
                                                                { .u = 0x339a, .name = "nmsquare" },
                                                                { .u = 0x09a3, .name = "nnabengali" },
                                                                { .u = 0x0923, .name = "nnadeva" },
                                                                { .u = 0x0aa3, .name = "nnagujarati" },
                                                                { .u = 0x0a23, .name = "nnagurmukhi" },
                                                                { .u = 0x0929, .name = "nnnadeva" },
                                                                { .u = 0x306e, .name = "nohiragana" },
                                                                { .u = 0x30ce, .name = "nokatakana" },
                                                                { .u = 0xff89, .name = "nokatakanahalfwidth" },
                                                                { .u = 0x00a0, .name = "nonbreakingspace" },
                                                                { .u = 0x0e13, .name = "nonenthai" },
                                                                { .u = 0x0e19, .name = "nonuthai" },
                                                                { .u = 0x0646, .name = "noonarabic" },
                                                                { .u = 0xfee6, .name = "noonfinalarabic" },
                                                                { .u = 0x06ba, .name = "noonghunnaarabic" },
                                                                { .u = 0xfb9f, .name = "noonghunnafinalarabic" },
                                                                { .u = 0xfee7, .name = "nooninitialarabic" },
                                                                { .u = 0xfcd2, .name = "noonjeeminitialarabic" },
                                                                { .u = 0xfc4b, .name = "noonjeemisolatedarabic" },
                                                                { .u = 0xfee8, .name = "noonmedialarabic" },
                                                                { .u = 0xfcd5, .name = "noonmeeminitialarabic" },
                                                                { .u = 0xfc4e, .name = "noonmeemisolatedarabic" },
                                                                { .u = 0xfc8d, .name = "noonnoonfinalarabic" },
                                                                { .u = 0x220c, .name = "notcontains" },
                                                                { .u = 0x2209, .name = "notelement" },
                                                                { .u = 0x2209, .name = "notelementof" },
                                                                { .u = 0x2260, .name = "notequal" },
                                                                { .u = 0x226f, .name = "notgreater" },
                                                                { .u = 0x2271, .name = "notgreaternorequal" },
                                                                { .u = 0x2279, .name = "notgreaternorless" },
                                                                { .u = 0x2262, .name = "notidentical" },
                                                                { .u = 0x226e, .name = "notless" },
                                                                { .u = 0x2270, .name = "notlessnorequal" },
                                                                { .u = 0x2226, .name = "notparallel" },
                                                                { .u = 0x2280, .name = "notprecedes" },
                                                                { .u = 0x2284, .name = "notsubset" },
                                                                { .u = 0x2281, .name = "notsucceeds" },
                                                                { .u = 0x2285, .name = "notsuperset" },
                                                                { .u = 0x0576, .name = "nowarmenian" },
                                                                { .u = 0x24a9, .name = "nparen" },
                                                                { .u = 0x33b1, .name = "nssquare" },
                                                                { .u = 0x207f, .name = "nsuperior" },
                                                                { .u = 0x00f1, .name = "ntilde" },
                                                                { .u = 0x03bd, .name = "nu" },
                                                                { .u = 0x306c, .name = "nuhiragana" },
                                                                { .u = 0x30cc, .name = "nukatakana" },
                                                                { .u = 0xff87, .name = "nukatakanahalfwidth" },
                                                                { .u = 0x09bc, .name = "nuktabengali" },
                                                                { .u = 0x093c, .name = "nuktadeva" },
                                                                { .u = 0x0abc, .name = "nuktagujarati" },
                                                                { .u = 0x0a3c, .name = "nuktagurmukhi" },
                                                                { .u = 0x0023, .name = "numbersign" },
                                                                { .u = 0xff03, .name = "numbersignmonospace" },
                                                                { .u = 0xfe5f, .name = "numbersignsmall" },
                                                                { .u = 0x0374, .name = "numeralsigngreek" },
                                                                { .u = 0x0375, .name = "numeralsignlowergreek" },
                                                                { .u = 0x2116, .name = "numero" },
                                                                { .u = 0x05e0, .name = "nun" },
                                                                { .u = 0xfb40, .name = "nundagesh" },
                                                                { .u = 0xfb40, .name = "nundageshhebrew" },
                                                                { .u = 0x05e0, .name = "nunhebrew" },
                                                                { .u = 0x33b5, .name = "nvsquare" },
                                                                { .u = 0x33bb, .name = "nwsquare" },
                                                                { .u = 0x099e, .name = "nyabengali" },
                                                                { .u = 0x091e, .name = "nyadeva" },
                                                                { .u = 0x0a9e, .name = "nyagujarati" },
                                                                { .u = 0x0a1e, .name = "nyagurmukhi" },
                                                                { .u = 0x006f, .name = "o" },
                                                                { .u = 0x00f3, .name = "oacute" },
                                                                { .u = 0x0e2d, .name = "oangthai" },
                                                                { .u = 0x0275, .name = "obarred" },
                                                                { .u = 0x04e9, .name = "obarredcyrillic" },
                                                                { .u = 0x04eb, .name = "obarreddieresiscyrillic" },
                                                                { .u = 0x0993, .name = "obengali" },
                                                                { .u = 0x311b, .name = "obopomofo" },
                                                                { .u = 0x014f, .name = "obreve" },
                                                                { .u = 0x0911, .name = "ocandradeva" },
                                                                { .u = 0x0a91, .name = "ocandragujarati" },
                                                                { .u = 0x0949, .name = "ocandravowelsigndeva" },
                                                                { .u = 0x0ac9, .name = "ocandravowelsigngujarati" },
                                                                { .u = 0x01d2, .name = "ocaron" },
                                                                { .u = 0x24de, .name = "ocircle" },
                                                                { .u = 0x00f4, .name = "ocircumflex" },
                                                                { .u = 0x1ed1, .name = "ocircumflexacute" },
                                                                { .u = 0x1ed9, .name = "ocircumflexdotbelow" },
                                                                { .u = 0x1ed3, .name = "ocircumflexgrave" },
                                                                { .u = 0x1ed5, .name = "ocircumflexhookabove" },
                                                                { .u = 0x1ed7, .name = "ocircumflextilde" },
                                                                { .u = 0x043e, .name = "ocyrillic" },
                                                                { .u = 0x0151, .name = "odblacute" },
                                                                { .u = 0x020d, .name = "odblgrave" },
                                                                { .u = 0x0913, .name = "odeva" },
                                                                { .u = 0x00f6, .name = "odieresis" },
                                                                { .u = 0x04e7, .name = "odieresiscyrillic" },
                                                                { .u = 0x1ecd, .name = "odotbelow" },
                                                                { .u = 0x0153, .name = "oe" },
                                                                { .u = 0x315a, .name = "oekorean" },
                                                                { .u = 0x02db, .name = "ogonek" },
                                                                { .u = 0x0328, .name = "ogonekcmb" },
                                                                { .u = 0x00f2, .name = "ograve" },
                                                                { .u = 0x0a93, .name = "ogujarati" },
                                                                { .u = 0x0585, .name = "oharmenian" },
                                                                { .u = 0x304a, .name = "ohiragana" },
                                                                { .u = 0x1ecf, .name = "ohookabove" },
                                                                { .u = 0x01a1, .name = "ohorn" },
                                                                { .u = 0x1edb, .name = "ohornacute" },
                                                                { .u = 0x1ee3, .name = "ohorndotbelow" },
                                                                { .u = 0x1edd, .name = "ohorngrave" },
                                                                { .u = 0x1edf, .name = "ohornhookabove" },
                                                                { .u = 0x1ee1, .name = "ohorntilde" },
                                                                { .u = 0x0151, .name = "ohungarumlaut" },
                                                                { .u = 0x01a3, .name = "oi" },
                                                                { .u = 0x020f, .name = "oinvertedbreve" },
                                                                { .u = 0x30aa, .name = "okatakana" },
                                                                { .u = 0xff75, .name = "okatakanahalfwidth" },
                                                                { .u = 0x3157, .name = "okorean" },
                                                                { .u = 0x05ab, .name = "olehebrew" },
                                                                { .u = 0x014d, .name = "omacron" },
                                                                { .u = 0x1e53, .name = "omacronacute" },
                                                                { .u = 0x1e51, .name = "omacrongrave" },
                                                                { .u = 0x0950, .name = "omdeva" },
                                                                { .u = 0x03c9, .name = "omega" },
                                                                { .u = 0x03d6, .name = "omega1" },
                                                                { .u = 0x0461, .name = "omegacyrillic" },
                                                                { .u = 0x0277, .name = "omegalatinclosed" },
                                                                { .u = 0x047b, .name = "omegaroundcyrillic" },
                                                                { .u = 0x047d, .name = "omegatitlocyrillic" },
                                                                { .u = 0x03ce, .name = "omegatonos" },
                                                                { .u = 0x0ad0, .name = "omgujarati" },
                                                                { .u = 0x03bf, .name = "omicron" },
                                                                { .u = 0x03cc, .name = "omicrontonos" },
                                                                { .u = 0xff4f, .name = "omonospace" },
                                                                { .u = 0x0031, .name = "one" },
                                                                { .u = 0x0661, .name = "onearabic" },
                                                                { .u = 0x09e7, .name = "onebengali" },
                                                                { .u = 0x2460, .name = "onecircle" },
                                                                { .u = 0x278a, .name = "onecircleinversesansserif" },
                                                                { .u = 0x0967, .name = "onedeva" },
                                                                { .u = 0x2024, .name = "onedotenleader" },
                                                                { .u = 0x215b, .name = "oneeighth" },
                                                                { .u = 0xf6dc, .name = "onefitted" },
                                                                { .u = 0x0ae7, .name = "onegujarati" },
                                                                { .u = 0x0a67, .name = "onegurmukhi" },
                                                                { .u = 0x0661, .name = "onehackarabic" },
                                                                { .u = 0x00bd, .name = "onehalf" },
                                                                { .u = 0x3021, .name = "onehangzhou" },
                                                                { .u = 0x3220, .name = "oneideographicparen" },
                                                                { .u = 0x2081, .name = "oneinferior" },
                                                                { .u = 0xff11, .name = "onemonospace" },
                                                                { .u = 0x09f4, .name = "onenumeratorbengali" },
                                                                { .u = 0xf731, .name = "oneoldstyle" },
                                                                { .u = 0x2474, .name = "oneparen" },
                                                                { .u = 0x2488, .name = "oneperiod" },
                                                                { .u = 0x06f1, .name = "onepersian" },
                                                                { .u = 0x00bc, .name = "onequarter" },
                                                                { .u = 0x2170, .name = "oneroman" },
                                                                { .u = 0x00b9, .name = "onesuperior" },
                                                                { .u = 0x0e51, .name = "onethai" },
                                                                { .u = 0x2153, .name = "onethird" },
                                                                { .u = 0x01eb, .name = "oogonek" },
                                                                { .u = 0x01ed, .name = "oogonekmacron" },
                                                                { .u = 0x0a13, .name = "oogurmukhi" },
                                                                { .u = 0x0a4b, .name = "oomatragurmukhi" },
                                                                { .u = 0x0254, .name = "oopen" },
                                                                { .u = 0x24aa, .name = "oparen" },
                                                                { .u = 0x25e6, .name = "openbullet" },
                                                                { .u = 0x2325, .name = "option" },
                                                                { .u = 0x00aa, .name = "ordfeminine" },
                                                                { .u = 0x00ba, .name = "ordmasculine" },
                                                                { .u = 0x221f, .name = "orthogonal" },
                                                                { .u = 0x0912, .name = "oshortdeva" },
                                                                { .u = 0x094a, .name = "oshortvowelsigndeva" },
                                                                { .u = 0x00f8, .name = "oslash" },
                                                                { .u = 0x01ff, .name = "oslashacute" },
                                                                { .u = 0x3049, .name = "osmallhiragana" },
                                                                { .u = 0x30a9, .name = "osmallkatakana" },
                                                                { .u = 0xff6b, .name = "osmallkatakanahalfwidth" },
                                                                { .u = 0x01ff, .name = "ostrokeacute" },
                                                                { .u = 0xf6f0, .name = "osuperior" },
                                                                { .u = 0x047f, .name = "otcyrillic" },
                                                                { .u = 0x00f5, .name = "otilde" },
                                                                { .u = 0x1e4d, .name = "otildeacute" },
                                                                { .u = 0x1e4f, .name = "otildedieresis" },
                                                                { .u = 0x3121, .name = "oubopomofo" },
                                                                { .u = 0x203e, .name = "overline" },
                                                                { .u = 0xfe4a, .name = "overlinecenterline" },
                                                                { .u = 0x0305, .name = "overlinecmb" },
                                                                { .u = 0xfe49, .name = "overlinedashed" },
                                                                { .u = 0xfe4c, .name = "overlinedblwavy" },
                                                                { .u = 0xfe4b, .name = "overlinewavy" },
                                                                { .u = 0x00af, .name = "overscore" },
                                                                { .u = 0x09cb, .name = "ovowelsignbengali" },
                                                                { .u = 0x094b, .name = "ovowelsigndeva" },
                                                                { .u = 0x0acb, .name = "ovowelsigngujarati" },
                                                                { .u = 0x0070, .name = "p" },
                                                                { .u = 0x3380, .name = "paampssquare" },
                                                                { .u = 0x332b, .name = "paasentosquare" },
                                                                { .u = 0x09aa, .name = "pabengali" },
                                                                { .u = 0x1e55, .name = "pacute" },
                                                                { .u = 0x092a, .name = "padeva" },
                                                                { .u = 0x21df, .name = "pagedown" },
                                                                { .u = 0x21de, .name = "pageup" },
                                                                { .u = 0x0aaa, .name = "pagujarati" },
                                                                { .u = 0x0a2a, .name = "pagurmukhi" },
                                                                { .u = 0x3071, .name = "pahiragana" },
                                                                { .u = 0x0e2f, .name = "paiyannoithai" },
                                                                { .u = 0x30d1, .name = "pakatakana" },
                                                                { .u = 0x0484, .name = "palatalizationcyrilliccmb" },
                                                                { .u = 0x04c0, .name = "palochkacyrillic" },
                                                                { .u = 0x317f, .name = "pansioskorean" },
                                                                { .u = 0x00b6, .name = "paragraph" },
                                                                { .u = 0x2225, .name = "parallel" },
                                                                { .u = 0x0028, .name = "parenleft" },
                                                                { .u = 0xfd3e, .name = "parenleftaltonearabic" },
                                                                { .u = 0xf8ed, .name = "parenleftbt" },
                                                                { .u = 0xf8ec, .name = "parenleftex" },
                                                                { .u = 0x208d, .name = "parenleftinferior" },
                                                                { .u = 0xff08, .name = "parenleftmonospace" },
                                                                { .u = 0xfe59, .name = "parenleftsmall" },
                                                                { .u = 0x207d, .name = "parenleftsuperior" },
                                                                { .u = 0xf8eb, .name = "parenlefttp" },
                                                                { .u = 0xfe35, .name = "parenleftvertical" },
                                                                { .u = 0x0029, .name = "parenright" },
                                                                { .u = 0xfd3f, .name = "parenrightaltonearabic" },
                                                                { .u = 0xf8f8, .name = "parenrightbt" },
                                                                { .u = 0xf8f7, .name = "parenrightex" },
                                                                { .u = 0x208e, .name = "parenrightinferior" },
                                                                { .u = 0xff09, .name = "parenrightmonospace" },
                                                                { .u = 0xfe5a, .name = "parenrightsmall" },
                                                                { .u = 0x207e, .name = "parenrightsuperior" },
                                                                { .u = 0xf8f6, .name = "parenrighttp" },
                                                                { .u = 0xfe36, .name = "parenrightvertical" },
                                                                { .u = 0x2202, .name = "partialdiff" },
                                                                { .u = 0x05c0, .name = "paseqhebrew" },
                                                                { .u = 0x0599, .name = "pashtahebrew" },
                                                                { .u = 0x33a9, .name = "pasquare" },
                                                                { .u = 0x05b7, .name = "patah" },
                                                                { .u = 0x05b7, .name = "patah11" },
                                                                { .u = 0x05b7, .name = "patah1d" },
                                                                { .u = 0x05b7, .name = "patah2a" },
                                                                { .u = 0x05b7, .name = "patahhebrew" },
                                                                { .u = 0x05b7, .name = "patahnarrowhebrew" },
                                                                { .u = 0x05b7, .name = "patahquarterhebrew" },
                                                                { .u = 0x05b7, .name = "patahwidehebrew" },
                                                                { .u = 0x05a1, .name = "pazerhebrew" },
                                                                { .u = 0x3106, .name = "pbopomofo" },
                                                                { .u = 0x24df, .name = "pcircle" },
                                                                { .u = 0x1e57, .name = "pdotaccent" },
                                                                { .u = 0x05e4, .name = "pe" },
                                                                { .u = 0x043f, .name = "pecyrillic" },
                                                                { .u = 0xfb44, .name = "pedagesh" },
                                                                { .u = 0xfb44, .name = "pedageshhebrew" },
                                                                { .u = 0x333b, .name = "peezisquare" },
                                                                { .u = 0xfb43, .name = "pefinaldageshhebrew" },
                                                                { .u = 0x067e, .name = "peharabic" },
                                                                { .u = 0x057a, .name = "peharmenian" },
                                                                { .u = 0x05e4, .name = "pehebrew" },
                                                                { .u = 0xfb57, .name = "pehfinalarabic" },
                                                                { .u = 0xfb58, .name = "pehinitialarabic" },
                                                                { .u = 0x307a, .name = "pehiragana" },
                                                                { .u = 0xfb59, .name = "pehmedialarabic" },
                                                                { .u = 0x30da, .name = "pekatakana" },
                                                                { .u = 0x04a7, .name = "pemiddlehookcyrillic" },
                                                                { .u = 0xfb4e, .name = "perafehebrew" },
                                                                { .u = 0x0025, .name = "percent" },
                                                                { .u = 0x066a, .name = "percentarabic" },
                                                                { .u = 0xff05, .name = "percentmonospace" },
                                                                { .u = 0xfe6a, .name = "percentsmall" },
                                                                { .u = 0x002e, .name = "period" },
                                                                { .u = 0x0589, .name = "periodarmenian" },
                                                                { .u = 0x00b7, .name = "periodcentered" },
                                                                { .u = 0xff61, .name = "periodhalfwidth" },
                                                                { .u = 0xf6e7, .name = "periodinferior" },
                                                                { .u = 0xff0e, .name = "periodmonospace" },
                                                                { .u = 0xfe52, .name = "periodsmall" },
                                                                { .u = 0xf6e8, .name = "periodsuperior" },
                                                                { .u = 0x0342, .name = "perispomenigreekcmb" },
                                                                { .u = 0x22a5, .name = "perpendicular" },
                                                                { .u = 0x2030, .name = "perthousand" },
                                                                { .u = 0x20a7, .name = "peseta" },
                                                                { .u = 0x338a, .name = "pfsquare" },
                                                                { .u = 0x09ab, .name = "phabengali" },
                                                                { .u = 0x092b, .name = "phadeva" },
                                                                { .u = 0x0aab, .name = "phagujarati" },
                                                                { .u = 0x0a2b, .name = "phagurmukhi" },
                                                                { .u = 0x03c6, .name = "phi" },
                                                                { .u = 0x03d5, .name = "phi1" },
                                                                { .u = 0x327a, .name = "phieuphacirclekorean" },
                                                                { .u = 0x321a, .name = "phieuphaparenkorean" },
                                                                { .u = 0x326c, .name = "phieuphcirclekorean" },
                                                                { .u = 0x314d, .name = "phieuphkorean" },
                                                                { .u = 0x320c, .name = "phieuphparenkorean" },
                                                                { .u = 0x0278, .name = "philatin" },
                                                                { .u = 0x0e3a, .name = "phinthuthai" },
                                                                { .u = 0x03d5, .name = "phisymbolgreek" },
                                                                { .u = 0x01a5, .name = "phook" },
                                                                { .u = 0x0e1e, .name = "phophanthai" },
                                                                { .u = 0x0e1c, .name = "phophungthai" },
                                                                { .u = 0x0e20, .name = "phosamphaothai" },
                                                                { .u = 0x03c0, .name = "pi" },
                                                                { .u = 0x3273, .name = "pieupacirclekorean" },
                                                                { .u = 0x3213, .name = "pieupaparenkorean" },
                                                                { .u = 0x3176, .name = "pieupcieuckorean" },
                                                                { .u = 0x3265, .name = "pieupcirclekorean" },
                                                                { .u = 0x3172, .name = "pieupkiyeokkorean" },
                                                                { .u = 0x3142, .name = "pieupkorean" },
                                                                { .u = 0x3205, .name = "pieupparenkorean" },
                                                                { .u = 0x3174, .name = "pieupsioskiyeokkorean" },
                                                                { .u = 0x3144, .name = "pieupsioskorean" },
                                                                { .u = 0x3175, .name = "pieupsiostikeutkorean" },
                                                                { .u = 0x3177, .name = "pieupthieuthkorean" },
                                                                { .u = 0x3173, .name = "pieuptikeutkorean" },
                                                                { .u = 0x3074, .name = "pihiragana" },
                                                                { .u = 0x30d4, .name = "pikatakana" },
                                                                { .u = 0x03d6, .name = "pisymbolgreek" },
                                                                { .u = 0x0583, .name = "piwrarmenian" },
                                                                { .u = 0x002b, .name = "plus" },
                                                                { .u = 0x031f, .name = "plusbelowcmb" },
                                                                { .u = 0x2295, .name = "pluscircle" },
                                                                { .u = 0x00b1, .name = "plusminus" },
                                                                { .u = 0x02d6, .name = "plusmod" },
                                                                { .u = 0xff0b, .name = "plusmonospace" },
                                                                { .u = 0xfe62, .name = "plussmall" },
                                                                { .u = 0x207a, .name = "plussuperior" },
                                                                { .u = 0xff50, .name = "pmonospace" },
                                                                { .u = 0x33d8, .name = "pmsquare" },
                                                                { .u = 0x307d, .name = "pohiragana" },
                                                                { .u = 0x261f, .name = "pointingindexdownwhite" },
                                                                { .u = 0x261c, .name = "pointingindexleftwhite" },
                                                                { .u = 0x261e, .name = "pointingindexrightwhite" },
                                                                { .u = 0x261d, .name = "pointingindexupwhite" },
                                                                { .u = 0x30dd, .name = "pokatakana" },
                                                                { .u = 0x0e1b, .name = "poplathai" },
                                                                { .u = 0x3012, .name = "postalmark" },
                                                                { .u = 0x3020, .name = "postalmarkface" },
                                                                { .u = 0x24ab, .name = "pparen" },
                                                                { .u = 0x227a, .name = "precedes" },
                                                                { .u = 0x211e, .name = "prescription" },
                                                                { .u = 0x02b9, .name = "primemod" },
                                                                { .u = 0x2035, .name = "primereversed" },
                                                                { .u = 0x220f, .name = "product" },
                                                                { .u = 0x2305, .name = "projective" },
                                                                { .u = 0x30fc, .name = "prolongedkana" },
                                                                { .u = 0x2318, .name = "propellor" },
                                                                { .u = 0x2282, .name = "propersubset" },
                                                                { .u = 0x2283, .name = "propersuperset" },
                                                                { .u = 0x2237, .name = "proportion" },
                                                                { .u = 0x221d, .name = "proportional" },
                                                                { .u = 0x03c8, .name = "psi" },
                                                                { .u = 0x0471, .name = "psicyrillic" },
                                                                { .u = 0x0486, .name = "psilipneumatacyrilliccmb" },
                                                                { .u = 0x33b0, .name = "pssquare" },
                                                                { .u = 0x3077, .name = "puhiragana" },
                                                                { .u = 0x30d7, .name = "pukatakana" },
                                                                { .u = 0x33b4, .name = "pvsquare" },
                                                                { .u = 0x33ba, .name = "pwsquare" },
                                                                { .u = 0x0071, .name = "q" },
                                                                { .u = 0x0958, .name = "qadeva" },
                                                                { .u = 0x05a8, .name = "qadmahebrew" },
                                                                { .u = 0x0642, .name = "qafarabic" },
                                                                { .u = 0xfed6, .name = "qaffinalarabic" },
                                                                { .u = 0xfed7, .name = "qafinitialarabic" },
                                                                { .u = 0xfed8, .name = "qafmedialarabic" },
                                                                { .u = 0x05b8, .name = "qamats" },
                                                                { .u = 0x05b8, .name = "qamats10" },
                                                                { .u = 0x05b8, .name = "qamats1a" },
                                                                { .u = 0x05b8, .name = "qamats1c" },
                                                                { .u = 0x05b8, .name = "qamats27" },
                                                                { .u = 0x05b8, .name = "qamats29" },
                                                                { .u = 0x05b8, .name = "qamats33" },
                                                                { .u = 0x05b8, .name = "qamatsde" },
                                                                { .u = 0x05b8, .name = "qamatshebrew" },
                                                                { .u = 0x05b8, .name = "qamatsnarrowhebrew" },
                                                                { .u = 0x05b8, .name = "qamatsqatanhebrew" },
                                                                { .u = 0x05b8, .name = "qamatsqatannarrowhebrew" },
                                                                { .u = 0x05b8, .name = "qamatsqatanquarterhebrew" },
                                                                { .u = 0x05b8, .name = "qamatsqatanwidehebrew" },
                                                                { .u = 0x05b8, .name = "qamatsquarterhebrew" },
                                                                { .u = 0x05b8, .name = "qamatswidehebrew" },
                                                                { .u = 0x059f, .name = "qarneyparahebrew" },
                                                                { .u = 0x3111, .name = "qbopomofo" },
                                                                { .u = 0x24e0, .name = "qcircle" },
                                                                { .u = 0x02a0, .name = "qhook" },
                                                                { .u = 0xff51, .name = "qmonospace" },
                                                                { .u = 0x05e7, .name = "qof" },
                                                                { .u = 0xfb47, .name = "qofdagesh" },
                                                                { .u = 0xfb47, .name = "qofdageshhebrew" },
                                                                { .u = 0x05e7, .name = "qofhebrew" },
                                                                { .u = 0x24ac, .name = "qparen" },
                                                                { .u = 0x2669, .name = "quarternote" },
                                                                { .u = 0x05bb, .name = "qubuts" },
                                                                { .u = 0x05bb, .name = "qubuts18" },
                                                                { .u = 0x05bb, .name = "qubuts25" },
                                                                { .u = 0x05bb, .name = "qubuts31" },
                                                                { .u = 0x05bb, .name = "qubutshebrew" },
                                                                { .u = 0x05bb, .name = "qubutsnarrowhebrew" },
                                                                { .u = 0x05bb, .name = "qubutsquarterhebrew" },
                                                                { .u = 0x05bb, .name = "qubutswidehebrew" },
                                                                { .u = 0x003f, .name = "question" },
                                                                { .u = 0x061f, .name = "questionarabic" },
                                                                { .u = 0x055e, .name = "questionarmenian" },
                                                                { .u = 0x00bf, .name = "questiondown" },
                                                                { .u = 0xf7bf, .name = "questiondownsmall" },
                                                                { .u = 0x037e, .name = "questiongreek" },
                                                                { .u = 0xff1f, .name = "questionmonospace" },
                                                                { .u = 0xf73f, .name = "questionsmall" },
                                                                { .u = 0x0022, .name = "quotedbl" },
                                                                { .u = 0x201e, .name = "quotedblbase" },
                                                                { .u = 0x201c, .name = "quotedblleft" },
                                                                { .u = 0xff02, .name = "quotedblmonospace" },
                                                                { .u = 0x301e, .name = "quotedblprime" },
                                                                { .u = 0x301d, .name = "quotedblprimereversed" },
                                                                { .u = 0x201d, .name = "quotedblright" },
                                                                { .u = 0x2018, .name = "quoteleft" },
                                                                { .u = 0x201b, .name = "quoteleftreversed" },
                                                                { .u = 0x201b, .name = "quotereversed" },
                                                                { .u = 0x2019, .name = "quoteright" },
                                                                { .u = 0x0149, .name = "quoterightn" },
                                                                { .u = 0x201a, .name = "quotesinglbase" },
                                                                { .u = 0x0027, .name = "quotesingle" },
                                                                { .u = 0xff07, .name = "quotesinglemonospace" },
                                                                { .u = 0x0072, .name = "r" },
                                                                { .u = 0x057c, .name = "raarmenian" },
                                                                { .u = 0x09b0, .name = "rabengali" },
                                                                { .u = 0x0155, .name = "racute" },
                                                                { .u = 0x0930, .name = "radeva" },
                                                                { .u = 0x221a, .name = "radical" },
                                                                { .u = 0xf8e5, .name = "radicalex" },
                                                                { .u = 0x33ae, .name = "radoverssquare" },
                                                                { .u = 0x33af, .name = "radoverssquaredsquare" },
                                                                { .u = 0x33ad, .name = "radsquare" },
                                                                { .u = 0x05bf, .name = "rafe" },
                                                                { .u = 0x05bf, .name = "rafehebrew" },
                                                                { .u = 0x0ab0, .name = "ragujarati" },
                                                                { .u = 0x0a30, .name = "ragurmukhi" },
                                                                { .u = 0x3089, .name = "rahiragana" },
                                                                { .u = 0x30e9, .name = "rakatakana" },
                                                                { .u = 0xff97, .name = "rakatakanahalfwidth" },
                                                                { .u = 0x09f1, .name = "ralowerdiagonalbengali" },
                                                                { .u = 0x09f0, .name = "ramiddlediagonalbengali" },
                                                                { .u = 0x0264, .name = "ramshorn" },
                                                                { .u = 0x2236, .name = "ratio" },
                                                                { .u = 0x3116, .name = "rbopomofo" },
                                                                { .u = 0x0159, .name = "rcaron" },
                                                                { .u = 0x0157, .name = "rcedilla" },
                                                                { .u = 0x24e1, .name = "rcircle" },
                                                                { .u = 0x0157, .name = "rcommaaccent" },
                                                                { .u = 0x0211, .name = "rdblgrave" },
                                                                { .u = 0x1e59, .name = "rdotaccent" },
                                                                { .u = 0x1e5b, .name = "rdotbelow" },
                                                                { .u = 0x1e5d, .name = "rdotbelowmacron" },
                                                                { .u = 0x203b, .name = "referencemark" },
                                                                { .u = 0x2286, .name = "reflexsubset" },
                                                                { .u = 0x2287, .name = "reflexsuperset" },
                                                                { .u = 0x00ae, .name = "registered" },
                                                                { .u = 0xf8e8, .name = "registersans" },
                                                                { .u = 0xf6da, .name = "registerserif" },
                                                                { .u = 0x0631, .name = "reharabic" },
                                                                { .u = 0x0580, .name = "reharmenian" },
                                                                { .u = 0xfeae, .name = "rehfinalarabic" },
                                                                { .u = 0x308c, .name = "rehiragana" },
                                                                { .u = 0x30ec, .name = "rekatakana" },
                                                                { .u = 0xff9a, .name = "rekatakanahalfwidth" },
                                                                { .u = 0x05e8, .name = "resh" },
                                                                { .u = 0xfb48, .name = "reshdageshhebrew" },
                                                                { .u = 0x05e8, .name = "reshhebrew" },
                                                                { .u = 0x223d, .name = "reversedtilde" },
                                                                { .u = 0x0597, .name = "reviahebrew" },
                                                                { .u = 0x0597, .name = "reviamugrashhebrew" },
                                                                { .u = 0x2310, .name = "revlogicalnot" },
                                                                { .u = 0x027e, .name = "rfishhook" },
                                                                { .u = 0x027f, .name = "rfishhookreversed" },
                                                                { .u = 0x09dd, .name = "rhabengali" },
                                                                { .u = 0x095d, .name = "rhadeva" },
                                                                { .u = 0x03c1, .name = "rho" },
                                                                { .u = 0x027d, .name = "rhook" },
                                                                { .u = 0x027b, .name = "rhookturned" },
                                                                { .u = 0x02b5, .name = "rhookturnedsuperior" },
                                                                { .u = 0x03f1, .name = "rhosymbolgreek" },
                                                                { .u = 0x02de, .name = "rhotichookmod" },
                                                                { .u = 0x3271, .name = "rieulacirclekorean" },
                                                                { .u = 0x3211, .name = "rieulaparenkorean" },
                                                                { .u = 0x3263, .name = "rieulcirclekorean" },
                                                                { .u = 0x3140, .name = "rieulhieuhkorean" },
                                                                { .u = 0x313a, .name = "rieulkiyeokkorean" },
                                                                { .u = 0x3169, .name = "rieulkiyeoksioskorean" },
                                                                { .u = 0x3139, .name = "rieulkorean" },
                                                                { .u = 0x313b, .name = "rieulmieumkorean" },
                                                                { .u = 0x316c, .name = "rieulpansioskorean" },
                                                                { .u = 0x3203, .name = "rieulparenkorean" },
                                                                { .u = 0x313f, .name = "rieulphieuphkorean" },
                                                                { .u = 0x313c, .name = "rieulpieupkorean" },
                                                                { .u = 0x316b, .name = "rieulpieupsioskorean" },
                                                                { .u = 0x313d, .name = "rieulsioskorean" },
                                                                { .u = 0x313e, .name = "rieulthieuthkorean" },
                                                                { .u = 0x316a, .name = "rieultikeutkorean" },
                                                                { .u = 0x316d, .name = "rieulyeorinhieuhkorean" },
                                                                { .u = 0x221f, .name = "rightangle" },
                                                                { .u = 0x0319, .name = "righttackbelowcmb" },
                                                                { .u = 0x22bf, .name = "righttriangle" },
                                                                { .u = 0x308a, .name = "rihiragana" },
                                                                { .u = 0x30ea, .name = "rikatakana" },
                                                                { .u = 0xff98, .name = "rikatakanahalfwidth" },
                                                                { .u = 0x02da, .name = "ring" },
                                                                { .u = 0x0325, .name = "ringbelowcmb" },
                                                                { .u = 0x030a, .name = "ringcmb" },
                                                                { .u = 0x02bf, .name = "ringhalfleft" },
                                                                { .u = 0x0559, .name = "ringhalfleftarmenian" },
                                                                { .u = 0x031c, .name = "ringhalfleftbelowcmb" },
                                                                { .u = 0x02d3, .name = "ringhalfleftcentered" },
                                                                { .u = 0x02be, .name = "ringhalfright" },
                                                                { .u = 0x0339, .name = "ringhalfrightbelowcmb" },
                                                                { .u = 0x02d2, .name = "ringhalfrightcentered" },
                                                                { .u = 0x0213, .name = "rinvertedbreve" },
                                                                { .u = 0x3351, .name = "rittorusquare" },
                                                                { .u = 0x1e5f, .name = "rlinebelow" },
                                                                { .u = 0x027c, .name = "rlongleg" },
                                                                { .u = 0x027a, .name = "rlonglegturned" },
                                                                { .u = 0xff52, .name = "rmonospace" },
                                                                { .u = 0x308d, .name = "rohiragana" },
                                                                { .u = 0x30ed, .name = "rokatakana" },
                                                                { .u = 0xff9b, .name = "rokatakanahalfwidth" },
                                                                { .u = 0x0e23, .name = "roruathai" },
                                                                { .u = 0x24ad, .name = "rparen" },
                                                                { .u = 0x09dc, .name = "rrabengali" },
                                                                { .u = 0x0931, .name = "rradeva" },
                                                                { .u = 0x0a5c, .name = "rragurmukhi" },
                                                                { .u = 0x0691, .name = "rreharabic" },
                                                                { .u = 0xfb8d, .name = "rrehfinalarabic" },
                                                                { .u = 0x09e0, .name = "rrvocalicbengali" },
                                                                { .u = 0x0960, .name = "rrvocalicdeva" },
                                                                { .u = 0x0ae0, .name = "rrvocalicgujarati" },
                                                                { .u = 0x09c4, .name = "rrvocalicvowelsignbengali" },
                                                                { .u = 0x0944, .name = "rrvocalicvowelsigndeva" },
                                                                { .u = 0x0ac4, .name = "rrvocalicvowelsigngujarati" },
                                                                { .u = 0xf6f1, .name = "rsuperior" },
                                                                { .u = 0x2590, .name = "rtblock" },
                                                                { .u = 0x0279, .name = "rturned" },
                                                                { .u = 0x02b4, .name = "rturnedsuperior" },
                                                                { .u = 0x308b, .name = "ruhiragana" },
                                                                { .u = 0x30eb, .name = "rukatakana" },
                                                                { .u = 0xff99, .name = "rukatakanahalfwidth" },
                                                                { .u = 0x09f2, .name = "rupeemarkbengali" },
                                                                { .u = 0x09f3, .name = "rupeesignbengali" },
                                                                { .u = 0xf6dd, .name = "rupiah" },
                                                                { .u = 0x0e24, .name = "ruthai" },
                                                                { .u = 0x098b, .name = "rvocalicbengali" },
                                                                { .u = 0x090b, .name = "rvocalicdeva" },
                                                                { .u = 0x0a8b, .name = "rvocalicgujarati" },
                                                                { .u = 0x09c3, .name = "rvocalicvowelsignbengali" },
                                                                { .u = 0x0943, .name = "rvocalicvowelsigndeva" },
                                                                { .u = 0x0ac3, .name = "rvocalicvowelsigngujarati" },
                                                                { .u = 0x0073, .name = "s" },
                                                                { .u = 0x09b8, .name = "sabengali" },
                                                                { .u = 0x015b, .name = "sacute" },
                                                                { .u = 0x1e65, .name = "sacutedotaccent" },
                                                                { .u = 0x0635, .name = "sadarabic" },
                                                                { .u = 0x0938, .name = "sadeva" },
                                                                { .u = 0xfeba, .name = "sadfinalarabic" },
                                                                { .u = 0xfebb, .name = "sadinitialarabic" },
                                                                { .u = 0xfebc, .name = "sadmedialarabic" },
                                                                { .u = 0x0ab8, .name = "sagujarati" },
                                                                { .u = 0x0a38, .name = "sagurmukhi" },
                                                                { .u = 0x3055, .name = "sahiragana" },
                                                                { .u = 0x30b5, .name = "sakatakana" },
                                                                { .u = 0xff7b, .name = "sakatakanahalfwidth" },
                                                                { .u = 0xfdfa, .name = "sallallahoualayhewasallamarabic" },
                                                                { .u = 0x05e1, .name = "samekh" },
                                                                { .u = 0xfb41, .name = "samekhdagesh" },
                                                                { .u = 0xfb41, .name = "samekhdageshhebrew" },
                                                                { .u = 0x05e1, .name = "samekhhebrew" },
                                                                { .u = 0x0e32, .name = "saraaathai" },
                                                                { .u = 0x0e41, .name = "saraaethai" },
                                                                { .u = 0x0e44, .name = "saraaimaimalaithai" },
                                                                { .u = 0x0e43, .name = "saraaimaimuanthai" },
                                                                { .u = 0x0e33, .name = "saraamthai" },
                                                                { .u = 0x0e30, .name = "saraathai" },
                                                                { .u = 0x0e40, .name = "saraethai" },
                                                                { .u = 0xf886, .name = "saraiileftthai" },
                                                                { .u = 0x0e35, .name = "saraiithai" },
                                                                { .u = 0xf885, .name = "saraileftthai" },
                                                                { .u = 0x0e34, .name = "saraithai" },
                                                                { .u = 0x0e42, .name = "saraothai" },
                                                                { .u = 0xf888, .name = "saraueeleftthai" },
                                                                { .u = 0x0e37, .name = "saraueethai" },
                                                                { .u = 0xf887, .name = "saraueleftthai" },
                                                                { .u = 0x0e36, .name = "sarauethai" },
                                                                { .u = 0x0e38, .name = "sarauthai" },
                                                                { .u = 0x0e39, .name = "sarauuthai" },
                                                                { .u = 0x3119, .name = "sbopomofo" },
                                                                { .u = 0x0161, .name = "scaron" },
                                                                { .u = 0x1e67, .name = "scarondotaccent" },
                                                                { .u = 0x015f, .name = "scedilla" },
                                                                { .u = 0x0259, .name = "schwa" },
                                                                { .u = 0x04d9, .name = "schwacyrillic" },
                                                                { .u = 0x04db, .name = "schwadieresiscyrillic" },
                                                                { .u = 0x025a, .name = "schwahook" },
                                                                { .u = 0x24e2, .name = "scircle" },
                                                                { .u = 0x015d, .name = "scircumflex" },
                                                                { .u = 0x0219, .name = "scommaaccent" },
                                                                { .u = 0x1e61, .name = "sdotaccent" },
                                                                { .u = 0x1e63, .name = "sdotbelow" },
                                                                { .u = 0x1e69, .name = "sdotbelowdotaccent" },
                                                                { .u = 0x033c, .name = "seagullbelowcmb" },
                                                                { .u = 0x2033, .name = "second" },
                                                                { .u = 0x02ca, .name = "secondtonechinese" },
                                                                { .u = 0x00a7, .name = "section" },
                                                                { .u = 0x0633, .name = "seenarabic" },
                                                                { .u = 0xfeb2, .name = "seenfinalarabic" },
                                                                { .u = 0xfeb3, .name = "seeninitialarabic" },
                                                                { .u = 0xfeb4, .name = "seenmedialarabic" },
                                                                { .u = 0x05b6, .name = "segol" },
                                                                { .u = 0x05b6, .name = "segol13" },
                                                                { .u = 0x05b6, .name = "segol1f" },
                                                                { .u = 0x05b6, .name = "segol2c" },
                                                                { .u = 0x05b6, .name = "segolhebrew" },
                                                                { .u = 0x05b6, .name = "segolnarrowhebrew" },
                                                                { .u = 0x05b6, .name = "segolquarterhebrew" },
                                                                { .u = 0x0592, .name = "segoltahebrew" },
                                                                { .u = 0x05b6, .name = "segolwidehebrew" },
                                                                { .u = 0x057d, .name = "seharmenian" },
                                                                { .u = 0x305b, .name = "sehiragana" },
                                                                { .u = 0x30bb, .name = "sekatakana" },
                                                                { .u = 0xff7e, .name = "sekatakanahalfwidth" },
                                                                { .u = 0x003b, .name = "semicolon" },
                                                                { .u = 0x061b, .name = "semicolonarabic" },
                                                                { .u = 0xff1b, .name = "semicolonmonospace" },
                                                                { .u = 0xfe54, .name = "semicolonsmall" },
                                                                { .u = 0x309c, .name = "semivoicedmarkkana" },
                                                                { .u = 0xff9f, .name = "semivoicedmarkkanahalfwidth" },
                                                                { .u = 0x3322, .name = "sentisquare" },
                                                                { .u = 0x3323, .name = "sentosquare" },
                                                                { .u = 0x0037, .name = "seven" },
                                                                { .u = 0x0667, .name = "sevenarabic" },
                                                                { .u = 0x09ed, .name = "sevenbengali" },
                                                                { .u = 0x2466, .name = "sevencircle" },
                                                                { .u = 0x2790, .name = "sevencircleinversesansserif" },
                                                                { .u = 0x096d, .name = "sevendeva" },
                                                                { .u = 0x215e, .name = "seveneighths" },
                                                                { .u = 0x0aed, .name = "sevengujarati" },
                                                                { .u = 0x0a6d, .name = "sevengurmukhi" },
                                                                { .u = 0x0667, .name = "sevenhackarabic" },
                                                                { .u = 0x3027, .name = "sevenhangzhou" },
                                                                { .u = 0x3226, .name = "sevenideographicparen" },
                                                                { .u = 0x2087, .name = "seveninferior" },
                                                                { .u = 0xff17, .name = "sevenmonospace" },
                                                                { .u = 0xf737, .name = "sevenoldstyle" },
                                                                { .u = 0x247a, .name = "sevenparen" },
                                                                { .u = 0x248e, .name = "sevenperiod" },
                                                                { .u = 0x06f7, .name = "sevenpersian" },
                                                                { .u = 0x2176, .name = "sevenroman" },
                                                                { .u = 0x2077, .name = "sevensuperior" },
                                                                { .u = 0x2470, .name = "seventeencircle" },
                                                                { .u = 0x2484, .name = "seventeenparen" },
                                                                { .u = 0x2498, .name = "seventeenperiod" },
                                                                { .u = 0x0e57, .name = "seventhai" },
                                                                { .u = 0x00ad, .name = "sfthyphen" },
                                                                { .u = 0x0577, .name = "shaarmenian" },
                                                                { .u = 0x09b6, .name = "shabengali" },
                                                                { .u = 0x0448, .name = "shacyrillic" },
                                                                { .u = 0x0651, .name = "shaddaarabic" },
                                                                { .u = 0xfc61, .name = "shaddadammaarabic" },
                                                                { .u = 0xfc5e, .name = "shaddadammatanarabic" },
                                                                { .u = 0xfc60, .name = "shaddafathaarabic" },
                                                                { .u = 0xfc62, .name = "shaddakasraarabic" },
                                                                { .u = 0xfc5f, .name = "shaddakasratanarabic" },
                                                                { .u = 0x2592, .name = "shade" },
                                                                { .u = 0x2593, .name = "shadedark" },
                                                                { .u = 0x2591, .name = "shadelight" },
                                                                { .u = 0x2592, .name = "shademedium" },
                                                                { .u = 0x0936, .name = "shadeva" },
                                                                { .u = 0x0ab6, .name = "shagujarati" },
                                                                { .u = 0x0a36, .name = "shagurmukhi" },
                                                                { .u = 0x0593, .name = "shalshelethebrew" },
                                                                { .u = 0x3115, .name = "shbopomofo" },
                                                                { .u = 0x0449, .name = "shchacyrillic" },
                                                                { .u = 0x0634, .name = "sheenarabic" },
                                                                { .u = 0xfeb6, .name = "sheenfinalarabic" },
                                                                { .u = 0xfeb7, .name = "sheeninitialarabic" },
                                                                { .u = 0xfeb8, .name = "sheenmedialarabic" },
                                                                { .u = 0x03e3, .name = "sheicoptic" },
                                                                { .u = 0x20aa, .name = "sheqel" },
                                                                { .u = 0x20aa, .name = "sheqelhebrew" },
                                                                { .u = 0x05b0, .name = "sheva" },
                                                                { .u = 0x05b0, .name = "sheva115" },
                                                                { .u = 0x05b0, .name = "sheva15" },
                                                                { .u = 0x05b0, .name = "sheva22" },
                                                                { .u = 0x05b0, .name = "sheva2e" },
                                                                { .u = 0x05b0, .name = "shevahebrew" },
                                                                { .u = 0x05b0, .name = "shevanarrowhebrew" },
                                                                { .u = 0x05b0, .name = "shevaquarterhebrew" },
                                                                { .u = 0x05b0, .name = "shevawidehebrew" },
                                                                { .u = 0x04bb, .name = "shhacyrillic" },
                                                                { .u = 0x03ed, .name = "shimacoptic" },
                                                                { .u = 0x05e9, .name = "shin" },
                                                                { .u = 0xfb49, .name = "shindagesh" },
                                                                { .u = 0xfb49, .name = "shindageshhebrew" },
                                                                { .u = 0xfb2c, .name = "shindageshshindot" },
                                                                { .u = 0xfb2c, .name = "shindageshshindothebrew" },
                                                                { .u = 0xfb2d, .name = "shindageshsindot" },
                                                                { .u = 0xfb2d, .name = "shindageshsindothebrew" },
                                                                { .u = 0x05c1, .name = "shindothebrew" },
                                                                { .u = 0x05e9, .name = "shinhebrew" },
                                                                { .u = 0xfb2a, .name = "shinshindot" },
                                                                { .u = 0xfb2a, .name = "shinshindothebrew" },
                                                                { .u = 0xfb2b, .name = "shinsindot" },
                                                                { .u = 0xfb2b, .name = "shinsindothebrew" },
                                                                { .u = 0x0282, .name = "shook" },
                                                                { .u = 0x03c3, .name = "sigma" },
                                                                { .u = 0x03c2, .name = "sigma1" },
                                                                { .u = 0x03c2, .name = "sigmafinal" },
                                                                { .u = 0x03f2, .name = "sigmalunatesymbolgreek" },
                                                                { .u = 0x3057, .name = "sihiragana" },
                                                                { .u = 0x30b7, .name = "sikatakana" },
                                                                { .u = 0xff7c, .name = "sikatakanahalfwidth" },
                                                                { .u = 0x05bd, .name = "siluqhebrew" },
                                                                { .u = 0x05bd, .name = "siluqlefthebrew" },
                                                                { .u = 0x223c, .name = "similar" },
                                                                { .u = 0x2243, .name = "similarequal" },
                                                                { .u = 0x05c2, .name = "sindothebrew" },
                                                                { .u = 0x3274, .name = "siosacirclekorean" },
                                                                { .u = 0x3214, .name = "siosaparenkorean" },
                                                                { .u = 0x317e, .name = "sioscieuckorean" },
                                                                { .u = 0x3266, .name = "sioscirclekorean" },
                                                                { .u = 0x317a, .name = "sioskiyeokkorean" },
                                                                { .u = 0x3145, .name = "sioskorean" },
                                                                { .u = 0x317b, .name = "siosnieunkorean" },
                                                                { .u = 0x3206, .name = "siosparenkorean" },
                                                                { .u = 0x317d, .name = "siospieupkorean" },
                                                                { .u = 0x317c, .name = "siostikeutkorean" },
                                                                { .u = 0x0036, .name = "six" },
                                                                { .u = 0x0666, .name = "sixarabic" },
                                                                { .u = 0x09ec, .name = "sixbengali" },
                                                                { .u = 0x2465, .name = "sixcircle" },
                                                                { .u = 0x278f, .name = "sixcircleinversesansserif" },
                                                                { .u = 0x096c, .name = "sixdeva" },
                                                                { .u = 0x0aec, .name = "sixgujarati" },
                                                                { .u = 0x0a6c, .name = "sixgurmukhi" },
                                                                { .u = 0x0666, .name = "sixhackarabic" },
                                                                { .u = 0x3026, .name = "sixhangzhou" },
                                                                { .u = 0x3225, .name = "sixideographicparen" },
                                                                { .u = 0x2086, .name = "sixinferior" },
                                                                { .u = 0xff16, .name = "sixmonospace" },
                                                                { .u = 0xf736, .name = "sixoldstyle" },
                                                                { .u = 0x2479, .name = "sixparen" },
                                                                { .u = 0x248d, .name = "sixperiod" },
                                                                { .u = 0x06f6, .name = "sixpersian" },
                                                                { .u = 0x2175, .name = "sixroman" },
                                                                { .u = 0x2076, .name = "sixsuperior" },
                                                                { .u = 0x246f, .name = "sixteencircle" },
                                                                { .u = 0x09f9, .name = "sixteencurrencydenominatorbengali" },
                                                                { .u = 0x2483, .name = "sixteenparen" },
                                                                { .u = 0x2497, .name = "sixteenperiod" },
                                                                { .u = 0x0e56, .name = "sixthai" },
                                                                { .u = 0x002f, .name = "slash" },
                                                                { .u = 0xff0f, .name = "slashmonospace" },
                                                                { .u = 0x017f, .name = "slong" },
                                                                { .u = 0x1e9b, .name = "slongdotaccent" },
                                                                { .u = 0x263a, .name = "smileface" },
                                                                { .u = 0xff53, .name = "smonospace" },
                                                                { .u = 0x05c3, .name = "sofpasuqhebrew" },
                                                                { .u = 0x00ad, .name = "softhyphen" },
                                                                { .u = 0x044c, .name = "softsigncyrillic" },
                                                                { .u = 0x305d, .name = "sohiragana" },
                                                                { .u = 0x30bd, .name = "sokatakana" },
                                                                { .u = 0xff7f, .name = "sokatakanahalfwidth" },
                                                                { .u = 0x0338, .name = "soliduslongoverlaycmb" },
                                                                { .u = 0x0337, .name = "solidusshortoverlaycmb" },
                                                                { .u = 0x0e29, .name = "sorusithai" },
                                                                { .u = 0x0e28, .name = "sosalathai" },
                                                                { .u = 0x0e0b, .name = "sosothai" },
                                                                { .u = 0x0e2a, .name = "sosuathai" },
                                                                { .u = 0x0020, .name = "space" },
                                                                { .u = 0x0020, .name = "spacehackarabic" },
                                                                { .u = 0x2660, .name = "spade" },
                                                                { .u = 0x2660, .name = "spadesuitblack" },
                                                                { .u = 0x2664, .name = "spadesuitwhite" },
                                                                { .u = 0x24ae, .name = "sparen" },
                                                                { .u = 0x033b, .name = "squarebelowcmb" },
                                                                { .u = 0x33c4, .name = "squarecc" },
                                                                { .u = 0x339d, .name = "squarecm" },
                                                                { .u = 0x25a9, .name = "squarediagonalcrosshatchfill" },
                                                                { .u = 0x25a4, .name = "squarehorizontalfill" },
                                                                { .u = 0x338f, .name = "squarekg" },
                                                                { .u = 0x339e, .name = "squarekm" },
                                                                { .u = 0x33ce, .name = "squarekmcapital" },
                                                                { .u = 0x33d1, .name = "squareln" },
                                                                { .u = 0x33d2, .name = "squarelog" },
                                                                { .u = 0x338e, .name = "squaremg" },
                                                                { .u = 0x33d5, .name = "squaremil" },
                                                                { .u = 0x339c, .name = "squaremm" },
                                                                { .u = 0x33a1, .name = "squaremsquared" },
                                                                { .u = 0x25a6, .name = "squareorthogonalcrosshatchfill" },
                                                                { .u = 0x25a7, .name = "squareupperlefttolowerrightfill" },
                                                                { .u = 0x25a8, .name = "squareupperrighttolowerleftfill" },
                                                                { .u = 0x25a5, .name = "squareverticalfill" },
                                                                { .u = 0x25a3, .name = "squarewhitewithsmallblack" },
                                                                { .u = 0x33db, .name = "srsquare" },
                                                                { .u = 0x09b7, .name = "ssabengali" },
                                                                { .u = 0x0937, .name = "ssadeva" },
                                                                { .u = 0x0ab7, .name = "ssagujarati" },
                                                                { .u = 0x3149, .name = "ssangcieuckorean" },
                                                                { .u = 0x3185, .name = "ssanghieuhkorean" },
                                                                { .u = 0x3180, .name = "ssangieungkorean" },
                                                                { .u = 0x3132, .name = "ssangkiyeokkorean" },
                                                                { .u = 0x3165, .name = "ssangnieunkorean" },
                                                                { .u = 0x3143, .name = "ssangpieupkorean" },
                                                                { .u = 0x3146, .name = "ssangsioskorean" },
                                                                { .u = 0x3138, .name = "ssangtikeutkorean" },
                                                                { .u = 0xf6f2, .name = "ssuperior" },
                                                                { .u = 0x00a3, .name = "sterling" },
                                                                { .u = 0xffe1, .name = "sterlingmonospace" },
                                                                { .u = 0x0336, .name = "strokelongoverlaycmb" },
                                                                { .u = 0x0335, .name = "strokeshortoverlaycmb" },
                                                                { .u = 0x2282, .name = "subset" },
                                                                { .u = 0x228a, .name = "subsetnotequal" },
                                                                { .u = 0x2286, .name = "subsetorequal" },
                                                                { .u = 0x227b, .name = "succeeds" },
                                                                { .u = 0x220b, .name = "suchthat" },
                                                                { .u = 0x3059, .name = "suhiragana" },
                                                                { .u = 0x30b9, .name = "sukatakana" },
                                                                { .u = 0xff7d, .name = "sukatakanahalfwidth" },
                                                                { .u = 0x0652, .name = "sukunarabic" },
                                                                { .u = 0x2211, .name = "summation" },
                                                                { .u = 0x263c, .name = "sun" },
                                                                { .u = 0x2283, .name = "superset" },
                                                                { .u = 0x228b, .name = "supersetnotequal" },
                                                                { .u = 0x2287, .name = "supersetorequal" },
                                                                { .u = 0x33dc, .name = "svsquare" },
                                                                { .u = 0x337c, .name = "syouwaerasquare" },
                                                                { .u = 0x0074, .name = "t" },
                                                                { .u = 0x09a4, .name = "tabengali" },
                                                                { .u = 0x22a4, .name = "tackdown" },
                                                                { .u = 0x22a3, .name = "tackleft" },
                                                                { .u = 0x0924, .name = "tadeva" },
                                                                { .u = 0x0aa4, .name = "tagujarati" },
                                                                { .u = 0x0a24, .name = "tagurmukhi" },
                                                                { .u = 0x0637, .name = "taharabic" },
                                                                { .u = 0xfec2, .name = "tahfinalarabic" },
                                                                { .u = 0xfec3, .name = "tahinitialarabic" },
                                                                { .u = 0x305f, .name = "tahiragana" },
                                                                { .u = 0xfec4, .name = "tahmedialarabic" },
                                                                { .u = 0x337d, .name = "taisyouerasquare" },
                                                                { .u = 0x30bf, .name = "takatakana" },
                                                                { .u = 0xff80, .name = "takatakanahalfwidth" },
                                                                { .u = 0x0640, .name = "tatweelarabic" },
                                                                { .u = 0x03c4, .name = "tau" },
                                                                { .u = 0x05ea, .name = "tav" },
                                                                { .u = 0xfb4a, .name = "tavdages" },
                                                                { .u = 0xfb4a, .name = "tavdagesh" },
                                                                { .u = 0xfb4a, .name = "tavdageshhebrew" },
                                                                { .u = 0x05ea, .name = "tavhebrew" },
                                                                { .u = 0x0167, .name = "tbar" },
                                                                { .u = 0x310a, .name = "tbopomofo" },
                                                                { .u = 0x0165, .name = "tcaron" },
                                                                { .u = 0x02a8, .name = "tccurl" },
                                                                { .u = 0x0163, .name = "tcedilla" },
                                                                { .u = 0x0686, .name = "tcheharabic" },
                                                                { .u = 0xfb7b, .name = "tchehfinalarabic" },
                                                                { .u = 0xfb7c, .name = "tchehinitialarabic" },
                                                                { .u = 0xfb7d, .name = "tchehmedialarabic" },
                                                                { .u = 0x24e3, .name = "tcircle" },
                                                                { .u = 0x1e71, .name = "tcircumflexbelow" },
                                                                { .u = 0x0163, .name = "tcommaaccent" },
                                                                { .u = 0x1e97, .name = "tdieresis" },
                                                                { .u = 0x1e6b, .name = "tdotaccent" },
                                                                { .u = 0x1e6d, .name = "tdotbelow" },
                                                                { .u = 0x0442, .name = "tecyrillic" },
                                                                { .u = 0x04ad, .name = "tedescendercyrillic" },
                                                                { .u = 0x062a, .name = "teharabic" },
                                                                { .u = 0xfe96, .name = "tehfinalarabic" },
                                                                { .u = 0xfca2, .name = "tehhahinitialarabic" },
                                                                { .u = 0xfc0c, .name = "tehhahisolatedarabic" },
                                                                { .u = 0xfe97, .name = "tehinitialarabic" },
                                                                { .u = 0x3066, .name = "tehiragana" },
                                                                { .u = 0xfca1, .name = "tehjeeminitialarabic" },
                                                                { .u = 0xfc0b, .name = "tehjeemisolatedarabic" },
                                                                { .u = 0x0629, .name = "tehmarbutaarabic" },
                                                                { .u = 0xfe94, .name = "tehmarbutafinalarabic" },
                                                                { .u = 0xfe98, .name = "tehmedialarabic" },
                                                                { .u = 0xfca4, .name = "tehmeeminitialarabic" },
                                                                { .u = 0xfc0e, .name = "tehmeemisolatedarabic" },
                                                                { .u = 0xfc73, .name = "tehnoonfinalarabic" },
                                                                { .u = 0x30c6, .name = "tekatakana" },
                                                                { .u = 0xff83, .name = "tekatakanahalfwidth" },
                                                                { .u = 0x2121, .name = "telephone" },
                                                                { .u = 0x260e, .name = "telephoneblack" },
                                                                { .u = 0x05a0, .name = "telishagedolahebrew" },
                                                                { .u = 0x05a9, .name = "telishaqetanahebrew" },
                                                                { .u = 0x2469, .name = "tencircle" },
                                                                { .u = 0x3229, .name = "tenideographicparen" },
                                                                { .u = 0x247d, .name = "tenparen" },
                                                                { .u = 0x2491, .name = "tenperiod" },
                                                                { .u = 0x2179, .name = "tenroman" },
                                                                { .u = 0x02a7, .name = "tesh" },
                                                                { .u = 0x05d8, .name = "tet" },
                                                                { .u = 0xfb38, .name = "tetdagesh" },
                                                                { .u = 0xfb38, .name = "tetdageshhebrew" },
                                                                { .u = 0x05d8, .name = "tethebrew" },
                                                                { .u = 0x04b5, .name = "tetsecyrillic" },
                                                                { .u = 0x059b, .name = "tevirhebrew" },
                                                                { .u = 0x059b, .name = "tevirlefthebrew" },
                                                                { .u = 0x09a5, .name = "thabengali" },
                                                                { .u = 0x0925, .name = "thadeva" },
                                                                { .u = 0x0aa5, .name = "thagujarati" },
                                                                { .u = 0x0a25, .name = "thagurmukhi" },
                                                                { .u = 0x0630, .name = "thalarabic" },
                                                                { .u = 0xfeac, .name = "thalfinalarabic" },
                                                                { .u = 0xf898, .name = "thanthakhatlowleftthai" },
                                                                { .u = 0xf897, .name = "thanthakhatlowrightthai" },
                                                                { .u = 0x0e4c, .name = "thanthakhatthai" },
                                                                { .u = 0xf896, .name = "thanthakhatupperleftthai" },
                                                                { .u = 0x062b, .name = "theharabic" },
                                                                { .u = 0xfe9a, .name = "thehfinalarabic" },
                                                                { .u = 0xfe9b, .name = "thehinitialarabic" },
                                                                { .u = 0xfe9c, .name = "thehmedialarabic" },
                                                                { .u = 0x2203, .name = "thereexists" },
                                                                { .u = 0x2234, .name = "therefore" },
                                                                { .u = 0x03b8, .name = "theta" },
                                                                { .u = 0x03d1, .name = "theta1" },
                                                                { .u = 0x03d1, .name = "thetasymbolgreek" },
                                                                { .u = 0x3279, .name = "thieuthacirclekorean" },
                                                                { .u = 0x3219, .name = "thieuthaparenkorean" },
                                                                { .u = 0x326b, .name = "thieuthcirclekorean" },
                                                                { .u = 0x314c, .name = "thieuthkorean" },
                                                                { .u = 0x320b, .name = "thieuthparenkorean" },
                                                                { .u = 0x246c, .name = "thirteencircle" },
                                                                { .u = 0x2480, .name = "thirteenparen" },
                                                                { .u = 0x2494, .name = "thirteenperiod" },
                                                                { .u = 0x0e11, .name = "thonangmonthothai" },
                                                                { .u = 0x01ad, .name = "thook" },
                                                                { .u = 0x0e12, .name = "thophuthaothai" },
                                                                { .u = 0x00fe, .name = "thorn" },
                                                                { .u = 0x0e17, .name = "thothahanthai" },
                                                                { .u = 0x0e10, .name = "thothanthai" },
                                                                { .u = 0x0e18, .name = "thothongthai" },
                                                                { .u = 0x0e16, .name = "thothungthai" },
                                                                { .u = 0x0482, .name = "thousandcyrillic" },
                                                                { .u = 0x066c, .name = "thousandsseparatorarabic" },
                                                                { .u = 0x066c, .name = "thousandsseparatorpersian" },
                                                                { .u = 0x0033, .name = "three" },
                                                                { .u = 0x0663, .name = "threearabic" },
                                                                { .u = 0x09e9, .name = "threebengali" },
                                                                { .u = 0x2462, .name = "threecircle" },
                                                                { .u = 0x278c, .name = "threecircleinversesansserif" },
                                                                { .u = 0x0969, .name = "threedeva" },
                                                                { .u = 0x215c, .name = "threeeighths" },
                                                                { .u = 0x0ae9, .name = "threegujarati" },
                                                                { .u = 0x0a69, .name = "threegurmukhi" },
                                                                { .u = 0x0663, .name = "threehackarabic" },
                                                                { .u = 0x3023, .name = "threehangzhou" },
                                                                { .u = 0x3222, .name = "threeideographicparen" },
                                                                { .u = 0x2083, .name = "threeinferior" },
                                                                { .u = 0xff13, .name = "threemonospace" },
                                                                { .u = 0x09f6, .name = "threenumeratorbengali" },
                                                                { .u = 0xf733, .name = "threeoldstyle" },
                                                                { .u = 0x2476, .name = "threeparen" },
                                                                { .u = 0x248a, .name = "threeperiod" },
                                                                { .u = 0x06f3, .name = "threepersian" },
                                                                { .u = 0x00be, .name = "threequarters" },
                                                                { .u = 0xf6de, .name = "threequartersemdash" },
                                                                { .u = 0x2172, .name = "threeroman" },
                                                                { .u = 0x00b3, .name = "threesuperior" },
                                                                { .u = 0x0e53, .name = "threethai" },
                                                                { .u = 0x3394, .name = "thzsquare" },
                                                                { .u = 0x3061, .name = "tihiragana" },
                                                                { .u = 0x30c1, .name = "tikatakana" },
                                                                { .u = 0xff81, .name = "tikatakanahalfwidth" },
                                                                { .u = 0x3270, .name = "tikeutacirclekorean" },
                                                                { .u = 0x3210, .name = "tikeutaparenkorean" },
                                                                { .u = 0x3262, .name = "tikeutcirclekorean" },
                                                                { .u = 0x3137, .name = "tikeutkorean" },
                                                                { .u = 0x3202, .name = "tikeutparenkorean" },
                                                                { .u = 0x02dc, .name = "tilde" },
                                                                { .u = 0x0330, .name = "tildebelowcmb" },
                                                                { .u = 0x0303, .name = "tildecmb" },
                                                                { .u = 0x0303, .name = "tildecomb" },
                                                                { .u = 0x0360, .name = "tildedoublecmb" },
                                                                { .u = 0x223c, .name = "tildeoperator" },
                                                                { .u = 0x0334, .name = "tildeoverlaycmb" },
                                                                { .u = 0x033e, .name = "tildeverticalcmb" },
                                                                { .u = 0x2297, .name = "timescircle" },
                                                                { .u = 0x0596, .name = "tipehahebrew" },
                                                                { .u = 0x0596, .name = "tipehalefthebrew" },
                                                                { .u = 0x0a70, .name = "tippigurmukhi" },
                                                                { .u = 0x0483, .name = "titlocyrilliccmb" },
                                                                { .u = 0x057f, .name = "tiwnarmenian" },
                                                                { .u = 0x1e6f, .name = "tlinebelow" },
                                                                { .u = 0xff54, .name = "tmonospace" },
                                                                { .u = 0x0569, .name = "toarmenian" },
                                                                { .u = 0x3068, .name = "tohiragana" },
                                                                { .u = 0x30c8, .name = "tokatakana" },
                                                                { .u = 0xff84, .name = "tokatakanahalfwidth" },
                                                                { .u = 0x02e5, .name = "tonebarextrahighmod" },
                                                                { .u = 0x02e9, .name = "tonebarextralowmod" },
                                                                { .u = 0x02e6, .name = "tonebarhighmod" },
                                                                { .u = 0x02e8, .name = "tonebarlowmod" },
                                                                { .u = 0x02e7, .name = "tonebarmidmod" },
                                                                { .u = 0x01bd, .name = "tonefive" },
                                                                { .u = 0x0185, .name = "tonesix" },
                                                                { .u = 0x01a8, .name = "tonetwo" },
                                                                { .u = 0x0384, .name = "tonos" },
                                                                { .u = 0x3327, .name = "tonsquare" },
                                                                { .u = 0x0e0f, .name = "topatakthai" },
                                                                { .u = 0x3014, .name = "tortoiseshellbracketleft" },
                                                                { .u = 0xfe5d, .name = "tortoiseshellbracketleftsmall" },
                                                                { .u = 0xfe39, .name = "tortoiseshellbracketleftvertical" },
                                                                { .u = 0x3015, .name = "tortoiseshellbracketright" },
                                                                { .u = 0xfe5e, .name = "tortoiseshellbracketrightsmall" },
                                                                { .u = 0xfe3a, .name = "tortoiseshellbracketrightvertical" },
                                                                { .u = 0x0e15, .name = "totaothai" },
                                                                { .u = 0x01ab, .name = "tpalatalhook" },
                                                                { .u = 0x24af, .name = "tparen" },
                                                                { .u = 0x2122, .name = "trademark" },
                                                                { .u = 0xf8ea, .name = "trademarksans" },
                                                                { .u = 0xf6db, .name = "trademarkserif" },
                                                                { .u = 0x0288, .name = "tretroflexhook" },
                                                                { .u = 0x25bc, .name = "triagdn" },
                                                                { .u = 0x25c4, .name = "triaglf" },
                                                                { .u = 0x25ba, .name = "triagrt" },
                                                                { .u = 0x25b2, .name = "triagup" },
                                                                { .u = 0x02a6, .name = "ts" },
                                                                { .u = 0x05e6, .name = "tsadi" },
                                                                { .u = 0xfb46, .name = "tsadidagesh" },
                                                                { .u = 0xfb46, .name = "tsadidageshhebrew" },
                                                                { .u = 0x05e6, .name = "tsadihebrew" },
                                                                { .u = 0x0446, .name = "tsecyrillic" },
                                                                { .u = 0x05b5, .name = "tsere" },
                                                                { .u = 0x05b5, .name = "tsere12" },
                                                                { .u = 0x05b5, .name = "tsere1e" },
                                                                { .u = 0x05b5, .name = "tsere2b" },
                                                                { .u = 0x05b5, .name = "tserehebrew" },
                                                                { .u = 0x05b5, .name = "tserenarrowhebrew" },
                                                                { .u = 0x05b5, .name = "tserequarterhebrew" },
                                                                { .u = 0x05b5, .name = "tserewidehebrew" },
                                                                { .u = 0x045b, .name = "tshecyrillic" },
                                                                { .u = 0xf6f3, .name = "tsuperior" },
                                                                { .u = 0x099f, .name = "ttabengali" },
                                                                { .u = 0x091f, .name = "ttadeva" },
                                                                { .u = 0x0a9f, .name = "ttagujarati" },
                                                                { .u = 0x0a1f, .name = "ttagurmukhi" },
                                                                { .u = 0x0679, .name = "tteharabic" },
                                                                { .u = 0xfb67, .name = "ttehfinalarabic" },
                                                                { .u = 0xfb68, .name = "ttehinitialarabic" },
                                                                { .u = 0xfb69, .name = "ttehmedialarabic" },
                                                                { .u = 0x09a0, .name = "tthabengali" },
                                                                { .u = 0x0920, .name = "tthadeva" },
                                                                { .u = 0x0aa0, .name = "tthagujarati" },
                                                                { .u = 0x0a20, .name = "tthagurmukhi" },
                                                                { .u = 0x0287, .name = "tturned" },
                                                                { .u = 0x3064, .name = "tuhiragana" },
                                                                { .u = 0x30c4, .name = "tukatakana" },
                                                                { .u = 0xff82, .name = "tukatakanahalfwidth" },
                                                                { .u = 0x3063, .name = "tusmallhiragana" },
                                                                { .u = 0x30c3, .name = "tusmallkatakana" },
                                                                { .u = 0xff6f, .name = "tusmallkatakanahalfwidth" },
                                                                { .u = 0x246b, .name = "twelvecircle" },
                                                                { .u = 0x247f, .name = "twelveparen" },
                                                                { .u = 0x2493, .name = "twelveperiod" },
                                                                { .u = 0x217b, .name = "twelveroman" },
                                                                { .u = 0x2473, .name = "twentycircle" },
                                                                { .u = 0x5344, .name = "twentyhangzhou" },
                                                                { .u = 0x2487, .name = "twentyparen" },
                                                                { .u = 0x249b, .name = "twentyperiod" },
                                                                { .u = 0x0032, .name = "two" },
                                                                { .u = 0x0662, .name = "twoarabic" },
                                                                { .u = 0x09e8, .name = "twobengali" },
                                                                { .u = 0x2461, .name = "twocircle" },
                                                                { .u = 0x278b, .name = "twocircleinversesansserif" },
                                                                { .u = 0x0968, .name = "twodeva" },
                                                                { .u = 0x2025, .name = "twodotenleader" },
                                                                { .u = 0x2025, .name = "twodotleader" },
                                                                { .u = 0xfe30, .name = "twodotleadervertical" },
                                                                { .u = 0x0ae8, .name = "twogujarati" },
                                                                { .u = 0x0a68, .name = "twogurmukhi" },
                                                                { .u = 0x0662, .name = "twohackarabic" },
                                                                { .u = 0x3022, .name = "twohangzhou" },
                                                                { .u = 0x3221, .name = "twoideographicparen" },
                                                                { .u = 0x2082, .name = "twoinferior" },
                                                                { .u = 0xff12, .name = "twomonospace" },
                                                                { .u = 0x09f5, .name = "twonumeratorbengali" },
                                                                { .u = 0xf732, .name = "twooldstyle" },
                                                                { .u = 0x2475, .name = "twoparen" },
                                                                { .u = 0x2489, .name = "twoperiod" },
                                                                { .u = 0x06f2, .name = "twopersian" },
                                                                { .u = 0x2171, .name = "tworoman" },
                                                                { .u = 0x01bb, .name = "twostroke" },
                                                                { .u = 0x00b2, .name = "twosuperior" },
                                                                { .u = 0x0e52, .name = "twothai" },
                                                                { .u = 0x2154, .name = "twothirds" },
                                                                { .u = 0x0075, .name = "u" },
                                                                { .u = 0x00fa, .name = "uacute" },
                                                                { .u = 0x0289, .name = "ubar" },
                                                                { .u = 0x0989, .name = "ubengali" },
                                                                { .u = 0x3128, .name = "ubopomofo" },
                                                                { .u = 0x016d, .name = "ubreve" },
                                                                { .u = 0x01d4, .name = "ucaron" },
                                                                { .u = 0x24e4, .name = "ucircle" },
                                                                { .u = 0x00fb, .name = "ucircumflex" },
                                                                { .u = 0x1e77, .name = "ucircumflexbelow" },
                                                                { .u = 0x0443, .name = "ucyrillic" },
                                                                { .u = 0x0951, .name = "udattadeva" },
                                                                { .u = 0x0171, .name = "udblacute" },
                                                                { .u = 0x0215, .name = "udblgrave" },
                                                                { .u = 0x0909, .name = "udeva" },
                                                                { .u = 0x00fc, .name = "udieresis" },
                                                                { .u = 0x01d8, .name = "udieresisacute" },
                                                                { .u = 0x1e73, .name = "udieresisbelow" },
                                                                { .u = 0x01da, .name = "udieresiscaron" },
                                                                { .u = 0x04f1, .name = "udieresiscyrillic" },
                                                                { .u = 0x01dc, .name = "udieresisgrave" },
                                                                { .u = 0x01d6, .name = "udieresismacron" },
                                                                { .u = 0x1ee5, .name = "udotbelow" },
                                                                { .u = 0x00f9, .name = "ugrave" },
                                                                { .u = 0x0a89, .name = "ugujarati" },
                                                                { .u = 0x0a09, .name = "ugurmukhi" },
                                                                { .u = 0x3046, .name = "uhiragana" },
                                                                { .u = 0x1ee7, .name = "uhookabove" },
                                                                { .u = 0x01b0, .name = "uhorn" },
                                                                { .u = 0x1ee9, .name = "uhornacute" },
                                                                { .u = 0x1ef1, .name = "uhorndotbelow" },
                                                                { .u = 0x1eeb, .name = "uhorngrave" },
                                                                { .u = 0x1eed, .name = "uhornhookabove" },
                                                                { .u = 0x1eef, .name = "uhorntilde" },
                                                                { .u = 0x0171, .name = "uhungarumlaut" },
                                                                { .u = 0x04f3, .name = "uhungarumlautcyrillic" },
                                                                { .u = 0x0217, .name = "uinvertedbreve" },
                                                                { .u = 0x30a6, .name = "ukatakana" },
                                                                { .u = 0xff73, .name = "ukatakanahalfwidth" },
                                                                { .u = 0x0479, .name = "ukcyrillic" },
                                                                { .u = 0x315c, .name = "ukorean" },
                                                                { .u = 0x016b, .name = "umacron" },
                                                                { .u = 0x04ef, .name = "umacroncyrillic" },
                                                                { .u = 0x1e7b, .name = "umacrondieresis" },
                                                                { .u = 0x0a41, .name = "umatragurmukhi" },
                                                                { .u = 0xff55, .name = "umonospace" },
                                                                { .u = 0x005f, .name = "underscore" },
                                                                { .u = 0x2017, .name = "underscoredbl" },
                                                                { .u = 0xff3f, .name = "underscoremonospace" },
                                                                { .u = 0xfe33, .name = "underscorevertical" },
                                                                { .u = 0xfe4f, .name = "underscorewavy" },
                                                                { .u = 0x222a, .name = "union" },
                                                                { .u = 0x2200, .name = "universal" },
                                                                { .u = 0x0173, .name = "uogonek" },
                                                                { .u = 0x24b0, .name = "uparen" },
                                                                { .u = 0x2580, .name = "upblock" },
                                                                { .u = 0x05c4, .name = "upperdothebrew" },
                                                                { .u = 0x03c5, .name = "upsilon" },
                                                                { .u = 0x03cb, .name = "upsilondieresis" },
                                                                { .u = 0x03b0, .name = "upsilondieresistonos" },
                                                                { .u = 0x028a, .name = "upsilonlatin" },
                                                                { .u = 0x03cd, .name = "upsilontonos" },
                                                                { .u = 0x031d, .name = "uptackbelowcmb" },
                                                                { .u = 0x02d4, .name = "uptackmod" },
                                                                { .u = 0x0a73, .name = "uragurmukhi" },
                                                                { .u = 0x016f, .name = "uring" },
                                                                { .u = 0x045e, .name = "ushortcyrillic" },
                                                                { .u = 0x3045, .name = "usmallhiragana" },
                                                                { .u = 0x30a5, .name = "usmallkatakana" },
                                                                { .u = 0xff69, .name = "usmallkatakanahalfwidth" },
                                                                { .u = 0x04af, .name = "ustraightcyrillic" },
                                                                { .u = 0x04b1, .name = "ustraightstrokecyrillic" },
                                                                { .u = 0x0169, .name = "utilde" },
                                                                { .u = 0x1e79, .name = "utildeacute" },
                                                                { .u = 0x1e75, .name = "utildebelow" },
                                                                { .u = 0x098a, .name = "uubengali" },
                                                                { .u = 0x090a, .name = "uudeva" },
                                                                { .u = 0x0a8a, .name = "uugujarati" },
                                                                { .u = 0x0a0a, .name = "uugurmukhi" },
                                                                { .u = 0x0a42, .name = "uumatragurmukhi" },
                                                                { .u = 0x09c2, .name = "uuvowelsignbengali" },
                                                                { .u = 0x0942, .name = "uuvowelsigndeva" },
                                                                { .u = 0x0ac2, .name = "uuvowelsigngujarati" },
                                                                { .u = 0x09c1, .name = "uvowelsignbengali" },
                                                                { .u = 0x0941, .name = "uvowelsigndeva" },
                                                                { .u = 0x0ac1, .name = "uvowelsigngujarati" },
                                                                { .u = 0x0076, .name = "v" },
                                                                { .u = 0x0935, .name = "vadeva" },
                                                                { .u = 0x0ab5, .name = "vagujarati" },
                                                                { .u = 0x0a35, .name = "vagurmukhi" },
                                                                { .u = 0x30f7, .name = "vakatakana" },
                                                                { .u = 0x05d5, .name = "vav" },
                                                                { .u = 0xfb35, .name = "vavdagesh" },
                                                                { .u = 0xfb35, .name = "vavdagesh65" },
                                                                { .u = 0xfb35, .name = "vavdageshhebrew" },
                                                                { .u = 0x05d5, .name = "vavhebrew" },
                                                                { .u = 0xfb4b, .name = "vavholam" },
                                                                { .u = 0xfb4b, .name = "vavholamhebrew" },
                                                                { .u = 0x05f0, .name = "vavvavhebrew" },
                                                                { .u = 0x05f1, .name = "vavyodhebrew" },
                                                                { .u = 0x24e5, .name = "vcircle" },
                                                                { .u = 0x1e7f, .name = "vdotbelow" },
                                                                { .u = 0x0432, .name = "vecyrillic" },
                                                                { .u = 0x06a4, .name = "veharabic" },
                                                                { .u = 0xfb6b, .name = "vehfinalarabic" },
                                                                { .u = 0xfb6c, .name = "vehinitialarabic" },
                                                                { .u = 0xfb6d, .name = "vehmedialarabic" },
                                                                { .u = 0x30f9, .name = "vekatakana" },
                                                                { .u = 0x2640, .name = "venus" },
                                                                { .u = 0x007c, .name = "verticalbar" },
                                                                { .u = 0x030d, .name = "verticallineabovecmb" },
                                                                { .u = 0x0329, .name = "verticallinebelowcmb" },
                                                                { .u = 0x02cc, .name = "verticallinelowmod" },
                                                                { .u = 0x02c8, .name = "verticallinemod" },
                                                                { .u = 0x057e, .name = "vewarmenian" },
                                                                { .u = 0x028b, .name = "vhook" },
                                                                { .u = 0x30f8, .name = "vikatakana" },
                                                                { .u = 0x09cd, .name = "viramabengali" },
                                                                { .u = 0x094d, .name = "viramadeva" },
                                                                { .u = 0x0acd, .name = "viramagujarati" },
                                                                { .u = 0x0983, .name = "visargabengali" },
                                                                { .u = 0x0903, .name = "visargadeva" },
                                                                { .u = 0x0a83, .name = "visargagujarati" },
                                                                { .u = 0xff56, .name = "vmonospace" },
                                                                { .u = 0x0578, .name = "voarmenian" },
                                                                { .u = 0x309e, .name = "voicediterationhiragana" },
                                                                { .u = 0x30fe, .name = "voicediterationkatakana" },
                                                                { .u = 0x309b, .name = "voicedmarkkana" },
                                                                { .u = 0xff9e, .name = "voicedmarkkanahalfwidth" },
                                                                { .u = 0x30fa, .name = "vokatakana" },
                                                                { .u = 0x24b1, .name = "vparen" },
                                                                { .u = 0x1e7d, .name = "vtilde" },
                                                                { .u = 0x028c, .name = "vturned" },
                                                                { .u = 0x3094, .name = "vuhiragana" },
                                                                { .u = 0x30f4, .name = "vukatakana" },
                                                                { .u = 0x0077, .name = "w" },
                                                                { .u = 0x1e83, .name = "wacute" },
                                                                { .u = 0x3159, .name = "waekorean" },
                                                                { .u = 0x308f, .name = "wahiragana" },
                                                                { .u = 0x30ef, .name = "wakatakana" },
                                                                { .u = 0xff9c, .name = "wakatakanahalfwidth" },
                                                                { .u = 0x3158, .name = "wakorean" },
                                                                { .u = 0x308e, .name = "wasmallhiragana" },
                                                                { .u = 0x30ee, .name = "wasmallkatakana" },
                                                                { .u = 0x3357, .name = "wattosquare" },
                                                                { .u = 0x301c, .name = "wavedash" },
                                                                { .u = 0xfe34, .name = "wavyunderscorevertical" },
                                                                { .u = 0x0648, .name = "wawarabic" },
                                                                { .u = 0xfeee, .name = "wawfinalarabic" },
                                                                { .u = 0x0624, .name = "wawhamzaabovearabic" },
                                                                { .u = 0xfe86, .name = "wawhamzaabovefinalarabic" },
                                                                { .u = 0x33dd, .name = "wbsquare" },
                                                                { .u = 0x24e6, .name = "wcircle" },
                                                                { .u = 0x0175, .name = "wcircumflex" },
                                                                { .u = 0x1e85, .name = "wdieresis" },
                                                                { .u = 0x1e87, .name = "wdotaccent" },
                                                                { .u = 0x1e89, .name = "wdotbelow" },
                                                                { .u = 0x3091, .name = "wehiragana" },
                                                                { .u = 0x2118, .name = "weierstrass" },
                                                                { .u = 0x30f1, .name = "wekatakana" },
                                                                { .u = 0x315e, .name = "wekorean" },
                                                                { .u = 0x315d, .name = "weokorean" },
                                                                { .u = 0x1e81, .name = "wgrave" },
                                                                { .u = 0x25e6, .name = "whitebullet" },
                                                                { .u = 0x25cb, .name = "whitecircle" },
                                                                { .u = 0x25d9, .name = "whitecircleinverse" },
                                                                { .u = 0x300e, .name = "whitecornerbracketleft" },
                                                                { .u = 0xfe43, .name = "whitecornerbracketleftvertical" },
                                                                { .u = 0x300f, .name = "whitecornerbracketright" },
                                                                { .u = 0xfe44, .name = "whitecornerbracketrightvertical" },
                                                                { .u = 0x25c7, .name = "whitediamond" },
                                                                { .u = 0x25c8, .name = "whitediamondcontainingblacksmalldiamond" },
                                                                { .u = 0x25bf, .name = "whitedownpointingsmalltriangle" },
                                                                { .u = 0x25bd, .name = "whitedownpointingtriangle" },
                                                                { .u = 0x25c3, .name = "whiteleftpointingsmalltriangle" },
                                                                { .u = 0x25c1, .name = "whiteleftpointingtriangle" },
                                                                { .u = 0x3016, .name = "whitelenticularbracketleft" },
                                                                { .u = 0x3017, .name = "whitelenticularbracketright" },
                                                                { .u = 0x25b9, .name = "whiterightpointingsmalltriangle" },
                                                                { .u = 0x25b7, .name = "whiterightpointingtriangle" },
                                                                { .u = 0x25ab, .name = "whitesmallsquare" },
                                                                { .u = 0x263a, .name = "whitesmilingface" },
                                                                { .u = 0x25a1, .name = "whitesquare" },
                                                                { .u = 0x2606, .name = "whitestar" },
                                                                { .u = 0x260f, .name = "whitetelephone" },
                                                                { .u = 0x3018, .name = "whitetortoiseshellbracketleft" },
                                                                { .u = 0x3019, .name = "whitetortoiseshellbracketright" },
                                                                { .u = 0x25b5, .name = "whiteuppointingsmalltriangle" },
                                                                { .u = 0x25b3, .name = "whiteuppointingtriangle" },
                                                                { .u = 0x3090, .name = "wihiragana" },
                                                                { .u = 0x30f0, .name = "wikatakana" },
                                                                { .u = 0x315f, .name = "wikorean" },
                                                                { .u = 0xff57, .name = "wmonospace" },
                                                                { .u = 0x3092, .name = "wohiragana" },
                                                                { .u = 0x30f2, .name = "wokatakana" },
                                                                { .u = 0xff66, .name = "wokatakanahalfwidth" },
                                                                { .u = 0x20a9, .name = "won" },
                                                                { .u = 0xffe6, .name = "wonmonospace" },
                                                                { .u = 0x0e27, .name = "wowaenthai" },
                                                                { .u = 0x24b2, .name = "wparen" },
                                                                { .u = 0x1e98, .name = "wring" },
                                                                { .u = 0x02b7, .name = "wsuperior" },
                                                                { .u = 0x028d, .name = "wturned" },
                                                                { .u = 0x01bf, .name = "wynn" },
                                                                { .u = 0x0078, .name = "x" },
                                                                { .u = 0x033d, .name = "xabovecmb" },
                                                                { .u = 0x3112, .name = "xbopomofo" },
                                                                { .u = 0x24e7, .name = "xcircle" },
                                                                { .u = 0x1e8d, .name = "xdieresis" },
                                                                { .u = 0x1e8b, .name = "xdotaccent" },
                                                                { .u = 0x056d, .name = "xeharmenian" },
                                                                { .u = 0x03be, .name = "xi" },
                                                                { .u = 0xff58, .name = "xmonospace" },
                                                                { .u = 0x24b3, .name = "xparen" },
                                                                { .u = 0x02e3, .name = "xsuperior" },
                                                                { .u = 0x0079, .name = "y" },
                                                                { .u = 0x334e, .name = "yaadosquare" },
                                                                { .u = 0x09af, .name = "yabengali" },
                                                                { .u = 0x00fd, .name = "yacute" },
                                                                { .u = 0x092f, .name = "yadeva" },
                                                                { .u = 0x3152, .name = "yaekorean" },
                                                                { .u = 0x0aaf, .name = "yagujarati" },
                                                                { .u = 0x0a2f, .name = "yagurmukhi" },
                                                                { .u = 0x3084, .name = "yahiragana" },
                                                                { .u = 0x30e4, .name = "yakatakana" },
                                                                { .u = 0xff94, .name = "yakatakanahalfwidth" },
                                                                { .u = 0x3151, .name = "yakorean" },
                                                                { .u = 0x0e4e, .name = "yamakkanthai" },
                                                                { .u = 0x3083, .name = "yasmallhiragana" },
                                                                { .u = 0x30e3, .name = "yasmallkatakana" },
                                                                { .u = 0xff6c, .name = "yasmallkatakanahalfwidth" },
                                                                { .u = 0x0463, .name = "yatcyrillic" },
                                                                { .u = 0x24e8, .name = "ycircle" },
                                                                { .u = 0x0177, .name = "ycircumflex" },
                                                                { .u = 0x00ff, .name = "ydieresis" },
                                                                { .u = 0x1e8f, .name = "ydotaccent" },
                                                                { .u = 0x1ef5, .name = "ydotbelow" },
                                                                { .u = 0x064a, .name = "yeharabic" },
                                                                { .u = 0x06d2, .name = "yehbarreearabic" },
                                                                { .u = 0xfbaf, .name = "yehbarreefinalarabic" },
                                                                { .u = 0xfef2, .name = "yehfinalarabic" },
                                                                { .u = 0x0626, .name = "yehhamzaabovearabic" },
                                                                { .u = 0xfe8a, .name = "yehhamzaabovefinalarabic" },
                                                                { .u = 0xfe8b, .name = "yehhamzaaboveinitialarabic" },
                                                                { .u = 0xfe8c, .name = "yehhamzaabovemedialarabic" },
                                                                { .u = 0xfef3, .name = "yehinitialarabic" },
                                                                { .u = 0xfef4, .name = "yehmedialarabic" },
                                                                { .u = 0xfcdd, .name = "yehmeeminitialarabic" },
                                                                { .u = 0xfc58, .name = "yehmeemisolatedarabic" },
                                                                { .u = 0xfc94, .name = "yehnoonfinalarabic" },
                                                                { .u = 0x06d1, .name = "yehthreedotsbelowarabic" },
                                                                { .u = 0x3156, .name = "yekorean" },
                                                                { .u = 0x00a5, .name = "yen" },
                                                                { .u = 0xffe5, .name = "yenmonospace" },
                                                                { .u = 0x3155, .name = "yeokorean" },
                                                                { .u = 0x3186, .name = "yeorinhieuhkorean" },
                                                                { .u = 0x05aa, .name = "yerahbenyomohebrew" },
                                                                { .u = 0x05aa, .name = "yerahbenyomolefthebrew" },
                                                                { .u = 0x044b, .name = "yericyrillic" },
                                                                { .u = 0x04f9, .name = "yerudieresiscyrillic" },
                                                                { .u = 0x3181, .name = "yesieungkorean" },
                                                                { .u = 0x3183, .name = "yesieungpansioskorean" },
                                                                { .u = 0x3182, .name = "yesieungsioskorean" },
                                                                { .u = 0x059a, .name = "yetivhebrew" },
                                                                { .u = 0x1ef3, .name = "ygrave" },
                                                                { .u = 0x01b4, .name = "yhook" },
                                                                { .u = 0x1ef7, .name = "yhookabove" },
                                                                { .u = 0x0575, .name = "yiarmenian" },
                                                                { .u = 0x0457, .name = "yicyrillic" },
                                                                { .u = 0x3162, .name = "yikorean" },
                                                                { .u = 0x262f, .name = "yinyang" },
                                                                { .u = 0x0582, .name = "yiwnarmenian" },
                                                                { .u = 0xff59, .name = "ymonospace" },
                                                                { .u = 0x05d9, .name = "yod" },
                                                                { .u = 0xfb39, .name = "yoddagesh" },
                                                                { .u = 0xfb39, .name = "yoddageshhebrew" },
                                                                { .u = 0x05d9, .name = "yodhebrew" },
                                                                { .u = 0x05f2, .name = "yodyodhebrew" },
                                                                { .u = 0xfb1f, .name = "yodyodpatahhebrew" },
                                                                { .u = 0x3088, .name = "yohiragana" },
                                                                { .u = 0x3189, .name = "yoikorean" },
                                                                { .u = 0x30e8, .name = "yokatakana" },
                                                                { .u = 0xff96, .name = "yokatakanahalfwidth" },
                                                                { .u = 0x315b, .name = "yokorean" },
                                                                { .u = 0x3087, .name = "yosmallhiragana" },
                                                                { .u = 0x30e7, .name = "yosmallkatakana" },
                                                                { .u = 0xff6e, .name = "yosmallkatakanahalfwidth" },
                                                                { .u = 0x03f3, .name = "yotgreek" },
                                                                { .u = 0x3188, .name = "yoyaekorean" },
                                                                { .u = 0x3187, .name = "yoyakorean" },
                                                                { .u = 0x0e22, .name = "yoyakthai" },
                                                                { .u = 0x0e0d, .name = "yoyingthai" },
                                                                { .u = 0x24b4, .name = "yparen" },
                                                                { .u = 0x037a, .name = "ypogegrammeni" },
                                                                { .u = 0x0345, .name = "ypogegrammenigreekcmb" },
                                                                { .u = 0x01a6, .name = "yr" },
                                                                { .u = 0x1e99, .name = "yring" },
                                                                { .u = 0x02b8, .name = "ysuperior" },
                                                                { .u = 0x1ef9, .name = "ytilde" },
                                                                { .u = 0x028e, .name = "yturned" },
                                                                { .u = 0x3086, .name = "yuhiragana" },
                                                                { .u = 0x318c, .name = "yuikorean" },
                                                                { .u = 0x30e6, .name = "yukatakana" },
                                                                { .u = 0xff95, .name = "yukatakanahalfwidth" },
                                                                { .u = 0x3160, .name = "yukorean" },
                                                                { .u = 0x046b, .name = "yusbigcyrillic" },
                                                                { .u = 0x046d, .name = "yusbigiotifiedcyrillic" },
                                                                { .u = 0x0467, .name = "yuslittlecyrillic" },
                                                                { .u = 0x0469, .name = "yuslittleiotifiedcyrillic" },
                                                                { .u = 0x3085, .name = "yusmallhiragana" },
                                                                { .u = 0x30e5, .name = "yusmallkatakana" },
                                                                { .u = 0xff6d, .name = "yusmallkatakanahalfwidth" },
                                                                { .u = 0x318b, .name = "yuyekorean" },
                                                                { .u = 0x318a, .name = "yuyeokorean" },
                                                                { .u = 0x09df, .name = "yyabengali" },
                                                                { .u = 0x095f, .name = "yyadeva" },
                                                                { .u = 0x007a, .name = "z" },
                                                                { .u = 0x0566, .name = "zaarmenian" },
                                                                { .u = 0x017a, .name = "zacute" },
                                                                { .u = 0x095b, .name = "zadeva" },
                                                                { .u = 0x0a5b, .name = "zagurmukhi" },
                                                                { .u = 0x0638, .name = "zaharabic" },
                                                                { .u = 0xfec6, .name = "zahfinalarabic" },
                                                                { .u = 0xfec7, .name = "zahinitialarabic" },
                                                                { .u = 0x3056, .name = "zahiragana" },
                                                                { .u = 0xfec8, .name = "zahmedialarabic" },
                                                                { .u = 0x0632, .name = "zainarabic" },
                                                                { .u = 0xfeb0, .name = "zainfinalarabic" },
                                                                { .u = 0x30b6, .name = "zakatakana" },
                                                                { .u = 0x0595, .name = "zaqefgadolhebrew" },
                                                                { .u = 0x0594, .name = "zaqefqatanhebrew" },
                                                                { .u = 0x0598, .name = "zarqahebrew" },
                                                                { .u = 0x05d6, .name = "zayin" },
                                                                { .u = 0xfb36, .name = "zayindagesh" },
                                                                { .u = 0xfb36, .name = "zayindageshhebrew" },
                                                                { .u = 0x05d6, .name = "zayinhebrew" },
                                                                { .u = 0x3117, .name = "zbopomofo" },
                                                                { .u = 0x017e, .name = "zcaron" },
                                                                { .u = 0x24e9, .name = "zcircle" },
                                                                { .u = 0x1e91, .name = "zcircumflex" },
                                                                { .u = 0x0291, .name = "zcurl" },
                                                                { .u = 0x017c, .name = "zdot" },
                                                                { .u = 0x017c, .name = "zdotaccent" },
                                                                { .u = 0x1e93, .name = "zdotbelow" },
                                                                { .u = 0x0437, .name = "zecyrillic" },
                                                                { .u = 0x0499, .name = "zedescendercyrillic" },
                                                                { .u = 0x04df, .name = "zedieresiscyrillic" },
                                                                { .u = 0x305c, .name = "zehiragana" },
                                                                { .u = 0x30bc, .name = "zekatakana" },
                                                                { .u = 0x0030, .name = "zero" },
                                                                { .u = 0x0660, .name = "zeroarabic" },
                                                                { .u = 0x09e6, .name = "zerobengali" },
                                                                { .u = 0x0966, .name = "zerodeva" },
                                                                { .u = 0x0ae6, .name = "zerogujarati" },
                                                                { .u = 0x0a66, .name = "zerogurmukhi" },
                                                                { .u = 0x0660, .name = "zerohackarabic" },
                                                                { .u = 0x2080, .name = "zeroinferior" },
                                                                { .u = 0xff10, .name = "zeromonospace" },
                                                                { .u = 0xf730, .name = "zerooldstyle" },
                                                                { .u = 0x06f0, .name = "zeropersian" },
                                                                { .u = 0x2070, .name = "zerosuperior" },
                                                                { .u = 0x0e50, .name = "zerothai" },
                                                                { .u = 0xfeff, .name = "zerowidthjoiner" },
                                                                { .u = 0x200c, .name = "zerowidthnonjoiner" },
                                                                { .u = 0x200b, .name = "zerowidthspace" },
                                                                { .u = 0x03b6, .name = "zeta" },
                                                                { .u = 0x3113, .name = "zhbopomofo" },
                                                                { .u = 0x056a, .name = "zhearmenian" },
                                                                { .u = 0x04c2, .name = "zhebrevecyrillic" },
                                                                { .u = 0x0436, .name = "zhecyrillic" },
                                                                { .u = 0x0497, .name = "zhedescendercyrillic" },
                                                                { .u = 0x04dd, .name = "zhedieresiscyrillic" },
                                                                { .u = 0x3058, .name = "zihiragana" },
                                                                { .u = 0x30b8, .name = "zikatakana" },
                                                                { .u = 0x05ae, .name = "zinorhebrew" },
                                                                { .u = 0x1e95, .name = "zlinebelow" },
                                                                { .u = 0xff5a, .name = "zmonospace" },
                                                                { .u = 0x305e, .name = "zohiragana" },
                                                                { .u = 0x30be, .name = "zokatakana" },
                                                                { .u = 0x24b5, .name = "zparen" },
                                                                { .u = 0x0290, .name = "zretroflexhook" },
                                                                { .u = 0x01b6, .name = "zstroke" },
                                                                { .u = 0x305a, .name = "zuhiragana" },
                                                                { .u = 0x30ba, .name = "zukatakana" },
                                                                { .u = 0x007b, .name = "{" },
                                                                { .u = 0x007c, .name = "|" },
                                                                { .u = 0x007d, .name = "}" },
                                                                { .u = 0x007e, .name = "~" },
                                                                { .u = 0, .name = nullptr } };

// map ZapfDingbats names to Unicode
static const struct NameToUnicodeTab nameToUnicodeZapfDingbatsTab[] = {
    { .u = 0x275e, .name = "a100" }, { .u = 0x2761, .name = "a101" }, { .u = 0x2762, .name = "a102" }, { .u = 0x2763, .name = "a103" }, { .u = 0x2764, .name = "a104" }, { .u = 0x2710, .name = "a105" }, { .u = 0x2765, .name = "a106" },
    { .u = 0x2766, .name = "a107" }, { .u = 0x2767, .name = "a108" }, { .u = 0x2660, .name = "a109" }, { .u = 0x2721, .name = "a10" },  { .u = 0x2665, .name = "a110" }, { .u = 0x2666, .name = "a111" }, { .u = 0x2663, .name = "a112" },
    { .u = 0x2709, .name = "a117" }, { .u = 0x2708, .name = "a118" }, { .u = 0x2707, .name = "a119" }, { .u = 0x261b, .name = "a11" },  { .u = 0x2460, .name = "a120" }, { .u = 0x2461, .name = "a121" }, { .u = 0x2462, .name = "a122" },
    { .u = 0x2463, .name = "a123" }, { .u = 0x2464, .name = "a124" }, { .u = 0x2465, .name = "a125" }, { .u = 0x2466, .name = "a126" }, { .u = 0x2467, .name = "a127" }, { .u = 0x2468, .name = "a128" }, { .u = 0x2469, .name = "a129" },
    { .u = 0x261e, .name = "a12" },  { .u = 0x2776, .name = "a130" }, { .u = 0x2777, .name = "a131" }, { .u = 0x2778, .name = "a132" }, { .u = 0x2779, .name = "a133" }, { .u = 0x277a, .name = "a134" }, { .u = 0x277b, .name = "a135" },
    { .u = 0x277c, .name = "a136" }, { .u = 0x277d, .name = "a137" }, { .u = 0x277e, .name = "a138" }, { .u = 0x277f, .name = "a139" }, { .u = 0x270c, .name = "a13" },  { .u = 0x2780, .name = "a140" }, { .u = 0x2781, .name = "a141" },
    { .u = 0x2782, .name = "a142" }, { .u = 0x2783, .name = "a143" }, { .u = 0x2784, .name = "a144" }, { .u = 0x2785, .name = "a145" }, { .u = 0x2786, .name = "a146" }, { .u = 0x2787, .name = "a147" }, { .u = 0x2788, .name = "a148" },
    { .u = 0x2789, .name = "a149" }, { .u = 0x270d, .name = "a14" },  { .u = 0x278a, .name = "a150" }, { .u = 0x278b, .name = "a151" }, { .u = 0x278c, .name = "a152" }, { .u = 0x278d, .name = "a153" }, { .u = 0x278e, .name = "a154" },
    { .u = 0x278f, .name = "a155" }, { .u = 0x2790, .name = "a156" }, { .u = 0x2791, .name = "a157" }, { .u = 0x2792, .name = "a158" }, { .u = 0x2793, .name = "a159" }, { .u = 0x270e, .name = "a15" },  { .u = 0x2794, .name = "a160" },
    { .u = 0x2192, .name = "a161" }, { .u = 0x27a3, .name = "a162" }, { .u = 0x2194, .name = "a163" }, { .u = 0x2195, .name = "a164" }, { .u = 0x2799, .name = "a165" }, { .u = 0x279b, .name = "a166" }, { .u = 0x279c, .name = "a167" },
    { .u = 0x279d, .name = "a168" }, { .u = 0x279e, .name = "a169" }, { .u = 0x270f, .name = "a16" },  { .u = 0x279f, .name = "a170" }, { .u = 0x27a0, .name = "a171" }, { .u = 0x27a1, .name = "a172" }, { .u = 0x27a2, .name = "a173" },
    { .u = 0x27a4, .name = "a174" }, { .u = 0x27a5, .name = "a175" }, { .u = 0x27a6, .name = "a176" }, { .u = 0x27a7, .name = "a177" }, { .u = 0x27a8, .name = "a178" }, { .u = 0x27a9, .name = "a179" }, { .u = 0x2711, .name = "a17" },
    { .u = 0x27ab, .name = "a180" }, { .u = 0x27ad, .name = "a181" }, { .u = 0x27af, .name = "a182" }, { .u = 0x27b2, .name = "a183" }, { .u = 0x27b3, .name = "a184" }, { .u = 0x27b5, .name = "a185" }, { .u = 0x27b8, .name = "a186" },
    { .u = 0x27ba, .name = "a187" }, { .u = 0x27bb, .name = "a188" }, { .u = 0x27bc, .name = "a189" }, { .u = 0x2712, .name = "a18" },  { .u = 0x27bd, .name = "a190" }, { .u = 0x27be, .name = "a191" }, { .u = 0x279a, .name = "a192" },
    { .u = 0x27aa, .name = "a193" }, { .u = 0x27b6, .name = "a194" }, { .u = 0x27b9, .name = "a195" }, { .u = 0x2798, .name = "a196" }, { .u = 0x27b4, .name = "a197" }, { .u = 0x27b7, .name = "a198" }, { .u = 0x27ac, .name = "a199" },
    { .u = 0x2713, .name = "a19" },  { .u = 0x2701, .name = "a1" },   { .u = 0x27ae, .name = "a200" }, { .u = 0x27b1, .name = "a201" }, { .u = 0x2703, .name = "a202" }, { .u = 0x2750, .name = "a203" }, { .u = 0x2752, .name = "a204" },
    { .u = 0x276e, .name = "a205" }, { .u = 0x2770, .name = "a206" }, { .u = 0x2714, .name = "a20" },  { .u = 0x2715, .name = "a21" },  { .u = 0x2716, .name = "a22" },  { .u = 0x2717, .name = "a23" },  { .u = 0x2718, .name = "a24" },
    { .u = 0x2719, .name = "a25" },  { .u = 0x271a, .name = "a26" },  { .u = 0x271b, .name = "a27" },  { .u = 0x271c, .name = "a28" },  { .u = 0x2722, .name = "a29" },  { .u = 0x2702, .name = "a2" },   { .u = 0x2723, .name = "a30" },
    { .u = 0x2724, .name = "a31" },  { .u = 0x2725, .name = "a32" },  { .u = 0x2726, .name = "a33" },  { .u = 0x2727, .name = "a34" },  { .u = 0x2605, .name = "a35" },  { .u = 0x2729, .name = "a36" },  { .u = 0x272a, .name = "a37" },
    { .u = 0x272b, .name = "a38" },  { .u = 0x272c, .name = "a39" },  { .u = 0x2704, .name = "a3" },   { .u = 0x272d, .name = "a40" },  { .u = 0x272e, .name = "a41" },  { .u = 0x272f, .name = "a42" },  { .u = 0x2730, .name = "a43" },
    { .u = 0x2731, .name = "a44" },  { .u = 0x2732, .name = "a45" },  { .u = 0x2733, .name = "a46" },  { .u = 0x2734, .name = "a47" },  { .u = 0x2735, .name = "a48" },  { .u = 0x2736, .name = "a49" },  { .u = 0x260e, .name = "a4" },
    { .u = 0x2737, .name = "a50" },  { .u = 0x2738, .name = "a51" },  { .u = 0x2739, .name = "a52" },  { .u = 0x273a, .name = "a53" },  { .u = 0x273b, .name = "a54" },  { .u = 0x273c, .name = "a55" },  { .u = 0x273d, .name = "a56" },
    { .u = 0x273e, .name = "a57" },  { .u = 0x273f, .name = "a58" },  { .u = 0x2740, .name = "a59" },  { .u = 0x2706, .name = "a5" },   { .u = 0x2741, .name = "a60" },  { .u = 0x2742, .name = "a61" },  { .u = 0x2743, .name = "a62" },
    { .u = 0x2744, .name = "a63" },  { .u = 0x2745, .name = "a64" },  { .u = 0x2746, .name = "a65" },  { .u = 0x2747, .name = "a66" },  { .u = 0x2748, .name = "a67" },  { .u = 0x2749, .name = "a68" },  { .u = 0x274a, .name = "a69" },
    { .u = 0x271d, .name = "a6" },   { .u = 0x274b, .name = "a70" },  { .u = 0x25cf, .name = "a71" },  { .u = 0x274d, .name = "a72" },  { .u = 0x25a0, .name = "a73" },  { .u = 0x274f, .name = "a74" },  { .u = 0x2751, .name = "a75" },
    { .u = 0x25b2, .name = "a76" },  { .u = 0x25bc, .name = "a77" },  { .u = 0x25c6, .name = "a78" },  { .u = 0x2756, .name = "a79" },  { .u = 0x271e, .name = "a7" },   { .u = 0x25d7, .name = "a81" },  { .u = 0x2758, .name = "a82" },
    { .u = 0x2759, .name = "a83" },  { .u = 0x275a, .name = "a84" },  { .u = 0x276f, .name = "a85" },  { .u = 0x2771, .name = "a86" },  { .u = 0x2772, .name = "a87" },  { .u = 0x2773, .name = "a88" },  { .u = 0x2768, .name = "a89" },
    { .u = 0x271f, .name = "a8" },   { .u = 0x2769, .name = "a90" },  { .u = 0x276c, .name = "a91" },  { .u = 0x276d, .name = "a92" },  { .u = 0x276a, .name = "a93" },  { .u = 0x276b, .name = "a94" },  { .u = 0x2774, .name = "a95" },
    { .u = 0x2775, .name = "a96" },  { .u = 0x275b, .name = "a97" },  { .u = 0x275c, .name = "a98" },  { .u = 0x275d, .name = "a99" },  { .u = 0x2720, .name = "a9" },   { .u = 0, .name = nullptr }
};
