// Code generated by `cargo run --package generate`. DO NOT EDIT.

#![cfg_attr(rustfmt, rustfmt::skip)]

pub mod shortcode;
pub mod unicode;

use crate::{Emoji, Group, SkinTone, UnicodeVersion};

/// The version of [Unicode](https://www.unicode.org/) that the emojis are based on.
pub const UNICODE_VERSION: UnicodeVersion = UnicodeVersion::new(16, 0);

pub const EMOJIS: &[Emoji] = &[
    Emoji { emoji: "😀", name: "grinning face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["grinning"]) },
    Emoji { emoji: "😃", name: "grinning face with big eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["smiley"]) },
    Emoji { emoji: "😄", name: "grinning face with smiling eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["smile"]) },
    Emoji { emoji: "😁", name: "beaming face with smiling eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["grin"]) },
    Emoji { emoji: "😆", name: "grinning squinting face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["laughing", "satisfied"]) },
    Emoji { emoji: "😅", name: "grinning face with sweat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["sweat_smile"]) },
    Emoji { emoji: "🤣", name: "rolling on the floor laughing", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["rofl"]) },
    Emoji { emoji: "😂", name: "face with tears of joy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["joy"]) },
    Emoji { emoji: "🙂", name: "slightly smiling face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["slightly_smiling_face"]) },
    Emoji { emoji: "🙃", name: "upside-down face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["upside_down_face"]) },
    Emoji { emoji: "🫠", name: "melting face", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["melting_face"]) },
    Emoji { emoji: "😉", name: "winking face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["wink"]) },
    Emoji { emoji: "😊", name: "smiling face with smiling eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["blush"]) },
    Emoji { emoji: "😇", name: "smiling face with halo", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["innocent"]) },
    Emoji { emoji: "🥰", name: "smiling face with hearts", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["smiling_face_with_three_hearts"]) },
    Emoji { emoji: "😍", name: "smiling face with heart-eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["heart_eyes"]) },
    Emoji { emoji: "🤩", name: "star-struck", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["star_struck"]) },
    Emoji { emoji: "😘", name: "face blowing a kiss", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["kissing_heart"]) },
    Emoji { emoji: "😗", name: "kissing face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["kissing"]) },
    Emoji { emoji: "☺️", name: "smiling face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["relaxed"]) },
    Emoji { emoji: "😚", name: "kissing face with closed eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["kissing_closed_eyes"]) },
    Emoji { emoji: "😙", name: "kissing face with smiling eyes", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["kissing_smiling_eyes"]) },
    Emoji { emoji: "🥲", name: "smiling face with tear", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["smiling_face_with_tear"]) },
    Emoji { emoji: "😋", name: "face savoring food", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["yum"]) },
    Emoji { emoji: "😛", name: "face with tongue", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["stuck_out_tongue"]) },
    Emoji { emoji: "😜", name: "winking face with tongue", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["stuck_out_tongue_winking_eye"]) },
    Emoji { emoji: "🤪", name: "zany face", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["zany_face"]) },
    Emoji { emoji: "😝", name: "squinting face with tongue", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["stuck_out_tongue_closed_eyes"]) },
    Emoji { emoji: "🤑", name: "money-mouth face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["money_mouth_face"]) },
    Emoji { emoji: "🤗", name: "smiling face with open hands", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["hugs"]) },
    Emoji { emoji: "🤭", name: "face with hand over mouth", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["hand_over_mouth"]) },
    Emoji { emoji: "🫢", name: "face with open eyes and hand over mouth", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["face_with_open_eyes_and_hand_over_mouth"]) },
    Emoji { emoji: "🫣", name: "face with peeking eye", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["face_with_peeking_eye"]) },
    Emoji { emoji: "🤫", name: "shushing face", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["shushing_face"]) },
    Emoji { emoji: "🤔", name: "thinking face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["thinking"]) },
    Emoji { emoji: "🫡", name: "saluting face", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["saluting_face"]) },
    Emoji { emoji: "🤐", name: "zipper-mouth face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["zipper_mouth_face"]) },
    Emoji { emoji: "🤨", name: "face with raised eyebrow", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["raised_eyebrow"]) },
    Emoji { emoji: "😐", name: "neutral face", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["neutral_face"]) },
    Emoji { emoji: "😑", name: "expressionless face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["expressionless"]) },
    Emoji { emoji: "😶", name: "face without mouth", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["no_mouth"]) },
    Emoji { emoji: "🫥", name: "dotted line face", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["dotted_line_face"]) },
    Emoji { emoji: "😶‍🌫️", name: "face in clouds", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["face_in_clouds"]) },
    Emoji { emoji: "😏", name: "smirking face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["smirk"]) },
    Emoji { emoji: "😒", name: "unamused face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["unamused"]) },
    Emoji { emoji: "🙄", name: "face with rolling eyes", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["roll_eyes"]) },
    Emoji { emoji: "😬", name: "grimacing face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["grimacing"]) },
    Emoji { emoji: "😮‍💨", name: "face exhaling", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["face_exhaling"]) },
    Emoji { emoji: "🤥", name: "lying face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["lying_face"]) },
    Emoji { emoji: "🫨", name: "shaking face", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["shaking_face"]) },
    Emoji { emoji: "🙂‍↔️", name: "head shaking horizontally", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: None },
    Emoji { emoji: "🙂‍↕️", name: "head shaking vertically", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: None },
    Emoji { emoji: "😌", name: "relieved face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["relieved"]) },
    Emoji { emoji: "😔", name: "pensive face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["pensive"]) },
    Emoji { emoji: "😪", name: "sleepy face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["sleepy"]) },
    Emoji { emoji: "🤤", name: "drooling face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["drooling_face"]) },
    Emoji { emoji: "😴", name: "sleeping face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["sleeping"]) },
    Emoji { emoji: "🫩", name: "face with bags under eyes", unicode_version: UnicodeVersion { major: 16, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: None },
    Emoji { emoji: "😷", name: "face with medical mask", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["mask"]) },
    Emoji { emoji: "🤒", name: "face with thermometer", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["face_with_thermometer"]) },
    Emoji { emoji: "🤕", name: "face with head-bandage", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["face_with_head_bandage"]) },
    Emoji { emoji: "🤢", name: "nauseated face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["nauseated_face"]) },
    Emoji { emoji: "🤮", name: "face vomiting", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["vomiting_face"]) },
    Emoji { emoji: "🤧", name: "sneezing face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["sneezing_face"]) },
    Emoji { emoji: "🥵", name: "hot face", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["hot_face"]) },
    Emoji { emoji: "🥶", name: "cold face", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["cold_face"]) },
    Emoji { emoji: "🥴", name: "woozy face", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["woozy_face"]) },
    Emoji { emoji: "😵", name: "face with crossed-out eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["dizzy_face"]) },
    Emoji { emoji: "😵‍💫", name: "face with spiral eyes", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["face_with_spiral_eyes"]) },
    Emoji { emoji: "🤯", name: "exploding head", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["exploding_head"]) },
    Emoji { emoji: "🤠", name: "cowboy hat face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["cowboy_hat_face"]) },
    Emoji { emoji: "🥳", name: "partying face", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["partying_face"]) },
    Emoji { emoji: "🥸", name: "disguised face", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["disguised_face"]) },
    Emoji { emoji: "😎", name: "smiling face with sunglasses", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["sunglasses"]) },
    Emoji { emoji: "🤓", name: "nerd face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["nerd_face"]) },
    Emoji { emoji: "🧐", name: "face with monocle", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["monocle_face"]) },
    Emoji { emoji: "😕", name: "confused face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["confused"]) },
    Emoji { emoji: "🫤", name: "face with diagonal mouth", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["face_with_diagonal_mouth"]) },
    Emoji { emoji: "😟", name: "worried face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["worried"]) },
    Emoji { emoji: "🙁", name: "slightly frowning face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["slightly_frowning_face"]) },
    Emoji { emoji: "☹️", name: "frowning face", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["frowning_face"]) },
    Emoji { emoji: "😮", name: "face with open mouth", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["open_mouth"]) },
    Emoji { emoji: "😯", name: "hushed face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["hushed"]) },
    Emoji { emoji: "😲", name: "astonished face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["astonished"]) },
    Emoji { emoji: "😳", name: "flushed face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["flushed"]) },
    Emoji { emoji: "🥺", name: "pleading face", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["pleading_face"]) },
    Emoji { emoji: "🥹", name: "face holding back tears", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["face_holding_back_tears"]) },
    Emoji { emoji: "😦", name: "frowning face with open mouth", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["frowning"]) },
    Emoji { emoji: "😧", name: "anguished face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["anguished"]) },
    Emoji { emoji: "😨", name: "fearful face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["fearful"]) },
    Emoji { emoji: "😰", name: "anxious face with sweat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["cold_sweat"]) },
    Emoji { emoji: "😥", name: "sad but relieved face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["disappointed_relieved"]) },
    Emoji { emoji: "😢", name: "crying face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["cry"]) },
    Emoji { emoji: "😭", name: "loudly crying face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["sob"]) },
    Emoji { emoji: "😱", name: "face screaming in fear", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["scream"]) },
    Emoji { emoji: "😖", name: "confounded face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["confounded"]) },
    Emoji { emoji: "😣", name: "persevering face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["persevere"]) },
    Emoji { emoji: "😞", name: "disappointed face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["disappointed"]) },
    Emoji { emoji: "😓", name: "downcast face with sweat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["sweat"]) },
    Emoji { emoji: "😩", name: "weary face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["weary"]) },
    Emoji { emoji: "😫", name: "tired face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["tired_face"]) },
    Emoji { emoji: "🥱", name: "yawning face", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["yawning_face"]) },
    Emoji { emoji: "😤", name: "face with steam from nose", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["triumph"]) },
    Emoji { emoji: "😡", name: "enraged face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["rage", "pout"]) },
    Emoji { emoji: "😠", name: "angry face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["angry"]) },
    Emoji { emoji: "🤬", name: "face with symbols on mouth", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["cursing_face"]) },
    Emoji { emoji: "😈", name: "smiling face with horns", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["smiling_imp"]) },
    Emoji { emoji: "👿", name: "angry face with horns", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["imp"]) },
    Emoji { emoji: "💀", name: "skull", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["skull"]) },
    Emoji { emoji: "☠️", name: "skull and crossbones", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["skull_and_crossbones"]) },
    Emoji { emoji: "💩", name: "pile of poo", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["hankey", "poop", "shit"]) },
    Emoji { emoji: "🤡", name: "clown face", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["clown_face"]) },
    Emoji { emoji: "👹", name: "ogre", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["japanese_ogre"]) },
    Emoji { emoji: "👺", name: "goblin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["japanese_goblin"]) },
    Emoji { emoji: "👻", name: "ghost", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["ghost"]) },
    Emoji { emoji: "👽", name: "alien", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["alien"]) },
    Emoji { emoji: "👾", name: "alien monster", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["space_invader"]) },
    Emoji { emoji: "🤖", name: "robot", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["robot"]) },
    Emoji { emoji: "😺", name: "grinning cat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["smiley_cat"]) },
    Emoji { emoji: "😸", name: "grinning cat with smiling eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["smile_cat"]) },
    Emoji { emoji: "😹", name: "cat with tears of joy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["joy_cat"]) },
    Emoji { emoji: "😻", name: "smiling cat with heart-eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["heart_eyes_cat"]) },
    Emoji { emoji: "😼", name: "cat with wry smile", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["smirk_cat"]) },
    Emoji { emoji: "😽", name: "kissing cat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["kissing_cat"]) },
    Emoji { emoji: "🙀", name: "weary cat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["scream_cat"]) },
    Emoji { emoji: "😿", name: "crying cat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["crying_cat_face"]) },
    Emoji { emoji: "😾", name: "pouting cat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["pouting_cat"]) },
    Emoji { emoji: "🙈", name: "see-no-evil monkey", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["see_no_evil"]) },
    Emoji { emoji: "🙉", name: "hear-no-evil monkey", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["hear_no_evil"]) },
    Emoji { emoji: "🙊", name: "speak-no-evil monkey", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["speak_no_evil"]) },
    Emoji { emoji: "💌", name: "love letter", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["love_letter"]) },
    Emoji { emoji: "💘", name: "heart with arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["cupid"]) },
    Emoji { emoji: "💝", name: "heart with ribbon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["gift_heart"]) },
    Emoji { emoji: "💖", name: "sparkling heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["sparkling_heart"]) },
    Emoji { emoji: "💗", name: "growing heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["heartpulse"]) },
    Emoji { emoji: "💓", name: "beating heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["heartbeat"]) },
    Emoji { emoji: "💞", name: "revolving hearts", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["revolving_hearts"]) },
    Emoji { emoji: "💕", name: "two hearts", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["two_hearts"]) },
    Emoji { emoji: "💟", name: "heart decoration", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["heart_decoration"]) },
    Emoji { emoji: "❣️", name: "heart exclamation", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["heavy_heart_exclamation"]) },
    Emoji { emoji: "💔", name: "broken heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["broken_heart"]) },
    Emoji { emoji: "❤️‍🔥", name: "heart on fire", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["heart_on_fire"]) },
    Emoji { emoji: "❤️‍🩹", name: "mending heart", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["mending_heart"]) },
    Emoji { emoji: "❤️", name: "red heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["heart"]) },
    Emoji { emoji: "🩷", name: "pink heart", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["pink_heart"]) },
    Emoji { emoji: "🧡", name: "orange heart", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["orange_heart"]) },
    Emoji { emoji: "💛", name: "yellow heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["yellow_heart"]) },
    Emoji { emoji: "💚", name: "green heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["green_heart"]) },
    Emoji { emoji: "💙", name: "blue heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["blue_heart"]) },
    Emoji { emoji: "🩵", name: "light blue heart", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["light_blue_heart"]) },
    Emoji { emoji: "💜", name: "purple heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["purple_heart"]) },
    Emoji { emoji: "🤎", name: "brown heart", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["brown_heart"]) },
    Emoji { emoji: "🖤", name: "black heart", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["black_heart"]) },
    Emoji { emoji: "🩶", name: "grey heart", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["grey_heart"]) },
    Emoji { emoji: "🤍", name: "white heart", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["white_heart"]) },
    Emoji { emoji: "💋", name: "kiss mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["kiss"]) },
    Emoji { emoji: "💯", name: "hundred points", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["100"]) },
    Emoji { emoji: "💢", name: "anger symbol", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["anger"]) },
    Emoji { emoji: "💥", name: "collision", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["boom", "collision"]) },
    Emoji { emoji: "💫", name: "dizzy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["dizzy"]) },
    Emoji { emoji: "💦", name: "sweat droplets", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["sweat_drops"]) },
    Emoji { emoji: "💨", name: "dashing away", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["dash"]) },
    Emoji { emoji: "🕳️", name: "hole", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["hole"]) },
    Emoji { emoji: "💬", name: "speech balloon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["speech_balloon"]) },
    Emoji { emoji: "👁️‍🗨️", name: "eye in speech bubble", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["eye_speech_bubble"]) },
    Emoji { emoji: "🗨️", name: "left speech bubble", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["left_speech_bubble"]) },
    Emoji { emoji: "🗯️", name: "right anger bubble", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["right_anger_bubble"]) },
    Emoji { emoji: "💭", name: "thought balloon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["thought_balloon"]) },
    Emoji { emoji: "💤", name: "ZZZ", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::SmileysAndEmotion, skin_tone: None, shortcodes: Some(&["zzz"]) },
    Emoji { emoji: "👋", name: "waving hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((169, 6, SkinTone::Default)), shortcodes: Some(&["wave"]) },
    Emoji { emoji: "👋🏻", name: "waving hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((169, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👋🏼", name: "waving hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((169, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👋🏽", name: "waving hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((169, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👋🏾", name: "waving hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((169, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👋🏿", name: "waving hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((169, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤚", name: "raised back of hand", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((175, 6, SkinTone::Default)), shortcodes: Some(&["raised_back_of_hand"]) },
    Emoji { emoji: "🤚🏻", name: "raised back of hand: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((175, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤚🏼", name: "raised back of hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((175, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤚🏽", name: "raised back of hand: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((175, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤚🏾", name: "raised back of hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((175, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤚🏿", name: "raised back of hand: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((175, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🖐️", name: "hand with fingers splayed", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((181, 6, SkinTone::Default)), shortcodes: Some(&["raised_hand_with_fingers_splayed"]) },
    Emoji { emoji: "🖐🏻", name: "hand with fingers splayed: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((181, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🖐🏼", name: "hand with fingers splayed: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((181, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🖐🏽", name: "hand with fingers splayed: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((181, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🖐🏾", name: "hand with fingers splayed: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((181, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🖐🏿", name: "hand with fingers splayed: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((181, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "✋", name: "raised hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((187, 6, SkinTone::Default)), shortcodes: Some(&["hand", "raised_hand"]) },
    Emoji { emoji: "✋🏻", name: "raised hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((187, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "✋🏼", name: "raised hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((187, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "✋🏽", name: "raised hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((187, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "✋🏾", name: "raised hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((187, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "✋🏿", name: "raised hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((187, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🖖", name: "vulcan salute", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, 6, SkinTone::Default)), shortcodes: Some(&["vulcan_salute"]) },
    Emoji { emoji: "🖖🏻", name: "vulcan salute: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🖖🏼", name: "vulcan salute: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🖖🏽", name: "vulcan salute: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🖖🏾", name: "vulcan salute: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🖖🏿", name: "vulcan salute: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((193, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫱", name: "rightwards hand", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, 6, SkinTone::Default)), shortcodes: Some(&["rightwards_hand"]) },
    Emoji { emoji: "🫱🏻", name: "rightwards hand: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫱🏼", name: "rightwards hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫱🏽", name: "rightwards hand: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫱🏾", name: "rightwards hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫱🏿", name: "rightwards hand: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((199, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫲", name: "leftwards hand", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, 6, SkinTone::Default)), shortcodes: Some(&["leftwards_hand"]) },
    Emoji { emoji: "🫲🏻", name: "leftwards hand: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫲🏼", name: "leftwards hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫲🏽", name: "leftwards hand: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫲🏾", name: "leftwards hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫲🏿", name: "leftwards hand: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((205, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫳", name: "palm down hand", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, 6, SkinTone::Default)), shortcodes: Some(&["palm_down_hand"]) },
    Emoji { emoji: "🫳🏻", name: "palm down hand: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫳🏼", name: "palm down hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫳🏽", name: "palm down hand: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫳🏾", name: "palm down hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫳🏿", name: "palm down hand: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((211, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫴", name: "palm up hand", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((217, 6, SkinTone::Default)), shortcodes: Some(&["palm_up_hand"]) },
    Emoji { emoji: "🫴🏻", name: "palm up hand: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((217, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫴🏼", name: "palm up hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((217, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫴🏽", name: "palm up hand: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((217, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫴🏾", name: "palm up hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((217, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫴🏿", name: "palm up hand: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((217, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫷", name: "leftwards pushing hand", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, 6, SkinTone::Default)), shortcodes: Some(&["leftwards_pushing_hand"]) },
    Emoji { emoji: "🫷🏻", name: "leftwards pushing hand: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫷🏼", name: "leftwards pushing hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫷🏽", name: "leftwards pushing hand: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫷🏾", name: "leftwards pushing hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫷🏿", name: "leftwards pushing hand: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((223, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫸", name: "rightwards pushing hand", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, 6, SkinTone::Default)), shortcodes: Some(&["rightwards_pushing_hand"]) },
    Emoji { emoji: "🫸🏻", name: "rightwards pushing hand: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫸🏼", name: "rightwards pushing hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫸🏽", name: "rightwards pushing hand: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫸🏾", name: "rightwards pushing hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫸🏿", name: "rightwards pushing hand: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((229, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👌", name: "OK hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((235, 6, SkinTone::Default)), shortcodes: Some(&["ok_hand"]) },
    Emoji { emoji: "👌🏻", name: "OK hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((235, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👌🏼", name: "OK hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((235, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👌🏽", name: "OK hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((235, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👌🏾", name: "OK hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((235, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👌🏿", name: "OK hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((235, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤌", name: "pinched fingers", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, 6, SkinTone::Default)), shortcodes: Some(&["pinched_fingers"]) },
    Emoji { emoji: "🤌🏻", name: "pinched fingers: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤌🏼", name: "pinched fingers: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤌🏽", name: "pinched fingers: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤌🏾", name: "pinched fingers: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤌🏿", name: "pinched fingers: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((241, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤏", name: "pinching hand", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, 6, SkinTone::Default)), shortcodes: Some(&["pinching_hand"]) },
    Emoji { emoji: "🤏🏻", name: "pinching hand: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤏🏼", name: "pinching hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤏🏽", name: "pinching hand: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤏🏾", name: "pinching hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤏🏿", name: "pinching hand: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((247, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "✌️", name: "victory hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((253, 6, SkinTone::Default)), shortcodes: Some(&["v"]) },
    Emoji { emoji: "✌🏻", name: "victory hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((253, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "✌🏼", name: "victory hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((253, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "✌🏽", name: "victory hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((253, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "✌🏾", name: "victory hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((253, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "✌🏿", name: "victory hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((253, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤞", name: "crossed fingers", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, 6, SkinTone::Default)), shortcodes: Some(&["crossed_fingers"]) },
    Emoji { emoji: "🤞🏻", name: "crossed fingers: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤞🏼", name: "crossed fingers: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤞🏽", name: "crossed fingers: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤞🏾", name: "crossed fingers: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤞🏿", name: "crossed fingers: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((259, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫰", name: "hand with index finger and thumb crossed", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, 6, SkinTone::Default)), shortcodes: Some(&["hand_with_index_finger_and_thumb_crossed"]) },
    Emoji { emoji: "🫰🏻", name: "hand with index finger and thumb crossed: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫰🏼", name: "hand with index finger and thumb crossed: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫰🏽", name: "hand with index finger and thumb crossed: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫰🏾", name: "hand with index finger and thumb crossed: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫰🏿", name: "hand with index finger and thumb crossed: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((265, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤟", name: "love-you gesture", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((271, 6, SkinTone::Default)), shortcodes: Some(&["love_you_gesture"]) },
    Emoji { emoji: "🤟🏻", name: "love-you gesture: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((271, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤟🏼", name: "love-you gesture: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((271, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤟🏽", name: "love-you gesture: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((271, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤟🏾", name: "love-you gesture: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((271, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤟🏿", name: "love-you gesture: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((271, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤘", name: "sign of the horns", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((277, 6, SkinTone::Default)), shortcodes: Some(&["metal"]) },
    Emoji { emoji: "🤘🏻", name: "sign of the horns: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((277, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤘🏼", name: "sign of the horns: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((277, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤘🏽", name: "sign of the horns: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((277, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤘🏾", name: "sign of the horns: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((277, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤘🏿", name: "sign of the horns: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((277, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤙", name: "call me hand", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((283, 6, SkinTone::Default)), shortcodes: Some(&["call_me_hand"]) },
    Emoji { emoji: "🤙🏻", name: "call me hand: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((283, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤙🏼", name: "call me hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((283, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤙🏽", name: "call me hand: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((283, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤙🏾", name: "call me hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((283, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤙🏿", name: "call me hand: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((283, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👈", name: "backhand index pointing left", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((289, 6, SkinTone::Default)), shortcodes: Some(&["point_left"]) },
    Emoji { emoji: "👈🏻", name: "backhand index pointing left: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((289, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👈🏼", name: "backhand index pointing left: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((289, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👈🏽", name: "backhand index pointing left: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((289, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👈🏾", name: "backhand index pointing left: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((289, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👈🏿", name: "backhand index pointing left: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((289, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👉", name: "backhand index pointing right", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((295, 6, SkinTone::Default)), shortcodes: Some(&["point_right"]) },
    Emoji { emoji: "👉🏻", name: "backhand index pointing right: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((295, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👉🏼", name: "backhand index pointing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((295, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👉🏽", name: "backhand index pointing right: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((295, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👉🏾", name: "backhand index pointing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((295, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👉🏿", name: "backhand index pointing right: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((295, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👆", name: "backhand index pointing up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((301, 6, SkinTone::Default)), shortcodes: Some(&["point_up_2"]) },
    Emoji { emoji: "👆🏻", name: "backhand index pointing up: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((301, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👆🏼", name: "backhand index pointing up: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((301, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👆🏽", name: "backhand index pointing up: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((301, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👆🏾", name: "backhand index pointing up: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((301, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👆🏿", name: "backhand index pointing up: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((301, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🖕", name: "middle finger", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, 6, SkinTone::Default)), shortcodes: Some(&["middle_finger", "fu"]) },
    Emoji { emoji: "🖕🏻", name: "middle finger: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🖕🏼", name: "middle finger: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🖕🏽", name: "middle finger: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🖕🏾", name: "middle finger: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🖕🏿", name: "middle finger: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((307, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👇", name: "backhand index pointing down", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((313, 6, SkinTone::Default)), shortcodes: Some(&["point_down"]) },
    Emoji { emoji: "👇🏻", name: "backhand index pointing down: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((313, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👇🏼", name: "backhand index pointing down: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((313, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👇🏽", name: "backhand index pointing down: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((313, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👇🏾", name: "backhand index pointing down: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((313, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👇🏿", name: "backhand index pointing down: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((313, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "☝️", name: "index pointing up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((319, 6, SkinTone::Default)), shortcodes: Some(&["point_up"]) },
    Emoji { emoji: "☝🏻", name: "index pointing up: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((319, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "☝🏼", name: "index pointing up: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((319, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "☝🏽", name: "index pointing up: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((319, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "☝🏾", name: "index pointing up: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((319, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "☝🏿", name: "index pointing up: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((319, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫵", name: "index pointing at the viewer", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((325, 6, SkinTone::Default)), shortcodes: Some(&["index_pointing_at_the_viewer"]) },
    Emoji { emoji: "🫵🏻", name: "index pointing at the viewer: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((325, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫵🏼", name: "index pointing at the viewer: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((325, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫵🏽", name: "index pointing at the viewer: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((325, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫵🏾", name: "index pointing at the viewer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((325, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫵🏿", name: "index pointing at the viewer: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((325, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👍", name: "thumbs up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((331, 6, SkinTone::Default)), shortcodes: Some(&["+1", "thumbsup"]) },
    Emoji { emoji: "👍🏻", name: "thumbs up: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((331, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👍🏼", name: "thumbs up: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((331, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👍🏽", name: "thumbs up: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((331, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👍🏾", name: "thumbs up: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((331, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👍🏿", name: "thumbs up: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((331, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👎", name: "thumbs down", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((337, 6, SkinTone::Default)), shortcodes: Some(&["-1", "thumbsdown"]) },
    Emoji { emoji: "👎🏻", name: "thumbs down: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((337, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👎🏼", name: "thumbs down: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((337, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👎🏽", name: "thumbs down: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((337, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👎🏾", name: "thumbs down: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((337, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👎🏿", name: "thumbs down: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((337, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "✊", name: "raised fist", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((343, 6, SkinTone::Default)), shortcodes: Some(&["fist_raised", "fist"]) },
    Emoji { emoji: "✊🏻", name: "raised fist: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((343, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "✊🏼", name: "raised fist: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((343, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "✊🏽", name: "raised fist: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((343, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "✊🏾", name: "raised fist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((343, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "✊🏿", name: "raised fist: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((343, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👊", name: "oncoming fist", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((349, 6, SkinTone::Default)), shortcodes: Some(&["fist_oncoming", "facepunch", "punch"]) },
    Emoji { emoji: "👊🏻", name: "oncoming fist: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((349, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👊🏼", name: "oncoming fist: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((349, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👊🏽", name: "oncoming fist: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((349, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👊🏾", name: "oncoming fist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((349, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👊🏿", name: "oncoming fist: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((349, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤛", name: "left-facing fist", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((355, 6, SkinTone::Default)), shortcodes: Some(&["fist_left"]) },
    Emoji { emoji: "🤛🏻", name: "left-facing fist: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((355, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤛🏼", name: "left-facing fist: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((355, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤛🏽", name: "left-facing fist: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((355, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤛🏾", name: "left-facing fist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((355, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤛🏿", name: "left-facing fist: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((355, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤜", name: "right-facing fist", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, 6, SkinTone::Default)), shortcodes: Some(&["fist_right"]) },
    Emoji { emoji: "🤜🏻", name: "right-facing fist: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤜🏼", name: "right-facing fist: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤜🏽", name: "right-facing fist: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤜🏾", name: "right-facing fist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤜🏿", name: "right-facing fist: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((361, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👏", name: "clapping hands", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((367, 6, SkinTone::Default)), shortcodes: Some(&["clap"]) },
    Emoji { emoji: "👏🏻", name: "clapping hands: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((367, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👏🏼", name: "clapping hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((367, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👏🏽", name: "clapping hands: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((367, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👏🏾", name: "clapping hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((367, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👏🏿", name: "clapping hands: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((367, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙌", name: "raising hands", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((373, 6, SkinTone::Default)), shortcodes: Some(&["raised_hands"]) },
    Emoji { emoji: "🙌🏻", name: "raising hands: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((373, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙌🏼", name: "raising hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((373, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙌🏽", name: "raising hands: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((373, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙌🏾", name: "raising hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((373, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙌🏿", name: "raising hands: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((373, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫶", name: "heart hands", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, 6, SkinTone::Default)), shortcodes: Some(&["heart_hands"]) },
    Emoji { emoji: "🫶🏻", name: "heart hands: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫶🏼", name: "heart hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫶🏽", name: "heart hands: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫶🏾", name: "heart hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫶🏿", name: "heart hands: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((379, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👐", name: "open hands", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((385, 6, SkinTone::Default)), shortcodes: Some(&["open_hands"]) },
    Emoji { emoji: "👐🏻", name: "open hands: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((385, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👐🏼", name: "open hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((385, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👐🏽", name: "open hands: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((385, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👐🏾", name: "open hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((385, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👐🏿", name: "open hands: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((385, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤲", name: "palms up together", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((391, 6, SkinTone::Default)), shortcodes: Some(&["palms_up_together"]) },
    Emoji { emoji: "🤲🏻", name: "palms up together: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((391, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤲🏼", name: "palms up together: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((391, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤲🏽", name: "palms up together: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((391, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤲🏾", name: "palms up together: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((391, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤲🏿", name: "palms up together: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((391, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤝", name: "handshake", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::Default)), shortcodes: Some(&["handshake"]) },
    Emoji { emoji: "🤝🏻", name: "handshake: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤝🏼", name: "handshake: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤝🏽", name: "handshake: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤝🏾", name: "handshake: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤝🏿", name: "handshake: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫱🏻‍🫲🏼", name: "handshake: light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🫱🏻‍🫲🏽", name: "handshake: light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "🫱🏻‍🫲🏾", name: "handshake: light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🫱🏻‍🫲🏿", name: "handshake: light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "🫱🏼‍🫲🏻", name: "handshake: medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "🫱🏼‍🫲🏽", name: "handshake: medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "🫱🏼‍🫲🏾", name: "handshake: medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🫱🏼‍🫲🏿", name: "handshake: medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "🫱🏽‍🫲🏻", name: "handshake: medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "🫱🏽‍🫲🏼", name: "handshake: medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🫱🏽‍🫲🏾", name: "handshake: medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🫱🏽‍🫲🏿", name: "handshake: medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "🫱🏾‍🫲🏻", name: "handshake: medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "🫱🏾‍🫲🏼", name: "handshake: medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🫱🏾‍🫲🏽", name: "handshake: medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "🫱🏾‍🫲🏿", name: "handshake: medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "🫱🏿‍🫲🏻", name: "handshake: dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "🫱🏿‍🫲🏼", name: "handshake: dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🫱🏿‍🫲🏽", name: "handshake: dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "🫱🏿‍🫲🏾", name: "handshake: dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((397, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🙏", name: "folded hands", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((423, 6, SkinTone::Default)), shortcodes: Some(&["pray"]) },
    Emoji { emoji: "🙏🏻", name: "folded hands: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((423, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙏🏼", name: "folded hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((423, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙏🏽", name: "folded hands: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((423, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙏🏾", name: "folded hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((423, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙏🏿", name: "folded hands: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((423, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "✍️", name: "writing hand", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((429, 6, SkinTone::Default)), shortcodes: Some(&["writing_hand"]) },
    Emoji { emoji: "✍🏻", name: "writing hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((429, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "✍🏼", name: "writing hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((429, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "✍🏽", name: "writing hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((429, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "✍🏾", name: "writing hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((429, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "✍🏿", name: "writing hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((429, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💅", name: "nail polish", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((435, 6, SkinTone::Default)), shortcodes: Some(&["nail_care"]) },
    Emoji { emoji: "💅🏻", name: "nail polish: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((435, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💅🏼", name: "nail polish: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((435, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💅🏽", name: "nail polish: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((435, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💅🏾", name: "nail polish: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((435, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💅🏿", name: "nail polish: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((435, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤳", name: "selfie", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((441, 6, SkinTone::Default)), shortcodes: Some(&["selfie"]) },
    Emoji { emoji: "🤳🏻", name: "selfie: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((441, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤳🏼", name: "selfie: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((441, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤳🏽", name: "selfie: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((441, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤳🏾", name: "selfie: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((441, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤳🏿", name: "selfie: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((441, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💪", name: "flexed biceps", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((447, 6, SkinTone::Default)), shortcodes: Some(&["muscle"]) },
    Emoji { emoji: "💪🏻", name: "flexed biceps: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((447, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💪🏼", name: "flexed biceps: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((447, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💪🏽", name: "flexed biceps: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((447, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💪🏾", name: "flexed biceps: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((447, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💪🏿", name: "flexed biceps: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((447, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🦾", name: "mechanical arm", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["mechanical_arm"]) },
    Emoji { emoji: "🦿", name: "mechanical leg", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["mechanical_leg"]) },
    Emoji { emoji: "🦵", name: "leg", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((455, 6, SkinTone::Default)), shortcodes: Some(&["leg"]) },
    Emoji { emoji: "🦵🏻", name: "leg: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((455, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🦵🏼", name: "leg: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((455, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🦵🏽", name: "leg: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((455, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🦵🏾", name: "leg: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((455, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🦵🏿", name: "leg: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((455, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🦶", name: "foot", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((461, 6, SkinTone::Default)), shortcodes: Some(&["foot"]) },
    Emoji { emoji: "🦶🏻", name: "foot: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((461, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🦶🏼", name: "foot: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((461, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🦶🏽", name: "foot: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((461, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🦶🏾", name: "foot: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((461, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🦶🏿", name: "foot: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((461, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👂", name: "ear", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((467, 6, SkinTone::Default)), shortcodes: Some(&["ear"]) },
    Emoji { emoji: "👂🏻", name: "ear: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((467, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👂🏼", name: "ear: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((467, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👂🏽", name: "ear: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((467, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👂🏾", name: "ear: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((467, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👂🏿", name: "ear: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((467, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🦻", name: "ear with hearing aid", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((473, 6, SkinTone::Default)), shortcodes: Some(&["ear_with_hearing_aid"]) },
    Emoji { emoji: "🦻🏻", name: "ear with hearing aid: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((473, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🦻🏼", name: "ear with hearing aid: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((473, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🦻🏽", name: "ear with hearing aid: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((473, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🦻🏾", name: "ear with hearing aid: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((473, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🦻🏿", name: "ear with hearing aid: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((473, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👃", name: "nose", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((479, 6, SkinTone::Default)), shortcodes: Some(&["nose"]) },
    Emoji { emoji: "👃🏻", name: "nose: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((479, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👃🏼", name: "nose: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((479, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👃🏽", name: "nose: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((479, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👃🏾", name: "nose: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((479, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👃🏿", name: "nose: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((479, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧠", name: "brain", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["brain"]) },
    Emoji { emoji: "🫀", name: "anatomical heart", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["anatomical_heart"]) },
    Emoji { emoji: "🫁", name: "lungs", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["lungs"]) },
    Emoji { emoji: "🦷", name: "tooth", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["tooth"]) },
    Emoji { emoji: "🦴", name: "bone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["bone"]) },
    Emoji { emoji: "👀", name: "eyes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["eyes"]) },
    Emoji { emoji: "👁️", name: "eye", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["eye"]) },
    Emoji { emoji: "👅", name: "tongue", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["tongue"]) },
    Emoji { emoji: "👄", name: "mouth", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["lips"]) },
    Emoji { emoji: "🫦", name: "biting lip", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["biting_lip"]) },
    Emoji { emoji: "👶", name: "baby", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((495, 6, SkinTone::Default)), shortcodes: Some(&["baby"]) },
    Emoji { emoji: "👶🏻", name: "baby: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((495, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👶🏼", name: "baby: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((495, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👶🏽", name: "baby: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((495, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👶🏾", name: "baby: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((495, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👶🏿", name: "baby: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((495, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧒", name: "child", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((501, 6, SkinTone::Default)), shortcodes: Some(&["child"]) },
    Emoji { emoji: "🧒🏻", name: "child: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((501, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧒🏼", name: "child: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((501, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧒🏽", name: "child: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((501, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧒🏾", name: "child: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((501, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧒🏿", name: "child: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((501, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👦", name: "boy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((507, 6, SkinTone::Default)), shortcodes: Some(&["boy"]) },
    Emoji { emoji: "👦🏻", name: "boy: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((507, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👦🏼", name: "boy: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((507, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👦🏽", name: "boy: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((507, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👦🏾", name: "boy: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((507, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👦🏿", name: "boy: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((507, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👧", name: "girl", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((513, 6, SkinTone::Default)), shortcodes: Some(&["girl"]) },
    Emoji { emoji: "👧🏻", name: "girl: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((513, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👧🏼", name: "girl: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((513, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👧🏽", name: "girl: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((513, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👧🏾", name: "girl: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((513, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👧🏿", name: "girl: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((513, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑", name: "person", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((519, 6, SkinTone::Default)), shortcodes: Some(&["adult"]) },
    Emoji { emoji: "🧑🏻", name: "person: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((519, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼", name: "person: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((519, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽", name: "person: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((519, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾", name: "person: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((519, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿", name: "person: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((519, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👱", name: "person: blond hair", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((525, 6, SkinTone::Default)), shortcodes: Some(&["blond_haired_person"]) },
    Emoji { emoji: "👱🏻", name: "person: light skin tone, blond hair", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((525, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👱🏼", name: "person: medium-light skin tone, blond hair", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((525, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👱🏽", name: "person: medium skin tone, blond hair", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((525, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👱🏾", name: "person: medium-dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((525, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👱🏿", name: "person: dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((525, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨", name: "man", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((531, 6, SkinTone::Default)), shortcodes: Some(&["man"]) },
    Emoji { emoji: "👨🏻", name: "man: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((531, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼", name: "man: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((531, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽", name: "man: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((531, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾", name: "man: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((531, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿", name: "man: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((531, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧔", name: "person: beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((537, 6, SkinTone::Default)), shortcodes: Some(&["bearded_person"]) },
    Emoji { emoji: "🧔🏻", name: "person: light skin tone, beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((537, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧔🏼", name: "person: medium-light skin tone, beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((537, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧔🏽", name: "person: medium skin tone, beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((537, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧔🏾", name: "person: medium-dark skin tone, beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((537, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧔🏿", name: "person: dark skin tone, beard", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((537, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧔‍♂️", name: "man: beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((543, 6, SkinTone::Default)), shortcodes: Some(&["man_beard"]) },
    Emoji { emoji: "🧔🏻‍♂️", name: "man: light skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((543, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧔🏼‍♂️", name: "man: medium-light skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((543, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧔🏽‍♂️", name: "man: medium skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((543, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧔🏾‍♂️", name: "man: medium-dark skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((543, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧔🏿‍♂️", name: "man: dark skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((543, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧔‍♀️", name: "woman: beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((549, 6, SkinTone::Default)), shortcodes: Some(&["woman_beard"]) },
    Emoji { emoji: "🧔🏻‍♀️", name: "woman: light skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((549, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧔🏼‍♀️", name: "woman: medium-light skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((549, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧔🏽‍♀️", name: "woman: medium skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((549, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧔🏾‍♀️", name: "woman: medium-dark skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((549, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧔🏿‍♀️", name: "woman: dark skin tone, beard", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((549, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🦰", name: "man: red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((555, 6, SkinTone::Default)), shortcodes: Some(&["red_haired_man"]) },
    Emoji { emoji: "👨🏻‍🦰", name: "man: light skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((555, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🦰", name: "man: medium-light skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((555, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🦰", name: "man: medium skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((555, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🦰", name: "man: medium-dark skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((555, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🦰", name: "man: dark skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((555, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🦱", name: "man: curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((561, 6, SkinTone::Default)), shortcodes: Some(&["curly_haired_man"]) },
    Emoji { emoji: "👨🏻‍🦱", name: "man: light skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((561, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🦱", name: "man: medium-light skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((561, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🦱", name: "man: medium skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((561, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🦱", name: "man: medium-dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((561, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🦱", name: "man: dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((561, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🦳", name: "man: white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((567, 6, SkinTone::Default)), shortcodes: Some(&["white_haired_man"]) },
    Emoji { emoji: "👨🏻‍🦳", name: "man: light skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((567, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🦳", name: "man: medium-light skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((567, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🦳", name: "man: medium skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((567, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🦳", name: "man: medium-dark skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((567, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🦳", name: "man: dark skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((567, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🦲", name: "man: bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((573, 6, SkinTone::Default)), shortcodes: Some(&["bald_man"]) },
    Emoji { emoji: "👨🏻‍🦲", name: "man: light skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((573, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🦲", name: "man: medium-light skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((573, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🦲", name: "man: medium skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((573, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🦲", name: "man: medium-dark skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((573, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🦲", name: "man: dark skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((573, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩", name: "woman", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((579, 6, SkinTone::Default)), shortcodes: Some(&["woman"]) },
    Emoji { emoji: "👩🏻", name: "woman: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((579, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼", name: "woman: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((579, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽", name: "woman: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((579, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾", name: "woman: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((579, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿", name: "woman: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((579, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🦰", name: "woman: red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((585, 6, SkinTone::Default)), shortcodes: Some(&["red_haired_woman"]) },
    Emoji { emoji: "👩🏻‍🦰", name: "woman: light skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((585, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🦰", name: "woman: medium-light skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((585, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🦰", name: "woman: medium skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((585, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🦰", name: "woman: medium-dark skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((585, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🦰", name: "woman: dark skin tone, red hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((585, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🦰", name: "person: red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((591, 6, SkinTone::Default)), shortcodes: Some(&["person_red_hair"]) },
    Emoji { emoji: "🧑🏻‍🦰", name: "person: light skin tone, red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((591, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🦰", name: "person: medium-light skin tone, red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((591, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🦰", name: "person: medium skin tone, red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((591, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🦰", name: "person: medium-dark skin tone, red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((591, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🦰", name: "person: dark skin tone, red hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((591, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🦱", name: "woman: curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((597, 6, SkinTone::Default)), shortcodes: Some(&["curly_haired_woman"]) },
    Emoji { emoji: "👩🏻‍🦱", name: "woman: light skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((597, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🦱", name: "woman: medium-light skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((597, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🦱", name: "woman: medium skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((597, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🦱", name: "woman: medium-dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((597, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🦱", name: "woman: dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((597, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🦱", name: "person: curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((603, 6, SkinTone::Default)), shortcodes: Some(&["person_curly_hair"]) },
    Emoji { emoji: "🧑🏻‍🦱", name: "person: light skin tone, curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((603, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🦱", name: "person: medium-light skin tone, curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((603, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🦱", name: "person: medium skin tone, curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((603, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🦱", name: "person: medium-dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((603, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🦱", name: "person: dark skin tone, curly hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((603, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🦳", name: "woman: white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((609, 6, SkinTone::Default)), shortcodes: Some(&["white_haired_woman"]) },
    Emoji { emoji: "👩🏻‍🦳", name: "woman: light skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((609, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🦳", name: "woman: medium-light skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((609, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🦳", name: "woman: medium skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((609, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🦳", name: "woman: medium-dark skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((609, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🦳", name: "woman: dark skin tone, white hair", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((609, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🦳", name: "person: white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((615, 6, SkinTone::Default)), shortcodes: Some(&["person_white_hair"]) },
    Emoji { emoji: "🧑🏻‍🦳", name: "person: light skin tone, white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((615, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🦳", name: "person: medium-light skin tone, white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((615, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🦳", name: "person: medium skin tone, white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((615, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🦳", name: "person: medium-dark skin tone, white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((615, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🦳", name: "person: dark skin tone, white hair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((615, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🦲", name: "woman: bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((621, 6, SkinTone::Default)), shortcodes: Some(&["bald_woman"]) },
    Emoji { emoji: "👩🏻‍🦲", name: "woman: light skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((621, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🦲", name: "woman: medium-light skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((621, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🦲", name: "woman: medium skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((621, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🦲", name: "woman: medium-dark skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((621, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🦲", name: "woman: dark skin tone, bald", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((621, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🦲", name: "person: bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((627, 6, SkinTone::Default)), shortcodes: Some(&["person_bald"]) },
    Emoji { emoji: "🧑🏻‍🦲", name: "person: light skin tone, bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((627, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🦲", name: "person: medium-light skin tone, bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((627, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🦲", name: "person: medium skin tone, bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((627, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🦲", name: "person: medium-dark skin tone, bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((627, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🦲", name: "person: dark skin tone, bald", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((627, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👱‍♀️", name: "woman: blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((633, 6, SkinTone::Default)), shortcodes: Some(&["blond_haired_woman", "blonde_woman"]) },
    Emoji { emoji: "👱🏻‍♀️", name: "woman: light skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((633, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👱🏼‍♀️", name: "woman: medium-light skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((633, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👱🏽‍♀️", name: "woman: medium skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((633, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👱🏾‍♀️", name: "woman: medium-dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((633, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👱🏿‍♀️", name: "woman: dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((633, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👱‍♂️", name: "man: blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((639, 6, SkinTone::Default)), shortcodes: Some(&["blond_haired_man"]) },
    Emoji { emoji: "👱🏻‍♂️", name: "man: light skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((639, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👱🏼‍♂️", name: "man: medium-light skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((639, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👱🏽‍♂️", name: "man: medium skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((639, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👱🏾‍♂️", name: "man: medium-dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((639, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👱🏿‍♂️", name: "man: dark skin tone, blond hair", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((639, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧓", name: "older person", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((645, 6, SkinTone::Default)), shortcodes: Some(&["older_adult"]) },
    Emoji { emoji: "🧓🏻", name: "older person: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((645, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧓🏼", name: "older person: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((645, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧓🏽", name: "older person: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((645, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧓🏾", name: "older person: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((645, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧓🏿", name: "older person: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((645, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👴", name: "old man", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((651, 6, SkinTone::Default)), shortcodes: Some(&["older_man"]) },
    Emoji { emoji: "👴🏻", name: "old man: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((651, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👴🏼", name: "old man: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((651, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👴🏽", name: "old man: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((651, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👴🏾", name: "old man: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((651, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👴🏿", name: "old man: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((651, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👵", name: "old woman", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((657, 6, SkinTone::Default)), shortcodes: Some(&["older_woman"]) },
    Emoji { emoji: "👵🏻", name: "old woman: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((657, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👵🏼", name: "old woman: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((657, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👵🏽", name: "old woman: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((657, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👵🏾", name: "old woman: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((657, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👵🏿", name: "old woman: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((657, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙍", name: "person frowning", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((663, 6, SkinTone::Default)), shortcodes: Some(&["frowning_person"]) },
    Emoji { emoji: "🙍🏻", name: "person frowning: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((663, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙍🏼", name: "person frowning: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((663, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙍🏽", name: "person frowning: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((663, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙍🏾", name: "person frowning: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((663, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙍🏿", name: "person frowning: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((663, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙍‍♂️", name: "man frowning", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((669, 6, SkinTone::Default)), shortcodes: Some(&["frowning_man"]) },
    Emoji { emoji: "🙍🏻‍♂️", name: "man frowning: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((669, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙍🏼‍♂️", name: "man frowning: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((669, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙍🏽‍♂️", name: "man frowning: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((669, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙍🏾‍♂️", name: "man frowning: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((669, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙍🏿‍♂️", name: "man frowning: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((669, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙍‍♀️", name: "woman frowning", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((675, 6, SkinTone::Default)), shortcodes: Some(&["frowning_woman"]) },
    Emoji { emoji: "🙍🏻‍♀️", name: "woman frowning: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((675, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙍🏼‍♀️", name: "woman frowning: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((675, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙍🏽‍♀️", name: "woman frowning: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((675, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙍🏾‍♀️", name: "woman frowning: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((675, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙍🏿‍♀️", name: "woman frowning: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((675, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙎", name: "person pouting", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((681, 6, SkinTone::Default)), shortcodes: Some(&["pouting_face"]) },
    Emoji { emoji: "🙎🏻", name: "person pouting: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((681, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙎🏼", name: "person pouting: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((681, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙎🏽", name: "person pouting: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((681, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙎🏾", name: "person pouting: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((681, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙎🏿", name: "person pouting: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((681, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙎‍♂️", name: "man pouting", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((687, 6, SkinTone::Default)), shortcodes: Some(&["pouting_man"]) },
    Emoji { emoji: "🙎🏻‍♂️", name: "man pouting: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((687, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙎🏼‍♂️", name: "man pouting: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((687, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙎🏽‍♂️", name: "man pouting: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((687, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙎🏾‍♂️", name: "man pouting: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((687, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙎🏿‍♂️", name: "man pouting: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((687, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙎‍♀️", name: "woman pouting", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((693, 6, SkinTone::Default)), shortcodes: Some(&["pouting_woman"]) },
    Emoji { emoji: "🙎🏻‍♀️", name: "woman pouting: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((693, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙎🏼‍♀️", name: "woman pouting: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((693, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙎🏽‍♀️", name: "woman pouting: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((693, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙎🏾‍♀️", name: "woman pouting: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((693, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙎🏿‍♀️", name: "woman pouting: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((693, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙅", name: "person gesturing NO", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((699, 6, SkinTone::Default)), shortcodes: Some(&["no_good"]) },
    Emoji { emoji: "🙅🏻", name: "person gesturing NO: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((699, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙅🏼", name: "person gesturing NO: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((699, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙅🏽", name: "person gesturing NO: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((699, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙅🏾", name: "person gesturing NO: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((699, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙅🏿", name: "person gesturing NO: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((699, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙅‍♂️", name: "man gesturing NO", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((705, 6, SkinTone::Default)), shortcodes: Some(&["no_good_man", "ng_man"]) },
    Emoji { emoji: "🙅🏻‍♂️", name: "man gesturing NO: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((705, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙅🏼‍♂️", name: "man gesturing NO: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((705, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙅🏽‍♂️", name: "man gesturing NO: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((705, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙅🏾‍♂️", name: "man gesturing NO: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((705, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙅🏿‍♂️", name: "man gesturing NO: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((705, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙅‍♀️", name: "woman gesturing NO", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((711, 6, SkinTone::Default)), shortcodes: Some(&["no_good_woman", "ng_woman"]) },
    Emoji { emoji: "🙅🏻‍♀️", name: "woman gesturing NO: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((711, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙅🏼‍♀️", name: "woman gesturing NO: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((711, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙅🏽‍♀️", name: "woman gesturing NO: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((711, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙅🏾‍♀️", name: "woman gesturing NO: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((711, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙅🏿‍♀️", name: "woman gesturing NO: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((711, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙆", name: "person gesturing OK", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((717, 6, SkinTone::Default)), shortcodes: Some(&["ok_person"]) },
    Emoji { emoji: "🙆🏻", name: "person gesturing OK: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((717, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙆🏼", name: "person gesturing OK: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((717, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙆🏽", name: "person gesturing OK: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((717, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙆🏾", name: "person gesturing OK: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((717, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙆🏿", name: "person gesturing OK: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((717, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙆‍♂️", name: "man gesturing OK", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((723, 6, SkinTone::Default)), shortcodes: Some(&["ok_man"]) },
    Emoji { emoji: "🙆🏻‍♂️", name: "man gesturing OK: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((723, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙆🏼‍♂️", name: "man gesturing OK: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((723, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙆🏽‍♂️", name: "man gesturing OK: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((723, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙆🏾‍♂️", name: "man gesturing OK: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((723, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙆🏿‍♂️", name: "man gesturing OK: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((723, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙆‍♀️", name: "woman gesturing OK", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((729, 6, SkinTone::Default)), shortcodes: Some(&["ok_woman"]) },
    Emoji { emoji: "🙆🏻‍♀️", name: "woman gesturing OK: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((729, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙆🏼‍♀️", name: "woman gesturing OK: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((729, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙆🏽‍♀️", name: "woman gesturing OK: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((729, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙆🏾‍♀️", name: "woman gesturing OK: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((729, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙆🏿‍♀️", name: "woman gesturing OK: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((729, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💁", name: "person tipping hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((735, 6, SkinTone::Default)), shortcodes: Some(&["tipping_hand_person", "information_desk_person"]) },
    Emoji { emoji: "💁🏻", name: "person tipping hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((735, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💁🏼", name: "person tipping hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((735, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💁🏽", name: "person tipping hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((735, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💁🏾", name: "person tipping hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((735, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💁🏿", name: "person tipping hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((735, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💁‍♂️", name: "man tipping hand", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((741, 6, SkinTone::Default)), shortcodes: Some(&["tipping_hand_man", "sassy_man"]) },
    Emoji { emoji: "💁🏻‍♂️", name: "man tipping hand: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((741, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💁🏼‍♂️", name: "man tipping hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((741, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💁🏽‍♂️", name: "man tipping hand: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((741, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💁🏾‍♂️", name: "man tipping hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((741, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💁🏿‍♂️", name: "man tipping hand: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((741, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💁‍♀️", name: "woman tipping hand", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((747, 6, SkinTone::Default)), shortcodes: Some(&["tipping_hand_woman", "sassy_woman"]) },
    Emoji { emoji: "💁🏻‍♀️", name: "woman tipping hand: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((747, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💁🏼‍♀️", name: "woman tipping hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((747, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💁🏽‍♀️", name: "woman tipping hand: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((747, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💁🏾‍♀️", name: "woman tipping hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((747, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💁🏿‍♀️", name: "woman tipping hand: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((747, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙋", name: "person raising hand", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((753, 6, SkinTone::Default)), shortcodes: Some(&["raising_hand"]) },
    Emoji { emoji: "🙋🏻", name: "person raising hand: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((753, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙋🏼", name: "person raising hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((753, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙋🏽", name: "person raising hand: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((753, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙋🏾", name: "person raising hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((753, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙋🏿", name: "person raising hand: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((753, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙋‍♂️", name: "man raising hand", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((759, 6, SkinTone::Default)), shortcodes: Some(&["raising_hand_man"]) },
    Emoji { emoji: "🙋🏻‍♂️", name: "man raising hand: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((759, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙋🏼‍♂️", name: "man raising hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((759, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙋🏽‍♂️", name: "man raising hand: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((759, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙋🏾‍♂️", name: "man raising hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((759, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙋🏿‍♂️", name: "man raising hand: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((759, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙋‍♀️", name: "woman raising hand", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((765, 6, SkinTone::Default)), shortcodes: Some(&["raising_hand_woman"]) },
    Emoji { emoji: "🙋🏻‍♀️", name: "woman raising hand: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((765, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙋🏼‍♀️", name: "woman raising hand: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((765, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙋🏽‍♀️", name: "woman raising hand: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((765, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙋🏾‍♀️", name: "woman raising hand: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((765, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙋🏿‍♀️", name: "woman raising hand: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((765, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧏", name: "deaf person", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((771, 6, SkinTone::Default)), shortcodes: Some(&["deaf_person"]) },
    Emoji { emoji: "🧏🏻", name: "deaf person: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((771, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧏🏼", name: "deaf person: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((771, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧏🏽", name: "deaf person: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((771, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧏🏾", name: "deaf person: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((771, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧏🏿", name: "deaf person: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((771, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧏‍♂️", name: "deaf man", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((777, 6, SkinTone::Default)), shortcodes: Some(&["deaf_man"]) },
    Emoji { emoji: "🧏🏻‍♂️", name: "deaf man: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((777, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧏🏼‍♂️", name: "deaf man: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((777, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧏🏽‍♂️", name: "deaf man: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((777, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧏🏾‍♂️", name: "deaf man: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((777, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧏🏿‍♂️", name: "deaf man: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((777, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧏‍♀️", name: "deaf woman", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((783, 6, SkinTone::Default)), shortcodes: Some(&["deaf_woman"]) },
    Emoji { emoji: "🧏🏻‍♀️", name: "deaf woman: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((783, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧏🏼‍♀️", name: "deaf woman: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((783, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧏🏽‍♀️", name: "deaf woman: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((783, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧏🏾‍♀️", name: "deaf woman: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((783, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧏🏿‍♀️", name: "deaf woman: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((783, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙇", name: "person bowing", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((789, 6, SkinTone::Default)), shortcodes: Some(&["bow"]) },
    Emoji { emoji: "🙇🏻", name: "person bowing: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((789, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙇🏼", name: "person bowing: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((789, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙇🏽", name: "person bowing: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((789, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙇🏾", name: "person bowing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((789, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙇🏿", name: "person bowing: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((789, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙇‍♂️", name: "man bowing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((795, 6, SkinTone::Default)), shortcodes: Some(&["bowing_man"]) },
    Emoji { emoji: "🙇🏻‍♂️", name: "man bowing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((795, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙇🏼‍♂️", name: "man bowing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((795, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙇🏽‍♂️", name: "man bowing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((795, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙇🏾‍♂️", name: "man bowing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((795, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙇🏿‍♂️", name: "man bowing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((795, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🙇‍♀️", name: "woman bowing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((801, 6, SkinTone::Default)), shortcodes: Some(&["bowing_woman"]) },
    Emoji { emoji: "🙇🏻‍♀️", name: "woman bowing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((801, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🙇🏼‍♀️", name: "woman bowing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((801, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🙇🏽‍♀️", name: "woman bowing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((801, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🙇🏾‍♀️", name: "woman bowing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((801, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🙇🏿‍♀️", name: "woman bowing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((801, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤦", name: "person facepalming", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((807, 6, SkinTone::Default)), shortcodes: Some(&["facepalm"]) },
    Emoji { emoji: "🤦🏻", name: "person facepalming: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((807, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤦🏼", name: "person facepalming: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((807, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤦🏽", name: "person facepalming: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((807, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤦🏾", name: "person facepalming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((807, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤦🏿", name: "person facepalming: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((807, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤦‍♂️", name: "man facepalming", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((813, 6, SkinTone::Default)), shortcodes: Some(&["man_facepalming"]) },
    Emoji { emoji: "🤦🏻‍♂️", name: "man facepalming: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((813, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤦🏼‍♂️", name: "man facepalming: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((813, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤦🏽‍♂️", name: "man facepalming: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((813, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤦🏾‍♂️", name: "man facepalming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((813, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤦🏿‍♂️", name: "man facepalming: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((813, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤦‍♀️", name: "woman facepalming", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((819, 6, SkinTone::Default)), shortcodes: Some(&["woman_facepalming"]) },
    Emoji { emoji: "🤦🏻‍♀️", name: "woman facepalming: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((819, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤦🏼‍♀️", name: "woman facepalming: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((819, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤦🏽‍♀️", name: "woman facepalming: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((819, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤦🏾‍♀️", name: "woman facepalming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((819, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤦🏿‍♀️", name: "woman facepalming: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((819, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤷", name: "person shrugging", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((825, 6, SkinTone::Default)), shortcodes: Some(&["shrug"]) },
    Emoji { emoji: "🤷🏻", name: "person shrugging: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((825, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤷🏼", name: "person shrugging: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((825, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤷🏽", name: "person shrugging: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((825, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤷🏾", name: "person shrugging: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((825, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤷🏿", name: "person shrugging: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((825, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤷‍♂️", name: "man shrugging", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((831, 6, SkinTone::Default)), shortcodes: Some(&["man_shrugging"]) },
    Emoji { emoji: "🤷🏻‍♂️", name: "man shrugging: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((831, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤷🏼‍♂️", name: "man shrugging: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((831, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤷🏽‍♂️", name: "man shrugging: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((831, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤷🏾‍♂️", name: "man shrugging: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((831, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤷🏿‍♂️", name: "man shrugging: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((831, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤷‍♀️", name: "woman shrugging", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((837, 6, SkinTone::Default)), shortcodes: Some(&["woman_shrugging"]) },
    Emoji { emoji: "🤷🏻‍♀️", name: "woman shrugging: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((837, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤷🏼‍♀️", name: "woman shrugging: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((837, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤷🏽‍♀️", name: "woman shrugging: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((837, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤷🏾‍♀️", name: "woman shrugging: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((837, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤷🏿‍♀️", name: "woman shrugging: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((837, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍⚕️", name: "health worker", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((843, 6, SkinTone::Default)), shortcodes: Some(&["health_worker"]) },
    Emoji { emoji: "🧑🏻‍⚕️", name: "health worker: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((843, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍⚕️", name: "health worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((843, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍⚕️", name: "health worker: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((843, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍⚕️", name: "health worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((843, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍⚕️", name: "health worker: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((843, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍⚕️", name: "man health worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((849, 6, SkinTone::Default)), shortcodes: Some(&["man_health_worker"]) },
    Emoji { emoji: "👨🏻‍⚕️", name: "man health worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((849, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍⚕️", name: "man health worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((849, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍⚕️", name: "man health worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((849, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍⚕️", name: "man health worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((849, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍⚕️", name: "man health worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((849, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍⚕️", name: "woman health worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((855, 6, SkinTone::Default)), shortcodes: Some(&["woman_health_worker"]) },
    Emoji { emoji: "👩🏻‍⚕️", name: "woman health worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((855, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍⚕️", name: "woman health worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((855, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍⚕️", name: "woman health worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((855, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍⚕️", name: "woman health worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((855, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍⚕️", name: "woman health worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((855, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🎓", name: "student", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((861, 6, SkinTone::Default)), shortcodes: Some(&["student"]) },
    Emoji { emoji: "🧑🏻‍🎓", name: "student: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((861, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🎓", name: "student: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((861, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🎓", name: "student: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((861, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🎓", name: "student: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((861, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🎓", name: "student: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((861, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🎓", name: "man student", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((867, 6, SkinTone::Default)), shortcodes: Some(&["man_student"]) },
    Emoji { emoji: "👨🏻‍🎓", name: "man student: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((867, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🎓", name: "man student: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((867, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🎓", name: "man student: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((867, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🎓", name: "man student: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((867, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🎓", name: "man student: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((867, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🎓", name: "woman student", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((873, 6, SkinTone::Default)), shortcodes: Some(&["woman_student"]) },
    Emoji { emoji: "👩🏻‍🎓", name: "woman student: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((873, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🎓", name: "woman student: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((873, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🎓", name: "woman student: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((873, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🎓", name: "woman student: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((873, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🎓", name: "woman student: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((873, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🏫", name: "teacher", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((879, 6, SkinTone::Default)), shortcodes: Some(&["teacher"]) },
    Emoji { emoji: "🧑🏻‍🏫", name: "teacher: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((879, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🏫", name: "teacher: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((879, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🏫", name: "teacher: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((879, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🏫", name: "teacher: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((879, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🏫", name: "teacher: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((879, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🏫", name: "man teacher", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((885, 6, SkinTone::Default)), shortcodes: Some(&["man_teacher"]) },
    Emoji { emoji: "👨🏻‍🏫", name: "man teacher: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((885, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🏫", name: "man teacher: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((885, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🏫", name: "man teacher: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((885, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🏫", name: "man teacher: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((885, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🏫", name: "man teacher: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((885, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🏫", name: "woman teacher", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((891, 6, SkinTone::Default)), shortcodes: Some(&["woman_teacher"]) },
    Emoji { emoji: "👩🏻‍🏫", name: "woman teacher: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((891, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🏫", name: "woman teacher: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((891, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🏫", name: "woman teacher: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((891, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🏫", name: "woman teacher: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((891, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🏫", name: "woman teacher: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((891, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍⚖️", name: "judge", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((897, 6, SkinTone::Default)), shortcodes: Some(&["judge"]) },
    Emoji { emoji: "🧑🏻‍⚖️", name: "judge: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((897, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍⚖️", name: "judge: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((897, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍⚖️", name: "judge: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((897, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍⚖️", name: "judge: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((897, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍⚖️", name: "judge: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((897, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍⚖️", name: "man judge", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((903, 6, SkinTone::Default)), shortcodes: Some(&["man_judge"]) },
    Emoji { emoji: "👨🏻‍⚖️", name: "man judge: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((903, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍⚖️", name: "man judge: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((903, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍⚖️", name: "man judge: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((903, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍⚖️", name: "man judge: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((903, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍⚖️", name: "man judge: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((903, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍⚖️", name: "woman judge", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((909, 6, SkinTone::Default)), shortcodes: Some(&["woman_judge"]) },
    Emoji { emoji: "👩🏻‍⚖️", name: "woman judge: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((909, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍⚖️", name: "woman judge: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((909, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍⚖️", name: "woman judge: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((909, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍⚖️", name: "woman judge: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((909, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍⚖️", name: "woman judge: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((909, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🌾", name: "farmer", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((915, 6, SkinTone::Default)), shortcodes: Some(&["farmer"]) },
    Emoji { emoji: "🧑🏻‍🌾", name: "farmer: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((915, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🌾", name: "farmer: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((915, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🌾", name: "farmer: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((915, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🌾", name: "farmer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((915, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🌾", name: "farmer: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((915, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🌾", name: "man farmer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((921, 6, SkinTone::Default)), shortcodes: Some(&["man_farmer"]) },
    Emoji { emoji: "👨🏻‍🌾", name: "man farmer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((921, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🌾", name: "man farmer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((921, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🌾", name: "man farmer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((921, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🌾", name: "man farmer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((921, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🌾", name: "man farmer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((921, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🌾", name: "woman farmer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((927, 6, SkinTone::Default)), shortcodes: Some(&["woman_farmer"]) },
    Emoji { emoji: "👩🏻‍🌾", name: "woman farmer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((927, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🌾", name: "woman farmer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((927, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🌾", name: "woman farmer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((927, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🌾", name: "woman farmer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((927, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🌾", name: "woman farmer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((927, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🍳", name: "cook", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((933, 6, SkinTone::Default)), shortcodes: Some(&["cook"]) },
    Emoji { emoji: "🧑🏻‍🍳", name: "cook: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((933, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🍳", name: "cook: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((933, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🍳", name: "cook: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((933, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🍳", name: "cook: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((933, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🍳", name: "cook: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((933, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🍳", name: "man cook", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((939, 6, SkinTone::Default)), shortcodes: Some(&["man_cook"]) },
    Emoji { emoji: "👨🏻‍🍳", name: "man cook: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((939, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🍳", name: "man cook: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((939, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🍳", name: "man cook: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((939, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🍳", name: "man cook: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((939, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🍳", name: "man cook: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((939, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🍳", name: "woman cook", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((945, 6, SkinTone::Default)), shortcodes: Some(&["woman_cook"]) },
    Emoji { emoji: "👩🏻‍🍳", name: "woman cook: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((945, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🍳", name: "woman cook: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((945, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🍳", name: "woman cook: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((945, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🍳", name: "woman cook: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((945, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🍳", name: "woman cook: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((945, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🔧", name: "mechanic", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((951, 6, SkinTone::Default)), shortcodes: Some(&["mechanic"]) },
    Emoji { emoji: "🧑🏻‍🔧", name: "mechanic: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((951, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🔧", name: "mechanic: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((951, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🔧", name: "mechanic: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((951, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🔧", name: "mechanic: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((951, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🔧", name: "mechanic: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((951, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🔧", name: "man mechanic", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((957, 6, SkinTone::Default)), shortcodes: Some(&["man_mechanic"]) },
    Emoji { emoji: "👨🏻‍🔧", name: "man mechanic: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((957, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🔧", name: "man mechanic: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((957, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🔧", name: "man mechanic: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((957, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🔧", name: "man mechanic: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((957, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🔧", name: "man mechanic: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((957, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🔧", name: "woman mechanic", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((963, 6, SkinTone::Default)), shortcodes: Some(&["woman_mechanic"]) },
    Emoji { emoji: "👩🏻‍🔧", name: "woman mechanic: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((963, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🔧", name: "woman mechanic: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((963, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🔧", name: "woman mechanic: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((963, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🔧", name: "woman mechanic: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((963, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🔧", name: "woman mechanic: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((963, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🏭", name: "factory worker", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((969, 6, SkinTone::Default)), shortcodes: Some(&["factory_worker"]) },
    Emoji { emoji: "🧑🏻‍🏭", name: "factory worker: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((969, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🏭", name: "factory worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((969, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🏭", name: "factory worker: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((969, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🏭", name: "factory worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((969, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🏭", name: "factory worker: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((969, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🏭", name: "man factory worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((975, 6, SkinTone::Default)), shortcodes: Some(&["man_factory_worker"]) },
    Emoji { emoji: "👨🏻‍🏭", name: "man factory worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((975, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🏭", name: "man factory worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((975, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🏭", name: "man factory worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((975, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🏭", name: "man factory worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((975, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🏭", name: "man factory worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((975, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🏭", name: "woman factory worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((981, 6, SkinTone::Default)), shortcodes: Some(&["woman_factory_worker"]) },
    Emoji { emoji: "👩🏻‍🏭", name: "woman factory worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((981, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🏭", name: "woman factory worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((981, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🏭", name: "woman factory worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((981, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🏭", name: "woman factory worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((981, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🏭", name: "woman factory worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((981, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍💼", name: "office worker", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((987, 6, SkinTone::Default)), shortcodes: Some(&["office_worker"]) },
    Emoji { emoji: "🧑🏻‍💼", name: "office worker: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((987, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍💼", name: "office worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((987, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍💼", name: "office worker: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((987, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍💼", name: "office worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((987, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍💼", name: "office worker: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((987, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍💼", name: "man office worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((993, 6, SkinTone::Default)), shortcodes: Some(&["man_office_worker"]) },
    Emoji { emoji: "👨🏻‍💼", name: "man office worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((993, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍💼", name: "man office worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((993, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍💼", name: "man office worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((993, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍💼", name: "man office worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((993, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍💼", name: "man office worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((993, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍💼", name: "woman office worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((999, 6, SkinTone::Default)), shortcodes: Some(&["woman_office_worker"]) },
    Emoji { emoji: "👩🏻‍💼", name: "woman office worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((999, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍💼", name: "woman office worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((999, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍💼", name: "woman office worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((999, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍💼", name: "woman office worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((999, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍💼", name: "woman office worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((999, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🔬", name: "scientist", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1005, 6, SkinTone::Default)), shortcodes: Some(&["scientist"]) },
    Emoji { emoji: "🧑🏻‍🔬", name: "scientist: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1005, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🔬", name: "scientist: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1005, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🔬", name: "scientist: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1005, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🔬", name: "scientist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1005, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🔬", name: "scientist: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1005, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🔬", name: "man scientist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1011, 6, SkinTone::Default)), shortcodes: Some(&["man_scientist"]) },
    Emoji { emoji: "👨🏻‍🔬", name: "man scientist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1011, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🔬", name: "man scientist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1011, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🔬", name: "man scientist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1011, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🔬", name: "man scientist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1011, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🔬", name: "man scientist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1011, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🔬", name: "woman scientist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1017, 6, SkinTone::Default)), shortcodes: Some(&["woman_scientist"]) },
    Emoji { emoji: "👩🏻‍🔬", name: "woman scientist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1017, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🔬", name: "woman scientist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1017, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🔬", name: "woman scientist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1017, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🔬", name: "woman scientist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1017, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🔬", name: "woman scientist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1017, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍💻", name: "technologist", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1023, 6, SkinTone::Default)), shortcodes: Some(&["technologist"]) },
    Emoji { emoji: "🧑🏻‍💻", name: "technologist: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1023, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍💻", name: "technologist: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1023, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍💻", name: "technologist: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1023, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍💻", name: "technologist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1023, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍💻", name: "technologist: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1023, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍💻", name: "man technologist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1029, 6, SkinTone::Default)), shortcodes: Some(&["man_technologist"]) },
    Emoji { emoji: "👨🏻‍💻", name: "man technologist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1029, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍💻", name: "man technologist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1029, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍💻", name: "man technologist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1029, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍💻", name: "man technologist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1029, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍💻", name: "man technologist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1029, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍💻", name: "woman technologist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1035, 6, SkinTone::Default)), shortcodes: Some(&["woman_technologist"]) },
    Emoji { emoji: "👩🏻‍💻", name: "woman technologist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1035, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍💻", name: "woman technologist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1035, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍💻", name: "woman technologist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1035, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍💻", name: "woman technologist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1035, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍💻", name: "woman technologist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1035, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🎤", name: "singer", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1041, 6, SkinTone::Default)), shortcodes: Some(&["singer"]) },
    Emoji { emoji: "🧑🏻‍🎤", name: "singer: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1041, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🎤", name: "singer: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1041, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🎤", name: "singer: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1041, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🎤", name: "singer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1041, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🎤", name: "singer: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1041, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🎤", name: "man singer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1047, 6, SkinTone::Default)), shortcodes: Some(&["man_singer"]) },
    Emoji { emoji: "👨🏻‍🎤", name: "man singer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1047, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🎤", name: "man singer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1047, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🎤", name: "man singer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1047, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🎤", name: "man singer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1047, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🎤", name: "man singer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1047, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🎤", name: "woman singer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1053, 6, SkinTone::Default)), shortcodes: Some(&["woman_singer"]) },
    Emoji { emoji: "👩🏻‍🎤", name: "woman singer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1053, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🎤", name: "woman singer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1053, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🎤", name: "woman singer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1053, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🎤", name: "woman singer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1053, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🎤", name: "woman singer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1053, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🎨", name: "artist", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1059, 6, SkinTone::Default)), shortcodes: Some(&["artist"]) },
    Emoji { emoji: "🧑🏻‍🎨", name: "artist: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1059, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🎨", name: "artist: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1059, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🎨", name: "artist: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1059, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🎨", name: "artist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1059, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🎨", name: "artist: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1059, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🎨", name: "man artist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1065, 6, SkinTone::Default)), shortcodes: Some(&["man_artist"]) },
    Emoji { emoji: "👨🏻‍🎨", name: "man artist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1065, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🎨", name: "man artist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1065, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🎨", name: "man artist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1065, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🎨", name: "man artist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1065, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🎨", name: "man artist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1065, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🎨", name: "woman artist", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1071, 6, SkinTone::Default)), shortcodes: Some(&["woman_artist"]) },
    Emoji { emoji: "👩🏻‍🎨", name: "woman artist: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1071, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🎨", name: "woman artist: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1071, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🎨", name: "woman artist: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1071, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🎨", name: "woman artist: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1071, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🎨", name: "woman artist: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1071, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍✈️", name: "pilot", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1077, 6, SkinTone::Default)), shortcodes: Some(&["pilot"]) },
    Emoji { emoji: "🧑🏻‍✈️", name: "pilot: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1077, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍✈️", name: "pilot: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1077, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍✈️", name: "pilot: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1077, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍✈️", name: "pilot: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1077, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍✈️", name: "pilot: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1077, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍✈️", name: "man pilot", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1083, 6, SkinTone::Default)), shortcodes: Some(&["man_pilot"]) },
    Emoji { emoji: "👨🏻‍✈️", name: "man pilot: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1083, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍✈️", name: "man pilot: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1083, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍✈️", name: "man pilot: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1083, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍✈️", name: "man pilot: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1083, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍✈️", name: "man pilot: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1083, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍✈️", name: "woman pilot", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1089, 6, SkinTone::Default)), shortcodes: Some(&["woman_pilot"]) },
    Emoji { emoji: "👩🏻‍✈️", name: "woman pilot: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1089, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍✈️", name: "woman pilot: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1089, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍✈️", name: "woman pilot: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1089, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍✈️", name: "woman pilot: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1089, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍✈️", name: "woman pilot: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1089, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🚀", name: "astronaut", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1095, 6, SkinTone::Default)), shortcodes: Some(&["astronaut"]) },
    Emoji { emoji: "🧑🏻‍🚀", name: "astronaut: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1095, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🚀", name: "astronaut: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1095, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🚀", name: "astronaut: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1095, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🚀", name: "astronaut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1095, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🚀", name: "astronaut: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1095, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🚀", name: "man astronaut", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1101, 6, SkinTone::Default)), shortcodes: Some(&["man_astronaut"]) },
    Emoji { emoji: "👨🏻‍🚀", name: "man astronaut: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1101, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🚀", name: "man astronaut: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1101, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🚀", name: "man astronaut: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1101, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🚀", name: "man astronaut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1101, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🚀", name: "man astronaut: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1101, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🚀", name: "woman astronaut", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1107, 6, SkinTone::Default)), shortcodes: Some(&["woman_astronaut"]) },
    Emoji { emoji: "👩🏻‍🚀", name: "woman astronaut: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1107, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🚀", name: "woman astronaut: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1107, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🚀", name: "woman astronaut: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1107, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🚀", name: "woman astronaut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1107, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🚀", name: "woman astronaut: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1107, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🚒", name: "firefighter", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1113, 6, SkinTone::Default)), shortcodes: Some(&["firefighter"]) },
    Emoji { emoji: "🧑🏻‍🚒", name: "firefighter: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1113, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🚒", name: "firefighter: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1113, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🚒", name: "firefighter: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1113, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🚒", name: "firefighter: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1113, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🚒", name: "firefighter: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1113, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🚒", name: "man firefighter", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1119, 6, SkinTone::Default)), shortcodes: Some(&["man_firefighter"]) },
    Emoji { emoji: "👨🏻‍🚒", name: "man firefighter: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1119, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🚒", name: "man firefighter: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1119, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🚒", name: "man firefighter: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1119, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🚒", name: "man firefighter: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1119, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🚒", name: "man firefighter: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1119, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🚒", name: "woman firefighter", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1125, 6, SkinTone::Default)), shortcodes: Some(&["woman_firefighter"]) },
    Emoji { emoji: "👩🏻‍🚒", name: "woman firefighter: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1125, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🚒", name: "woman firefighter: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1125, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🚒", name: "woman firefighter: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1125, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🚒", name: "woman firefighter: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1125, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🚒", name: "woman firefighter: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1125, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👮", name: "police officer", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1131, 6, SkinTone::Default)), shortcodes: Some(&["police_officer", "cop"]) },
    Emoji { emoji: "👮🏻", name: "police officer: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1131, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👮🏼", name: "police officer: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1131, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👮🏽", name: "police officer: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1131, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👮🏾", name: "police officer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1131, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👮🏿", name: "police officer: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1131, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👮‍♂️", name: "man police officer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1137, 6, SkinTone::Default)), shortcodes: Some(&["policeman"]) },
    Emoji { emoji: "👮🏻‍♂️", name: "man police officer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1137, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👮🏼‍♂️", name: "man police officer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1137, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👮🏽‍♂️", name: "man police officer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1137, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👮🏾‍♂️", name: "man police officer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1137, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👮🏿‍♂️", name: "man police officer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1137, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👮‍♀️", name: "woman police officer", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1143, 6, SkinTone::Default)), shortcodes: Some(&["policewoman"]) },
    Emoji { emoji: "👮🏻‍♀️", name: "woman police officer: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1143, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👮🏼‍♀️", name: "woman police officer: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1143, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👮🏽‍♀️", name: "woman police officer: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1143, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👮🏾‍♀️", name: "woman police officer: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1143, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👮🏿‍♀️", name: "woman police officer: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1143, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🕵️", name: "detective", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((1149, 6, SkinTone::Default)), shortcodes: Some(&["detective"]) },
    Emoji { emoji: "🕵🏻", name: "detective: light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1149, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🕵🏼", name: "detective: medium-light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1149, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🕵🏽", name: "detective: medium skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1149, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🕵🏾", name: "detective: medium-dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1149, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🕵🏿", name: "detective: dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1149, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🕵️‍♂️", name: "man detective", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1155, 6, SkinTone::Default)), shortcodes: Some(&["male_detective"]) },
    Emoji { emoji: "🕵🏻‍♂️", name: "man detective: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1155, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🕵🏼‍♂️", name: "man detective: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1155, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🕵🏽‍♂️", name: "man detective: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1155, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🕵🏾‍♂️", name: "man detective: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1155, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🕵🏿‍♂️", name: "man detective: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1155, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🕵️‍♀️", name: "woman detective", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1161, 6, SkinTone::Default)), shortcodes: Some(&["female_detective"]) },
    Emoji { emoji: "🕵🏻‍♀️", name: "woman detective: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1161, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🕵🏼‍♀️", name: "woman detective: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1161, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🕵🏽‍♀️", name: "woman detective: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1161, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🕵🏾‍♀️", name: "woman detective: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1161, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🕵🏿‍♀️", name: "woman detective: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1161, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💂", name: "guard", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1167, 6, SkinTone::Default)), shortcodes: Some(&["guard"]) },
    Emoji { emoji: "💂🏻", name: "guard: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1167, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💂🏼", name: "guard: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1167, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💂🏽", name: "guard: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1167, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💂🏾", name: "guard: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1167, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💂🏿", name: "guard: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1167, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💂‍♂️", name: "man guard", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1173, 6, SkinTone::Default)), shortcodes: Some(&["guardsman"]) },
    Emoji { emoji: "💂🏻‍♂️", name: "man guard: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1173, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💂🏼‍♂️", name: "man guard: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1173, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💂🏽‍♂️", name: "man guard: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1173, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💂🏾‍♂️", name: "man guard: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1173, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💂🏿‍♂️", name: "man guard: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1173, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💂‍♀️", name: "woman guard", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1179, 6, SkinTone::Default)), shortcodes: Some(&["guardswoman"]) },
    Emoji { emoji: "💂🏻‍♀️", name: "woman guard: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1179, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💂🏼‍♀️", name: "woman guard: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1179, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💂🏽‍♀️", name: "woman guard: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1179, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💂🏾‍♀️", name: "woman guard: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1179, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💂🏿‍♀️", name: "woman guard: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1179, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🥷", name: "ninja", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1185, 6, SkinTone::Default)), shortcodes: Some(&["ninja"]) },
    Emoji { emoji: "🥷🏻", name: "ninja: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1185, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🥷🏼", name: "ninja: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1185, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🥷🏽", name: "ninja: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1185, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🥷🏾", name: "ninja: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1185, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🥷🏿", name: "ninja: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1185, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👷", name: "construction worker", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1191, 6, SkinTone::Default)), shortcodes: Some(&["construction_worker"]) },
    Emoji { emoji: "👷🏻", name: "construction worker: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1191, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👷🏼", name: "construction worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1191, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👷🏽", name: "construction worker: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1191, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👷🏾", name: "construction worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1191, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👷🏿", name: "construction worker: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1191, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👷‍♂️", name: "man construction worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1197, 6, SkinTone::Default)), shortcodes: Some(&["construction_worker_man"]) },
    Emoji { emoji: "👷🏻‍♂️", name: "man construction worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1197, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👷🏼‍♂️", name: "man construction worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1197, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👷🏽‍♂️", name: "man construction worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1197, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👷🏾‍♂️", name: "man construction worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1197, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👷🏿‍♂️", name: "man construction worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1197, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👷‍♀️", name: "woman construction worker", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1203, 6, SkinTone::Default)), shortcodes: Some(&["construction_worker_woman"]) },
    Emoji { emoji: "👷🏻‍♀️", name: "woman construction worker: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1203, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👷🏼‍♀️", name: "woman construction worker: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1203, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👷🏽‍♀️", name: "woman construction worker: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1203, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👷🏾‍♀️", name: "woman construction worker: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1203, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👷🏿‍♀️", name: "woman construction worker: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1203, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫅", name: "person with crown", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1209, 6, SkinTone::Default)), shortcodes: Some(&["person_with_crown"]) },
    Emoji { emoji: "🫅🏻", name: "person with crown: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1209, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫅🏼", name: "person with crown: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1209, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫅🏽", name: "person with crown: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1209, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫅🏾", name: "person with crown: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1209, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫅🏿", name: "person with crown: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1209, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤴", name: "prince", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1215, 6, SkinTone::Default)), shortcodes: Some(&["prince"]) },
    Emoji { emoji: "🤴🏻", name: "prince: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1215, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤴🏼", name: "prince: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1215, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤴🏽", name: "prince: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1215, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤴🏾", name: "prince: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1215, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤴🏿", name: "prince: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1215, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👸", name: "princess", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1221, 6, SkinTone::Default)), shortcodes: Some(&["princess"]) },
    Emoji { emoji: "👸🏻", name: "princess: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1221, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👸🏼", name: "princess: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1221, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👸🏽", name: "princess: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1221, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👸🏾", name: "princess: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1221, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👸🏿", name: "princess: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1221, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👳", name: "person wearing turban", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1227, 6, SkinTone::Default)), shortcodes: Some(&["person_with_turban"]) },
    Emoji { emoji: "👳🏻", name: "person wearing turban: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1227, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👳🏼", name: "person wearing turban: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1227, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👳🏽", name: "person wearing turban: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1227, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👳🏾", name: "person wearing turban: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1227, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👳🏿", name: "person wearing turban: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1227, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👳‍♂️", name: "man wearing turban", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1233, 6, SkinTone::Default)), shortcodes: Some(&["man_with_turban"]) },
    Emoji { emoji: "👳🏻‍♂️", name: "man wearing turban: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1233, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👳🏼‍♂️", name: "man wearing turban: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1233, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👳🏽‍♂️", name: "man wearing turban: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1233, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👳🏾‍♂️", name: "man wearing turban: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1233, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👳🏿‍♂️", name: "man wearing turban: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1233, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👳‍♀️", name: "woman wearing turban", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1239, 6, SkinTone::Default)), shortcodes: Some(&["woman_with_turban"]) },
    Emoji { emoji: "👳🏻‍♀️", name: "woman wearing turban: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1239, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👳🏼‍♀️", name: "woman wearing turban: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1239, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👳🏽‍♀️", name: "woman wearing turban: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1239, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👳🏾‍♀️", name: "woman wearing turban: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1239, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👳🏿‍♀️", name: "woman wearing turban: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1239, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👲", name: "person with skullcap", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1245, 6, SkinTone::Default)), shortcodes: Some(&["man_with_gua_pi_mao"]) },
    Emoji { emoji: "👲🏻", name: "person with skullcap: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1245, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👲🏼", name: "person with skullcap: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1245, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👲🏽", name: "person with skullcap: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1245, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👲🏾", name: "person with skullcap: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1245, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👲🏿", name: "person with skullcap: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1245, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧕", name: "woman with headscarf", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1251, 6, SkinTone::Default)), shortcodes: Some(&["woman_with_headscarf"]) },
    Emoji { emoji: "🧕🏻", name: "woman with headscarf: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1251, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧕🏼", name: "woman with headscarf: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1251, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧕🏽", name: "woman with headscarf: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1251, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧕🏾", name: "woman with headscarf: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1251, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧕🏿", name: "woman with headscarf: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1251, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤵", name: "person in tuxedo", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1257, 6, SkinTone::Default)), shortcodes: Some(&["person_in_tuxedo"]) },
    Emoji { emoji: "🤵🏻", name: "person in tuxedo: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1257, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤵🏼", name: "person in tuxedo: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1257, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤵🏽", name: "person in tuxedo: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1257, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤵🏾", name: "person in tuxedo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1257, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤵🏿", name: "person in tuxedo: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1257, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤵‍♂️", name: "man in tuxedo", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1263, 6, SkinTone::Default)), shortcodes: Some(&["man_in_tuxedo"]) },
    Emoji { emoji: "🤵🏻‍♂️", name: "man in tuxedo: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1263, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤵🏼‍♂️", name: "man in tuxedo: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1263, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤵🏽‍♂️", name: "man in tuxedo: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1263, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤵🏾‍♂️", name: "man in tuxedo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1263, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤵🏿‍♂️", name: "man in tuxedo: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1263, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤵‍♀️", name: "woman in tuxedo", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1269, 6, SkinTone::Default)), shortcodes: Some(&["woman_in_tuxedo"]) },
    Emoji { emoji: "🤵🏻‍♀️", name: "woman in tuxedo: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1269, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤵🏼‍♀️", name: "woman in tuxedo: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1269, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤵🏽‍♀️", name: "woman in tuxedo: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1269, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤵🏾‍♀️", name: "woman in tuxedo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1269, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤵🏿‍♀️", name: "woman in tuxedo: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1269, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👰", name: "person with veil", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1275, 6, SkinTone::Default)), shortcodes: Some(&["person_with_veil"]) },
    Emoji { emoji: "👰🏻", name: "person with veil: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1275, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👰🏼", name: "person with veil: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1275, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👰🏽", name: "person with veil: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1275, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👰🏾", name: "person with veil: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1275, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👰🏿", name: "person with veil: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1275, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👰‍♂️", name: "man with veil", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1281, 6, SkinTone::Default)), shortcodes: Some(&["man_with_veil"]) },
    Emoji { emoji: "👰🏻‍♂️", name: "man with veil: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1281, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👰🏼‍♂️", name: "man with veil: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1281, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👰🏽‍♂️", name: "man with veil: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1281, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👰🏾‍♂️", name: "man with veil: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1281, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👰🏿‍♂️", name: "man with veil: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1281, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👰‍♀️", name: "woman with veil", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1287, 6, SkinTone::Default)), shortcodes: Some(&["woman_with_veil", "bride_with_veil"]) },
    Emoji { emoji: "👰🏻‍♀️", name: "woman with veil: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1287, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👰🏼‍♀️", name: "woman with veil: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1287, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👰🏽‍♀️", name: "woman with veil: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1287, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👰🏾‍♀️", name: "woman with veil: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1287, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👰🏿‍♀️", name: "woman with veil: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1287, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤰", name: "pregnant woman", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1293, 6, SkinTone::Default)), shortcodes: Some(&["pregnant_woman"]) },
    Emoji { emoji: "🤰🏻", name: "pregnant woman: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1293, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤰🏼", name: "pregnant woman: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1293, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤰🏽", name: "pregnant woman: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1293, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤰🏾", name: "pregnant woman: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1293, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤰🏿", name: "pregnant woman: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1293, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫃", name: "pregnant man", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1299, 6, SkinTone::Default)), shortcodes: Some(&["pregnant_man"]) },
    Emoji { emoji: "🫃🏻", name: "pregnant man: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1299, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫃🏼", name: "pregnant man: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1299, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫃🏽", name: "pregnant man: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1299, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫃🏾", name: "pregnant man: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1299, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫃🏿", name: "pregnant man: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1299, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🫄", name: "pregnant person", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1305, 6, SkinTone::Default)), shortcodes: Some(&["pregnant_person"]) },
    Emoji { emoji: "🫄🏻", name: "pregnant person: light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1305, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🫄🏼", name: "pregnant person: medium-light skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1305, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🫄🏽", name: "pregnant person: medium skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1305, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🫄🏾", name: "pregnant person: medium-dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1305, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🫄🏿", name: "pregnant person: dark skin tone", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1305, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤱", name: "breast-feeding", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1311, 6, SkinTone::Default)), shortcodes: Some(&["breast_feeding"]) },
    Emoji { emoji: "🤱🏻", name: "breast-feeding: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1311, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤱🏼", name: "breast-feeding: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1311, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤱🏽", name: "breast-feeding: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1311, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤱🏾", name: "breast-feeding: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1311, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤱🏿", name: "breast-feeding: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1311, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🍼", name: "woman feeding baby", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1317, 6, SkinTone::Default)), shortcodes: Some(&["woman_feeding_baby"]) },
    Emoji { emoji: "👩🏻‍🍼", name: "woman feeding baby: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1317, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🍼", name: "woman feeding baby: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1317, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🍼", name: "woman feeding baby: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1317, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🍼", name: "woman feeding baby: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1317, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🍼", name: "woman feeding baby: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1317, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🍼", name: "man feeding baby", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1323, 6, SkinTone::Default)), shortcodes: Some(&["man_feeding_baby"]) },
    Emoji { emoji: "👨🏻‍🍼", name: "man feeding baby: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1323, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🍼", name: "man feeding baby: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1323, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🍼", name: "man feeding baby: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1323, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🍼", name: "man feeding baby: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1323, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🍼", name: "man feeding baby: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1323, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🍼", name: "person feeding baby", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1329, 6, SkinTone::Default)), shortcodes: Some(&["person_feeding_baby"]) },
    Emoji { emoji: "🧑🏻‍🍼", name: "person feeding baby: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1329, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🍼", name: "person feeding baby: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1329, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🍼", name: "person feeding baby: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1329, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🍼", name: "person feeding baby: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1329, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🍼", name: "person feeding baby: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1329, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👼", name: "baby angel", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1335, 6, SkinTone::Default)), shortcodes: Some(&["angel"]) },
    Emoji { emoji: "👼🏻", name: "baby angel: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1335, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👼🏼", name: "baby angel: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1335, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👼🏽", name: "baby angel: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1335, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👼🏾", name: "baby angel: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1335, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👼🏿", name: "baby angel: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1335, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🎅", name: "Santa Claus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1341, 6, SkinTone::Default)), shortcodes: Some(&["santa"]) },
    Emoji { emoji: "🎅🏻", name: "Santa Claus: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1341, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🎅🏼", name: "Santa Claus: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1341, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🎅🏽", name: "Santa Claus: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1341, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🎅🏾", name: "Santa Claus: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1341, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🎅🏿", name: "Santa Claus: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1341, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤶", name: "Mrs. Claus", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1347, 6, SkinTone::Default)), shortcodes: Some(&["mrs_claus"]) },
    Emoji { emoji: "🤶🏻", name: "Mrs. Claus: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1347, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤶🏼", name: "Mrs. Claus: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1347, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤶🏽", name: "Mrs. Claus: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1347, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤶🏾", name: "Mrs. Claus: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1347, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤶🏿", name: "Mrs. Claus: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1347, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🎄", name: "Mx Claus", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1353, 6, SkinTone::Default)), shortcodes: Some(&["mx_claus"]) },
    Emoji { emoji: "🧑🏻‍🎄", name: "Mx Claus: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1353, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🎄", name: "Mx Claus: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1353, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🎄", name: "Mx Claus: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1353, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🎄", name: "Mx Claus: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1353, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🎄", name: "Mx Claus: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1353, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🦸", name: "superhero", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1359, 6, SkinTone::Default)), shortcodes: Some(&["superhero"]) },
    Emoji { emoji: "🦸🏻", name: "superhero: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1359, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🦸🏼", name: "superhero: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1359, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🦸🏽", name: "superhero: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1359, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🦸🏾", name: "superhero: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1359, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🦸🏿", name: "superhero: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1359, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🦸‍♂️", name: "man superhero", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1365, 6, SkinTone::Default)), shortcodes: Some(&["superhero_man"]) },
    Emoji { emoji: "🦸🏻‍♂️", name: "man superhero: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1365, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🦸🏼‍♂️", name: "man superhero: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1365, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🦸🏽‍♂️", name: "man superhero: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1365, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🦸🏾‍♂️", name: "man superhero: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1365, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🦸🏿‍♂️", name: "man superhero: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1365, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🦸‍♀️", name: "woman superhero", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1371, 6, SkinTone::Default)), shortcodes: Some(&["superhero_woman"]) },
    Emoji { emoji: "🦸🏻‍♀️", name: "woman superhero: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1371, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🦸🏼‍♀️", name: "woman superhero: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1371, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🦸🏽‍♀️", name: "woman superhero: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1371, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🦸🏾‍♀️", name: "woman superhero: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1371, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🦸🏿‍♀️", name: "woman superhero: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1371, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🦹", name: "supervillain", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1377, 6, SkinTone::Default)), shortcodes: Some(&["supervillain"]) },
    Emoji { emoji: "🦹🏻", name: "supervillain: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1377, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🦹🏼", name: "supervillain: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1377, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🦹🏽", name: "supervillain: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1377, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🦹🏾", name: "supervillain: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1377, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🦹🏿", name: "supervillain: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1377, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🦹‍♂️", name: "man supervillain", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1383, 6, SkinTone::Default)), shortcodes: Some(&["supervillain_man"]) },
    Emoji { emoji: "🦹🏻‍♂️", name: "man supervillain: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1383, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🦹🏼‍♂️", name: "man supervillain: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1383, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🦹🏽‍♂️", name: "man supervillain: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1383, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🦹🏾‍♂️", name: "man supervillain: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1383, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🦹🏿‍♂️", name: "man supervillain: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1383, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🦹‍♀️", name: "woman supervillain", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1389, 6, SkinTone::Default)), shortcodes: Some(&["supervillain_woman"]) },
    Emoji { emoji: "🦹🏻‍♀️", name: "woman supervillain: light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1389, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🦹🏼‍♀️", name: "woman supervillain: medium-light skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1389, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🦹🏽‍♀️", name: "woman supervillain: medium skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1389, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🦹🏾‍♀️", name: "woman supervillain: medium-dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1389, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🦹🏿‍♀️", name: "woman supervillain: dark skin tone", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1389, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧙", name: "mage", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1395, 6, SkinTone::Default)), shortcodes: Some(&["mage"]) },
    Emoji { emoji: "🧙🏻", name: "mage: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1395, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧙🏼", name: "mage: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1395, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧙🏽", name: "mage: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1395, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧙🏾", name: "mage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1395, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧙🏿", name: "mage: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1395, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧙‍♂️", name: "man mage", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1401, 6, SkinTone::Default)), shortcodes: Some(&["mage_man"]) },
    Emoji { emoji: "🧙🏻‍♂️", name: "man mage: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1401, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧙🏼‍♂️", name: "man mage: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1401, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧙🏽‍♂️", name: "man mage: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1401, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧙🏾‍♂️", name: "man mage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1401, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧙🏿‍♂️", name: "man mage: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1401, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧙‍♀️", name: "woman mage", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1407, 6, SkinTone::Default)), shortcodes: Some(&["mage_woman"]) },
    Emoji { emoji: "🧙🏻‍♀️", name: "woman mage: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1407, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧙🏼‍♀️", name: "woman mage: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1407, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧙🏽‍♀️", name: "woman mage: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1407, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧙🏾‍♀️", name: "woman mage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1407, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧙🏿‍♀️", name: "woman mage: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1407, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧚", name: "fairy", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1413, 6, SkinTone::Default)), shortcodes: Some(&["fairy"]) },
    Emoji { emoji: "🧚🏻", name: "fairy: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1413, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧚🏼", name: "fairy: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1413, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧚🏽", name: "fairy: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1413, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧚🏾", name: "fairy: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1413, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧚🏿", name: "fairy: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1413, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧚‍♂️", name: "man fairy", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1419, 6, SkinTone::Default)), shortcodes: Some(&["fairy_man"]) },
    Emoji { emoji: "🧚🏻‍♂️", name: "man fairy: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1419, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧚🏼‍♂️", name: "man fairy: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1419, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧚🏽‍♂️", name: "man fairy: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1419, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧚🏾‍♂️", name: "man fairy: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1419, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧚🏿‍♂️", name: "man fairy: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1419, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧚‍♀️", name: "woman fairy", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1425, 6, SkinTone::Default)), shortcodes: Some(&["fairy_woman"]) },
    Emoji { emoji: "🧚🏻‍♀️", name: "woman fairy: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1425, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧚🏼‍♀️", name: "woman fairy: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1425, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧚🏽‍♀️", name: "woman fairy: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1425, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧚🏾‍♀️", name: "woman fairy: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1425, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧚🏿‍♀️", name: "woman fairy: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1425, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧛", name: "vampire", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1431, 6, SkinTone::Default)), shortcodes: Some(&["vampire"]) },
    Emoji { emoji: "🧛🏻", name: "vampire: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1431, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧛🏼", name: "vampire: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1431, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧛🏽", name: "vampire: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1431, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧛🏾", name: "vampire: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1431, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧛🏿", name: "vampire: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1431, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧛‍♂️", name: "man vampire", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1437, 6, SkinTone::Default)), shortcodes: Some(&["vampire_man"]) },
    Emoji { emoji: "🧛🏻‍♂️", name: "man vampire: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1437, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧛🏼‍♂️", name: "man vampire: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1437, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧛🏽‍♂️", name: "man vampire: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1437, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧛🏾‍♂️", name: "man vampire: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1437, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧛🏿‍♂️", name: "man vampire: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1437, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧛‍♀️", name: "woman vampire", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1443, 6, SkinTone::Default)), shortcodes: Some(&["vampire_woman"]) },
    Emoji { emoji: "🧛🏻‍♀️", name: "woman vampire: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1443, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧛🏼‍♀️", name: "woman vampire: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1443, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧛🏽‍♀️", name: "woman vampire: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1443, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧛🏾‍♀️", name: "woman vampire: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1443, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧛🏿‍♀️", name: "woman vampire: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1443, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧜", name: "merperson", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1449, 6, SkinTone::Default)), shortcodes: Some(&["merperson"]) },
    Emoji { emoji: "🧜🏻", name: "merperson: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1449, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧜🏼", name: "merperson: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1449, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧜🏽", name: "merperson: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1449, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧜🏾", name: "merperson: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1449, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧜🏿", name: "merperson: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1449, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧜‍♂️", name: "merman", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1455, 6, SkinTone::Default)), shortcodes: Some(&["merman"]) },
    Emoji { emoji: "🧜🏻‍♂️", name: "merman: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1455, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧜🏼‍♂️", name: "merman: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1455, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧜🏽‍♂️", name: "merman: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1455, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧜🏾‍♂️", name: "merman: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1455, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧜🏿‍♂️", name: "merman: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1455, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧜‍♀️", name: "mermaid", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1461, 6, SkinTone::Default)), shortcodes: Some(&["mermaid"]) },
    Emoji { emoji: "🧜🏻‍♀️", name: "mermaid: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1461, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧜🏼‍♀️", name: "mermaid: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1461, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧜🏽‍♀️", name: "mermaid: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1461, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧜🏾‍♀️", name: "mermaid: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1461, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧜🏿‍♀️", name: "mermaid: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1461, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧝", name: "elf", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1467, 6, SkinTone::Default)), shortcodes: Some(&["elf"]) },
    Emoji { emoji: "🧝🏻", name: "elf: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1467, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧝🏼", name: "elf: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1467, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧝🏽", name: "elf: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1467, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧝🏾", name: "elf: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1467, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧝🏿", name: "elf: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1467, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧝‍♂️", name: "man elf", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1473, 6, SkinTone::Default)), shortcodes: Some(&["elf_man"]) },
    Emoji { emoji: "🧝🏻‍♂️", name: "man elf: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1473, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧝🏼‍♂️", name: "man elf: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1473, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧝🏽‍♂️", name: "man elf: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1473, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧝🏾‍♂️", name: "man elf: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1473, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧝🏿‍♂️", name: "man elf: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1473, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧝‍♀️", name: "woman elf", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1479, 6, SkinTone::Default)), shortcodes: Some(&["elf_woman"]) },
    Emoji { emoji: "🧝🏻‍♀️", name: "woman elf: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1479, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧝🏼‍♀️", name: "woman elf: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1479, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧝🏽‍♀️", name: "woman elf: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1479, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧝🏾‍♀️", name: "woman elf: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1479, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧝🏿‍♀️", name: "woman elf: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1479, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧞", name: "genie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["genie"]) },
    Emoji { emoji: "🧞‍♂️", name: "man genie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["genie_man"]) },
    Emoji { emoji: "🧞‍♀️", name: "woman genie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["genie_woman"]) },
    Emoji { emoji: "🧟", name: "zombie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["zombie"]) },
    Emoji { emoji: "🧟‍♂️", name: "man zombie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["zombie_man"]) },
    Emoji { emoji: "🧟‍♀️", name: "woman zombie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["zombie_woman"]) },
    Emoji { emoji: "🧌", name: "troll", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["troll"]) },
    Emoji { emoji: "💆", name: "person getting massage", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1492, 6, SkinTone::Default)), shortcodes: Some(&["massage"]) },
    Emoji { emoji: "💆🏻", name: "person getting massage: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1492, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💆🏼", name: "person getting massage: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1492, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💆🏽", name: "person getting massage: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1492, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💆🏾", name: "person getting massage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1492, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💆🏿", name: "person getting massage: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1492, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💆‍♂️", name: "man getting massage", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1498, 6, SkinTone::Default)), shortcodes: Some(&["massage_man"]) },
    Emoji { emoji: "💆🏻‍♂️", name: "man getting massage: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1498, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💆🏼‍♂️", name: "man getting massage: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1498, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💆🏽‍♂️", name: "man getting massage: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1498, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💆🏾‍♂️", name: "man getting massage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1498, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💆🏿‍♂️", name: "man getting massage: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1498, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💆‍♀️", name: "woman getting massage", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1504, 6, SkinTone::Default)), shortcodes: Some(&["massage_woman"]) },
    Emoji { emoji: "💆🏻‍♀️", name: "woman getting massage: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1504, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💆🏼‍♀️", name: "woman getting massage: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1504, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💆🏽‍♀️", name: "woman getting massage: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1504, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💆🏾‍♀️", name: "woman getting massage: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1504, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💆🏿‍♀️", name: "woman getting massage: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1504, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💇", name: "person getting haircut", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1510, 6, SkinTone::Default)), shortcodes: Some(&["haircut"]) },
    Emoji { emoji: "💇🏻", name: "person getting haircut: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1510, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💇🏼", name: "person getting haircut: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1510, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💇🏽", name: "person getting haircut: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1510, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💇🏾", name: "person getting haircut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1510, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💇🏿", name: "person getting haircut: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1510, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💇‍♂️", name: "man getting haircut", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1516, 6, SkinTone::Default)), shortcodes: Some(&["haircut_man"]) },
    Emoji { emoji: "💇🏻‍♂️", name: "man getting haircut: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1516, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💇🏼‍♂️", name: "man getting haircut: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1516, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💇🏽‍♂️", name: "man getting haircut: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1516, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💇🏾‍♂️", name: "man getting haircut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1516, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💇🏿‍♂️", name: "man getting haircut: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1516, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💇‍♀️", name: "woman getting haircut", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1522, 6, SkinTone::Default)), shortcodes: Some(&["haircut_woman"]) },
    Emoji { emoji: "💇🏻‍♀️", name: "woman getting haircut: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1522, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💇🏼‍♀️", name: "woman getting haircut: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1522, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💇🏽‍♀️", name: "woman getting haircut: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1522, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💇🏾‍♀️", name: "woman getting haircut: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1522, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💇🏿‍♀️", name: "woman getting haircut: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1522, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚶", name: "person walking", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1528, 6, SkinTone::Default)), shortcodes: Some(&["walking"]) },
    Emoji { emoji: "🚶🏻", name: "person walking: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1528, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚶🏼", name: "person walking: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1528, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚶🏽", name: "person walking: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1528, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚶🏾", name: "person walking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1528, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚶🏿", name: "person walking: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1528, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚶‍♂️", name: "man walking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1534, 6, SkinTone::Default)), shortcodes: Some(&["walking_man"]) },
    Emoji { emoji: "🚶🏻‍♂️", name: "man walking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1534, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚶🏼‍♂️", name: "man walking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1534, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚶🏽‍♂️", name: "man walking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1534, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚶🏾‍♂️", name: "man walking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1534, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚶🏿‍♂️", name: "man walking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1534, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚶‍♀️", name: "woman walking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1540, 6, SkinTone::Default)), shortcodes: Some(&["walking_woman"]) },
    Emoji { emoji: "🚶🏻‍♀️", name: "woman walking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1540, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚶🏼‍♀️", name: "woman walking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1540, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚶🏽‍♀️", name: "woman walking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1540, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚶🏾‍♀️", name: "woman walking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1540, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚶🏿‍♀️", name: "woman walking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1540, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚶‍➡️", name: "person walking facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1546, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🚶🏻‍➡️", name: "person walking facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1546, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚶🏼‍➡️", name: "person walking facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1546, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚶🏽‍➡️", name: "person walking facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1546, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚶🏾‍➡️", name: "person walking facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1546, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚶🏿‍➡️", name: "person walking facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1546, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚶‍♀️‍➡️", name: "woman walking facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1552, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🚶🏻‍♀️‍➡️", name: "woman walking facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1552, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚶🏼‍♀️‍➡️", name: "woman walking facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1552, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚶🏽‍♀️‍➡️", name: "woman walking facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1552, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚶🏾‍♀️‍➡️", name: "woman walking facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1552, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚶🏿‍♀️‍➡️", name: "woman walking facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1552, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚶‍♂️‍➡️", name: "man walking facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1558, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🚶🏻‍♂️‍➡️", name: "man walking facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1558, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚶🏼‍♂️‍➡️", name: "man walking facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1558, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚶🏽‍♂️‍➡️", name: "man walking facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1558, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚶🏾‍♂️‍➡️", name: "man walking facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1558, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚶🏿‍♂️‍➡️", name: "man walking facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1558, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧍", name: "person standing", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1564, 6, SkinTone::Default)), shortcodes: Some(&["standing_person"]) },
    Emoji { emoji: "🧍🏻", name: "person standing: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1564, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧍🏼", name: "person standing: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1564, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧍🏽", name: "person standing: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1564, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧍🏾", name: "person standing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1564, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧍🏿", name: "person standing: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1564, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧍‍♂️", name: "man standing", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1570, 6, SkinTone::Default)), shortcodes: Some(&["standing_man"]) },
    Emoji { emoji: "🧍🏻‍♂️", name: "man standing: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1570, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧍🏼‍♂️", name: "man standing: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1570, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧍🏽‍♂️", name: "man standing: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1570, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧍🏾‍♂️", name: "man standing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1570, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧍🏿‍♂️", name: "man standing: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1570, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧍‍♀️", name: "woman standing", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1576, 6, SkinTone::Default)), shortcodes: Some(&["standing_woman"]) },
    Emoji { emoji: "🧍🏻‍♀️", name: "woman standing: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1576, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧍🏼‍♀️", name: "woman standing: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1576, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧍🏽‍♀️", name: "woman standing: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1576, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧍🏾‍♀️", name: "woman standing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1576, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧍🏿‍♀️", name: "woman standing: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1576, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧎", name: "person kneeling", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1582, 6, SkinTone::Default)), shortcodes: Some(&["kneeling_person"]) },
    Emoji { emoji: "🧎🏻", name: "person kneeling: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1582, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧎🏼", name: "person kneeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1582, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧎🏽", name: "person kneeling: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1582, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧎🏾", name: "person kneeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1582, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧎🏿", name: "person kneeling: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1582, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧎‍♂️", name: "man kneeling", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1588, 6, SkinTone::Default)), shortcodes: Some(&["kneeling_man"]) },
    Emoji { emoji: "🧎🏻‍♂️", name: "man kneeling: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1588, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧎🏼‍♂️", name: "man kneeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1588, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧎🏽‍♂️", name: "man kneeling: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1588, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧎🏾‍♂️", name: "man kneeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1588, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧎🏿‍♂️", name: "man kneeling: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1588, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧎‍♀️", name: "woman kneeling", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1594, 6, SkinTone::Default)), shortcodes: Some(&["kneeling_woman"]) },
    Emoji { emoji: "🧎🏻‍♀️", name: "woman kneeling: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1594, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧎🏼‍♀️", name: "woman kneeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1594, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧎🏽‍♀️", name: "woman kneeling: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1594, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧎🏾‍♀️", name: "woman kneeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1594, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧎🏿‍♀️", name: "woman kneeling: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1594, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧎‍➡️", name: "person kneeling facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1600, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🧎🏻‍➡️", name: "person kneeling facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1600, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧎🏼‍➡️", name: "person kneeling facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1600, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧎🏽‍➡️", name: "person kneeling facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1600, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧎🏾‍➡️", name: "person kneeling facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1600, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧎🏿‍➡️", name: "person kneeling facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1600, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧎‍♀️‍➡️", name: "woman kneeling facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1606, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🧎🏻‍♀️‍➡️", name: "woman kneeling facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1606, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧎🏼‍♀️‍➡️", name: "woman kneeling facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1606, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧎🏽‍♀️‍➡️", name: "woman kneeling facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1606, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧎🏾‍♀️‍➡️", name: "woman kneeling facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1606, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧎🏿‍♀️‍➡️", name: "woman kneeling facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1606, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧎‍♂️‍➡️", name: "man kneeling facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1612, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🧎🏻‍♂️‍➡️", name: "man kneeling facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1612, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧎🏼‍♂️‍➡️", name: "man kneeling facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1612, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧎🏽‍♂️‍➡️", name: "man kneeling facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1612, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧎🏾‍♂️‍➡️", name: "man kneeling facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1612, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧎🏿‍♂️‍➡️", name: "man kneeling facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1612, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🦯", name: "person with white cane", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1618, 6, SkinTone::Default)), shortcodes: Some(&["person_with_probing_cane"]) },
    Emoji { emoji: "🧑🏻‍🦯", name: "person with white cane: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1618, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🦯", name: "person with white cane: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1618, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🦯", name: "person with white cane: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1618, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🦯", name: "person with white cane: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1618, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🦯", name: "person with white cane: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1618, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🦯‍➡️", name: "person with white cane facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1624, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍🦯‍➡️", name: "person with white cane facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1624, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🦯‍➡️", name: "person with white cane facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1624, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🦯‍➡️", name: "person with white cane facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1624, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🦯‍➡️", name: "person with white cane facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1624, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🦯‍➡️", name: "person with white cane facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1624, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🦯", name: "man with white cane", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1630, 6, SkinTone::Default)), shortcodes: Some(&["man_with_probing_cane"]) },
    Emoji { emoji: "👨🏻‍🦯", name: "man with white cane: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1630, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🦯", name: "man with white cane: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1630, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🦯", name: "man with white cane: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1630, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🦯", name: "man with white cane: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1630, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🦯", name: "man with white cane: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1630, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🦯‍➡️", name: "man with white cane facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1636, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "👨🏻‍🦯‍➡️", name: "man with white cane facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1636, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🦯‍➡️", name: "man with white cane facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1636, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🦯‍➡️", name: "man with white cane facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1636, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🦯‍➡️", name: "man with white cane facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1636, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🦯‍➡️", name: "man with white cane facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1636, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🦯", name: "woman with white cane", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1642, 6, SkinTone::Default)), shortcodes: Some(&["woman_with_probing_cane"]) },
    Emoji { emoji: "👩🏻‍🦯", name: "woman with white cane: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1642, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🦯", name: "woman with white cane: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1642, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🦯", name: "woman with white cane: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1642, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🦯", name: "woman with white cane: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1642, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🦯", name: "woman with white cane: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1642, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🦯‍➡️", name: "woman with white cane facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1648, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "👩🏻‍🦯‍➡️", name: "woman with white cane facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1648, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🦯‍➡️", name: "woman with white cane facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1648, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🦯‍➡️", name: "woman with white cane facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1648, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🦯‍➡️", name: "woman with white cane facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1648, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🦯‍➡️", name: "woman with white cane facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1648, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🦼", name: "person in motorized wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1654, 6, SkinTone::Default)), shortcodes: Some(&["person_in_motorized_wheelchair"]) },
    Emoji { emoji: "🧑🏻‍🦼", name: "person in motorized wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1654, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🦼", name: "person in motorized wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1654, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🦼", name: "person in motorized wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1654, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🦼", name: "person in motorized wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1654, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🦼", name: "person in motorized wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1654, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🦼‍➡️", name: "person in motorized wheelchair facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1660, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍🦼‍➡️", name: "person in motorized wheelchair facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1660, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🦼‍➡️", name: "person in motorized wheelchair facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1660, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🦼‍➡️", name: "person in motorized wheelchair facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1660, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🦼‍➡️", name: "person in motorized wheelchair facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1660, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🦼‍➡️", name: "person in motorized wheelchair facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1660, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🦼", name: "man in motorized wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1666, 6, SkinTone::Default)), shortcodes: Some(&["man_in_motorized_wheelchair"]) },
    Emoji { emoji: "👨🏻‍🦼", name: "man in motorized wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1666, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🦼", name: "man in motorized wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1666, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🦼", name: "man in motorized wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1666, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🦼", name: "man in motorized wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1666, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🦼", name: "man in motorized wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1666, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🦼‍➡️", name: "man in motorized wheelchair facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1672, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "👨🏻‍🦼‍➡️", name: "man in motorized wheelchair facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1672, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🦼‍➡️", name: "man in motorized wheelchair facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1672, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🦼‍➡️", name: "man in motorized wheelchair facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1672, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🦼‍➡️", name: "man in motorized wheelchair facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1672, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🦼‍➡️", name: "man in motorized wheelchair facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1672, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🦼", name: "woman in motorized wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1678, 6, SkinTone::Default)), shortcodes: Some(&["woman_in_motorized_wheelchair"]) },
    Emoji { emoji: "👩🏻‍🦼", name: "woman in motorized wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1678, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🦼", name: "woman in motorized wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1678, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🦼", name: "woman in motorized wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1678, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🦼", name: "woman in motorized wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1678, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🦼", name: "woman in motorized wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1678, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🦼‍➡️", name: "woman in motorized wheelchair facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1684, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "👩🏻‍🦼‍➡️", name: "woman in motorized wheelchair facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1684, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🦼‍➡️", name: "woman in motorized wheelchair facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1684, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🦼‍➡️", name: "woman in motorized wheelchair facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1684, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🦼‍➡️", name: "woman in motorized wheelchair facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1684, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🦼‍➡️", name: "woman in motorized wheelchair facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1684, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🦽", name: "person in manual wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1690, 6, SkinTone::Default)), shortcodes: Some(&["person_in_manual_wheelchair"]) },
    Emoji { emoji: "🧑🏻‍🦽", name: "person in manual wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1690, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🦽", name: "person in manual wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1690, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🦽", name: "person in manual wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1690, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🦽", name: "person in manual wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1690, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🦽", name: "person in manual wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1690, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🦽‍➡️", name: "person in manual wheelchair facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1696, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍🦽‍➡️", name: "person in manual wheelchair facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1696, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🦽‍➡️", name: "person in manual wheelchair facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1696, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🦽‍➡️", name: "person in manual wheelchair facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1696, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🦽‍➡️", name: "person in manual wheelchair facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1696, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🦽‍➡️", name: "person in manual wheelchair facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1696, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🦽", name: "man in manual wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1702, 6, SkinTone::Default)), shortcodes: Some(&["man_in_manual_wheelchair"]) },
    Emoji { emoji: "👨🏻‍🦽", name: "man in manual wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1702, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🦽", name: "man in manual wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1702, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🦽", name: "man in manual wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1702, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🦽", name: "man in manual wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1702, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🦽", name: "man in manual wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1702, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨‍🦽‍➡️", name: "man in manual wheelchair facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1708, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "👨🏻‍🦽‍➡️", name: "man in manual wheelchair facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1708, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🦽‍➡️", name: "man in manual wheelchair facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1708, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🦽‍➡️", name: "man in manual wheelchair facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1708, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🦽‍➡️", name: "man in manual wheelchair facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1708, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🦽‍➡️", name: "man in manual wheelchair facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1708, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🦽", name: "woman in manual wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1714, 6, SkinTone::Default)), shortcodes: Some(&["woman_in_manual_wheelchair"]) },
    Emoji { emoji: "👩🏻‍🦽", name: "woman in manual wheelchair: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1714, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🦽", name: "woman in manual wheelchair: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1714, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🦽", name: "woman in manual wheelchair: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1714, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🦽", name: "woman in manual wheelchair: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1714, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🦽", name: "woman in manual wheelchair: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1714, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩‍🦽‍➡️", name: "woman in manual wheelchair facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1720, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "👩🏻‍🦽‍➡️", name: "woman in manual wheelchair facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1720, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🦽‍➡️", name: "woman in manual wheelchair facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1720, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🦽‍➡️", name: "woman in manual wheelchair facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1720, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🦽‍➡️", name: "woman in manual wheelchair facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1720, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🦽‍➡️", name: "woman in manual wheelchair facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1720, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏃", name: "person running", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1726, 6, SkinTone::Default)), shortcodes: Some(&["runner", "running"]) },
    Emoji { emoji: "🏃🏻", name: "person running: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1726, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏃🏼", name: "person running: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1726, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏃🏽", name: "person running: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1726, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏃🏾", name: "person running: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1726, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏃🏿", name: "person running: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1726, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏃‍♂️", name: "man running", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1732, 6, SkinTone::Default)), shortcodes: Some(&["running_man"]) },
    Emoji { emoji: "🏃🏻‍♂️", name: "man running: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1732, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏃🏼‍♂️", name: "man running: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1732, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏃🏽‍♂️", name: "man running: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1732, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏃🏾‍♂️", name: "man running: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1732, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏃🏿‍♂️", name: "man running: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1732, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏃‍♀️", name: "woman running", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1738, 6, SkinTone::Default)), shortcodes: Some(&["running_woman"]) },
    Emoji { emoji: "🏃🏻‍♀️", name: "woman running: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1738, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏃🏼‍♀️", name: "woman running: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1738, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏃🏽‍♀️", name: "woman running: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1738, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏃🏾‍♀️", name: "woman running: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1738, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏃🏿‍♀️", name: "woman running: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1738, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏃‍➡️", name: "person running facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1744, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🏃🏻‍➡️", name: "person running facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1744, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏃🏼‍➡️", name: "person running facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1744, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏃🏽‍➡️", name: "person running facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1744, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏃🏾‍➡️", name: "person running facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1744, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏃🏿‍➡️", name: "person running facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1744, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏃‍♀️‍➡️", name: "woman running facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1750, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🏃🏻‍♀️‍➡️", name: "woman running facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1750, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏃🏼‍♀️‍➡️", name: "woman running facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1750, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏃🏽‍♀️‍➡️", name: "woman running facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1750, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏃🏾‍♀️‍➡️", name: "woman running facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1750, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏃🏿‍♀️‍➡️", name: "woman running facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1750, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏃‍♂️‍➡️", name: "man running facing right", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1756, 6, SkinTone::Default)), shortcodes: None },
    Emoji { emoji: "🏃🏻‍♂️‍➡️", name: "man running facing right: light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1756, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏃🏼‍♂️‍➡️", name: "man running facing right: medium-light skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1756, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏃🏽‍♂️‍➡️", name: "man running facing right: medium skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1756, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏃🏾‍♂️‍➡️", name: "man running facing right: medium-dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1756, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏃🏿‍♂️‍➡️", name: "man running facing right: dark skin tone", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((1756, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "💃", name: "woman dancing", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1762, 6, SkinTone::Default)), shortcodes: Some(&["woman_dancing", "dancer"]) },
    Emoji { emoji: "💃🏻", name: "woman dancing: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1762, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💃🏼", name: "woman dancing: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1762, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💃🏽", name: "woman dancing: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1762, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💃🏾", name: "woman dancing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1762, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💃🏿", name: "woman dancing: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1762, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🕺", name: "man dancing", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1768, 6, SkinTone::Default)), shortcodes: Some(&["man_dancing"]) },
    Emoji { emoji: "🕺🏻", name: "man dancing: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1768, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🕺🏼", name: "man dancing: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1768, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🕺🏽", name: "man dancing: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1768, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🕺🏾", name: "man dancing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1768, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🕺🏿", name: "man dancing: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1768, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🕴️", name: "person in suit levitating", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((1774, 6, SkinTone::Default)), shortcodes: Some(&["business_suit_levitating"]) },
    Emoji { emoji: "🕴🏻", name: "person in suit levitating: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1774, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🕴🏼", name: "person in suit levitating: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1774, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🕴🏽", name: "person in suit levitating: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1774, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🕴🏾", name: "person in suit levitating: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1774, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🕴🏿", name: "person in suit levitating: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1774, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👯", name: "people with bunny ears", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["dancers"]) },
    Emoji { emoji: "👯‍♂️", name: "men with bunny ears", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["dancing_men"]) },
    Emoji { emoji: "👯‍♀️", name: "women with bunny ears", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["dancing_women"]) },
    Emoji { emoji: "🧖", name: "person in steamy room", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, 6, SkinTone::Default)), shortcodes: Some(&["sauna_person"]) },
    Emoji { emoji: "🧖🏻", name: "person in steamy room: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧖🏼", name: "person in steamy room: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧖🏽", name: "person in steamy room: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧖🏾", name: "person in steamy room: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧖🏿", name: "person in steamy room: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1783, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧖‍♂️", name: "man in steamy room", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, 6, SkinTone::Default)), shortcodes: Some(&["sauna_man"]) },
    Emoji { emoji: "🧖🏻‍♂️", name: "man in steamy room: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧖🏼‍♂️", name: "man in steamy room: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧖🏽‍♂️", name: "man in steamy room: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧖🏾‍♂️", name: "man in steamy room: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧖🏿‍♂️", name: "man in steamy room: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1789, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧖‍♀️", name: "woman in steamy room", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, 6, SkinTone::Default)), shortcodes: Some(&["sauna_woman"]) },
    Emoji { emoji: "🧖🏻‍♀️", name: "woman in steamy room: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧖🏼‍♀️", name: "woman in steamy room: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧖🏽‍♀️", name: "woman in steamy room: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧖🏾‍♀️", name: "woman in steamy room: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧖🏿‍♀️", name: "woman in steamy room: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1795, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧗", name: "person climbing", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, 6, SkinTone::Default)), shortcodes: Some(&["climbing"]) },
    Emoji { emoji: "🧗🏻", name: "person climbing: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧗🏼", name: "person climbing: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧗🏽", name: "person climbing: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧗🏾", name: "person climbing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧗🏿", name: "person climbing: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1801, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧗‍♂️", name: "man climbing", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, 6, SkinTone::Default)), shortcodes: Some(&["climbing_man"]) },
    Emoji { emoji: "🧗🏻‍♂️", name: "man climbing: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧗🏼‍♂️", name: "man climbing: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧗🏽‍♂️", name: "man climbing: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧗🏾‍♂️", name: "man climbing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧗🏿‍♂️", name: "man climbing: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1807, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧗‍♀️", name: "woman climbing", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, 6, SkinTone::Default)), shortcodes: Some(&["climbing_woman"]) },
    Emoji { emoji: "🧗🏻‍♀️", name: "woman climbing: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧗🏼‍♀️", name: "woman climbing: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧗🏽‍♀️", name: "woman climbing: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧗🏾‍♀️", name: "woman climbing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧗🏿‍♀️", name: "woman climbing: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1813, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤺", name: "person fencing", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["person_fencing"]) },
    Emoji { emoji: "🏇", name: "horse racing", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1820, 6, SkinTone::Default)), shortcodes: Some(&["horse_racing"]) },
    Emoji { emoji: "🏇🏻", name: "horse racing: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1820, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏇🏼", name: "horse racing: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1820, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏇🏽", name: "horse racing: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1820, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏇🏾", name: "horse racing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1820, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏇🏿", name: "horse racing: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1820, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "⛷️", name: "skier", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["skier"]) },
    Emoji { emoji: "🏂", name: "snowboarder", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1827, 6, SkinTone::Default)), shortcodes: Some(&["snowboarder"]) },
    Emoji { emoji: "🏂🏻", name: "snowboarder: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1827, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏂🏼", name: "snowboarder: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1827, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏂🏽", name: "snowboarder: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1827, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏂🏾", name: "snowboarder: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1827, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏂🏿", name: "snowboarder: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1827, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏌️", name: "person golfing", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((1833, 6, SkinTone::Default)), shortcodes: Some(&["golfing"]) },
    Emoji { emoji: "🏌🏻", name: "person golfing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1833, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏌🏼", name: "person golfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1833, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏌🏽", name: "person golfing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1833, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏌🏾", name: "person golfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1833, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏌🏿", name: "person golfing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1833, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏌️‍♂️", name: "man golfing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1839, 6, SkinTone::Default)), shortcodes: Some(&["golfing_man"]) },
    Emoji { emoji: "🏌🏻‍♂️", name: "man golfing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1839, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏌🏼‍♂️", name: "man golfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1839, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏌🏽‍♂️", name: "man golfing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1839, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏌🏾‍♂️", name: "man golfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1839, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏌🏿‍♂️", name: "man golfing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1839, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏌️‍♀️", name: "woman golfing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1845, 6, SkinTone::Default)), shortcodes: Some(&["golfing_woman"]) },
    Emoji { emoji: "🏌🏻‍♀️", name: "woman golfing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1845, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏌🏼‍♀️", name: "woman golfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1845, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏌🏽‍♀️", name: "woman golfing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1845, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏌🏾‍♀️", name: "woman golfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1845, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏌🏿‍♀️", name: "woman golfing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1845, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏄", name: "person surfing", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1851, 6, SkinTone::Default)), shortcodes: Some(&["surfer"]) },
    Emoji { emoji: "🏄🏻", name: "person surfing: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1851, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏄🏼", name: "person surfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1851, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏄🏽", name: "person surfing: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1851, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏄🏾", name: "person surfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1851, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏄🏿", name: "person surfing: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1851, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏄‍♂️", name: "man surfing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1857, 6, SkinTone::Default)), shortcodes: Some(&["surfing_man"]) },
    Emoji { emoji: "🏄🏻‍♂️", name: "man surfing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1857, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏄🏼‍♂️", name: "man surfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1857, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏄🏽‍♂️", name: "man surfing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1857, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏄🏾‍♂️", name: "man surfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1857, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏄🏿‍♂️", name: "man surfing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1857, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏄‍♀️", name: "woman surfing", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1863, 6, SkinTone::Default)), shortcodes: Some(&["surfing_woman"]) },
    Emoji { emoji: "🏄🏻‍♀️", name: "woman surfing: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1863, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏄🏼‍♀️", name: "woman surfing: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1863, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏄🏽‍♀️", name: "woman surfing: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1863, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏄🏾‍♀️", name: "woman surfing: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1863, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏄🏿‍♀️", name: "woman surfing: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1863, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚣", name: "person rowing boat", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1869, 6, SkinTone::Default)), shortcodes: Some(&["rowboat"]) },
    Emoji { emoji: "🚣🏻", name: "person rowing boat: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1869, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚣🏼", name: "person rowing boat: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1869, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚣🏽", name: "person rowing boat: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1869, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚣🏾", name: "person rowing boat: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1869, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚣🏿", name: "person rowing boat: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1869, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚣‍♂️", name: "man rowing boat", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1875, 6, SkinTone::Default)), shortcodes: Some(&["rowing_man"]) },
    Emoji { emoji: "🚣🏻‍♂️", name: "man rowing boat: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1875, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚣🏼‍♂️", name: "man rowing boat: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1875, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚣🏽‍♂️", name: "man rowing boat: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1875, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚣🏾‍♂️", name: "man rowing boat: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1875, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚣🏿‍♂️", name: "man rowing boat: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1875, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚣‍♀️", name: "woman rowing boat", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1881, 6, SkinTone::Default)), shortcodes: Some(&["rowing_woman"]) },
    Emoji { emoji: "🚣🏻‍♀️", name: "woman rowing boat: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1881, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚣🏼‍♀️", name: "woman rowing boat: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1881, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚣🏽‍♀️", name: "woman rowing boat: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1881, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚣🏾‍♀️", name: "woman rowing boat: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1881, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚣🏿‍♀️", name: "woman rowing boat: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1881, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏊", name: "person swimming", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((1887, 6, SkinTone::Default)), shortcodes: Some(&["swimmer"]) },
    Emoji { emoji: "🏊🏻", name: "person swimming: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1887, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏊🏼", name: "person swimming: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1887, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏊🏽", name: "person swimming: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1887, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏊🏾", name: "person swimming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1887, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏊🏿", name: "person swimming: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1887, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏊‍♂️", name: "man swimming", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1893, 6, SkinTone::Default)), shortcodes: Some(&["swimming_man"]) },
    Emoji { emoji: "🏊🏻‍♂️", name: "man swimming: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1893, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏊🏼‍♂️", name: "man swimming: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1893, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏊🏽‍♂️", name: "man swimming: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1893, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏊🏾‍♂️", name: "man swimming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1893, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏊🏿‍♂️", name: "man swimming: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1893, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏊‍♀️", name: "woman swimming", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1899, 6, SkinTone::Default)), shortcodes: Some(&["swimming_woman"]) },
    Emoji { emoji: "🏊🏻‍♀️", name: "woman swimming: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1899, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏊🏼‍♀️", name: "woman swimming: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1899, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏊🏽‍♀️", name: "woman swimming: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1899, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏊🏾‍♀️", name: "woman swimming: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1899, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏊🏿‍♀️", name: "woman swimming: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1899, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "⛹️", name: "person bouncing ball", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((1905, 6, SkinTone::Default)), shortcodes: Some(&["bouncing_ball_person"]) },
    Emoji { emoji: "⛹🏻", name: "person bouncing ball: light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1905, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "⛹🏼", name: "person bouncing ball: medium-light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1905, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "⛹🏽", name: "person bouncing ball: medium skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1905, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "⛹🏾", name: "person bouncing ball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1905, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "⛹🏿", name: "person bouncing ball: dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1905, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "⛹️‍♂️", name: "man bouncing ball", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1911, 6, SkinTone::Default)), shortcodes: Some(&["bouncing_ball_man", "basketball_man"]) },
    Emoji { emoji: "⛹🏻‍♂️", name: "man bouncing ball: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1911, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "⛹🏼‍♂️", name: "man bouncing ball: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1911, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "⛹🏽‍♂️", name: "man bouncing ball: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1911, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "⛹🏾‍♂️", name: "man bouncing ball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1911, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "⛹🏿‍♂️", name: "man bouncing ball: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1911, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "⛹️‍♀️", name: "woman bouncing ball", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1917, 6, SkinTone::Default)), shortcodes: Some(&["bouncing_ball_woman", "basketball_woman"]) },
    Emoji { emoji: "⛹🏻‍♀️", name: "woman bouncing ball: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1917, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "⛹🏼‍♀️", name: "woman bouncing ball: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1917, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "⛹🏽‍♀️", name: "woman bouncing ball: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1917, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "⛹🏾‍♀️", name: "woman bouncing ball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1917, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "⛹🏿‍♀️", name: "woman bouncing ball: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1917, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏋️", name: "person lifting weights", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: Some((1923, 6, SkinTone::Default)), shortcodes: Some(&["weight_lifting"]) },
    Emoji { emoji: "🏋🏻", name: "person lifting weights: light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1923, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏋🏼", name: "person lifting weights: medium-light skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1923, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏋🏽", name: "person lifting weights: medium skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1923, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏋🏾", name: "person lifting weights: medium-dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1923, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏋🏿", name: "person lifting weights: dark skin tone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1923, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏋️‍♂️", name: "man lifting weights", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1929, 6, SkinTone::Default)), shortcodes: Some(&["weight_lifting_man"]) },
    Emoji { emoji: "🏋🏻‍♂️", name: "man lifting weights: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1929, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏋🏼‍♂️", name: "man lifting weights: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1929, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏋🏽‍♂️", name: "man lifting weights: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1929, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏋🏾‍♂️", name: "man lifting weights: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1929, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏋🏿‍♂️", name: "man lifting weights: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1929, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🏋️‍♀️", name: "woman lifting weights", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1935, 6, SkinTone::Default)), shortcodes: Some(&["weight_lifting_woman"]) },
    Emoji { emoji: "🏋🏻‍♀️", name: "woman lifting weights: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1935, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🏋🏼‍♀️", name: "woman lifting weights: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1935, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🏋🏽‍♀️", name: "woman lifting weights: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1935, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🏋🏾‍♀️", name: "woman lifting weights: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1935, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🏋🏿‍♀️", name: "woman lifting weights: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1935, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚴", name: "person biking", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1941, 6, SkinTone::Default)), shortcodes: Some(&["bicyclist"]) },
    Emoji { emoji: "🚴🏻", name: "person biking: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1941, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚴🏼", name: "person biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1941, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚴🏽", name: "person biking: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1941, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚴🏾", name: "person biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1941, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚴🏿", name: "person biking: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1941, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚴‍♂️", name: "man biking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1947, 6, SkinTone::Default)), shortcodes: Some(&["biking_man"]) },
    Emoji { emoji: "🚴🏻‍♂️", name: "man biking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1947, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚴🏼‍♂️", name: "man biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1947, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚴🏽‍♂️", name: "man biking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1947, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚴🏾‍♂️", name: "man biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1947, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚴🏿‍♂️", name: "man biking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1947, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚴‍♀️", name: "woman biking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1953, 6, SkinTone::Default)), shortcodes: Some(&["biking_woman"]) },
    Emoji { emoji: "🚴🏻‍♀️", name: "woman biking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1953, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚴🏼‍♀️", name: "woman biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1953, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚴🏽‍♀️", name: "woman biking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1953, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚴🏾‍♀️", name: "woman biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1953, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚴🏿‍♀️", name: "woman biking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1953, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚵", name: "person mountain biking", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1959, 6, SkinTone::Default)), shortcodes: Some(&["mountain_bicyclist"]) },
    Emoji { emoji: "🚵🏻", name: "person mountain biking: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1959, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚵🏼", name: "person mountain biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1959, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚵🏽", name: "person mountain biking: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1959, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚵🏾", name: "person mountain biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1959, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚵🏿", name: "person mountain biking: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1959, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚵‍♂️", name: "man mountain biking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1965, 6, SkinTone::Default)), shortcodes: Some(&["mountain_biking_man"]) },
    Emoji { emoji: "🚵🏻‍♂️", name: "man mountain biking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1965, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚵🏼‍♂️", name: "man mountain biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1965, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚵🏽‍♂️", name: "man mountain biking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1965, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚵🏾‍♂️", name: "man mountain biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1965, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚵🏿‍♂️", name: "man mountain biking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1965, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🚵‍♀️", name: "woman mountain biking", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1971, 6, SkinTone::Default)), shortcodes: Some(&["mountain_biking_woman"]) },
    Emoji { emoji: "🚵🏻‍♀️", name: "woman mountain biking: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1971, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🚵🏼‍♀️", name: "woman mountain biking: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1971, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🚵🏽‍♀️", name: "woman mountain biking: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1971, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🚵🏾‍♀️", name: "woman mountain biking: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1971, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🚵🏿‍♀️", name: "woman mountain biking: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1971, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤸", name: "person cartwheeling", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1977, 6, SkinTone::Default)), shortcodes: Some(&["cartwheeling"]) },
    Emoji { emoji: "🤸🏻", name: "person cartwheeling: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1977, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤸🏼", name: "person cartwheeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1977, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤸🏽", name: "person cartwheeling: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1977, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤸🏾", name: "person cartwheeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1977, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤸🏿", name: "person cartwheeling: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1977, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤸‍♂️", name: "man cartwheeling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1983, 6, SkinTone::Default)), shortcodes: Some(&["man_cartwheeling"]) },
    Emoji { emoji: "🤸🏻‍♂️", name: "man cartwheeling: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1983, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤸🏼‍♂️", name: "man cartwheeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1983, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤸🏽‍♂️", name: "man cartwheeling: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1983, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤸🏾‍♂️", name: "man cartwheeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1983, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤸🏿‍♂️", name: "man cartwheeling: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1983, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤸‍♀️", name: "woman cartwheeling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1989, 6, SkinTone::Default)), shortcodes: Some(&["woman_cartwheeling"]) },
    Emoji { emoji: "🤸🏻‍♀️", name: "woman cartwheeling: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1989, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤸🏼‍♀️", name: "woman cartwheeling: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1989, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤸🏽‍♀️", name: "woman cartwheeling: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1989, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤸🏾‍♀️", name: "woman cartwheeling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1989, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤸🏿‍♀️", name: "woman cartwheeling: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1989, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤼", name: "people wrestling", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["wrestling"]) },
    Emoji { emoji: "🤼‍♂️", name: "men wrestling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["men_wrestling"]) },
    Emoji { emoji: "🤼‍♀️", name: "women wrestling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["women_wrestling"]) },
    Emoji { emoji: "🤽", name: "person playing water polo", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1998, 6, SkinTone::Default)), shortcodes: Some(&["water_polo"]) },
    Emoji { emoji: "🤽🏻", name: "person playing water polo: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1998, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤽🏼", name: "person playing water polo: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1998, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤽🏽", name: "person playing water polo: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1998, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤽🏾", name: "person playing water polo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1998, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤽🏿", name: "person playing water polo: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((1998, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤽‍♂️", name: "man playing water polo", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2004, 6, SkinTone::Default)), shortcodes: Some(&["man_playing_water_polo"]) },
    Emoji { emoji: "🤽🏻‍♂️", name: "man playing water polo: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2004, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤽🏼‍♂️", name: "man playing water polo: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2004, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤽🏽‍♂️", name: "man playing water polo: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2004, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤽🏾‍♂️", name: "man playing water polo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2004, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤽🏿‍♂️", name: "man playing water polo: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2004, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤽‍♀️", name: "woman playing water polo", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2010, 6, SkinTone::Default)), shortcodes: Some(&["woman_playing_water_polo"]) },
    Emoji { emoji: "🤽🏻‍♀️", name: "woman playing water polo: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2010, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤽🏼‍♀️", name: "woman playing water polo: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2010, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤽🏽‍♀️", name: "woman playing water polo: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2010, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤽🏾‍♀️", name: "woman playing water polo: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2010, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤽🏿‍♀️", name: "woman playing water polo: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2010, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤾", name: "person playing handball", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2016, 6, SkinTone::Default)), shortcodes: Some(&["handball_person"]) },
    Emoji { emoji: "🤾🏻", name: "person playing handball: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2016, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤾🏼", name: "person playing handball: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2016, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤾🏽", name: "person playing handball: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2016, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤾🏾", name: "person playing handball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2016, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤾🏿", name: "person playing handball: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2016, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤾‍♂️", name: "man playing handball", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2022, 6, SkinTone::Default)), shortcodes: Some(&["man_playing_handball"]) },
    Emoji { emoji: "🤾🏻‍♂️", name: "man playing handball: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2022, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤾🏼‍♂️", name: "man playing handball: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2022, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤾🏽‍♂️", name: "man playing handball: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2022, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤾🏾‍♂️", name: "man playing handball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2022, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤾🏿‍♂️", name: "man playing handball: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2022, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤾‍♀️", name: "woman playing handball", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2028, 6, SkinTone::Default)), shortcodes: Some(&["woman_playing_handball"]) },
    Emoji { emoji: "🤾🏻‍♀️", name: "woman playing handball: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2028, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤾🏼‍♀️", name: "woman playing handball: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2028, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤾🏽‍♀️", name: "woman playing handball: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2028, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤾🏾‍♀️", name: "woman playing handball: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2028, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤾🏿‍♀️", name: "woman playing handball: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2028, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤹", name: "person juggling", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2034, 6, SkinTone::Default)), shortcodes: Some(&["juggling_person"]) },
    Emoji { emoji: "🤹🏻", name: "person juggling: light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2034, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤹🏼", name: "person juggling: medium-light skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2034, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤹🏽", name: "person juggling: medium skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2034, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤹🏾", name: "person juggling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2034, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤹🏿", name: "person juggling: dark skin tone", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2034, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤹‍♂️", name: "man juggling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2040, 6, SkinTone::Default)), shortcodes: Some(&["man_juggling"]) },
    Emoji { emoji: "🤹🏻‍♂️", name: "man juggling: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2040, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤹🏼‍♂️", name: "man juggling: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2040, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤹🏽‍♂️", name: "man juggling: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2040, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤹🏾‍♂️", name: "man juggling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2040, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤹🏿‍♂️", name: "man juggling: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2040, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🤹‍♀️", name: "woman juggling", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2046, 6, SkinTone::Default)), shortcodes: Some(&["woman_juggling"]) },
    Emoji { emoji: "🤹🏻‍♀️", name: "woman juggling: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2046, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🤹🏼‍♀️", name: "woman juggling: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2046, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🤹🏽‍♀️", name: "woman juggling: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2046, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🤹🏾‍♀️", name: "woman juggling: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2046, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🤹🏿‍♀️", name: "woman juggling: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2046, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧘", name: "person in lotus position", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2052, 6, SkinTone::Default)), shortcodes: Some(&["lotus_position"]) },
    Emoji { emoji: "🧘🏻", name: "person in lotus position: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2052, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧘🏼", name: "person in lotus position: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2052, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧘🏽", name: "person in lotus position: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2052, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧘🏾", name: "person in lotus position: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2052, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧘🏿", name: "person in lotus position: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2052, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧘‍♂️", name: "man in lotus position", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2058, 6, SkinTone::Default)), shortcodes: Some(&["lotus_position_man"]) },
    Emoji { emoji: "🧘🏻‍♂️", name: "man in lotus position: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2058, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧘🏼‍♂️", name: "man in lotus position: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2058, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧘🏽‍♂️", name: "man in lotus position: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2058, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧘🏾‍♂️", name: "man in lotus position: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2058, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧘🏿‍♂️", name: "man in lotus position: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2058, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧘‍♀️", name: "woman in lotus position", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2064, 6, SkinTone::Default)), shortcodes: Some(&["lotus_position_woman"]) },
    Emoji { emoji: "🧘🏻‍♀️", name: "woman in lotus position: light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2064, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧘🏼‍♀️", name: "woman in lotus position: medium-light skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2064, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧘🏽‍♀️", name: "woman in lotus position: medium skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2064, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧘🏾‍♀️", name: "woman in lotus position: medium-dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2064, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧘🏿‍♀️", name: "woman in lotus position: dark skin tone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2064, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🛀", name: "person taking bath", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((2070, 6, SkinTone::Default)), shortcodes: Some(&["bath"]) },
    Emoji { emoji: "🛀🏻", name: "person taking bath: light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2070, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🛀🏼", name: "person taking bath: medium-light skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2070, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🛀🏽", name: "person taking bath: medium skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2070, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🛀🏾", name: "person taking bath: medium-dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2070, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🛀🏿", name: "person taking bath: dark skin tone", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2070, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🛌", name: "person in bed", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2076, 6, SkinTone::Default)), shortcodes: Some(&["sleeping_bed"]) },
    Emoji { emoji: "🛌🏻", name: "person in bed: light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2076, 6, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🛌🏼", name: "person in bed: medium-light skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2076, 6, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🛌🏽", name: "person in bed: medium skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2076, 6, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🛌🏾", name: "person in bed: medium-dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2076, 6, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🛌🏿", name: "person in bed: dark skin tone", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2076, 6, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑‍🤝‍🧑", name: "people holding hands", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::Default)), shortcodes: Some(&["people_holding_hands"]) },
    Emoji { emoji: "🧑🏻‍🤝‍🧑🏻", name: "people holding hands: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🤝‍🧑🏼", name: "people holding hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🤝‍🧑🏽", name: "people holding hands: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🤝‍🧑🏾", name: "people holding hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🤝‍🧑🏿", name: "people holding hands: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍🤝‍🧑🏼", name: "people holding hands: light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍🤝‍🧑🏽", name: "people holding hands: light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍🤝‍🧑🏾", name: "people holding hands: light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍🤝‍🧑🏿", name: "people holding hands: light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🤝‍🧑🏻", name: "people holding hands: medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🤝‍🧑🏽", name: "people holding hands: medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🤝‍🧑🏾", name: "people holding hands: medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍🤝‍🧑🏿", name: "people holding hands: medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🤝‍🧑🏻", name: "people holding hands: medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🤝‍🧑🏼", name: "people holding hands: medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🤝‍🧑🏾", name: "people holding hands: medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍🤝‍🧑🏿", name: "people holding hands: medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🤝‍🧑🏻", name: "people holding hands: medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🤝‍🧑🏼", name: "people holding hands: medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🤝‍🧑🏽", name: "people holding hands: medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍🤝‍🧑🏿", name: "people holding hands: medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🤝‍🧑🏻", name: "people holding hands: dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🤝‍🧑🏼", name: "people holding hands: dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🤝‍🧑🏽", name: "people holding hands: dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍🤝‍🧑🏾", name: "people holding hands: dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2082, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👭", name: "women holding hands", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::Default)), shortcodes: Some(&["two_women_holding_hands"]) },
    Emoji { emoji: "👭🏻", name: "women holding hands: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👭🏼", name: "women holding hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👭🏽", name: "women holding hands: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👭🏾", name: "women holding hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👭🏿", name: "women holding hands: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍🤝‍👩🏼", name: "women holding hands: light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏻‍🤝‍👩🏽", name: "women holding hands: light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏻‍🤝‍👩🏾", name: "women holding hands: light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍🤝‍👩🏿", name: "women holding hands: light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🤝‍👩🏻", name: "women holding hands: medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🤝‍👩🏽", name: "women holding hands: medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🤝‍👩🏾", name: "women holding hands: medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🤝‍👩🏿", name: "women holding hands: medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🤝‍👩🏻", name: "women holding hands: medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🤝‍👩🏼", name: "women holding hands: medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🤝‍👩🏾", name: "women holding hands: medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🤝‍👩🏿", name: "women holding hands: medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🤝‍👩🏻", name: "women holding hands: medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🤝‍👩🏼", name: "women holding hands: medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🤝‍👩🏽", name: "women holding hands: medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🤝‍👩🏿", name: "women holding hands: medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🤝‍👩🏻", name: "women holding hands: dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🤝‍👩🏼", name: "women holding hands: dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🤝‍👩🏽", name: "women holding hands: dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🤝‍👩🏾", name: "women holding hands: dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2108, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👫", name: "woman and man holding hands", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::Default)), shortcodes: Some(&["couple"]) },
    Emoji { emoji: "👫🏻", name: "woman and man holding hands: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👫🏼", name: "woman and man holding hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👫🏽", name: "woman and man holding hands: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👫🏾", name: "woman and man holding hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👫🏿", name: "woman and man holding hands: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍🤝‍👨🏼", name: "woman and man holding hands: light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏻‍🤝‍👨🏽", name: "woman and man holding hands: light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏻‍🤝‍👨🏾", name: "woman and man holding hands: light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍🤝‍👨🏿", name: "woman and man holding hands: light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🤝‍👨🏻", name: "woman and man holding hands: medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🤝‍👨🏽", name: "woman and man holding hands: medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🤝‍👨🏾", name: "woman and man holding hands: medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍🤝‍👨🏿", name: "woman and man holding hands: medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🤝‍👨🏻", name: "woman and man holding hands: medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🤝‍👨🏼", name: "woman and man holding hands: medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🤝‍👨🏾", name: "woman and man holding hands: medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍🤝‍👨🏿", name: "woman and man holding hands: medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🤝‍👨🏻", name: "woman and man holding hands: medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🤝‍👨🏼", name: "woman and man holding hands: medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🤝‍👨🏽", name: "woman and man holding hands: medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍🤝‍👨🏿", name: "woman and man holding hands: medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🤝‍👨🏻", name: "woman and man holding hands: dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🤝‍👨🏼", name: "woman and man holding hands: dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🤝‍👨🏽", name: "woman and man holding hands: dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏿‍🤝‍👨🏾", name: "woman and man holding hands: dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2134, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👬", name: "men holding hands", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::Default)), shortcodes: Some(&["two_men_holding_hands"]) },
    Emoji { emoji: "👬🏻", name: "men holding hands: light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👬🏼", name: "men holding hands: medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👬🏽", name: "men holding hands: medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👬🏾", name: "men holding hands: medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👬🏿", name: "men holding hands: dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨🏻‍🤝‍👨🏼", name: "men holding hands: light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏻‍🤝‍👨🏽", name: "men holding hands: light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏻‍🤝‍👨🏾", name: "men holding hands: light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏻‍🤝‍👨🏿", name: "men holding hands: light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🤝‍👨🏻", name: "men holding hands: medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🤝‍👨🏽", name: "men holding hands: medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🤝‍👨🏾", name: "men holding hands: medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏼‍🤝‍👨🏿", name: "men holding hands: medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🤝‍👨🏻", name: "men holding hands: medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🤝‍👨🏼", name: "men holding hands: medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🤝‍👨🏾", name: "men holding hands: medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏽‍🤝‍👨🏿", name: "men holding hands: medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🤝‍👨🏻", name: "men holding hands: medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🤝‍👨🏼", name: "men holding hands: medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🤝‍👨🏽", name: "men holding hands: medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍🤝‍👨🏿", name: "men holding hands: medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🤝‍👨🏻", name: "men holding hands: dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🤝‍👨🏼", name: "men holding hands: dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🤝‍👨🏽", name: "men holding hands: dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏿‍🤝‍👨🏾", name: "men holding hands: dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2160, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "💏", name: "kiss", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::Default)), shortcodes: Some(&["couplekiss"]) },
    Emoji { emoji: "💏🏻", name: "kiss: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💏🏼", name: "kiss: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💏🏽", name: "kiss: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💏🏾", name: "kiss: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💏🏿", name: "kiss: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍❤️‍💋‍🧑🏼", name: "kiss: person, person, light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍❤️‍💋‍🧑🏽", name: "kiss: person, person, light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍❤️‍💋‍🧑🏾", name: "kiss: person, person, light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍❤️‍💋‍🧑🏿", name: "kiss: person, person, light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍❤️‍💋‍🧑🏻", name: "kiss: person, person, medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍❤️‍💋‍🧑🏽", name: "kiss: person, person, medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍❤️‍💋‍🧑🏾", name: "kiss: person, person, medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍❤️‍💋‍🧑🏿", name: "kiss: person, person, medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍❤️‍💋‍🧑🏻", name: "kiss: person, person, medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍❤️‍💋‍🧑🏼", name: "kiss: person, person, medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍❤️‍💋‍🧑🏾", name: "kiss: person, person, medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍❤️‍💋‍🧑🏿", name: "kiss: person, person, medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍❤️‍💋‍🧑🏻", name: "kiss: person, person, medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍❤️‍💋‍🧑🏼", name: "kiss: person, person, medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍❤️‍💋‍🧑🏽", name: "kiss: person, person, medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍❤️‍💋‍🧑🏿", name: "kiss: person, person, medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍❤️‍💋‍🧑🏻", name: "kiss: person, person, dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍❤️‍💋‍🧑🏼", name: "kiss: person, person, dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍❤️‍💋‍🧑🏽", name: "kiss: person, person, dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍❤️‍💋‍🧑🏾", name: "kiss: person, person, dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2186, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩‍❤️‍💋‍👨", name: "kiss: woman, man", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::Default)), shortcodes: Some(&["couplekiss_man_woman"]) },
    Emoji { emoji: "👩🏻‍❤️‍💋‍👨🏻", name: "kiss: woman, man, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍💋‍👨🏼", name: "kiss: woman, man, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍💋‍👨🏽", name: "kiss: woman, man, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍💋‍👨🏾", name: "kiss: woman, man, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍💋‍👨🏿", name: "kiss: woman, man, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍💋‍👨🏼", name: "kiss: woman, man, light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍💋‍👨🏽", name: "kiss: woman, man, light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍💋‍👨🏾", name: "kiss: woman, man, light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍💋‍👨🏿", name: "kiss: woman, man, light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍💋‍👨🏻", name: "kiss: woman, man, medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍💋‍👨🏽", name: "kiss: woman, man, medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍💋‍👨🏾", name: "kiss: woman, man, medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍💋‍👨🏿", name: "kiss: woman, man, medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍💋‍👨🏻", name: "kiss: woman, man, medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍💋‍👨🏼", name: "kiss: woman, man, medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍💋‍👨🏾", name: "kiss: woman, man, medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍💋‍👨🏿", name: "kiss: woman, man, medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍💋‍👨🏻", name: "kiss: woman, man, medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍💋‍👨🏼", name: "kiss: woman, man, medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍💋‍👨🏽", name: "kiss: woman, man, medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍💋‍👨🏿", name: "kiss: woman, man, medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍💋‍👨🏻", name: "kiss: woman, man, dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍💋‍👨🏼", name: "kiss: woman, man, dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍💋‍👨🏽", name: "kiss: woman, man, dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍💋‍👨🏾", name: "kiss: woman, man, dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2212, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨‍❤️‍💋‍👨", name: "kiss: man, man", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::Default)), shortcodes: Some(&["couplekiss_man_man"]) },
    Emoji { emoji: "👨🏻‍❤️‍💋‍👨🏻", name: "kiss: man, man, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍❤️‍💋‍👨🏼", name: "kiss: man, man, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍❤️‍💋‍👨🏽", name: "kiss: man, man, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍❤️‍💋‍👨🏾", name: "kiss: man, man, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍❤️‍💋‍👨🏿", name: "kiss: man, man, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨🏻‍❤️‍💋‍👨🏼", name: "kiss: man, man, light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏻‍❤️‍💋‍👨🏽", name: "kiss: man, man, light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏻‍❤️‍💋‍👨🏾", name: "kiss: man, man, light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏻‍❤️‍💋‍👨🏿", name: "kiss: man, man, light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏼‍❤️‍💋‍👨🏻", name: "kiss: man, man, medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏼‍❤️‍💋‍👨🏽", name: "kiss: man, man, medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏼‍❤️‍💋‍👨🏾", name: "kiss: man, man, medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏼‍❤️‍💋‍👨🏿", name: "kiss: man, man, medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏽‍❤️‍💋‍👨🏻", name: "kiss: man, man, medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍❤️‍💋‍👨🏼", name: "kiss: man, man, medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍❤️‍💋‍👨🏾", name: "kiss: man, man, medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏽‍❤️‍💋‍👨🏿", name: "kiss: man, man, medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏾‍❤️‍💋‍👨🏻", name: "kiss: man, man, medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏾‍❤️‍💋‍👨🏼", name: "kiss: man, man, medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏾‍❤️‍💋‍👨🏽", name: "kiss: man, man, medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍❤️‍💋‍👨🏿", name: "kiss: man, man, medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍❤️‍💋‍👨🏻", name: "kiss: man, man, dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏿‍❤️‍💋‍👨🏼", name: "kiss: man, man, dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏿‍❤️‍💋‍👨🏽", name: "kiss: man, man, dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏿‍❤️‍💋‍👨🏾", name: "kiss: man, man, dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2238, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩‍❤️‍💋‍👩", name: "kiss: woman, woman", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::Default)), shortcodes: Some(&["couplekiss_woman_woman"]) },
    Emoji { emoji: "👩🏻‍❤️‍💋‍👩🏻", name: "kiss: woman, woman, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍💋‍👩🏼", name: "kiss: woman, woman, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍💋‍👩🏽", name: "kiss: woman, woman, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍💋‍👩🏾", name: "kiss: woman, woman, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍💋‍👩🏿", name: "kiss: woman, woman, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍💋‍👩🏼", name: "kiss: woman, woman, light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍💋‍👩🏽", name: "kiss: woman, woman, light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍💋‍👩🏾", name: "kiss: woman, woman, light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍💋‍👩🏿", name: "kiss: woman, woman, light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍💋‍👩🏻", name: "kiss: woman, woman, medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍💋‍👩🏽", name: "kiss: woman, woman, medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍💋‍👩🏾", name: "kiss: woman, woman, medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍💋‍👩🏿", name: "kiss: woman, woman, medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍💋‍👩🏻", name: "kiss: woman, woman, medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍💋‍👩🏼", name: "kiss: woman, woman, medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍💋‍👩🏾", name: "kiss: woman, woman, medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍💋‍👩🏿", name: "kiss: woman, woman, medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍💋‍👩🏻", name: "kiss: woman, woman, medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍💋‍👩🏼", name: "kiss: woman, woman, medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍💋‍👩🏽", name: "kiss: woman, woman, medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍💋‍👩🏿", name: "kiss: woman, woman, medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍💋‍👩🏻", name: "kiss: woman, woman, dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍💋‍👩🏼", name: "kiss: woman, woman, dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍💋‍👩🏽", name: "kiss: woman, woman, dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍💋‍👩🏾", name: "kiss: woman, woman, dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2264, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "💑", name: "couple with heart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::Default)), shortcodes: Some(&["couple_with_heart"]) },
    Emoji { emoji: "💑🏻", name: "couple with heart: light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "💑🏼", name: "couple with heart: medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "💑🏽", name: "couple with heart: medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "💑🏾", name: "couple with heart: medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "💑🏿", name: "couple with heart: dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍❤️‍🧑🏼", name: "couple with heart: person, person, light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍❤️‍🧑🏽", name: "couple with heart: person, person, light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍❤️‍🧑🏾", name: "couple with heart: person, person, light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏻‍❤️‍🧑🏿", name: "couple with heart: person, person, light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍❤️‍🧑🏻", name: "couple with heart: person, person, medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍❤️‍🧑🏽", name: "couple with heart: person, person, medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍❤️‍🧑🏾", name: "couple with heart: person, person, medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏼‍❤️‍🧑🏿", name: "couple with heart: person, person, medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍❤️‍🧑🏻", name: "couple with heart: person, person, medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍❤️‍🧑🏼", name: "couple with heart: person, person, medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍❤️‍🧑🏾", name: "couple with heart: person, person, medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "🧑🏽‍❤️‍🧑🏿", name: "couple with heart: person, person, medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍❤️‍🧑🏻", name: "couple with heart: person, person, medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍❤️‍🧑🏼", name: "couple with heart: person, person, medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍❤️‍🧑🏽", name: "couple with heart: person, person, medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏾‍❤️‍🧑🏿", name: "couple with heart: person, person, medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍❤️‍🧑🏻", name: "couple with heart: person, person, dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍❤️‍🧑🏼", name: "couple with heart: person, person, dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍❤️‍🧑🏽", name: "couple with heart: person, person, dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "🧑🏿‍❤️‍🧑🏾", name: "couple with heart: person, person, dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2290, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩‍❤️‍👨", name: "couple with heart: woman, man", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::Default)), shortcodes: Some(&["couple_with_heart_woman_man"]) },
    Emoji { emoji: "👩🏻‍❤️‍👨🏻", name: "couple with heart: woman, man, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍👨🏼", name: "couple with heart: woman, man, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍👨🏽", name: "couple with heart: woman, man, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍👨🏾", name: "couple with heart: woman, man, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍👨🏿", name: "couple with heart: woman, man, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍👨🏼", name: "couple with heart: woman, man, light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍👨🏽", name: "couple with heart: woman, man, light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍👨🏾", name: "couple with heart: woman, man, light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍👨🏿", name: "couple with heart: woman, man, light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍👨🏻", name: "couple with heart: woman, man, medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍👨🏽", name: "couple with heart: woman, man, medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍👨🏾", name: "couple with heart: woman, man, medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍👨🏿", name: "couple with heart: woman, man, medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍👨🏻", name: "couple with heart: woman, man, medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍👨🏼", name: "couple with heart: woman, man, medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍👨🏾", name: "couple with heart: woman, man, medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍👨🏿", name: "couple with heart: woman, man, medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍👨🏻", name: "couple with heart: woman, man, medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍👨🏼", name: "couple with heart: woman, man, medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍👨🏽", name: "couple with heart: woman, man, medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍👨🏿", name: "couple with heart: woman, man, medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍👨🏻", name: "couple with heart: woman, man, dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍👨🏼", name: "couple with heart: woman, man, dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍👨🏽", name: "couple with heart: woman, man, dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍👨🏾", name: "couple with heart: woman, man, dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2316, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨‍❤️‍👨", name: "couple with heart: man, man", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::Default)), shortcodes: Some(&["couple_with_heart_man_man"]) },
    Emoji { emoji: "👨🏻‍❤️‍👨🏻", name: "couple with heart: man, man, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👨🏼‍❤️‍👨🏼", name: "couple with heart: man, man, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍❤️‍👨🏽", name: "couple with heart: man, man, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍❤️‍👨🏾", name: "couple with heart: man, man, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍❤️‍👨🏿", name: "couple with heart: man, man, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👨🏻‍❤️‍👨🏼", name: "couple with heart: man, man, light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏻‍❤️‍👨🏽", name: "couple with heart: man, man, light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏻‍❤️‍👨🏾", name: "couple with heart: man, man, light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏻‍❤️‍👨🏿", name: "couple with heart: man, man, light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏼‍❤️‍👨🏻", name: "couple with heart: man, man, medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏼‍❤️‍👨🏽", name: "couple with heart: man, man, medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏼‍❤️‍👨🏾", name: "couple with heart: man, man, medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏼‍❤️‍👨🏿", name: "couple with heart: man, man, medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏽‍❤️‍👨🏻", name: "couple with heart: man, man, medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍❤️‍👨🏼", name: "couple with heart: man, man, medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏽‍❤️‍👨🏾", name: "couple with heart: man, man, medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨🏽‍❤️‍👨🏿", name: "couple with heart: man, man, medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏾‍❤️‍👨🏻", name: "couple with heart: man, man, medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏾‍❤️‍👨🏼", name: "couple with heart: man, man, medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏾‍❤️‍👨🏽", name: "couple with heart: man, man, medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏾‍❤️‍👨🏿", name: "couple with heart: man, man, medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "👨🏿‍❤️‍👨🏻", name: "couple with heart: man, man, dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "👨🏿‍❤️‍👨🏼", name: "couple with heart: man, man, dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👨🏿‍❤️‍👨🏽", name: "couple with heart: man, man, dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👨🏿‍❤️‍👨🏾", name: "couple with heart: man, man, dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2342, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩‍❤️‍👩", name: "couple with heart: woman, woman", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::Default)), shortcodes: Some(&["couple_with_heart_woman_woman"]) },
    Emoji { emoji: "👩🏻‍❤️‍👩🏻", name: "couple with heart: woman, woman, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::Light)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍👩🏼", name: "couple with heart: woman, woman, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍👩🏽", name: "couple with heart: woman, woman, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::Medium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍👩🏾", name: "couple with heart: woman, woman, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍👩🏿", name: "couple with heart: woman, woman, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::Dark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍👩🏼", name: "couple with heart: woman, woman, light skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::LightAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍👩🏽", name: "couple with heart: woman, woman, light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::LightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍👩🏾", name: "couple with heart: woman, woman, light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::LightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏻‍❤️‍👩🏿", name: "couple with heart: woman, woman, light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::LightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍👩🏻", name: "couple with heart: woman, woman, medium-light skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumLightAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍👩🏽", name: "couple with heart: woman, woman, medium-light skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumLightAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍👩🏾", name: "couple with heart: woman, woman, medium-light skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumLightAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏼‍❤️‍👩🏿", name: "couple with heart: woman, woman, medium-light skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumLightAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍👩🏻", name: "couple with heart: woman, woman, medium skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍👩🏼", name: "couple with heart: woman, woman, medium skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍👩🏾", name: "couple with heart: woman, woman, medium skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👩🏽‍❤️‍👩🏿", name: "couple with heart: woman, woman, medium skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍👩🏻", name: "couple with heart: woman, woman, medium-dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumDarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍👩🏼", name: "couple with heart: woman, woman, medium-dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumDarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍👩🏽", name: "couple with heart: woman, woman, medium-dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumDarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏾‍❤️‍👩🏿", name: "couple with heart: woman, woman, medium-dark skin tone, dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::MediumDarkAndDark)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍👩🏻", name: "couple with heart: woman, woman, dark skin tone, light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::DarkAndLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍👩🏼", name: "couple with heart: woman, woman, dark skin tone, medium-light skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::DarkAndMediumLight)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍👩🏽", name: "couple with heart: woman, woman, dark skin tone, medium skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::DarkAndMedium)), shortcodes: None },
    Emoji { emoji: "👩🏿‍❤️‍👩🏾", name: "couple with heart: woman, woman, dark skin tone, medium-dark skin tone", unicode_version: UnicodeVersion { major: 13, minor: 1 }, group: Group::PeopleAndBody, skin_tone: Some((2368, 26, SkinTone::DarkAndMediumDark)), shortcodes: None },
    Emoji { emoji: "👨‍👩‍👦", name: "family: man, woman, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_woman_boy"]) },
    Emoji { emoji: "👨‍👩‍👧", name: "family: man, woman, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_woman_girl"]) },
    Emoji { emoji: "👨‍👩‍👧‍👦", name: "family: man, woman, girl, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_woman_girl_boy"]) },
    Emoji { emoji: "👨‍👩‍👦‍👦", name: "family: man, woman, boy, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_woman_boy_boy"]) },
    Emoji { emoji: "👨‍👩‍👧‍👧", name: "family: man, woman, girl, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_woman_girl_girl"]) },
    Emoji { emoji: "👨‍👨‍👦", name: "family: man, man, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_man_boy"]) },
    Emoji { emoji: "👨‍👨‍👧", name: "family: man, man, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_man_girl"]) },
    Emoji { emoji: "👨‍👨‍👧‍👦", name: "family: man, man, girl, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_man_girl_boy"]) },
    Emoji { emoji: "👨‍👨‍👦‍👦", name: "family: man, man, boy, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_man_boy_boy"]) },
    Emoji { emoji: "👨‍👨‍👧‍👧", name: "family: man, man, girl, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_man_girl_girl"]) },
    Emoji { emoji: "👩‍👩‍👦", name: "family: woman, woman, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_woman_woman_boy"]) },
    Emoji { emoji: "👩‍👩‍👧", name: "family: woman, woman, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_woman_woman_girl"]) },
    Emoji { emoji: "👩‍👩‍👧‍👦", name: "family: woman, woman, girl, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_woman_woman_girl_boy"]) },
    Emoji { emoji: "👩‍👩‍👦‍👦", name: "family: woman, woman, boy, boy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_woman_woman_boy_boy"]) },
    Emoji { emoji: "👩‍👩‍👧‍👧", name: "family: woman, woman, girl, girl", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_woman_woman_girl_girl"]) },
    Emoji { emoji: "👨‍👦", name: "family: man, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_boy"]) },
    Emoji { emoji: "👨‍👦‍👦", name: "family: man, boy, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_boy_boy"]) },
    Emoji { emoji: "👨‍👧", name: "family: man, girl", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_girl"]) },
    Emoji { emoji: "👨‍👧‍👦", name: "family: man, girl, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_girl_boy"]) },
    Emoji { emoji: "👨‍👧‍👧", name: "family: man, girl, girl", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_man_girl_girl"]) },
    Emoji { emoji: "👩‍👦", name: "family: woman, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_woman_boy"]) },
    Emoji { emoji: "👩‍👦‍👦", name: "family: woman, boy, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_woman_boy_boy"]) },
    Emoji { emoji: "👩‍👧", name: "family: woman, girl", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_woman_girl"]) },
    Emoji { emoji: "👩‍👧‍👦", name: "family: woman, girl, boy", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_woman_girl_boy"]) },
    Emoji { emoji: "👩‍👧‍👧", name: "family: woman, girl, girl", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family_woman_girl_girl"]) },
    Emoji { emoji: "🗣️", name: "speaking head", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["speaking_head"]) },
    Emoji { emoji: "👤", name: "bust in silhouette", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["bust_in_silhouette"]) },
    Emoji { emoji: "👥", name: "busts in silhouette", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["busts_in_silhouette"]) },
    Emoji { emoji: "🫂", name: "people hugging", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["people_hugging"]) },
    Emoji { emoji: "👪", name: "family", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["family"]) },
    Emoji { emoji: "🧑‍🧑‍🧒", name: "family: adult, adult, child", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: None },
    Emoji { emoji: "🧑‍🧑‍🧒‍🧒", name: "family: adult, adult, child, child", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: None },
    Emoji { emoji: "🧑‍🧒", name: "family: adult, child", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: None },
    Emoji { emoji: "🧑‍🧒‍🧒", name: "family: adult, child, child", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: None },
    Emoji { emoji: "👣", name: "footprints", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: Some(&["footprints"]) },
    Emoji { emoji: "🫆", name: "fingerprint", unicode_version: UnicodeVersion { major: 16, minor: 0 }, group: Group::PeopleAndBody, skin_tone: None, shortcodes: None },
    Emoji { emoji: "🐵", name: "monkey face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["monkey_face"]) },
    Emoji { emoji: "🐒", name: "monkey", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["monkey"]) },
    Emoji { emoji: "🦍", name: "gorilla", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["gorilla"]) },
    Emoji { emoji: "🦧", name: "orangutan", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["orangutan"]) },
    Emoji { emoji: "🐶", name: "dog face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["dog"]) },
    Emoji { emoji: "🐕", name: "dog", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["dog2"]) },
    Emoji { emoji: "🦮", name: "guide dog", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["guide_dog"]) },
    Emoji { emoji: "🐕‍🦺", name: "service dog", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["service_dog"]) },
    Emoji { emoji: "🐩", name: "poodle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["poodle"]) },
    Emoji { emoji: "🐺", name: "wolf", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["wolf"]) },
    Emoji { emoji: "🦊", name: "fox", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["fox_face"]) },
    Emoji { emoji: "🦝", name: "raccoon", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["raccoon"]) },
    Emoji { emoji: "🐱", name: "cat face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["cat"]) },
    Emoji { emoji: "🐈", name: "cat", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["cat2"]) },
    Emoji { emoji: "🐈‍⬛", name: "black cat", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["black_cat"]) },
    Emoji { emoji: "🦁", name: "lion", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["lion"]) },
    Emoji { emoji: "🐯", name: "tiger face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["tiger"]) },
    Emoji { emoji: "🐅", name: "tiger", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["tiger2"]) },
    Emoji { emoji: "🐆", name: "leopard", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["leopard"]) },
    Emoji { emoji: "🐴", name: "horse face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["horse"]) },
    Emoji { emoji: "🫎", name: "moose", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["moose"]) },
    Emoji { emoji: "🫏", name: "donkey", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["donkey"]) },
    Emoji { emoji: "🐎", name: "horse", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["racehorse"]) },
    Emoji { emoji: "🦄", name: "unicorn", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["unicorn"]) },
    Emoji { emoji: "🦓", name: "zebra", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["zebra"]) },
    Emoji { emoji: "🦌", name: "deer", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["deer"]) },
    Emoji { emoji: "🦬", name: "bison", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["bison"]) },
    Emoji { emoji: "🐮", name: "cow face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["cow"]) },
    Emoji { emoji: "🐂", name: "ox", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["ox"]) },
    Emoji { emoji: "🐃", name: "water buffalo", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["water_buffalo"]) },
    Emoji { emoji: "🐄", name: "cow", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["cow2"]) },
    Emoji { emoji: "🐷", name: "pig face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["pig"]) },
    Emoji { emoji: "🐖", name: "pig", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["pig2"]) },
    Emoji { emoji: "🐗", name: "boar", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["boar"]) },
    Emoji { emoji: "🐽", name: "pig nose", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["pig_nose"]) },
    Emoji { emoji: "🐏", name: "ram", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["ram"]) },
    Emoji { emoji: "🐑", name: "ewe", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["sheep"]) },
    Emoji { emoji: "🐐", name: "goat", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["goat"]) },
    Emoji { emoji: "🐪", name: "camel", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["dromedary_camel"]) },
    Emoji { emoji: "🐫", name: "two-hump camel", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["camel"]) },
    Emoji { emoji: "🦙", name: "llama", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["llama"]) },
    Emoji { emoji: "🦒", name: "giraffe", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["giraffe"]) },
    Emoji { emoji: "🐘", name: "elephant", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["elephant"]) },
    Emoji { emoji: "🦣", name: "mammoth", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["mammoth"]) },
    Emoji { emoji: "🦏", name: "rhinoceros", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["rhinoceros"]) },
    Emoji { emoji: "🦛", name: "hippopotamus", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["hippopotamus"]) },
    Emoji { emoji: "🐭", name: "mouse face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["mouse"]) },
    Emoji { emoji: "🐁", name: "mouse", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["mouse2"]) },
    Emoji { emoji: "🐀", name: "rat", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["rat"]) },
    Emoji { emoji: "🐹", name: "hamster", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["hamster"]) },
    Emoji { emoji: "🐰", name: "rabbit face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["rabbit"]) },
    Emoji { emoji: "🐇", name: "rabbit", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["rabbit2"]) },
    Emoji { emoji: "🐿️", name: "chipmunk", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["chipmunk"]) },
    Emoji { emoji: "🦫", name: "beaver", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["beaver"]) },
    Emoji { emoji: "🦔", name: "hedgehog", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["hedgehog"]) },
    Emoji { emoji: "🦇", name: "bat", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["bat"]) },
    Emoji { emoji: "🐻", name: "bear", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["bear"]) },
    Emoji { emoji: "🐻‍❄️", name: "polar bear", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["polar_bear"]) },
    Emoji { emoji: "🐨", name: "koala", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["koala"]) },
    Emoji { emoji: "🐼", name: "panda", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["panda_face"]) },
    Emoji { emoji: "🦥", name: "sloth", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["sloth"]) },
    Emoji { emoji: "🦦", name: "otter", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["otter"]) },
    Emoji { emoji: "🦨", name: "skunk", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["skunk"]) },
    Emoji { emoji: "🦘", name: "kangaroo", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["kangaroo"]) },
    Emoji { emoji: "🦡", name: "badger", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["badger"]) },
    Emoji { emoji: "🐾", name: "paw prints", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["feet", "paw_prints"]) },
    Emoji { emoji: "🦃", name: "turkey", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["turkey"]) },
    Emoji { emoji: "🐔", name: "chicken", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["chicken"]) },
    Emoji { emoji: "🐓", name: "rooster", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["rooster"]) },
    Emoji { emoji: "🐣", name: "hatching chick", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["hatching_chick"]) },
    Emoji { emoji: "🐤", name: "baby chick", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["baby_chick"]) },
    Emoji { emoji: "🐥", name: "front-facing baby chick", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["hatched_chick"]) },
    Emoji { emoji: "🐦", name: "bird", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["bird"]) },
    Emoji { emoji: "🐧", name: "penguin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["penguin"]) },
    Emoji { emoji: "🕊️", name: "dove", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["dove"]) },
    Emoji { emoji: "🦅", name: "eagle", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["eagle"]) },
    Emoji { emoji: "🦆", name: "duck", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["duck"]) },
    Emoji { emoji: "🦢", name: "swan", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["swan"]) },
    Emoji { emoji: "🦉", name: "owl", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["owl"]) },
    Emoji { emoji: "🦤", name: "dodo", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["dodo"]) },
    Emoji { emoji: "🪶", name: "feather", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["feather"]) },
    Emoji { emoji: "🦩", name: "flamingo", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["flamingo"]) },
    Emoji { emoji: "🦚", name: "peacock", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["peacock"]) },
    Emoji { emoji: "🦜", name: "parrot", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["parrot"]) },
    Emoji { emoji: "🪽", name: "wing", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["wing"]) },
    Emoji { emoji: "🐦‍⬛", name: "black bird", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["black_bird"]) },
    Emoji { emoji: "🪿", name: "goose", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["goose"]) },
    Emoji { emoji: "🐦‍🔥", name: "phoenix", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: None },
    Emoji { emoji: "🐸", name: "frog", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["frog"]) },
    Emoji { emoji: "🐊", name: "crocodile", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["crocodile"]) },
    Emoji { emoji: "🐢", name: "turtle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["turtle"]) },
    Emoji { emoji: "🦎", name: "lizard", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["lizard"]) },
    Emoji { emoji: "🐍", name: "snake", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["snake"]) },
    Emoji { emoji: "🐲", name: "dragon face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["dragon_face"]) },
    Emoji { emoji: "🐉", name: "dragon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["dragon"]) },
    Emoji { emoji: "🦕", name: "sauropod", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["sauropod"]) },
    Emoji { emoji: "🦖", name: "T-Rex", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["t-rex"]) },
    Emoji { emoji: "🐳", name: "spouting whale", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["whale"]) },
    Emoji { emoji: "🐋", name: "whale", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["whale2"]) },
    Emoji { emoji: "🐬", name: "dolphin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["dolphin", "flipper"]) },
    Emoji { emoji: "🦭", name: "seal", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["seal"]) },
    Emoji { emoji: "🐟", name: "fish", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["fish"]) },
    Emoji { emoji: "🐠", name: "tropical fish", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["tropical_fish"]) },
    Emoji { emoji: "🐡", name: "blowfish", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["blowfish"]) },
    Emoji { emoji: "🦈", name: "shark", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["shark"]) },
    Emoji { emoji: "🐙", name: "octopus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["octopus"]) },
    Emoji { emoji: "🐚", name: "spiral shell", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["shell"]) },
    Emoji { emoji: "🪸", name: "coral", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["coral"]) },
    Emoji { emoji: "🪼", name: "jellyfish", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["jellyfish"]) },
    Emoji { emoji: "🦀", name: "crab", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["crab"]) },
    Emoji { emoji: "🦞", name: "lobster", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["lobster"]) },
    Emoji { emoji: "🦐", name: "shrimp", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["shrimp"]) },
    Emoji { emoji: "🦑", name: "squid", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["squid"]) },
    Emoji { emoji: "🦪", name: "oyster", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["oyster"]) },
    Emoji { emoji: "🐌", name: "snail", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["snail"]) },
    Emoji { emoji: "🦋", name: "butterfly", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["butterfly"]) },
    Emoji { emoji: "🐛", name: "bug", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["bug"]) },
    Emoji { emoji: "🐜", name: "ant", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["ant"]) },
    Emoji { emoji: "🐝", name: "honeybee", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["bee", "honeybee"]) },
    Emoji { emoji: "🪲", name: "beetle", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["beetle"]) },
    Emoji { emoji: "🐞", name: "lady beetle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["lady_beetle"]) },
    Emoji { emoji: "🦗", name: "cricket", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["cricket"]) },
    Emoji { emoji: "🪳", name: "cockroach", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["cockroach"]) },
    Emoji { emoji: "🕷️", name: "spider", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["spider"]) },
    Emoji { emoji: "🕸️", name: "spider web", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["spider_web"]) },
    Emoji { emoji: "🦂", name: "scorpion", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["scorpion"]) },
    Emoji { emoji: "🦟", name: "mosquito", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["mosquito"]) },
    Emoji { emoji: "🪰", name: "fly", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["fly"]) },
    Emoji { emoji: "🪱", name: "worm", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["worm"]) },
    Emoji { emoji: "🦠", name: "microbe", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["microbe"]) },
    Emoji { emoji: "💐", name: "bouquet", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["bouquet"]) },
    Emoji { emoji: "🌸", name: "cherry blossom", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["cherry_blossom"]) },
    Emoji { emoji: "💮", name: "white flower", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["white_flower"]) },
    Emoji { emoji: "🪷", name: "lotus", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["lotus"]) },
    Emoji { emoji: "🏵️", name: "rosette", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["rosette"]) },
    Emoji { emoji: "🌹", name: "rose", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["rose"]) },
    Emoji { emoji: "🥀", name: "wilted flower", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["wilted_flower"]) },
    Emoji { emoji: "🌺", name: "hibiscus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["hibiscus"]) },
    Emoji { emoji: "🌻", name: "sunflower", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["sunflower"]) },
    Emoji { emoji: "🌼", name: "blossom", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["blossom"]) },
    Emoji { emoji: "🌷", name: "tulip", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["tulip"]) },
    Emoji { emoji: "🪻", name: "hyacinth", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["hyacinth"]) },
    Emoji { emoji: "🌱", name: "seedling", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["seedling"]) },
    Emoji { emoji: "🪴", name: "potted plant", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["potted_plant"]) },
    Emoji { emoji: "🌲", name: "evergreen tree", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["evergreen_tree"]) },
    Emoji { emoji: "🌳", name: "deciduous tree", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["deciduous_tree"]) },
    Emoji { emoji: "🌴", name: "palm tree", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["palm_tree"]) },
    Emoji { emoji: "🌵", name: "cactus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["cactus"]) },
    Emoji { emoji: "🌾", name: "sheaf of rice", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["ear_of_rice"]) },
    Emoji { emoji: "🌿", name: "herb", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["herb"]) },
    Emoji { emoji: "☘️", name: "shamrock", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["shamrock"]) },
    Emoji { emoji: "🍀", name: "four leaf clover", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["four_leaf_clover"]) },
    Emoji { emoji: "🍁", name: "maple leaf", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["maple_leaf"]) },
    Emoji { emoji: "🍂", name: "fallen leaf", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["fallen_leaf"]) },
    Emoji { emoji: "🍃", name: "leaf fluttering in wind", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["leaves"]) },
    Emoji { emoji: "🪹", name: "empty nest", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["empty_nest"]) },
    Emoji { emoji: "🪺", name: "nest with eggs", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["nest_with_eggs"]) },
    Emoji { emoji: "🍄", name: "mushroom", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: Some(&["mushroom"]) },
    Emoji { emoji: "🪾", name: "leafless tree", unicode_version: UnicodeVersion { major: 16, minor: 0 }, group: Group::AnimalsAndNature, skin_tone: None, shortcodes: None },
    Emoji { emoji: "🍇", name: "grapes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["grapes"]) },
    Emoji { emoji: "🍈", name: "melon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["melon"]) },
    Emoji { emoji: "🍉", name: "watermelon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["watermelon"]) },
    Emoji { emoji: "🍊", name: "tangerine", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["tangerine", "orange", "mandarin"]) },
    Emoji { emoji: "🍋", name: "lemon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["lemon"]) },
    Emoji { emoji: "🍋‍🟩", name: "lime", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: None },
    Emoji { emoji: "🍌", name: "banana", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["banana"]) },
    Emoji { emoji: "🍍", name: "pineapple", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["pineapple"]) },
    Emoji { emoji: "🥭", name: "mango", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["mango"]) },
    Emoji { emoji: "🍎", name: "red apple", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["apple"]) },
    Emoji { emoji: "🍏", name: "green apple", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["green_apple"]) },
    Emoji { emoji: "🍐", name: "pear", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["pear"]) },
    Emoji { emoji: "🍑", name: "peach", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["peach"]) },
    Emoji { emoji: "🍒", name: "cherries", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["cherries"]) },
    Emoji { emoji: "🍓", name: "strawberry", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["strawberry"]) },
    Emoji { emoji: "🫐", name: "blueberries", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["blueberries"]) },
    Emoji { emoji: "🥝", name: "kiwi fruit", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["kiwi_fruit"]) },
    Emoji { emoji: "🍅", name: "tomato", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["tomato"]) },
    Emoji { emoji: "🫒", name: "olive", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["olive"]) },
    Emoji { emoji: "🥥", name: "coconut", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["coconut"]) },
    Emoji { emoji: "🥑", name: "avocado", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["avocado"]) },
    Emoji { emoji: "🍆", name: "eggplant", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["eggplant"]) },
    Emoji { emoji: "🥔", name: "potato", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["potato"]) },
    Emoji { emoji: "🥕", name: "carrot", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["carrot"]) },
    Emoji { emoji: "🌽", name: "ear of corn", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["corn"]) },
    Emoji { emoji: "🌶️", name: "hot pepper", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["hot_pepper"]) },
    Emoji { emoji: "🫑", name: "bell pepper", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["bell_pepper"]) },
    Emoji { emoji: "🥒", name: "cucumber", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["cucumber"]) },
    Emoji { emoji: "🥬", name: "leafy green", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["leafy_green"]) },
    Emoji { emoji: "🥦", name: "broccoli", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["broccoli"]) },
    Emoji { emoji: "🧄", name: "garlic", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["garlic"]) },
    Emoji { emoji: "🧅", name: "onion", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["onion"]) },
    Emoji { emoji: "🥜", name: "peanuts", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["peanuts"]) },
    Emoji { emoji: "🫘", name: "beans", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["beans"]) },
    Emoji { emoji: "🌰", name: "chestnut", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["chestnut"]) },
    Emoji { emoji: "🫚", name: "ginger root", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["ginger_root"]) },
    Emoji { emoji: "🫛", name: "pea pod", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["pea_pod"]) },
    Emoji { emoji: "🍄‍🟫", name: "brown mushroom", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: None },
    Emoji { emoji: "🫜", name: "root vegetable", unicode_version: UnicodeVersion { major: 16, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: None },
    Emoji { emoji: "🍞", name: "bread", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["bread"]) },
    Emoji { emoji: "🥐", name: "croissant", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["croissant"]) },
    Emoji { emoji: "🥖", name: "baguette bread", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["baguette_bread"]) },
    Emoji { emoji: "🫓", name: "flatbread", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["flatbread"]) },
    Emoji { emoji: "🥨", name: "pretzel", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["pretzel"]) },
    Emoji { emoji: "🥯", name: "bagel", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["bagel"]) },
    Emoji { emoji: "🥞", name: "pancakes", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["pancakes"]) },
    Emoji { emoji: "🧇", name: "waffle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["waffle"]) },
    Emoji { emoji: "🧀", name: "cheese wedge", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["cheese"]) },
    Emoji { emoji: "🍖", name: "meat on bone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["meat_on_bone"]) },
    Emoji { emoji: "🍗", name: "poultry leg", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["poultry_leg"]) },
    Emoji { emoji: "🥩", name: "cut of meat", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["cut_of_meat"]) },
    Emoji { emoji: "🥓", name: "bacon", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["bacon"]) },
    Emoji { emoji: "🍔", name: "hamburger", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["hamburger"]) },
    Emoji { emoji: "🍟", name: "french fries", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["fries"]) },
    Emoji { emoji: "🍕", name: "pizza", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["pizza"]) },
    Emoji { emoji: "🌭", name: "hot dog", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["hotdog"]) },
    Emoji { emoji: "🥪", name: "sandwich", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["sandwich"]) },
    Emoji { emoji: "🌮", name: "taco", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["taco"]) },
    Emoji { emoji: "🌯", name: "burrito", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["burrito"]) },
    Emoji { emoji: "🫔", name: "tamale", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["tamale"]) },
    Emoji { emoji: "🥙", name: "stuffed flatbread", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["stuffed_flatbread"]) },
    Emoji { emoji: "🧆", name: "falafel", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["falafel"]) },
    Emoji { emoji: "🥚", name: "egg", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["egg"]) },
    Emoji { emoji: "🍳", name: "cooking", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["fried_egg"]) },
    Emoji { emoji: "🥘", name: "shallow pan of food", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["shallow_pan_of_food"]) },
    Emoji { emoji: "🍲", name: "pot of food", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["stew"]) },
    Emoji { emoji: "🫕", name: "fondue", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["fondue"]) },
    Emoji { emoji: "🥣", name: "bowl with spoon", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["bowl_with_spoon"]) },
    Emoji { emoji: "🥗", name: "green salad", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["green_salad"]) },
    Emoji { emoji: "🍿", name: "popcorn", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["popcorn"]) },
    Emoji { emoji: "🧈", name: "butter", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["butter"]) },
    Emoji { emoji: "🧂", name: "salt", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["salt"]) },
    Emoji { emoji: "🥫", name: "canned food", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["canned_food"]) },
    Emoji { emoji: "🍱", name: "bento box", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["bento"]) },
    Emoji { emoji: "🍘", name: "rice cracker", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["rice_cracker"]) },
    Emoji { emoji: "🍙", name: "rice ball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["rice_ball"]) },
    Emoji { emoji: "🍚", name: "cooked rice", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["rice"]) },
    Emoji { emoji: "🍛", name: "curry rice", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["curry"]) },
    Emoji { emoji: "🍜", name: "steaming bowl", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["ramen"]) },
    Emoji { emoji: "🍝", name: "spaghetti", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["spaghetti"]) },
    Emoji { emoji: "🍠", name: "roasted sweet potato", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["sweet_potato"]) },
    Emoji { emoji: "🍢", name: "oden", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["oden"]) },
    Emoji { emoji: "🍣", name: "sushi", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["sushi"]) },
    Emoji { emoji: "🍤", name: "fried shrimp", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["fried_shrimp"]) },
    Emoji { emoji: "🍥", name: "fish cake with swirl", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["fish_cake"]) },
    Emoji { emoji: "🥮", name: "moon cake", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["moon_cake"]) },
    Emoji { emoji: "🍡", name: "dango", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["dango"]) },
    Emoji { emoji: "🥟", name: "dumpling", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["dumpling"]) },
    Emoji { emoji: "🥠", name: "fortune cookie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["fortune_cookie"]) },
    Emoji { emoji: "🥡", name: "takeout box", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["takeout_box"]) },
    Emoji { emoji: "🍦", name: "soft ice cream", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["icecream"]) },
    Emoji { emoji: "🍧", name: "shaved ice", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["shaved_ice"]) },
    Emoji { emoji: "🍨", name: "ice cream", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["ice_cream"]) },
    Emoji { emoji: "🍩", name: "doughnut", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["doughnut"]) },
    Emoji { emoji: "🍪", name: "cookie", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["cookie"]) },
    Emoji { emoji: "🎂", name: "birthday cake", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["birthday"]) },
    Emoji { emoji: "🍰", name: "shortcake", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["cake"]) },
    Emoji { emoji: "🧁", name: "cupcake", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["cupcake"]) },
    Emoji { emoji: "🥧", name: "pie", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["pie"]) },
    Emoji { emoji: "🍫", name: "chocolate bar", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["chocolate_bar"]) },
    Emoji { emoji: "🍬", name: "candy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["candy"]) },
    Emoji { emoji: "🍭", name: "lollipop", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["lollipop"]) },
    Emoji { emoji: "🍮", name: "custard", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["custard"]) },
    Emoji { emoji: "🍯", name: "honey pot", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["honey_pot"]) },
    Emoji { emoji: "🍼", name: "baby bottle", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["baby_bottle"]) },
    Emoji { emoji: "🥛", name: "glass of milk", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["milk_glass"]) },
    Emoji { emoji: "☕", name: "hot beverage", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["coffee"]) },
    Emoji { emoji: "🫖", name: "teapot", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["teapot"]) },
    Emoji { emoji: "🍵", name: "teacup without handle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["tea"]) },
    Emoji { emoji: "🍶", name: "sake", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["sake"]) },
    Emoji { emoji: "🍾", name: "bottle with popping cork", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["champagne"]) },
    Emoji { emoji: "🍷", name: "wine glass", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["wine_glass"]) },
    Emoji { emoji: "🍸", name: "cocktail glass", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["cocktail"]) },
    Emoji { emoji: "🍹", name: "tropical drink", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["tropical_drink"]) },
    Emoji { emoji: "🍺", name: "beer mug", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["beer"]) },
    Emoji { emoji: "🍻", name: "clinking beer mugs", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["beers"]) },
    Emoji { emoji: "🥂", name: "clinking glasses", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["clinking_glasses"]) },
    Emoji { emoji: "🥃", name: "tumbler glass", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["tumbler_glass"]) },
    Emoji { emoji: "🫗", name: "pouring liquid", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["pouring_liquid"]) },
    Emoji { emoji: "🥤", name: "cup with straw", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["cup_with_straw"]) },
    Emoji { emoji: "🧋", name: "bubble tea", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["bubble_tea"]) },
    Emoji { emoji: "🧃", name: "beverage box", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["beverage_box"]) },
    Emoji { emoji: "🧉", name: "mate", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["mate"]) },
    Emoji { emoji: "🧊", name: "ice", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["ice_cube"]) },
    Emoji { emoji: "🥢", name: "chopsticks", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["chopsticks"]) },
    Emoji { emoji: "🍽️", name: "fork and knife with plate", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["plate_with_cutlery"]) },
    Emoji { emoji: "🍴", name: "fork and knife", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["fork_and_knife"]) },
    Emoji { emoji: "🥄", name: "spoon", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["spoon"]) },
    Emoji { emoji: "🔪", name: "kitchen knife", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["hocho", "knife"]) },
    Emoji { emoji: "🫙", name: "jar", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["jar"]) },
    Emoji { emoji: "🏺", name: "amphora", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::FoodAndDrink, skin_tone: None, shortcodes: Some(&["amphora"]) },
    Emoji { emoji: "🌍", name: "globe showing Europe-Africa", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["earth_africa"]) },
    Emoji { emoji: "🌎", name: "globe showing Americas", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["earth_americas"]) },
    Emoji { emoji: "🌏", name: "globe showing Asia-Australia", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["earth_asia"]) },
    Emoji { emoji: "🌐", name: "globe with meridians", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["globe_with_meridians"]) },
    Emoji { emoji: "🗺️", name: "world map", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["world_map"]) },
    Emoji { emoji: "🗾", name: "map of Japan", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["japan"]) },
    Emoji { emoji: "🧭", name: "compass", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["compass"]) },
    Emoji { emoji: "🏔️", name: "snow-capped mountain", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["mountain_snow"]) },
    Emoji { emoji: "⛰️", name: "mountain", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["mountain"]) },
    Emoji { emoji: "🌋", name: "volcano", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["volcano"]) },
    Emoji { emoji: "🗻", name: "mount fuji", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["mount_fuji"]) },
    Emoji { emoji: "🏕️", name: "camping", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["camping"]) },
    Emoji { emoji: "🏖️", name: "beach with umbrella", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["beach_umbrella"]) },
    Emoji { emoji: "🏜️", name: "desert", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["desert"]) },
    Emoji { emoji: "🏝️", name: "desert island", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["desert_island"]) },
    Emoji { emoji: "🏞️", name: "national park", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["national_park"]) },
    Emoji { emoji: "🏟️", name: "stadium", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["stadium"]) },
    Emoji { emoji: "🏛️", name: "classical building", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["classical_building"]) },
    Emoji { emoji: "🏗️", name: "building construction", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["building_construction"]) },
    Emoji { emoji: "🧱", name: "brick", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["bricks"]) },
    Emoji { emoji: "🪨", name: "rock", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["rock"]) },
    Emoji { emoji: "🪵", name: "wood", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["wood"]) },
    Emoji { emoji: "🛖", name: "hut", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["hut"]) },
    Emoji { emoji: "🏘️", name: "houses", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["houses"]) },
    Emoji { emoji: "🏚️", name: "derelict house", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["derelict_house"]) },
    Emoji { emoji: "🏠", name: "house", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["house"]) },
    Emoji { emoji: "🏡", name: "house with garden", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["house_with_garden"]) },
    Emoji { emoji: "🏢", name: "office building", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["office"]) },
    Emoji { emoji: "🏣", name: "Japanese post office", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["post_office"]) },
    Emoji { emoji: "🏤", name: "post office", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["european_post_office"]) },
    Emoji { emoji: "🏥", name: "hospital", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["hospital"]) },
    Emoji { emoji: "🏦", name: "bank", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["bank"]) },
    Emoji { emoji: "🏨", name: "hotel", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["hotel"]) },
    Emoji { emoji: "🏩", name: "love hotel", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["love_hotel"]) },
    Emoji { emoji: "🏪", name: "convenience store", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["convenience_store"]) },
    Emoji { emoji: "🏫", name: "school", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["school"]) },
    Emoji { emoji: "🏬", name: "department store", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["department_store"]) },
    Emoji { emoji: "🏭", name: "factory", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["factory"]) },
    Emoji { emoji: "🏯", name: "Japanese castle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["japanese_castle"]) },
    Emoji { emoji: "🏰", name: "castle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["european_castle"]) },
    Emoji { emoji: "💒", name: "wedding", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["wedding"]) },
    Emoji { emoji: "🗼", name: "Tokyo tower", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["tokyo_tower"]) },
    Emoji { emoji: "🗽", name: "Statue of Liberty", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["statue_of_liberty"]) },
    Emoji { emoji: "⛪", name: "church", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["church"]) },
    Emoji { emoji: "🕌", name: "mosque", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["mosque"]) },
    Emoji { emoji: "🛕", name: "hindu temple", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["hindu_temple"]) },
    Emoji { emoji: "🕍", name: "synagogue", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["synagogue"]) },
    Emoji { emoji: "⛩️", name: "shinto shrine", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["shinto_shrine"]) },
    Emoji { emoji: "🕋", name: "kaaba", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["kaaba"]) },
    Emoji { emoji: "⛲", name: "fountain", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["fountain"]) },
    Emoji { emoji: "⛺", name: "tent", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["tent"]) },
    Emoji { emoji: "🌁", name: "foggy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["foggy"]) },
    Emoji { emoji: "🌃", name: "night with stars", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["night_with_stars"]) },
    Emoji { emoji: "🏙️", name: "cityscape", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["cityscape"]) },
    Emoji { emoji: "🌄", name: "sunrise over mountains", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["sunrise_over_mountains"]) },
    Emoji { emoji: "🌅", name: "sunrise", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["sunrise"]) },
    Emoji { emoji: "🌆", name: "cityscape at dusk", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["city_sunset"]) },
    Emoji { emoji: "🌇", name: "sunset", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["city_sunrise"]) },
    Emoji { emoji: "🌉", name: "bridge at night", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["bridge_at_night"]) },
    Emoji { emoji: "♨️", name: "hot springs", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["hotsprings"]) },
    Emoji { emoji: "🎠", name: "carousel horse", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["carousel_horse"]) },
    Emoji { emoji: "🛝", name: "playground slide", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["playground_slide"]) },
    Emoji { emoji: "🎡", name: "ferris wheel", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["ferris_wheel"]) },
    Emoji { emoji: "🎢", name: "roller coaster", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["roller_coaster"]) },
    Emoji { emoji: "💈", name: "barber pole", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["barber"]) },
    Emoji { emoji: "🎪", name: "circus tent", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["circus_tent"]) },
    Emoji { emoji: "🚂", name: "locomotive", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["steam_locomotive"]) },
    Emoji { emoji: "🚃", name: "railway car", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["railway_car"]) },
    Emoji { emoji: "🚄", name: "high-speed train", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["bullettrain_side"]) },
    Emoji { emoji: "🚅", name: "bullet train", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["bullettrain_front"]) },
    Emoji { emoji: "🚆", name: "train", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["train2"]) },
    Emoji { emoji: "🚇", name: "metro", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["metro"]) },
    Emoji { emoji: "🚈", name: "light rail", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["light_rail"]) },
    Emoji { emoji: "🚉", name: "station", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["station"]) },
    Emoji { emoji: "🚊", name: "tram", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["tram"]) },
    Emoji { emoji: "🚝", name: "monorail", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["monorail"]) },
    Emoji { emoji: "🚞", name: "mountain railway", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["mountain_railway"]) },
    Emoji { emoji: "🚋", name: "tram car", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["train"]) },
    Emoji { emoji: "🚌", name: "bus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["bus"]) },
    Emoji { emoji: "🚍", name: "oncoming bus", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["oncoming_bus"]) },
    Emoji { emoji: "🚎", name: "trolleybus", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["trolleybus"]) },
    Emoji { emoji: "🚐", name: "minibus", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["minibus"]) },
    Emoji { emoji: "🚑", name: "ambulance", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["ambulance"]) },
    Emoji { emoji: "🚒", name: "fire engine", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["fire_engine"]) },
    Emoji { emoji: "🚓", name: "police car", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["police_car"]) },
    Emoji { emoji: "🚔", name: "oncoming police car", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["oncoming_police_car"]) },
    Emoji { emoji: "🚕", name: "taxi", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["taxi"]) },
    Emoji { emoji: "🚖", name: "oncoming taxi", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["oncoming_taxi"]) },
    Emoji { emoji: "🚗", name: "automobile", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["car", "red_car"]) },
    Emoji { emoji: "🚘", name: "oncoming automobile", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["oncoming_automobile"]) },
    Emoji { emoji: "🚙", name: "sport utility vehicle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["blue_car"]) },
    Emoji { emoji: "🛻", name: "pickup truck", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["pickup_truck"]) },
    Emoji { emoji: "🚚", name: "delivery truck", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["truck"]) },
    Emoji { emoji: "🚛", name: "articulated lorry", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["articulated_lorry"]) },
    Emoji { emoji: "🚜", name: "tractor", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["tractor"]) },
    Emoji { emoji: "🏎️", name: "racing car", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["racing_car"]) },
    Emoji { emoji: "🏍️", name: "motorcycle", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["motorcycle"]) },
    Emoji { emoji: "🛵", name: "motor scooter", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["motor_scooter"]) },
    Emoji { emoji: "🦽", name: "manual wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["manual_wheelchair"]) },
    Emoji { emoji: "🦼", name: "motorized wheelchair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["motorized_wheelchair"]) },
    Emoji { emoji: "🛺", name: "auto rickshaw", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["auto_rickshaw"]) },
    Emoji { emoji: "🚲", name: "bicycle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["bike"]) },
    Emoji { emoji: "🛴", name: "kick scooter", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["kick_scooter"]) },
    Emoji { emoji: "🛹", name: "skateboard", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["skateboard"]) },
    Emoji { emoji: "🛼", name: "roller skate", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["roller_skate"]) },
    Emoji { emoji: "🚏", name: "bus stop", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["busstop"]) },
    Emoji { emoji: "🛣️", name: "motorway", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["motorway"]) },
    Emoji { emoji: "🛤️", name: "railway track", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["railway_track"]) },
    Emoji { emoji: "🛢️", name: "oil drum", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["oil_drum"]) },
    Emoji { emoji: "⛽", name: "fuel pump", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["fuelpump"]) },
    Emoji { emoji: "🛞", name: "wheel", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["wheel"]) },
    Emoji { emoji: "🚨", name: "police car light", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["rotating_light"]) },
    Emoji { emoji: "🚥", name: "horizontal traffic light", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["traffic_light"]) },
    Emoji { emoji: "🚦", name: "vertical traffic light", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["vertical_traffic_light"]) },
    Emoji { emoji: "🛑", name: "stop sign", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["stop_sign"]) },
    Emoji { emoji: "🚧", name: "construction", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["construction"]) },
    Emoji { emoji: "⚓", name: "anchor", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["anchor"]) },
    Emoji { emoji: "🛟", name: "ring buoy", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["ring_buoy"]) },
    Emoji { emoji: "⛵", name: "sailboat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["boat", "sailboat"]) },
    Emoji { emoji: "🛶", name: "canoe", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["canoe"]) },
    Emoji { emoji: "🚤", name: "speedboat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["speedboat"]) },
    Emoji { emoji: "🛳️", name: "passenger ship", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["passenger_ship"]) },
    Emoji { emoji: "⛴️", name: "ferry", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["ferry"]) },
    Emoji { emoji: "🛥️", name: "motor boat", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["motor_boat"]) },
    Emoji { emoji: "🚢", name: "ship", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["ship"]) },
    Emoji { emoji: "✈️", name: "airplane", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["airplane"]) },
    Emoji { emoji: "🛩️", name: "small airplane", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["small_airplane"]) },
    Emoji { emoji: "🛫", name: "airplane departure", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["flight_departure"]) },
    Emoji { emoji: "🛬", name: "airplane arrival", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["flight_arrival"]) },
    Emoji { emoji: "🪂", name: "parachute", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["parachute"]) },
    Emoji { emoji: "💺", name: "seat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["seat"]) },
    Emoji { emoji: "🚁", name: "helicopter", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["helicopter"]) },
    Emoji { emoji: "🚟", name: "suspension railway", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["suspension_railway"]) },
    Emoji { emoji: "🚠", name: "mountain cableway", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["mountain_cableway"]) },
    Emoji { emoji: "🚡", name: "aerial tramway", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["aerial_tramway"]) },
    Emoji { emoji: "🛰️", name: "satellite", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["artificial_satellite"]) },
    Emoji { emoji: "🚀", name: "rocket", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["rocket"]) },
    Emoji { emoji: "🛸", name: "flying saucer", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["flying_saucer"]) },
    Emoji { emoji: "🛎️", name: "bellhop bell", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["bellhop_bell"]) },
    Emoji { emoji: "🧳", name: "luggage", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["luggage"]) },
    Emoji { emoji: "⌛", name: "hourglass done", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["hourglass"]) },
    Emoji { emoji: "⏳", name: "hourglass not done", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["hourglass_flowing_sand"]) },
    Emoji { emoji: "⌚", name: "watch", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["watch"]) },
    Emoji { emoji: "⏰", name: "alarm clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["alarm_clock"]) },
    Emoji { emoji: "⏱️", name: "stopwatch", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["stopwatch"]) },
    Emoji { emoji: "⏲️", name: "timer clock", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["timer_clock"]) },
    Emoji { emoji: "🕰️", name: "mantelpiece clock", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["mantelpiece_clock"]) },
    Emoji { emoji: "🕛", name: "twelve o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock12"]) },
    Emoji { emoji: "🕧", name: "twelve-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock1230"]) },
    Emoji { emoji: "🕐", name: "one o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock1"]) },
    Emoji { emoji: "🕜", name: "one-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock130"]) },
    Emoji { emoji: "🕑", name: "two o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock2"]) },
    Emoji { emoji: "🕝", name: "two-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock230"]) },
    Emoji { emoji: "🕒", name: "three o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock3"]) },
    Emoji { emoji: "🕞", name: "three-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock330"]) },
    Emoji { emoji: "🕓", name: "four o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock4"]) },
    Emoji { emoji: "🕟", name: "four-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock430"]) },
    Emoji { emoji: "🕔", name: "five o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock5"]) },
    Emoji { emoji: "🕠", name: "five-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock530"]) },
    Emoji { emoji: "🕕", name: "six o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock6"]) },
    Emoji { emoji: "🕡", name: "six-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock630"]) },
    Emoji { emoji: "🕖", name: "seven o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock7"]) },
    Emoji { emoji: "🕢", name: "seven-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock730"]) },
    Emoji { emoji: "🕗", name: "eight o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock8"]) },
    Emoji { emoji: "🕣", name: "eight-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock830"]) },
    Emoji { emoji: "🕘", name: "nine o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock9"]) },
    Emoji { emoji: "🕤", name: "nine-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock930"]) },
    Emoji { emoji: "🕙", name: "ten o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock10"]) },
    Emoji { emoji: "🕥", name: "ten-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock1030"]) },
    Emoji { emoji: "🕚", name: "eleven o’clock", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock11"]) },
    Emoji { emoji: "🕦", name: "eleven-thirty", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["clock1130"]) },
    Emoji { emoji: "🌑", name: "new moon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["new_moon"]) },
    Emoji { emoji: "🌒", name: "waxing crescent moon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["waxing_crescent_moon"]) },
    Emoji { emoji: "🌓", name: "first quarter moon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["first_quarter_moon"]) },
    Emoji { emoji: "🌔", name: "waxing gibbous moon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["moon", "waxing_gibbous_moon"]) },
    Emoji { emoji: "🌕", name: "full moon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["full_moon"]) },
    Emoji { emoji: "🌖", name: "waning gibbous moon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["waning_gibbous_moon"]) },
    Emoji { emoji: "🌗", name: "last quarter moon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["last_quarter_moon"]) },
    Emoji { emoji: "🌘", name: "waning crescent moon", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["waning_crescent_moon"]) },
    Emoji { emoji: "🌙", name: "crescent moon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["crescent_moon"]) },
    Emoji { emoji: "🌚", name: "new moon face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["new_moon_with_face"]) },
    Emoji { emoji: "🌛", name: "first quarter moon face", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["first_quarter_moon_with_face"]) },
    Emoji { emoji: "🌜", name: "last quarter moon face", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["last_quarter_moon_with_face"]) },
    Emoji { emoji: "🌡️", name: "thermometer", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["thermometer"]) },
    Emoji { emoji: "☀️", name: "sun", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["sunny"]) },
    Emoji { emoji: "🌝", name: "full moon face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["full_moon_with_face"]) },
    Emoji { emoji: "🌞", name: "sun with face", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["sun_with_face"]) },
    Emoji { emoji: "🪐", name: "ringed planet", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["ringed_planet"]) },
    Emoji { emoji: "⭐", name: "star", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["star"]) },
    Emoji { emoji: "🌟", name: "glowing star", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["star2"]) },
    Emoji { emoji: "🌠", name: "shooting star", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["stars"]) },
    Emoji { emoji: "🌌", name: "milky way", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["milky_way"]) },
    Emoji { emoji: "☁️", name: "cloud", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["cloud"]) },
    Emoji { emoji: "⛅", name: "sun behind cloud", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["partly_sunny"]) },
    Emoji { emoji: "⛈️", name: "cloud with lightning and rain", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["cloud_with_lightning_and_rain"]) },
    Emoji { emoji: "🌤️", name: "sun behind small cloud", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["sun_behind_small_cloud"]) },
    Emoji { emoji: "🌥️", name: "sun behind large cloud", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["sun_behind_large_cloud"]) },
    Emoji { emoji: "🌦️", name: "sun behind rain cloud", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["sun_behind_rain_cloud"]) },
    Emoji { emoji: "🌧️", name: "cloud with rain", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["cloud_with_rain"]) },
    Emoji { emoji: "🌨️", name: "cloud with snow", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["cloud_with_snow"]) },
    Emoji { emoji: "🌩️", name: "cloud with lightning", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["cloud_with_lightning"]) },
    Emoji { emoji: "🌪️", name: "tornado", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["tornado"]) },
    Emoji { emoji: "🌫️", name: "fog", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["fog"]) },
    Emoji { emoji: "🌬️", name: "wind face", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["wind_face"]) },
    Emoji { emoji: "🌀", name: "cyclone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["cyclone"]) },
    Emoji { emoji: "🌈", name: "rainbow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["rainbow"]) },
    Emoji { emoji: "🌂", name: "closed umbrella", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["closed_umbrella"]) },
    Emoji { emoji: "☂️", name: "umbrella", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["open_umbrella"]) },
    Emoji { emoji: "☔", name: "umbrella with rain drops", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["umbrella"]) },
    Emoji { emoji: "⛱️", name: "umbrella on ground", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["parasol_on_ground"]) },
    Emoji { emoji: "⚡", name: "high voltage", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["zap"]) },
    Emoji { emoji: "❄️", name: "snowflake", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["snowflake"]) },
    Emoji { emoji: "☃️", name: "snowman", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["snowman_with_snow"]) },
    Emoji { emoji: "⛄", name: "snowman without snow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["snowman"]) },
    Emoji { emoji: "☄️", name: "comet", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["comet"]) },
    Emoji { emoji: "🔥", name: "fire", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["fire"]) },
    Emoji { emoji: "💧", name: "droplet", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["droplet"]) },
    Emoji { emoji: "🌊", name: "water wave", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::TravelAndPlaces, skin_tone: None, shortcodes: Some(&["ocean"]) },
    Emoji { emoji: "🎃", name: "jack-o-lantern", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["jack_o_lantern"]) },
    Emoji { emoji: "🎄", name: "Christmas tree", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["christmas_tree"]) },
    Emoji { emoji: "🎆", name: "fireworks", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["fireworks"]) },
    Emoji { emoji: "🎇", name: "sparkler", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["sparkler"]) },
    Emoji { emoji: "🧨", name: "firecracker", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["firecracker"]) },
    Emoji { emoji: "✨", name: "sparkles", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["sparkles"]) },
    Emoji { emoji: "🎈", name: "balloon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["balloon"]) },
    Emoji { emoji: "🎉", name: "party popper", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["tada"]) },
    Emoji { emoji: "🎊", name: "confetti ball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["confetti_ball"]) },
    Emoji { emoji: "🎋", name: "tanabata tree", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["tanabata_tree"]) },
    Emoji { emoji: "🎍", name: "pine decoration", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["bamboo"]) },
    Emoji { emoji: "🎎", name: "Japanese dolls", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["dolls"]) },
    Emoji { emoji: "🎏", name: "carp streamer", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["flags"]) },
    Emoji { emoji: "🎐", name: "wind chime", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["wind_chime"]) },
    Emoji { emoji: "🎑", name: "moon viewing ceremony", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["rice_scene"]) },
    Emoji { emoji: "🧧", name: "red envelope", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["red_envelope"]) },
    Emoji { emoji: "🎀", name: "ribbon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["ribbon"]) },
    Emoji { emoji: "🎁", name: "wrapped gift", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["gift"]) },
    Emoji { emoji: "🎗️", name: "reminder ribbon", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["reminder_ribbon"]) },
    Emoji { emoji: "🎟️", name: "admission tickets", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["tickets"]) },
    Emoji { emoji: "🎫", name: "ticket", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["ticket"]) },
    Emoji { emoji: "🎖️", name: "military medal", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["medal_military"]) },
    Emoji { emoji: "🏆", name: "trophy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["trophy"]) },
    Emoji { emoji: "🏅", name: "sports medal", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["medal_sports"]) },
    Emoji { emoji: "🥇", name: "1st place medal", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["1st_place_medal"]) },
    Emoji { emoji: "🥈", name: "2nd place medal", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["2nd_place_medal"]) },
    Emoji { emoji: "🥉", name: "3rd place medal", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["3rd_place_medal"]) },
    Emoji { emoji: "⚽", name: "soccer ball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["soccer"]) },
    Emoji { emoji: "⚾", name: "baseball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["baseball"]) },
    Emoji { emoji: "🥎", name: "softball", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["softball"]) },
    Emoji { emoji: "🏀", name: "basketball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["basketball"]) },
    Emoji { emoji: "🏐", name: "volleyball", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["volleyball"]) },
    Emoji { emoji: "🏈", name: "american football", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["football"]) },
    Emoji { emoji: "🏉", name: "rugby football", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["rugby_football"]) },
    Emoji { emoji: "🎾", name: "tennis", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["tennis"]) },
    Emoji { emoji: "🥏", name: "flying disc", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["flying_disc"]) },
    Emoji { emoji: "🎳", name: "bowling", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["bowling"]) },
    Emoji { emoji: "🏏", name: "cricket game", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["cricket_game"]) },
    Emoji { emoji: "🏑", name: "field hockey", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["field_hockey"]) },
    Emoji { emoji: "🏒", name: "ice hockey", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["ice_hockey"]) },
    Emoji { emoji: "🥍", name: "lacrosse", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["lacrosse"]) },
    Emoji { emoji: "🏓", name: "ping pong", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["ping_pong"]) },
    Emoji { emoji: "🏸", name: "badminton", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["badminton"]) },
    Emoji { emoji: "🥊", name: "boxing glove", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["boxing_glove"]) },
    Emoji { emoji: "🥋", name: "martial arts uniform", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["martial_arts_uniform"]) },
    Emoji { emoji: "🥅", name: "goal net", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["goal_net"]) },
    Emoji { emoji: "⛳", name: "flag in hole", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["golf"]) },
    Emoji { emoji: "⛸️", name: "ice skate", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["ice_skate"]) },
    Emoji { emoji: "🎣", name: "fishing pole", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["fishing_pole_and_fish"]) },
    Emoji { emoji: "🤿", name: "diving mask", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["diving_mask"]) },
    Emoji { emoji: "🎽", name: "running shirt", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["running_shirt_with_sash"]) },
    Emoji { emoji: "🎿", name: "skis", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["ski"]) },
    Emoji { emoji: "🛷", name: "sled", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["sled"]) },
    Emoji { emoji: "🥌", name: "curling stone", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["curling_stone"]) },
    Emoji { emoji: "🎯", name: "bullseye", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["dart"]) },
    Emoji { emoji: "🪀", name: "yo-yo", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["yo_yo"]) },
    Emoji { emoji: "🪁", name: "kite", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["kite"]) },
    Emoji { emoji: "🔫", name: "water pistol", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["gun"]) },
    Emoji { emoji: "🎱", name: "pool 8 ball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["8ball"]) },
    Emoji { emoji: "🔮", name: "crystal ball", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["crystal_ball"]) },
    Emoji { emoji: "🪄", name: "magic wand", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["magic_wand"]) },
    Emoji { emoji: "🎮", name: "video game", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["video_game"]) },
    Emoji { emoji: "🕹️", name: "joystick", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["joystick"]) },
    Emoji { emoji: "🎰", name: "slot machine", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["slot_machine"]) },
    Emoji { emoji: "🎲", name: "game die", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["game_die"]) },
    Emoji { emoji: "🧩", name: "puzzle piece", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["jigsaw"]) },
    Emoji { emoji: "🧸", name: "teddy bear", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["teddy_bear"]) },
    Emoji { emoji: "🪅", name: "piñata", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["pinata"]) },
    Emoji { emoji: "🪩", name: "mirror ball", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["mirror_ball"]) },
    Emoji { emoji: "🪆", name: "nesting dolls", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["nesting_dolls"]) },
    Emoji { emoji: "♠️", name: "spade suit", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["spades"]) },
    Emoji { emoji: "♥️", name: "heart suit", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["hearts"]) },
    Emoji { emoji: "♦️", name: "diamond suit", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["diamonds"]) },
    Emoji { emoji: "♣️", name: "club suit", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["clubs"]) },
    Emoji { emoji: "♟️", name: "chess pawn", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["chess_pawn"]) },
    Emoji { emoji: "🃏", name: "joker", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["black_joker"]) },
    Emoji { emoji: "🀄", name: "mahjong red dragon", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["mahjong"]) },
    Emoji { emoji: "🎴", name: "flower playing cards", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["flower_playing_cards"]) },
    Emoji { emoji: "🎭", name: "performing arts", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["performing_arts"]) },
    Emoji { emoji: "🖼️", name: "framed picture", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["framed_picture"]) },
    Emoji { emoji: "🎨", name: "artist palette", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["art"]) },
    Emoji { emoji: "🧵", name: "thread", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["thread"]) },
    Emoji { emoji: "🪡", name: "sewing needle", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["sewing_needle"]) },
    Emoji { emoji: "🧶", name: "yarn", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["yarn"]) },
    Emoji { emoji: "🪢", name: "knot", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Activities, skin_tone: None, shortcodes: Some(&["knot"]) },
    Emoji { emoji: "👓", name: "glasses", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["eyeglasses"]) },
    Emoji { emoji: "🕶️", name: "sunglasses", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["dark_sunglasses"]) },
    Emoji { emoji: "🥽", name: "goggles", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["goggles"]) },
    Emoji { emoji: "🥼", name: "lab coat", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["lab_coat"]) },
    Emoji { emoji: "🦺", name: "safety vest", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["safety_vest"]) },
    Emoji { emoji: "👔", name: "necktie", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["necktie"]) },
    Emoji { emoji: "👕", name: "t-shirt", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["shirt", "tshirt"]) },
    Emoji { emoji: "👖", name: "jeans", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["jeans"]) },
    Emoji { emoji: "🧣", name: "scarf", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["scarf"]) },
    Emoji { emoji: "🧤", name: "gloves", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["gloves"]) },
    Emoji { emoji: "🧥", name: "coat", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["coat"]) },
    Emoji { emoji: "🧦", name: "socks", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["socks"]) },
    Emoji { emoji: "👗", name: "dress", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["dress"]) },
    Emoji { emoji: "👘", name: "kimono", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["kimono"]) },
    Emoji { emoji: "🥻", name: "sari", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["sari"]) },
    Emoji { emoji: "🩱", name: "one-piece swimsuit", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["one_piece_swimsuit"]) },
    Emoji { emoji: "🩲", name: "briefs", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["swim_brief"]) },
    Emoji { emoji: "🩳", name: "shorts", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["shorts"]) },
    Emoji { emoji: "👙", name: "bikini", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bikini"]) },
    Emoji { emoji: "👚", name: "woman’s clothes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["womans_clothes"]) },
    Emoji { emoji: "🪭", name: "folding hand fan", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["folding_hand_fan"]) },
    Emoji { emoji: "👛", name: "purse", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["purse"]) },
    Emoji { emoji: "👜", name: "handbag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["handbag"]) },
    Emoji { emoji: "👝", name: "clutch bag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["pouch"]) },
    Emoji { emoji: "🛍️", name: "shopping bags", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["shopping"]) },
    Emoji { emoji: "🎒", name: "backpack", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["school_satchel"]) },
    Emoji { emoji: "🩴", name: "thong sandal", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["thong_sandal"]) },
    Emoji { emoji: "👞", name: "man’s shoe", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mans_shoe", "shoe"]) },
    Emoji { emoji: "👟", name: "running shoe", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["athletic_shoe"]) },
    Emoji { emoji: "🥾", name: "hiking boot", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["hiking_boot"]) },
    Emoji { emoji: "🥿", name: "flat shoe", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["flat_shoe"]) },
    Emoji { emoji: "👠", name: "high-heeled shoe", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["high_heel"]) },
    Emoji { emoji: "👡", name: "woman’s sandal", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["sandal"]) },
    Emoji { emoji: "🩰", name: "ballet shoes", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["ballet_shoes"]) },
    Emoji { emoji: "👢", name: "woman’s boot", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["boot"]) },
    Emoji { emoji: "🪮", name: "hair pick", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["hair_pick"]) },
    Emoji { emoji: "👑", name: "crown", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["crown"]) },
    Emoji { emoji: "👒", name: "woman’s hat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["womans_hat"]) },
    Emoji { emoji: "🎩", name: "top hat", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["tophat"]) },
    Emoji { emoji: "🎓", name: "graduation cap", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mortar_board"]) },
    Emoji { emoji: "🧢", name: "billed cap", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["billed_cap"]) },
    Emoji { emoji: "🪖", name: "military helmet", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["military_helmet"]) },
    Emoji { emoji: "⛑️", name: "rescue worker’s helmet", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["rescue_worker_helmet"]) },
    Emoji { emoji: "📿", name: "prayer beads", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["prayer_beads"]) },
    Emoji { emoji: "💄", name: "lipstick", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["lipstick"]) },
    Emoji { emoji: "💍", name: "ring", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["ring"]) },
    Emoji { emoji: "💎", name: "gem stone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["gem"]) },
    Emoji { emoji: "🔇", name: "muted speaker", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mute"]) },
    Emoji { emoji: "🔈", name: "speaker low volume", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["speaker"]) },
    Emoji { emoji: "🔉", name: "speaker medium volume", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["sound"]) },
    Emoji { emoji: "🔊", name: "speaker high volume", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["loud_sound"]) },
    Emoji { emoji: "📢", name: "loudspeaker", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["loudspeaker"]) },
    Emoji { emoji: "📣", name: "megaphone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mega"]) },
    Emoji { emoji: "📯", name: "postal horn", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["postal_horn"]) },
    Emoji { emoji: "🔔", name: "bell", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bell"]) },
    Emoji { emoji: "🔕", name: "bell with slash", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["no_bell"]) },
    Emoji { emoji: "🎼", name: "musical score", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["musical_score"]) },
    Emoji { emoji: "🎵", name: "musical note", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["musical_note"]) },
    Emoji { emoji: "🎶", name: "musical notes", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["notes"]) },
    Emoji { emoji: "🎙️", name: "studio microphone", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["studio_microphone"]) },
    Emoji { emoji: "🎚️", name: "level slider", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["level_slider"]) },
    Emoji { emoji: "🎛️", name: "control knobs", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["control_knobs"]) },
    Emoji { emoji: "🎤", name: "microphone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["microphone"]) },
    Emoji { emoji: "🎧", name: "headphone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["headphones"]) },
    Emoji { emoji: "📻", name: "radio", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["radio"]) },
    Emoji { emoji: "🎷", name: "saxophone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["saxophone"]) },
    Emoji { emoji: "🪗", name: "accordion", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["accordion"]) },
    Emoji { emoji: "🎸", name: "guitar", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["guitar"]) },
    Emoji { emoji: "🎹", name: "musical keyboard", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["musical_keyboard"]) },
    Emoji { emoji: "🎺", name: "trumpet", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["trumpet"]) },
    Emoji { emoji: "🎻", name: "violin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["violin"]) },
    Emoji { emoji: "🪕", name: "banjo", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["banjo"]) },
    Emoji { emoji: "🥁", name: "drum", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["drum"]) },
    Emoji { emoji: "🪘", name: "long drum", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["long_drum"]) },
    Emoji { emoji: "🪇", name: "maracas", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["maracas"]) },
    Emoji { emoji: "🪈", name: "flute", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["flute"]) },
    Emoji { emoji: "🪉", name: "harp", unicode_version: UnicodeVersion { major: 16, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: None },
    Emoji { emoji: "📱", name: "mobile phone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["iphone"]) },
    Emoji { emoji: "📲", name: "mobile phone with arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["calling"]) },
    Emoji { emoji: "☎️", name: "telephone", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["phone", "telephone"]) },
    Emoji { emoji: "📞", name: "telephone receiver", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["telephone_receiver"]) },
    Emoji { emoji: "📟", name: "pager", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["pager"]) },
    Emoji { emoji: "📠", name: "fax machine", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["fax"]) },
    Emoji { emoji: "🔋", name: "battery", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["battery"]) },
    Emoji { emoji: "🪫", name: "low battery", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["low_battery"]) },
    Emoji { emoji: "🔌", name: "electric plug", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["electric_plug"]) },
    Emoji { emoji: "💻", name: "laptop", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["computer"]) },
    Emoji { emoji: "🖥️", name: "desktop computer", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["desktop_computer"]) },
    Emoji { emoji: "🖨️", name: "printer", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["printer"]) },
    Emoji { emoji: "⌨️", name: "keyboard", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["keyboard"]) },
    Emoji { emoji: "🖱️", name: "computer mouse", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["computer_mouse"]) },
    Emoji { emoji: "🖲️", name: "trackball", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["trackball"]) },
    Emoji { emoji: "💽", name: "computer disk", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["minidisc"]) },
    Emoji { emoji: "💾", name: "floppy disk", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["floppy_disk"]) },
    Emoji { emoji: "💿", name: "optical disk", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["cd"]) },
    Emoji { emoji: "📀", name: "dvd", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["dvd"]) },
    Emoji { emoji: "🧮", name: "abacus", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["abacus"]) },
    Emoji { emoji: "🎥", name: "movie camera", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["movie_camera"]) },
    Emoji { emoji: "🎞️", name: "film frames", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["film_strip"]) },
    Emoji { emoji: "📽️", name: "film projector", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["film_projector"]) },
    Emoji { emoji: "🎬", name: "clapper board", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["clapper"]) },
    Emoji { emoji: "📺", name: "television", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["tv"]) },
    Emoji { emoji: "📷", name: "camera", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["camera"]) },
    Emoji { emoji: "📸", name: "camera with flash", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["camera_flash"]) },
    Emoji { emoji: "📹", name: "video camera", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["video_camera"]) },
    Emoji { emoji: "📼", name: "videocassette", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["vhs"]) },
    Emoji { emoji: "🔍", name: "magnifying glass tilted left", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mag"]) },
    Emoji { emoji: "🔎", name: "magnifying glass tilted right", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mag_right"]) },
    Emoji { emoji: "🕯️", name: "candle", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["candle"]) },
    Emoji { emoji: "💡", name: "light bulb", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bulb"]) },
    Emoji { emoji: "🔦", name: "flashlight", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["flashlight"]) },
    Emoji { emoji: "🏮", name: "red paper lantern", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["izakaya_lantern", "lantern"]) },
    Emoji { emoji: "🪔", name: "diya lamp", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["diya_lamp"]) },
    Emoji { emoji: "📔", name: "notebook with decorative cover", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["notebook_with_decorative_cover"]) },
    Emoji { emoji: "📕", name: "closed book", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["closed_book"]) },
    Emoji { emoji: "📖", name: "open book", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["book", "open_book"]) },
    Emoji { emoji: "📗", name: "green book", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["green_book"]) },
    Emoji { emoji: "📘", name: "blue book", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["blue_book"]) },
    Emoji { emoji: "📙", name: "orange book", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["orange_book"]) },
    Emoji { emoji: "📚", name: "books", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["books"]) },
    Emoji { emoji: "📓", name: "notebook", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["notebook"]) },
    Emoji { emoji: "📒", name: "ledger", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["ledger"]) },
    Emoji { emoji: "📃", name: "page with curl", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["page_with_curl"]) },
    Emoji { emoji: "📜", name: "scroll", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["scroll"]) },
    Emoji { emoji: "📄", name: "page facing up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["page_facing_up"]) },
    Emoji { emoji: "📰", name: "newspaper", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["newspaper"]) },
    Emoji { emoji: "🗞️", name: "rolled-up newspaper", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["newspaper_roll"]) },
    Emoji { emoji: "📑", name: "bookmark tabs", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bookmark_tabs"]) },
    Emoji { emoji: "🔖", name: "bookmark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bookmark"]) },
    Emoji { emoji: "🏷️", name: "label", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["label"]) },
    Emoji { emoji: "💰", name: "money bag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["moneybag"]) },
    Emoji { emoji: "🪙", name: "coin", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["coin"]) },
    Emoji { emoji: "💴", name: "yen banknote", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["yen"]) },
    Emoji { emoji: "💵", name: "dollar banknote", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["dollar"]) },
    Emoji { emoji: "💶", name: "euro banknote", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["euro"]) },
    Emoji { emoji: "💷", name: "pound banknote", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["pound"]) },
    Emoji { emoji: "💸", name: "money with wings", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["money_with_wings"]) },
    Emoji { emoji: "💳", name: "credit card", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["credit_card"]) },
    Emoji { emoji: "🧾", name: "receipt", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["receipt"]) },
    Emoji { emoji: "💹", name: "chart increasing with yen", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["chart"]) },
    Emoji { emoji: "✉️", name: "envelope", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["envelope"]) },
    Emoji { emoji: "📧", name: "e-mail", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["email", "e-mail"]) },
    Emoji { emoji: "📨", name: "incoming envelope", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["incoming_envelope"]) },
    Emoji { emoji: "📩", name: "envelope with arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["envelope_with_arrow"]) },
    Emoji { emoji: "📤", name: "outbox tray", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["outbox_tray"]) },
    Emoji { emoji: "📥", name: "inbox tray", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["inbox_tray"]) },
    Emoji { emoji: "📦", name: "package", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["package"]) },
    Emoji { emoji: "📫", name: "closed mailbox with raised flag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mailbox"]) },
    Emoji { emoji: "📪", name: "closed mailbox with lowered flag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mailbox_closed"]) },
    Emoji { emoji: "📬", name: "open mailbox with raised flag", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mailbox_with_mail"]) },
    Emoji { emoji: "📭", name: "open mailbox with lowered flag", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mailbox_with_no_mail"]) },
    Emoji { emoji: "📮", name: "postbox", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["postbox"]) },
    Emoji { emoji: "🗳️", name: "ballot box with ballot", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["ballot_box"]) },
    Emoji { emoji: "✏️", name: "pencil", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["pencil2"]) },
    Emoji { emoji: "✒️", name: "black nib", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["black_nib"]) },
    Emoji { emoji: "🖋️", name: "fountain pen", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["fountain_pen"]) },
    Emoji { emoji: "🖊️", name: "pen", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["pen"]) },
    Emoji { emoji: "🖌️", name: "paintbrush", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["paintbrush"]) },
    Emoji { emoji: "🖍️", name: "crayon", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["crayon"]) },
    Emoji { emoji: "📝", name: "memo", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["memo", "pencil"]) },
    Emoji { emoji: "💼", name: "briefcase", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["briefcase"]) },
    Emoji { emoji: "📁", name: "file folder", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["file_folder"]) },
    Emoji { emoji: "📂", name: "open file folder", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["open_file_folder"]) },
    Emoji { emoji: "🗂️", name: "card index dividers", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["card_index_dividers"]) },
    Emoji { emoji: "📅", name: "calendar", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["date"]) },
    Emoji { emoji: "📆", name: "tear-off calendar", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["calendar"]) },
    Emoji { emoji: "🗒️", name: "spiral notepad", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["spiral_notepad"]) },
    Emoji { emoji: "🗓️", name: "spiral calendar", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["spiral_calendar"]) },
    Emoji { emoji: "📇", name: "card index", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["card_index"]) },
    Emoji { emoji: "📈", name: "chart increasing", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["chart_with_upwards_trend"]) },
    Emoji { emoji: "📉", name: "chart decreasing", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["chart_with_downwards_trend"]) },
    Emoji { emoji: "📊", name: "bar chart", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bar_chart"]) },
    Emoji { emoji: "📋", name: "clipboard", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["clipboard"]) },
    Emoji { emoji: "📌", name: "pushpin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["pushpin"]) },
    Emoji { emoji: "📍", name: "round pushpin", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["round_pushpin"]) },
    Emoji { emoji: "📎", name: "paperclip", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["paperclip"]) },
    Emoji { emoji: "🖇️", name: "linked paperclips", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["paperclips"]) },
    Emoji { emoji: "📏", name: "straight ruler", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["straight_ruler"]) },
    Emoji { emoji: "📐", name: "triangular ruler", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["triangular_ruler"]) },
    Emoji { emoji: "✂️", name: "scissors", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["scissors"]) },
    Emoji { emoji: "🗃️", name: "card file box", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["card_file_box"]) },
    Emoji { emoji: "🗄️", name: "file cabinet", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["file_cabinet"]) },
    Emoji { emoji: "🗑️", name: "wastebasket", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["wastebasket"]) },
    Emoji { emoji: "🔒", name: "locked", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["lock"]) },
    Emoji { emoji: "🔓", name: "unlocked", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["unlock"]) },
    Emoji { emoji: "🔏", name: "locked with pen", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["lock_with_ink_pen"]) },
    Emoji { emoji: "🔐", name: "locked with key", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["closed_lock_with_key"]) },
    Emoji { emoji: "🔑", name: "key", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["key"]) },
    Emoji { emoji: "🗝️", name: "old key", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["old_key"]) },
    Emoji { emoji: "🔨", name: "hammer", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["hammer"]) },
    Emoji { emoji: "🪓", name: "axe", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["axe"]) },
    Emoji { emoji: "⛏️", name: "pick", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["pick"]) },
    Emoji { emoji: "⚒️", name: "hammer and pick", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["hammer_and_pick"]) },
    Emoji { emoji: "🛠️", name: "hammer and wrench", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["hammer_and_wrench"]) },
    Emoji { emoji: "🗡️", name: "dagger", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["dagger"]) },
    Emoji { emoji: "⚔️", name: "crossed swords", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["crossed_swords"]) },
    Emoji { emoji: "💣", name: "bomb", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bomb"]) },
    Emoji { emoji: "🪃", name: "boomerang", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["boomerang"]) },
    Emoji { emoji: "🏹", name: "bow and arrow", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bow_and_arrow"]) },
    Emoji { emoji: "🛡️", name: "shield", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["shield"]) },
    Emoji { emoji: "🪚", name: "carpentry saw", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["carpentry_saw"]) },
    Emoji { emoji: "🔧", name: "wrench", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["wrench"]) },
    Emoji { emoji: "🪛", name: "screwdriver", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["screwdriver"]) },
    Emoji { emoji: "🔩", name: "nut and bolt", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["nut_and_bolt"]) },
    Emoji { emoji: "⚙️", name: "gear", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["gear"]) },
    Emoji { emoji: "🗜️", name: "clamp", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["clamp"]) },
    Emoji { emoji: "⚖️", name: "balance scale", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["balance_scale"]) },
    Emoji { emoji: "🦯", name: "white cane", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["probing_cane"]) },
    Emoji { emoji: "🔗", name: "link", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["link"]) },
    Emoji { emoji: "⛓️‍💥", name: "broken chain", unicode_version: UnicodeVersion { major: 15, minor: 1 }, group: Group::Objects, skin_tone: None, shortcodes: None },
    Emoji { emoji: "⛓️", name: "chains", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["chains"]) },
    Emoji { emoji: "🪝", name: "hook", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["hook"]) },
    Emoji { emoji: "🧰", name: "toolbox", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["toolbox"]) },
    Emoji { emoji: "🧲", name: "magnet", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["magnet"]) },
    Emoji { emoji: "🪜", name: "ladder", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["ladder"]) },
    Emoji { emoji: "🪏", name: "shovel", unicode_version: UnicodeVersion { major: 16, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: None },
    Emoji { emoji: "⚗️", name: "alembic", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["alembic"]) },
    Emoji { emoji: "🧪", name: "test tube", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["test_tube"]) },
    Emoji { emoji: "🧫", name: "petri dish", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["petri_dish"]) },
    Emoji { emoji: "🧬", name: "dna", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["dna"]) },
    Emoji { emoji: "🔬", name: "microscope", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["microscope"]) },
    Emoji { emoji: "🔭", name: "telescope", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["telescope"]) },
    Emoji { emoji: "📡", name: "satellite antenna", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["satellite"]) },
    Emoji { emoji: "💉", name: "syringe", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["syringe"]) },
    Emoji { emoji: "🩸", name: "drop of blood", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["drop_of_blood"]) },
    Emoji { emoji: "💊", name: "pill", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["pill"]) },
    Emoji { emoji: "🩹", name: "adhesive bandage", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["adhesive_bandage"]) },
    Emoji { emoji: "🩼", name: "crutch", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["crutch"]) },
    Emoji { emoji: "🩺", name: "stethoscope", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["stethoscope"]) },
    Emoji { emoji: "🩻", name: "x-ray", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["x_ray"]) },
    Emoji { emoji: "🚪", name: "door", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["door"]) },
    Emoji { emoji: "🛗", name: "elevator", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["elevator"]) },
    Emoji { emoji: "🪞", name: "mirror", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mirror"]) },
    Emoji { emoji: "🪟", name: "window", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["window"]) },
    Emoji { emoji: "🛏️", name: "bed", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bed"]) },
    Emoji { emoji: "🛋️", name: "couch and lamp", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["couch_and_lamp"]) },
    Emoji { emoji: "🪑", name: "chair", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["chair"]) },
    Emoji { emoji: "🚽", name: "toilet", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["toilet"]) },
    Emoji { emoji: "🪠", name: "plunger", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["plunger"]) },
    Emoji { emoji: "🚿", name: "shower", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["shower"]) },
    Emoji { emoji: "🛁", name: "bathtub", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bathtub"]) },
    Emoji { emoji: "🪤", name: "mouse trap", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["mouse_trap"]) },
    Emoji { emoji: "🪒", name: "razor", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["razor"]) },
    Emoji { emoji: "🧴", name: "lotion bottle", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["lotion_bottle"]) },
    Emoji { emoji: "🧷", name: "safety pin", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["safety_pin"]) },
    Emoji { emoji: "🧹", name: "broom", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["broom"]) },
    Emoji { emoji: "🧺", name: "basket", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["basket"]) },
    Emoji { emoji: "🧻", name: "roll of paper", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["roll_of_paper"]) },
    Emoji { emoji: "🪣", name: "bucket", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bucket"]) },
    Emoji { emoji: "🧼", name: "soap", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["soap"]) },
    Emoji { emoji: "🫧", name: "bubbles", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["bubbles"]) },
    Emoji { emoji: "🪥", name: "toothbrush", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["toothbrush"]) },
    Emoji { emoji: "🧽", name: "sponge", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["sponge"]) },
    Emoji { emoji: "🧯", name: "fire extinguisher", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["fire_extinguisher"]) },
    Emoji { emoji: "🛒", name: "shopping cart", unicode_version: UnicodeVersion { major: 3, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["shopping_cart"]) },
    Emoji { emoji: "🚬", name: "cigarette", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["smoking"]) },
    Emoji { emoji: "⚰️", name: "coffin", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["coffin"]) },
    Emoji { emoji: "🪦", name: "headstone", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["headstone"]) },
    Emoji { emoji: "⚱️", name: "funeral urn", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["funeral_urn"]) },
    Emoji { emoji: "🧿", name: "nazar amulet", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["nazar_amulet"]) },
    Emoji { emoji: "🪬", name: "hamsa", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["hamsa"]) },
    Emoji { emoji: "🗿", name: "moai", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["moyai"]) },
    Emoji { emoji: "🪧", name: "placard", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["placard"]) },
    Emoji { emoji: "🪪", name: "identification card", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Objects, skin_tone: None, shortcodes: Some(&["identification_card"]) },
    Emoji { emoji: "🏧", name: "ATM sign", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["atm"]) },
    Emoji { emoji: "🚮", name: "litter in bin sign", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["put_litter_in_its_place"]) },
    Emoji { emoji: "🚰", name: "potable water", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["potable_water"]) },
    Emoji { emoji: "♿", name: "wheelchair symbol", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["wheelchair"]) },
    Emoji { emoji: "🚹", name: "men’s room", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["mens"]) },
    Emoji { emoji: "🚺", name: "women’s room", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["womens"]) },
    Emoji { emoji: "🚻", name: "restroom", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["restroom"]) },
    Emoji { emoji: "🚼", name: "baby symbol", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["baby_symbol"]) },
    Emoji { emoji: "🚾", name: "water closet", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["wc"]) },
    Emoji { emoji: "🛂", name: "passport control", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["passport_control"]) },
    Emoji { emoji: "🛃", name: "customs", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["customs"]) },
    Emoji { emoji: "🛄", name: "baggage claim", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["baggage_claim"]) },
    Emoji { emoji: "🛅", name: "left luggage", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["left_luggage"]) },
    Emoji { emoji: "⚠️", name: "warning", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["warning"]) },
    Emoji { emoji: "🚸", name: "children crossing", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["children_crossing"]) },
    Emoji { emoji: "⛔", name: "no entry", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["no_entry"]) },
    Emoji { emoji: "🚫", name: "prohibited", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["no_entry_sign"]) },
    Emoji { emoji: "🚳", name: "no bicycles", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["no_bicycles"]) },
    Emoji { emoji: "🚭", name: "no smoking", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["no_smoking"]) },
    Emoji { emoji: "🚯", name: "no littering", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["do_not_litter"]) },
    Emoji { emoji: "🚱", name: "non-potable water", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["non-potable_water"]) },
    Emoji { emoji: "🚷", name: "no pedestrians", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["no_pedestrians"]) },
    Emoji { emoji: "📵", name: "no mobile phones", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["no_mobile_phones"]) },
    Emoji { emoji: "🔞", name: "no one under eighteen", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["underage"]) },
    Emoji { emoji: "☢️", name: "radioactive", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["radioactive"]) },
    Emoji { emoji: "☣️", name: "biohazard", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["biohazard"]) },
    Emoji { emoji: "⬆️", name: "up arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_up"]) },
    Emoji { emoji: "↗️", name: "up-right arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_upper_right"]) },
    Emoji { emoji: "➡️", name: "right arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_right"]) },
    Emoji { emoji: "↘️", name: "down-right arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_lower_right"]) },
    Emoji { emoji: "⬇️", name: "down arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_down"]) },
    Emoji { emoji: "↙️", name: "down-left arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_lower_left"]) },
    Emoji { emoji: "⬅️", name: "left arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_left"]) },
    Emoji { emoji: "↖️", name: "up-left arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_upper_left"]) },
    Emoji { emoji: "↕️", name: "up-down arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_up_down"]) },
    Emoji { emoji: "↔️", name: "left-right arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["left_right_arrow"]) },
    Emoji { emoji: "↩️", name: "right arrow curving left", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["leftwards_arrow_with_hook"]) },
    Emoji { emoji: "↪️", name: "left arrow curving right", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_right_hook"]) },
    Emoji { emoji: "⤴️", name: "right arrow curving up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_heading_up"]) },
    Emoji { emoji: "⤵️", name: "right arrow curving down", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_heading_down"]) },
    Emoji { emoji: "🔃", name: "clockwise vertical arrows", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrows_clockwise"]) },
    Emoji { emoji: "🔄", name: "counterclockwise arrows button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrows_counterclockwise"]) },
    Emoji { emoji: "🔙", name: "BACK arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["back"]) },
    Emoji { emoji: "🔚", name: "END arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["end"]) },
    Emoji { emoji: "🔛", name: "ON! arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["on"]) },
    Emoji { emoji: "🔜", name: "SOON arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["soon"]) },
    Emoji { emoji: "🔝", name: "TOP arrow", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["top"]) },
    Emoji { emoji: "🛐", name: "place of worship", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["place_of_worship"]) },
    Emoji { emoji: "⚛️", name: "atom symbol", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["atom_symbol"]) },
    Emoji { emoji: "🕉️", name: "om", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["om"]) },
    Emoji { emoji: "✡️", name: "star of David", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["star_of_david"]) },
    Emoji { emoji: "☸️", name: "wheel of dharma", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["wheel_of_dharma"]) },
    Emoji { emoji: "☯️", name: "yin yang", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["yin_yang"]) },
    Emoji { emoji: "✝️", name: "latin cross", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["latin_cross"]) },
    Emoji { emoji: "☦️", name: "orthodox cross", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["orthodox_cross"]) },
    Emoji { emoji: "☪️", name: "star and crescent", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["star_and_crescent"]) },
    Emoji { emoji: "☮️", name: "peace symbol", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["peace_symbol"]) },
    Emoji { emoji: "🕎", name: "menorah", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["menorah"]) },
    Emoji { emoji: "🔯", name: "dotted six-pointed star", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["six_pointed_star"]) },
    Emoji { emoji: "🪯", name: "khanda", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["khanda"]) },
    Emoji { emoji: "♈", name: "Aries", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["aries"]) },
    Emoji { emoji: "♉", name: "Taurus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["taurus"]) },
    Emoji { emoji: "♊", name: "Gemini", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["gemini"]) },
    Emoji { emoji: "♋", name: "Cancer", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["cancer"]) },
    Emoji { emoji: "♌", name: "Leo", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["leo"]) },
    Emoji { emoji: "♍", name: "Virgo", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["virgo"]) },
    Emoji { emoji: "♎", name: "Libra", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["libra"]) },
    Emoji { emoji: "♏", name: "Scorpio", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["scorpius"]) },
    Emoji { emoji: "♐", name: "Sagittarius", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["sagittarius"]) },
    Emoji { emoji: "♑", name: "Capricorn", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["capricorn"]) },
    Emoji { emoji: "♒", name: "Aquarius", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["aquarius"]) },
    Emoji { emoji: "♓", name: "Pisces", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["pisces"]) },
    Emoji { emoji: "⛎", name: "Ophiuchus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["ophiuchus"]) },
    Emoji { emoji: "🔀", name: "shuffle tracks button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["twisted_rightwards_arrows"]) },
    Emoji { emoji: "🔁", name: "repeat button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["repeat"]) },
    Emoji { emoji: "🔂", name: "repeat single button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["repeat_one"]) },
    Emoji { emoji: "▶️", name: "play button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_forward"]) },
    Emoji { emoji: "⏩", name: "fast-forward button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["fast_forward"]) },
    Emoji { emoji: "⏭️", name: "next track button", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["next_track_button"]) },
    Emoji { emoji: "⏯️", name: "play or pause button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["play_or_pause_button"]) },
    Emoji { emoji: "◀️", name: "reverse button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_backward"]) },
    Emoji { emoji: "⏪", name: "fast reverse button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["rewind"]) },
    Emoji { emoji: "⏮️", name: "last track button", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["previous_track_button"]) },
    Emoji { emoji: "🔼", name: "upwards button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_up_small"]) },
    Emoji { emoji: "⏫", name: "fast up button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_double_up"]) },
    Emoji { emoji: "🔽", name: "downwards button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_down_small"]) },
    Emoji { emoji: "⏬", name: "fast down button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["arrow_double_down"]) },
    Emoji { emoji: "⏸️", name: "pause button", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["pause_button"]) },
    Emoji { emoji: "⏹️", name: "stop button", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["stop_button"]) },
    Emoji { emoji: "⏺️", name: "record button", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["record_button"]) },
    Emoji { emoji: "⏏️", name: "eject button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["eject_button"]) },
    Emoji { emoji: "🎦", name: "cinema", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["cinema"]) },
    Emoji { emoji: "🔅", name: "dim button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["low_brightness"]) },
    Emoji { emoji: "🔆", name: "bright button", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["high_brightness"]) },
    Emoji { emoji: "📶", name: "antenna bars", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["signal_strength"]) },
    Emoji { emoji: "🛜", name: "wireless", unicode_version: UnicodeVersion { major: 15, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["wireless"]) },
    Emoji { emoji: "📳", name: "vibration mode", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["vibration_mode"]) },
    Emoji { emoji: "📴", name: "mobile phone off", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["mobile_phone_off"]) },
    Emoji { emoji: "♀️", name: "female sign", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["female_sign"]) },
    Emoji { emoji: "♂️", name: "male sign", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["male_sign"]) },
    Emoji { emoji: "⚧️", name: "transgender symbol", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["transgender_symbol"]) },
    Emoji { emoji: "✖️", name: "multiply", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["heavy_multiplication_x"]) },
    Emoji { emoji: "➕", name: "plus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["heavy_plus_sign"]) },
    Emoji { emoji: "➖", name: "minus", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["heavy_minus_sign"]) },
    Emoji { emoji: "➗", name: "divide", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["heavy_division_sign"]) },
    Emoji { emoji: "🟰", name: "heavy equals sign", unicode_version: UnicodeVersion { major: 14, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["heavy_equals_sign"]) },
    Emoji { emoji: "♾️", name: "infinity", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["infinity"]) },
    Emoji { emoji: "‼️", name: "double exclamation mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["bangbang"]) },
    Emoji { emoji: "⁉️", name: "exclamation question mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["interrobang"]) },
    Emoji { emoji: "❓", name: "red question mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["question"]) },
    Emoji { emoji: "❔", name: "white question mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["grey_question"]) },
    Emoji { emoji: "❕", name: "white exclamation mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["grey_exclamation"]) },
    Emoji { emoji: "❗", name: "red exclamation mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["exclamation", "heavy_exclamation_mark"]) },
    Emoji { emoji: "〰️", name: "wavy dash", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["wavy_dash"]) },
    Emoji { emoji: "💱", name: "currency exchange", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["currency_exchange"]) },
    Emoji { emoji: "💲", name: "heavy dollar sign", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["heavy_dollar_sign"]) },
    Emoji { emoji: "⚕️", name: "medical symbol", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["medical_symbol"]) },
    Emoji { emoji: "♻️", name: "recycling symbol", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["recycle"]) },
    Emoji { emoji: "⚜️", name: "fleur-de-lis", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["fleur_de_lis"]) },
    Emoji { emoji: "🔱", name: "trident emblem", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["trident"]) },
    Emoji { emoji: "📛", name: "name badge", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["name_badge"]) },
    Emoji { emoji: "🔰", name: "Japanese symbol for beginner", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["beginner"]) },
    Emoji { emoji: "⭕", name: "hollow red circle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["o"]) },
    Emoji { emoji: "✅", name: "check mark button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["white_check_mark"]) },
    Emoji { emoji: "☑️", name: "check box with check", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["ballot_box_with_check"]) },
    Emoji { emoji: "✔️", name: "check mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["heavy_check_mark"]) },
    Emoji { emoji: "❌", name: "cross mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["x"]) },
    Emoji { emoji: "❎", name: "cross mark button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["negative_squared_cross_mark"]) },
    Emoji { emoji: "➰", name: "curly loop", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["curly_loop"]) },
    Emoji { emoji: "➿", name: "double curly loop", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["loop"]) },
    Emoji { emoji: "〽️", name: "part alternation mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["part_alternation_mark"]) },
    Emoji { emoji: "✳️", name: "eight-spoked asterisk", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["eight_spoked_asterisk"]) },
    Emoji { emoji: "✴️", name: "eight-pointed star", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["eight_pointed_black_star"]) },
    Emoji { emoji: "❇️", name: "sparkle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["sparkle"]) },
    Emoji { emoji: "©️", name: "copyright", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["copyright"]) },
    Emoji { emoji: "®️", name: "registered", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["registered"]) },
    Emoji { emoji: "™️", name: "trade mark", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["tm"]) },
    Emoji { emoji: "🫟", name: "splatter", unicode_version: UnicodeVersion { major: 16, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: None },
    Emoji { emoji: "#️⃣", name: "keycap: #", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["hash"]) },
    Emoji { emoji: "*️⃣", name: "keycap: *", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["asterisk"]) },
    Emoji { emoji: "0️⃣", name: "keycap: 0", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["zero"]) },
    Emoji { emoji: "1️⃣", name: "keycap: 1", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["one"]) },
    Emoji { emoji: "2️⃣", name: "keycap: 2", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["two"]) },
    Emoji { emoji: "3️⃣", name: "keycap: 3", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["three"]) },
    Emoji { emoji: "4️⃣", name: "keycap: 4", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["four"]) },
    Emoji { emoji: "5️⃣", name: "keycap: 5", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["five"]) },
    Emoji { emoji: "6️⃣", name: "keycap: 6", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["six"]) },
    Emoji { emoji: "7️⃣", name: "keycap: 7", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["seven"]) },
    Emoji { emoji: "8️⃣", name: "keycap: 8", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["eight"]) },
    Emoji { emoji: "9️⃣", name: "keycap: 9", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["nine"]) },
    Emoji { emoji: "🔟", name: "keycap: 10", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["keycap_ten"]) },
    Emoji { emoji: "🔠", name: "input latin uppercase", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["capital_abcd"]) },
    Emoji { emoji: "🔡", name: "input latin lowercase", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["abcd"]) },
    Emoji { emoji: "🔢", name: "input numbers", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["1234"]) },
    Emoji { emoji: "🔣", name: "input symbols", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["symbols"]) },
    Emoji { emoji: "🔤", name: "input latin letters", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["abc"]) },
    Emoji { emoji: "🅰️", name: "A button (blood type)", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["a"]) },
    Emoji { emoji: "🆎", name: "AB button (blood type)", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["ab"]) },
    Emoji { emoji: "🅱️", name: "B button (blood type)", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["b"]) },
    Emoji { emoji: "🆑", name: "CL button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["cl"]) },
    Emoji { emoji: "🆒", name: "COOL button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["cool"]) },
    Emoji { emoji: "🆓", name: "FREE button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["free"]) },
    Emoji { emoji: "ℹ️", name: "information", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["information_source"]) },
    Emoji { emoji: "🆔", name: "ID button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["id"]) },
    Emoji { emoji: "Ⓜ️", name: "circled M", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["m"]) },
    Emoji { emoji: "🆕", name: "NEW button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["new"]) },
    Emoji { emoji: "🆖", name: "NG button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["ng"]) },
    Emoji { emoji: "🅾️", name: "O button (blood type)", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["o2"]) },
    Emoji { emoji: "🆗", name: "OK button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["ok"]) },
    Emoji { emoji: "🅿️", name: "P button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["parking"]) },
    Emoji { emoji: "🆘", name: "SOS button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["sos"]) },
    Emoji { emoji: "🆙", name: "UP! button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["up"]) },
    Emoji { emoji: "🆚", name: "VS button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["vs"]) },
    Emoji { emoji: "🈁", name: "Japanese “here” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["koko"]) },
    Emoji { emoji: "🈂️", name: "Japanese “service charge” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["sa"]) },
    Emoji { emoji: "🈷️", name: "Japanese “monthly amount” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["u6708"]) },
    Emoji { emoji: "🈶", name: "Japanese “not free of charge” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["u6709"]) },
    Emoji { emoji: "🈯", name: "Japanese “reserved” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["u6307"]) },
    Emoji { emoji: "🉐", name: "Japanese “bargain” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["ideograph_advantage"]) },
    Emoji { emoji: "🈹", name: "Japanese “discount” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["u5272"]) },
    Emoji { emoji: "🈚", name: "Japanese “free of charge” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["u7121"]) },
    Emoji { emoji: "🈲", name: "Japanese “prohibited” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["u7981"]) },
    Emoji { emoji: "🉑", name: "Japanese “acceptable” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["accept"]) },
    Emoji { emoji: "🈸", name: "Japanese “application” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["u7533"]) },
    Emoji { emoji: "🈴", name: "Japanese “passing grade” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["u5408"]) },
    Emoji { emoji: "🈳", name: "Japanese “vacancy” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["u7a7a"]) },
    Emoji { emoji: "㊗️", name: "Japanese “congratulations” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["congratulations"]) },
    Emoji { emoji: "㊙️", name: "Japanese “secret” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["secret"]) },
    Emoji { emoji: "🈺", name: "Japanese “open for business” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["u55b6"]) },
    Emoji { emoji: "🈵", name: "Japanese “no vacancy” button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["u6e80"]) },
    Emoji { emoji: "🔴", name: "red circle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["red_circle"]) },
    Emoji { emoji: "🟠", name: "orange circle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["orange_circle"]) },
    Emoji { emoji: "🟡", name: "yellow circle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["yellow_circle"]) },
    Emoji { emoji: "🟢", name: "green circle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["green_circle"]) },
    Emoji { emoji: "🔵", name: "blue circle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["large_blue_circle"]) },
    Emoji { emoji: "🟣", name: "purple circle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["purple_circle"]) },
    Emoji { emoji: "🟤", name: "brown circle", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["brown_circle"]) },
    Emoji { emoji: "⚫", name: "black circle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["black_circle"]) },
    Emoji { emoji: "⚪", name: "white circle", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["white_circle"]) },
    Emoji { emoji: "🟥", name: "red square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["red_square"]) },
    Emoji { emoji: "🟧", name: "orange square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["orange_square"]) },
    Emoji { emoji: "🟨", name: "yellow square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["yellow_square"]) },
    Emoji { emoji: "🟩", name: "green square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["green_square"]) },
    Emoji { emoji: "🟦", name: "blue square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["blue_square"]) },
    Emoji { emoji: "🟪", name: "purple square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["purple_square"]) },
    Emoji { emoji: "🟫", name: "brown square", unicode_version: UnicodeVersion { major: 12, minor: 0 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["brown_square"]) },
    Emoji { emoji: "⬛", name: "black large square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["black_large_square"]) },
    Emoji { emoji: "⬜", name: "white large square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["white_large_square"]) },
    Emoji { emoji: "◼️", name: "black medium square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["black_medium_square"]) },
    Emoji { emoji: "◻️", name: "white medium square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["white_medium_square"]) },
    Emoji { emoji: "◾", name: "black medium-small square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["black_medium_small_square"]) },
    Emoji { emoji: "◽", name: "white medium-small square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["white_medium_small_square"]) },
    Emoji { emoji: "▪️", name: "black small square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["black_small_square"]) },
    Emoji { emoji: "▫️", name: "white small square", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["white_small_square"]) },
    Emoji { emoji: "🔶", name: "large orange diamond", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["large_orange_diamond"]) },
    Emoji { emoji: "🔷", name: "large blue diamond", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["large_blue_diamond"]) },
    Emoji { emoji: "🔸", name: "small orange diamond", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["small_orange_diamond"]) },
    Emoji { emoji: "🔹", name: "small blue diamond", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["small_blue_diamond"]) },
    Emoji { emoji: "🔺", name: "red triangle pointed up", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["small_red_triangle"]) },
    Emoji { emoji: "🔻", name: "red triangle pointed down", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["small_red_triangle_down"]) },
    Emoji { emoji: "💠", name: "diamond with a dot", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["diamond_shape_with_a_dot_inside"]) },
    Emoji { emoji: "🔘", name: "radio button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["radio_button"]) },
    Emoji { emoji: "🔳", name: "white square button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["white_square_button"]) },
    Emoji { emoji: "🔲", name: "black square button", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Symbols, skin_tone: None, shortcodes: Some(&["black_square_button"]) },
    Emoji { emoji: "🏁", name: "chequered flag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["checkered_flag"]) },
    Emoji { emoji: "🚩", name: "triangular flag", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["triangular_flag_on_post"]) },
    Emoji { emoji: "🎌", name: "crossed flags", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["crossed_flags"]) },
    Emoji { emoji: "🏴", name: "black flag", unicode_version: UnicodeVersion { major: 1, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["black_flag"]) },
    Emoji { emoji: "🏳️", name: "white flag", unicode_version: UnicodeVersion { major: 0, minor: 7 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["white_flag"]) },
    Emoji { emoji: "🏳️‍🌈", name: "rainbow flag", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["rainbow_flag"]) },
    Emoji { emoji: "🏳️‍⚧️", name: "transgender flag", unicode_version: UnicodeVersion { major: 13, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["transgender_flag"]) },
    Emoji { emoji: "🏴‍☠️", name: "pirate flag", unicode_version: UnicodeVersion { major: 11, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["pirate_flag"]) },
    Emoji { emoji: "🇦🇨", name: "flag: Ascension Island", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["ascension_island"]) },
    Emoji { emoji: "🇦🇩", name: "flag: Andorra", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["andorra"]) },
    Emoji { emoji: "🇦🇪", name: "flag: United Arab Emirates", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["united_arab_emirates"]) },
    Emoji { emoji: "🇦🇫", name: "flag: Afghanistan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["afghanistan"]) },
    Emoji { emoji: "🇦🇬", name: "flag: Antigua & Barbuda", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["antigua_barbuda"]) },
    Emoji { emoji: "🇦🇮", name: "flag: Anguilla", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["anguilla"]) },
    Emoji { emoji: "🇦🇱", name: "flag: Albania", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["albania"]) },
    Emoji { emoji: "🇦🇲", name: "flag: Armenia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["armenia"]) },
    Emoji { emoji: "🇦🇴", name: "flag: Angola", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["angola"]) },
    Emoji { emoji: "🇦🇶", name: "flag: Antarctica", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["antarctica"]) },
    Emoji { emoji: "🇦🇷", name: "flag: Argentina", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["argentina"]) },
    Emoji { emoji: "🇦🇸", name: "flag: American Samoa", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["american_samoa"]) },
    Emoji { emoji: "🇦🇹", name: "flag: Austria", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["austria"]) },
    Emoji { emoji: "🇦🇺", name: "flag: Australia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["australia"]) },
    Emoji { emoji: "🇦🇼", name: "flag: Aruba", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["aruba"]) },
    Emoji { emoji: "🇦🇽", name: "flag: Åland Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["aland_islands"]) },
    Emoji { emoji: "🇦🇿", name: "flag: Azerbaijan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["azerbaijan"]) },
    Emoji { emoji: "🇧🇦", name: "flag: Bosnia & Herzegovina", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["bosnia_herzegovina"]) },
    Emoji { emoji: "🇧🇧", name: "flag: Barbados", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["barbados"]) },
    Emoji { emoji: "🇧🇩", name: "flag: Bangladesh", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["bangladesh"]) },
    Emoji { emoji: "🇧🇪", name: "flag: Belgium", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["belgium"]) },
    Emoji { emoji: "🇧🇫", name: "flag: Burkina Faso", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["burkina_faso"]) },
    Emoji { emoji: "🇧🇬", name: "flag: Bulgaria", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["bulgaria"]) },
    Emoji { emoji: "🇧🇭", name: "flag: Bahrain", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["bahrain"]) },
    Emoji { emoji: "🇧🇮", name: "flag: Burundi", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["burundi"]) },
    Emoji { emoji: "🇧🇯", name: "flag: Benin", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["benin"]) },
    Emoji { emoji: "🇧🇱", name: "flag: St. Barthélemy", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["st_barthelemy"]) },
    Emoji { emoji: "🇧🇲", name: "flag: Bermuda", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["bermuda"]) },
    Emoji { emoji: "🇧🇳", name: "flag: Brunei", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["brunei"]) },
    Emoji { emoji: "🇧🇴", name: "flag: Bolivia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["bolivia"]) },
    Emoji { emoji: "🇧🇶", name: "flag: Caribbean Netherlands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["caribbean_netherlands"]) },
    Emoji { emoji: "🇧🇷", name: "flag: Brazil", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["brazil"]) },
    Emoji { emoji: "🇧🇸", name: "flag: Bahamas", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["bahamas"]) },
    Emoji { emoji: "🇧🇹", name: "flag: Bhutan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["bhutan"]) },
    Emoji { emoji: "🇧🇻", name: "flag: Bouvet Island", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["bouvet_island"]) },
    Emoji { emoji: "🇧🇼", name: "flag: Botswana", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["botswana"]) },
    Emoji { emoji: "🇧🇾", name: "flag: Belarus", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["belarus"]) },
    Emoji { emoji: "🇧🇿", name: "flag: Belize", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["belize"]) },
    Emoji { emoji: "🇨🇦", name: "flag: Canada", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["canada"]) },
    Emoji { emoji: "🇨🇨", name: "flag: Cocos (Keeling) Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["cocos_islands"]) },
    Emoji { emoji: "🇨🇩", name: "flag: Congo - Kinshasa", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["congo_kinshasa"]) },
    Emoji { emoji: "🇨🇫", name: "flag: Central African Republic", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["central_african_republic"]) },
    Emoji { emoji: "🇨🇬", name: "flag: Congo - Brazzaville", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["congo_brazzaville"]) },
    Emoji { emoji: "🇨🇭", name: "flag: Switzerland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["switzerland"]) },
    Emoji { emoji: "🇨🇮", name: "flag: Côte d’Ivoire", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["cote_divoire"]) },
    Emoji { emoji: "🇨🇰", name: "flag: Cook Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["cook_islands"]) },
    Emoji { emoji: "🇨🇱", name: "flag: Chile", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["chile"]) },
    Emoji { emoji: "🇨🇲", name: "flag: Cameroon", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["cameroon"]) },
    Emoji { emoji: "🇨🇳", name: "flag: China", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["cn"]) },
    Emoji { emoji: "🇨🇴", name: "flag: Colombia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["colombia"]) },
    Emoji { emoji: "🇨🇵", name: "flag: Clipperton Island", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["clipperton_island"]) },
    Emoji { emoji: "🇨🇶", name: "flag: Sark", unicode_version: UnicodeVersion { major: 16, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: None },
    Emoji { emoji: "🇨🇷", name: "flag: Costa Rica", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["costa_rica"]) },
    Emoji { emoji: "🇨🇺", name: "flag: Cuba", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["cuba"]) },
    Emoji { emoji: "🇨🇻", name: "flag: Cape Verde", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["cape_verde"]) },
    Emoji { emoji: "🇨🇼", name: "flag: Curaçao", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["curacao"]) },
    Emoji { emoji: "🇨🇽", name: "flag: Christmas Island", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["christmas_island"]) },
    Emoji { emoji: "🇨🇾", name: "flag: Cyprus", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["cyprus"]) },
    Emoji { emoji: "🇨🇿", name: "flag: Czechia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["czech_republic"]) },
    Emoji { emoji: "🇩🇪", name: "flag: Germany", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["de"]) },
    Emoji { emoji: "🇩🇬", name: "flag: Diego Garcia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["diego_garcia"]) },
    Emoji { emoji: "🇩🇯", name: "flag: Djibouti", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["djibouti"]) },
    Emoji { emoji: "🇩🇰", name: "flag: Denmark", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["denmark"]) },
    Emoji { emoji: "🇩🇲", name: "flag: Dominica", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["dominica"]) },
    Emoji { emoji: "🇩🇴", name: "flag: Dominican Republic", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["dominican_republic"]) },
    Emoji { emoji: "🇩🇿", name: "flag: Algeria", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["algeria"]) },
    Emoji { emoji: "🇪🇦", name: "flag: Ceuta & Melilla", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["ceuta_melilla"]) },
    Emoji { emoji: "🇪🇨", name: "flag: Ecuador", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["ecuador"]) },
    Emoji { emoji: "🇪🇪", name: "flag: Estonia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["estonia"]) },
    Emoji { emoji: "🇪🇬", name: "flag: Egypt", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["egypt"]) },
    Emoji { emoji: "🇪🇭", name: "flag: Western Sahara", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["western_sahara"]) },
    Emoji { emoji: "🇪🇷", name: "flag: Eritrea", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["eritrea"]) },
    Emoji { emoji: "🇪🇸", name: "flag: Spain", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["es"]) },
    Emoji { emoji: "🇪🇹", name: "flag: Ethiopia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["ethiopia"]) },
    Emoji { emoji: "🇪🇺", name: "flag: European Union", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["eu", "european_union"]) },
    Emoji { emoji: "🇫🇮", name: "flag: Finland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["finland"]) },
    Emoji { emoji: "🇫🇯", name: "flag: Fiji", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["fiji"]) },
    Emoji { emoji: "🇫🇰", name: "flag: Falkland Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["falkland_islands"]) },
    Emoji { emoji: "🇫🇲", name: "flag: Micronesia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["micronesia"]) },
    Emoji { emoji: "🇫🇴", name: "flag: Faroe Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["faroe_islands"]) },
    Emoji { emoji: "🇫🇷", name: "flag: France", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["fr"]) },
    Emoji { emoji: "🇬🇦", name: "flag: Gabon", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["gabon"]) },
    Emoji { emoji: "🇬🇧", name: "flag: United Kingdom", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["gb", "uk"]) },
    Emoji { emoji: "🇬🇩", name: "flag: Grenada", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["grenada"]) },
    Emoji { emoji: "🇬🇪", name: "flag: Georgia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["georgia"]) },
    Emoji { emoji: "🇬🇫", name: "flag: French Guiana", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["french_guiana"]) },
    Emoji { emoji: "🇬🇬", name: "flag: Guernsey", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["guernsey"]) },
    Emoji { emoji: "🇬🇭", name: "flag: Ghana", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["ghana"]) },
    Emoji { emoji: "🇬🇮", name: "flag: Gibraltar", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["gibraltar"]) },
    Emoji { emoji: "🇬🇱", name: "flag: Greenland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["greenland"]) },
    Emoji { emoji: "🇬🇲", name: "flag: Gambia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["gambia"]) },
    Emoji { emoji: "🇬🇳", name: "flag: Guinea", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["guinea"]) },
    Emoji { emoji: "🇬🇵", name: "flag: Guadeloupe", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["guadeloupe"]) },
    Emoji { emoji: "🇬🇶", name: "flag: Equatorial Guinea", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["equatorial_guinea"]) },
    Emoji { emoji: "🇬🇷", name: "flag: Greece", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["greece"]) },
    Emoji { emoji: "🇬🇸", name: "flag: South Georgia & South Sandwich Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["south_georgia_south_sandwich_islands"]) },
    Emoji { emoji: "🇬🇹", name: "flag: Guatemala", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["guatemala"]) },
    Emoji { emoji: "🇬🇺", name: "flag: Guam", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["guam"]) },
    Emoji { emoji: "🇬🇼", name: "flag: Guinea-Bissau", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["guinea_bissau"]) },
    Emoji { emoji: "🇬🇾", name: "flag: Guyana", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["guyana"]) },
    Emoji { emoji: "🇭🇰", name: "flag: Hong Kong SAR China", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["hong_kong"]) },
    Emoji { emoji: "🇭🇲", name: "flag: Heard & McDonald Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["heard_mcdonald_islands"]) },
    Emoji { emoji: "🇭🇳", name: "flag: Honduras", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["honduras"]) },
    Emoji { emoji: "🇭🇷", name: "flag: Croatia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["croatia"]) },
    Emoji { emoji: "🇭🇹", name: "flag: Haiti", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["haiti"]) },
    Emoji { emoji: "🇭🇺", name: "flag: Hungary", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["hungary"]) },
    Emoji { emoji: "🇮🇨", name: "flag: Canary Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["canary_islands"]) },
    Emoji { emoji: "🇮🇩", name: "flag: Indonesia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["indonesia"]) },
    Emoji { emoji: "🇮🇪", name: "flag: Ireland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["ireland"]) },
    Emoji { emoji: "🇮🇱", name: "flag: Israel", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["israel"]) },
    Emoji { emoji: "🇮🇲", name: "flag: Isle of Man", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["isle_of_man"]) },
    Emoji { emoji: "🇮🇳", name: "flag: India", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["india"]) },
    Emoji { emoji: "🇮🇴", name: "flag: British Indian Ocean Territory", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["british_indian_ocean_territory"]) },
    Emoji { emoji: "🇮🇶", name: "flag: Iraq", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["iraq"]) },
    Emoji { emoji: "🇮🇷", name: "flag: Iran", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["iran"]) },
    Emoji { emoji: "🇮🇸", name: "flag: Iceland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["iceland"]) },
    Emoji { emoji: "🇮🇹", name: "flag: Italy", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["it"]) },
    Emoji { emoji: "🇯🇪", name: "flag: Jersey", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["jersey"]) },
    Emoji { emoji: "🇯🇲", name: "flag: Jamaica", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["jamaica"]) },
    Emoji { emoji: "🇯🇴", name: "flag: Jordan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["jordan"]) },
    Emoji { emoji: "🇯🇵", name: "flag: Japan", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["jp"]) },
    Emoji { emoji: "🇰🇪", name: "flag: Kenya", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["kenya"]) },
    Emoji { emoji: "🇰🇬", name: "flag: Kyrgyzstan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["kyrgyzstan"]) },
    Emoji { emoji: "🇰🇭", name: "flag: Cambodia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["cambodia"]) },
    Emoji { emoji: "🇰🇮", name: "flag: Kiribati", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["kiribati"]) },
    Emoji { emoji: "🇰🇲", name: "flag: Comoros", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["comoros"]) },
    Emoji { emoji: "🇰🇳", name: "flag: St. Kitts & Nevis", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["st_kitts_nevis"]) },
    Emoji { emoji: "🇰🇵", name: "flag: North Korea", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["north_korea"]) },
    Emoji { emoji: "🇰🇷", name: "flag: South Korea", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["kr"]) },
    Emoji { emoji: "🇰🇼", name: "flag: Kuwait", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["kuwait"]) },
    Emoji { emoji: "🇰🇾", name: "flag: Cayman Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["cayman_islands"]) },
    Emoji { emoji: "🇰🇿", name: "flag: Kazakhstan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["kazakhstan"]) },
    Emoji { emoji: "🇱🇦", name: "flag: Laos", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["laos"]) },
    Emoji { emoji: "🇱🇧", name: "flag: Lebanon", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["lebanon"]) },
    Emoji { emoji: "🇱🇨", name: "flag: St. Lucia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["st_lucia"]) },
    Emoji { emoji: "🇱🇮", name: "flag: Liechtenstein", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["liechtenstein"]) },
    Emoji { emoji: "🇱🇰", name: "flag: Sri Lanka", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["sri_lanka"]) },
    Emoji { emoji: "🇱🇷", name: "flag: Liberia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["liberia"]) },
    Emoji { emoji: "🇱🇸", name: "flag: Lesotho", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["lesotho"]) },
    Emoji { emoji: "🇱🇹", name: "flag: Lithuania", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["lithuania"]) },
    Emoji { emoji: "🇱🇺", name: "flag: Luxembourg", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["luxembourg"]) },
    Emoji { emoji: "🇱🇻", name: "flag: Latvia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["latvia"]) },
    Emoji { emoji: "🇱🇾", name: "flag: Libya", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["libya"]) },
    Emoji { emoji: "🇲🇦", name: "flag: Morocco", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["morocco"]) },
    Emoji { emoji: "🇲🇨", name: "flag: Monaco", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["monaco"]) },
    Emoji { emoji: "🇲🇩", name: "flag: Moldova", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["moldova"]) },
    Emoji { emoji: "🇲🇪", name: "flag: Montenegro", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["montenegro"]) },
    Emoji { emoji: "🇲🇫", name: "flag: St. Martin", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["st_martin"]) },
    Emoji { emoji: "🇲🇬", name: "flag: Madagascar", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["madagascar"]) },
    Emoji { emoji: "🇲🇭", name: "flag: Marshall Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["marshall_islands"]) },
    Emoji { emoji: "🇲🇰", name: "flag: North Macedonia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["macedonia"]) },
    Emoji { emoji: "🇲🇱", name: "flag: Mali", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["mali"]) },
    Emoji { emoji: "🇲🇲", name: "flag: Myanmar (Burma)", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["myanmar"]) },
    Emoji { emoji: "🇲🇳", name: "flag: Mongolia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["mongolia"]) },
    Emoji { emoji: "🇲🇴", name: "flag: Macao SAR China", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["macau"]) },
    Emoji { emoji: "🇲🇵", name: "flag: Northern Mariana Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["northern_mariana_islands"]) },
    Emoji { emoji: "🇲🇶", name: "flag: Martinique", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["martinique"]) },
    Emoji { emoji: "🇲🇷", name: "flag: Mauritania", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["mauritania"]) },
    Emoji { emoji: "🇲🇸", name: "flag: Montserrat", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["montserrat"]) },
    Emoji { emoji: "🇲🇹", name: "flag: Malta", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["malta"]) },
    Emoji { emoji: "🇲🇺", name: "flag: Mauritius", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["mauritius"]) },
    Emoji { emoji: "🇲🇻", name: "flag: Maldives", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["maldives"]) },
    Emoji { emoji: "🇲🇼", name: "flag: Malawi", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["malawi"]) },
    Emoji { emoji: "🇲🇽", name: "flag: Mexico", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["mexico"]) },
    Emoji { emoji: "🇲🇾", name: "flag: Malaysia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["malaysia"]) },
    Emoji { emoji: "🇲🇿", name: "flag: Mozambique", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["mozambique"]) },
    Emoji { emoji: "🇳🇦", name: "flag: Namibia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["namibia"]) },
    Emoji { emoji: "🇳🇨", name: "flag: New Caledonia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["new_caledonia"]) },
    Emoji { emoji: "🇳🇪", name: "flag: Niger", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["niger"]) },
    Emoji { emoji: "🇳🇫", name: "flag: Norfolk Island", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["norfolk_island"]) },
    Emoji { emoji: "🇳🇬", name: "flag: Nigeria", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["nigeria"]) },
    Emoji { emoji: "🇳🇮", name: "flag: Nicaragua", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["nicaragua"]) },
    Emoji { emoji: "🇳🇱", name: "flag: Netherlands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["netherlands"]) },
    Emoji { emoji: "🇳🇴", name: "flag: Norway", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["norway"]) },
    Emoji { emoji: "🇳🇵", name: "flag: Nepal", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["nepal"]) },
    Emoji { emoji: "🇳🇷", name: "flag: Nauru", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["nauru"]) },
    Emoji { emoji: "🇳🇺", name: "flag: Niue", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["niue"]) },
    Emoji { emoji: "🇳🇿", name: "flag: New Zealand", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["new_zealand"]) },
    Emoji { emoji: "🇴🇲", name: "flag: Oman", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["oman"]) },
    Emoji { emoji: "🇵🇦", name: "flag: Panama", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["panama"]) },
    Emoji { emoji: "🇵🇪", name: "flag: Peru", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["peru"]) },
    Emoji { emoji: "🇵🇫", name: "flag: French Polynesia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["french_polynesia"]) },
    Emoji { emoji: "🇵🇬", name: "flag: Papua New Guinea", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["papua_new_guinea"]) },
    Emoji { emoji: "🇵🇭", name: "flag: Philippines", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["philippines"]) },
    Emoji { emoji: "🇵🇰", name: "flag: Pakistan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["pakistan"]) },
    Emoji { emoji: "🇵🇱", name: "flag: Poland", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["poland"]) },
    Emoji { emoji: "🇵🇲", name: "flag: St. Pierre & Miquelon", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["st_pierre_miquelon"]) },
    Emoji { emoji: "🇵🇳", name: "flag: Pitcairn Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["pitcairn_islands"]) },
    Emoji { emoji: "🇵🇷", name: "flag: Puerto Rico", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["puerto_rico"]) },
    Emoji { emoji: "🇵🇸", name: "flag: Palestinian Territories", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["palestinian_territories"]) },
    Emoji { emoji: "🇵🇹", name: "flag: Portugal", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["portugal"]) },
    Emoji { emoji: "🇵🇼", name: "flag: Palau", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["palau"]) },
    Emoji { emoji: "🇵🇾", name: "flag: Paraguay", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["paraguay"]) },
    Emoji { emoji: "🇶🇦", name: "flag: Qatar", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["qatar"]) },
    Emoji { emoji: "🇷🇪", name: "flag: Réunion", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["reunion"]) },
    Emoji { emoji: "🇷🇴", name: "flag: Romania", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["romania"]) },
    Emoji { emoji: "🇷🇸", name: "flag: Serbia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["serbia"]) },
    Emoji { emoji: "🇷🇺", name: "flag: Russia", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["ru"]) },
    Emoji { emoji: "🇷🇼", name: "flag: Rwanda", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["rwanda"]) },
    Emoji { emoji: "🇸🇦", name: "flag: Saudi Arabia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["saudi_arabia"]) },
    Emoji { emoji: "🇸🇧", name: "flag: Solomon Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["solomon_islands"]) },
    Emoji { emoji: "🇸🇨", name: "flag: Seychelles", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["seychelles"]) },
    Emoji { emoji: "🇸🇩", name: "flag: Sudan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["sudan"]) },
    Emoji { emoji: "🇸🇪", name: "flag: Sweden", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["sweden"]) },
    Emoji { emoji: "🇸🇬", name: "flag: Singapore", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["singapore"]) },
    Emoji { emoji: "🇸🇭", name: "flag: St. Helena", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["st_helena"]) },
    Emoji { emoji: "🇸🇮", name: "flag: Slovenia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["slovenia"]) },
    Emoji { emoji: "🇸🇯", name: "flag: Svalbard & Jan Mayen", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["svalbard_jan_mayen"]) },
    Emoji { emoji: "🇸🇰", name: "flag: Slovakia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["slovakia"]) },
    Emoji { emoji: "🇸🇱", name: "flag: Sierra Leone", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["sierra_leone"]) },
    Emoji { emoji: "🇸🇲", name: "flag: San Marino", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["san_marino"]) },
    Emoji { emoji: "🇸🇳", name: "flag: Senegal", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["senegal"]) },
    Emoji { emoji: "🇸🇴", name: "flag: Somalia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["somalia"]) },
    Emoji { emoji: "🇸🇷", name: "flag: Suriname", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["suriname"]) },
    Emoji { emoji: "🇸🇸", name: "flag: South Sudan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["south_sudan"]) },
    Emoji { emoji: "🇸🇹", name: "flag: São Tomé & Príncipe", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["sao_tome_principe"]) },
    Emoji { emoji: "🇸🇻", name: "flag: El Salvador", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["el_salvador"]) },
    Emoji { emoji: "🇸🇽", name: "flag: Sint Maarten", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["sint_maarten"]) },
    Emoji { emoji: "🇸🇾", name: "flag: Syria", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["syria"]) },
    Emoji { emoji: "🇸🇿", name: "flag: Eswatini", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["swaziland"]) },
    Emoji { emoji: "🇹🇦", name: "flag: Tristan da Cunha", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["tristan_da_cunha"]) },
    Emoji { emoji: "🇹🇨", name: "flag: Turks & Caicos Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["turks_caicos_islands"]) },
    Emoji { emoji: "🇹🇩", name: "flag: Chad", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["chad"]) },
    Emoji { emoji: "🇹🇫", name: "flag: French Southern Territories", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["french_southern_territories"]) },
    Emoji { emoji: "🇹🇬", name: "flag: Togo", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["togo"]) },
    Emoji { emoji: "🇹🇭", name: "flag: Thailand", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["thailand"]) },
    Emoji { emoji: "🇹🇯", name: "flag: Tajikistan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["tajikistan"]) },
    Emoji { emoji: "🇹🇰", name: "flag: Tokelau", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["tokelau"]) },
    Emoji { emoji: "🇹🇱", name: "flag: Timor-Leste", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["timor_leste"]) },
    Emoji { emoji: "🇹🇲", name: "flag: Turkmenistan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["turkmenistan"]) },
    Emoji { emoji: "🇹🇳", name: "flag: Tunisia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["tunisia"]) },
    Emoji { emoji: "🇹🇴", name: "flag: Tonga", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["tonga"]) },
    Emoji { emoji: "🇹🇷", name: "flag: Türkiye", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["tr"]) },
    Emoji { emoji: "🇹🇹", name: "flag: Trinidad & Tobago", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["trinidad_tobago"]) },
    Emoji { emoji: "🇹🇻", name: "flag: Tuvalu", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["tuvalu"]) },
    Emoji { emoji: "🇹🇼", name: "flag: Taiwan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["taiwan"]) },
    Emoji { emoji: "🇹🇿", name: "flag: Tanzania", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["tanzania"]) },
    Emoji { emoji: "🇺🇦", name: "flag: Ukraine", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["ukraine"]) },
    Emoji { emoji: "🇺🇬", name: "flag: Uganda", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["uganda"]) },
    Emoji { emoji: "🇺🇲", name: "flag: U.S. Outlying Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["us_outlying_islands"]) },
    Emoji { emoji: "🇺🇳", name: "flag: United Nations", unicode_version: UnicodeVersion { major: 4, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["united_nations"]) },
    Emoji { emoji: "🇺🇸", name: "flag: United States", unicode_version: UnicodeVersion { major: 0, minor: 6 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["us"]) },
    Emoji { emoji: "🇺🇾", name: "flag: Uruguay", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["uruguay"]) },
    Emoji { emoji: "🇺🇿", name: "flag: Uzbekistan", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["uzbekistan"]) },
    Emoji { emoji: "🇻🇦", name: "flag: Vatican City", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["vatican_city"]) },
    Emoji { emoji: "🇻🇨", name: "flag: St. Vincent & Grenadines", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["st_vincent_grenadines"]) },
    Emoji { emoji: "🇻🇪", name: "flag: Venezuela", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["venezuela"]) },
    Emoji { emoji: "🇻🇬", name: "flag: British Virgin Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["british_virgin_islands"]) },
    Emoji { emoji: "🇻🇮", name: "flag: U.S. Virgin Islands", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["us_virgin_islands"]) },
    Emoji { emoji: "🇻🇳", name: "flag: Vietnam", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["vietnam"]) },
    Emoji { emoji: "🇻🇺", name: "flag: Vanuatu", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["vanuatu"]) },
    Emoji { emoji: "🇼🇫", name: "flag: Wallis & Futuna", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["wallis_futuna"]) },
    Emoji { emoji: "🇼🇸", name: "flag: Samoa", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["samoa"]) },
    Emoji { emoji: "🇽🇰", name: "flag: Kosovo", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["kosovo"]) },
    Emoji { emoji: "🇾🇪", name: "flag: Yemen", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["yemen"]) },
    Emoji { emoji: "🇾🇹", name: "flag: Mayotte", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["mayotte"]) },
    Emoji { emoji: "🇿🇦", name: "flag: South Africa", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["south_africa"]) },
    Emoji { emoji: "🇿🇲", name: "flag: Zambia", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["zambia"]) },
    Emoji { emoji: "🇿🇼", name: "flag: Zimbabwe", unicode_version: UnicodeVersion { major: 2, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["zimbabwe"]) },
    Emoji { emoji: "🏴󠁧󠁢󠁥󠁮󠁧󠁿", name: "flag: England", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["england"]) },
    Emoji { emoji: "🏴󠁧󠁢󠁳󠁣󠁴󠁿", name: "flag: Scotland", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["scotland"]) },
    Emoji { emoji: "🏴󠁧󠁢󠁷󠁬󠁳󠁿", name: "flag: Wales", unicode_version: UnicodeVersion { major: 5, minor: 0 }, group: Group::Flags, skin_tone: None, shortcodes: Some(&["wales"]) },
];
