/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jfrog.build.extractor.scan.GeneralInfo;
import org.jfrog.build.extractor.scan.Issue;
import org.jfrog.build.extractor.scan.License;
import org.jfrog.build.extractor.scan.Scope;

public class DependenciesTree
extends DefaultMutableTreeNode {
    private Set<Issue> issues = new HashSet<Issue>();
    private Set<License> licenses = new HashSet<License>();
    private Set<Scope> scopes = new HashSet<Scope>();
    private GeneralInfo generalInfo;
    private Issue topIssue = new Issue();

    public DependenciesTree() {
    }

    public DependenciesTree(Object userObject) {
        super(userObject);
    }

    public void setIssues(Set<Issue> issues) {
        this.issues = issues;
    }

    public void setLicenses(Set<License> licenses) {
        this.licenses = licenses;
    }

    public void setScopes(Set<Scope> scopes) {
        this.scopes = scopes;
    }

    public void setGeneralInfo(GeneralInfo generalInfo) {
        this.generalInfo = generalInfo;
    }

    public GeneralInfo getGeneralInfo() {
        return this.generalInfo;
    }

    public Set<Issue> getIssues() {
        return this.issues;
    }

    public Set<License> getLicenses() {
        return this.licenses;
    }

    public Set<Scope> getScopes() {
        return this.scopes;
    }

    public Issue getTopIssue() {
        return this.topIssue;
    }

    public int getIssueCount() {
        return this.issues.size();
    }

    public Vector<DependenciesTree> getChildren() {
        return this.children != null ? this.children : new Vector();
    }

    public Set<Issue> processTreeIssues() {
        this.setIssuesComponent();
        this.getChildren().forEach(child -> this.issues.addAll(child.processTreeIssues()));
        this.setTopIssue();
        this.sortChildren();
        return this.issues;
    }

    private void setIssuesComponent() {
        Object userObject = this.getUserObject();
        if (userObject != null) {
            this.issues.forEach(issue -> issue.setComponent(userObject.toString()));
        }
    }

    private void sortChildren() {
        this.getChildren().sort(Comparator.comparing(DependenciesTree::getTopIssue, Comparator.comparing(Issue::getSeverity)).thenComparing(DependenciesTree::getIssueCount).thenComparing(DefaultMutableTreeNode::getChildCount).reversed().thenComparing(DefaultMutableTreeNode::toString));
    }

    private void setTopIssue() {
        this.issues.forEach(issue -> {
            if (this.topIssue.isTopSeverity()) {
                return;
            }
            if (issue.isHigherSeverityThan(this.topIssue)) {
                this.topIssue = issue;
            }
        });
    }
}

