/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ru extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Среднее время по Гринвичу",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Акри стандартное время",
               "",
               "Акри летнее время",
               "",
               "Акри время",
               "",
            };
        final String[] Apia = new String[] {
               "Апиа, стандартное время",
               "",
               "Апиа, летнее время",
               "",
               "Апиа",
               "",
            };
        final String[] Cook = new String[] {
               "Острова Кука, стандартное время",
               "",
               "Острова Кука, полулетнее время",
               "",
               "Острова Кука",
               "",
            };
        final String[] Cuba = new String[] {
               "Куба, стандартное время",
               "CST",
               "Куба, летнее время",
               "CDT",
               "Куба",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Фиджи, стандартное время",
               "",
               "Фиджи, летнее время",
               "",
               "Фиджи",
               "",
            };
        final String[] Gulf = new String[] {
               "Персидский залив",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ховд, стандартное время",
               "",
               "Ховд, летнее время",
               "",
               "Ховд",
               "",
            };
        final String[] Iran = new String[] {
               "Иран, стандартное время",
               "",
               "Иран, летнее время",
               "",
               "Иран",
               "",
            };
        final String[] Niue = new String[] {
               "Ниуэ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Омск, стандартное время",
               "",
               "Омск, летнее время",
               "",
               "Омск",
               "",
            };
        final String[] Peru = new String[] {
               "Перу, стандартное время",
               "",
               "Перу, летнее время",
               "",
               "Перу",
               "",
            };
        final String[] Truk = new String[] {
               "Трук",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Уэйк",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Чили, стандартное время",
               "",
               "Чили, летнее время",
               "",
               "Чили",
               "",
            };
        final String[] China = new String[] {
               "Китай, стандартное время",
               "CST",
               "Китай, летнее время",
               "CDT",
               "Китай",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Кокосовые о-ва",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Дейвис",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Индия",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Япония, стандартное время",
               "JST",
               "Япония, летнее время",
               "JDT",
               "Япония",
               "JT",
            };
        final String[] Korea = new String[] {
               "Корея, стандартное время",
               "KST",
               "Корея, летнее время",
               "KST",
               "Корея",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Науру",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Непал",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Палау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Самоа, стандартное время",
               "SST",
               "Самоа, летнее время",
               "SST",
               "Самоа",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Сёва",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Тонга, стандартное время",
               "",
               "Тонга, летнее время",
               "",
               "Тонга",
               "",
            };
        final String[] Yukon = new String[] {
               "Юкон",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Аляска, стандартное время",
               "AKST",
               "Аляска, летнее время",
               "AKDT",
               "Аляска",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Амазонка, стандартное время",
               "",
               "Амазонка, летнее время",
               "",
               "Амазонка",
               "",
            };
        final String[] Azores = new String[] {
               "Азорские о-ва, стандартное время",
               "",
               "Азорские о-ва, летнее время",
               "",
               "Азорские о-ва",
               "",
            };
        final String[] Bhutan = new String[] {
               "Бутан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Бруней-Даруссалам",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "О-в Пасхи, стандартное время",
               "",
               "О-в Пасхи, летнее время",
               "",
               "О-в Пасхи",
               "",
            };
        final String[] Guyana = new String[] {
               "Гайана",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Гавайско-алеутское стандартное время",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Израиль, стандартное время",
               "IST",
               "Израиль, летнее время",
               "IDT",
               "Израиль",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Косрае",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Моусон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Москва, стандартное время",
               "MSK",
               "Москва, летнее время",
               "MSK",
               "Москва",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Понпеи",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Самарское стандартное время",
               "",
               "Самарское летнее время",
               "",
               "Время в Самаре",
               "",
            };
        final String[] Tahiti = new String[] {
               "Таити",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Тайвань, стандартное время",
               "CST",
               "Тайвань, летнее время",
               "CDT",
               "Тайвань",
               "CT",
            };
        final String[] Turkey = new String[] {
               "Турецкое стандартное время",
               "",
               "Турецкое летнее время",
               "",
               "Турецкое время",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Тувалу",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Восток",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Уоллис и Футуна",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Саудовская Аравия, стандартное время",
               "",
               "Саудовская Аравия, летнее время",
               "",
               "Саудовская Аравия",
               "",
            };
        final String[] Armenia = new String[] {
               "Армения, стандартное время",
               "",
               "Армения, летнее время",
               "",
               "Армения",
               "",
            };
        final String[] Bolivia = new String[] {
               "Боливия",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Чатем, стандартное время",
               "",
               "Чатем, летнее время",
               "",
               "Чатем",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Всемирное координированное время",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Эквадор",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Гамбье",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Грузия, стандартное время",
               "",
               "Грузия, летнее время",
               "",
               "Грузия",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Иркутск, стандартное время",
               "",
               "Иркутск, летнее время",
               "",
               "Иркутск",
               "",
            };
        final String[] Magadan = new String[] {
               "Магадан, стандартное время",
               "",
               "Магадан, летнее время",
               "",
               "Магадан",
               "",
            };
        final String[] Myanmar = new String[] {
               "Мьянма",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Норфолк, стандартное время",
               "",
               "Норфолк, летнее время",
               "",
               "Норфолк",
               "",
            };
        final String[] Noronha = new String[] {
               "Фернанду-ди-Норонья, стандартное время",
               "",
               "Фернанду-ди-Норонья, летнее время",
               "",
               "Фернанду-ди-Норонья",
               "",
            };
        final String[] Reunion = new String[] {
               "Реюньон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ротера",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Соломоновы Острова",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Токелау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Уругвай, стандартное время",
               "",
               "Уругвай, летнее время",
               "",
               "Уругвай",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Вануату, стандартное время",
               "",
               "Вануату, летнее время",
               "",
               "Вануату",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Якутск, стандартное время",
               "",
               "Якутск, летнее время",
               "",
               "Якутск",
               "",
            };
        final String[] Atlantic = new String[] {
               "Атлантическое стандартное время",
               "AST",
               "Атлантическое летнее время",
               "AST",
               "Атлантическое время",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Бразилия, стандартное время",
               "",
               "Бразилия, летнее время",
               "",
               "Бразилия",
               "",
            };
        final String[] Chamorro = new String[] {
               "Чаморро",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Колумбия, стандартное время",
               "",
               "Колумбия, летнее время",
               "",
               "Колумбия",
               "",
            };
        final String[] Falkland = new String[] {
               "Фолклендские о-ва, стандартное время",
               "",
               "Фолклендские о-ва, летнее время",
               "",
               "Фолклендские о-ва",
               "",
            };
        final String[] Malaysia = new String[] {
               "Малайзия",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Мальдивы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Улан-Батор, стандартное время",
               "",
               "Улан-Батор, летнее время",
               "",
               "Улан-Батор",
               "",
            };
        final String[] Pakistan = new String[] {
               "Пакистан, стандартное время",
               "PKT",
               "Пакистан, летнее время",
               "PKST",
               "Пакистан",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Парагвай, стандартное время",
               "",
               "Парагвай, летнее время",
               "",
               "Парагвай",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Питкэрн",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Суринам",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Аргентина, стандартное время",
               "",
               "Аргентина, летнее время",
               "",
               "Аргентина",
               "",
            };
        final String[] Christmas = new String[] {
               "о-в Рождества",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Галапагосские о-ва",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Гонконг, стандартное время",
               "HKT",
               "Гонконг, летнее время",
               "HKST",
               "Гонконг",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Индокитай",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Петропавловск-Камчатский, стандартное время",
               "",
               "Петропавловск-Камчатский, летнее время",
               "",
               "Петропавловск-Камчатский",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Киргизия",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Лорд-Хау, стандартное время",
               "",
               "Лорд-Хау, летнее время",
               "",
               "Лорд-Хау",
               "",
            };
        final String[] Marquesas = new String[] {
               "Маркизские о-ва",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Маврикий, стандартное время",
               "",
               "Маврикий, летнее время",
               "",
               "Маврикий",
               "",
            };
        final String[] Singapore = new String[] {
               "Сингапур",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Венесуэла",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Азербайджан, стандартное время",
               "",
               "Азербайджан, летнее время",
               "",
               "Азербайджан",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Бангладеш, стандартное время",
               "",
               "Бангладеш, летнее время",
               "",
               "Бангладеш",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Кабо-Верде, стандартное время",
               "",
               "Кабо-Верде, летнее время",
               "",
               "Кабо-Верде",
               "",
            };
        final String[] East_Timor = new String[] {
               "Восточный Тимор",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Казахстан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Сейшельские Острова",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Таджикистан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Узбекистан, стандартное время",
               "",
               "Узбекистан, летнее время",
               "",
               "Узбекистан",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Афганистан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Красноярск, стандартное время",
               "",
               "Красноярск, летнее время",
               "",
               "Красноярск",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Новая Зеландия, стандартное время",
               "NZST",
               "Новая Зеландия, летнее время",
               "NZDT",
               "Новая Зеландия",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Филиппины, стандартное время",
               "PST",
               "Филиппины, летнее время",
               "PDT",
               "Филиппины",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Владивосток, стандартное время",
               "",
               "Владивосток, летнее время",
               "",
               "Владивосток",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Индийский океан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "о-ва Лайн",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ньюфаундленд, стандартное время",
               "NST",
               "Ньюфаундленд, летнее время",
               "NDT",
               "Ньюфаундленд",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Туркменистан, стандартное время",
               "",
               "Туркменистан, летнее время",
               "",
               "Туркменистан",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Французская Гвиана",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Новая Каледония, стандартное время",
               "",
               "Новая Каледония, летнее время",
               "",
               "Новая Каледония",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Южная Георгия",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Екатеринбург, стандартное время",
               "",
               "Екатеринбург, летнее время",
               "",
               "Екатеринбург",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Центральная Африка",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Восточная Африка",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Западная Африка",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Дюмон-д’Юрвиль",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Центральная Европа, стандартное время",
               "CET",
               "Центральная Европа, летнее время",
               "CEST",
               "Центральная Европа",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Восточная Европа, стандартное время",
               "EET",
               "Восточная Европа, летнее время",
               "EEST",
               "Восточная Европа",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Западная Европа, стандартное время",
               "WET",
               "Западная Европа, летнее время",
               "WEST",
               "Западная Европа",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Тихоокеанское мексиканское стандартное время",
               "MST",
               "Тихоокеанское мексиканское летнее время",
               "MDT",
               "Тихоокеанское мексиканское время",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Южная Африка",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Центральная Америка, стандартное время",
               "CST",
               "Центральная Америка, летнее время",
               "CDT",
               "Центральная Америка",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Восточная Америка, стандартное время",
               "EST",
               "Восточная Америка, летнее время",
               "EST",
               "Восточная Америка",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Тихоокеанское стандартное время",
               "PST",
               "Тихоокеанское летнее время",
               "PDT",
               "Тихоокеанское время",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Французские Южные и Антарктические территории",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "о-ва Гилберта",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Гавайско-алеутское стандартное время",
               "HST",
               "Гавайско-алеутское летнее время",
               "HDT",
               "Гавайско-алеутское время",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "о-ва Феникс",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Сен-Пьер и Микелон, стандартное время",
               "",
               "Сен-Пьер и Микелон, летнее время",
               "",
               "Сен-Пьер и Микелон",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Стандартное горное время (Северная Америка)",
               "MST",
               "Летнее горное время (Северная Америка)",
               "MST",
               "Горное время (Северная Америка)",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Маршалловы Острова",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Папуа – Новая Гвинея",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Центральная Австралия, стандартное время",
               "ACST",
               "Центральная Австралия, летнее время",
               "ACDT",
               "Центральная Австралия",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Восточная Австралия, стандартное время",
               "AEST",
               "Восточная Австралия, летнее время",
               "AEDT",
               "Восточная Австралия",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Западная Австралия, стандартное время",
               "AWST",
               "Западная Австралия, летнее время",
               "AWDT",
               "Западная Австралия",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Центральная Индонезия",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Восточная Индонезия",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Западная Индонезия",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Центральная Австралия, западное стандартное время",
               "",
               "Центральная Австралия, западное летнее время",
               "",
               "Центральная Австралия, западное время",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Среднее время по Гринвичу",
                    "GMT",
                    "Великобритания, летнее время",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Всемирное координированное время",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Среднее время по Гринвичу",
                    "GMT",
                    "Ирландия, стандартное время",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Всемирное координированное время",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Всемирное координированное время",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Среднее время по Гринвичу",
                    "GMT",
                    "Великобритания, летнее время",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Всемирное координированное время",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Всемирное координированное время",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Всемирное координированное время",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Среднее время по Гринвичу",
                    "GMT",
                    "Ирландия, стандартное время",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Среднее время по Гринвичу",
                    "GMT",
                    "Великобритания, летнее время",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Среднее время по Гринвичу",
                    "GMT",
                    "Великобритания, летнее время",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Среднее время по Гринвичу",
                    "GMT",
                    "Великобритания, летнее время",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Среднее время по Гринвичу",
                    "GMT",
                    "Великобритания, летнее время",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Среднее время по Гринвичу",
                    "GMT",
                    "Великобритания, летнее время",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Аден" },
            { "timezone.excity.Asia/Baku", "Баку" },
            { "timezone.excity.Asia/Dili", "Дили" },
            { "timezone.excity.Asia/Gaza", "Газа" },
            { "timezone.excity.Asia/Hovd", "Ховд" },
            { "timezone.excity.Asia/Omsk", "Омск" },
            { "timezone.excity.Asia/Oral", "Уральск" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Амман" },
            { "timezone.excity.Asia/Aqtau", "Актау" },
            { "timezone.excity.Asia/Chita", "Чита" },
            { "timezone.excity.Asia/Dhaka", "Дакка" },
            { "timezone.excity.Asia/Dubai", "Дубай" },
            { "timezone.excity.Asia/Kabul", "Кабул" },
            { "timezone.excity.Asia/Macau", "Макао" },
            { "timezone.excity.Asia/Qatar", "Катар" },
            { "timezone.excity.Asia/Seoul", "Сеул" },
            { "timezone.excity.Asia/Tokyo", "Токио" },
            { "timezone.excity.Asia/Tomsk", "Томск" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Джуба" },
            { "timezone.excity.Africa/Lome", "Ломе" },
            { "timezone.excity.Asia/Almaty", "Алматы" },
            { "timezone.excity.Asia/Anadyr", "Анадырь" },
            { "timezone.excity.Asia/Aqtobe", "Актобе" },
            { "timezone.excity.Asia/Atyrau", "Атырау" },
            { "timezone.excity.Asia/Beirut", "Бейрут" },
            { "timezone.excity.Asia/Brunei", "Бруней" },
            { "timezone.excity.Asia/Hebron", "Хеврон" },
            { "timezone.excity.Asia/Kuwait", "Кувейт" },
            { "timezone.excity.Asia/Manila", "Манила" },
            { "timezone.excity.Asia/Muscat", "Маскат" },
            { "timezone.excity.Asia/Riyadh", "Эр-Рияд" },
            { "timezone.excity.Asia/Saigon", "Хошимин" },
            { "timezone.excity.Asia/Taipei", "Тайбэй" },
            { "timezone.excity.Asia/Tehran", "Тегеран" },
            { "timezone.excity.Asia/Urumqi", "Урумчи" },
            { "timezone.excity.Etc/Unknown", "Неизвестный город" },
            { "timezone.excity.Europe/Kiev", "Киев" },
            { "timezone.excity.Europe/Oslo", "Осло" },
            { "timezone.excity.Europe/Riga", "Рига" },
            { "timezone.excity.Europe/Rome", "Рим" },
            { "timezone.excity.Indian/Mahe", "Маэ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Аккра" },
            { "timezone.excity.Africa/Cairo", "Каир" },
            { "timezone.excity.Africa/Ceuta", "Сеута" },
            { "timezone.excity.Africa/Dakar", "Дакар" },
            { "timezone.excity.Africa/Lagos", "Лагос" },
            { "timezone.excity.Africa/Tunis", "Тунис" },
            { "timezone.excity.America/Adak", "Адак" },
            { "timezone.excity.America/Lima", "Лима" },
            { "timezone.excity.America/Nome", "Ном" },
            { "timezone.excity.Asia/Baghdad", "Багдад" },
            { "timezone.excity.Asia/Bahrain", "Бахрейн" },
            { "timezone.excity.Asia/Bangkok", "Бангкок" },
            { "timezone.excity.Asia/Barnaul", "Барнаул" },
            { "timezone.excity.Asia/Bishkek", "Бишкек" },
            { "timezone.excity.Asia/Colombo", "Коломбо" },
            { "timezone.excity.Asia/Irkutsk", "Иркутск" },
            { "timezone.excity.Asia/Jakarta", "Джакарта" },
            { "timezone.excity.Asia/Karachi", "Карачи" },
            { "timezone.excity.Asia/Kuching", "Кучинг" },
            { "timezone.excity.Asia/Magadan", "Магадан" },
            { "timezone.excity.Asia/Nicosia", "Никосия" },
            { "timezone.excity.Asia/Rangoon", "Янгон" },
            { "timezone.excity.Asia/Tbilisi", "Тбилиси" },
            { "timezone.excity.Asia/Thimphu", "Тхимпху" },
            { "timezone.excity.Asia/Yakutsk", "Якутск" },
            { "timezone.excity.Asia/Yerevan", "Ереван" },
            { "timezone.excity.Europe/Kirov", "Киров" },
            { "timezone.excity.Europe/Malta", "Мальта" },
            { "timezone.excity.Europe/Minsk", "Минск" },
            { "timezone.excity.Europe/Paris", "Париж" },
            { "timezone.excity.Europe/Sofia", "София" },
            { "timezone.excity.Europe/Vaduz", "Вадуц" },
            { "timezone.excity.Indian/Cocos", "Кокосовые о-ва" },
            { "timezone.excity.Pacific/Apia", "Апиа" },
            { "timezone.excity.Pacific/Fiji", "Фиджи" },
            { "timezone.excity.Pacific/Guam", "Гуам" },
            { "timezone.excity.Pacific/Niue", "Ниуэ" },
            { "timezone.excity.Pacific/Truk", "Трук" },
            { "timezone.excity.Pacific/Wake", "Уэйк" },
            { "timezone.excity.Africa/Asmera", "Асмэра" },
            { "timezone.excity.Africa/Bamako", "Бамако" },
            { "timezone.excity.Africa/Bangui", "Банги" },
            { "timezone.excity.Africa/Banjul", "Банжул" },
            { "timezone.excity.Africa/Bissau", "Бисау" },
            { "timezone.excity.Africa/Douala", "Дуала" },
            { "timezone.excity.Africa/Harare", "Хараре" },
            { "timezone.excity.Africa/Kigali", "Кигали" },
            { "timezone.excity.Africa/Luanda", "Луанда" },
            { "timezone.excity.Africa/Lusaka", "Лусака" },
            { "timezone.excity.Africa/Malabo", "Малабо" },
            { "timezone.excity.Africa/Maputo", "Мапуту" },
            { "timezone.excity.Africa/Maseru", "Масеру" },
            { "timezone.excity.Africa/Niamey", "Ниамей" },
            { "timezone.excity.America/Aruba", "Аруба" },
            { "timezone.excity.America/Bahia", "Баия" },
            { "timezone.excity.America/Belem", "Белен" },
            { "timezone.excity.America/Boise", "Бойсе" },
            { "timezone.excity.America/Jujuy", "Жужуй" },
            { "timezone.excity.America/Sitka", "Ситка" },
            { "timezone.excity.America/Thule", "Туле" },
            { "timezone.excity.Asia/Ashgabat", "Ашхабад" },
            { "timezone.excity.Asia/Calcutta", "Калькутта" },
            { "timezone.excity.Asia/Damascus", "Дамаск" },
            { "timezone.excity.Asia/Dushanbe", "Душанбе" },
            { "timezone.excity.Asia/Jayapura", "Джаяпура" },
            { "timezone.excity.Asia/Katmandu", "Катманду" },
            { "timezone.excity.Asia/Khandyga", "Хандыга" },
            { "timezone.excity.Asia/Makassar", "Макасар" },
            { "timezone.excity.Asia/Qostanay", "Костанай" },
            { "timezone.excity.Asia/Sakhalin", "о-в Сахалин" },
            { "timezone.excity.Asia/Shanghai", "Шанхай" },
            { "timezone.excity.Asia/Tashkent", "Ташкент" },
            { "timezone.excity.Asia/Ust-Nera", "Усть-Нера" },
            { "timezone.excity.Europe/Athens", "Афины" },
            { "timezone.excity.Europe/Berlin", "Берлин" },
            { "timezone.excity.Europe/Dublin", "Дублин" },
            { "timezone.excity.Europe/Jersey", "Джерси" },
            { "timezone.excity.Europe/Lisbon", "Лиссабон" },
            { "timezone.excity.Europe/London", "Лондон" },
            { "timezone.excity.Europe/Madrid", "Мадрид" },
            { "timezone.excity.Europe/Monaco", "Монако" },
            { "timezone.excity.Europe/Moscow", "Москва" },
            { "timezone.excity.Europe/Prague", "Прага" },
            { "timezone.excity.Europe/Samara", "Самара" },
            { "timezone.excity.Europe/Skopje", "Скопье" },
            { "timezone.excity.Europe/Tirane", "Тирана" },
            { "timezone.excity.Europe/Vienna", "Вена" },
            { "timezone.excity.Europe/Warsaw", "Варшава" },
            { "timezone.excity.Europe/Zagreb", "Загреб" },
            { "timezone.excity.Europe/Zurich", "Цюрих" },
            { "timezone.excity.Indian/Chagos", "Чагос" },
            { "timezone.excity.Indian/Comoro", "Коморы" },
            { "timezone.excity.Pacific/Efate", "Эфате" },
            { "timezone.excity.Pacific/Nauru", "Науру" },
            { "timezone.excity.Pacific/Palau", "Палау" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Абиджан" },
            { "timezone.excity.Africa/Algiers", "Алжир" },
            { "timezone.excity.Africa/Conakry", "Конакри" },
            { "timezone.excity.Africa/Kampala", "Кампала" },
            { "timezone.excity.Africa/Mbabane", "Мбабане" },
            { "timezone.excity.Africa/Nairobi", "Найроби" },
            { "timezone.excity.Africa/Tripoli", "Триполи" },
            { "timezone.excity.America/Belize", "Белиз" },
            { "timezone.excity.America/Bogota", "Богота" },
            { "timezone.excity.America/Cancun", "Канкун" },
            { "timezone.excity.America/Cayman", "Острова Кайман" },
            { "timezone.excity.America/Cuiaba", "Куяба" },
            { "timezone.excity.America/Dawson", "Доусон" },
            { "timezone.excity.America/Denver", "Денвер" },
            { "timezone.excity.America/Guyana", "Гайана" },
            { "timezone.excity.America/Havana", "Гавана" },
            { "timezone.excity.America/Inuvik", "Инувик" },
            { "timezone.excity.America/Juneau", "Джуно" },
            { "timezone.excity.America/La_Paz", "Ла-Пас" },
            { "timezone.excity.America/Maceio", "Масейо" },
            { "timezone.excity.America/Manaus", "Манаус" },
            { "timezone.excity.America/Merida", "Мерида" },
            { "timezone.excity.America/Nassau", "Нассау" },
            { "timezone.excity.America/Panama", "Панама" },
            { "timezone.excity.America/Recife", "Ресифи" },
            { "timezone.excity.America/Regina", "Реджайна" },
            { "timezone.excity.Asia/Famagusta", "Фамагуста" },
            { "timezone.excity.Asia/Hong_Kong", "Гонконг" },
            { "timezone.excity.Asia/Jerusalem", "Иерусалим" },
            { "timezone.excity.Asia/Kamchatka", "Петропавловск-Камчатский" },
            { "timezone.excity.Asia/Pontianak", "Понтианак" },
            { "timezone.excity.Asia/Pyongyang", "Пхеньян" },
            { "timezone.excity.Asia/Qyzylorda", "Кызылорда" },
            { "timezone.excity.Asia/Samarkand", "Самарканд" },
            { "timezone.excity.Asia/Singapore", "Сингапур" },
            { "timezone.excity.Asia/Vientiane", "Вьентьян" },
            { "timezone.excity.Europe/Andorra", "Андорра" },
            { "timezone.excity.Europe/Saratov", "Саратов" },
            { "timezone.excity.Europe/Tallinn", "Таллин" },
            { "timezone.excity.Europe/Vatican", "Ватикан" },
            { "timezone.excity.Europe/Vilnius", "Вильнюс" },
            { "timezone.excity.Indian/Mayotte", "Майотта" },
            { "timezone.excity.Indian/Reunion", "Реюньон" },
            { "timezone.excity.Pacific/Easter", "о-в Пасхи" },
            { "timezone.excity.Pacific/Kosrae", "Косрае" },
            { "timezone.excity.Pacific/Majuro", "Маджуро" },
            { "timezone.excity.Pacific/Midway", "о-ва Мидуэй" },
            { "timezone.excity.Pacific/Noumea", "Нумеа" },
            { "timezone.excity.Pacific/Ponape", "Понпеи" },
            { "timezone.excity.Pacific/Saipan", "Сайпан" },
            { "timezone.excity.Pacific/Tahiti", "Таити" },
            { "timezone.excity.Pacific/Tarawa", "Тарава" },
            { "timezone.excity.Pacific/Wallis", "Уоллис" },
            { "timezone.excity.Africa/Blantyre", "Блантайр" },
            { "timezone.excity.Africa/Djibouti", "Джибути" },
            { "timezone.excity.Africa/El_Aaiun", "Эль-Аюн" },
            { "timezone.excity.Africa/Freetown", "Фритаун" },
            { "timezone.excity.Africa/Gaborone", "Габороне" },
            { "timezone.excity.Africa/Khartoum", "Хартум" },
            { "timezone.excity.Africa/Kinshasa", "Киншаса" },
            { "timezone.excity.Africa/Monrovia", "Монровия" },
            { "timezone.excity.Africa/Ndjamena", "Нджамена" },
            { "timezone.excity.Africa/Sao_Tome", "Сан-Томе" },
            { "timezone.excity.Africa/Windhoek", "Виндхук" },
            { "timezone.excity.America/Antigua", "Антигуа" },
            { "timezone.excity.America/Caracas", "Каракас" },
            { "timezone.excity.America/Cayenne", "Кайенна" },
            { "timezone.excity.America/Chicago", "Чикаго" },
            { "timezone.excity.America/Cordoba", "Кордова" },
            { "timezone.excity.America/Creston", "Крестон" },
            { "timezone.excity.America/Curacao", "Кюрасао" },
            { "timezone.excity.America/Detroit", "Детройт" },
            { "timezone.excity.America/Godthab", "Нуук" },
            { "timezone.excity.America/Grenada", "Гренада" },
            { "timezone.excity.America/Halifax", "Галифакс" },
            { "timezone.excity.America/Iqaluit", "Икалуит" },
            { "timezone.excity.America/Jamaica", "Ямайка" },
            { "timezone.excity.America/Managua", "Манагуа" },
            { "timezone.excity.America/Marigot", "Мариго" },
            { "timezone.excity.America/Mendoza", "Мендоса" },
            { "timezone.excity.America/Moncton", "Монктон" },
            { "timezone.excity.America/Noronha", "Норонья" },
            { "timezone.excity.America/Ojinaga", "Охинага" },
            { "timezone.excity.America/Phoenix", "Финикс" },
            { "timezone.excity.America/Tijuana", "Тихуана" },
            { "timezone.excity.America/Toronto", "Торонто" },
            { "timezone.excity.America/Tortola", "Тортола" },
            { "timezone.excity.America/Yakutat", "Якутат" },
            { "timezone.excity.Asia/Phnom_Penh", "Пномпень" },
            { "timezone.excity.Atlantic/Azores", "Азорские о-ва" },
            { "timezone.excity.Atlantic/Canary", "Канарские о-ва" },
            { "timezone.excity.Atlantic/Faeroe", "Фарерские о-ва" },
            { "timezone.excity.Australia/Eucla", "Юкла" },
            { "timezone.excity.Australia/Perth", "Перт" },
            { "timezone.excity.Europe/Belgrade", "Белград" },
            { "timezone.excity.Europe/Brussels", "Брюссель" },
            { "timezone.excity.Europe/Budapest", "Будапешт" },
            { "timezone.excity.Europe/Busingen", "Бюзинген-на-Верхнем-Рейне" },
            { "timezone.excity.Europe/Chisinau", "Кишинев" },
            { "timezone.excity.Europe/Guernsey", "Гернси" },
            { "timezone.excity.Europe/Helsinki", "Хельсинки" },
            { "timezone.excity.Europe/Istanbul", "Стамбул" },
            { "timezone.excity.Europe/Sarajevo", "Сараево" },
            { "timezone.excity.Indian/Maldives", "Мальдивы" },
            { "timezone.excity.Pacific/Chatham", "Чатем" },
            { "timezone.excity.Pacific/Fakaofo", "Факаофо" },
            { "timezone.excity.Pacific/Gambier", "о-ва Гамбье" },
            { "timezone.excity.Pacific/Norfolk", "Норфолк" },
            { "timezone.excity.Africa/Bujumbura", "Бужумбура" },
            { "timezone.excity.Africa/Mogadishu", "Могадишо" },
            { "timezone.excity.America/Anguilla", "Ангилья" },
            { "timezone.excity.America/Asuncion", "Асунсьон" },
            { "timezone.excity.America/Barbados", "Барбадос" },
            { "timezone.excity.America/Dominica", "Доминика" },
            { "timezone.excity.America/Edmonton", "Эдмонтон" },
            { "timezone.excity.America/Eirunepe", "Эйрунепе" },
            { "timezone.excity.America/Mazatlan", "Масатлан" },
            { "timezone.excity.America/Miquelon", "Микелон" },
            { "timezone.excity.America/New_York", "Нью-Йорк" },
            { "timezone.excity.America/Resolute", "Резольют" },
            { "timezone.excity.America/Santarem", "Сантарен" },
            { "timezone.excity.America/Santiago", "Сантьяго" },
            { "timezone.excity.America/St_Johns", "Сент-Джонс" },
            { "timezone.excity.America/St_Kitts", "Сент-Китс" },
            { "timezone.excity.America/St_Lucia", "Сент-Люсия" },
            { "timezone.excity.America/Winnipeg", "Виннипег" },
            { "timezone.excity.Antarctica/Casey", "Кейси" },
            { "timezone.excity.Antarctica/Davis", "Дейвис" },
            { "timezone.excity.Antarctica/Syowa", "Сёва" },
            { "timezone.excity.Antarctica/Troll", "Тролль" },
            { "timezone.excity.Asia/Krasnoyarsk", "Красноярск" },
            { "timezone.excity.Asia/Novosibirsk", "Новосибирск" },
            { "timezone.excity.Asia/Ulaanbaatar", "Улан-Батор" },
            { "timezone.excity.Asia/Vladivostok", "Владивосток" },
            { "timezone.excity.Atlantic/Bermuda", "Бермудские о-ва" },
            { "timezone.excity.Atlantic/Madeira", "Мадейра" },
            { "timezone.excity.Atlantic/Stanley", "Стэнли" },
            { "timezone.excity.Australia/Darwin", "Дарвин" },
            { "timezone.excity.Australia/Hobart", "Хобарт" },
            { "timezone.excity.Australia/Sydney", "Сидней" },
            { "timezone.excity.Europe/Amsterdam", "Амстердам" },
            { "timezone.excity.Europe/Astrakhan", "Астрахань" },
            { "timezone.excity.Europe/Bucharest", "Бухарест" },
            { "timezone.excity.Europe/Gibraltar", "Гибралтар" },
            { "timezone.excity.Europe/Ljubljana", "Любляна" },
            { "timezone.excity.Europe/Mariehamn", "Мариехамн" },
            { "timezone.excity.Europe/Podgorica", "Подгорица" },
            { "timezone.excity.Europe/Stockholm", "Стокгольм" },
            { "timezone.excity.Europe/Ulyanovsk", "Ульяновск" },
            { "timezone.excity.Europe/Volgograd", "Волгоград" },
            { "timezone.excity.Indian/Christmas", "о-в Рождества" },
            { "timezone.excity.Indian/Kerguelen", "Кергелен" },
            { "timezone.excity.Indian/Mauritius", "Маврикий" },
            { "timezone.excity.Pacific/Auckland", "Окленд" },
            { "timezone.excity.Pacific/Funafuti", "Фунафути" },
            { "timezone.excity.Pacific/Honolulu", "Гонолулу" },
            { "timezone.excity.Pacific/Pitcairn", "Питкэрн" },
            { "timezone.excity.Africa/Casablanca", "Касабланка" },
            { "timezone.excity.Africa/Libreville", "Либревиль" },
            { "timezone.excity.Africa/Lubumbashi", "Лубумбаши" },
            { "timezone.excity.Africa/Nouakchott", "Нуакшот" },
            { "timezone.excity.Africa/Porto-Novo", "Порто-Ново" },
            { "timezone.excity.America/Anchorage", "Анкоридж" },
            { "timezone.excity.America/Araguaina", "Арагуаина" },
            { "timezone.excity.America/Boa_Vista", "Боа-Виста" },
            { "timezone.excity.America/Catamarca", "Катамарка" },
            { "timezone.excity.America/Chihuahua", "Чиуауа" },
            { "timezone.excity.America/Coyhaique", "Койайке" },
            { "timezone.excity.America/Fortaleza", "Форталеза" },
            { "timezone.excity.America/Glace_Bay", "Глейс-Бей" },
            { "timezone.excity.America/Goose_Bay", "Гус-Бей" },
            { "timezone.excity.America/Guatemala", "Гватемала" },
            { "timezone.excity.America/Guayaquil", "Гуаякиль" },
            { "timezone.excity.America/Matamoros", "Матаморос" },
            { "timezone.excity.America/Menominee", "Меномини" },
            { "timezone.excity.America/Monterrey", "Монтеррей" },
            { "timezone.excity.America/Sao_Paulo", "Сан-Паулу" },
            { "timezone.excity.America/St_Thomas", "Сент-Томас" },
            { "timezone.excity.America/Vancouver", "Ванкувер" },
            { "timezone.excity.Antarctica/Mawson", "Моусон" },
            { "timezone.excity.Antarctica/Palmer", "Палмер" },
            { "timezone.excity.Antarctica/Vostok", "Восток" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Куала-Лумпур" },
            { "timezone.excity.Asia/Novokuznetsk", "Новокузнецк" },
            { "timezone.excity.Europe/Bratislava", "Братислава" },
            { "timezone.excity.Europe/Copenhagen", "Копенгаген" },
            { "timezone.excity.Europe/Luxembourg", "Люксембург" },
            { "timezone.excity.Europe/San_Marino", "Сан-Марино" },
            { "timezone.excity.Europe/Simferopol", "Симферополь" },
            { "timezone.excity.Pacific/Enderbury", "о-в Кантон" },
            { "timezone.excity.Pacific/Galapagos", "Галапагосские о-ва" },
            { "timezone.excity.Pacific/Kwajalein", "Кваджалейн" },
            { "timezone.excity.Pacific/Marquesas", "Маркизские о-ва" },
            { "timezone.excity.Pacific/Pago_Pago", "Паго-Паго" },
            { "timezone.excity.Pacific/Rarotonga", "Раротонга" },
            { "timezone.excity.Pacific/Tongatapu", "Тонгатапу" },
            { "timezone.excity.Africa/Addis_Ababa", "Аддис-Абеба" },
            { "timezone.excity.Africa/Brazzaville", "Браззавиль" },
            { "timezone.excity.Africa/Ouagadougou", "Уагадугу" },
            { "timezone.excity.America/Costa_Rica", "Коста-Рика" },
            { "timezone.excity.America/Grand_Turk", "Гранд-Терк" },
            { "timezone.excity.America/Guadeloupe", "Гваделупа" },
            { "timezone.excity.America/Hermosillo", "Эрмосильо" },
            { "timezone.excity.America/Kralendijk", "Кралендейк" },
            { "timezone.excity.America/Louisville", "Луисвилл" },
            { "timezone.excity.America/Martinique", "Мартиника" },
            { "timezone.excity.America/Metlakatla", "Метлакатла" },
            { "timezone.excity.America/Montevideo", "Монтевидео" },
            { "timezone.excity.America/Montserrat", "Монтсеррат" },
            { "timezone.excity.America/Paramaribo", "Парамарибо" },
            { "timezone.excity.America/Rio_Branco", "Риу-Бранку" },
            { "timezone.excity.America/St_Vincent", "Сент-Винсент" },
            { "timezone.excity.America/Whitehorse", "Уайтхорс" },
            { "timezone.excity.Antarctica/McMurdo", "Мак-Мердо" },
            { "timezone.excity.Antarctica/Rothera", "Ротера" },
            { "timezone.excity.Asia/Srednekolymsk", "Среднеколымск" },
            { "timezone.excity.Asia/Yekaterinburg", "Екатеринбург" },
            { "timezone.excity.Atlantic/Reykjavik", "Рейкьявик" },
            { "timezone.excity.Atlantic/St_Helena", "о-в Святой Елены" },
            { "timezone.excity.Australia/Adelaide", "Аделаида" },
            { "timezone.excity.Australia/Brisbane", "Брисбен" },
            { "timezone.excity.Australia/Lindeman", "Линдеман" },
            { "timezone.excity.Europe/Isle_of_Man", "о-в Мэн" },
            { "timezone.excity.Europe/Kaliningrad", "Калининград" },
            { "timezone.excity.Pacific/Kiritimati", "Киритимати" },
            { "timezone.excity.Africa/Johannesburg", "Йоханнесбург" },
            { "timezone.excity.America/El_Salvador", "Сальвадор" },
            { "timezone.excity.America/Fort_Nelson", "Форт Нельсон" },
            { "timezone.excity.America/Los_Angeles", "Лос-Анджелес" },
            { "timezone.excity.America/Mexico_City", "Мехико" },
            { "timezone.excity.America/Porto_Velho", "Порту-Велью" },
            { "timezone.excity.America/Puerto_Rico", "Пуэрто-Рико" },
            { "timezone.excity.America/Tegucigalpa", "Тегусигальпа" },
            { "timezone.excity.Arctic/Longyearbyen", "Лонгйир" },
            { "timezone.excity.Atlantic/Cape_Verde", "Кабо-Верде" },
            { "timezone.excity.Australia/Lord_Howe", "Лорд-Хау" },
            { "timezone.excity.Australia/Melbourne", "Мельбурн" },
            { "timezone.excity.Indian/Antananarivo", "Антананариву" },
            { "timezone.excity.Pacific/Guadalcanal", "Гуадалканал" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Дар-эс-Салам" },
            { "timezone.excity.America/Blanc-Sablon", "Бланк-Саблон" },
            { "timezone.excity.America/Buenos_Aires", "Буэнос-Айрес" },
            { "timezone.excity.America/Campo_Grande", "Кампу-Гранди" },
            { "timezone.excity.America/Danmarkshavn", "Денмарксхавн" },
            { "timezone.excity.America/Dawson_Creek", "Доусон-Крик" },
            { "timezone.excity.America/Indiana/Knox", "Нокс, Индиана" },
            { "timezone.excity.America/Indianapolis", "Индианаполис" },
            { "timezone.excity.America/Punta_Arenas", "Пунта-Аренас" },
            { "timezone.excity.America/Rankin_Inlet", "Ранкин-Инлет" },
            { "timezone.excity.America/Scoresbysund", "Скорсбисунн" },
            { "timezone.excity.Antarctica/Macquarie", "Маккуори" },
            { "timezone.excity.Pacific/Bougainville", "Бугенвиль" },
            { "timezone.excity.Pacific/Port_Moresby", "Порт-Морсби" },
            { "timezone.excity.America/Cambridge_Bay", "Кеймбридж-Бей" },
            { "timezone.excity.America/Ciudad_Juarez", "Сьюдад-Хуарес" },
            { "timezone.excity.America/Coral_Harbour", "Корал-Харбор" },
            { "timezone.excity.America/Indiana/Vevay", "Вевей, Индиана" },
            { "timezone.excity.America/Lower_Princes", "Лоуэр-Принс-Куотер" },
            { "timezone.excity.America/Port_of_Spain", "Порт-оф-Спейн" },
            { "timezone.excity.America/Santo_Domingo", "Санто-Доминго" },
            { "timezone.excity.America/St_Barthelemy", "Сен-Бартелеми" },
            { "timezone.excity.America/Swift_Current", "Свифт-Керрент" },
            { "timezone.excity.Australia/Broken_Hill", "Брокен-Хилл" },
            { "timezone.excity.America/Bahia_Banderas", "Баия-де-Бандерас" },
            { "timezone.excity.America/Port-au-Prince", "Порт-о-Пренс" },
            { "timezone.excity.Atlantic/South_Georgia", "Южная Георгия" },
            { "timezone.excity.America/Argentina/Salta", "Сальта" },
            { "timezone.excity.America/Indiana/Marengo", "Маренго, Индиана" },
            { "timezone.excity.America/Indiana/Winamac", "Уинамак" },
            { "timezone.excity.America/Argentina/Tucuman", "Тукуман" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ушуая" },
            { "timezone.excity.America/Indiana/Tell_City", "Телл-Сити" },
            { "timezone.excity.America/Indiana/Vincennes", "Винсеннес" },
            { "timezone.excity.Antarctica/DumontDUrville", "Дюмон-д’Юрвиль" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ла-Риоха" },
            { "timezone.excity.America/Argentina/San_Juan", "Сан-Хуан" },
            { "timezone.excity.America/Argentina/San_Luis", "Сан-Луис" },
            { "timezone.excity.America/Indiana/Petersburg", "Питерсберг, Индиана" },
            { "timezone.excity.America/Kentucky/Monticello", "Монтиселло, Кентукки" },
            { "timezone.excity.America/North_Dakota/Beulah", "Бойла, Северная Дакота" },
            { "timezone.excity.America/North_Dakota/Center", "Центр, Северная Дакота" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Рио-Гальегос" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Нью-Сейлем, Северная Дакота" },
        };
        return data;
    }
}
