/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.mappers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.gson.JsonSyntaxException;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.ThreadingAssertions;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0007\"'\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"iterable", "", "", "", "getIterable", "(Ljava/util/Map;)Ljava/lang/Iterable;", "jsonToKubernetesObject", "Lio/kubernetes/client/common/KubernetesObject;", "obj", "Lcom/fasterxml/jackson/databind/JsonNode;", "yamlToKubernetesObject", "yamlText", "yamlReader", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "json", "Lio/kubernetes/client/openapi/JSON;", "jsonWriter", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesResourceMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,215:1\n1056#2:216\n1563#2:217\n1634#2,3:218\n13#3:221\n*S KotlinDebug\n*F\n+ 1 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapperKt\n*L\n187#1:216\n187#1:217\n187#1:218,3\n201#1:221\n*E\n"})
public final class KubernetesResourceMapperKt {
    @NotNull
    private static final ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
    @NotNull
    private static final JSON json = new JSON();
    @NotNull
    private static final ObjectMapper jsonWriter = new ObjectMapper();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Iterable<String> getIterable(@NotNull Map<String, String> $this$iterable) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$iterable, (String)"<this>");
        Iterable $this$sortedBy$iv = $this$iterable.entrySet();
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey() + ": " + it.getValue());
        }
        return (List)destination$iv$iv;
    }

    @ApiStatus.Internal
    @Nullable
    public static final KubernetesObject jsonToKubernetesObject(@NotNull JsonNode obj) {
        KubernetesObject kubernetesObject;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        ThreadingAssertions.assertBackgroundThread();
        ThreadingAssertions.assertNoReadAccess();
        if (obj.get("apiVersion") == null) {
            return null;
        }
        if (obj.get("metadata") == null) {
            return null;
        }
        String string = obj.get("kind").textValue();
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return null;
        }
        String kind = string;
        KubernetesResourceMapper<?, ?> kubernetesResourceMapper = KubernetesResourceMapper.Companion.find(arg_0 -> KubernetesResourceMapperKt.jsonToKubernetesObject$lambda$0(kind, arg_0));
        if (kubernetesResourceMapper == null) {
            return null;
        }
        KubernetesResourceMapper<?, ?> mapper = kubernetesResourceMapper;
        String jsonText = jsonWriter.writeValueAsString((Object)obj);
        try {
            kubernetesObject = (KubernetesObject)json.deserialize(jsonText, (Type)JvmClassMappingKt.getJavaClass(mapper.getResourceClass()));
        }
        catch (JsonSyntaxException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KubernetesResourceMapper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Failed to deserialize kubernetes object: " + e.getMessage());
            kubernetesObject = null;
        }
        return kubernetesObject;
    }

    @ApiStatus.Internal
    @Nullable
    public static final KubernetesObject yamlToKubernetesObject(@NotNull String yamlText) {
        Intrinsics.checkNotNullParameter((Object)yamlText, (String)"yamlText");
        Object object = yamlReader.readValue(yamlText, JsonNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        JsonNode obj = (JsonNode)object;
        return KubernetesResourceMapperKt.jsonToKubernetesObject(obj);
    }

    private static final boolean jsonToKubernetesObject$lambda$0(String $kind, KubernetesEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getKind(), (Object)$kind);
    }
}

