/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.layout.TextJustification;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Label;
import org.jetbrains.letsPlot.core.plot.base.render.svg.StrokeDashArraySupport;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBoxLayout;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBoxSpec;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH$J\b\u0010\u001c\u001a\u00020\u001dH\u0014J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u0004H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBox;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "()V", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "spec", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBoxSpec;", "getSpec", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBoxSpec;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "getTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "title", "", "getTitle", "()Ljava/lang/String;", "appendGuideContent", "contentRoot", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "buildComponent", "", "createTitleLabel", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Label;", "boundRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "titleSize", "justification", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "hasTitle", "Companion", "plot-builder"})
public abstract class LegendBox
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean debug;

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @NotNull
    public abstract LegendBoxSpec getSpec();

    @NotNull
    protected final LegendTheme getTheme() {
        return this.getSpec().getTheme();
    }

    private final String getTitle() {
        return this.getSpec().getTitle();
    }

    @NotNull
    public final DoubleVector getSize() {
        return this.getSpec().getSize();
    }

    private final boolean hasTitle() {
        return this.getSpec().hasTitle();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildComponent() {
        DoubleRectangle doubleRectangle;
        if (this.getTheme().showBackground()) {
            void $this$buildComponent_u24lambda_u240;
            SvgRectElement svgRectElement;
            SvgRectElement svgRectElement2 = svgRectElement = new SvgRectElement(this.getSpec().getInnerBounds());
            LegendBox legendBox = this;
            boolean bl = false;
            $this$buildComponent_u24lambda_u240.strokeColor().set(this.getTheme().backgroundColor());
            $this$buildComponent_u24lambda_u240.strokeWidth().set(this.getTheme().backgroundStrokeWidth());
            StrokeDashArraySupport.INSTANCE.apply((SvgShape)$this$buildComponent_u24lambda_u240, this.getTheme().backgroundStrokeWidth(), this.getTheme().backgroundLineType());
            $this$buildComponent_u24lambda_u240.fillColor().set(this.getTheme().backgroundFill());
            legendBox.add(svgRectElement);
        }
        SvgGElement innerGroup = new SvgGElement();
        innerGroup.transform().set(SvgComponent.Companion.buildTransform(this.getSpec().getContentOrigin(), 0.0));
        LegendBoxLayout l = this.getSpec().getLayout();
        LegendBox it = this;
        boolean bl = false;
        if (!this.hasTitle()) {
            doubleRectangle = DoubleRectangle.Companion.getZERO();
        } else {
            DoubleVector titleRectSize = l.isHorizontal() ? this.getSpec().getContentBounds().getDimension().subtract(new DoubleVector(l.getGraphSize().getX(), 0.0)) : new DoubleVector(this.getSpec().getContentBounds().getWidth(), l.getTitleSize$plot_builder().getY());
            doubleRectangle = new DoubleRectangle(DoubleVector.Companion.getZERO(), titleRectSize);
        }
        DoubleRectangle titleBoundingRect = doubleRectangle;
        if (this.hasTitle()) {
            Label label2 = this.createTitleLabel(titleBoundingRect, l.getTitleSize$plot_builder(), this.getTheme().titleJustification());
            innerGroup.children().add(label2.getRootGroup());
        }
        SvgGElement graphGroup = new SvgGElement();
        graphGroup.transform().set(SvgComponent.Companion.buildTransform(l.getGraphOrigin(), 0.0));
        this.appendGuideContent(graphGroup);
        innerGroup.children().add(graphGroup);
        if (this.debug) {
            DoubleRectangle outerBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), this.getSpec().getSize());
            this.add(Companion.createTransparentRect(outerBounds, Color.Companion.getCYAN(), 1.0));
            LegendBox $this$buildComponent_u24lambda_u242 = this;
            boolean bl2 = false;
            SvgRectElement rect2 = new SvgRectElement($this$buildComponent_u24lambda_u242.getSpec().getInnerBounds());
            rect2.fillColor().set(Color.Companion.getBLACK());
            rect2.strokeWidth().set(0.0);
            rect2.fillOpacity().set(0.1);
            $this$buildComponent_u24lambda_u242.add(rect2);
            this.add(Companion.createTransparentRect(this.getSpec().getContentBounds(), Color.Companion.getDARK_MAGENTA(), 1.0));
            DoubleRectangle rect3 = titleBoundingRect.add(this.getSpec().getContentOrigin());
            this.add(Companion.createTransparentRect(rect3, Color.Companion.getMAGENTA(), 1.0));
            if (this.getTheme().showTitle()) {
                DoubleVector textDimensions = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(this.getTitle(), PlotLabelSpecFactory.INSTANCE.legendTitle(this.getTheme()));
                double x2 = rect3.getLeft() + rect3.getWidth() * this.getTheme().titleJustification().getX() - (this.getTheme().titleJustification().getX() < 0.5 ? 0.0 : (this.getTheme().titleJustification().getX() == 0.5 ? textDimensions.getX() / (double)2 : textDimensions.getX()));
                DoubleRectangle titleBoundingBox = new DoubleRectangle(x2, rect3.getTop() + (rect3.getHeight() - textDimensions.getY()) * (1.0 - this.getTheme().titleJustification().getY()), textDimensions.getX(), textDimensions.getY());
                this.add(Companion.createTransparentRect(titleBoundingBox, Color.Companion.getDARK_GREEN(), 1.0));
            }
        }
        this.add(innerGroup);
    }

    @NotNull
    protected abstract DoubleVector appendGuideContent(@NotNull SvgNode var1);

    private final Label createTitleLabel(DoubleRectangle boundRect, DoubleVector titleSize, TextJustification justification) {
        double lineHeight = PlotLabelSpecFactory.INSTANCE.legendTitle(this.getTheme()).height();
        Label label2 = new Label(this.getTitle(), 0, false, 6, null);
        Pair pair2 = TextJustification.Companion.applyJustification$default(TextJustification.Companion, boundRect, titleSize, lineHeight, justification, null, 16, null);
        DoubleVector pos = (DoubleVector)pair2.component1();
        Text.HorizontalAnchor hAnchor = (Text.HorizontalAnchor)((Object)pair2.component2());
        label2.addClassName("legend-title");
        label2.setHorizontalAnchor(hAnchor);
        label2.setLineHeight(lineHeight);
        label2.moveTo(pos);
        return label2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBox$Companion;", "", "()V", "createTransparentRect", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgRectElement;", "bounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "strokeColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "strokeWidth", "", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgRectElement createTransparentRect(@NotNull DoubleRectangle bounds, @NotNull Color strokeColor, double strokeWidth) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            Intrinsics.checkNotNullParameter((Object)strokeColor, (String)"strokeColor");
            SvgRectElement rect2 = new SvgRectElement(bounds);
            rect2.strokeColor().set(strokeColor);
            rect2.strokeWidth().set(strokeWidth);
            rect2.fillOpacity().set(0.0);
            return rect2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

