/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.migration.DiffStatus;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u001a\u0010\u0015\u001a\f0\u0016\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J;\u0010\u001e\u001a\u00020\u0016\"\b\b\u0000\u0010\u001f*\u00020\u0007\"\u0004\b\u0001\u0010 2\b\u0010!\u001a\u0004\u0018\u0001H\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H 0\rH\u0002\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0013J\u001c\u0010%\u001a\u00020\u00052\b\u0010&\u001a\u0004\u0018\u00010\u001b2\b\u0010'\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010(\u001a\u00020\u00052\u0006\u0010&\u001a\u00020)2\u0006\u0010'\u001a\u00020)H\u0002J\u0006\u0010*\u001a\u00020+J \u0010\u000e\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u00030\r0\f2\u0006\u0010!\u001a\u00020\u0007H\u0002J$\u0010,\u001a\u00020+2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u00030\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006."}, d2={"Lcom/intellij/database/model/migration/DbPropsDiffTableModel;", "Ljavax/swing/table/AbstractTableModel;", "<init>", "()V", "status", "Lcom/intellij/database/model/migration/DiffStatus;", "originElement", "Lcom/intellij/database/model/basic/BasicElement;", "targetElement", "modelHelper", "Lcom/intellij/database/model/ModelHelper;", "properties", "", "Lcom/intellij/database/model/meta/BasicMetaProperty;", "getProperties", "()Ljava/util/List;", "setProperties", "(Ljava/util/List;)V", "getRowCount", "", "getColumnCount", "getColumnName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "column", "getValueAt", "", "rowIndex", "columnIndex", "getPropertyStringValue", "E", "T", "element", "parameter", "(Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/meta/BasicMetaProperty;)Ljava/lang/String;", "getRowStatus", "compareProperties", "originValue", "targetValue", "compareReferences", "Lcom/intellij/database/model/properties/BasicReference;", "clear", "", "setElements", "Column", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbPropsDiffTableModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbPropsDiffTableModel.kt\ncom/intellij/database/model/migration/DbPropsDiffTableModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n23#3:109\n865#4,2:110\n*S KotlinDebug\n*F\n+ 1 DbPropsDiffTableModel.kt\ncom/intellij/database/model/migration/DbPropsDiffTableModel\n*L\n59#1:109\n89#1:110,2\n*E\n"})
public final class DbPropsDiffTableModel
extends AbstractTableModel {
    @Nullable
    private DiffStatus status;
    @Nullable
    private BasicElement originElement;
    @Nullable
    private BasicElement targetElement;
    @Nullable
    private ModelHelper modelHelper;
    @NotNull
    private List<? extends BasicMetaProperty<BasicElement, ?>> properties = CollectionsKt.emptyList();

    @NotNull
    public final List<BasicMetaProperty<BasicElement, ?>> getProperties() {
        return this.properties;
    }

    public final void setProperties(@NotNull List<? extends BasicMetaProperty<BasicElement, ?>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.properties = list;
    }

    @Override
    public int getRowCount() {
        return this.properties.size();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        String string;
        int n = column;
        if (n == Column.PROPERTY.getIndex()) {
            string = DatabaseBundle.message((String)"migration.meta.properties.diff.table.tab.parameter", (Object[])new Object[0]);
        } else if (n == Column.ORIGIN.getIndex()) {
            string = DatabaseBundle.message((String)"migration.meta.properties.diff.table.tab.origin", (Object[])new Object[0]);
        } else if (n == Column.TARGET.getIndex()) {
            string = DatabaseBundle.message((String)"migration.meta.properties.diff.table.tab.target", (Object[])new Object[0]);
        } else {
            throw new AssertionError();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    @Override
    @NotNull
    public Object getValueAt(int rowIndex, int columnIndex) {
        String string;
        BasicMetaProperty<BasicElement, ?> property = this.properties.get(rowIndex);
        int n = columnIndex;
        if (n == Column.PROPERTY.getIndex()) {
            ModelHelper modelHelper = this.modelHelper;
            Intrinsics.checkNotNull((Object)modelHelper);
            BasicElement basicElement = this.originElement;
            if (basicElement == null) {
                basicElement = this.targetElement;
            }
            Intrinsics.checkNotNull((Object)basicElement);
            string = modelHelper.getTitle(basicElement.getMetaObject(), (BasicMetaId)property.id);
        } else if (n == Column.ORIGIN.getIndex()) {
            string = this.getPropertyStringValue(this.originElement, property);
        } else if (n == Column.TARGET.getIndex()) {
            string = this.getPropertyStringValue(this.targetElement, property);
        } else {
            throw new AssertionError();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    private final <E extends BasicElement, T> String getPropertyStringValue(E element, BasicMetaProperty<E, T> parameter) {
        Object object;
        block5: {
            block4: {
                object = element;
                if (object == null) break block4;
                E it = object;
                boolean bl = false;
                String string = BasicMetaUtils.getPropertyStringValue(element, parameter);
                if (string == null) {
                    string = "null";
                }
                object = string;
                if (string != null) break block5;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public final DiffStatus getRowStatus(int rowIndex) {
        if (!(0 <= rowIndex ? rowIndex <= this.getRowCount() : false)) {
            throw new IllegalArgumentException();
        }
        if (this.status != DiffStatus.MODIFIED) {
            DiffStatus diffStatus = this.status;
            Intrinsics.checkNotNull((Object)((Object)diffStatus));
            return diffStatus;
        }
        BasicMetaProperty<BasicElement, ?> property = this.properties.get(rowIndex);
        BasicElement origin = this.originElement;
        BasicElement target = this.targetElement;
        if (origin == null || target == null) {
            DbPropsDiffTableModel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DbPropsDiffTableModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Some elements are null for modified node: origin=" + origin + ", target=" + target);
            return DiffStatus.SAME;
        }
        Object originValue = property.get(origin);
        Object targetValue = property.get(target);
        return this.compareProperties(originValue, targetValue);
    }

    private final DiffStatus compareProperties(Object originValue, Object targetValue) {
        if (originValue == null && targetValue == null) {
            return DiffStatus.SAME;
        }
        if (originValue == null || targetValue == null) {
            return DiffStatus.MODIFIED;
        }
        if (originValue instanceof BasicReference && targetValue instanceof BasicReference) {
            return this.compareReferences((BasicReference)originValue, (BasicReference)targetValue);
        }
        return Intrinsics.areEqual((Object)originValue, (Object)targetValue) ? DiffStatus.SAME : DiffStatus.MODIFIED;
    }

    private final DiffStatus compareReferences(BasicReference originValue, BasicReference targetValue) {
        return originValue.isEquivalent(targetValue) ? DiffStatus.SAME : DiffStatus.MODIFIED;
    }

    public final void clear() {
        this.status = null;
        this.originElement = null;
        this.targetElement = null;
        this.modelHelper = null;
        this.properties = CollectionsKt.emptyList();
        this.fireTableDataChanged();
    }

    /*
     * WARNING - void declaration
     */
    private final List<BasicMetaProperty<BasicElement, ?>> getProperties(BasicElement element) {
        void $this$filterTo$iv;
        BasicMetaObject basicMetaObject = BasicMetaUtils.getMetaObject((BasicElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaObject, (String)"getMetaObject(...)");
        BasicMetaObject metaObject = basicMetaObject;
        JBIterable jBIterable = metaObject.getAllProperties();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getAllProperties(...)");
        Iterable iterable = (Iterable)jBIterable;
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            BasicMetaProperty it = (BasicMetaProperty)element$iv;
            boolean bl = false;
            if (!(!it.isInternal() && !it.isAbstract())) continue;
            destination$iv.add(element$iv);
        }
        ArrayList properties = (ArrayList)destination$iv;
        ModelHelper modelHelper = this.modelHelper = DbImplUtilCore.getModelHelper((Dbms)DbImplUtilCore.getDbms((BasicElement)element));
        Intrinsics.checkNotNull((Object)modelHelper);
        modelHelper.prepareProperties(metaObject, (List)properties);
        return properties;
    }

    public final void setElements(@Nullable BasicElement originElement, @Nullable BasicElement targetElement, @Nullable DiffStatus status) {
        if (originElement == null && targetElement == null || status == null) {
            this.clear();
            return;
        }
        this.status = status;
        this.originElement = originElement;
        this.targetElement = targetElement;
        BasicElement basicElement = originElement;
        if (basicElement == null && (basicElement = targetElement) == null) {
            throw new AssertionError();
        }
        BasicElement element = basicElement;
        this.properties = this.getProperties(element);
        this.fireTableStructureChanged();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/model/migration/DbPropsDiffTableModel$Column;", "", "index", "", "<init>", "(Ljava/lang/String;II)V", "getIndex", "()I", "PROPERTY", "ORIGIN", "TARGET", "intellij.database.impl"})
    private static final class Column
    extends Enum<Column> {
        private final int index;
        public static final /* enum */ Column PROPERTY = new Column(0);
        public static final /* enum */ Column ORIGIN = new Column(1);
        public static final /* enum */ Column TARGET = new Column(2);
        private static final /* synthetic */ Column[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Column(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        public static Column[] values() {
            return (Column[])$VALUES.clone();
        }

        public static Column valueOf(String value) {
            return Enum.valueOf(Column.class, value);
        }

        @NotNull
        public static EnumEntries<Column> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = columnArray = new Column[]{Column.PROPERTY, Column.ORIGIN, Column.TARGET};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

