/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.ssh.SshTunnelsInfo;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionEstablisher;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SshConnectionInterceptor;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.config.ConfigRepository;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000  2\u00020\u0001:\u0005\u001c\u001d\u001e\u001f B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\tH\u0086@\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J8\u0010\u0015\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0018H\u0082@\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;)V", "createTunnels", "Lcom/intellij/database/console/ssh/SshTunnelsInfo;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createLocalTunnel", "", "hostPort", "Lcom/intellij/database/dataSource/url/HostPort;", "session", "Lcom/intellij/ssh/SshSession;", "authType", "Lcom/intellij/remote/AuthType;", "forcedLocalPort", "", "createSshSessionWithRetries", "Lkotlin/Triple;", "Lcom/intellij/database/dataSource/DataSourceSshTunnelConfiguration;", "Lcom/intellij/ssh/ui/unified/SshUiData;", "ssh", "sshUiData", "(Lcom/intellij/database/dataSource/DataSourceSshTunnelConfiguration;Lcom/intellij/ssh/ui/unified/SshUiData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "SshForcedPortErrorInfo", "SshForcedPortOccupiedErrorInfo", "SshForcedPortNotApplicableErrorInfo", "SshTunnel", "Companion", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDatabaseSshTunnelEstablisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSshTunnelEstablisher.kt\ncom/intellij/database/dataSource/DatabaseSshTunnelEstablisher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n1#2:347\n*E\n"})
public final class DatabaseSshTunnelEstablisher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final LocalDataSource myDataSource;
    @NotNull
    private static final Logger LOG;
    public static final int DEF_PORT = 22;
    @NotNull
    public static final String DEF_KEY_FILE = "~/.ssh/id_rsa";

    private DatabaseSshTunnelEstablisher(Project myProject, LocalDataSource myDataSource) {
        this.myProject = myProject;
        this.myDataSource = myDataSource;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object createTunnels(@NotNull Continuation<? super SshTunnelsInfo> $completion) {
        if (!($completion instanceof createTunnels.1)) ** GOTO lbl-1000
        var16_2 = $completion;
        if ((var16_2.label & -2147483648) != 0) {
            var16_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseSshTunnelEstablisher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createTunnels((Continuation<? super SshTunnelsInfo>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ssh = DataSourceSshTunnelConfiguration.getEnabledSshConfiguration((DatabaseConnectionPoint)((DatabaseConnectionPoint)this.myDataSource));
                if (ssh == null) {
                    return null;
                }
                $continuation.L$0 = ssh;
                $continuation.label = 1;
                v0 = com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$extractHostsPorts(DatabaseSshTunnelEstablisher.Companion, this.myProject, this.myDataSource, (Continuation)$continuation);
                if (v0 == var17_4) {
                    return var17_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                ssh = (DataSourceSshTunnelConfiguration)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if ((hostsPorts = (List)v0).isEmpty()) {
                    throw new UnsupportedOperationException(DatabaseBundle.message((String)"DataSourceSshPanel.unable.to.find.host.port", (Object[])new Object[0]));
                }
                v1 = forcedLocalPort = ssh.getLocalPort() == -1 ? null : String.valueOf(ssh.getLocalPort());
                if (hostsPorts.size() > 1 && forcedLocalPort != null) {
                    throw new KnownDatabaseException((ErrorInfo)new SshForcedPortNotApplicableErrorInfo(forcedLocalPort));
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)ssh);
                $continuation.L$1 = hostsPorts;
                $continuation.L$2 = forcedLocalPort;
                $continuation.label = 2;
                v2 = DatabaseSshTunnelEstablisher.Companion.getInitialSshCredentials(this.myProject, this.myDataSource, true, (Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>>)$continuation);
                if (v2 == var17_4) {
                    return var17_4;
                }
                ** GOTO lbl44
            }
            case 2: {
                forcedLocalPort = (String)$continuation.L$2;
                hostsPorts = (List)$continuation.L$1;
                ssh = (DataSourceSshTunnelConfiguration)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl44:
                // 2 sources

                config = (Pair)v2;
                v3 = this;
                v4 = config;
                if (v4 != null && (v4 = (DataSourceSshTunnelConfiguration)v4.getFirst()) != null) {
                    var8_9 = v4;
                    var9_10 = var8_9;
                    var13_11 = v3;
                    $i$a$-takeIf-DatabaseSshTunnelEstablisher$createTunnels$sessionInfo$1 = false;
                    var14_15 = it.isEnabled();
                    v3 = var13_11;
                    v5 /* !! */  = var14_15 ? var8_9 : null;
                } else {
                    v5 /* !! */  = null;
                }
                v6 = config;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)ssh);
                $continuation.L$1 = hostsPorts;
                $continuation.L$2 = forcedLocalPort;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)config);
                $continuation.label = 3;
                v7 = v3.createSshSessionWithRetries((DataSourceSshTunnelConfiguration)v5 /* !! */ , (SshUiData)(v6 != null ? (SshUiData)v6.getSecond() : null), (Continuation<? super Triple<? extends DataSourceSshTunnelConfiguration, ? extends SshSession, SshUiData>>)$continuation);
                if (v7 == var17_4) {
                    return var17_4;
                }
                ** GOTO lbl74
            }
            case 3: {
                config = (Pair)$continuation.L$3;
                forcedLocalPort = (String)$continuation.L$2;
                hostsPorts = (List)$continuation.L$1;
                ssh = (DataSourceSshTunnelConfiguration)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl74:
                // 2 sources

                if ((sessionInfo = (Triple)v7) == null) {
                    return null;
                }
                session = (SshSession)sessionInfo.getSecond();
                tunnels = new ArrayList<E>();
                try {
                    for (HostPort hostPort : hostsPorts) {
                        v8 = ((SshUiData)sessionInfo.getThird()).getAuthType();
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getAuthType(...)");
                        tunnels.add(new SshTunnel(this.createLocalTunnel(hostPort, session, v8, forcedLocalPort), hostPort));
                    }
                    v9 = ((SshUiData)sessionInfo.getThird()).getAuthType();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getAuthType(...)");
                    return new SshTunnelsInfo(session, v9, tunnels);
                }
                catch (Throwable th) {
                    for (SshTunnel tunnel : tunnels) {
                        JdbcNativeUtil.performSafe((ThrowableRunnable)(ThrowableRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, createTunnels$lambda$1(com.intellij.ssh.SshSession com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$SshTunnel ), ()V)((SshSession)session, (SshTunnel)tunnel));
                    }
                    throw th;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final int createLocalTunnel(@NotNull HostPort hostPort, @NotNull SshSession session, @NotNull AuthType authType, @Nullable String forcedLocalPort) {
        Intrinsics.checkNotNullParameter((Object)hostPort, (String)"hostPort");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        return DatabaseSshTunnelEstablisher.Companion.getAddLocalPortTunnel(hostPort, authType == AuthType.OPEN_SSH, forcedLocalPort, session);
    }

    private final Object createSshSessionWithRetries(DataSourceSshTunnelConfiguration ssh, SshUiData sshUiData, Continuation<? super Triple<? extends DataSourceSshTunnelConfiguration, ? extends SshSession, SshUiData>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Triple<? extends DataSourceSshTunnelConfiguration, ? extends SshSession, ? extends SshUiData>>, Object>(ssh, sshUiData, this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ DataSourceSshTunnelConfiguration $ssh;
            final /* synthetic */ SshUiData $sshUiData;
            final /* synthetic */ DatabaseSshTunnelEstablisher this$0;
            {
                this.$ssh = $ssh;
                this.$sshUiData = $sshUiData;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$ssh == null || this.$sshUiData == null) {
                            return null;
                        }
                        try {
                            var2_3 = new Triple((Object)this.$ssh, (Object)com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$createSshSession(DatabaseSshTunnelEstablisher.Companion, this.$sshUiData), (Object)this.$sshUiData);
                            ** GOTO lbl39
                        }
                        catch (Throwable e) {
                            if (!com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$isAuthFailure(DatabaseSshTunnelEstablisher.Companion, e)) {
                                throw e;
                            }
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                            this.label = 1;
                            v0 = DatabaseSshTunnelEstablisher.Companion.askSshCredentialsWhenFailed(DatabaseSshTunnelEstablisher.access$getMyProject$p(this.this$0), DatabaseSshTunnelEstablisher.access$getMyDataSource$p(this.this$0), "<html>" + e.getMessage() + "</html>", true, (Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>>)((Continuation)this));
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl24
                        }
                    }
                    case 1: {
                        e = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        v1 = config = (Pair)v0;
                        v2 = config;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)config);
                        this.label = 2;
                        v3 = DatabaseSshTunnelEstablisher.access$createSshSessionWithRetries(this.this$0, (DataSourceSshTunnelConfiguration)(v1 != null ? (DataSourceSshTunnelConfiguration)v1.getFirst() : null), (SshUiData)(v2 != null ? (SshUiData)v2.getSecond() : null), (Continuation)this);
                        if (v3 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl38
                    }
                    case 2: {
                        config = (Pair)this.L$1;
                        e = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl38:
                        // 2 sources

                        var2_3 = (Triple)v3;
lbl39:
                        // 2 sources

                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Triple<? extends DataSourceSshTunnelConfiguration, ? extends SshSession, SshUiData>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final void createTunnels$lambda$1(SshSession $session, SshTunnel $tunnel) {
        $session.removeLocalTunnel($tunnel.localPort);
    }

    @JvmStatic
    @Nullable
    public static final SshTunnelsInfo createTunnelsSync(@NotNull Project project, @NotNull LocalDataSource dataSource) throws SshException {
        return Companion.createTunnelsSync(project, dataSource);
    }

    @JvmStatic
    public static final int createAdditionalLocalTunnel(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull HostPort hostPort, @NotNull SshTunnelsInfo tunnelsInfo) {
        return Companion.createAdditionalLocalTunnel(project, dataSource, hostPort, tunnelsInfo);
    }

    @JvmStatic
    @NotNull
    public static final String tildeExpandFilename(@NotNull String path) {
        return Companion.tildeExpandFilename(path);
    }

    public static final /* synthetic */ Object access$createSshSessionWithRetries(DatabaseSshTunnelEstablisher $this, DataSourceSshTunnelConfiguration ssh, SshUiData sshUiData, Continuation $completion) {
        return $this.createSshSessionWithRetries(ssh, sshUiData, (Continuation<? super Triple<? extends DataSourceSshTunnelConfiguration, ? extends SshSession, SshUiData>>)$completion);
    }

    public static final /* synthetic */ Project access$getMyProject$p(DatabaseSshTunnelEstablisher $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ LocalDataSource access$getMyDataSource$p(DatabaseSshTunnelEstablisher $this) {
        return $this.myDataSource;
    }

    public /* synthetic */ DatabaseSshTunnelEstablisher(Project myProject, LocalDataSource myDataSource, DefaultConstructorMarker $constructor_marker) {
        this(myProject, myDataSource);
    }

    static {
        Logger logger = Logger.getInstance(DatabaseSshTunnelEstablisher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J(\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0007J \u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0016J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0082@\u00a2\u0006\u0002\u0010\u0016J*\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010 \u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\nH\u0002J\"\u0010!\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J$\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020\nH\u0007JC\u00102\u001a\u0012\u0012\u0004\u0012\u000204\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u0001032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000b\u00105\u001a\u00070\n\u00a2\u0006\u0002\b62\u0006\u00107\u001a\u00020\u001bH\u0086@\u00a2\u0006\u0002\u00108J.\u00109\u001a\u0012\u0012\u0004\u0012\u000204\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u0001032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0016J6\u0010:\u001a\u0012\u0012\u0004\u0012\u000204\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u0001032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u001bH\u0086@\u00a2\u0006\u0002\u0010<J(\u0010=\u001a\u0012\u0012\u0004\u0012\u000204\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u0001032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010>\u001a\u0012\u0012\u0004\u0012\u000204\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u0001032\u0006\u0010?\u001a\u00020@2\u0006\u0010\r\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010AR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "DEF_PORT", "", "DEF_KEY_FILE", "", "createTunnelsSync", "Lcom/intellij/database/console/ssh/SshTunnelsInfo;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "createAdditionalLocalTunnel", "hostPort", "Lcom/intellij/database/dataSource/url/HostPort;", "tunnelsInfo", "createTunnels", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractHostsPorts", "", "getAddLocalPortTunnel", "reuseExisting", "", "requiredLocal", "session", "Lcom/intellij/ssh/SshSession;", "getNewTunnelPort", "findLocalPort", "findExistingPort", "findExistingForwarding", "isAuthFailure", "e", "", "createSshSession", "sshUiData", "Lcom/intellij/ssh/ui/unified/SshUiData;", "usePortFromOpenSSHConfig", "", "holder", "Lcom/intellij/remote/RemoteCredentialsHolder;", "hostConfig", "Lcom/intellij/ssh/config/ConfigRepository$Config;", "useUserFromOpenSSHConfig", "tildeExpandFilename", "path", "askSshCredentialsWhenFailed", "Lkotlin/Pair;", "Lcom/intellij/database/dataSource/DataSourceSshTunnelConfiguration;", "message", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "error", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "askNoSshCredentials", "getInitialSshCredentials", "askPassword", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSshAuth", "getSshAuthAsync", "info", "Lcom/intellij/database/model/DasDataSource;", "(Lcom/intellij/database/model/DasDataSource;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseSshTunnelEstablisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSshTunnelEstablisher.kt\ncom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,346:1\n1#2:347\n106#3:348\n78#3,22:349\n*S KotlinDebug\n*F\n+ 1 DatabaseSshTunnelEstablisher.kt\ncom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$Companion\n*L\n278#1:348\n278#1:349,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final SshTunnelsInfo createTunnelsSync(@NotNull Project project, @NotNull LocalDataSource dataSource) throws SshException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            return (SshTunnelsInfo)com.intellij.openapi.progress.CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SshTunnelsInfo>, Object>(project, dataSource, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ LocalDataSource $dataSource;
                {
                    this.$project = $project;
                    this.$dataSource = $dataSource;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DatabaseSshTunnelEstablisher.Companion.createTunnels(this.$project, this.$dataSource, (Continuation<? super SshTunnelsInfo>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super SshTunnelsInfo> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @JvmStatic
        public final int createAdditionalLocalTunnel(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull HostPort hostPort, @NotNull SshTunnelsInfo tunnelsInfo) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)hostPort, (String)"hostPort");
            Intrinsics.checkNotNullParameter((Object)tunnelsInfo, (String)"tunnelsInfo");
            return new DatabaseSshTunnelEstablisher(project, dataSource, null).createLocalTunnel(hostPort, tunnelsInfo.getSession(), tunnelsInfo.getAuthType(), null);
        }

        @Nullable
        public final Object createTunnels(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull Continuation<? super SshTunnelsInfo> $completion) {
            return new DatabaseSshTunnelEstablisher(project, dataSource, null).createTunnels($completion);
        }

        /*
         * Unable to fully structure code
         */
        private final Object extractHostsPorts(Project project, LocalDataSource dataSource, Continuation<? super List<? extends HostPort>> $completion) {
            if (!($completion instanceof extractHostsPorts.1)) ** GOTO lbl-1000
            var9_4 = $completion;
            if ((var9_4.label & -2147483648) != 0) {
                var9_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$extractHostsPorts(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$extractHostsPorts_u24lambda_u240 = new DatabaseConnectionEstablisher.ProtoConnectionBuilder((DatabaseConnectionPoint)dataSource);
                    $i$a$-run-DatabaseSshTunnelEstablisher$Companion$extractHostsPorts$proto$1 = 0;
                    $this$extractHostsPorts_u24lambda_u240.setStopAt((Function1<? super DatabaseConnectionInterceptor, Boolean>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, extractHostsPorts$lambda$0$0(com.intellij.database.dataSource.DatabaseConnectionInterceptor ), (Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor;)Ljava/lang/Boolean;)());
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)dataSource);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$extractHostsPorts_u24lambda_u240);
                    $continuation.I$0 = $i$a$-run-DatabaseSshTunnelEstablisher$Companion$extractHostsPorts$proto$1;
                    $continuation.label = 1;
                    v0 = $this$extractHostsPorts_u24lambda_u240.processInterceptors(project, true, false, (Continuation<? super DatabaseConnectionInterceptor.ProtoConnection>)$continuation);
                    if (v0 == var10_6) {
                        return var10_6;
                    }
                    ** GOTO lbl32
                }
                case 1: {
                    $i$a$-run-DatabaseSshTunnelEstablisher$Companion$extractHostsPorts$proto$1 = $continuation.I$0;
                    $this$extractHostsPorts_u24lambda_u240 = (DatabaseConnectionEstablisher.ProtoConnectionBuilder)$continuation.L$2;
                    dataSource = (LocalDataSource)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    proto = (DatabaseConnectionInterceptor.ProtoConnection)v0;
                    connectionUrl = proto.getUrl();
                    driver = proto.getConnectionPoint().getDatabaseDriver();
                    if (driver == null) {
                        return CollectionsKt.emptyList();
                    }
                    v1 = JdbcUrlParserUtil.extractHostsPorts((Collection)driver.getJDBCUrlParsers(), (String)connectionUrl, null);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"extractHostsPorts(...)");
                    return v1;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final int getAddLocalPortTunnel(HostPort hostPort, boolean reuseExisting, String requiredLocal, SshSession session) {
            int existingPort = reuseExisting || requiredLocal != null ? this.findExistingPort(hostPort, requiredLocal, session) : -1;
            return existingPort != -1 ? existingPort : this.getNewTunnelPort(hostPort, requiredLocal, session);
        }

        private final int getNewTunnelPort(HostPort hostPort, String requiredLocal, SshSession session) {
            int localPort = this.findLocalPort(requiredLocal);
            String string = hostPort.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            session.addLocalTunnel(localPort, string, StringUtil.parseInt((String)hostPort.getPort(), (int)-1));
            LOG.info("SSH tunnel created: " + localPort + ":" + hostPort);
            return localPort;
        }

        private final int findLocalPort(String requiredLocal) {
            if (requiredLocal != null) {
                int localPort = StringUtil.parseInt((String)requiredLocal, (int)-1);
                if (localPort != -1) {
                    return localPort;
                }
                throw new SshException("Requested local port is not an integer: " + requiredLocal, new Attachment[0]);
            }
            try {
                return NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                throw new SshException("Free port not found", (Throwable)e, new Attachment[0]);
            }
        }

        private final int findExistingPort(HostPort hostPort, String requiredLocal, SshSession session) {
            String existing = this.findExistingForwarding(hostPort, requiredLocal, session);
            if (existing != null) {
                String string = existing.substring(0, StringsKt.indexOf$default((CharSequence)existing, (char)':', (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int localPort = StringUtil.parseInt((String)string, (int)-1);
                if (localPort == -1) {
                    throw new RuntimeException("Failed to parse forwarding: " + existing);
                }
                LOG.info("SSH tunnel reused: " + existing);
                return localPort;
            }
            return -1;
        }

        private final String findExistingForwarding(HostPort hostPort, String requiredLocal, SshSession session) {
            String found;
            Object v1;
            List existing;
            block6: {
                session.applyPortForwardings();
                existing = session.getPortForwardingList();
                String string = requiredLocal;
                if (string == null) {
                    string = "";
                }
                String term = string + ":" + hostPort;
                Iterable iterable = existing;
                for (Object object : iterable) {
                    String it = (String)object;
                    boolean bl = false;
                    if (!(requiredLocal == null ? StringsKt.endsWith$default((String)it, (String)term, (boolean)false, (int)2, null) : Intrinsics.areEqual((Object)it, (Object)term))) continue;
                    v1 = object;
                    break block6;
                }
                v1 = null;
            }
            String string = found = (String)v1;
            if (string != null) {
                return string;
            }
            if (requiredLocal != null) {
                Object v3;
                String prefix;
                block7: {
                    Object object;
                    prefix = requiredLocal + ":";
                    Iterable iterable = existing;
                    object = iterable.iterator();
                    while (object.hasNext()) {
                        Object e = object.next();
                        String o = (String)e;
                        boolean bl = false;
                        if (!StringsKt.startsWith$default((String)o, (String)prefix, (boolean)false, (int)2, null)) continue;
                        v3 = e;
                        break block7;
                    }
                    v3 = null;
                }
                found = v3;
                if (found != null) {
                    String string2 = hostPort.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    throw new KnownDatabaseException((ErrorInfo)new SshForcedPortOccupiedErrorInfo(requiredLocal, string2, StringsKt.removePrefix((String)found, (CharSequence)prefix)));
                }
            }
            return found;
        }

        private final boolean isAuthFailure(Throwable e) {
            if (e instanceof SshException) {
                if (e instanceof AuthFailSshTransportException) {
                    return true;
                }
                String message = e.getMessage();
                if (message == null) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)"Auth cancel", (Object)message)) {
                    return true;
                }
                if (StringsKt.contains$default((CharSequence)message, (CharSequence)"Too many authentication failures", (boolean)false, (int)2, null)) {
                    return true;
                }
            }
            return false;
        }

        private final SshSession createSshSession(SshUiData sshUiData) {
            RemoteCredentialsHolder holder = new RemoteCredentialsHolder();
            holder.copyFrom((RemoteCredentials)sshUiData);
            holder.setPort(StringUtil.parseInt((String)holder.getLiteralPort(), (int)22));
            switch (WhenMappings.$EnumSwitchMapping$0[holder.getAuthType().ordinal()]) {
                case 1: {
                    String string = StringUtil.notNullize((String)StringUtil.nullize((String)holder.getPrivateKeyFile()), (String)DatabaseSshTunnelEstablisher.DEF_KEY_FILE);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"notNullize(...)");
                    holder.setPrivateKeyFile(this.tildeExpandFilename(string));
                    break;
                }
                case 2: {
                    CharSequence charSequence;
                    OpenSSHClientConfig openSSHConfig = OpenSSHConfigService.Companion.getInstance().getConfig();
                    if (openSSHConfig == null) break;
                    ConfigRepository.Config hostConfig = (ConfigRepository.Config)openSSHConfig.getConfig(holder.getHost());
                    String string = holder.getHost();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
                    if (StringsKt.isBlank((CharSequence)string)) {
                        this.usePortFromOpenSSHConfig(holder, hostConfig);
                    }
                    if (!((charSequence = (CharSequence)holder.getUserName()) == null || StringsKt.isBlank((CharSequence)charSequence))) break;
                    this.useUserFromOpenSSHConfig(holder, hostConfig);
                }
            }
            ConnectionBuilder builder = RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)((RemoteCredentials)holder), null, null, (boolean)false, null, (int)15, null);
            return builder.connect();
        }

        private final void usePortFromOpenSSHConfig(RemoteCredentialsHolder holder, ConfigRepository.Config hostConfig) {
            int port = hostConfig.getPort();
            if (port != -1) {
                LOG.info("Use " + port + " port from OpenSSH configuration file");
                holder.setPort(port);
            }
        }

        private final void useUserFromOpenSSHConfig(RemoteCredentialsHolder holder, ConfigRepository.Config hostConfig) {
            String user = hostConfig.getUser();
            if (StringUtil.isNotEmpty((String)user)) {
                LOG.info("Use \"" + user + "\" user from OpenSSH configuration file");
                holder.setUserName(user);
            }
        }

        @JvmStatic
        @NotNull
        public final String tildeExpandFilename(@NotNull String path) {
            Object object;
            String path2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String $this$trim$iv = path2 = path;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.startsWith$default((String)(path2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"~", (boolean)false, (int)2, null)) {
                String string = SystemProperties.getUserHome();
                String string2 = path2.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                object = string + string2;
            } else {
                object = path2;
            }
            return object;
        }

        @Nullable
        public final Object askSshCredentialsWhenFailed(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String message, boolean error, @NotNull Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>> $completion) {
            if (project.isDefault()) {
                throw new CancellationException("Default project");
            }
            if (!DataSourceSshTunnelConfiguration.hasTunnel((DatabaseConnectionPoint)((DatabaseConnectionPoint)dataSource))) {
                throw new CancellationException("No SSH");
            }
            Pair<DataSourceSshTunnelConfiguration, SshUiData> p1 = this.getSshAuth(dataSource, project);
            return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>, Object>(dataSource, project, p1, message, error, null){
                int label;
                final /* synthetic */ LocalDataSource $dataSource;
                final /* synthetic */ Project $project;
                final /* synthetic */ Pair<DataSourceSshTunnelConfiguration, SshUiData> $p1;
                final /* synthetic */ String $message;
                final /* synthetic */ boolean $error;
                {
                    this.$dataSource = $dataSource;
                    this.$project = $project;
                    this.$p1 = $p1;
                    this.$message = $message;
                    this.$error = $error;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Pair p2 = com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$getSshAuth(DatabaseSshTunnelEstablisher.Companion, this.$dataSource, this.$project);
                            if (!(Intrinsics.areEqual(this.$p1, (Object)p2) || this.$p1 != null && p2 != null && Intrinsics.areEqual((Object)this.$p1.getFirst(), (Object)p2.getFirst()) && this.$p1.getSecond() != null && p2.getSecond() != null && Intrinsics.areEqual((Object)this.$p1.getSecond(), (Object)p2.getSecond()))) {
                                return p2;
                            }
                            return DatabaseUiService.Companion.getInstance().askSshCredentials(this.$project, this.$dataSource, this.$message, this.$error);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        @Nullable
        public final Object askNoSshCredentials(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>> $completion) {
            String string = DatabaseBundle.message((String)"ssh.tunnel.html.please.provide.ssh.credentials.html", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.askSshCredentialsWhenFailed(project, dataSource, string, false, $completion);
        }

        @Nullable
        public final Object getInitialSshCredentials(@NotNull Project project, @NotNull LocalDataSource dataSource, boolean askPassword, @NotNull Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>> $completion) {
            return DatabaseCredentials.Companion.getInitialCredentials(LocalDataSource.Storage.MEMORY, askPassword, (Function1)new Function1<Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>, Object>(dataSource, project, null){
                int label;
                final /* synthetic */ LocalDataSource $dataSource;
                final /* synthetic */ Project $project;
                {
                    this.$dataSource = $dataSource;
                    this.$project = $project;
                    super(1, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DatabaseSshTunnelEstablisher.Companion.getSshAuthAsync((DasDataSource)this.$dataSource, this.$project, (Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }, (Function2)new Function2<Throwable, Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>, Object>(project, dataSource, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ LocalDataSource $dataSource;
                {
                    this.$project = $project;
                    this.$dataSource = $dataSource;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (Throwable)this.L$0;
                    var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (th != null) break;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)th);
                            this.label = 1;
                            v0 = DatabaseSshTunnelEstablisher.Companion.askNoSshCredentials(this.$project, this.$dataSource, (Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>>)((Continuation)this));
                            if (v0 == var3_3) {
                                return var3_3;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            v1 = (Pair)v0;
                            ** GOTO lbl30
                        }
                    }
                    v2 = th.getMessage();
                    Intrinsics.checkNotNull((Object)v2);
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)th);
                    this.label = 2;
                    v3 = DatabaseSshTunnelEstablisher.Companion.askSshCredentialsWhenFailed(this.$project, this.$dataSource, v2, true, (Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>>)((Continuation)this));
                    if (v3 == var3_3) {
                        return var3_3;
                    }
                    ** GOTO lbl29
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl29:
                            // 2 sources

                            v1 = (Pair)v3;
lbl30:
                            // 2 sources

                            return v1;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(Throwable p1, Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, Companion::getInitialSshCredentials$lambda$0, $completion);
        }

        private final Pair<DataSourceSshTunnelConfiguration, SshUiData> getSshAuth(LocalDataSource dataSource, Project project) {
            DataSourceSshTunnelConfiguration ssh = DataSourceSshTunnelConfiguration.getEnabledSshConfiguration((DatabaseConnectionPoint)((DatabaseConnectionPoint)dataSource));
            if (ssh == null) {
                return null;
            }
            SshConfig config = ssh.getSshConfig(project);
            if (config == null) {
                return null;
            }
            return new Pair((Object)ssh, (Object)new SshUiData(config));
        }

        @Nullable
        public final Object getSshAuthAsync(@NotNull DasDataSource info, @NotNull Project project, @NotNull Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>> $completion) {
            DataSourceSshTunnelConfiguration ssh;
            LocalDataSource dataSource;
            LocalDataSource localDataSource = dataSource = info instanceof LocalDataSource ? (LocalDataSource)info : null;
            Object object = ssh = localDataSource != null ? localDataSource.getSshConfiguration() : null;
            if (ssh == null) {
                return null;
            }
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, ? extends SshUiData>>, Object>(dataSource, project, null){
                int label;
                final /* synthetic */ LocalDataSource $dataSource;
                final /* synthetic */ Project $project;
                {
                    this.$dataSource = $dataSource;
                    this.$project = $project;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            return com.intellij.database.dataSource.DatabaseSshTunnelEstablisher$Companion.access$getSshAuth(DatabaseSshTunnelEstablisher.Companion, this.$dataSource, this.$project);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Pair<? extends DataSourceSshTunnelConfiguration, SshUiData>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private static final boolean extractHostsPorts$lambda$0$0(DatabaseConnectionInterceptor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof SshConnectionInterceptor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean getInitialSshCredentials$lambda$0(Pair c) {
            Pair pair = c;
            if (pair == null) return true;
            SshUiData sshUiData = (SshUiData)pair.getSecond();
            if (sshUiData == null) return true;
            Object object = c.getSecond();
            Intrinsics.checkNotNull((Object)object);
            if (!((SshUiData)object).hasNoCredentials()) return false;
            return true;
        }

        public static final /* synthetic */ Object access$extractHostsPorts(Companion $this, Project project, LocalDataSource dataSource, Continuation $completion) {
            return $this.extractHostsPorts(project, dataSource, (Continuation<? super List<? extends HostPort>>)$completion);
        }

        public static final /* synthetic */ SshSession access$createSshSession(Companion $this, SshUiData sshUiData) {
            return $this.createSshSession(sshUiData);
        }

        public static final /* synthetic */ boolean access$isAuthFailure(Companion $this, Throwable e) {
            return $this.isAuthFailure(e);
        }

        public static final /* synthetic */ Pair access$getSshAuth(Companion $this, LocalDataSource dataSource, Project project) {
            return $this.getSshAuth(dataSource, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AuthType.values().length];
                try {
                    nArray[AuthType.KEY_PAIR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AuthType.OPEN_SSH.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshForcedPortErrorInfo;", "Lcom/intellij/database/connection/throwable/info/ErrorInfo;", "localPort", "", "<init>", "(Ljava/lang/String;)V", "getLocalPort", "()Ljava/lang/String;", "getFixes", "", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "getOriginalThrowable", "", "intellij.database.connectivity"})
    public static abstract class SshForcedPortErrorInfo
    implements ErrorInfo {
        @NotNull
        private final String localPort;

        public SshForcedPortErrorInfo(@NotNull String localPort) {
            Intrinsics.checkNotNullParameter((Object)localPort, (String)"localPort");
            this.localPort = localPort;
        }

        @NotNull
        public final String getLocalPort() {
            return this.localPort;
        }

        @NotNull
        public List<ErrorInfo.Fix> getFixes() {
            return CollectionsKt.emptyList();
        }

        @Nullable
        public Throwable getOriginalThrowable() {
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshForcedPortNotApplicableErrorInfo;", "Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshForcedPortErrorInfo;", "localPort", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "intellij.database.connectivity"})
    public static final class SshForcedPortNotApplicableErrorInfo
    extends SshForcedPortErrorInfo {
        public SshForcedPortNotApplicableErrorInfo(@NotNull String localPort) {
            Intrinsics.checkNotNullParameter((Object)localPort, (String)"localPort");
            super(localPort);
        }

        @NotNull
        public String getMessage() {
            Object[] objectArray = new Object[]{this.getLocalPort()};
            String string = DatabaseBundle.message((String)"notification.content.unable.to.create.multiple.ssh.tunnels", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshForcedPortOccupiedErrorInfo;", "Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshForcedPortErrorInfo;", "localPort", "", "desiredMapping", "existingMapping", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDesiredMapping", "()Ljava/lang/String;", "getExistingMapping", "getMessage", "intellij.database.connectivity"})
    public static final class SshForcedPortOccupiedErrorInfo
    extends SshForcedPortErrorInfo {
        @NotNull
        private final String desiredMapping;
        @NotNull
        private final String existingMapping;

        public SshForcedPortOccupiedErrorInfo(@NotNull String localPort, @NotNull String desiredMapping, @NotNull String existingMapping) {
            Intrinsics.checkNotNullParameter((Object)localPort, (String)"localPort");
            Intrinsics.checkNotNullParameter((Object)desiredMapping, (String)"desiredMapping");
            Intrinsics.checkNotNullParameter((Object)existingMapping, (String)"existingMapping");
            super(localPort);
            this.desiredMapping = desiredMapping;
            this.existingMapping = existingMapping;
        }

        @NotNull
        public final String getDesiredMapping() {
            return this.desiredMapping;
        }

        @NotNull
        public final String getExistingMapping() {
            return this.existingMapping;
        }

        @NotNull
        public String getMessage() {
            Object[] objectArray = new Object[]{this.getLocalPort(), this.existingMapping, this.desiredMapping};
            String string = DatabaseBundle.message((String)"notification.content.forced.local.port.already.occupied.by.ssh.tunnel.to.expected", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshTunnel;", "", "localPort", "", "remoteHostPort", "Lcom/intellij/database/dataSource/url/HostPort;", "<init>", "(ILcom/intellij/database/dataSource/url/HostPort;)V", "Companion", "intellij.database.connectivity"})
    public static final class SshTunnel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        public final int localPort;
        @JvmField
        @NotNull
        public final HostPort remoteHostPort;
        @NotNull
        public static final String LOCAL_HOST = "localhost";

        public SshTunnel(int localPort, @NotNull HostPort remoteHostPort) {
            Intrinsics.checkNotNullParameter((Object)remoteHostPort, (String)"remoteHostPort");
            this.localPort = localPort;
            this.remoteHostPort = remoteHostPort;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dataSource/DatabaseSshTunnelEstablisher$SshTunnel$Companion;", "", "<init>", "()V", "LOCAL_HOST", "", "intellij.database.connectivity"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

