/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.providers.SqlCompletionProviderBase;
import com.intellij.sql.completion.providers.SqlFunctionDefinitionCompletions;
import com.intellij.sql.completion.providers.SqlJoinSmartCompletionProvider;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlReferenceExpressionCompletionProvider
extends SqlCompletionProviderBase {
    @Override
    protected void doAddCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        LookupElement element2;
        Object ktt;
        SqlBinaryExpression be;
        SqlReferenceExpression qualifier;
        SqlReferenceImpl sqlRef;
        ObjectKind inDefinitionNameKind;
        PsiElement parent;
        SqlExpression expression;
        PsiElement prevLeaf;
        PsiElement position;
        block22: {
            block21: {
                if (parameters == null) {
                    SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(2);
                }
                if ((position = parameters.getPosition()).getParent() instanceof PsiErrorElement) {
                    return;
                }
                prevLeaf = SqlCompletionUtil.getNonWSPrecedingLeaf(position);
                if (prevLeaf instanceof PsiErrorElement && ((PsiErrorElement)prevLeaf).getErrorDescription().endsWith(" expected, got '" + position.getText() + "'")) {
                    return;
                }
                expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{SqlReferenceExpression.class, SqlStringLiteralExpression.class});
                if (expression == null) {
                    return;
                }
                if (PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)expression) instanceof PsiErrorElement) {
                    return;
                }
                parent = expression.getParent();
                inDefinitionNameKind = parent instanceof SqlDefinition && !(parent instanceof SqlRenameToClause) && ((SqlDefinition)parent).getNameElement() == expression ? ((SqlDefinition)parent).getKind() : null;
                PsiReference ref = expression.getReference();
                if (!(ref instanceof SqlReferenceImpl)) break block21;
                sqlRef = (SqlReferenceImpl)ref;
                if (!SqlPsiMiscUtil.isJoinUsingColumn(position)) break block22;
            }
            return;
        }
        Set strictExpectedTargetTypes = inDefinitionNameKind != null ? sqlRef.getExpectedTargetTypes(false, true) : Collections.emptySet();
        Project project = expression.getProject();
        SqlReferenceElementType refType = sqlRef.getReferenceElementType();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
        Dbms dbms = SqlImplUtil.getDbms((PsiElement)expression);
        NamingService namingService = NamingServices.getNamingService((Dbms)dbms);
        Set columnsNamesFromSelectForTableRef = CollectionFactory.createCaseInsensitiveStringSet();
        Set columnsNamesFromSelectForColumnRef = CollectionFactory.createCaseInsensitiveStringSet();
        Ref fromType = Ref.create();
        SqlReferenceExpression sqlReferenceExpression = qualifier = expression instanceof SqlReferenceExpression ? (SqlReferenceExpression)ObjectUtils.tryCast((Object)((SqlReferenceExpression)expression).getQualifierExpression(), SqlReferenceExpression.class) : null;
        if (qualifier != null) {
            qualifier.putUserData(SqlReferenceImpl.COMPLETION_MODE, (Object)true);
        }
        CompletionResultSet resultSet = result.caseInsensitive();
        if (refType == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
            String basePrefix;
            String qPrefix;
            String fullPrefix;
            List<String> items;
            int index;
            SqlTableExpression tableExpression;
            SqlSelectClause selectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlSelectClause.class);
            SqlQueryExpression query = (SqlQueryExpression)ObjectUtils.tryCast((Object)(selectClause == null ? null : selectClause.getParent()), SqlQueryExpression.class);
            SqlTableExpression sqlTableExpression = tableExpression = query == null ? null : query.getTableExpression();
            if (tableExpression != null) {
                fromType.set((Object)tableExpression.getDasType());
            }
            if (parent instanceof SqlGroupByClause && (qualifier != null || SqlImplUtil.sqlTraverser(parent).children((Object)parent).filter(SqlReferenceExpression.class).single() != null) && (index = ContainerUtil.indexOf(items = SqlReferenceExpressionCompletionProvider.collectGroupByItems((SqlGroupByClause)parent), arg_0 -> SqlReferenceExpressionCompletionProvider.lambda$doAddCompletions$0(fullPrefix = (qPrefix = qualifier != null ? qualifier.getText() + "." : "") + (basePrefix = resultSet.getPrefixMatcher().getPrefix()), arg_0))) >= 0) {
                ContainerUtil.swapElements(items, (int)0, (int)index);
                String suggestion = StringUtil.join(items, (String)", ");
                resultSet.addElement(SqlCompletionUtil.createTextLookup(suggestion.substring(qPrefix.length()), suggestion, 200.0));
            }
        }
        if (refType == SqlCompositeElementTypes.SQL_TABLE_REFERENCE && (parent instanceof SqlFromClause || parent instanceof SqlJoinExpression)) {
            SqlReferenceExpressionCompletionProvider.collectColumnsFromSelect(expression, namingService, columnsNamesFromSelectForTableRef);
        }
        SqlBinaryExpression binary = parent instanceof SqlBinaryExpression ? (be = (SqlBinaryExpression)parent) : null;
        IElementType sign = binary != null ? binary.getOpSign() : null;
        SqlExpression leftOperand = null;
        if (binary != null) {
            if (binary.getLOperand() == expression) {
                leftOperand = binary.getROperand();
            } else if (binary.getROperand() == expression) {
                leftOperand = binary.getLOperand();
            }
        }
        boolean isEq = sign == SqlCommonTokens.SQL_OP_EQ || sign == SqlCommonTokens.SQL_OP_EQEQ;
        DasType leftExpectedType = leftOperand != null ? leftOperand.getDasType() : null;
        DasTypeCategory leftExpectedCategory = leftExpectedType != null ? DasTypeUtilsKt.getCategoryOrUnknown((DasType)leftExpectedType) : DasTypeCategory.UNKNOWN;
        PsiElement leftResolved = leftOperand instanceof SqlReferenceExpression ? ((SqlReferenceExpression)leftOperand).resolve() : null;
        DasColumn leftColumn = leftResolved instanceof DasColumn ? (DasColumn)leftResolved : null;
        Set tablesForJoin = ContainerUtil.map2Set(SqlJoinSmartCompletionProvider.collectTablesForJoinIfAny(parameters), tableInfo -> tableInfo.table);
        boolean triggerFunctionExpected = SqlCompletionUtil.isTriggerFunctionExpected(expression);
        boolean isValidSelectClause = refType == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE && expression.getParent() instanceof SqlSelectClause && !SqlCompletionUtil.hasMissingFrom((SqlElement)expression);
        PsiElement qualifyingEntity = SqlReferenceExpressionCompletionProvider.getQualifyingEntity(qualifier);
        DasTable qualifierTable = SqlReferenceExpressionCompletionProvider.getQualifyingTable(qualifyingEntity);
        PsiElement originalPosition = parameters.getOriginalPosition();
        LinkedHashSet columnsAtOnce = new LinkedHashSet();
        ArrayList<PsiElement> qualifiers = new ArrayList<PsiElement>();
        Ref hasSourceColumns = Ref.create((Object)false);
        HashSet<String> existingFunctionNames = new HashSet<String>();
        ArrayList restrainedElements = new ArrayList();
        Set<ObjectKind> strictTypes = sqlRef.getExpectedTargetTypesStrict(dialect);
        boolean restrainNonStrict = dbms.isPostgres() && refType.getTargetKind() == ObjectKind.TABLE;
        boolean weightDown = prevLeaf instanceof SqlIdentifierKeywordTokenType && (ktt = (SqlIdentifierKeywordTokenType)prevLeaf).getKeyword() == SqlCommonKeywords.SQL_CONSTRAINT;
        SqlCompletionUtil.addReferenceCompletionVariants(sqlRef, resultSet.getPrefixMatcher(), weightDown, (Consumer<LookupElement>)((Consumer)element -> {
            SqlNameElement ne;
            ObjectKind targetKind;
            DasSymbol symbol = SqlCompletionUtil.getTargetSymbol(element);
            DasObject dasObject = symbol != null ? symbol.getDasObject() : null;
            ObjectKind objectKind = targetKind = dasObject != null ? dasObject.getKind() : ObjectKind.NONE;
            if (dasObject != null) {
                ObjectKind kind;
                ObjectKind objectKind2 = dasObject.getKind();
                if (!(inDefinitionNameKind == null || objectKind2 != inDefinitionNameKind && strictExpectedTargetTypes.contains(objectKind2))) {
                    return;
                }
                if (!refType.isQualified() && (kind = refType.getTargetKind()) != SqlDbElementType.ANY && dialect.getSuperKind(objectKind2) != dialect.getSuperKind(kind)) {
                    return;
                }
            }
            if (triggerFunctionExpected) {
                if (!(dasObject instanceof DasRoutine)) {
                    return;
                }
                DasArgument returnArgument = ((DasRoutine)dasObject).getReturnArgument();
                if (returnArgument == null) {
                    return;
                }
                if (!dialect.getTypeSystem().isTriggerFunctionType(returnArgument.getDasType())) {
                    return;
                }
            }
            if (dasObject instanceof DasColumn && element instanceof PrioritizedLookupElement && ((PrioritizedLookupElement)element).getPriority() >= 10.0) {
                hasSourceColumns.set((Object)true);
            }
            if (originalPosition != null && symbol instanceof SqlDefinition && (ne = ((SqlDefinition)symbol).getNameElement()) != null && PsiTreeUtil.isContextAncestor((PsiElement)ne, (PsiElement)originalPosition, (boolean)false)) {
                return;
            }
            LookupElement lookupElement = element;
            lookupElement = SqlReferenceExpressionCompletionProvider.adjustBySimilarity(lookupElement, SqlReferenceExpressionCompletionProvider.getSimilarity(namingService, columnsNamesFromSelectForTableRef, (SqlTableType)fromType.get(), dasObject));
            if (dasObject != null && !strictTypes.contains(targetKind) && (restrainNonStrict || targetKind == ObjectKind.SCHEMA || targetKind == ObjectKind.DATABASE)) {
                restrainedElements.add(lookupElement);
                return;
            }
            if (tablesForJoin.contains(dasObject) || SqlReferenceExpressionCompletionProvider.isHighPriorityAliasedColumn(parameters, dasObject, dialect, leftExpectedCategory, isEq, leftColumn, position)) {
                lookupElement = SqlReferenceExpressionCompletionProvider.elevatePriority(lookupElement, 90.0);
            }
            resultSet.addElement(lookupElement);
        }), parameters, (element, q) -> {
            if ((element instanceof DasColumn || element instanceof SqlAsExpression && !SqlReferenceExpressionCompletionProvider.isQueryExpression(((SqlAsExpression)element).getExpression())) && (isValidSelectClause || SqlReferenceExpressionCompletionProvider.acceptBySelectAndQualifier(namingService, columnsNamesFromSelectForColumnRef, element, qualifierTable))) {
                if (columnsAtOnce.add(element)) {
                    qualifiers.add((PsiElement)q);
                }
            } else if (element instanceof DasRoutine && element instanceof PsiNamedElement) {
                existingFunctionNames.add(element.getName());
            }
        });
        for (LookupElement restrainedElement : restrainedElements) {
            resultSet.addElement(restrainedElement);
        }
        if (columnsAtOnce.size() > 1 && (element2 = SqlCompletionUtil.createAllColumnsLookupElement(columnsAtOnce, project, dialect, !columnsNamesFromSelectForColumnRef.isEmpty() && SqlReferenceExpressionCompletionProvider.requiresFullSpecInOrderBy(dbms) ? 149 : ((Boolean)hasSourceColumns.get() != false ? 10 : 5), false, SqlCompletionUtil.canQualify((IElementType)refType), qualifiers, dbms)) != null) {
            resultSet.addElement(element2);
        }
        SqlFunctionDefinitionCompletions.addFunctionDefinitionCompletions(parameters, result, existingFunctionNames);
    }

    private static boolean isHighPriorityAliasedColumn(@NotNull CompletionParameters parameters, DasObject dasObject, SqlLanguageDialectEx dialect, DasTypeCategory leftExpectedCategory, boolean isEq, DasColumn leftColumn, PsiElement position) {
        if (parameters == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(3);
        }
        if (!(dasObject instanceof DasColumn)) {
            return false;
        }
        DasColumn columnInfo = (DasColumn)dasObject;
        DataType dataType = columnInfo.getDasType().toDataType();
        DasType byJdbc = dialect.getTypeSystem().getDefaultType(DasTypeCategory.findByJdbcType((int)dataType.jdbcType));
        DasType byName = columnInfo.getDasType();
        if (!(DasTypeUtilsKt.is((DasType)byJdbc, (DasTypeCategory)leftExpectedCategory) || byJdbc != byName && DasTypeUtilsKt.is((DasType)byName, (DasTypeCategory)leftExpectedCategory))) {
            return false;
        }
        DasTable table = columnInfo.getTable();
        if (table == null) {
            return false;
        }
        return parameters.getInvocationCount() > 1 || !isEq || leftColumn != null && SqlReferenceExpressionCompletionProvider.areColumnsConnected(position.getProject(), leftColumn, columnInfo);
    }

    private static List<String> collectGroupByItems(SqlGroupByClause groupByClause) {
        SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)groupByClause, SqlQueryExpression.class);
        if (queryExpression == null) {
            return Collections.emptyList();
        }
        SqlSelectClause selectClause = queryExpression.getSelectClause();
        JBIterable expressions = selectClause != null ? JBIterable.from((Iterable)selectClause.getExpressions()) : JBIterable.empty();
        return (List)JBIterable.from((Iterable)expressions).filter(e -> {
            final boolean[] isAggregate = new boolean[]{false};
            if (SqlImplUtil.isAsteriskRef((PsiElement)e)) {
                return false;
            }
            e.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof SqlFunctionCallExpression && SqlPsiUtilCoreKt.isAggregateCall((SqlFunctionCallExpression)element)) {
                        isAggregate[0] = true;
                        this.stopWalking();
                    }
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/completion/providers/SqlReferenceExpressionCompletionProvider$1", "visitElement"));
                }
            });
            return !isAggregate[0];
        }).map(e -> {
            SqlExpression unwrapped = e instanceof SqlAsExpression ? ((SqlAsExpression)e).getExpression() : e;
            return unwrapped != null ? unwrapped.getText() : null;
        }).filter(Conditions.notNull()).addAllTo(new ArrayList());
    }

    private static boolean isQueryExpression(@Nullable SqlExpression expression) {
        if (expression instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)expression).getReferenceElementType().getTargetKind() != ObjectKind.COLUMN;
        }
        if (expression instanceof SqlResultSetExpression) {
            return true;
        }
        if (!(expression instanceof SqlParenthesizedExpression)) {
            return false;
        }
        List expressions = ((SqlParenthesizedExpression)expression).getExpressionList();
        if (expressions.size() != 1) {
            return false;
        }
        return SqlReferenceExpressionCompletionProvider.isQueryExpression((SqlExpression)expressions.get(0));
    }

    private static boolean requiresFullSpecInOrderBy(@NotNull Dbms dbms) {
        if (dbms == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(4);
        }
        return dbms.isMicrosoft() || dbms.isOracle();
    }

    private static PsiElement getQualifyingEntity(@Nullable SqlReferenceExpression qualifier) {
        return qualifier == null ? null : qualifier.resolve();
    }

    private static DasTable getQualifyingTable(@Nullable PsiElement qualifyingElement) {
        SqlExpression expression;
        PsiElement qualifier = qualifyingElement instanceof SqlAsExpression ? ((expression = ((SqlAsExpression)qualifyingElement).getExpression()) instanceof SqlReferenceExpression ? ((SqlReferenceExpression)expression).resolve() : null) : qualifyingElement;
        return (DasTable)ObjectUtils.tryCast((Object)qualifier, DasTable.class);
    }

    private static boolean acceptBySelectAndQualifier(NamingService namingService, Set<String> columnsNamesFromSelectForColumnRef, DasObject element, DasTable qualifierTable) {
        if (!SqlReferenceExpressionCompletionProvider.isStar(columnsNamesFromSelectForColumnRef, namingService) && !columnsNamesFromSelectForColumnRef.contains(namingService.enquote(element.getName(), element.getKind()))) {
            return false;
        }
        return qualifierTable == null || qualifierTable.equals((Object)element.getDasParent());
    }

    private static boolean isStar(Set<String> columnRefs, NamingService namingService) {
        return columnRefs.size() == 1 && namingService.enquote("*", ObjectKind.COLUMN).equals(columnRefs.iterator().next());
    }

    private static void collectColumnsFromSelect(@NotNull SqlExpression expression, final @NotNull NamingService namingService, final @NotNull Set<String> columnsNamesFromSelect) {
        SqlQueryExpression query;
        SqlSelectClause select;
        if (expression == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(5);
        }
        if (namingService == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(6);
        }
        if (columnsNamesFromSelect == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(7);
        }
        SqlSelectClause sqlSelectClause = select = (query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlQueryExpression.class)) != null ? query.getSelectClause() : null;
        if (select != null) {
            select.accept(new SqlVisitor(){

                public void visitSqlReferenceExpression(SqlReferenceExpression e) {
                    if (e.getQualifierExpression() == null && e.getReferenceElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
                        columnsNamesFromSelect.add(namingService.enquote(e.getName(), e.getKind()));
                    }
                }

                public void visitSqlElement(SqlElement e) {
                    for (PsiElement element = e.getFirstChild(); element != null; element = element.getNextSibling()) {
                        if (!(element instanceof SqlElement)) continue;
                        ((SqlElement)element).accept((SqlVisitor)this);
                    }
                }
            });
        }
    }

    private static boolean areColumnsConnected(@NotNull Project project, @NotNull DasColumn c1, @NotNull DasColumn c2) {
        String n2;
        String n1;
        DasTable t2;
        DasTable t1;
        if (project == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(8);
        }
        if (c1 == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(9);
        }
        if (c2 == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(10);
        }
        return SqlReferenceExpressionCompletionProvider.isInFk(project, t1 = c1.getTable(), t2 = c2.getTable(), n1 = c1.getName(), n2 = c2.getName()) || SqlReferenceExpressionCompletionProvider.isInFk(project, t2, t1, n2, n1);
    }

    private static boolean isInFk(@NotNull Project project, @Nullable DasTable t1, @Nullable DasTable t2, @Nullable String n1, @Nullable String n2) {
        if (project == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(11);
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        for (DasForeignKey fk : ModelRelationManager.getForeignKeys((Project)project, (DasTable)t1, (DasTable)t2)) {
            Iterator it1 = fk.getColumnsRef().names().iterator();
            Iterator it2 = fk.getRefColumns().names().iterator();
            while (it1.hasNext() && it2.hasNext()) {
                if (!Comparing.equal((String)n2, (String)((String)it2.next()), (boolean)false) || !Comparing.equal((String)n1, (String)((String)it1.next()), (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    private static int getInitialSimilarity(@Nullable SqlTableType fromType, @Nullable DasObject tgt) {
        if (fromType == null) {
            return 0;
        }
        boolean isColumn = tgt instanceof DasColumn;
        boolean isTable = tgt instanceof DasTable;
        if (!isColumn && !isTable) {
            return 0;
        }
        for (int i = 0; i < fromType.getColumnCount(); ++i) {
            if (isColumn && fromType.getColumnElement(i).equals((Object)tgt)) {
                return 2;
            }
            if (!isTable || !Comparing.equal((Object)fromType.getColumnQualifier(i), (Object)tgt)) continue;
            return 1;
        }
        return 0;
    }

    private static int getSimilarity(@NotNull NamingService namingService, @NotNull Set<String> columnsNamesFromSelect, @Nullable SqlTableType fromType, @Nullable DasObject tgt) {
        if (namingService == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(12);
        }
        if (columnsNamesFromSelect == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(13);
        }
        int similarity = SqlReferenceExpressionCompletionProvider.getInitialSimilarity(fromType, tgt);
        if (columnsNamesFromSelect.isEmpty() || !(tgt instanceof DasTable)) {
            return similarity;
        }
        for (DasColumn c : DasUtil.getColumns((DasObject)tgt)) {
            if (!columnsNamesFromSelect.contains(namingService.enquote(c.getName(), c.getKind()))) continue;
            ++similarity;
        }
        return similarity;
    }

    @NotNull
    private static LookupElement adjustBySimilarity(@NotNull LookupElement element, int similarity) {
        if (element == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(14);
        }
        if (similarity == 0) {
            LookupElement lookupElement = element;
            if (lookupElement == null) {
                SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(15);
            }
            return lookupElement;
        }
        int factorizedSimilarity = similarity * 10;
        double priority = element instanceof PrioritizedLookupElement ? ((PrioritizedLookupElement)element).getPriority() : 0.0;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)element, (double)(priority + (double)factorizedSimilarity));
        if (lookupElement == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(16);
        }
        return lookupElement;
    }

    @NotNull
    private static LookupElement elevatePriority(@NotNull LookupElement element, double upTo) {
        double d;
        if (element == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(17);
        }
        if (element instanceof PrioritizedLookupElement) {
            PrioritizedLookupElement prioritized = (PrioritizedLookupElement)element;
            d = prioritized.getPriority();
        } else {
            d = 0.0;
        }
        double priority = d;
        LookupElement lookupElement = priority < upTo ? PrioritizedLookupElement.withPriority((LookupElement)element, (double)upTo) : element;
        if (lookupElement == null) {
            SqlReferenceExpressionCompletionProvider.$$$reportNull$$$0(18);
        }
        return lookupElement;
    }

    private static /* synthetic */ boolean lambda$doAddCompletions$0(String fullPrefix, String item) {
        return StringUtil.startsWithIgnoreCase((String)item, (String)fullPrefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsNamesFromSelect";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/providers/SqlReferenceExpressionCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlReferenceExpressionCompletionProvider";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustBySimilarity";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "elevatePriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doAddCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isHighPriorityAliasedColumn";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requiresFullSpecInOrderBy";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectColumnsFromSelect";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "areColumnsConnected";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInFk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSimilarity";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "adjustBySimilarity";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "elevatePriority";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 18 -> new IllegalStateException(string);
        };
    }
}

