/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections.expressions;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0004H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/expressions/ExplicitThisExpressionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "text", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "thisExpression", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.kotlin.codeInsight.inspections"})
public final class ExplicitThisExpressionFix
extends KotlinModCommandQuickFix<KtThisExpression> {
    @NotNull
    private final String text;

    public ExplicitThisExpressionFix(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.text};
        return KotlinBundle.message((String)"explicit.this.expression.fix.family.name", (Object[])objectArray);
    }

    @Override
    protected void applyFix(@NotNull Project project, @NotNull KtThisExpression thisExpression, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)thisExpression, (String)"thisExpression");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        PsiElement parent = thisExpression.getParent();
        if (parent instanceof KtDotQualifiedExpression) {
            KtExpression ktExpression = ((KtDotQualifiedExpression)parent).getSelectorExpression();
            if (ktExpression == null) {
                return;
            }
            ((KtDotQualifiedExpression)parent).replace((PsiElement)ktExpression);
        } else if (parent instanceof KtCallableReferenceExpression) {
            thisExpression.delete();
        }
    }
}

