/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mpp.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.kotlin.commonNative.debugger.KonanHelper;
import com.jetbrains.kotlin.commonNative.debugger.workspace.WorkspaceBase;
import com.jetbrains.mpp.KotlinMppBundle;
import com.jetbrains.mpp.MPPWorkspace;
import com.jetbrains.mpp.debugger.HostMachine;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.TargetSupportException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/mpp/debugger/GradleLLDBDriverConfiguration;", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lldbHome", "Ljava/io/File;", "getLldbHome", "()Ljava/io/File;", "lldbHome$delegate", "Lkotlin/Lazy;", "hostMachine", "Lcom/jetbrains/mpp/debugger/HostMachine;", "framework", "", "getLLDBFrameworkFile", "architecture", "Lcom/jetbrains/cidr/ArchitectureType;", "getLLDBFrontendFile", "copyToKonan", "binaryInPlugin", "createDriver", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver;", "handler", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;", "architectureType", "useSTLRenderers", "", "kotlin-ultimate.ultimate-native"})
@SourceDebugExtension(value={"SMAP\nGradleLLDBDriverConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleLLDBDriverConfiguration.kt\ncom/jetbrains/mpp/debugger/GradleLLDBDriverConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,78:1\n1#2:79\n30#3,2:80\n*S KotlinDebug\n*F\n+ 1 GradleLLDBDriverConfiguration.kt\ncom/jetbrains/mpp/debugger/GradleLLDBDriverConfiguration\n*L\n33#1:80,2\n*E\n"})
public final class GradleLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy lldbHome$delegate;
    @NotNull
    private final HostMachine hostMachine;
    @NotNull
    private final String framework;

    public GradleLLDBDriverConfiguration(@NotNull Project project) {
        HostMachine hostMachine;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lldbHome$delegate = LazyKt.lazy(() -> GradleLLDBDriverConfiguration.lldbHome_delegate$lambda$0(this));
        KonanTarget konanTarget = HostManager.Companion.getHost();
        if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_ARM64.INSTANCE)) {
            hostMachine = HostMachine.Mac;
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) {
            hostMachine = HostMachine.Linux;
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE)) {
            hostMachine = HostMachine.Windows;
        } else {
            throw new TargetSupportException("Unsupported host target: " + HostManager.Companion.hostOs() + " " + HostManager.Companion.hostArch(), null, 2, null);
        }
        this.hostMachine = hostMachine;
        this.framework = switch (WhenMappings.$EnumSwitchMapping$0[this.hostMachine.ordinal()]) {
            case 1 -> "LLDB.framework";
            case 2 -> "lib/liblldb.so";
            case 3 -> "bin/liblldb.dll";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final File getLldbHome() {
        Lazy lazy = this.lldbHome$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    protected File getLLDBFrameworkFile(@NotNull ArchitectureType architecture) {
        Intrinsics.checkNotNullParameter((Object)architecture, (String)"architecture");
        return FilesKt.resolve((File)this.getLldbHome(), (String)this.framework);
    }

    @NotNull
    protected File getLLDBFrontendFile(@NotNull ArchitectureType architecture) {
        Intrinsics.checkNotNullParameter((Object)architecture, (String)"architecture");
        File file = super.getLLDBFrontendFile(architecture);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getLLDBFrontendFile(...)");
        File binaryInPlugin = file;
        return switch (WhenMappings.$EnumSwitchMapping$0[this.hostMachine.ordinal()]) {
            case 2 -> this.copyToKonan(binaryInPlugin);
            case 1, 3 -> binaryInPlugin;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final File copyToKonan(File binaryInPlugin) {
        File file;
        File binaryInKonan = FilesKt.resolve((File)this.getLldbHome(), (String)"bin/LLDBFrontend");
        FilesKt.copyTo$default((File)binaryInPlugin, (File)binaryInKonan, (boolean)true, (int)0, (int)4, null);
        File $this$copyToKonan_u24lambda_u240 = file = binaryInKonan;
        boolean bl = false;
        $this$copyToKonan_u24lambda_u240.setExecutable(true);
        return file;
    }

    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler2, @NotNull ArchitectureType architectureType) {
        LLDBDriver lLDBDriver;
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
        String pythonHelpersPath = KonanHelper.INSTANCE.getPythonHelpersPathBy(this.project);
        LLDBDriver lLDBDriver2 = super.createDriver(handler2, architectureType);
        Intrinsics.checkNotNullExpressionValue((Object)lLDBDriver2, (String)"createDriver(...)");
        LLDBDriver $this$createDriver_u24lambda_u240 = lLDBDriver = lLDBDriver2;
        boolean bl = false;
        $this$createDriver_u24lambda_u240.setAutorunScriptName(pythonHelpersPath);
        return lLDBDriver;
    }

    public boolean useSTLRenderers() {
        return false;
    }

    private static final File lldbHome_delegate$lambda$0(GradleLLDBDriverConfiguration this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<WorkspaceBase> serviceClass$iv = WorkspaceBase.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Object object2 = object;
        MPPWorkspace mPPWorkspace = object2 instanceof MPPWorkspace ? (MPPWorkspace)object2 : null;
        if (mPPWorkspace == null) {
            throw new ExecutionException(KotlinMppBundle.message("workspace.error.lldbNotFound", new Object[0]));
        }
        MPPWorkspace baseService = mPPWorkspace;
        File file = baseService.getLldbHome();
        if (file == null) {
            throw new ExecutionException(KotlinMppBundle.message("workspace.error.lldbNotFound", new Object[0]));
        }
        return file;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HostMachine.values().length];
            try {
                nArray[HostMachine.Mac.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HostMachine.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HostMachine.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

