/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.providers;

import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.oas.SpringMvcOasConverters;
import com.intellij.spring.mvc.providers.SpringMvcServerProvider;
import com.intellij.spring.mvc.services.SpringMvcService;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringMvcControllersEndpointsProvider
extends SpringMvcServerProvider
implements EndpointsUrlTargetProvider<SpringBeanPointer<?>, UrlMappingElement> {
    public SpringMvcControllersEndpointsProvider() {
        super("Spring-MVC-Controllers", "Spring MVC Controllers");
    }

    @NotNull
    public EndpointType getEndpointType() {
        EndpointType endpointType = EndpointTypes.HTTP_SERVER_TYPE;
        if (endpointType == null) {
            SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(0);
        }
        return endpointType;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        if (project == null) {
            SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(1);
        }
        if (!SpringMvcLibraryUtil.hasSpringMvcLibrary(project) && !SpringMvcLibraryUtil.hasWebfluxLibrary(project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.UNAVAILABLE;
            if (status == null) {
                SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(2);
            }
            return status;
        }
        if (SpringMvcLibraryUtil.isSpringMVCEnabled(project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.HAS_ENDPOINTS;
            if (status == null) {
                SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(3);
            }
            return status;
        }
        EndpointsProvider.Status status = EndpointsProvider.Status.AVAILABLE;
        if (status == null) {
            SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(4);
        }
        return status;
    }

    @NotNull
    public Iterable<SpringBeanPointer<?>> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        if (project == null) {
            SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(5);
        }
        if (filter == null) {
            SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(6);
        }
        if (!(filter instanceof ModuleEndpointsFilter)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        ModuleEndpointsFilter moduleFilter = (ModuleEndpointsFilter)filter;
        Module module = moduleFilter.getModule();
        if (!SpringMvcLibraryUtil.hasSpringMvcLibrary(module) && !SpringMvcLibraryUtil.hasWebfluxLibrary(module)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        Set<SpringBeanPointer<?>> allControllers = SpringMvcService.getInstance().getBeanControllers(module);
        Iterable iterable = moduleFilter.filterByScope(allControllers, SpringBeanPointer::getContainingFile);
        if (iterable == null) {
            SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(9);
        }
        return iterable;
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        if (project == null) {
            SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(10);
        }
        ModificationTracker modificationTracker = SpringModificationTrackersManager.getInstance((Project)project).getEndpointsModificationTracker();
        if (modificationTracker == null) {
            SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(11);
        }
        return modificationTracker;
    }

    @Nullable
    public OpenApiSpecification getOpenApiSpecification(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint) {
        if (group == null) {
            SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(12);
        }
        if (endpoint == null) {
            SpringMvcControllersEndpointsProvider.$$$reportNull$$$0(13);
        }
        return SpringMvcOasConverters.getMvcOpenApiSpecification(endpoint, this.findUrlTargetInfo(group, endpoint));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5, 6, 10, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/providers/SpringMvcControllersEndpointsProvider";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointType";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/providers/SpringMvcControllersEndpointsProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointGroups";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointGroups";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOpenApiSpecification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 5, 6, 10, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

