/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop.highlighting;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopProvider;
import com.intellij.aop.jam.utils.AopModelSearchers;
import com.intellij.aop.jam.utils.AopModelUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.concurrency.JobScheduler;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.aop.SpringAdvisedElementsSearcher;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.aop.highlighting.EnableAspectJQuickFix;
import com.intellij.spring.aop.model.xml.AopConfig;
import com.intellij.spring.aop.model.xml.AspectjAutoproxy;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.Idref;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JdkProxiedBeanTypeInspection
extends SpringBeanInspectionBase {
    private static final Key<CachedValue<Set<PsiClass>>> REPLACE_CLASS = Key.create((String)"ReplaceClassWithInterfaces");
    private static volatile boolean FORCE_TIMEOUT = false;

    protected SpringModelVisitor createVisitor(final DomElementAnnotationHolder holder, @NotNull Beans beans, @Nullable CommonSpringModel model) {
        if (beans == null) {
            JdkProxiedBeanTypeInspection.$$$reportNull$$$0(0);
        }
        return new SpringModelVisitor(this){

            protected boolean visitValueHolder(SpringValueHolder valueHolder) {
                Idref idref;
                List types = TypeHolderUtil.getRequiredTypes((TypeHolder)valueHolder);
                if (types.size() != 1 || !(types.get(0) instanceof PsiClassType)) {
                    return true;
                }
                PsiClass psiClass = ((PsiClassType)types.get(0)).resolve();
                if (psiClass == null || psiClass.isInterface()) {
                    return true;
                }
                JdkProxiedBeanTypeInspection.checkReference(valueHolder.getRefAttr(), holder);
                SpringRef ref = valueHolder.getRef();
                if (DomUtil.hasXml((DomElement)ref)) {
                    JdkProxiedBeanTypeInspection.checkReference(ref.getBean(), holder);
                    JdkProxiedBeanTypeInspection.checkReference(ref.getLocal(), holder);
                    JdkProxiedBeanTypeInspection.checkReference(ref.getParentAttr(), holder);
                }
                if (DomUtil.hasXml((DomElement)(idref = valueHolder.getIdref()))) {
                    JdkProxiedBeanTypeInspection.checkReference(idref.getBean(), holder);
                    JdkProxiedBeanTypeInspection.checkReference(idref.getLocal(), holder);
                }
                return true;
            }
        };
    }

    private static void checkReference(GenericDomValue<SpringBeanPointer<?>> springBean, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml(springBean)) {
            return;
        }
        SpringBeanPointer pointer = (SpringBeanPointer)springBean.getValue();
        if (pointer != null) {
            ScheduledFuture<?> scheduledFuture;
            PsiClass psiClass = pointer.getBeanClass();
            if (psiClass == null || psiClass.isInterface()) {
                return;
            }
            HashSet interfaces = new HashSet();
            SensitiveProgressWrapper progress = new SensitiveProgressWrapper(ProgressManager.getInstance().getProgressIndicator());
            Runnable cancelOnTimeOut = () -> ((SensitiveProgressWrapper)progress).cancel();
            long delay = ApplicationManager.getApplication().isUnitTestMode() ? 2000L : 200L;
            ScheduledFuture<?> scheduledFuture2 = scheduledFuture = FORCE_TIMEOUT ? null : JobScheduler.getScheduler().schedule(cancelOnTimeOut, delay, TimeUnit.MILLISECONDS);
            if (FORCE_TIMEOUT) {
                cancelOnTimeOut.run();
            }
            try {
                ProgressManager.getInstance().runProcess(() -> {
                    progress.checkCanceled();
                    interfaces.addAll(JdkProxiedBeanTypeInspection.getInterfacesToReplaceClassWith(psiClass));
                }, (ProgressIndicator)progress);
            }
            catch (ProcessCanceledException e) {
                if (FORCE_TIMEOUT) {
                    holder.createProblem(springBean, ProblemHighlightType.WEAK_WARNING, SpringAopBundle.message("JdkProxiedBeanTypeInspection.could.not.determine.type", new Object[0]), null, JdkProxiedBeanTypeInspection.createFixes(springBean));
                    return;
                }
                throw e;
            }
            finally {
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(true);
                }
            }
            if (!interfaces.isEmpty()) {
                String s = StringUtil.join((Collection)ContainerUtil.map(interfaces, PsiClass::getQualifiedName), (String)", ");
                holder.createProblem(springBean, HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, SpringAopBundle.message("jdk.proxy.intercepts.class", s), JdkProxiedBeanTypeInspection.createFixes(springBean));
            }
        }
    }

    private static LocalQuickFix[] createFixes(DomElement annotatedElement) {
        LocalQuickFix[] localQuickFixArray;
        if (EnableAspectJQuickFix.isSchemaStyle(DomUtil.getFileElement((DomElement)annotatedElement).getRootElement().getXmlTag())) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = new SwitchToCglibProxyingFix();
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        return localQuickFixArray;
    }

    private static Set<PsiClass> getInterfacesToReplaceClassWith(final PsiClass psiClass) {
        CachedValue classes = (CachedValue)psiClass.getUserData(REPLACE_CLASS);
        if (classes == null) {
            classes = CachedValuesManager.getManager((Project)psiClass.getProject()).createCachedValue(() -> (CachedValueProvider.Result)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CachedValueProvider.Result<Set<PsiClass>>>(){

                public CachedValueProvider.Result<Set<PsiClass>> compute() {
                    ProgressManager.checkCanceled();
                    for (AopProvider provider : AopModelSearchers.getAopProviders((PsiClass)psiClass)) {
                        SpringAdvisedElementsSearcher searcher;
                        AopAdvisedElementsSearcher elementsSearcher = provider.getAdvisedElementsSearcher(psiClass);
                        if (!(elementsSearcher instanceof SpringAdvisedElementsSearcher) || !(searcher = (SpringAdvisedElementsSearcher)elementsSearcher).isJdkProxyType() || !JdkProxiedBeanTypeInspection.isAdvised(psiClass)) continue;
                        HashSet interfaces = new HashSet();
                        JamCommonUtil.processSuperClassList((PsiClass)psiClass, (Collection)new ArrayListSet(), psiClass1 -> {
                            ContainerUtil.addAll((Collection)interfaces, (Object[])psiClass1.getInterfaces());
                            return true;
                        });
                        return CachedValueProvider.Result.create(interfaces, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                    return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            }), false);
            psiClass.putUserData(REPLACE_CLASS, (Object)classes);
        }
        return (Set)classes.getValue();
    }

    private static boolean isAdvised(PsiClass psiClass) {
        return !AopModelUtils.getBoundAdvices((PsiClass)psiClass).isEmpty() || !AopModelUtils.getBoundIntroductions((PsiClass)psiClass).isEmpty();
    }

    @TestOnly
    public static void setForceTimeout(boolean active) {
        FORCE_TIMEOUT = active;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/aop/highlighting/JdkProxiedBeanTypeInspection", "createVisitor"));
    }

    private static class SwitchToCglibProxyingFix
    implements LocalQuickFix {
        private SwitchToCglibProxyingFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringAopBundle.message("use.cglib.proxying", new Object[0]);
            if (string == null) {
                SwitchToCglibProxyingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            DomElement domElement;
            if (project == null) {
                SwitchToCglibProxyingFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                SwitchToCglibProxyingFix.$$$reportNull$$$0(2);
            }
            if ((domElement = DomUtil.getDomElement((PsiElement)(element = descriptor.getPsiElement()))) == null) {
                return;
            }
            DomElement rootElement = DomUtil.getFileElement((DomElement)domElement).getRootElement();
            if (rootElement instanceof Beans) {
                Beans beans = (Beans)rootElement;
                List configs = DomUtil.getDefinedChildrenOfType((DomElement)beans, AopConfig.class, (boolean)true, (boolean)false);
                if (!configs.isEmpty()) {
                    ((AopConfig)configs.get(0)).getProxyTargetClass().setValue((Object)Boolean.TRUE);
                    return;
                }
                List autoproxyList = DomUtil.getDefinedChildrenOfType((DomElement)beans, AspectjAutoproxy.class, (boolean)true, (boolean)false);
                if (autoproxyList.isEmpty()) {
                    EnableAspectJQuickFix.addAspectjAutoproxy(beans.getXmlTag());
                    autoproxyList = DomUtil.getDefinedChildrenOfType((DomElement)beans, AspectjAutoproxy.class, (boolean)true, (boolean)false);
                }
                ((AspectjAutoproxy)autoproxyList.get(0)).getProxyTargetClass().setValue((Object)Boolean.TRUE);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/aop/highlighting/JdkProxiedBeanTypeInspection$SwitchToCglibProxyingFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/aop/highlighting/JdkProxiedBeanTypeInspection$SwitchToCglibProxyingFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

