/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitInstaller;
import git4idea.config.GitVersion;
import git4idea.config.MacExecutableProblemHandler;
import git4idea.config.NotificationErrorNotifier;
import git4idea.config.WindowsExecutableProblemHandler;
import git4idea.i18n.GitBundle;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u001a\b\u0010\u000b\u001a\u00020\fH\u0001\u001a&\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u0012H\u0000\u001a\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0002\u001a\b\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0002\u001a\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u001c\u001a\u00020\u0019H\u0002\u001a(\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020 H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"feedUrl", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "downloadAndInstallGit", "", "project", "Lcom/intellij/openapi/project/Project;", "onSuccess", "Lkotlin/Function0;", "getLatestAvailableVersion", "Lgit4idea/config/GitVersion;", "fetchInstaller", "Lgit4idea/config/GitInstaller;", "errorNotifier", "Lgit4idea/config/ErrorNotifier;", "condition", "Lkotlin/Function1;", "", "downloadListOfGitInstallers", "", "downloadGitJson", "", "readTree", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "rawData", "parse", "node", "downloadGit", "installer", "fileToSave", "Ljava/io/File;", "verifyHashCode", "downloadedFile", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDownloadAndInstall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDownloadAndInstall.kt\ngit4idea/config/GitDownloadAndInstallKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1#2:156\n808#3,11:157\n*S KotlinDebug\n*F\n+ 1 GitDownloadAndInstall.kt\ngit4idea/config/GitDownloadAndInstallKt\n*L\n116#1:157,11\n*E\n"})
public final class GitDownloadAndInstallKt {
    @NotNull
    private static final String feedUrl = "https://download.jetbrains.com/jdk/feed/v1/gits.json.xz";
    @NotNull
    private static final Logger LOG;

    public static final void downloadAndInstallGit(@NotNull Project project, @NotNull Function0<Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        NotificationErrorNotifier errorNotifier = new NotificationErrorNotifier(project);
        if (SystemInfo.isWindows) {
            new WindowsExecutableProblemHandler(project).downloadAndInstall$intellij_vcs_git(errorNotifier, onSuccess);
        } else if (SystemInfo.isMac) {
            new MacExecutableProblemHandler(project).downloadAndInstall$intellij_vcs_git(errorNotifier, onSuccess);
        }
    }

    public static /* synthetic */ void downloadAndInstallGit$default(Project project, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = GitDownloadAndInstallKt::downloadAndInstallGit$lambda$0;
        }
        GitDownloadAndInstallKt.downloadAndInstallGit(project, (Function0<Unit>)function0);
    }

    @RequiresBackgroundThread
    @NotNull
    public static final GitVersion getLatestAvailableVersion() {
        try {
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)GitDownloadAndInstallKt.downloadListOfGitInstallers()), GitDownloadAndInstallKt::getLatestAvailableVersion$lambda$0);
            Comparator comparator = new Comparator(){

                public final int compare(T a, T b) {
                    GitVersion it = (GitVersion)a;
                    boolean bl = false;
                    Comparable comparable = it;
                    it = (GitVersion)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it);
                }
            };
            Iterator iterator = sequence.iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            GitInstaller it = (GitInstaller)iterator.next();
            boolean bl = false;
            GitVersion gitVersion = GitVersion.parse("git version " + it.getVersion());
            Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"parse(...)");
            GitVersion gitVersion2 = gitVersion;
            while (iterator.hasNext()) {
                GitVersion gitVersion3;
                GitInstaller it2 = (GitInstaller)iterator.next();
                $i$a$-maxOfWith-GitDownloadAndInstallKt$getLatestAvailableVersion$3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)GitVersion.parse("git version " + it2.getVersion()), (String)"parse(...)");
                if (comparator.compare(gitVersion2, gitVersion3) >= 0) continue;
                gitVersion2 = gitVersion3;
            }
            return gitVersion2;
        }
        catch (Throwable e) {
            LOG.warn("Failed to check Git latest version", e);
            GitVersion gitVersion = GitVersion.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"NULL");
            return gitVersion;
        }
    }

    @Nullable
    public static final GitInstaller fetchInstaller(@NotNull ErrorNotifier errorNotifier, @NotNull Function1<? super GitInstaller, Boolean> condition) {
        Object v1;
        List<GitInstaller> installers;
        block4: {
            List<GitInstaller> list;
            Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            try {
                list = GitDownloadAndInstallKt.downloadListOfGitInstallers();
            }
            catch (Throwable t) {
                LOG.warn(t);
                String string = GitBundle.message((String)"install.general.error", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                errorNotifier.showError(string);
                return null;
            }
            installers = list;
            Iterable iterable = installers;
            for (Object t : iterable) {
                if (!((Boolean)condition.invoke(t)).booleanValue()) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        GitInstaller matchingInstaller = v1;
        if (matchingInstaller != null) {
            return matchingInstaller;
        }
        LOG.warn("Couldn't find installer among " + installers);
        String string = GitBundle.message((String)"install.general.error", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        errorNotifier.showError(string);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<GitInstaller> downloadListOfGitInstallers() {
        List<GitInstaller> list;
        byte[] compressedJson = GitDownloadAndInstallKt.downloadGitJson();
        try {
            byte[] byArray;
            list = new ByteArrayInputStream(compressedJson);
            Throwable throwable = null;
            try {
                byte[] byArray2;
                ByteArrayInputStream input = (ByteArrayInputStream)((Object)list);
                boolean bl = false;
                Closeable closeable = (Closeable)new XZInputStream((InputStream)input);
                Throwable throwable2 = null;
                try {
                    XZInputStream it = (XZInputStream)closeable;
                    boolean bl2 = false;
                    byArray2 = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                byArray = byArray2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)((Object)list), (Throwable)throwable);
            }
            list = (List<GitInstaller>)byArray;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to unpack the list of available Gits from https://download.jetbrains.com/jdk/feed/v1/gits.json.xz. " + t.getMessage(), t);
        }
        List<GitInstaller> jsonBytes = list;
        try {
            list = GitDownloadAndInstallKt.parse(GitDownloadAndInstallKt.readTree((byte[])jsonBytes));
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to parse the downloaded list of available Gits. " + t.getMessage(), t);
        }
        return list;
    }

    private static final byte[] downloadGitJson() {
        byte[] byArray = HttpRequests.request((String)feedUrl).productNameAsUserAgent().readBytes(ProgressManager.getInstance().getProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readBytes(...)");
        return byArray;
    }

    private static final ObjectNode readTree(byte[] rawData) {
        JsonNode jsonNode = new ObjectMapper().readTree(rawData);
        ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
        if (objectNode == null) {
            throw new IllegalStateException("Unexpected JSON data".toString());
        }
        return objectNode;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<GitInstaller> parse(ObjectNode node) {
        void $this$filterIsInstanceTo$iv$iv;
        JsonNode jsonNode = node.get("gits");
        ArrayNode arrayNode = jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
        if (arrayNode == null) {
            throw new IllegalStateException("`gits` element is missing in JSON".toString());
        }
        ArrayNode items = arrayNode;
        List result2 = new ArrayList();
        Iterable $this$filterIsInstance$iv = (Iterable)items;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ObjectNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ObjectNode item : (List)destination$iv$iv) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5 = item.get("os");
            if (object5 == null || (object5 = object5.asText()) == null || (object4 = item.get("arch")) == null || (object4 = object4.asText()) == null || (object3 = item.get("version")) == null || (object3 = object3.asText()) == null || (object2 = item.get("url")) == null || (object2 = object2.asText()) == null || (object = item.get("fileName")) == null || (object = object.asText()) == null) continue;
            JsonNode jsonNode2 = item.get("pkgFileName");
            Object object6 = item.get("sha256");
            if (object6 == null || (object6 = object6.asText()) == null) continue;
            Object object7 = object6;
            String string = jsonNode2 != null ? jsonNode2.asText() : null;
            Object object8 = object;
            Object object9 = object2;
            Object object10 = object3;
            Object object11 = object4;
            Object object12 = object5;
            result2.add(new GitInstaller((String)object12, (String)object11, (String)object10, (String)object9, (String)object8, string, (String)object7));
        }
        return result2;
    }

    public static final boolean downloadGit(@NotNull GitInstaller installer, @NotNull File fileToSave, @NotNull Project project, @NotNull ErrorNotifier errorNotifier) {
        Intrinsics.checkNotNullParameter((Object)installer, (String)"installer");
        Intrinsics.checkNotNullParameter((Object)fileToSave, (String)"fileToSave");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        try {
            HttpRequests.request((String)installer.getUrl()).productNameAsUserAgent().saveToFile(fileToSave, ProgressManager.getInstance().getProgressIndicator());
            GitDownloadAndInstallKt.verifyHashCode(installer, fileToSave);
            return true;
        }
        catch (Exception e) {
            LOG.warn("Couldn't download " + installer.getFileName() + " from " + installer.getUrl(), (Throwable)e);
            String string = GitBundle.message((String)"install.general.error", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            errorNotifier.showError(string, GitExecutableProblemHandlersKt.getLinkToConfigure(project));
            return false;
        }
    }

    private static final void verifyHashCode(GitInstaller installer, File downloadedFile) {
        String string = Files.asByteSource((File)downloadedFile).hash(Hashing.sha256()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String actualHashCode = string;
        if (!StringsKt.equals((String)actualHashCode, (String)installer.getSha256(), (boolean)true)) {
            throw new IllegalStateException("SHA-256 checksums does not match. Actual value is " + actualHashCode + ", expected " + installer.getSha256());
        }
    }

    private static final Unit downloadAndInstallGit$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final boolean getLatestAvailableVersion$lambda$0(GitInstaller it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getOs(), (Object)(SystemInfo.isWindows && WindowsExecutableProblemHandler.Companion.archMatches$intellij_vcs_git(it.getArch()) ? "windows" : (SystemInfo.isMac ? "macOS" : "undefined")));
    }

    static {
        Logger logger = Logger.getInstance((String)"#git4idea.config.GitDownloadAndInstall");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

