/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.k2.scriptingSupport;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.scriptingSupport.ScriptingEntitiesConsistencyVerifier;
import com.intellij.kotlin.jupyter.k2.project.model.SearchKt;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.KotlinNotebookScriptModelKt;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.NotebookScriptConfigurationsManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.KotlinType;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationConfigurationKeys;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.k2.configurations.ScriptConfigurationWithSdk;
import org.jetbrains.kotlin.idea.core.script.k2.configurations.ScriptProjectModelUtilsKt;
import org.jetbrains.kotlin.idea.core.script.k2.modules.KotlinScriptEntity;
import org.jetbrains.kotlin.idea.core.script.k2.modules.KotlinScriptLibraryEntity;
import org.jetbrains.kotlin.idea.core.script.k2.modules.KotlinScriptLibraryEntityId;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0002J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\u0006\u0010\u0012\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0097@\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/intellij/kotlin/jupyter/k2/scriptingSupport/ScriptingEntitiesConsistencyVerifierK2;", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/ScriptingEntitiesConsistencyVerifier;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "getFileUrlManager", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "getDependencyRootsForNotebook", "", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "checkSourceIsNotEmpty", "", "checkArtifactPresentInLibrary", "virtualFile", "lastCompiledScriptPath", "filterTypesPresentInIndexes", "Lkotlin/script/experimental/api/KotlinType;", "types", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isScriptPathConsistentWithModel", "isScriptFileConfigurationConsistentWithModel", "compilationConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "compareConfigurationsData", "current", "cached", "intellij.kotlin.jupyter.k2"})
@SourceDebugExtension(value={"SMAP\nScriptingEntitiesConsistencyVerifierK2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingEntitiesConsistencyVerifierK2.kt\ncom/intellij/kotlin/jupyter/k2/scriptingSupport/ScriptingEntitiesConsistencyVerifierK2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,138:1\n1617#2,9:139\n1869#2:148\n1870#2:150\n1626#2:151\n1460#2,5:152\n1761#2,3:159\n774#2:172\n865#2,2:173\n1#3:149\n30#4,2:157\n30#4,2:170\n13#5:162\n60#6,5:163\n37#7,2:168\n*S KotlinDebug\n*F\n+ 1 ScriptingEntitiesConsistencyVerifierK2.kt\ncom/intellij/kotlin/jupyter/k2/scriptingSupport/ScriptingEntitiesConsistencyVerifierK2\n*L\n45#1:139,9\n45#1:148\n45#1:150\n45#1:151\n46#1:152,5\n64#1:159,3\n90#1:172\n90#1:173,2\n45#1:149\n52#1:157,2\n103#1:170,2\n67#1:162\n67#1:163,5\n87#1:168,2\n*E\n"})
final class ScriptingEntitiesConsistencyVerifierK2
implements ScriptingEntitiesConsistencyVerifier {
    @NotNull
    private final Project project;

    public ScriptingEntitiesConsistencyVerifierK2(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final VirtualFileUrlManager getFileUrlManager() {
        return WorkspaceModelKt.getWorkspaceModel((Project)this.project).getVirtualFileUrlManager();
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VirtualFileUrl> getDependencyRootsForNotebook(BackedNotebookVirtualFile notebookFile) {
        void destination$iv;
        void $this$flatMapTo$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        ImmutableEntityStorage snapshot = WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot();
        KotlinScriptEntity kotlinScriptEntity = (KotlinScriptEntity)SequencesKt.singleOrNull(SearchKt.findK2WorkspaceScriptEntities(notebookFile, WorkspaceModelKt.getWorkspaceModel((Project)this.project)));
        if (kotlinScriptEntity == null) {
            return CollectionsKt.emptyList();
        }
        KotlinScriptEntity kotlinScriptEntity2 = kotlinScriptEntity;
        Iterable iterable = kotlinScriptEntity2.getDependencies();
        boolean $i$f$mapNotNull22 = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KotlinScriptLibraryEntity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KotlinScriptLibraryEntityId it = (KotlinScriptLibraryEntityId)element$iv$iv;
            boolean bl2 = false;
            if ((KotlinScriptLibraryEntity)snapshot.resolve((SymbolicEntityId)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Collection $i$f$mapNotNull22 = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            KotlinScriptLibraryEntity it = (KotlinScriptLibraryEntity)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getClasses();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return destination$iv;
    }

    private final boolean checkSourceIsNotEmpty(BackedNotebookVirtualFile notebookFile) {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<NotebookScriptConfigurationsManager> serviceClass$iv = NotebookScriptConfigurationsManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ConcurrentHashMap<VirtualFile, ScriptConfigurationWithSdk> scriptConfigurationsSource = ((NotebookScriptConfigurationsManager)object).getCache();
        return KotlinNotebookScriptModelKt.getConfigurationForNotebook((Map<VirtualFile, ScriptConfigurationWithSdk>)scriptConfigurationsSource, notebookFile.getFile()) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkArtifactPresentInLibrary(BackedNotebookVirtualFile virtualFile, VirtualFileUrl lastCompiledScriptPath) {
        boolean isPresent;
        Collection<VirtualFileUrl> jars;
        String artifactName;
        block5: {
            artifactName = lastCompiledScriptPath.getFileName();
            jars = this.getDependencyRootsForNotebook(virtualFile);
            Iterable $this$any$iv = jars;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFileUrl root = (VirtualFileUrl)element$iv;
                    boolean bl = false;
                    String string = root.getPresentableUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
                    Intrinsics.checkNotNull((Object)artifactName);
                    if (!StringsKt.endsWith$default((String)string, (String)artifactName, (boolean)false, (int)2, null)) continue;
                    v0 = true;
                    break block5;
                }
                v0 = isPresent = false;
            }
        }
        if (!isPresent) {
            void $this$debug_u24default$iv;
            ScriptingEntitiesConsistencyVerifierK2 $this$notebookLogger$iv = this;
            boolean $i$f$notebookLogger = false;
            $this$notebookLogger$iv = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(ScriptingEntitiesConsistencyVerifierK2.class));
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                void var12_15 = $this$debug_u24default$iv;
                boolean bl = false;
                String loggedRoots = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)CollectionsKt.toList((Iterable)jars), (int)10), (CharSequence)"\n", null, null, (int)0, null, ScriptingEntitiesConsistencyVerifierK2::checkArtifactPresentInLibrary$lambda$1$0, (int)30, null);
                var12_15.debug("For notebook " + virtualFile.getFile().getName() + " no dependency '" + artifactName + "' found among roots of size " + jars.size() + ", last roots:\n " + loggedRoots, e$iv);
            }
        }
        return isPresent;
    }

    @RequiresReadLock
    @Nullable
    public Object filterTypesPresentInIndexes(@NotNull BackedNotebookVirtualFile virtualFile, @NotNull Collection<KotlinType> types, @NotNull Continuation<? super Collection<KotlinType>> $completion) {
        List<VirtualDirectoryImpl> dependencies = SearchKt.findK2WorkspaceEntityDependencies(virtualFile, this.project);
        Collection $this$toTypedArray$iv = dependencies;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VirtualDirectoryImpl[] virtualDirectoryImplArray = thisCollection$iv.toArray(new VirtualDirectoryImpl[0]);
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)this.project, (boolean)true, (VirtualFile[])((VirtualFile[])Arrays.copyOf(virtualDirectoryImplArray, virtualDirectoryImplArray.length)));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"directoriesScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        return CoroutinesKt.smartReadAction((Project)this.project, () -> ScriptingEntitiesConsistencyVerifierK2.filterTypesPresentInIndexes$lambda$0(types, this, scope), $completion);
    }

    public boolean isScriptPathConsistentWithModel(@NotNull BackedNotebookVirtualFile virtualFile, @NotNull VirtualFileUrl lastCompiledScriptPath) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)lastCompiledScriptPath, (String)"lastCompiledScriptPath");
        return this.checkSourceIsNotEmpty(virtualFile) && this.checkArtifactPresentInLibrary(virtualFile, lastCompiledScriptPath);
    }

    public boolean isScriptFileConfigurationConsistentWithModel(@NotNull BackedNotebookVirtualFile virtualFile, @NotNull ScriptCompilationConfiguration compilationConfiguration) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)compilationConfiguration, (String)"compilationConfiguration");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<NotebookScriptConfigurationsManager> serviceClass$iv = NotebookScriptConfigurationsManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ConcurrentHashMap<VirtualFile, ScriptConfigurationWithSdk> configurationsCache = ((NotebookScriptConfigurationsManager)object).getCache();
        ScriptCompilationConfigurationWrapper configurationForNotebook = KotlinNotebookScriptModelKt.getConfigurationForNotebook((Map<VirtualFile, ScriptConfigurationWithSdk>)configurationsCache, virtualFile.getFile());
        if (configurationForNotebook == null) {
            return false;
        }
        ScriptCompilationConfiguration scriptCompilationConfiguration = configurationForNotebook.getConfiguration();
        if (scriptCompilationConfiguration == null) {
            return false;
        }
        ScriptCompilationConfiguration configuration = scriptCompilationConfiguration;
        boolean presentInConfigurationSource = this.compareConfigurationsData(compilationConfiguration, configuration);
        if (!presentInConfigurationSource) {
            return false;
        }
        Object object2 = (File)CollectionsKt.lastOrNull((List)configurationForNotebook.getDependenciesClassPath());
        if (object2 == null || (object2 = ((File)object2).getPath()) == null || (object2 = ScriptProjectModelUtilsKt.toVirtualFileUrl((String)object2, (VirtualFileUrlManager)this.getFileUrlManager())) == null) {
            return false;
        }
        Object lastDependencyVFUrl = object2;
        boolean presentInModuleDependencies = this.checkArtifactPresentInLibrary(virtualFile, (VirtualFileUrl)lastDependencyVFUrl);
        return presentInModuleDependencies;
    }

    private final boolean compareConfigurationsData(ScriptCompilationConfiguration current, ScriptCompilationConfiguration cached) {
        return Intrinsics.areEqual((Object)current.get(ScriptCompilationKt.getBaseClass((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion))), (Object)cached.get(ScriptCompilationKt.getBaseClass((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion)))) && Intrinsics.areEqual((Object)current.get(ScriptCompilationKt.getImplicitReceivers((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion))), (Object)cached.get(ScriptCompilationKt.getImplicitReceivers((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion)))) && Intrinsics.areEqual((Object)current.get(ScriptCompilationKt.getDependencies((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion))), (Object)cached.get(ScriptCompilationKt.getDependencies((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion))));
    }

    private static final CharSequence checkArtifactPresentInLibrary$lambda$1$0(VirtualFileUrl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPresentableUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List filterTypesPresentInIndexes$lambda$0(Collection $types, ScriptingEntitiesConsistencyVerifierK2 this$0, GlobalSearchScope $scope) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $types;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinType type = (KotlinType)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !KotlinFullClassNameIndex.Helper.get(type.getTypeName(), this$0.project, $scope).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

