/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesLogFilterService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myFilters", "", "Lcom/intellij/execution/filters/Filter;", "getMyFilters", "()Ljava/util/List;", "myFilters$delegate", "Lkotlin/Lazy;", "myCompositeFilter", "Lcom/intellij/execution/filters/CompositeFilter;", "getMyCompositeFilter", "()Lcom/intellij/execution/filters/CompositeFilter;", "myCompositeFilter$delegate", "myAlarm", "Lcom/intellij/util/Alarm;", "enqueueHeavyFiltering", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "eventOffset", "", "event", "", "dispose", "Companion", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogFilterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogFilterService.kt\ncom/intellij/kubernetes/logs/KubernetesLogFilterService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,102:1\n1#2:103\n1869#3,2:104\n1374#3:109\n1460#3,5:110\n1056#3:115\n1869#3,2:116\n1878#3,3:118\n4244#4:106\n4344#4,2:107\n*S KotlinDebug\n*F\n+ 1 KubernetesLogFilterService.kt\ncom/intellij/kubernetes/logs/KubernetesLogFilterService\n*L\n85#1:104,2\n32#1:109\n32#1:110,5\n33#1:115\n66#1:116,2\n93#1:118,3\n31#1:106\n31#1:107,2\n*E\n"})
public final class KubernetesLogFilterService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy myFilters$delegate;
    @NotNull
    private final Lazy myCompositeFilter$delegate;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private static final Key<HashSet<Integer>> markupHighlightedExceptionsKey;
    @NotNull
    private static final Key<EditorHyperlinkSupport> markupHyperlinkSupportKey;

    public KubernetesLogFilterService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myFilters$delegate = LazyKt.lazy(() -> KubernetesLogFilterService.myFilters_delegate$lambda$0(this));
        this.myCompositeFilter$delegate = LazyKt.lazy(() -> KubernetesLogFilterService.myCompositeFilter_delegate$lambda$0(this));
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    private final List<Filter> getMyFilters() {
        Lazy lazy = this.myFilters$delegate;
        return (List)lazy.getValue();
    }

    private final CompositeFilter getMyCompositeFilter() {
        Lazy lazy = this.myCompositeFilter$delegate;
        return (CompositeFilter)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueHeavyFiltering(@NotNull Editor editor, int eventOffset, @NotNull CharSequence event) {
        HashSet<Integer> set;
        Object it;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (editor.isDisposed()) {
            return;
        }
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        HashSet<Integer> hashSet = (HashSet<Integer>)markupModel2.getUserData(markupHighlightedExceptionsKey);
        if (hashSet == null) {
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            it = hashSet2;
            boolean bl = false;
            markupModel2.putUserData(markupHighlightedExceptionsKey, it);
            hashSet = hashSet2;
        }
        HashSet<Integer> hashSet3 = set = hashSet;
        synchronized (hashSet3) {
            boolean bl = false;
            if (set.contains(eventOffset)) {
                return;
            }
            bl = set.add(eventOffset);
        }
        Object object = (EditorHyperlinkSupport)markupModel2.getUserData(markupHyperlinkSupportKey);
        if (object == null) {
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            Object it2 = it = new EditorHyperlinkSupport(editor, project);
            boolean bl = false;
            markupModel2.putUserData(markupHyperlinkSupportKey, it2);
            object = it;
        }
        EditorHyperlinkSupport hyperlinkSupport = object;
        it = new char[1];
        it[0] = 10;
        List lines = StringsKt.split$default((CharSequence)event, (char[])it, (boolean)false, (int)0, (int)6, null);
        DocumentImpl subDoc = new DocumentImpl(event);
        int offset = 0;
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            KubernetesLogFilterService.enqueueHeavyFiltering$consumeResult(editor, eventOffset, hyperlinkSupport, markupModel2, this.getMyCompositeFilter().applyFilter(line, eventOffset + (offset += line.length())), false);
            ++offset;
        }
        this.myAlarm.addRequest(() -> KubernetesLogFilterService.enqueueHeavyFiltering$lambda$5(this, lines, subDoc, editor, eventOffset, hyperlinkSupport, markupModel2), 0);
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List myFilters_delegate$lambda$0(KubernetesLogFilterService this$0) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Object[] $this$filterNot$iv = ConsoleFilterProvider.FILTER_PROVIDERS.getExtensions();
        boolean $i$f$filterNot = false;
        Object[] objectArray = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (void element$iv$iv : $this$filterNotTo$iv$iv) {
            ConsoleFilterProvider provider = (ConsoleFilterProvider)element$iv$iv;
            boolean bl = false;
            String string = Reflection.getOrCreateKotlinClass(provider.getClass()).getQualifiedName();
            if (string != null ? StringsKt.startsWith$default((String)string, (String)"com.intellij.ml.llm", (boolean)false, (int)2, null) : false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterNotTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ConsoleFilterProvider it = (ConsoleFilterProvider)element$iv$iv;
            boolean bl = false;
            Filter[] filterArray = it.getDefaultFilters(this$0.project);
            Intrinsics.checkNotNullExpressionValue((Object)filterArray, (String)"getDefaultFilters(...)");
            Iterable list$iv$iv = ArraysKt.asIterable((Object[])filterArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Filter it = (Filter)a;
                boolean bl = false;
                int n = Intrinsics.areEqual((Object)it.getClass().getSimpleName(), (Object)"StackTraceFileFilter") ? -1 : 1;
                it = (Filter)b;
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(Intrinsics.areEqual((Object)it.getClass().getSimpleName(), (Object)"StackTraceFileFilter") ? -1 : 1));
            }
        });
    }

    private static final CompositeFilter myCompositeFilter_delegate$lambda$0(KubernetesLogFilterService this$0) {
        return new CompositeFilter(this$0.project, this$0.getMyFilters());
    }

    private static final void enqueueHeavyFiltering$consumeResult(Editor $editor, int $eventOffset, EditorHyperlinkSupport hyperlinkSupport, MarkupModel markupModel, Filter.Result result2, boolean addOffset) {
        if (result2 == null) {
            return;
        }
        if ($editor.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> KubernetesLogFilterService.enqueueHeavyFiltering$consumeResult$lambda$3($editor, addOffset, $eventOffset, result2, hyperlinkSupport, markupModel));
    }

    private static final void enqueueHeavyFiltering$consumeResult$lambda$3(Editor $editor, boolean $addOffset, int $eventOffset, Filter.Result $result, EditorHyperlinkSupport $hyperlinkSupport, MarkupModel $markupModel) {
        if ($editor.isDisposed()) {
            return;
        }
        int extraOffset = $addOffset ? $eventOffset : 0;
        List list = $result.getResultItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResultItems(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Filter.ResultItem it = (Filter.ResultItem)element$iv;
            boolean bl = false;
            HyperlinkInfo hyperlinkInfo = it.getHyperlinkInfo();
            int highlightStartOffset = it.getHighlightStartOffset() + extraOffset;
            int highlightEndOffset = it.getHighlightEndOffset() + extraOffset;
            if (highlightEndOffset > $editor.getDocument().getTextLength()) continue;
            RangeHighlighter rangeHighlighter = hyperlinkInfo != null ? $hyperlinkSupport.createHyperlink(highlightStartOffset, highlightEndOffset, it.getHighlightAttributes(), hyperlinkInfo) : $markupModel.addRangeHighlighter(highlightStartOffset, highlightEndOffset, it.getHighlighterLayer(), it.getHighlightAttributes(), HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private static final void enqueueHeavyFiltering$lambda$5(KubernetesLogFilterService this$0, List $lines, DocumentImpl $subDoc, Editor $editor, int $eventOffset, EditorHyperlinkSupport $hyperlinkSupport, MarkupModel $markupModel) {
        if (this$0.getMyCompositeFilter().shouldRunHeavy()) {
            Iterable $this$forEachIndexed$iv = $lines;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String cfr_ignored_0 = (String)item$iv;
                int index = n;
                boolean bl = false;
                this$0.getMyCompositeFilter().applyHeavyFilter((Document)$subDoc, 0, index, arg_0 -> KubernetesLogFilterService.enqueueHeavyFiltering$lambda$5$0$1(arg_0 -> KubernetesLogFilterService.enqueueHeavyFiltering$lambda$5$0$0($editor, $eventOffset, $hyperlinkSupport, $markupModel, arg_0), arg_0));
            }
        }
    }

    private static final Unit enqueueHeavyFiltering$lambda$5$0$0(Editor $editor, int $eventOffset, EditorHyperlinkSupport $hyperlinkSupport, MarkupModel $markupModel, FilterMixin.AdditionalHighlight it) {
        KubernetesLogFilterService.enqueueHeavyFiltering$consumeResult($editor, $eventOffset, $hyperlinkSupport, $markupModel, (Filter.Result)it, true);
        return Unit.INSTANCE;
    }

    private static final void enqueueHeavyFiltering$lambda$5$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"Kubernetes.ParsedExceptions");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        markupHighlightedExceptionsKey = key;
        Key key2 = Key.create((String)"Kubernetes.ExceptionsHyperlinks");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        markupHyperlinkSupportKey = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R'\u0010\b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR'\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\t\u00a2\u0006\u0002\b\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesLogFilterService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kubernetes/logs/KubernetesLogFilterService;", "project", "Lcom/intellij/openapi/project/Project;", "markupHighlightedExceptionsKey", "Lcom/intellij/openapi/util/Key;", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getMarkupHighlightedExceptionsKey", "()Lcom/intellij/openapi/util/Key;", "markupHyperlinkSupportKey", "Lcom/intellij/execution/impl/EditorHyperlinkSupport;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getMarkupHyperlinkSupportKey$intellij_clouds_kubernetes_backend", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KubernetesLogFilterService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(KubernetesLogFilterService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (KubernetesLogFilterService)object;
        }

        @NotNull
        public final Key<HashSet<Integer>> getMarkupHighlightedExceptionsKey() {
            return markupHighlightedExceptionsKey;
        }

        @NotNull
        public final Key<EditorHyperlinkSupport> getMarkupHyperlinkSupportKey$intellij_clouds_kubernetes_backend() {
            return markupHyperlinkSupportKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

