/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.javascript.jest.coverage.JestCoverageEngine;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.testing.CoverageProjectDataLoader;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JestCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(JestCoverageRunner.class);
    private String myWorkingDirectory;
    private NodeTargetRun myTargetRun;

    JestCoverageRunner() {
    }

    public void setWorkingDirectory(@Nullable String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    public void setTargetRun(@Nullable NodeTargetRun targetRun) {
        this.myTargetRun = targetRun;
    }

    @NotNull
    public static JestCoverageRunner getInstance() {
        JestCoverageRunner jestCoverageRunner = Objects.requireNonNull((JestCoverageRunner)CoverageRunner.getInstance(JestCoverageRunner.class));
        if (jestCoverageRunner == null) {
            JestCoverageRunner.$$$reportNull$$$0(0);
        }
        return jestCoverageRunner;
    }

    @NotNull
    public CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        CoverageLoadingResult coverageLoadingResult;
        Path baseDir;
        if (sessionDataFile == null) {
            JestCoverageRunner.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            JestCoverageRunner.$$$reportNull$$$0(2);
        }
        if ((baseDir = this.getBaseDir(reporter)) == null && (baseDir = CoverageProjectDataLoader.guessBaseDir(sessionDataFile.toPath(), baseCoverageSuite != null ? baseCoverageSuite.getProject() : null, reporter)) == null) {
            String message = "Could not get base directory for coverage data file " + sessionDataFile.getAbsolutePath();
            LOG.warn(message);
            return new FailedCoverageLoadingResult(message);
        }
        try {
            coverageLoadingResult = CoverageProjectDataLoader.readProjectData(sessionDataFile.toPath(), baseDir, this.myTargetRun, reporter);
        }
        catch (Exception e) {
            LOG.warn("Can't read coverage data", (Throwable)e);
            return new FailedCoverageLoadingResult(e, true);
        }
        if (coverageLoadingResult == null) {
            JestCoverageRunner.$$$reportNull$$$0(3);
        }
        return coverageLoadingResult;
    }

    @Nullable
    private Path getBaseDir(@NotNull CoverageLoadErrorReporter reporter) {
        String basePath;
        if (reporter == null) {
            JestCoverageRunner.$$$reportNull$$$0(4);
        }
        if ((basePath = this.myWorkingDirectory) != null) {
            try {
                return Path.of(basePath, new String[0]);
            }
            catch (InvalidPathException e) {
                LOG.error("Invalid coverage basePath: " + basePath, (Throwable)e);
                reporter.reportError("Invalid coverage basePath: " + basePath);
            }
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        return "Jest Test Run";
    }

    @NotNull
    public String getId() {
        return "JestJavaScriptTestRunnerCoverage";
    }

    @NotNull
    public String getDataFileExtension() {
        return "info";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            JestCoverageRunner.$$$reportNull$$$0(5);
        }
        return engine instanceof JestCoverageEngine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/coverage/JestCoverageRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/coverage/JestCoverageRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCoverageData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDir";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

