/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.ins;

import com.vladsch.flexmark.util.ast.DelimitedNode;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class Ins
extends Node
implements DelimitedNode {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    protected String insBlockText;

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker};
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        Ins.delimitedSegmentSpanChars(out, this.openingMarker, this.text, this.closingMarker, "text");
    }

    public Ins() {
    }

    public Ins(BasedSequence chars) {
        super(chars);
    }

    public Ins(BasedSequence openingMarker, BasedSequence text, BasedSequence closingMarker) {
        super(openingMarker.baseSubSequence(openingMarker.getStartOffset(), closingMarker.getEndOffset()));
        this.openingMarker = openingMarker;
        this.text = text;
        this.closingMarker = closingMarker;
    }

    public Ins(BasedSequence chars, String insBlockText) {
        super(chars);
        this.insBlockText = insBlockText;
    }

    @Override
    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    @Override
    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    @Override
    public BasedSequence getText() {
        return this.text;
    }

    @Override
    public void setText(BasedSequence text) {
        this.text = text;
    }

    @Override
    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    @Override
    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }
}

