/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes;

import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeNode
extends Node
implements DoNotDecorate {
    protected BasedSequence name = BasedSequence.NULL;
    protected BasedSequence attributeSeparator = BasedSequence.NULL;
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence value = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.name, this.attributeSeparator, this.openingMarker, this.value, this.closingMarker};
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        AttributeNode.segmentSpanChars(out, this.name, "name");
        AttributeNode.segmentSpanChars(out, this.attributeSeparator, "sep");
        AttributeNode.delimitedSegmentSpanChars(out, this.openingMarker, this.value, this.closingMarker, "value");
        if (this.isImplicitName()) {
            out.append(" isImplicit");
        }
        if (this.isClass()) {
            out.append(" isClass");
        }
        if (this.isId()) {
            out.append(" isId");
        }
    }

    public AttributeNode() {
    }

    public AttributeNode(BasedSequence chars) {
        super(chars);
    }

    public AttributeNode(@Nullable BasedSequence name, @Nullable BasedSequence attributeSeparator, @Nullable BasedSequence openingMarker, @Nullable BasedSequence value, @Nullable BasedSequence closingMarker) {
        super(AttributeNode.spanningChars(name, attributeSeparator, openingMarker, value, closingMarker));
        this.name = name != null ? name : BasedSequence.NULL;
        this.attributeSeparator = attributeSeparator != null ? attributeSeparator : BasedSequence.NULL;
        this.openingMarker = openingMarker != null ? openingMarker : BasedSequence.NULL;
        this.value = value != null ? value : BasedSequence.NULL;
        this.closingMarker = closingMarker != null ? closingMarker : BasedSequence.NULL;
    }

    public static boolean isImplicitName(CharSequence text) {
        return text.length() > 0 && (text.charAt(0) == '.' || text.charAt(0) == '#');
    }

    public boolean isImplicitName() {
        return this.value.isNotNull() && this.attributeSeparator.isNull() && this.name.isNotNull();
    }

    public boolean isClass() {
        return this.isImplicitName() && this.name.equals(".") || !this.isImplicitName() && this.name.equals("class");
    }

    public boolean isId() {
        return this.isImplicitName() && this.name.equals("#") || !this.isImplicitName() && this.name.equals("id");
    }

    public BasedSequence getName() {
        return this.name;
    }

    public void setName(BasedSequence name) {
        this.name = name;
    }

    public BasedSequence getAttributeSeparator() {
        return this.attributeSeparator;
    }

    public void setAttributeSeparator(BasedSequence attributeSeparator) {
        this.attributeSeparator = attributeSeparator;
    }

    public BasedSequence getValue() {
        return this.value;
    }

    public void setValue(BasedSequence value) {
        this.value = value;
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }
}

