/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.util.ReferenceSetBase;
import com.intellij.spring.model.jam.converters.SpringAntPatternPackageReferenceSet;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJamConverter
extends JamConverter<Collection<PsiPackage>> {
    public Collection<PsiPackage> fromString(@Nullable String s, JamStringAttributeElement<Collection<PsiPackage>> context) {
        String text;
        PsiLanguageInjectionHost psiLiteral;
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        if (PlaceholderUtils.getInstance().isDefaultPlaceholder(s) && (psiLiteral = context.getLanguageInjectionHost()) != null && StringUtil.isNotEmpty((String)(text = PlaceholderUtils.getInstance().getPlaceholderText((PsiElement)psiLiteral)))) {
            return PackageJamConverter.calculatePackagesOnFakeElement(text, (PsiElement)context.getPsiElement());
        }
        psiLiteral = context.getLanguageInjectionHost();
        if (psiLiteral == null) {
            return PackageJamConverter.calculatePackagesOnFakeElement(s, (PsiElement)context.getPsiElement());
        }
        List<PackageReferenceSet> sets = PackageJamConverter.createReferenceSet(psiLiteral, s);
        return ContainerUtil.flatMap(sets, set -> new ArrayList(set.resolvePackage()));
    }

    @Nullable
    private static Collection<PsiPackage> calculatePackagesOnFakeElement(@NotNull String s, @Nullable PsiElement context) {
        if (s == null) {
            PackageJamConverter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            return null;
        }
        PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText("\"" + s + "\"", context);
        if (psiExpression instanceof PsiLanguageInjectionHost) {
            List<PackageReferenceSet> sets = PackageJamConverter.createReferenceSet((PsiLanguageInjectionHost)psiExpression, s);
            return ContainerUtil.flatMap(sets, set -> new ArrayList(set.resolvePackage()));
        }
        return null;
    }

    public PsiReference @NotNull [] createReferences(@NotNull JamStringAttributeElement<Collection<PsiPackage>> context, @NotNull PsiLanguageInjectionHost injectionHost) {
        String value;
        if (context == null) {
            PackageJamConverter.$$$reportNull$$$0(1);
        }
        if (injectionHost == null) {
            PackageJamConverter.$$$reportNull$$$0(2);
        }
        if ((value = context.getStringValue()) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PackageJamConverter.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        List<PackageReferenceSet> sets = PackageJamConverter.createReferenceSet(injectionHost, value);
        List references = ContainerUtil.flatMap(sets, ReferenceSetBase::getReferences);
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            PackageJamConverter.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    @NotNull
    private static List<PackageReferenceSet> createReferenceSet(@NotNull PsiLanguageInjectionHost psiLiteral, String value) {
        if (psiLiteral == null) {
            PackageJamConverter.$$$reportNull$$$0(5);
        }
        int startInElement = ElementManipulators.getOffsetInElement((PsiElement)psiLiteral);
        int start = 0;
        SmartList referenceSets = new SmartList();
        while (start < value.length()) {
            int next = PackageJamConverter.nextSeparator(value, start);
            String part = value.substring(start, next);
            if (!part.isEmpty()) {
                referenceSets.add(new SpringAntPatternPackageReferenceSet(part, (PsiElement)psiLiteral, startInElement + start, SpringReferenceUtils.getResolveScope((PsiElement)psiLiteral)));
            }
            start = next + 1;
        }
        if (referenceSets.isEmpty()) {
            referenceSets.add(new SpringAntPatternPackageReferenceSet(value, (PsiElement)psiLiteral, startInElement, SpringReferenceUtils.getResolveScope((PsiElement)psiLiteral)));
        }
        SmartList smartList = referenceSets;
        if (smartList == null) {
            PackageJamConverter.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    private static int nextSeparator(String value, int start) {
        for (int i = start; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != ',' && c != ';' && c != ' ') continue;
            return i;
        }
        return value.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/converters/PackageJamConverter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/converters/PackageJamConverter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculatePackagesOnFakeElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceSet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

