/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.RedisIntermediateFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import java.sql.Connection;
import java.sql.Driver;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedisJdbcHelper
extends JdbcHelperImpl {
    private static final String HOST_PORT_TEMPLATE = "%s:%s";

    public RedisJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("REDIS", version, connection, jdbcClassLoader);
    }

    private RedisJdbcHelper(@NotNull RedisJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            RedisJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            RedisJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    public RedisJdbcHelper() {
        this(null, null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return RedisJdbcHelper.extractVersion(version);
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "Redis")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        JdbcNativeUtil.logInfo("release_version: " + productVer);
        return new RedisJdbcHelper(productVer, delegate, jdbcClassLoader);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            RedisJdbcHelper.$$$reportNull$$$0(2);
        }
        return RedisJdbcHelper.classNameContains(driver, "Redis");
    }

    @Override
    public JdbcSettings.SslMode[] supportedSslModes() {
        return new JdbcSettings.SslMode[]{JdbcSettings.SslMode.REQUIRE, JdbcSettings.SslMode.VERIFY_CA};
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            RedisJdbcHelper.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            RedisJdbcHelper.$$$reportNull$$$0(4);
        }
        if (sslMode == null) {
            RedisJdbcHelper.$$$reportNull$$$0(5);
        }
        properties.setProperty("ssl", "true");
        RedisJdbcHelper.setIfEmpty(properties, "verifyServerCertificate", sslMode == JdbcSettings.SslMode.REQUIRE ? "false" : "true");
    }

    @Override
    protected void setPortForwardings(@NotNull Properties properties, @NotNull List<JdbcSettings.PortForwarding> portForwardings) {
        if (properties == null) {
            RedisJdbcHelper.$$$reportNull$$$0(6);
        }
        if (portForwardings == null) {
            RedisJdbcHelper.$$$reportNull$$$0(7);
        }
        Map<String, String> hostAndPortMapping = portForwardings.stream().collect(Collectors.toMap(pf -> String.format(HOST_PORT_TEMPLATE, pf.getToHost(), pf.getToPort()), pf -> String.format(HOST_PORT_TEMPLATE, pf.getFromHost(), pf.getFromPort())));
        RedisJdbcHelper.setIfEmpty(properties, "hostAndPortMapping", hostAndPortMapping.toString());
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            RedisJdbcHelper.$$$reportNull$$$0(8);
        }
        return new RedisJdbcHelper(this, jdbcClassLoader);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new RedisJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            RedisJdbcHelper.$$$reportNull$$$0(9);
        }
        return new RedisIntermediateFacade(ds, this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portForwardings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/RedisJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enableSsl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setPortForwardings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

