/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate.autowire;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.actions.generate.autowire.SpringBeanPointerWrapper;
import com.intellij.spring.model.jam.stereotype.SuperClassSpringComponentStub;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u00a8\u0006\b"}, d2={"checkSuperClassStub", "", "beanPointer", "Lcom/intellij/spring/model/SpringBeanPointer;", "beanWrapperTreeName", "", "beanWrapper", "Lcom/intellij/spring/model/actions/generate/autowire/SpringBeanPointerWrapper;", "intellij.spring.core"})
public final class SpringBeanModelLoaderKt {
    public static final boolean checkSuperClassStub(@NotNull SpringBeanPointer<?> beanPointer) {
        Intrinsics.checkNotNullParameter(beanPointer, (String)"beanPointer");
        CommonSpringBean commonSpringBean = beanPointer.getSpringBean();
        Intrinsics.checkNotNullExpressionValue((Object)commonSpringBean, (String)"getSpringBean(...)");
        CommonSpringBean springBean = commonSpringBean;
        if (springBean instanceof SuperClassSpringComponentStub) {
            PsiType psiType = ((SuperClassSpringComponentStub)springBean).getOriginalBean().getBeanType();
            PsiType psiType2 = ((SuperClassSpringComponentStub)springBean).getBeanType();
            return !Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)(psiType2 != null ? psiType2.getCanonicalText() : null));
        }
        return true;
    }

    @NlsContexts.Label
    @NotNull
    public static final String beanWrapperTreeName(@NotNull SpringBeanPointerWrapper beanWrapper) {
        Intrinsics.checkNotNullParameter((Object)beanWrapper, (String)"beanWrapper");
        Object object = beanWrapper.getInjectedBeanType();
        if (object == null || (object = object.getPresentableText()) == null) {
            PsiClass psiClass = beanWrapper.getBean().getBeanClass();
            object = psiClass != null ? psiClass.getName() : null;
            if (object == null) {
                object = beanWrapper.getName();
            }
        }
        return object;
    }
}

