/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.el.impl;

import com.intellij.javaee.el.ELExpressionHolder;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELFunctionCallExpression;
import com.intellij.javaee.el.psi.ELSliceExpression;
import com.intellij.javaee.el.references.ELReference;
import com.intellij.javaee.el.util.ELResolveUtil;
import com.intellij.javaee.el.util.ElComponentTypeUtil;
import com.intellij.jsp.javaee.web.JspImplicitVariableImpl;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.jsp.jspXml.JspExpression;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TagImplicitVariable
extends JspImplicitVariableImpl {
    @NonNls
    private static final String SET_TAG_NAME = "set";
    private final NotNullFunction<? super XmlTag, String> myDefaultVarTypeProvider;

    TagImplicitVariable(XmlTag tag, XmlAttribute attribute, String range, NotNullFunction<? super XmlTag, String> defaultVarTypeProvider) {
        super((PsiElement)tag, attribute.getValue(), null, (PsiElement)attribute.getValueElement(), range);
        this.myDefaultVarTypeProvider = defaultVarTypeProvider;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        if (this.getDeclarationRange() == 1) {
            return new LocalSearchScope(this.getDeclarationScope());
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            TagImplicitVariable.$$$reportNull$$$0(0);
        }
        return searchScope;
    }

    @NotNull
    public PsiType getType() {
        XmlTag tag = (XmlTag)this.getDeclarationScope();
        @NonNls String localName = tag.getLocalName();
        @NonNls String typeQName = (String)this.myDefaultVarTypeProvider.fun((Object)tag);
        if ("forTokens".equals(localName) || SET_TAG_NAME.equals(localName)) {
            typeQName = "java.lang.String";
        } else if ("catch".equals(localName)) {
            typeQName = "java.lang.Exception";
        }
        PsiType varType = null;
        PsiType componentType = TagImplicitVariable.tryDoEvalTypeFromAttributeValue(tag, "items", true, "forEach".equals(localName));
        if (componentType != null) {
            varType = componentType;
        } else {
            componentType = TagImplicitVariable.tryDoEvalTypeFromAttributeValue(tag, "value", !SET_TAG_NAME.equals(localName), false);
            if (componentType != null) {
                varType = componentType;
            }
        }
        if (varType != null) {
            varType = GenericsUtil.eliminateWildcards((PsiType)varType, (boolean)false);
        }
        if (varType == null) {
            varType = JavaPsiFacade.getElementFactory((Project)tag.getProject()).createTypeByFQClassName(typeQName);
        }
        PsiType psiType = varType;
        if (psiType == null) {
            TagImplicitVariable.$$$reportNull$$$0(1);
        }
        return psiType;
    }

    @Nullable
    private static PsiType tryDoEvalTypeFromAttributeValue(XmlTag tag, @NonNls String attrName, boolean evaluateComponentType, boolean treatMapComponentTypeAsEntry) {
        PsiElement[] itemsValueChildren;
        if (tag.getAttributeValue(attrName) == null) {
            return null;
        }
        XmlAttribute attribute = tag.getAttribute(attrName, null);
        XmlAttributeValue value = attribute != null ? attribute.getValueElement() : null;
        PsiElement[] psiElementArray = itemsValueChildren = value != null ? value.getChildren() : PsiElement.EMPTY_ARRAY;
        if (itemsValueChildren.length > 2) {
            PsiElement child = itemsValueChildren[1];
            if (child instanceof ELExpressionHolder) {
                PsiElement[] expressionHolderChildren = child.getChildren();
                if (expressionHolderChildren.length > 0) {
                    PsiElement expressionElement = expressionHolderChildren[0];
                    if (expressionElement instanceof ELFunctionCallExpression) {
                        expressionElement = ((ELFunctionCallExpression)expressionElement).getMethod();
                    } else if (expressionElement instanceof ELSliceExpression) {
                        expressionElement = ((ELSliceExpression)expressionElement).getFrom();
                        evaluateComponentType = true;
                    }
                    PsiReference psiReference = expressionElement.findReferenceAt(expressionElement.getTextLength() - 1);
                    if (psiReference instanceof ELReference) {
                        return TagImplicitVariable.handleType(tag, evaluateComponentType, treatMapComponentTypeAsEntry, ELResolveUtil.resolveContextAsType((ELExpression)((ELReference)psiReference).getElement()));
                    }
                }
            } else if (child instanceof JspExpression) {
                PsiElement at;
                int offset = child.getTextOffset() + "<%=".length();
                while ((at = tag.getContainingFile().getViewProvider().findElementAt(offset, (Language)JavaLanguage.INSTANCE)) != null) {
                    ++offset;
                    if (at instanceof PsiWhiteSpace) continue;
                }
                if (at != null) {
                    PsiExpression currentExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)at, PsiExpression.class, (boolean)false);
                    PsiExpression expression = null;
                    PsiExpression prevexpression = null;
                    while (currentExpression != null) {
                        prevexpression = expression;
                        expression = currentExpression;
                        currentExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)currentExpression, PsiExpression.class);
                    }
                    if (prevexpression != null) {
                        return TagImplicitVariable.handleType(tag, evaluateComponentType, treatMapComponentTypeAsEntry, prevexpression.getType());
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    static PsiType handleType(XmlTag tag, boolean evaluateComponentType, boolean treatMapComponentTypeAsEntry, PsiType type) {
        if (type == null) {
            return null;
        }
        if (evaluateComponentType) {
            if (treatMapComponentTypeAsEntry && type instanceof PsiClassType) {
                PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type).resolveGenerics();
                PsiFile file = tag.getContainingFile();
                if (ElComponentTypeUtil.isInheritor((PsiClass)ElComponentTypeUtil.getCachedClass((PsiFile)file, (String)"java.util.Map"), (PsiClassType.ClassResolveResult)classResolveResult)) {
                    PsiSubstitutor classSubstitutor = ElComponentTypeUtil.getSubstitutions((PsiClassType.ClassResolveResult)classResolveResult);
                    JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file.getProject());
                    PsiClass entryClass = facade.findClass("java.util.Map.Entry", ElComponentTypeUtil.getElementDependenciesScope((PsiElement)file));
                    assert (entryClass != null);
                    PsiSubstitutor entrySubstitutor = GenericsUtil.substituteByParameterName((PsiClass)entryClass, (PsiSubstitutor)classSubstitutor);
                    return facade.getElementFactory().createType(entryClass, entrySubstitutor);
                }
            }
            return ElComponentTypeUtil.evaluateComponentType((PsiType)type, (PsiElement)tag);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jsp/javaee/web/el/impl/TagImplicitVariable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

