/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceDirtyFilesHandler;
import org.jetbrains.idea.perforce.application.PerforceVcs;

public final class PerforceReadOnlyFileStateManager {
    private static final Logger LOG = Logger.getInstance(PerforceReadOnlyFileStateManager.class);
    private final Project myProject;
    private final PerforceDirtyFilesHandler myDirtyFilesHandler;
    private final ProjectLevelVcsManager myVcsManager;
    private final Object myLock = new Object();
    private final ApplicationActivationListener myFrameStateListener = new ApplicationActivationListener(){

        public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
            if (ideFrame == null) {
                1.$$$reportNull$$$0(0);
            }
            PerforceReadOnlyFileStateManager.this.processFocusLost();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager$1", "applicationDeactivated"));
        }
    };
    private final Set<FilePath> myPreviousAddedSnapshot = new HashSet<FilePath>();
    private final Map<VirtualFile, Set<VirtualFile>> myWritableFiles = new HashMap<VirtualFile, Set<VirtualFile>>();
    private volatile boolean myHasLostFocus;

    public PerforceReadOnlyFileStateManager(Project project, PerforceDirtyFilesHandler dirtyFilesHandler) {
        this.myProject = project;
        this.myDirtyFilesHandler = dirtyFilesHandler;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    public void activate(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PerforceReadOnlyFileStateManager.$$$reportNull$$$0(0);
        }
        Disposer.register((Disposable)parentDisposable, this::deactivate);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new MyVfsListener(), parentDisposable);
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        appConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)this.myFrameStateListener);
    }

    private void deactivate() {
        this.myHasLostFocus = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWritableFiles(VirtualFile root, Collection<VirtualFile> writableFiles, boolean withIgnored) {
        Set<Object> writablesUnderRoot = new HashSet();
        boolean needInit = false;
        Map<VirtualFile, Set<VirtualFile>> map = this.myWritableFiles;
        synchronized (map) {
            Set<VirtualFile> currentFilesUnderRoot;
            if (!this.myWritableFiles.containsKey(root)) {
                needInit = true;
            }
            if ((currentFilesUnderRoot = this.myWritableFiles.get(root)) != null) {
                writablesUnderRoot = new HashSet<VirtualFile>(currentFilesUnderRoot);
            }
        }
        if (needInit) {
            writablesUnderRoot = this.initializeWritableFiles(root);
        }
        for (VirtualFile vf : writablesUnderRoot) {
            if (!withIgnored && ChangeListManager.getInstance((Project)this.myProject).isIgnoredFile(vf)) continue;
            writableFiles.add(vf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<VirtualFile> initializeWritableFiles(VirtualFile root) {
        HashSet newWritableFiles = new HashSet();
        this.myVcsManager.iterateVfUnderVcsRoot(root, vf -> {
            PerforceReadOnlyFileStateManager.addFileIfWritable(newWritableFiles, vf);
            return true;
        });
        Map<VirtualFile, Set<VirtualFile>> map = this.myWritableFiles;
        synchronized (map) {
            if (!this.myWritableFiles.containsKey(root)) {
                this.myWritableFiles.put(root, newWritableFiles);
            }
            return new HashSet<VirtualFile>((Collection)this.myWritableFiles.get(root));
        }
    }

    private static void addFileIfWritable(Set<VirtualFile> collection, VirtualFile vf) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!vf.isValid() || vf.isDirectory() || !vf.isWritable() || vf.is(VFileProperty.SYMLINK)) {
                return;
            }
            collection.add(vf);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getChanges(VcsDirtyScope dirtyScope, ChangelistBuilder builder, ProgressIndicator progress, ChangeListManagerGate addGate) throws VcsException {
        Set<FilePath> newAdded = this.getAddedFilesInCurrentChangesView(addGate);
        Object object = this.myLock;
        synchronized (object) {
            progress.checkCanceled();
            this.recheckPreviouslyAddedFiles(newAdded);
            this.recheckWhatUnversionedRefreshNeeded(dirtyScope);
        }
        Set<String> missingFiles = this.myDirtyFilesHandler.scanAndGetMissingFiles(addGate, progress);
        Set<String> locallyDeleted = PerforceReadOnlyFileStateManager.findLocallyDeletedMissingFiles(addGate, missingFiles);
        for (String path : locallyDeleted) {
            builder.processLocallyDeletedFile(VcsUtil.getFilePath((String)path, (boolean)false));
        }
    }

    private Set<FilePath> getAddedFilesInCurrentChangesView(ChangeListManagerGate addGate) {
        HashSet<FilePath> set = new HashSet<FilePath>();
        for (LocalChangeList list : addGate.getListsCopy()) {
            for (Change change : list.getChanges()) {
                FilePath file;
                ContentRevision afterRevision = change.getAfterRevision();
                if (!FileStatus.ADDED.equals((Object)change.getFileStatus()) || afterRevision == null || !this.fileIsUnderP4Root(file = afterRevision.getFile())) continue;
                set.add(file);
            }
        }
        return set;
    }

    private void recheckWhatUnversionedRefreshNeeded(VcsDirtyScope dirtyScope) {
        if (this.myHasLostFocus && dirtyScope.wasEveryThingDirty()) {
            LOG.info("--- recheck missing");
            this.myHasLostFocus = false;
            this.myDirtyFilesHandler.rescanIfProblems();
        }
    }

    private void recheckPreviouslyAddedFiles(Set<FilePath> newAdded) {
        HashSet<FilePath> copy = new HashSet<FilePath>(this.myPreviousAddedSnapshot);
        copy.removeAll(newAdded);
        this.myPreviousAddedSnapshot.clear();
        this.myPreviousAddedSnapshot.addAll(newAdded);
        if (!copy.isEmpty()) {
            this.myDirtyFilesHandler.reportRecheck(copy);
        }
    }

    private static Set<String> findLocallyDeletedMissingFiles(ChangeListManagerGate addGate, Set<String> missingFiles) {
        HashSet<String> locallyDeleted = new HashSet<String>();
        for (String path : missingFiles) {
            if (FileStatus.DELETED.equals((Object)addGate.getStatus(VcsUtil.getFilePath((File)new File(path))))) continue;
            locallyDeleted.add(path);
        }
        return locallyDeleted;
    }

    public void processFocusLost() {
        this.myHasLostFocus = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardUnversioned() {
        Map<VirtualFile, Set<VirtualFile>> map = this.myWritableFiles;
        synchronized (map) {
            this.myWritableFiles.clear();
        }
        this.myDirtyFilesHandler.scheduleTotalRescan();
    }

    private boolean fileIsUnderP4Root(FilePath file) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (ChangeListManager.getInstance((Project)this.myProject).isIgnoredFile(file)) {
            return false;
        }
        AbstractVcs vcs = this.myVcsManager.getVcsFor(file);
        return vcs != null && PerforceVcs.getKey().equals((Object)vcs.getKeyInstanceMethod());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager", "activate"));
    }

    private class MyVfsListener
    implements VirtualFileListener {
        private MyVfsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(0);
            }
            VirtualFile file = event.getFile();
            FilePath path = VcsUtil.getFilePath((VirtualFile)file);
            if ("writable".equals(event.getPropertyName()) && PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(path)) {
                PerforceReadOnlyFileStateManager.this.myDirtyFilesHandler.reportRecheck(path);
                VirtualFile root = PerforceReadOnlyFileStateManager.this.myVcsManager.getVcsRootFor(path);
                Map<VirtualFile, Set<VirtualFile>> map = PerforceReadOnlyFileStateManager.this.myWritableFiles;
                synchronized (map) {
                    if (PerforceReadOnlyFileStateManager.this.myWritableFiles.containsKey(root)) {
                        Set<VirtualFile> writableFiles = PerforceReadOnlyFileStateManager.this.myWritableFiles.get(root);
                        if (((Boolean)event.getNewValue()).booleanValue()) {
                            writableFiles.add(file);
                        } else {
                            writableFiles.remove(file);
                        }
                    }
                }
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(1);
            }
            VirtualFile file = event.getFile();
            FilePath path = VcsUtil.getFilePath((VirtualFile)file);
            if (!file.isWritable() && PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(path)) {
                PerforceReadOnlyFileStateManager.this.myDirtyFilesHandler.reportRecheck(path);
            }
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            VirtualFile file;
            FilePath path;
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(2);
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(path = VcsUtil.getFilePath((VirtualFile)(file = event.getFile())))) {
                return;
            }
            PerforceReadOnlyFileStateManager.this.myDirtyFilesHandler.reportRecheck(path);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            VirtualFile file;
            FilePath path;
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(3);
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(path = VcsUtil.getFilePath((VirtualFile)(file = event.getFile())))) {
                return;
            }
            PerforceReadOnlyFileStateManager.this.myDirtyFilesHandler.reportRecheck(path);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            VirtualFile file;
            FilePath path;
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(4);
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(path = VcsUtil.getFilePath((VirtualFile)(file = event.getFile())))) {
                return;
            }
            PerforceReadOnlyFileStateManager.this.myDirtyFilesHandler.reportRecheck(path);
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            VirtualFile file;
            FilePath path;
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(5);
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(path = VcsUtil.getFilePath((VirtualFile)(file = event.getFile())))) {
                return;
            }
            PerforceReadOnlyFileStateManager.this.myDirtyFilesHandler.reportDelete(path);
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            VirtualFile file;
            FilePath path;
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(6);
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(path = VcsUtil.getFilePath((VirtualFile)(file = event.getFile())))) {
                return;
            }
            PerforceReadOnlyFileStateManager.this.myDirtyFilesHandler.reportDelete(path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager$MyVfsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileMovement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

