/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.JpaQueryParameterReferenceProvider;
import com.intellij.jpa.JpaQueryReferenceProvider;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLanguageInjectionHostVisitor;
import com.intellij.psi.PsiReference;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

public final class JpaQueryApiInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JpaQueryApiInspection.$$$reportNull$$$0(0);
        }
        return new PsiLanguageInjectionHostVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof PsiLanguageInjectionHost)) {
                    return;
                }
                UExpression uLiteralExpression = (UExpression)UastContextKt.toUElement((PsiElement)element, UExpression.class);
                if (uLiteralExpression != null) {
                    JpaQueryApiInspection.checkQueryApiReferences(uLiteralExpression, element, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/highlighting/JpaQueryApiInspection$1", "visitElement"));
            }
        };
    }

    private static void checkQueryApiReferences(UExpression literalExpression, PsiElement host, ProblemsHolder holder) {
        PsiReference[] references;
        JpaQueryReferenceProvider.QueryRelatedReference relatedReference;
        if ((JpaQueryReferenceProvider.ALL_PATTERNS.accepts((Object)literalExpression, UastPatterns.withRequestedPsi((PsiElement)host)) || JpaQueryParameterReferenceProvider.ALL_PATTERNS.accepts((Object)literalExpression, UastPatterns.withRequestedPsi((PsiElement)host))) && (relatedReference = JpaUtil.findReferenceOfType(references = host.getReferences(), JpaQueryReferenceProvider.QueryRelatedReference.class)) != null && relatedReference.resolve() == null) {
            TextRange range = relatedReference.getRangeInElement();
            if (range.isEmpty() && range.getStartOffset() == 1 && "\"\"".equals(host.getText())) {
                String message = ProblemsHolder.unresolvedReferenceMessage((PsiReference)relatedReference);
                holder.registerProblem(host, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, TextRange.create((int)0, (int)2), new LocalQuickFix[0]);
            } else {
                String message = MessageFormat.format(relatedReference.getUnresolvedMessagePattern(), relatedReference.getCanonicalText());
                holder.registerProblem(relatedReference.getElement(), range, message, relatedReference.getQuickFixes());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/jpa/highlighting/JpaQueryApiInspection", "buildVisitor"));
    }
}

