// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A block of content in a streaming response.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub enum ContentBlockDelta {
    /// <p>Incremental citation information that is streamed as part of the response generation process.</p>
    Citation(crate::types::CitationsDelta),
    /// <p>Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of Thought (CoT) that the model generates to enhance the accuracy of its final response.</p>
    ReasoningContent(crate::types::ReasoningContentBlockDelta),
    /// <p>The content text.</p>
    Text(::std::string::String),
    /// <p>An incremental update that contains the results from a tool call.</p>
    ToolResult(::std::vec::Vec<crate::types::ToolResultBlockDelta>),
    /// <p>Information about a tool that the model is requesting to use.</p>
    ToolUse(crate::types::ToolUseBlockDelta),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ContentBlockDelta {
    /// Tries to convert the enum instance into [`Citation`](crate::types::ContentBlockDelta::Citation), extracting the inner [`CitationsDelta`](crate::types::CitationsDelta).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_citation(&self) -> ::std::result::Result<&crate::types::CitationsDelta, &Self> {
        if let ContentBlockDelta::Citation(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Citation`](crate::types::ContentBlockDelta::Citation).
    pub fn is_citation(&self) -> bool {
        self.as_citation().is_ok()
    }
    /// Tries to convert the enum instance into [`ReasoningContent`](crate::types::ContentBlockDelta::ReasoningContent), extracting the inner [`ReasoningContentBlockDelta`](crate::types::ReasoningContentBlockDelta).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_reasoning_content(&self) -> ::std::result::Result<&crate::types::ReasoningContentBlockDelta, &Self> {
        if let ContentBlockDelta::ReasoningContent(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`ReasoningContent`](crate::types::ContentBlockDelta::ReasoningContent).
    pub fn is_reasoning_content(&self) -> bool {
        self.as_reasoning_content().is_ok()
    }
    /// Tries to convert the enum instance into [`Text`](crate::types::ContentBlockDelta::Text), extracting the inner [`String`](::std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_text(&self) -> ::std::result::Result<&::std::string::String, &Self> {
        if let ContentBlockDelta::Text(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Text`](crate::types::ContentBlockDelta::Text).
    pub fn is_text(&self) -> bool {
        self.as_text().is_ok()
    }
    /// Tries to convert the enum instance into [`ToolResult`](crate::types::ContentBlockDelta::ToolResult), extracting the inner [`Vec`](::std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tool_result(&self) -> ::std::result::Result<&::std::vec::Vec<crate::types::ToolResultBlockDelta>, &Self> {
        if let ContentBlockDelta::ToolResult(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`ToolResult`](crate::types::ContentBlockDelta::ToolResult).
    pub fn is_tool_result(&self) -> bool {
        self.as_tool_result().is_ok()
    }
    /// Tries to convert the enum instance into [`ToolUse`](crate::types::ContentBlockDelta::ToolUse), extracting the inner [`ToolUseBlockDelta`](crate::types::ToolUseBlockDelta).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tool_use(&self) -> ::std::result::Result<&crate::types::ToolUseBlockDelta, &Self> {
        if let ContentBlockDelta::ToolUse(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`ToolUse`](crate::types::ContentBlockDelta::ToolUse).
    pub fn is_tool_use(&self) -> bool {
        self.as_tool_use().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
impl ::std::fmt::Debug for ContentBlockDelta {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            ContentBlockDelta::Citation(val) => f.debug_tuple("Citation").field(&val).finish(),
            ContentBlockDelta::ReasoningContent(_) => f.debug_tuple("*** Sensitive Data Redacted ***").finish(),
            ContentBlockDelta::Text(val) => f.debug_tuple("Text").field(&val).finish(),
            ContentBlockDelta::ToolResult(val) => f.debug_tuple("ToolResult").field(&val).finish(),
            ContentBlockDelta::ToolUse(val) => f.debug_tuple("ToolUse").field(&val).finish(),
            ContentBlockDelta::Unknown => f.debug_tuple("Unknown").finish(),
        }
    }
}
