/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.ApplicationInstanceController;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.RestServer;

public abstract class ApplicationInstanceServer<T extends ApplicationInstanceController>
implements ApplicationInstanceController {
    private static final Log log = Log.getLog(ApplicationInstanceServer.class);
    private final RestServer<T> server;
    private final FileChannel configFileChannel;
    private final Class<T> controllerClass;

    protected ApplicationInstanceServer(Class<T> controllerClass) throws IOException {
        this.controllerClass = controllerClass;
        this.server = RestServer.builder(controllerClass, (Object)((ApplicationInstanceController)controllerClass.cast(this))).setFilter(address -> address.getAddress().isLoopbackAddress()).setLandingPage(GeneralUtils.getProductTitle()).create();
        this.configFileChannel = FileChannel.open(ApplicationInstanceServer.getConfigPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Properties props = new Properties();
            props.setProperty(ApplicationInstanceServer.portPropertyName(), String.valueOf(this.server.getAddress().getPort()));
            props.store(os, "DBeaver instance server properties");
            this.configFileChannel.write(ByteBuffer.wrap(os.toByteArray()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        log.debug((Object)("Starting instance server at http://localhost:" + this.server.getAddress().getPort()));
    }

    @Override
    public long ping(long payload) {
        return payload;
    }

    @Override
    public String getThreadDump() {
        log.info((Object)"Making thread dump");
        StringBuilder td = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> tde : Thread.getAllStackTraces().entrySet()) {
            td.append(tde.getKey().getId()).append(" ").append(tde.getKey().getName()).append(":\n");
            StackTraceElement[] stackTraceElementArray = tde.getValue();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                td.append("\t").append(ste.toString()).append("\n");
                ++n2;
            }
        }
        return td.toString();
    }

    @Override
    public String getVersion() {
        return GeneralUtils.getProductVersion().toString();
    }

    public void stopInstanceServer() {
        try {
            log.debug((Object)"Stop instance server");
            this.server.stop();
            if (this.configFileChannel != null) {
                this.configFileChannel.close();
                Files.delete(ApplicationInstanceServer.getConfigPath());
            }
            log.debug((Object)"Instance server has been stopped");
        }
        catch (Exception e) {
            log.error((Object)"Can't stop instance server", (Throwable)e);
        }
    }

    @NotNull
    protected static Path getConfigPath() {
        return ApplicationInstanceServer.getConfigPath(null);
    }

    @NotNull
    protected static Path getConfigPath(@Nullable Path workspacePath) {
        if (workspacePath != null) {
            return workspacePath.resolve(".metadata").resolve("dbeaver-instance.properties");
        }
        return GeneralUtils.getMetadataFolder().resolve("dbeaver-instance.properties");
    }

    protected static String portPropertyName() {
        return "port";
    }

    public static class InstanceConnectionParameters
    implements GeneralUtils.IParameterHandler {
        boolean makeConnect = true;
        boolean openConsole = false;
        boolean createNewConnection = true;

        public boolean setParameter(String name, String value) {
            return switch (name) {
                case "connect" -> {
                    this.makeConnect = CommonUtils.toBoolean((Object)value);
                    yield true;
                }
                case "openConsole" -> {
                    this.openConsole = CommonUtils.toBoolean((Object)value);
                    yield true;
                }
                case "create" -> {
                    this.createNewConnection = CommonUtils.toBoolean((Object)value);
                    yield true;
                }
                default -> false;
            };
        }

        public boolean isCreateNewConnection() {
            return this.createNewConnection;
        }

        public boolean isMakeConnect() {
            return this.makeConnect;
        }

        public boolean isOpenConsole() {
            return this.openConsole;
        }
    }
}

