#include <string.h>
#include "liveice.h"
#include "serverlib.h"
#include "url.h"
#include "mixer.h"

/*figure out the command string for update between track changes */
/* execut script takes form.... */
/* executable name */
/* args */
/* %t - epoch time */
/* %T - plaintext time */
/* %f - filename */
/* %F - url encoded formvars */
/* %a - artist */
/* %n - trackname */
/* %b - album */
/* %u - url */
void execute_update_script(cptr ch){
  time_t now;
  char *ptr,*lptr,exec_line[4096];

  if(g_conf.update_script){
    /* then someone's set it.... and I gotta parse the shit */
    bzero(exec_line,4096);
    ptr=g_conf.update_script;
    lptr=exec_line;
    while(*ptr!=0){
      if(*ptr=='%'){
	ptr++;
	switch(*ptr){
	 case 't':
	    sprintf(lptr,"%d",now);
	    break;
	  case 'T':
	    sprintf(lptr,"%s",ctime(&now));
	    while(*lptr!='\n') lptr++;
	    *lptr=0;
	    break;
	  case 'f':
	    sprintf(lptr,"%s",ch->curnt->filename);
	    break;
	  case 'F':
	    sprintf(lptr,"%s",ch->curnt->formvars);
	    break;
	  case 'a':
	    sprintf(lptr,"%s",ch->artist);
	    break;
	  case 'n':
	    sprintf(lptr,"%s",ch->title);
	    break;
	  case 'b':
	    sprintf(lptr,"%s",ch->album);
	    break;
	  case 'u':
	    sprintf(lptr,"%s",ch->url);
	    break;
	} 
	while(*lptr!=0) lptr++;
	ptr++;
      }  else if(*ptr=='\\'){
	ptr++;
	  switch(*ptr){
	  case 't':
	    *(lptr++) = '\t';
	    break;
	  case '\\':
	    *(lptr++) ='\\';
	    break;
	  case '\%':
	    *(lptr++) ='%';
	    break;
	  case '\000':
	    ptr--;
	    break;
	  default:
	    *(lptr++) = ' ';
	    break;
	  }
	  ptr++;
      } else {
	 *(lptr++) = *(ptr++);
      }
      /* really should fork before this */
      system(exec_line);
    }
  }
}
/* write logfile now includes support for setting the log format */
/* %t - epoch time */
/* %T - plaintext time */
/* %f - filename */
/* %F - url encoded formvars */
/* %a - artist */
/* %n - trackname */
/* %b - album */
/* %u - url */
/* default is %T %f %F */
void write_logfile(cptr ch){
  time_t now;
  char *ptr,*lptr,logline[4096];
  int i;
  FILE *logfile;
  time(&now);
  if(g_conf.track_logfile != NULL){
    bzero(logline,4096);
 
    if(g_conf.logfile_format){
      ptr=g_conf.logfile_format;
      logline[0]=0;
      lptr=logline;
      while(*ptr!=0){
	if(*ptr=='%'){
	  ptr++;
	  switch(*ptr){
	  case 't':
	    sprintf(lptr,"%d",now);
	    break;
	  case 'T':
	    sprintf(lptr,"%s",ctime(&now));
	    while(*lptr!='\n') lptr++;
	    *lptr=0;
	    break;
	  case 'f':
	    sprintf(lptr,"%s",ch->curnt->filename);
	    break;
	  case 'F':
	    sprintf(lptr,"%s",ch->curnt->formvars);
	    break;
	  case 'a':
	    sprintf(lptr,"%s",ch->artist);
	    break;
	  case 'n':
	    sprintf(lptr,"%s",ch->title);
	    break;
	  case 'b':
	    sprintf(lptr,"%s",ch->album);
	    break;
	  case 'u':
	    sprintf(lptr,"%s",ch->url);
	    break;
	  } 
	  while(*lptr!=0) lptr++;
	  ptr++;
	} else if(*ptr=='\\'){
	  ptr++;
	  switch(*ptr){
	  case 't':
	    *(lptr++) = '\t';
	    break;
	  case '\\':
	    *(lptr++) ='\\';
	    break;
	  case '\%':
	    *(lptr++) ='%';
	    break;
	  case '\000':
	    ptr--;
	    break;
	  default:
	    *(lptr++) = ' ';
	    break;
	  }
	  ptr++;
	} else {
	  *(lptr++) = *(ptr++);
	}
      }
	*(lptr++) = 0;
    } else {
      fprintf(stderr,"Using log %s\n",g_conf.track_logfile);
      sprintf(logline,"%s %s %s",ctime(&now),ch->curnt->filename,ch->curnt->formvars);
    }
    if((logfile=fopen(g_conf.track_logfile,"a+"))){
      time(&now);		
      fprintf(logfile,"%s\n",logline);
      fclose(logfile);
    } else {
      write_message("failed to write to logfile",1);
    }
  }
}

void parse_id3_v2(FILE *in,char **title,char **artist,char **album,char **url){
  unsigned char hdr[10];
  unsigned char *tag,*fptr;
  unsigned long tag_size,frame_size;
  fread(hdr,1,10,in);
  *title=malloc(2);
  *artist=malloc(2);
  *album=malloc(2);
  *url=malloc(2);
  strcpy(*title,"");
  strcpy(*artist,"");
  strcpy(*album,"");
  strcpy(*url,"");
  
  tag_size= ( ( (hdr[6] & 0x7f) <<21) | ((hdr[7] & 0x7f)<<14) | ((hdr[8] & 0x7f)<<7) | (hdr[9]&0x7f));
  tag=malloc(tag_size);
  fread(tag,1,tag_size,in);
  fptr=tag;
  while((fptr-tag)<tag_size){
    frame_size=10+((fptr[4]<<24) | (fptr[5]<<16) | (fptr[6]<<8) | fptr[7]);
    memcpy(hdr,fptr,4);
    hdr[4]=0;
    /* now parse each tag */
    if(fptr[0]=='T'){
      if((tag[1]=='I')&&(tag[2]=='T')){
	*title=realloc(*title,strlen(*title)+strlen(&fptr[11])+4);
	strcat(*title,&fptr[11]);
	strcat(*title," ");
      }

    }
    fptr+=frame_size;
  }
  
  free(tag);
}


int parse_file_metadata(char *filename,char **title,char **artist,char **album,char **url){
  FILE *in;
  unsigned char *buf,stat[128];

  if((in=fopen(filename,"rb"))){
    /*ok we've opened it */
    /* check for id3v2 */
    fread(stat,4,1,in);
    stat[4]=0;
    fprintf(stderr,"searching for Id3v2\n");
    if(!strcmp(stat,"ID3")){
      /* we've got an id3 v2 tag - go and parse it */
      fseek(in,0,SEEK_SET);
      parse_id3_v2(in,title,artist,album,url);
      fclose(in);
      return 0;
    } 
    fprintf(stderr,"searching for Id3v1\n");
    /* ok... no id3v2 seek to last 128 bytes */
    fseek(in,-128,SEEK_END);
    fread(stat,128,1,in);
    if((stat[0]=='T')&&(stat[1]=='A')&&(stat[2]=='G')){
      /* we've got an id3 v1 tag - go and parse it */
      *title=malloc(32);
      *artist=malloc(32);
      *album=malloc(32);
      *url=malloc(32);
      fprintf(stderr,"copying the data\n");
      memcpy(*title,&stat[3],30);
      memcpy(*artist,&stat[33],30);
      memcpy(*album,&stat[63],30);
      fprintf(stderr,"fixing the nulls\n");
      (*title)[30]=0;
      (*artist)[30]=0;
      (*album)[30]=0;
      fprintf(stderr,"adding the url\n");
      strcpy(*url,"http://www.icecast.org");
      fprintf(stderr,"closing input file\n");
      fclose(in);
      return 0;
    }    
  }
  fclose(in);
  fprintf(stderr,"making up the info\n");
  /* bugger something's up just return the filename */
  *title=malloc(strlen(filename)+2);
  *artist=malloc(10);
  *album=malloc(10);
  *url=malloc(30);
  strcpy(*title,filename);
  strcpy(*artist,"Unknown");
  strcpy(*album,"Unknown");  
  strcpy(*url,"http://www.icecast.org");
  return 0;
}

int update_meta_info_on_server (char *filename,enc_struct *e_stream)
{
	char mesg[4096];
	char *song = NULL;
	char *mount = NULL;
	sckt *sp;
	int sd;
	sp=sopen();
	if ((sd = sclient(sp, e_stream->server, e_stream->port)) == -1){
		/*fprintf(stderr,"error connecting to update metadata");*/
		sclose(sp);
		return 1;
	} else {
		if (e_stream->header_format) {
			sprintf(mesg, "GET /admin.cgi?pass=%s&mode=updinfo&mount=%s&song=%s HTTP/1.0\r\nHost: %s:%d\r\nUser-Agent: liveice-v%s\r\n\r\n", e_stream->password, url_encode(e_stream->mountpoint,&mount), url_encode (filename, &song),e_stream->server, e_stream->port,LIVEICE_VERSION);
			free(mount);
		}else {
			sprintf(mesg, "GET /admin.cgi?pass=%s&mode=updinfo&song=%s HTTP/1.0\r\nHost: %s:%d\r\nUser-Agent: liveice-v%s\r\n\r\n", e_stream->password, url_encode (filename, &song), e_stream->server, e_stream->port,LIVEICE_VERSION);
		}
		fprintf(stderr,mesg);
		free (song);
		write(sd,mesg,strlen(mesg));
		sclose(sp);
		return 0;
	}
}

void update_all_servers (char *message,char *url){
	int i;
	
        write_message("Updating Meta Data on All servers",1);
	switch(fork()){
	case 0:
	       
		for(i=0;i<MAX_ENCODER_STREAMS;i++){
			if(g_conf.e_str[i].enabled){
				update_meta_info_on_server (message,&(g_conf.e_str[i]));
			}
		}
		exit(0);
		break;
	case -1:
		write_message("failed to spawn a child process to do update",0);
		break;
	}
}


