/**********************************************************************
  Copyright(c) 2011-2016 Intel Corporation All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/

#include <aes_cbc.h>
#include <aes_keyexp.h>
#include "aes_keyexp_internal.h"

int
aes_cbc_precomp(uint8_t *key, int key_size, struct isal_cbc_key_data *keys_blk)
{
        if (ISAL_CBC_128_BITS == key_size) {
                _aes_keyexp_128(key, keys_blk->enc_keys, keys_blk->dec_keys);
        } else if (ISAL_CBC_192_BITS == key_size) {
                _aes_keyexp_192(key, keys_blk->enc_keys, keys_blk->dec_keys);
        } else if (ISAL_CBC_256_BITS == key_size) {
                _aes_keyexp_256(key, keys_blk->enc_keys, keys_blk->dec_keys);
        } else {
                // Invalid key length
                return 1;
        }
        return 0;
}

struct slver {
        uint16_t snum;
        uint8_t ver;
        uint8_t core;
};

// Version info
struct slver aes_cbc_precomp_slver_00000297;
struct slver aes_cbc_precomp_slver = { 0x0297, 0x00, 0x00 };
