/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery v2.53.3. DO NOT EDIT.

package testing

import (
	mock "github.com/stretchr/testify/mock"
	kubelettypes "k8s.io/kubernetes/pkg/kubelet/types"

	types "k8s.io/apimachinery/pkg/types"

	v1 "k8s.io/api/core/v1"
)

// MockManager is an autogenerated mock type for the Manager type
type MockManager struct {
	mock.Mock
}

type MockManager_Expecter struct {
	mock *mock.Mock
}

func (_m *MockManager) EXPECT() *MockManager_Expecter {
	return &MockManager_Expecter{mock: &_m.Mock}
}

// AddPod provides a mock function with given fields: _a0
func (_m *MockManager) AddPod(_a0 *v1.Pod) {
	_m.Called(_a0)
}

// MockManager_AddPod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'AddPod'
type MockManager_AddPod_Call struct {
	*mock.Call
}

// AddPod is a helper method to define mock.On call
//   - _a0 *v1.Pod
func (_e *MockManager_Expecter) AddPod(_a0 interface{}) *MockManager_AddPod_Call {
	return &MockManager_AddPod_Call{Call: _e.mock.On("AddPod", _a0)}
}

func (_c *MockManager_AddPod_Call) Run(run func(_a0 *v1.Pod)) *MockManager_AddPod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(*v1.Pod))
	})
	return _c
}

func (_c *MockManager_AddPod_Call) Return() *MockManager_AddPod_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockManager_AddPod_Call) RunAndReturn(run func(*v1.Pod)) *MockManager_AddPod_Call {
	_c.Run(run)
	return _c
}

// GetMirrorPodByPod provides a mock function with given fields: _a0
func (_m *MockManager) GetMirrorPodByPod(_a0 *v1.Pod) (*v1.Pod, bool) {
	ret := _m.Called(_a0)

	if len(ret) == 0 {
		panic("no return value specified for GetMirrorPodByPod")
	}

	var r0 *v1.Pod
	var r1 bool
	if rf, ok := ret.Get(0).(func(*v1.Pod) (*v1.Pod, bool)); ok {
		return rf(_a0)
	}
	if rf, ok := ret.Get(0).(func(*v1.Pod) *v1.Pod); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}

	if rf, ok := ret.Get(1).(func(*v1.Pod) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// MockManager_GetMirrorPodByPod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetMirrorPodByPod'
type MockManager_GetMirrorPodByPod_Call struct {
	*mock.Call
}

// GetMirrorPodByPod is a helper method to define mock.On call
//   - _a0 *v1.Pod
func (_e *MockManager_Expecter) GetMirrorPodByPod(_a0 interface{}) *MockManager_GetMirrorPodByPod_Call {
	return &MockManager_GetMirrorPodByPod_Call{Call: _e.mock.On("GetMirrorPodByPod", _a0)}
}

func (_c *MockManager_GetMirrorPodByPod_Call) Run(run func(_a0 *v1.Pod)) *MockManager_GetMirrorPodByPod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(*v1.Pod))
	})
	return _c
}

func (_c *MockManager_GetMirrorPodByPod_Call) Return(_a0 *v1.Pod, _a1 bool) *MockManager_GetMirrorPodByPod_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockManager_GetMirrorPodByPod_Call) RunAndReturn(run func(*v1.Pod) (*v1.Pod, bool)) *MockManager_GetMirrorPodByPod_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodAndMirrorPod provides a mock function with given fields: _a0
func (_m *MockManager) GetPodAndMirrorPod(_a0 *v1.Pod) (*v1.Pod, *v1.Pod, bool) {
	ret := _m.Called(_a0)

	if len(ret) == 0 {
		panic("no return value specified for GetPodAndMirrorPod")
	}

	var r0 *v1.Pod
	var r1 *v1.Pod
	var r2 bool
	if rf, ok := ret.Get(0).(func(*v1.Pod) (*v1.Pod, *v1.Pod, bool)); ok {
		return rf(_a0)
	}
	if rf, ok := ret.Get(0).(func(*v1.Pod) *v1.Pod); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}

	if rf, ok := ret.Get(1).(func(*v1.Pod) *v1.Pod); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*v1.Pod)
		}
	}

	if rf, ok := ret.Get(2).(func(*v1.Pod) bool); ok {
		r2 = rf(_a0)
	} else {
		r2 = ret.Get(2).(bool)
	}

	return r0, r1, r2
}

// MockManager_GetPodAndMirrorPod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodAndMirrorPod'
type MockManager_GetPodAndMirrorPod_Call struct {
	*mock.Call
}

// GetPodAndMirrorPod is a helper method to define mock.On call
//   - _a0 *v1.Pod
func (_e *MockManager_Expecter) GetPodAndMirrorPod(_a0 interface{}) *MockManager_GetPodAndMirrorPod_Call {
	return &MockManager_GetPodAndMirrorPod_Call{Call: _e.mock.On("GetPodAndMirrorPod", _a0)}
}

func (_c *MockManager_GetPodAndMirrorPod_Call) Run(run func(_a0 *v1.Pod)) *MockManager_GetPodAndMirrorPod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(*v1.Pod))
	})
	return _c
}

func (_c *MockManager_GetPodAndMirrorPod_Call) Return(_a0 *v1.Pod, mirrorPod *v1.Pod, wasMirror bool) *MockManager_GetPodAndMirrorPod_Call {
	_c.Call.Return(_a0, mirrorPod, wasMirror)
	return _c
}

func (_c *MockManager_GetPodAndMirrorPod_Call) RunAndReturn(run func(*v1.Pod) (*v1.Pod, *v1.Pod, bool)) *MockManager_GetPodAndMirrorPod_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodByFullName provides a mock function with given fields: podFullName
func (_m *MockManager) GetPodByFullName(podFullName string) (*v1.Pod, bool) {
	ret := _m.Called(podFullName)

	if len(ret) == 0 {
		panic("no return value specified for GetPodByFullName")
	}

	var r0 *v1.Pod
	var r1 bool
	if rf, ok := ret.Get(0).(func(string) (*v1.Pod, bool)); ok {
		return rf(podFullName)
	}
	if rf, ok := ret.Get(0).(func(string) *v1.Pod); ok {
		r0 = rf(podFullName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}

	if rf, ok := ret.Get(1).(func(string) bool); ok {
		r1 = rf(podFullName)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// MockManager_GetPodByFullName_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodByFullName'
type MockManager_GetPodByFullName_Call struct {
	*mock.Call
}

// GetPodByFullName is a helper method to define mock.On call
//   - podFullName string
func (_e *MockManager_Expecter) GetPodByFullName(podFullName interface{}) *MockManager_GetPodByFullName_Call {
	return &MockManager_GetPodByFullName_Call{Call: _e.mock.On("GetPodByFullName", podFullName)}
}

func (_c *MockManager_GetPodByFullName_Call) Run(run func(podFullName string)) *MockManager_GetPodByFullName_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockManager_GetPodByFullName_Call) Return(_a0 *v1.Pod, _a1 bool) *MockManager_GetPodByFullName_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockManager_GetPodByFullName_Call) RunAndReturn(run func(string) (*v1.Pod, bool)) *MockManager_GetPodByFullName_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodByMirrorPod provides a mock function with given fields: _a0
func (_m *MockManager) GetPodByMirrorPod(_a0 *v1.Pod) (*v1.Pod, bool) {
	ret := _m.Called(_a0)

	if len(ret) == 0 {
		panic("no return value specified for GetPodByMirrorPod")
	}

	var r0 *v1.Pod
	var r1 bool
	if rf, ok := ret.Get(0).(func(*v1.Pod) (*v1.Pod, bool)); ok {
		return rf(_a0)
	}
	if rf, ok := ret.Get(0).(func(*v1.Pod) *v1.Pod); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}

	if rf, ok := ret.Get(1).(func(*v1.Pod) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// MockManager_GetPodByMirrorPod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodByMirrorPod'
type MockManager_GetPodByMirrorPod_Call struct {
	*mock.Call
}

// GetPodByMirrorPod is a helper method to define mock.On call
//   - _a0 *v1.Pod
func (_e *MockManager_Expecter) GetPodByMirrorPod(_a0 interface{}) *MockManager_GetPodByMirrorPod_Call {
	return &MockManager_GetPodByMirrorPod_Call{Call: _e.mock.On("GetPodByMirrorPod", _a0)}
}

func (_c *MockManager_GetPodByMirrorPod_Call) Run(run func(_a0 *v1.Pod)) *MockManager_GetPodByMirrorPod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(*v1.Pod))
	})
	return _c
}

func (_c *MockManager_GetPodByMirrorPod_Call) Return(_a0 *v1.Pod, _a1 bool) *MockManager_GetPodByMirrorPod_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockManager_GetPodByMirrorPod_Call) RunAndReturn(run func(*v1.Pod) (*v1.Pod, bool)) *MockManager_GetPodByMirrorPod_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodByName provides a mock function with given fields: namespace, name
func (_m *MockManager) GetPodByName(namespace string, name string) (*v1.Pod, bool) {
	ret := _m.Called(namespace, name)

	if len(ret) == 0 {
		panic("no return value specified for GetPodByName")
	}

	var r0 *v1.Pod
	var r1 bool
	if rf, ok := ret.Get(0).(func(string, string) (*v1.Pod, bool)); ok {
		return rf(namespace, name)
	}
	if rf, ok := ret.Get(0).(func(string, string) *v1.Pod); ok {
		r0 = rf(namespace, name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) bool); ok {
		r1 = rf(namespace, name)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// MockManager_GetPodByName_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodByName'
type MockManager_GetPodByName_Call struct {
	*mock.Call
}

// GetPodByName is a helper method to define mock.On call
//   - namespace string
//   - name string
func (_e *MockManager_Expecter) GetPodByName(namespace interface{}, name interface{}) *MockManager_GetPodByName_Call {
	return &MockManager_GetPodByName_Call{Call: _e.mock.On("GetPodByName", namespace, name)}
}

func (_c *MockManager_GetPodByName_Call) Run(run func(namespace string, name string)) *MockManager_GetPodByName_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].(string))
	})
	return _c
}

func (_c *MockManager_GetPodByName_Call) Return(_a0 *v1.Pod, _a1 bool) *MockManager_GetPodByName_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockManager_GetPodByName_Call) RunAndReturn(run func(string, string) (*v1.Pod, bool)) *MockManager_GetPodByName_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodByUID provides a mock function with given fields: _a0
func (_m *MockManager) GetPodByUID(_a0 types.UID) (*v1.Pod, bool) {
	ret := _m.Called(_a0)

	if len(ret) == 0 {
		panic("no return value specified for GetPodByUID")
	}

	var r0 *v1.Pod
	var r1 bool
	if rf, ok := ret.Get(0).(func(types.UID) (*v1.Pod, bool)); ok {
		return rf(_a0)
	}
	if rf, ok := ret.Get(0).(func(types.UID) *v1.Pod); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}

	if rf, ok := ret.Get(1).(func(types.UID) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// MockManager_GetPodByUID_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodByUID'
type MockManager_GetPodByUID_Call struct {
	*mock.Call
}

// GetPodByUID is a helper method to define mock.On call
//   - _a0 types.UID
func (_e *MockManager_Expecter) GetPodByUID(_a0 interface{}) *MockManager_GetPodByUID_Call {
	return &MockManager_GetPodByUID_Call{Call: _e.mock.On("GetPodByUID", _a0)}
}

func (_c *MockManager_GetPodByUID_Call) Run(run func(_a0 types.UID)) *MockManager_GetPodByUID_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(types.UID))
	})
	return _c
}

func (_c *MockManager_GetPodByUID_Call) Return(_a0 *v1.Pod, _a1 bool) *MockManager_GetPodByUID_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockManager_GetPodByUID_Call) RunAndReturn(run func(types.UID) (*v1.Pod, bool)) *MockManager_GetPodByUID_Call {
	_c.Call.Return(run)
	return _c
}

// GetPods provides a mock function with no fields
func (_m *MockManager) GetPods() []*v1.Pod {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetPods")
	}

	var r0 []*v1.Pod
	if rf, ok := ret.Get(0).(func() []*v1.Pod); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v1.Pod)
		}
	}

	return r0
}

// MockManager_GetPods_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPods'
type MockManager_GetPods_Call struct {
	*mock.Call
}

// GetPods is a helper method to define mock.On call
func (_e *MockManager_Expecter) GetPods() *MockManager_GetPods_Call {
	return &MockManager_GetPods_Call{Call: _e.mock.On("GetPods")}
}

func (_c *MockManager_GetPods_Call) Run(run func()) *MockManager_GetPods_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockManager_GetPods_Call) Return(_a0 []*v1.Pod) *MockManager_GetPods_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockManager_GetPods_Call) RunAndReturn(run func() []*v1.Pod) *MockManager_GetPods_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodsAndMirrorPods provides a mock function with no fields
func (_m *MockManager) GetPodsAndMirrorPods() ([]*v1.Pod, []*v1.Pod, []string) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetPodsAndMirrorPods")
	}

	var r0 []*v1.Pod
	var r1 []*v1.Pod
	var r2 []string
	if rf, ok := ret.Get(0).(func() ([]*v1.Pod, []*v1.Pod, []string)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() []*v1.Pod); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v1.Pod)
		}
	}

	if rf, ok := ret.Get(1).(func() []*v1.Pod); ok {
		r1 = rf()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]*v1.Pod)
		}
	}

	if rf, ok := ret.Get(2).(func() []string); ok {
		r2 = rf()
	} else {
		if ret.Get(2) != nil {
			r2 = ret.Get(2).([]string)
		}
	}

	return r0, r1, r2
}

// MockManager_GetPodsAndMirrorPods_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodsAndMirrorPods'
type MockManager_GetPodsAndMirrorPods_Call struct {
	*mock.Call
}

// GetPodsAndMirrorPods is a helper method to define mock.On call
func (_e *MockManager_Expecter) GetPodsAndMirrorPods() *MockManager_GetPodsAndMirrorPods_Call {
	return &MockManager_GetPodsAndMirrorPods_Call{Call: _e.mock.On("GetPodsAndMirrorPods")}
}

func (_c *MockManager_GetPodsAndMirrorPods_Call) Run(run func()) *MockManager_GetPodsAndMirrorPods_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockManager_GetPodsAndMirrorPods_Call) Return(allPods []*v1.Pod, allMirrorPods []*v1.Pod, orphanedMirrorPodFullnames []string) *MockManager_GetPodsAndMirrorPods_Call {
	_c.Call.Return(allPods, allMirrorPods, orphanedMirrorPodFullnames)
	return _c
}

func (_c *MockManager_GetPodsAndMirrorPods_Call) RunAndReturn(run func() ([]*v1.Pod, []*v1.Pod, []string)) *MockManager_GetPodsAndMirrorPods_Call {
	_c.Call.Return(run)
	return _c
}

// GetStaticPodToMirrorPodMap provides a mock function with no fields
func (_m *MockManager) GetStaticPodToMirrorPodMap() map[*v1.Pod]*v1.Pod {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetStaticPodToMirrorPodMap")
	}

	var r0 map[*v1.Pod]*v1.Pod
	if rf, ok := ret.Get(0).(func() map[*v1.Pod]*v1.Pod); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[*v1.Pod]*v1.Pod)
		}
	}

	return r0
}

// MockManager_GetStaticPodToMirrorPodMap_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetStaticPodToMirrorPodMap'
type MockManager_GetStaticPodToMirrorPodMap_Call struct {
	*mock.Call
}

// GetStaticPodToMirrorPodMap is a helper method to define mock.On call
func (_e *MockManager_Expecter) GetStaticPodToMirrorPodMap() *MockManager_GetStaticPodToMirrorPodMap_Call {
	return &MockManager_GetStaticPodToMirrorPodMap_Call{Call: _e.mock.On("GetStaticPodToMirrorPodMap")}
}

func (_c *MockManager_GetStaticPodToMirrorPodMap_Call) Run(run func()) *MockManager_GetStaticPodToMirrorPodMap_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockManager_GetStaticPodToMirrorPodMap_Call) Return(_a0 map[*v1.Pod]*v1.Pod) *MockManager_GetStaticPodToMirrorPodMap_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockManager_GetStaticPodToMirrorPodMap_Call) RunAndReturn(run func() map[*v1.Pod]*v1.Pod) *MockManager_GetStaticPodToMirrorPodMap_Call {
	_c.Call.Return(run)
	return _c
}

// GetUIDTranslations provides a mock function with no fields
func (_m *MockManager) GetUIDTranslations() (map[kubelettypes.ResolvedPodUID]kubelettypes.MirrorPodUID, map[kubelettypes.MirrorPodUID]kubelettypes.ResolvedPodUID) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetUIDTranslations")
	}

	var r0 map[kubelettypes.ResolvedPodUID]kubelettypes.MirrorPodUID
	var r1 map[kubelettypes.MirrorPodUID]kubelettypes.ResolvedPodUID
	if rf, ok := ret.Get(0).(func() (map[kubelettypes.ResolvedPodUID]kubelettypes.MirrorPodUID, map[kubelettypes.MirrorPodUID]kubelettypes.ResolvedPodUID)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() map[kubelettypes.ResolvedPodUID]kubelettypes.MirrorPodUID); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[kubelettypes.ResolvedPodUID]kubelettypes.MirrorPodUID)
		}
	}

	if rf, ok := ret.Get(1).(func() map[kubelettypes.MirrorPodUID]kubelettypes.ResolvedPodUID); ok {
		r1 = rf()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(map[kubelettypes.MirrorPodUID]kubelettypes.ResolvedPodUID)
		}
	}

	return r0, r1
}

// MockManager_GetUIDTranslations_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetUIDTranslations'
type MockManager_GetUIDTranslations_Call struct {
	*mock.Call
}

// GetUIDTranslations is a helper method to define mock.On call
func (_e *MockManager_Expecter) GetUIDTranslations() *MockManager_GetUIDTranslations_Call {
	return &MockManager_GetUIDTranslations_Call{Call: _e.mock.On("GetUIDTranslations")}
}

func (_c *MockManager_GetUIDTranslations_Call) Run(run func()) *MockManager_GetUIDTranslations_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockManager_GetUIDTranslations_Call) Return(podToMirror map[kubelettypes.ResolvedPodUID]kubelettypes.MirrorPodUID, mirrorToPod map[kubelettypes.MirrorPodUID]kubelettypes.ResolvedPodUID) *MockManager_GetUIDTranslations_Call {
	_c.Call.Return(podToMirror, mirrorToPod)
	return _c
}

func (_c *MockManager_GetUIDTranslations_Call) RunAndReturn(run func() (map[kubelettypes.ResolvedPodUID]kubelettypes.MirrorPodUID, map[kubelettypes.MirrorPodUID]kubelettypes.ResolvedPodUID)) *MockManager_GetUIDTranslations_Call {
	_c.Call.Return(run)
	return _c
}

// RemovePod provides a mock function with given fields: _a0
func (_m *MockManager) RemovePod(_a0 *v1.Pod) {
	_m.Called(_a0)
}

// MockManager_RemovePod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'RemovePod'
type MockManager_RemovePod_Call struct {
	*mock.Call
}

// RemovePod is a helper method to define mock.On call
//   - _a0 *v1.Pod
func (_e *MockManager_Expecter) RemovePod(_a0 interface{}) *MockManager_RemovePod_Call {
	return &MockManager_RemovePod_Call{Call: _e.mock.On("RemovePod", _a0)}
}

func (_c *MockManager_RemovePod_Call) Run(run func(_a0 *v1.Pod)) *MockManager_RemovePod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(*v1.Pod))
	})
	return _c
}

func (_c *MockManager_RemovePod_Call) Return() *MockManager_RemovePod_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockManager_RemovePod_Call) RunAndReturn(run func(*v1.Pod)) *MockManager_RemovePod_Call {
	_c.Run(run)
	return _c
}

// SetPods provides a mock function with given fields: pods
func (_m *MockManager) SetPods(pods []*v1.Pod) {
	_m.Called(pods)
}

// MockManager_SetPods_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'SetPods'
type MockManager_SetPods_Call struct {
	*mock.Call
}

// SetPods is a helper method to define mock.On call
//   - pods []*v1.Pod
func (_e *MockManager_Expecter) SetPods(pods interface{}) *MockManager_SetPods_Call {
	return &MockManager_SetPods_Call{Call: _e.mock.On("SetPods", pods)}
}

func (_c *MockManager_SetPods_Call) Run(run func(pods []*v1.Pod)) *MockManager_SetPods_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].([]*v1.Pod))
	})
	return _c
}

func (_c *MockManager_SetPods_Call) Return() *MockManager_SetPods_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockManager_SetPods_Call) RunAndReturn(run func([]*v1.Pod)) *MockManager_SetPods_Call {
	_c.Run(run)
	return _c
}

// TranslatePodUID provides a mock function with given fields: uid
func (_m *MockManager) TranslatePodUID(uid types.UID) kubelettypes.ResolvedPodUID {
	ret := _m.Called(uid)

	if len(ret) == 0 {
		panic("no return value specified for TranslatePodUID")
	}

	var r0 kubelettypes.ResolvedPodUID
	if rf, ok := ret.Get(0).(func(types.UID) kubelettypes.ResolvedPodUID); ok {
		r0 = rf(uid)
	} else {
		r0 = ret.Get(0).(kubelettypes.ResolvedPodUID)
	}

	return r0
}

// MockManager_TranslatePodUID_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'TranslatePodUID'
type MockManager_TranslatePodUID_Call struct {
	*mock.Call
}

// TranslatePodUID is a helper method to define mock.On call
//   - uid types.UID
func (_e *MockManager_Expecter) TranslatePodUID(uid interface{}) *MockManager_TranslatePodUID_Call {
	return &MockManager_TranslatePodUID_Call{Call: _e.mock.On("TranslatePodUID", uid)}
}

func (_c *MockManager_TranslatePodUID_Call) Run(run func(uid types.UID)) *MockManager_TranslatePodUID_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(types.UID))
	})
	return _c
}

func (_c *MockManager_TranslatePodUID_Call) Return(_a0 kubelettypes.ResolvedPodUID) *MockManager_TranslatePodUID_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockManager_TranslatePodUID_Call) RunAndReturn(run func(types.UID) kubelettypes.ResolvedPodUID) *MockManager_TranslatePodUID_Call {
	_c.Call.Return(run)
	return _c
}

// UpdatePod provides a mock function with given fields: _a0
func (_m *MockManager) UpdatePod(_a0 *v1.Pod) {
	_m.Called(_a0)
}

// MockManager_UpdatePod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdatePod'
type MockManager_UpdatePod_Call struct {
	*mock.Call
}

// UpdatePod is a helper method to define mock.On call
//   - _a0 *v1.Pod
func (_e *MockManager_Expecter) UpdatePod(_a0 interface{}) *MockManager_UpdatePod_Call {
	return &MockManager_UpdatePod_Call{Call: _e.mock.On("UpdatePod", _a0)}
}

func (_c *MockManager_UpdatePod_Call) Run(run func(_a0 *v1.Pod)) *MockManager_UpdatePod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(*v1.Pod))
	})
	return _c
}

func (_c *MockManager_UpdatePod_Call) Return() *MockManager_UpdatePod_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockManager_UpdatePod_Call) RunAndReturn(run func(*v1.Pod)) *MockManager_UpdatePod_Call {
	_c.Run(run)
	return _c
}

// NewMockManager creates a new instance of MockManager. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockManager(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockManager {
	mock := &MockManager{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
