/*
	Plugin for Twolame encoder.

    Test with:
    ./ripperX_plugin_tester "twolame -b 224 music.wav music.mp2" "./ripperX_plugin-twolame 123 999"
    123 = begin, 999 = length
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>

#define TWOLAME_OUTPUT_BUF_LENGTH  	1024
#define PRINTOUT_INTERVAL       	0.5 * 1000000

int twolame_read_stat(float *current)
{
	char temp[TWOLAME_OUTPUT_BUF_LENGTH];
	int bytes_read;
	unsigned int value;
	char percent = '\0';
	char *p;

	// Grab new ouput from 'twolame'
	bytes_read = read(0, (void *) temp, sizeof(temp) - 1);
	if (bytes_read > 0)
	{
		temp[bytes_read] = '\0';

		if (p = (char *) strstr(temp, " frame: "))
		{
			p += 7;
			sscanf(p, " %*d/%*d ( %u%c", &value, &percent);
			*current = (float) value / 100;
			return (percent == '%') ? 0 : -1;
		}
	}
	return -1;
}

int main(int argc, char **argv)
{
	float current = 0;

    if (argc < 3)
        return 127;

	while (1)
	{
		if (twolame_read_stat(&current) == 0)
			// print message in form [P 0.xxxxx]\n
			printf("[P %f]\n", current);

		usleep(PRINTOUT_INTERVAL);
	}
}
