﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent-runtime/model/InputQueryType.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace BedrockAgentRuntime {
namespace Model {
namespace InputQueryTypeMapper {

static const int TEXT_HASH = HashingUtils::HashString("TEXT");

InputQueryType GetInputQueryTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == TEXT_HASH) {
    return InputQueryType::TEXT;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<InputQueryType>(hashCode);
  }

  return InputQueryType::NOT_SET;
}

Aws::String GetNameForInputQueryType(InputQueryType enumValue) {
  switch (enumValue) {
    case InputQueryType::NOT_SET:
      return {};
    case InputQueryType::TEXT:
      return "TEXT";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace InputQueryTypeMapper
}  // namespace Model
}  // namespace BedrockAgentRuntime
}  // namespace Aws
