<?php

declare(strict_types=1);

/**
 * This code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
 */

namespace Cucumber\Messages;

use JsonSerializable;
use Cucumber\Messages\DecodingException\SchemaViolationException;

/**
 * Represents the PickleDocString message in Cucumber's message protocol
 * @see https://github.com/cucumber/messages
 *
 */
final class PickleDocString implements JsonSerializable
{
    use JsonEncodingTrait;

    /**
     * Construct the PickleDocString with all properties
     *
     */
    public function __construct(
        public readonly ?string $mediaType = null,
        public readonly string $content = '',
    ) {
    }

    /**
     * @throws SchemaViolationException
     *
     * @internal
     */
    public static function fromArray(array $arr): self
    {
        self::ensureMediaType($arr);
        self::ensureContent($arr);

        return new self(
            isset($arr['mediaType']) ? (string) $arr['mediaType'] : null,
            (string) $arr['content'],
        );
    }

    /**
     * @psalm-assert array{mediaType?: string|int|bool} $arr
     */
    private static function ensureMediaType(array $arr): void
    {
        if (array_key_exists('mediaType', $arr) && is_array($arr['mediaType'])) {
            throw new SchemaViolationException('Property \'mediaType\' was array');
        }
    }

    /**
     * @psalm-assert array{content: string|int|bool} $arr
     */
    private static function ensureContent(array $arr): void
    {
        if (!array_key_exists('content', $arr)) {
            throw new SchemaViolationException('Property \'content\' is required but was not found');
        }
        if (array_key_exists('content', $arr) && is_array($arr['content'])) {
            throw new SchemaViolationException('Property \'content\' was array');
        }
    }
}
