/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextprint.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextprint.h>
        #include <wx/dc.h>
        #include <wx/gdicmn.h>
        #include <wx/cmndata.h>
        #include <wx/print.h>
        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxRichTextPrintout : public ::wxRichTextPrintout
{
public:
    sipwxRichTextPrintout(const ::wxString&);
    virtual ~sipwxRichTextPrintout();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void GetPageInfo(int*, int*, int*, int*) SIP_OVERRIDE;
    ::wxString GetTitle() const SIP_OVERRIDE;
    bool HasPage(int) SIP_OVERRIDE;
    bool IsPreview() const SIP_OVERRIDE;
    bool OnBeginDocument(int, int) SIP_OVERRIDE;
    void OnBeginPrinting() SIP_OVERRIDE;
    void OnEndDocument() SIP_OVERRIDE;
    void OnEndPrinting() SIP_OVERRIDE;
    void OnPreparePrinting() SIP_OVERRIDE;
    bool OnPrintPage(int) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxRichTextPrintout(const sipwxRichTextPrintout &);
    sipwxRichTextPrintout &operator = (const sipwxRichTextPrintout &);

    char sipPyMethods[10];
};

sipwxRichTextPrintout::sipwxRichTextPrintout(const ::wxString& title): ::wxRichTextPrintout(title), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextPrintout::~sipwxRichTextPrintout()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

void sipwxRichTextPrintout::GetPageInfo(int*minPage, int*maxPage, int*selPageFrom, int*selPageTo)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_GetPageInfo);

    if (!sipMeth)
    {
        ::wxRichTextPrintout::GetPageInfo(minPage, maxPage, selPageFrom, selPageTo);
        return;
    }

    extern void sipVH__richtext_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int*, int*, int*, int*);

    sipVH__richtext_144(sipGILState, 0, sipPySelf, sipMeth, minPage, maxPage, selPageFrom, selPageTo);
}

::wxString sipwxRichTextPrintout::GetTitle() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetTitle);

    if (!sipMeth)
        return ::wxRichTextPrintout::GetTitle();

    extern ::wxString sipVH__richtext_16(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__richtext_16(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxRichTextPrintout::HasPage(int page)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_HasPage);

    if (!sipMeth)
        return ::wxRichTextPrintout::HasPage(page);

    extern bool sipVH__richtext_143(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__richtext_143(sipGILState, 0, sipPySelf, sipMeth, page);
}

bool sipwxRichTextPrintout::IsPreview() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[3]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_IsPreview);

    if (!sipMeth)
        return ::wxRichTextPrintout::IsPreview();

    extern bool sipVH__richtext_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__richtext_9(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxRichTextPrintout::OnBeginDocument(int startPage, int endPage)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_OnBeginDocument);

    if (!sipMeth)
        return ::wxRichTextPrintout::OnBeginDocument(startPage, endPage);

    extern bool sipVH__richtext_105(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int, int);

    return sipVH__richtext_105(sipGILState, 0, sipPySelf, sipMeth, startPage, endPage);
}

void sipwxRichTextPrintout::OnBeginPrinting()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, SIP_NULLPTR, sipName_OnBeginPrinting);

    if (!sipMeth)
    {
        ::wxRichTextPrintout::OnBeginPrinting();
        return;
    }

    extern void sipVH__richtext_36(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__richtext_36(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxRichTextPrintout::OnEndDocument()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_OnEndDocument);

    if (!sipMeth)
    {
        ::wxRichTextPrintout::OnEndDocument();
        return;
    }

    extern void sipVH__richtext_36(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__richtext_36(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxRichTextPrintout::OnEndPrinting()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_OnEndPrinting);

    if (!sipMeth)
    {
        ::wxRichTextPrintout::OnEndPrinting();
        return;
    }

    extern void sipVH__richtext_36(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__richtext_36(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxRichTextPrintout::OnPreparePrinting()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[8], &sipPySelf, SIP_NULLPTR, sipName_OnPreparePrinting);

    if (!sipMeth)
    {
        ::wxRichTextPrintout::OnPreparePrinting();
        return;
    }

    extern void sipVH__richtext_36(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__richtext_36(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxRichTextPrintout::OnPrintPage(int page)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[9], &sipPySelf, SIP_NULLPTR, sipName_OnPrintPage);

    if (!sipMeth)
        return ::wxRichTextPrintout::OnPrintPage(page);

    extern bool sipVH__richtext_143(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__richtext_143(sipGILState, 0, sipPySelf, sipMeth, page);
}


PyDoc_STRVAR(doc_wxRichTextPrintout_CalculateScaling, "CalculateScaling(dc, textRect, headerRect, footerRect) -> None\n"
"\n"
"Calculates scaling and text, header and footer rectangles.");

extern "C" {static PyObject *meth_wxRichTextPrintout_CalculateScaling(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextPrintout_CalculateScaling(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC* dc;
        ::wxRect* textRect;
        int textRectState = 0;
        ::wxRect* headerRect;
        int headerRectState = 0;
        ::wxRect* footerRect;
        int footerRectState = 0;
        ::wxRichTextPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_textRect,
            sipName_headerRect,
            sipName_footerRect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1J1J1", &sipSelf, sipType_wxRichTextPrintout, &sipCpp, sipType_wxDC, &dc, sipType_wxRect, &textRect, &textRectState, sipType_wxRect, &headerRect, &headerRectState, sipType_wxRect, &footerRect, &footerRectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CalculateScaling(dc, *textRect, *headerRect, *footerRect);
            Py_END_ALLOW_THREADS
            sipReleaseType(textRect, sipType_wxRect, textRectState);
            sipReleaseType(headerRect, sipType_wxRect, headerRectState);
            sipReleaseType(footerRect, sipType_wxRect, footerRectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextPrintout, sipName_CalculateScaling, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextPrintout_GetHeaderFooterData, "GetHeaderFooterData() -> RichTextHeaderFooterData\n"
"\n"
"Returns the header and footer data associated with the printout.");

extern "C" {static PyObject *meth_wxRichTextPrintout_GetHeaderFooterData(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextPrintout_GetHeaderFooterData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextPrintout, &sipCpp))
        {
            ::wxRichTextHeaderFooterData*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxRichTextHeaderFooterData(sipCpp->GetHeaderFooterData());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxRichTextHeaderFooterData, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextPrintout, sipName_GetHeaderFooterData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextPrintout_GetPageInfo, "GetPageInfo() -> Tuple[int, int, int, int]\n"
"\n"
"Gets the page information.");

extern "C" {static PyObject *meth_wxRichTextPrintout_GetPageInfo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextPrintout_GetPageInfo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int minPage;
        int maxPage;
        int selPageFrom;
        int selPageTo;
        ::wxRichTextPrintout *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxRichTextPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxRichTextPrintout::GetPageInfo(&minPage, &maxPage, &selPageFrom, &selPageTo) : sipCpp->GetPageInfo(&minPage, &maxPage, &selPageFrom, &selPageTo));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(iiii)", minPage, maxPage, selPageFrom, selPageTo);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextPrintout, sipName_GetPageInfo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextPrintout_GetRichTextBuffer, "GetRichTextBuffer() -> RichTextBuffer\n"
"\n"
"Returns a pointer to the buffer being rendered.");

extern "C" {static PyObject *meth_wxRichTextPrintout_GetRichTextBuffer(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextPrintout_GetRichTextBuffer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextPrintout, &sipCpp))
        {
            ::wxRichTextBuffer*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRichTextBuffer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxRichTextBuffer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextPrintout, sipName_GetRichTextBuffer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextPrintout_HasPage, "HasPage(page) -> bool\n"
"\n"
"Returns true if the given page exists in the printout.");

extern "C" {static PyObject *meth_wxRichTextPrintout_HasPage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextPrintout_HasPage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int page;
        ::wxRichTextPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_page,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxRichTextPrintout, &sipCpp, &page))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxRichTextPrintout::HasPage(page) : sipCpp->HasPage(page));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextPrintout, sipName_HasPage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextPrintout_OnPreparePrinting, "OnPreparePrinting() -> None\n"
"\n"
"Prepares for printing, laying out the buffer and calculating\n"
"pagination.");

extern "C" {static PyObject *meth_wxRichTextPrintout_OnPreparePrinting(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextPrintout_OnPreparePrinting(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxRichTextPrintout *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextPrintout, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxRichTextPrintout::OnPreparePrinting() : sipCpp->OnPreparePrinting());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextPrintout, sipName_OnPreparePrinting, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextPrintout_OnPrintPage, "OnPrintPage(page) -> bool\n"
"\n"
"Does the actual printing for this page.");

extern "C" {static PyObject *meth_wxRichTextPrintout_OnPrintPage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextPrintout_OnPrintPage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int page;
        ::wxRichTextPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_page,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxRichTextPrintout, &sipCpp, &page))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxRichTextPrintout::OnPrintPage(page) : sipCpp->OnPrintPage(page));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextPrintout, sipName_OnPrintPage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextPrintout_SetHeaderFooterData, "SetHeaderFooterData(data) -> None\n"
"\n"
"Sets the header and footer data associated with the printout.");

extern "C" {static PyObject *meth_wxRichTextPrintout_SetHeaderFooterData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextPrintout_SetHeaderFooterData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextHeaderFooterData* data;
        ::wxRichTextPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextPrintout, &sipCpp, sipType_wxRichTextHeaderFooterData, &data))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHeaderFooterData(*data);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextPrintout, sipName_SetHeaderFooterData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextPrintout_SetMargins, "SetMargins(top=254, bottom=254, left=254, right=254) -> None\n"
"\n"
"Sets margins in 10ths of millimetre.");

extern "C" {static PyObject *meth_wxRichTextPrintout_SetMargins(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextPrintout_SetMargins(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int top = 254;
        int bottom = 254;
        int left = 254;
        int right = 254;
        ::wxRichTextPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_top,
            sipName_bottom,
            sipName_left,
            sipName_right,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|iiii", &sipSelf, sipType_wxRichTextPrintout, &sipCpp, &top, &bottom, &left, &right))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMargins(top, bottom, left, right);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextPrintout, sipName_SetMargins, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextPrintout_SetRichTextBuffer, "SetRichTextBuffer(buffer) -> None\n"
"\n"
"Sets the buffer to print.");

extern "C" {static PyObject *meth_wxRichTextPrintout_SetRichTextBuffer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextPrintout_SetRichTextBuffer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextBuffer* buffer;
        ::wxRichTextPrintout *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxRichTextPrintout, &sipCpp, sipType_wxRichTextBuffer, &buffer))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRichTextBuffer(buffer);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextPrintout, sipName_SetRichTextBuffer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextPrintout(void *, const sipTypeDef *);}
static void *cast_wxRichTextPrintout(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxRichTextPrintout *sipCpp = reinterpret_cast< ::wxRichTextPrintout *>(sipCppV);

    if (targetType == sipType_wxRichTextPrintout)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxPrintout)->ctd_cast(static_cast< ::wxPrintout *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextPrintout(void *, int);}
static void release_wxRichTextPrintout(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxRichTextPrintout *>(sipCppV);
    else
        delete reinterpret_cast< ::wxRichTextPrintout *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxRichTextPrintout(Py_ssize_t);}
static void *array_wxRichTextPrintout(Py_ssize_t sipNrElem)
{
    return new ::wxRichTextPrintout[sipNrElem];
}


extern "C" {static void array_delete_wxRichTextPrintout(void *);}
static void array_delete_wxRichTextPrintout(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxRichTextPrintout *>(sipCpp);
}


extern "C" {static void dealloc_wxRichTextPrintout(sipSimpleWrapper *);}
static void dealloc_wxRichTextPrintout(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxRichTextPrintout *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextPrintout(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxRichTextPrintout(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextPrintout(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxRichTextPrintout *sipCpp = SIP_NULLPTR;

    {
        const ::wxString& titledef = "Printout";
        const ::wxString* title = &titledef;
        int titleState = 0;

        static const char *sipKwdList[] = {
            sipName_title,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1", sipType_wxString, &title, &titleState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextPrintout(*title);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(title), sipType_wxString, titleState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextPrintout[] = {{51, 0, 1}};


static PyMethodDef methods_wxRichTextPrintout[] = {
    {sipName_CalculateScaling, SIP_MLMETH_CAST(meth_wxRichTextPrintout_CalculateScaling), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextPrintout_CalculateScaling},
    {sipName_GetHeaderFooterData, meth_wxRichTextPrintout_GetHeaderFooterData, METH_VARARGS, doc_wxRichTextPrintout_GetHeaderFooterData},
    {sipName_GetPageInfo, SIP_MLMETH_CAST(meth_wxRichTextPrintout_GetPageInfo), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextPrintout_GetPageInfo},
    {sipName_GetRichTextBuffer, meth_wxRichTextPrintout_GetRichTextBuffer, METH_VARARGS, doc_wxRichTextPrintout_GetRichTextBuffer},
    {sipName_HasPage, SIP_MLMETH_CAST(meth_wxRichTextPrintout_HasPage), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextPrintout_HasPage},
    {sipName_OnPreparePrinting, meth_wxRichTextPrintout_OnPreparePrinting, METH_VARARGS, doc_wxRichTextPrintout_OnPreparePrinting},
    {sipName_OnPrintPage, SIP_MLMETH_CAST(meth_wxRichTextPrintout_OnPrintPage), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextPrintout_OnPrintPage},
    {sipName_SetHeaderFooterData, SIP_MLMETH_CAST(meth_wxRichTextPrintout_SetHeaderFooterData), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextPrintout_SetHeaderFooterData},
    {sipName_SetMargins, SIP_MLMETH_CAST(meth_wxRichTextPrintout_SetMargins), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextPrintout_SetMargins},
    {sipName_SetRichTextBuffer, SIP_MLMETH_CAST(meth_wxRichTextPrintout_SetRichTextBuffer), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextPrintout_SetRichTextBuffer}
};

sipVariableDef variables_wxRichTextPrintout[] = {
    {PropertyVariable, sipName_RichTextBuffer, &methods_wxRichTextPrintout[3], &methods_wxRichTextPrintout[9], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_HeaderFooterData, &methods_wxRichTextPrintout[1], &methods_wxRichTextPrintout[7], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxRichTextPrintout, "RichTextPrintout(title=\"Printout\") -> None\n"
"\n"
"This class implements print layout for wxRichTextBuffer.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextPrintout = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextPrintout,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_RichTextPrintout,
        {0, 0, 1},
        10, methods_wxRichTextPrintout,
        0, SIP_NULLPTR,
        2, variables_wxRichTextPrintout,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextPrintout,
    -1,
    -1,
    supers_wxRichTextPrintout,
    SIP_NULLPTR,
    init_type_wxRichTextPrintout,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxRichTextPrintout,
    SIP_NULLPTR,
    array_wxRichTextPrintout,
    SIP_NULLPTR,
    release_wxRichTextPrintout,
    cast_wxRichTextPrintout,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxRichTextPrintout,
    sizeof (::wxRichTextPrintout),
};
