/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fi extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwichin normaaliaika",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acren normaaliaika",
               "",
               "Acren kes\u00e4aika",
               "",
               "Acren aika",
               "",
            };
        final String[] Apia = new String[] {
               "Apian normaaliaika",
               "",
               "Apian kes\u00e4aika",
               "",
               "Apian aika",
               "",
            };
        final String[] Cook = new String[] {
               "Cookinsaarten normaaliaika",
               "",
               "Cookinsaarten kes\u00e4aika",
               "",
               "Cookinsaarten aika",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuuban normaaliaika",
               "CST",
               "Kuuban kes\u00e4aika",
               "CDT",
               "Kuuban aika",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ein normaaliaika",
               "",
               "Fid\u017ein kes\u00e4aika",
               "",
               "Fid\u017ein aika",
               "",
            };
        final String[] Gulf = new String[] {
               "Arabiemiirikuntien normaaliaika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovdin normaaliaika",
               "",
               "Hovdin kes\u00e4aika",
               "",
               "Hovdin aika",
               "",
            };
        final String[] Iran = new String[] {
               "Iranin normaaliaika",
               "",
               "Iranin kes\u00e4aika",
               "",
               "Iranin aika",
               "",
            };
        final String[] Niue = new String[] {
               "Niuen aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omskin normaaliaika",
               "",
               "Omskin kes\u00e4aika",
               "",
               "Omskin aika",
               "",
            };
        final String[] Peru = new String[] {
               "Perun normaaliaika",
               "",
               "Perun kes\u00e4aika",
               "",
               "Perun aika",
               "",
            };
        final String[] Truk = new String[] {
               "Chuukin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Waken aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chilen normaaliaika",
               "",
               "Chilen kes\u00e4aika",
               "",
               "Chilen aika",
               "",
            };
        final String[] China = new String[] {
               "Kiinan normaaliaika",
               "CST",
               "Kiinan kes\u00e4aika",
               "CDT",
               "Kiinan aika",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kookossaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davisin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Intian aika",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japanin normaaliaika",
               "JST",
               "Japanin kes\u00e4aika",
               "JDT",
               "Japanin aika",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korean normaaliaika",
               "KST",
               "Korean kes\u00e4aika",
               "KST",
               "Korean aika",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Naurun aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palaun aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoan normaaliaika",
               "SST",
               "Samoan kes\u00e4aika",
               "SST",
               "Samoan aika",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongan normaaliaika",
               "",
               "Tongan kes\u00e4aika",
               "",
               "Tongan aika",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukonin aika",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaskan normaaliaika",
               "AKST",
               "Alaskan kes\u00e4aika",
               "AKDT",
               "Alaskan aika",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazonin normaaliaika",
               "",
               "Amazonin kes\u00e4aika",
               "",
               "Amazonin aika",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyrin normaaliaika",
               "",
               "Anadyrin kes\u00e4aika",
               "",
               "Anadyrin aika",
               "",
            };
        final String[] Azores = new String[] {
               "Azorien normaaliaika",
               "",
               "Azorien kes\u00e4aika",
               "",
               "Azorien aika",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutanin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunein aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "P\u00e4\u00e4si\u00e4issaaren normaaliaika",
               "",
               "P\u00e4\u00e4si\u00e4issaaren kes\u00e4aika",
               "",
               "P\u00e4\u00e4si\u00e4issaaren aika",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyanan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israelin normaaliaika",
               "IST",
               "Israelin kes\u00e4aika",
               "IDT",
               "Israelin aika",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosraen aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsonin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskovan normaaliaika",
               "MSK",
               "Moskovan kes\u00e4aika",
               "MSK",
               "Moskovan aika",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Pohnpein aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samaran normaaliaika",
               "",
               "Samaran kes\u00e4aika",
               "",
               "Samaran aika",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipein normaaliaika",
               "CST",
               "Taipein kes\u00e4aika",
               "CDT",
               "Taipein aika",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalun aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostokin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallisin ja Futunan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Saudi-Arabian normaaliaika",
               "",
               "Saudi-Arabian kes\u00e4aika",
               "",
               "Saudi-Arabian aika",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenian normaaliaika",
               "",
               "Armenian kes\u00e4aika",
               "",
               "Armenian aika",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chathamin normaaliaika",
               "",
               "Chathamin kes\u00e4aika",
               "",
               "Chathamin aika",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "UTC-yleisaika",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadorin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiersaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgian normaaliaika",
               "",
               "Georgian kes\u00e4aika",
               "",
               "Georgian aika",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutskin normaaliaika",
               "",
               "Irkutskin kes\u00e4aika",
               "",
               "Irkutskin aika",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadanin normaaliaika",
               "",
               "Magadanin kes\u00e4aika",
               "",
               "Magadanin aika",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmarin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkinsaaren normaaliaika",
               "",
               "Norfolkinsaaren kes\u00e4aika",
               "",
               "Norfolkinsaaren aika",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronhan normaaliaika",
               "",
               "Fernando de Noronhan kes\u00e4aika",
               "",
               "Fernando de Noronhan aika",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unionin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotheran aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonsaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelaun aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguayn normaaliaika",
               "",
               "Uruguayn kes\u00e4aika",
               "",
               "Uruguayn aika",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatun normaaliaika",
               "",
               "Vanuatun kes\u00e4aika",
               "",
               "Vanuatun aika",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutskin normaaliaika",
               "",
               "Jakutskin kes\u00e4aika",
               "",
               "Jakutskin aika",
               "",
            };
        final String[] Atlantic = new String[] {
               "Kanadan Atlantin normaaliaika",
               "AST",
               "Kanadan Atlantin kes\u00e4aika",
               "AST",
               "Kanadan Atlantin aika",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilian normaaliaika",
               "",
               "Brasilian kes\u00e4aika",
               "",
               "Brasilian aika",
               "",
            };
        final String[] Chamorro = new String[] {
               "T\u0161amorron aika",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbian normaaliaika",
               "",
               "Kolumbian kes\u00e4aika",
               "",
               "Kolumbian aika",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandinsaarten normaaliaika",
               "",
               "Falklandinsaarten kes\u00e4aika",
               "",
               "Falklandinsaarten aika",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malesian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Malediivien aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batorin normaaliaika",
               "",
               "Ulan Batorin kes\u00e4aika",
               "",
               "Ulan Batorin aika",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistanin normaaliaika",
               "PKT",
               "Pakistanin kes\u00e4aika",
               "PKST",
               "Pakistanin aika",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayn normaaliaika",
               "",
               "Paraguayn kes\u00e4aika",
               "",
               "Paraguayn aika",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairnin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahalinin normaaliaika",
               "",
               "Sahalinin kes\u00e4aika",
               "",
               "Sahalinin aika",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamen aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentiinan normaaliaika",
               "",
               "Argentiinan kes\u00e4aika",
               "",
               "Argentiinan aika",
               "",
            };
        final String[] Christmas = new String[] {
               "Joulusaaren aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Gal\u00e1pagossaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongin normaaliaika",
               "HKT",
               "Hongkongin kes\u00e4aika",
               "HKST",
               "Hongkongin aika",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indokiinan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Kamt\u0161atkan normaaliaika",
               "",
               "Kamt\u0161atkan kes\u00e4aika",
               "",
               "Kamt\u0161atkan aika",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howen normaaliaika",
               "",
               "Lord Howen kes\u00e4aika",
               "",
               "Lord Howen aika",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesassaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritiuksen normaaliaika",
               "",
               "Mauritiuksen kes\u00e4aika",
               "",
               "Mauritiuksen aika",
               "",
            };
        final String[] Singapore = new String[] {
               "Singaporen aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuelan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgogradin normaaliaika",
               "MSK",
               "Volgogradin kes\u00e4aika",
               "MSK",
               "Volgogradin aika",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaid\u017eanin normaaliaika",
               "",
               "Azerbaid\u017eanin kes\u00e4aika",
               "",
               "Azerbaid\u017eanin aika",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladeshin normaaliaika",
               "",
               "Bangladeshin kes\u00e4aika",
               "",
               "Bangladeshin aika",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kap Verden normaaliaika",
               "",
               "Kap Verden kes\u00e4aika",
               "",
               "Kap Verden aika",
               "",
            };
        final String[] East_Timor = new String[] {
               "It\u00e4-Timorin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kazakstanin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychellien aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikistanin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistanin normaaliaika",
               "",
               "Uzbekistanin kes\u00e4aika",
               "",
               "Uzbekistanin aika",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistanin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarskin normaaliaika",
               "",
               "Krasnojarskin kes\u00e4aika",
               "",
               "Krasnojarskin aika",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Uuden-Seelannin normaaliaika",
               "NZST",
               "Uuden-Seelannin kes\u00e4aika",
               "NZDT",
               "Uuden-Seelannin aika",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirskin normaaliaika",
               "",
               "Novosibirskin kes\u00e4aika",
               "",
               "Novosibirskin aika",
               "",
            };
        final String[] Philippines = new String[] {
               "Filippiinien normaaliaika",
               "PST",
               "Filippiinien kes\u00e4aika",
               "PDT",
               "Filippiinien aika",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostokin normaaliaika",
               "",
               "Vladivostokin kes\u00e4aika",
               "",
               "Vladivostokin aika",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Intian valtameren aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Linesaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlandin normaaliaika",
               "NST",
               "Newfoundlandin kes\u00e4aika",
               "NDT",
               "Newfoundlandin aika",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistanin normaaliaika",
               "",
               "Turkmenistanin kes\u00e4aika",
               "",
               "Turkmenistanin aika",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ranskan Guayanan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Uuden-Kaledonian normaaliaika",
               "",
               "Uuden-Kaledonian kes\u00e4aika",
               "",
               "Uuden-Kaledonian aika",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Etel\u00e4-Georgian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgin normaaliaika",
               "",
               "Jekaterinburgin kes\u00e4aika",
               "",
               "Jekaterinburgin aika",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Keski-Afrikan aika",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "It\u00e4-Afrikan aika",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "L\u00e4nsi-Afrikan normaaliaika",
               "WAT",
               "L\u00e4nsi-Afrikan kes\u00e4aika",
               "WAT",
               "L\u00e4nsi-Afrikan aika",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont d\u2019Urvillen aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Keski-Euroopan normaaliaika",
               "CET",
               "Keski-Euroopan kes\u00e4aika",
               "CEST",
               "Keski-Euroopan aika",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "It\u00e4-Euroopan normaaliaika",
               "EET",
               "It\u00e4-Euroopan kes\u00e4aika",
               "EEST",
               "It\u00e4-Euroopan aika",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "L\u00e4nsi-Euroopan normaaliaika",
               "WET",
               "L\u00e4nsi-Euroopan kes\u00e4aika",
               "WEST",
               "L\u00e4nsi-Euroopan aika",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksikon Tyynenmeren normaaliaika",
               "MST",
               "Meksikon Tyynenmeren kes\u00e4aika",
               "MDT",
               "Meksikon Tyynenmeren aika",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Etel\u00e4-Afrikan aika",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Yhdysvaltain keskinen normaaliaika",
               "CST",
               "Yhdysvaltain keskinen kes\u00e4aika",
               "CDT",
               "Yhdysvaltain keskinen aika",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Yhdysvaltain it\u00e4inen normaaliaika",
               "EST",
               "Yhdysvaltain it\u00e4inen kes\u00e4aika",
               "EST",
               "Yhdysvaltain it\u00e4inen aika",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Yhdysvaltain Tyynenmeren normaaliaika",
               "PST",
               "Yhdysvaltain Tyynenmeren kes\u00e4aika",
               "PDT",
               "Yhdysvaltain Tyynenmeren aika",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Ranskan etel\u00e4isten ja antarktisten alueiden aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbertsaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havaijin-Aleuttien normaaliaika",
               "HST",
               "Havaijin-Aleuttien kes\u00e4aika",
               "HST",
               "Havaijin-Aleuttien aika",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixsaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierren ja Miquelonin normaaliaika",
               "",
               "Saint-Pierren ja Miquelonin kes\u00e4aika",
               "",
               "Saint-Pierren ja Miquelonin aika",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Kalliovuorten normaaliaika",
               "MST",
               "Kalliovuorten kes\u00e4aika",
               "MST",
               "Kalliovuorten aika",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshallinsaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Uuden-Guinean aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Keski-Australian normaaliaika",
               "ACST",
               "Keski-Australian kes\u00e4aika",
               "ACDT",
               "Keski-Australian aika",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "It\u00e4-Australian normaaliaika",
               "AEST",
               "It\u00e4-Australian kes\u00e4aika",
               "AEDT",
               "It\u00e4-Australian aika",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "L\u00e4nsi-Australian normaaliaika",
               "AWST",
               "L\u00e4nsi-Australian kes\u00e4aika",
               "AWDT",
               "L\u00e4nsi-Australian aika",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Keski-Indonesian aika",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "It\u00e4-Indonesian aika",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "L\u00e4nsi-Indonesian aika",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "L\u00e4ntisen Keski-Australian normaaliaika",
               "",
               "L\u00e4ntisen Keski-Australian kes\u00e4aika",
               "",
               "L\u00e4ntisen Keski-Australian aika",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwichin normaaliaika",
                    "GMT",
                    "Britannian kes\u00e4aika",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "UTC-yleisaika",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwichin normaaliaika",
                    "GMT",
                    "Irlannin kes\u00e4aika",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "UTC-yleisaika",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "UTC-yleisaika",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwichin normaaliaika",
                    "GMT",
                    "Britannian kes\u00e4aika",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "UTC-yleisaika",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "UTC-yleisaika",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "UTC-yleisaika",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichin normaaliaika",
                    "GMT",
                    "Irlannin kes\u00e4aika",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwichin normaaliaika",
                    "GMT",
                    "Britannian kes\u00e4aika",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwichin normaaliaika",
                    "GMT",
                    "Britannian kes\u00e4aika",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwichin normaaliaika",
                    "GMT",
                    "Britannian kes\u00e4aika",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwichin normaaliaika",
                    "GMT",
                    "Britannian kes\u00e4aika",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwichin normaaliaika",
                    "GMT",
                    "Britannian kes\u00e4aika",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Oral", "Uralsk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aqtaw" },
            { "timezone.excity.Asia/Chita", "T\u0161ita" },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "timezone.excity.Asia/Atyrau", "At\u0131raw" },
            { "timezone.excity.Asia/Muscat", "Masqat" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Saigon", "H\u1ed3 Ch\u00ed Minhin kaupunki" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "tuntematon" },
            { "timezone.excity.Europe/Kiev", "Kiova" },
            { "timezone.excity.Europe/Riga", "Riika" },
            { "timezone.excity.Europe/Rome", "Rooma" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Paris", "Pariisi" },
            { "timezone.excity.Indian/Cocos", "Kookossaaret" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Asia/Ashgabat", "A\u0161gabat" },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "timezone.excity.Asia/Damascus", "Damaskos" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Khandyga", "Handyga" },
            { "timezone.excity.Asia/Qostanay", "Kostanai" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.Europe/Athens", "Ateena" },
            { "timezone.excity.Europe/Berlin", "Berliini" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/London", "Lontoo" },
            { "timezone.excity.Europe/Moscow", "Moskova" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "timezone.excity.Europe/Warsaw", "Varsova" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Comoro", "Komorit" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Kamchatka", "Kamt\u0161atka" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjang" },
            { "timezone.excity.Asia/Qyzylorda", "Q\u0131z\u0131lorda" },
            { "timezone.excity.Europe/Tallinn", "Tallinna" },
            { "timezone.excity.Europe/Vatican", "Vatikaani" },
            { "timezone.excity.Europe/Vilnius", "Vilna" },
            { "timezone.excity.Pacific/Easter", "P\u00e4\u00e4si\u00e4issaari" },
            { "timezone.excity.Pacific/Midway", "Midwaysaaret" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Atlantic/Azores", "Azorit" },
            { "timezone.excity.Atlantic/Canary", "Kanariansaaret" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e4rsaaret" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Bryssel" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Chisinau", "Chi\u015fin\u0103u" },
            { "timezone.excity.Indian/Maldives", "Malediivit" },
            { "timezone.excity.Pacific/Chatham", "Chathamsaaret" },
            { "timezone.excity.Pacific/Gambier", "Gambiersaaret" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/Santiago", "Santiago de Chile" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Europe/Astrakhan", "Astrahan" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Mariehamn", "Maarianhamina" },
            { "timezone.excity.Europe/Stockholm", "Tukholma" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Indian/Christmas", "Joulusaari" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelensaaret" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Copenhagen", "K\u00f6\u00f6penhamina" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Marquesas", "Marquesassaaret" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Saint Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Mansaari" },
            { "timezone.excity.America/Mexico_City", "Ciudad de M\u00e9xico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "timezone.excity.Antarctica/Macquarie", "Macquariensaari" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.Atlantic/South_Georgia", "Etel\u00e4-Georgia" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Pohjois-Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Pohjois-Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Pohjois-Dakota" },
        };
        return data;
    }
}
