/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureElementState;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureItemPresentation;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewModel;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewSelectionManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.impl.JupyterPsiCellImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0003J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%J\u0010\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)J\b\u0010*\u001a\u00020'H\u0002J\b\u0010+\u001a\u00020'H\u0002J\b\u0010,\u001a\u00020'H\u0002J\u0010\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020\u001eH\u0002J\u0010\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u001eH\u0002J\b\u00101\u001a\u00020\u001eH\u0002J\b\u00102\u001a\u000203H\u0002J\r\u00104\u001a\u000703\u00a2\u0006\u0002\b5H\u0002J\u0010\u00106\u001a\u00020'2\u0006\u00107\u001a\u00020\u000eH\u0016J\n\u00108\u001a\u0004\u0018\u000109H\u0002J\u0013\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001c0;H\u0016\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020\u000eH\u0016J\b\u0010@\u001a\u00020\u000eH\u0016J\b\u0010A\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement;", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "cell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "title", "", "level", "", "parent", "model", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;", "cellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "isCodeCellHeading", "", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;Ljava/lang/String;ILcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement;Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;Z)V", "getLevel", "()I", "getParent", "()Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement;", "getModel", "()Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;", "getCellType", "()Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "()Z", "children", "", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "executionState", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureElementState;", "associatedIntervals", "addChild", "child", "associateInterval", "interval", "collectAllRelatedIntervals", "", "updateStatus", "", "status", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "markAsExecuting", "markAsQueued", "markAsError", "propagateState", "state", "shouldUpdateState", "newState", "getExecutionState", "getIcon", "Ljavax/swing/Icon;", "getCellTypeIcon", "Lorg/jetbrains/annotations/NotNull;", "navigate", "requestFocus", "getRespectivePsiCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/impl/JupyterPsiCellImpl;", "getChildren", "", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "canNavigate", "canNavigateToSource", "getValue", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterStructureViewCellElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterStructureViewCellElement.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,125:1\n1869#2:126\n1870#2:128\n1617#2,9:129\n1869#2:138\n1870#2:140\n1626#2:141\n1761#2,3:143\n1#3:127\n1#3:139\n183#4:142\n184#4:146\n37#5:147\n36#5,3:148\n*S KotlinDebug\n*F\n+ 1 JupyterStructureViewCellElement.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement\n*L\n36#1:126\n36#1:128\n83#1:129,9\n83#1:138\n83#1:140\n83#1:141\n90#1:143,3\n83#1:139\n89#1:142\n89#1:146\n119#1:147\n119#1:148,3\n*E\n"})
public final class JupyterStructureViewCellElement
implements StructureViewTreeElement {
    @NotNull
    private final NotebookCellLines.Interval cell;
    @NotNull
    private final String title;
    private final int level;
    @Nullable
    private final JupyterStructureViewCellElement parent;
    @NotNull
    private final JupyterStructureViewModel model;
    @NotNull
    private final JupyterCellType cellType;
    private final boolean isCodeCellHeading;
    @NotNull
    private final List<TreeElement> children;
    @NotNull
    private JupyterStructureElementState executionState;
    @NotNull
    private final List<NotebookCellLines.Interval> associatedIntervals;

    public JupyterStructureViewCellElement(@NotNull NotebookCellLines.Interval cell, @NotNull String title, int level, @Nullable JupyterStructureViewCellElement parent, @NotNull JupyterStructureViewModel model, @NotNull JupyterCellType cellType, boolean isCodeCellHeading) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        this.cell = cell;
        this.title = title;
        this.level = level;
        this.parent = parent;
        this.model = model;
        this.cellType = cellType;
        this.isCodeCellHeading = isCodeCellHeading;
        this.children = new ArrayList();
        this.executionState = JupyterStructureElementState.NOT_RUNNING;
        this.associatedIntervals = new ArrayList();
    }

    public /* synthetic */ JupyterStructureViewCellElement(NotebookCellLines.Interval interval, String string, int n, JupyterStructureViewCellElement jupyterStructureViewCellElement, JupyterStructureViewModel jupyterStructureViewModel, JupyterCellType jupyterCellType, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            jupyterStructureViewCellElement = null;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        this(interval, string, n, jupyterStructureViewCellElement, jupyterStructureViewModel, jupyterCellType, bl);
    }

    public final int getLevel() {
        return this.level;
    }

    @Nullable
    public final JupyterStructureViewCellElement getParent() {
        return this.parent;
    }

    @NotNull
    public final JupyterStructureViewModel getModel() {
        return this.model;
    }

    @NotNull
    public final JupyterCellType getCellType() {
        return this.cellType;
    }

    public final boolean isCodeCellHeading() {
        return this.isCodeCellHeading;
    }

    public final boolean addChild(@NotNull TreeElement child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return this.children.add(child);
    }

    public final boolean associateInterval(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.associatedIntervals.add(interval);
    }

    @NotNull
    public final List<NotebookCellLines.Interval> collectAllRelatedIntervals() {
        List intervals = new ArrayList();
        intervals.addAll((Collection)this.associatedIntervals);
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreeElement child = (TreeElement)element$iv;
            boolean bl = false;
            Object object = child instanceof JupyterStructureViewCellElement ? (JupyterStructureViewCellElement)child : null;
            if (object == null || (object = ((JupyterStructureViewCellElement)object).collectAllRelatedIntervals()) == null) continue;
            Object it = object;
            boolean bl2 = false;
            intervals.addAll((Collection)it);
        }
        return intervals;
    }

    public final void updateStatus(@Nullable ProgressStatus status) {
        ProgressStatus progressStatus = status;
        switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1: {
                this.markAsExecuting();
                break;
            }
            case 2: {
                this.markAsQueued();
                break;
            }
            case 3: {
                this.markAsError();
            }
        }
    }

    private final void markAsExecuting() {
        block0: {
            this.executionState = JupyterStructureElementState.RUNNING;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = this.parent;
            if (jupyterStructureViewCellElement == null) break block0;
            jupyterStructureViewCellElement.propagateState(JupyterStructureElementState.RUNNING);
        }
    }

    private final void markAsQueued() {
        block1: {
            if (this.executionState != JupyterStructureElementState.NOT_RUNNING) break block1;
            this.executionState = JupyterStructureElementState.QUEUED;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = this.parent;
            if (jupyterStructureViewCellElement != null) {
                jupyterStructureViewCellElement.propagateState(JupyterStructureElementState.QUEUED);
            }
        }
    }

    private final void markAsError() {
        block0: {
            this.executionState = JupyterStructureElementState.ERROR;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = this.parent;
            if (jupyterStructureViewCellElement == null) break block0;
            jupyterStructureViewCellElement.propagateState(JupyterStructureElementState.ERROR);
        }
    }

    private final void propagateState(JupyterStructureElementState state) {
        block1: {
            if (!this.shouldUpdateState(state)) break block1;
            this.executionState = state;
            JupyterStructureViewCellElement jupyterStructureViewCellElement = this.parent;
            if (jupyterStructureViewCellElement != null) {
                jupyterStructureViewCellElement.propagateState(state);
            }
        }
    }

    private final boolean shouldUpdateState(JupyterStructureElementState newState) {
        return switch (WhenMappings.$EnumSwitchMapping$1[this.executionState.ordinal()]) {
            case 1 -> true;
            case 2 -> {
                if (newState == JupyterStructureElementState.RUNNING || newState == JupyterStructureElementState.ERROR) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (newState == JupyterStructureElementState.ERROR) {
                    yield true;
                }
                yield false;
            }
            case 4 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final JupyterStructureElementState getExecutionState() {
        JupyterStructureElementState jupyterStructureElementState;
        Object v2;
        block8: {
            Object element$iv;
            boolean bl;
            void $this$mapNotNullTo$iv$iv;
            JupyterStructureElementState[] jupyterStructureElementStateArray = new JupyterStructureElementState[]{JupyterStructureElementState.ERROR, JupyterStructureElementState.RUNNING};
            if (SetsKt.setOf((Object[])jupyterStructureElementStateArray).contains((Object)this.executionState)) {
                return this.executionState;
            }
            Iterable $this$mapNotNull$iv = this.children;
            boolean $i$f$mapNotNull22 = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                JupyterStructureElementState it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                TreeElement treeElement = (TreeElement)element$iv$iv;
                boolean bl3 = false;
                JupyterStructureViewCellElement jupyterStructureViewCellElement = treeElement instanceof JupyterStructureViewCellElement ? (JupyterStructureViewCellElement)treeElement : null;
                if ((jupyterStructureViewCellElement != null ? jupyterStructureViewCellElement.getExecutionState() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List childStates = (List)destination$iv$iv;
            JupyterStructureElementState[] $i$f$mapNotNull22 = new JupyterStructureElementState[]{JupyterStructureElementState.ERROR, JupyterStructureElementState.RUNNING, JupyterStructureElementState.QUEUED};
            Sequence $this$firstOrNull$iv = SequencesKt.sequenceOf((Object[])$i$f$mapNotNull22);
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            do {
                block14: {
                    block11: {
                        boolean bl5;
                        block9: {
                            Iterator iterator3;
                            JupyterStructureElementState state;
                            block13: {
                                block10: {
                                    Iterable $this$any$iv;
                                    block12: {
                                        if (!iterator2.hasNext()) break block10;
                                        element$iv = iterator2.next();
                                        state = (JupyterStructureElementState)((Object)element$iv);
                                        boolean bl6 = false;
                                        if (this.executionState == state) break block11;
                                        $this$any$iv = childStates;
                                        boolean $i$f$any = false;
                                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block12;
                                        bl5 = false;
                                        break block9;
                                    }
                                    iterator3 = $this$any$iv.iterator();
                                    break block13;
                                }
                                v2 = null;
                                break block8;
                            }
                            while (iterator3.hasNext()) {
                                Object element$iv2 = iterator3.next();
                                JupyterStructureElementState jupyterStructureElementState2 = (JupyterStructureElementState)((Object)element$iv2);
                                boolean bl7 = false;
                                if (!(jupyterStructureElementState2 == state)) continue;
                                bl5 = true;
                                break block9;
                            }
                            bl5 = false;
                        }
                        if (!bl5) break block14;
                    }
                    bl = true;
                    continue;
                }
                bl = false;
            } while (!bl);
            v2 = element$iv;
        }
        if ((jupyterStructureElementState = (JupyterStructureElementState)v2) == null) {
            jupyterStructureElementState = JupyterStructureElementState.NOT_RUNNING;
        }
        return jupyterStructureElementState;
    }

    private final Icon getIcon() {
        Icon icon;
        switch (WhenMappings.$EnumSwitchMapping$1[this.getExecutionState().ordinal()]) {
            case 3: {
                Icon icon2 = AllIcons.RunConfigurations.TestState.Run_run;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Run_run");
                break;
            }
            case 2: {
                Icon icon3 = AllIcons.General.History;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"History");
                break;
            }
            case 4: {
                Icon icon4 = JupyterCoreIcons.ResultIncorrect;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ResultIncorrect");
                break;
            }
            case 1: {
                icon = this.getCellTypeIcon();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    private final Icon getCellTypeIcon() {
        Icon icon = switch (WhenMappings.$EnumSwitchMapping$2[JupyterCellLinesExtensionsKt.toJupyterCellType(this.cell.getType()).ordinal()]) {
            case 1 -> JupyterCoreIcons.MarkdownCell;
            case 2 -> JupyterCoreIcons.CodeCell;
            default -> (Icon)EmptyIcon.create((int)16, (int)16);
        };
        Intrinsics.checkNotNull((Object)icon);
        return icon;
    }

    public void navigate(boolean requestFocus) {
        JupyterStructureViewSelectionManager jupyterStructureViewSelectionManager = this.model.getSelectionManager();
        if (jupyterStructureViewSelectionManager == null) {
            return;
        }
        JupyterStructureViewSelectionManager selectionModel = jupyterStructureViewSelectionManager;
        selectionModel.withNavigationFlag((Function0<Unit>)((Function0)() -> JupyterStructureViewCellElement.navigate$lambda$6(this, requestFocus)));
    }

    private final JupyterPsiCellImpl getRespectivePsiCell() {
        Editor editor = this.model.getEditor();
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        JupyterPsiCell jupyterPsiCell = JupyterHelper.INSTANCE.getPsiCell(editor2, this.cell.getOrdinal());
        return jupyterPsiCell instanceof JupyterPsiCellImpl ? (JupyterPsiCellImpl)jupyterPsiCell : null;
    }

    @NotNull
    public TreeElement[] getChildren() {
        Collection $this$toTypedArray$iv = this.children;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TreeElement[0]);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return (ItemPresentation)new JupyterStructureItemPresentation(this.title, null, this.getIcon(), this.level);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @NotNull
    public NotebookCellLines.Interval getValue() {
        return this.cell;
    }

    private static final Unit navigate$lambda$6(JupyterStructureViewCellElement this$0, boolean $requestFocus) {
        block0: {
            JupyterPsiCellImpl jupyterPsiCellImpl;
            JupyterPsiCellImpl it = jupyterPsiCellImpl = this$0.getRespectivePsiCell();
            boolean bl = false;
            JupyterPsiCellImpl jupyterPsiCellImpl2 = it;
            Object object = (jupyterPsiCellImpl2 != null ? jupyterPsiCellImpl2.isValid() : false) ? jupyterPsiCellImpl : null;
            if (object == null) break block0;
            object.navigate($requestFocus);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ProgressStatus.values().length];
            try {
                nArray[ProgressStatus.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.QUEUED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.STOPPED_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JupyterStructureElementState.values().length];
            try {
                nArray[JupyterStructureElementState.NOT_RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterStructureElementState.QUEUED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterStructureElementState.RUNNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterStructureElementState.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[JupyterCellType.values().length];
            try {
                nArray[JupyterCellType.MARKDOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterCellType.CODE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

