/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser.core;

import com.vladsch.flexmark.ast.CodeBlock;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.BlockQuoteParser;
import com.vladsch.flexmark.parser.core.HeadingParser;
import com.vladsch.flexmark.parser.core.HtmlBlockParser;
import com.vladsch.flexmark.parser.core.IndentedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListBlockParser;
import com.vladsch.flexmark.parser.core.ThematicBreakParser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FencedCodeBlockParser
extends AbstractBlockParser {
    private static final Pattern OPENING_FENCE = Pattern.compile("^`{3,}(?!.*`)|^~{3,}(?!.*~)");
    private static final Pattern CLOSING_FENCE = Pattern.compile("^(?:`{3,}|~{3,})(?=[ \t]*$)");
    private final FencedCodeBlock block = new FencedCodeBlock();
    private BlockContent content = new BlockContent();
    private final char fenceChar;
    private final int fenceLength;
    private final int fenceIndent;
    private final int fenceMarkerIndent;
    private final boolean matchingCloser;
    private final boolean codeContentBlock;

    public FencedCodeBlockParser(DataHolder options, char fenceChar, int fenceLength, int fenceIndent, int fenceMarkerIndent) {
        this.fenceChar = fenceChar;
        this.fenceLength = fenceLength;
        this.fenceIndent = fenceIndent;
        this.fenceMarkerIndent = fenceIndent + fenceMarkerIndent;
        this.matchingCloser = Parser.MATCH_CLOSING_FENCE_CHARACTERS.get(options);
        this.codeContentBlock = Parser.FENCED_CODE_CONTENT_BLOCK.get(options);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    public int getFenceIndent() {
        return this.fenceIndent;
    }

    public int getFenceMarkerIndent() {
        return this.fenceMarkerIndent;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        int foundFenceLength;
        BasedSequence trySequence;
        Matcher matcher;
        boolean matches;
        int nextNonSpace = state.getNextNonSpaceIndex();
        int newIndex = state.getIndex();
        BasedSequence line = state.getLine();
        boolean bl = matches = state.getIndent() <= 3 && nextNonSpace < line.length() && (!this.matchingCloser || line.charAt(nextNonSpace) == this.fenceChar);
        if (matches && (matcher = CLOSING_FENCE.matcher(trySequence = line.subSequence(nextNonSpace, line.length()))).find() && (foundFenceLength = matcher.group(0).length()) >= this.fenceLength) {
            this.block.setClosingMarker(trySequence.subSequence(0, foundFenceLength));
            return BlockContinue.finished();
        }
        for (int i = this.fenceIndent; i > 0 && newIndex < line.length() && line.charAt(newIndex) == ' '; ++newIndex, --i) {
        }
        return BlockContinue.atIndex(newIndex);
    }

    @Override
    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    @Override
    public boolean isPropagatingLastBlankLine(BlockParser lastMatchedBlockParser) {
        return false;
    }

    @Override
    public void closeBlock(ParserState state) {
        List<BasedSequence> lines = this.content.getLines();
        if (lines.size() > 0) {
            BasedSequence info = lines.get(0);
            if (!info.isBlank()) {
                this.block.setInfo((BasedSequence)info.trim());
            }
            BasedSequence chars = this.content.getSpanningChars();
            BasedSequence spanningChars = chars.baseSubSequence(chars.getStartOffset(), lines.get(0).getEndOffset());
            if (lines.size() > 1) {
                List<BasedSequence> segments = lines.subList(1, lines.size());
                this.block.setContent(spanningChars, segments);
                if (this.codeContentBlock) {
                    CodeBlock codeBlock = new CodeBlock();
                    codeBlock.setContent(segments);
                    codeBlock.setCharsFromContent();
                    this.block.appendChild(codeBlock);
                } else {
                    Text codeBlock = new Text(SegmentedSequence.create(chars, segments));
                    this.block.appendChild(codeBlock);
                }
            } else {
                this.block.setContent(spanningChars, BasedSequence.EMPTY_LIST);
            }
        } else {
            this.block.setContent(this.content);
        }
        this.block.setCharsFromContent();
        this.content = null;
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private BlockFactory(DataHolder options) {
            super(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence trySequence;
            Matcher matcher;
            int nextNonSpace = state.getNextNonSpaceIndex();
            BasedSequence line = state.getLine();
            if (state.getIndent() < 4 && (matcher = OPENING_FENCE.matcher(trySequence = line.subSequence(nextNonSpace, line.length()))).find()) {
                int fenceLength = matcher.group(0).length();
                char fenceChar = matcher.group(0).charAt(0);
                FencedCodeBlockParser blockParser = new FencedCodeBlockParser(state.getProperties(), fenceChar, fenceLength, state.getIndent(), nextNonSpace);
                blockParser.block.setOpeningMarker(trySequence.subSequence(0, fenceLength));
                return BlockStart.of(blockParser).atIndex(nextNonSpace + fenceLength);
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return new HashSet(Arrays.asList(BlockQuoteParser.Factory.class, HeadingParser.Factory.class));
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return new HashSet(Arrays.asList(HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class, ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

