/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.api.SharedIndexStorage;
import com.intellij.indexing.shared.platform.api.layout.SharedChunkLocation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0005J\b\u0010\u0018\u001a\u00020\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/indexing/shared/platform/impl/MemBasedSharedIndexStorage;", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStorage;", "<init>", "()V", "storageId", "", "getStorageId", "()Ljava/lang/String;", "stats", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStats;", "kotlin.jvm.PlatformType", "chunks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/indexing/shared/platform/api/layout/SharedChunkLocation;", "getSharedIndexStats", "isCompatibleChunk", "", "chunkId", "getChunkRoot", "removeChunk", "", "appendChunk", "chunkSourcePath", "close", "intellij.indexing.shared"})
public final class MemBasedSharedIndexStorage
implements SharedIndexStorage {
    @NotNull
    private final String storageId;
    @NotNull
    private final AtomicReference<SharedIndexStats> stats = new AtomicReference<SharedIndexStats>(new SharedIndexStats(0L, 0));
    @NotNull
    private final ConcurrentHashMap<String, SharedChunkLocation> chunks = new ConcurrentHashMap();

    public MemBasedSharedIndexStorage() {
        this.storageId = "MemStorage";
    }

    @Override
    @NotNull
    public String getStorageId() {
        return this.storageId;
    }

    @Override
    @NotNull
    public SharedIndexStats getSharedIndexStats() {
        SharedIndexStats sharedIndexStats = this.stats.get();
        Intrinsics.checkNotNullExpressionValue((Object)sharedIndexStats, (String)"get(...)");
        return sharedIndexStats;
    }

    @Override
    public boolean isCompatibleChunk(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return this.getChunkRoot(chunkId) != null;
    }

    @Override
    @Nullable
    public SharedChunkLocation getChunkRoot(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return this.chunks.get(chunkId);
    }

    public final void removeChunk(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        this.chunks.remove(chunkId);
        this.stats.updateAndGet(MemBasedSharedIndexStorage::removeChunk$lambda$0);
    }

    public final void appendChunk(@NotNull SharedChunkLocation chunkSourcePath, @NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkSourcePath, (String)"chunkSourcePath");
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        ((Map)this.chunks).put(chunkId, chunkSourcePath);
        this.stats.updateAndGet(MemBasedSharedIndexStorage::appendChunk$lambda$1);
    }

    @Override
    public void close() {
        this.chunks.clear();
        this.stats.set(new SharedIndexStats(0L, 0));
    }

    private static final SharedIndexStats removeChunk$lambda$0(SharedIndexStats old) {
        return old.plus(new SharedIndexStats(0L, -1));
    }

    private static final SharedIndexStats appendChunk$lambda$1(SharedIndexStats old) {
        return old.plus(new SharedIndexStats(0L, 1));
    }
}

