/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.extractors.NumberDisplayType;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsActions;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeColumnDisplayTypeAction
extends ActionGroup
implements DumbAware {
    public ChangeColumnDisplayTypeAction() {
        this.setPopup(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChangeColumnDisplayTypeAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            ChangeColumnDisplayTypeAction.$$$reportNull$$$0(1);
        }
        if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            ModelIndex<GridColumn> column = ChangeColumnDisplayTypeAction.getColumn(e);
            if (column != null) {
                ChangeColumnDisplayTypeAction.update(e, grid, column);
            } else {
                e.getPresentation().setEnabledAndVisible(false);
            }
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @Nullable
    private static ModelIndex<GridColumn> getColumn(@Nullable AnActionEvent e) {
        if (e == null) {
            return null;
        }
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid == null) {
            return null;
        }
        ModelIndex columnIdx = grid.getContextColumn();
        if (columnIdx.asInteger() == -1) {
            columnIdx = grid.getSelectionModel().getLeadSelectionColumn();
        }
        return columnIdx.asInteger() == -1 ? null : columnIdx;
    }

    private static void update(@NotNull AnActionEvent e, @NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (e == null) {
            ChangeColumnDisplayTypeAction.$$$reportNull$$$0(2);
        }
        if (grid == null) {
            ChangeColumnDisplayTypeAction.$$$reportNull$$$0(3);
        }
        if (columnIdx == null) {
            ChangeColumnDisplayTypeAction.$$$reportNull$$$0(4);
        }
        e.getPresentation().setText(DataGridBundle.message((String)"group.Console.TableResult.ColumnDisplayTypeChange.text", (Object[])new Object[0]));
        e.getPresentation().setEnabledAndVisible(ChangeColumnDisplayTypeAction.isBinary(columnIdx, grid) || ChangeColumnDisplayTypeAction.isIntegerOrBigInt(columnIdx, grid));
    }

    public static boolean isIntegerOrBigInt(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (columnIdx == null) {
            ChangeColumnDisplayTypeAction.$$$reportNull$$$0(5);
        }
        if (grid == null) {
            ChangeColumnDisplayTypeAction.$$$reportNull$$$0(6);
        }
        int type = GridCellEditorHelper.get(grid).guessJdbcTypeForEditing(grid, null, columnIdx);
        return ObjectFormatterUtil.isIntegerOrBigInt((int)type);
    }

    public static boolean isBinary(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (columnIdx == null) {
            ChangeColumnDisplayTypeAction.$$$reportNull$$$0(7);
        }
        if (grid == null) {
            ChangeColumnDisplayTypeAction.$$$reportNull$$$0(8);
        }
        int type = GridCellEditorHelper.get(grid).guessJdbcTypeForEditing(grid, null, columnIdx);
        GridColumn column = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
        return ObjectFormatterUtil.isBinary((GridColumn)column, (int)type);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ChangeColumnDisplayTypeAction.$$$reportNull$$$0(9);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ModelIndex<GridColumn> columnIdx = ChangeColumnDisplayTypeAction.getColumn(e);
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid == null || columnIdx == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ChangeColumnDisplayTypeAction.$$$reportNull$$$0(10);
            }
            return AnAction.EMPTY_ARRAY;
        }
        if (ChangeColumnDisplayTypeAction.isBinary(columnIdx, grid)) {
            BinaryDisplayType detectedDisplayType = grid.getOptimalBinaryDisplayTypeForDetect(columnIdx);
            String displayTypeName = detectedDisplayType == BinaryDisplayType.DETECT ? "" : " (" + detectedDisplayType.getName() + ")";
            AnAction[] anActionArray = Arrays.asList(new AnAction[]{new DisplayTypeAction(true, grid, columnIdx, (DisplayType)BinaryDisplayType.DETECT, DataGridBundle.message((String)"action.Console.TableResult.DisplayType.Detect.text", (Object[])new Object[0]) + displayTypeName), new Separator(), new DisplayTypeAction(grid.isDisplayTypeApplicable(BinaryDisplayType.UUID, columnIdx), grid, columnIdx, (DisplayType)BinaryDisplayType.UUID, DataGridBundle.message((String)"action.Console.TableResult.DisplayType.UUID.text", (Object[])new Object[0])), new DisplayTypeAction(grid.isDisplayTypeApplicable(BinaryDisplayType.UUID_SWAP, columnIdx), grid, columnIdx, (DisplayType)BinaryDisplayType.UUID_SWAP, DataGridBundle.message((String)"action.Console.TableResult.DisplayType.SwappedUUID.text", (Object[])new Object[0])), new DisplayTypeAction(grid.isDisplayTypeApplicable(BinaryDisplayType.TEXT, columnIdx), grid, columnIdx, (DisplayType)BinaryDisplayType.TEXT, DataGridBundle.message((String)"action.Console.TableResult.DisplayType.Text.text", (Object[])new Object[0])), new DisplayTypeAction(true, grid, columnIdx, (DisplayType)BinaryDisplayType.HEX, DataGridBundle.message((String)"action.Console.TableResult.DisplayType.Hex.text", (Object[])new Object[0])), new DisplayTypeAction(true, grid, columnIdx, (DisplayType)BinaryDisplayType.HEX_ASCII, DataGridBundle.message((String)"action.Console.TableResult.DisplayType.Hex.ASCII.text", (Object[])new Object[0]))}).toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ChangeColumnDisplayTypeAction.$$$reportNull$$$0(11);
            }
            return anActionArray;
        }
        AnAction[] anActionArray = Arrays.asList(new DisplayTypeAction(true, grid, columnIdx, (DisplayType)NumberDisplayType.NUMBER, DataGridBundle.message((String)"action.Console.TableResult.DisplayType.Number.text", (Object[])new Object[0])), new DisplayTypeAction(true, grid, columnIdx, (DisplayType)NumberDisplayType.TIMESTAMP_SECONDS, DataGridBundle.message((String)"action.Console.TableResult.DisplayType.Timestamp.Seconds.text", (Object[])new Object[0])), new DisplayTypeAction(true, grid, columnIdx, (DisplayType)NumberDisplayType.TIMESTAMP_MILLISECONDS, DataGridBundle.message((String)"action.Console.TableResult.DisplayType.Timestamp.Milliseconds.text", (Object[])new Object[0])), new DisplayTypeAction(true, grid, columnIdx, (DisplayType)NumberDisplayType.TIMESTAMP_MICROSECONDS, DataGridBundle.message((String)"action.Console.TableResult.DisplayType.Timestamp.Microseconds.text", (Object[])new Object[0]))).toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            ChangeColumnDisplayTypeAction.$$$reportNull$$$0(12);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChangeColumnDisplayTypeAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChangeColumnDisplayTypeAction";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isIntegerOrBigInt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBinary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    public static class DisplayTypeAction
    extends ToggleAction
    implements DumbAware {
        private final DisplayType myType;
        private final ModelIndex<GridColumn> myColumn;
        private final DataGrid myGrid;
        private final boolean isEnabled;

        DisplayTypeAction(boolean isEnabled, @NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> column, @NotNull DisplayType type, @NlsActions.ActionText @NotNull String name) {
            if (grid == null) {
                DisplayTypeAction.$$$reportNull$$$0(0);
            }
            if (column == null) {
                DisplayTypeAction.$$$reportNull$$$0(1);
            }
            if (type == null) {
                DisplayTypeAction.$$$reportNull$$$0(2);
            }
            if (name == null) {
                DisplayTypeAction.$$$reportNull$$$0(3);
            }
            super(name);
            this.myType = type;
            this.myColumn = column;
            this.myGrid = grid;
            this.isEnabled = isEnabled;
        }

        public DisplayType getType() {
            return this.myType;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DisplayTypeAction.$$$reportNull$$$0(4);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DisplayTypeAction.$$$reportNull$$$0(5);
            }
            super.update(e);
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(this.isEnabled);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                DisplayTypeAction.$$$reportNull$$$0(6);
            }
            return this.myType == this.myGrid.getPureDisplayType(this.myColumn);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                DisplayTypeAction.$$$reportNull$$$0(7);
            }
            if (state) {
                this.myGrid.setDisplayType(this.myColumn, this.myType);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChangeColumnDisplayTypeAction$DisplayTypeAction";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChangeColumnDisplayTypeAction$DisplayTypeAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

