(*++

Copyright (C) 2019 Calculator developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Pascal application that demonstrates the
 usage of the Pascal bindings of Calculator library

Interface version: 1.0.0

*)

program CalculatorPascalTest;

uses
  {$IFDEF UNIX}{$IFDEF UseCThreads}
  cthreads,
  {$ENDIF}{$ENDIF}
  Classes, SysUtils, CustApp,
  Unit_Calculator
  { you can add units after this };

type

TCalculator_Example = class(TCustomApplication)
protected
  procedure DoRun; override;
  procedure TestCalculator ();
public
  constructor Create(TheOwner: TComponent); override;
  destructor Destroy; override;
end;


procedure TCalculator_Example.TestCalculator ();
var
  ACalculatorWrapper: TCalculatorWrapper;
  AMajor, AMinor, AMicro: Cardinal;
  AVersionString: string;
  ALibPath: string;
  AVariable1, AVariable1Again: TCalculatorVariable;
  AVariable2: TCalculatorVariable;
  AResultVariable: TCalculatorVariable;
  ACalculator: TCalculatorCalculator;
begin
  writeln ('loading DLL');
  ALibPath := ''; // TODO add the location of the shared library binary here
  ACalculatorWrapper := TCalculatorWrapper.Create (ALibPath + '/' + 'calculator.'); // TODO add the extension of the shared library file here
  try
    writeln ('loading DLL Done');
    ACalculatorWrapper.GetVersion(AMajor, AMinor, AMicro);
    AVersionString := Format('Calculator.version = %d.%d.%d', [AMajor, AMinor, AMicro]);
    writeln(AVersionString);

    // Create calculator and fill with two variables
    ACalculator := ACalculatorWrapper.CreateCalculator();
    AVariable1 := ACalculatorWrapper.CreateVariable(2.0);
    AVariable2 := ACalculatorWrapper.CreateVariable(3.0);
    ACalculator.EnlistVariable(AVariable1);
    ACalculator.EnlistVariable(AVariable2);
    // Release variables on client side.
    // The calculator still holds these variables
    FreeAndNil(AVariable1);
    FreeAndNil(AVariable2);


    AResultVariable := ACalculator.Add();
    writeln(Format('   sum = %f', [AResultVariable.GetValue()]));
    FreeAndNil(AResultVariable);

    writeln('Changing the value of the first summand');
    AVariable1Again := ACalculator.GetEnlistedVariable(0);
    AVariable1Again.SetValue(10.0);
    FreeAndNil(AVariable1Again);

    AResultVariable := ACalculator.Add();
    writeln(Format('   sum = %f', [AResultVariable.GetValue()]));
    FreeAndNil(AResultVariable);

   finally
    FreeAndNil(ACalculator);
    FreeAndNil(AVariable1);
    FreeAndNil(AVariable2);
    FreeAndNil(AVariable1Again);
    FreeAndNil(AResultVariable);
    FreeAndNil(ACalculatorWrapper);
  end;
end;

procedure TCalculator_Example.DoRun;
begin
  try
    TestCalculator();
  except
    On E: Exception do
      writeln ('Fatal error: ', E.Message);
  end;
  Terminate
end;

constructor TCalculator_Example.Create(TheOwner: TComponent);
begin
  inherited Create(TheOwner);
  StopOnException:=True;
end;

destructor TCalculator_Example.Destroy;
begin
  inherited Destroy;
end;


var
  Application: TCalculator_Example;
begin
  Application:=TCalculator_Example.Create(nil);
  Application.Run;
  Application.Free;
end.
