/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.BasedUtils;
import com.vladsch.flexmark.util.sequence.MappedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.ReplacedBasedSequence;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.builder.IBasedSegmentBuilder;
import com.vladsch.flexmark.util.sequence.mappers.CharMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MappedBasedSequence
extends BasedSequenceImpl
implements MappedSequence<BasedSequence>,
ReplacedBasedSequence {
    private final CharMapper mapper;
    private final BasedSequence baseSeq;

    private MappedBasedSequence(BasedSequence baseSeq, CharMapper mapper) {
        super(0);
        this.baseSeq = baseSeq;
        this.mapper = mapper;
    }

    @Override
    @NotNull
    public CharMapper getCharMapper() {
        return this.mapper;
    }

    @Override
    public char charAt(int index) {
        return this.mapper.map(this.baseSeq.charAt(index));
    }

    @Override
    @NotNull
    public BasedSequence getCharSequence() {
        return this.baseSeq;
    }

    @Override
    public int length() {
        return this.baseSeq.length();
    }

    @Override
    @NotNull
    public BasedSequence toMapped(CharMapper mapper) {
        return mapper == CharMapper.IDENTITY ? this : new MappedBasedSequence(this.baseSeq, this.mapper.andThen(mapper));
    }

    @Override
    public int getOptionFlags() {
        return this.getBaseSequence().getOptionFlags();
    }

    @Override
    public boolean allOptions(int options) {
        return this.getBaseSequence().allOptions(options);
    }

    @Override
    public boolean anyOptions(int options) {
        return this.getBaseSequence().anyOptions(options);
    }

    @Override
    public <T> T getOption(DataKeyBase<T> dataKey) {
        return this.getBaseSequence().getOption(dataKey);
    }

    @Override
    @Nullable
    public DataHolder getOptions() {
        return this.getBaseSequence().getOptions();
    }

    @Override
    @NotNull
    public BasedSequence sequenceOf(@Nullable CharSequence baseSeq, int startIndex, int endIndex) {
        if (baseSeq instanceof MappedBasedSequence) {
            return startIndex == 0 && endIndex == baseSeq.length() ? (BasedSequence)baseSeq : (BasedSequence)((BasedSequence)baseSeq).subSequence(startIndex, endIndex).toMapped(this.mapper);
        }
        return new MappedBasedSequence((BasedSequence)this.baseSeq.sequenceOf(baseSeq, startIndex, endIndex), this.mapper);
    }

    @Override
    @NotNull
    public BasedSequence subSequence(int startIndex, int endIndex) {
        SequenceUtils.validateStartEnd(startIndex, endIndex, this.length());
        if (startIndex == 0 && endIndex == this.baseSeq.length()) {
            return this;
        }
        return new MappedBasedSequence(this.baseSeq.subSequence(startIndex, endIndex), this.mapper);
    }

    @Override
    @NotNull
    public Object getBase() {
        return this.baseSeq.getBase();
    }

    @Override
    @NotNull
    public BasedSequence getBaseSequence() {
        return this.baseSeq.getBaseSequence();
    }

    @Override
    public int getStartOffset() {
        return this.baseSeq.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.baseSeq.getEndOffset();
    }

    @Override
    public int getIndexOffset(int index) {
        return this.baseSeq.charAt(index) == this.charAt(index) ? this.baseSeq.getIndexOffset(index) : -1;
    }

    @Override
    public void addSegments(@NotNull IBasedSegmentBuilder<?> builder) {
        BasedUtils.generateSegments(builder, this);
    }

    @Override
    @NotNull
    public Range getSourceRange() {
        return this.baseSeq.getSourceRange();
    }

    @NotNull
    public static BasedSequence mappedOf(@NotNull BasedSequence baseSeq, @NotNull CharMapper mapper) {
        return new MappedBasedSequence(baseSeq, mapper);
    }
}

