Program DolbyBi64 (Input,Output);

{ Warning. Program not complete or not tested }

{ This will be an experemental program }
{ to decode recordings made in DolbyB  }

{ Modify to allow 2 alternative methods for DolbyC }


Uses SysUtils,Math,Crt;

{$I LibI64\ErrMsg.Lib}
{$I LibI64\Param.Lib}
{$I LibI64\WavIn.Lib}
{$I LibI64\WavOut.Lib}
{ Side path routines }
{$I LibI64\SidePath.Lib}
{$I LibI64\Mixers.Lib}
{$I LibI64\FindOutSmp.Lib}
{ Callibration }
{$I LibI64\Calibrate.Lib}

Const
  DisUpdIntSec = 20;

Var
  InSkSm,            { Total number of input samples to be skipped }
  OutSmp,            { Number of samples in output file            }
  EndSmp,            { Last sample number to be processed          }
  SmpCnt : QWord;    { Number of samples sent to the output        }

  { Display update variables }
  DspCnt,
  DspUpd,
  DspMin,
  DspHur,
  DspSec : QWord;

  { Wave value multiplication }
  WvInMx,
  WvOtDv : Int64;

{*********************************}
{***   Initialising Routines   ***}
{*********************************}

Procedure FirstInit;
{ Some initial initalising, before the input wave is read,  }
{ so before the sample rate and number of samples in known. }
Begin;
  ErrMsgInit;
  ParamRead;
  WavInInit ( ParamMnSmSc,ParamMxSmSc,ParamInBuf );
  WavOutInit;
End;

Procedure SecondInit;
{ More initalising, after the input wave header has been read,  }
{ so the sample rate and number of samples is now known.        }
Begin;
  { Set up sample rates }
  If ( ParamUpSamp = 0 ) Then
    While ( ParamUpSamp * WavInSmpSec < 200000 ) Do
      ParamUpSamp := ParamUpSamp + 1;
  If ParamAllHig Then
    ParamInUS := ParamUpSamp
  Else
    ParamInUS := 1;

  { Display update variables }
  DspCnt := 0;
  DspUpd := DisUpdIntSec * WavInSmpSec;
  DspMin := 0;
  DspSec := 0;

  { Set Sample Count and inital skip }
  SmpCnt := 0;
  If ( ParamStSec > 0 ) Then
    InSkSm := ParamStSec * WavInSmpSec
  Else
    InSkSm := 0;
  If Not ( InSkSm < WavInTotSmp ) Then
    ErrMsgFlagError ( 'Start is past the end of the input' );
  { Set output length and last sample }
  If Not ErrMsgFlg Then
    Begin;
      If ( ParamLnSec > 0 ) Then
        OutSmp := ParamLnSec * WavInSmpSec
      Else
        OutSmp := WavInTotSmp - InSkSm;
      EndSmp := InSkSm + OutSmp;
      If ( EndSmp > WavInTotSmp ) Then
        Begin;
          ErrMsgWarning ( 'End is past the end of the input' );
          OutSmp := WavInTotSmp - InSkSm;
          EndSmp := InSkSm + OutSmp;
        End;
     End;
  { Initialise side path routines }
  SidePathInit;
  FindOutSmpInit;
End;

Procedure SetWaveMultiplyers;
Begin;
  { Set multiplyer for wavinput and devider for wave output }
  Case WavInBDepth of
     8: WvInMx := ParamSMux08;
    16: WvInMx := ParamSMux16;
    24: WvInMx := ParamSMux24;
  End; { of case }
  Case WavOutBDepth of
     8 : WvOtDv := ParamSMux08;
    16 : WvOtDv := ParamSMux16;
    24 : WvOtDv := ParamSMux24;
  End; { of case }
End;

Procedure OpenInputFile;
{ Open input Wave file }
Begin;
  If Not ErrMsgFlg Then
    WavInOpen ( ParamInName,ParamRetry );
  If Not ErrMsgFlg Then
    WavInReadHeader;
End;

Procedure SetOutputParameters;
Var
  BytSmp,
  MaxSmp : Cardinal;
Begin;
  { Set output wave parameters }
  WavOutNumChn := WavInNumChn;
  If ( ParamOutBD = 0 ) Then
    WavOutBDepth := WavInBDepth
  Else
    WavOutBDepth := ParamOutBD;
  WavOutSmpSec := WavInSmpSec;
  If ParamNo64 Then
    Begin; { Check there are no too many samples for 32bit output }
      BytSmp := WavOutNumChn * ( WavOutBDepth Div 8 );
      MaxSmp := ( WavOutMax32Siz - 36 ) Div BytSmp;
      If ( OutSmp > MaxSmp ) Then
        Begin;
          ErrMsgWarning ( 'Reducing length, for 32 bit output' );
          OutSmp := MaxSmp;
        End;
    End;
  WavOutTotSmp := OutSmp;
End;

Procedure OpenOutputFile;
{ Open output output wave file }
Begin;
  If Not ErrMsgFlg Then
    WavOutOpen ( ParamOutNam );
  If Not ErrMsgFlg Then
    WavOutSendHeader;
End;


Procedure CloseFiles;
Begin;
  WavInClose;
  WavOutClose;
End;

{***********************************}
{***   Display update routines   ***}
{***********************************}

Procedure UpdateDisplay;
Begin;
  { Update seconds }
  While Not ( DspCnt < WavInSmpSec ) Do
    Begin;
      DspCnt := DspCnt - WavInSmpSec;
      DspSec := DspSec + 1;
    End;
  { Update Minutes }
  While ( DspSec > 59 ) Do
    Begin;
      DspSec := DspSec - 60;
      DspMin := DspMin + 1;
    End;
  { Update Hours }
  While ( DspMin > 59 ) Do
    Begin;
      DspMin := DspMin - 60;
      DspHur := DspHur + 1;
    End;
  { Now update the display }
  Write ( Chr ( 13 ));
  Write ( 'Processed Hours:Min:Sec ' );
  Write ( DspHur );
  Write ( ':' );
  If ( DspMin < 10 ) Then Write ( '0' );
  Write ( DspMin );
  Write ( ':' );
  If ( DspSec < 10 ) Then Write ( '0' );
  Write ( DspSec );
End;


{************************************}
{***   Wave shortening routines   ***}
{************************************}

Procedure SkipBlock ( BlkSec : Word; Update : Boolean );
Var
  BlkSmp,
  BytSmp,
  SkpByt : QWord;
Begin;
  BlkSmp := BlkSec * WavInSmpSec;
  BytSmp := WavInNumChn * ( WavInBDepth Div 8 );
  SkpByt := BlkSmp * BytSmp;
  WavInSkipBytes ( SkpByt );
  DspCnt := DspCnt + BlkSmp;
  SmpCnt := SmpCnt + BlkSmp;
  If Update Then
    UpdateDisplay;
End;


Procedure SkipSeconds ( SkpSec : Cardinal );
Var
  SecLft : Cardinal;
Begin;
  SecLft := SkpSec;
  While ( SecLft > 59 ) Do
    Begin;
      SkipBlock ( 60,True );
      SecLft := SecLft - 60;
    End;
  While ( SecLft > 9 ) Do
    Begin;
      SkipBlock ( 10,True );
      SecLft := SecLft - 10;
    End;
  If ( SecLft > 0 ) Then
    SkipBlock ( SecLft,False );
End;

{*************************************}
{***   Audio processing routines   ***}
{*************************************}


Function NextSamp : Int64;
Begin;
  If ParamInGFlg Then
    NextSamp := Round ( ParamInGain * WvInMx * WavInGetSample )
  Else
    NextSamp := WvInMx * WavInGetSample;
End;

Procedure OutSamp ( SmpVal : Int64 );
Var
  SmpOut : Int64;
Begin;
  If ParamOtGFlg Then
    SmpOut := Round ( ParamOtGain * SmpVal )
  Else
    SmpOut := SmpVal;
  WavOutSendSample ( SmpOut Div WvOtDv );
End;


Procedure EncodeAudio;
Var
  ChnCnt,
  UpCnt  : Word;
  SmpVal,
  SidSmp,
  TotSmp : Int64;
Begin;
  UpdateDisplay;
  While (( SmpCnt < EndSmp ) And Not ErrMsgFlg ) Do
    Begin;
      For ChnCnt := 1 To WavInNumChn Do
        Begin;
          { Choose output selection }
          ParamOtSl := ParamOutSel[ChnCnt];

          { Get input }
          SmpVal := NextSamp;

          { If Upsampling at the start then the same sample }
          { is processed several times }
          TotSmp := 0;
          For UpCnt := 1 To ParamInUS Do
            Begin;
              { Add audio from side path }
              SidSmp := SidePath ( SmpVal,ChnCnt );
              TotSmp := TotSmp + MixersEncode ( SmpVal,SidSmp );
             End;
          SmpVal := TotSmp Div ParamInUS;
          { Send to output }
          If ( ParamOtSl = 0 ) Then
            OutSamp ( SmpVal )
          Else
            OutSamp ( ParamOtSm );
        End;
      { Update Counters }
      SmpCnt := SmpCnt + 1;
      DspCnt := DspCnt + 1;
      If Not ( DspCnt < DspUpd ) Then
        UpdateDisplay;
    End;
End;


Procedure DecodeAudio;
Var
  ChnCnt,
  UpCnt  : Word;
  SmpVal,
  SidVal,
  OutVal,
  TotSmp : Int64;
Begin;
  UpdateDisplay;
  { Process samples }
  While (( SmpCnt < EndSmp ) And Not ErrMsgFlg ) Do
    Begin;
      For ChnCnt := 1 To WavInNumChn Do
        Begin;
          { Choose output selection }
          ParamOtSl := ParamOutSel[ChnCnt];

          { Get input }
          SmpVal := NextSamp;

          { If Upsampling at the start then the same sample }
          { is processed several times }
          TotSmp := 0;
          For UpCnt := 1 To ParamInUS Do
            Begin;
              { Set and process output }
              OutVal := FindOutSmp  ( SmpVal,ChnCnt );
              SidVal := SidePathUpdate ( ChnCnt );
              OutVal := MixersDecode ( SmpVal,SidVal );
              TotSmp := TotSmp + OutVal;
             End;
          OutVal := TotSmp Div ParamInUS;

          { Send Result }
          If ( ParamOtSl = 0 ) Then
            OutSamp ( OutVal )
          Else
            OutSamp ( ParamOtSm );
        End;
      { Update Counters }
      SmpCnt := SmpCnt + 1;
      DspCnt := DspCnt + 1;
      If Not ( DspCnt < DspUpd ) Then
        UpdateDisplay;
    End;
End;


Procedure NoDolby;
Var
  ChnCnt : Word;
  SmpVal : Int64;
Begin;
  UpdateDisplay;
  While (( SmpCnt < EndSmp ) And Not ErrMsgFlg ) Do
    Begin;
      For ChnCnt := 1 To WavInNumChn Do
        Begin;
          { Get input }
          SmpVal := NextSamp;

          { Apply mixer as if encoding }
          SmpVal := MixersEncode ( SmpVal,0 );

          { Send to output }
          OutSamp ( SmpVal );
        End;
      { Update Counters }
      SmpCnt := SmpCnt + 1;
      DspCnt := DspCnt + 1;
      If Not ( DspCnt < DspUpd ) Then
        UpdateDisplay;
    End;
End;


Procedure Encode;
Begin;
  If ParamDlbOff Then
    NoDolby
  Else
    EncodeAudio;
End;

Procedure Decode;
Begin;
  If ParamDlbOff Then
    NoDolby
  Else
    DecodeAudio;
End;

{************************}
{***   Main Program   ***}
{************************}

Begin;
  WriteLn;
  WriteLn ( '********************************************************************' );
  WriteLn ( '***   Program DolbyBi64 written by R.P.Evans.                    ***' );
  WriteLn ( '***   64Bit version. Last updated on 1st April 2018.             ***' );
  WriteLn ( '***                                                              ***' );
  WriteLn ( '***   Experemental program, written for my own personal use.     ***' );
  WriteLn ( '***                                                              ***' );
  WriteLn ( '***   I accept absolutely no liability for use of this program   ***' );
  WriteLn ( '***   Use is entirely at the users own risk.                     ***' );
  WriteLn ( '********************************************************************' );
  WriteLn;
  FirstInit;
  If Not ErrMsgFlg Then
    OpenInputFile;
  If ParamCal Then
    { Calibration is performed if selected, irrespective of errors }
    { but we must make sure a sample rate is set }
    Begin;
      If ( WavInBDepth = 0 ) Then
        WavInBDepth := 16;
      If ( ParamCFrq < ParamMnSmSc ) Then
        ParamCFrq := CalibrateTestSmpSec;
      If ErrMsgFlg Then
        WavInSmpSec := ParamCFrq
      Else
        ParamCFrq := WavInSmpSec;
      SecondInit;
      Calibrate;
    End;
  If ( ParamQuiet < 2 ) Then WriteLn;
  If ParamExm Then
    { Parameter example is written if selected, irrespective of errors }
    { So that the example will include calibration if selected }
    ParamWriteExample ( ParamExNm );
  If Not ErrMsgFlg Then
    SecondInit;
  If Not ErrMsgFlg Then
    SetOutputParameters;
  If Not ErrMsgFlg Then
    SkipSeconds ( ParamStSec );
  If Not ErrMsgFlg Then
    OpenOutputFile;
  If Not ErrMsgFlg Then
    SetWaveMultiplyers;
  If Not ErrMsgFlg Then
    If ParamEnc Then
      Encode
    Else
      Decode;
  If Not ErrMsgFlg Then
    UpdateDisplay;
  If (( ParamLnSec = 0 ) And Not ErrMsgFlg ) Then
    WavInCheckFileEnd;
  CloseFiles;
  Writeln;
  If Not ParamNoWarn Then
    ErrMsgWarningSummery; 
  If ( ParamQuiet < 2 ) Then WriteLn  ( 'Processing complete.' );
End.
