/* vim: set shiftwidth=4 tabstop=8 softtabstop=4: */
/* $Id: sptint.h,v 1.2 2003/12/12 07:06:41 shinra Exp $ */

#ifndef SPTINT_H
#define SPTINT_H

#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#elif defined(HAVE_STDINT_H)
# include <stdint.h>
#elif defined(HAVE_INT32_T)
# include <sys/types.h>
#endif

#ifdef HAVE_INT32_T
typedef int8_t spt_int8_t;
typedef int16_t spt_int16_t;
typedef int32_t spt_int32_t;
typedef intptr_t spt_intptr_t;
typedef uint8_t spt_uint8_t;
typedef uint16_t spt_uint16_t;
typedef uint32_t spt_uint32_t;
typedef uintptr_t spt_uintptr_t;
#else /* HAVE_INT32_T */
/* ILP32 and LP64 */
typedef signed char spt_int8_t;
typedef short spt_int16_t;
typedef int spt_int32_t;
typedef unsigned long spt_intptr_t;
typedef unsigned char spt_uint8_t;
typedef unsigned short spt_uint16_t;
typedef unsigned int spt_uint32_t;
typedef unsigned long spt_uintptr_t;
#endif /* !HAVE_INT32_T */

#endif /* SPTINT_H */
/* vim: set sw=2: */
