/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.events;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component
@NonNullByDefault
public class OSGiEventPublisher
implements EventPublisher {
    protected static final String SOURCE = "source";
    protected static final String TOPIC = "topic";
    protected static final String PAYLOAD = "payload";
    protected static final String TYPE = "type";
    private final @Nullable EventAdmin osgiEventAdmin;

    @Activate
    public OSGiEventPublisher(@Reference @Nullable EventAdmin eventAdmin) {
        this.osgiEventAdmin = eventAdmin;
    }

    @Override
    public void post(Event event) throws IllegalArgumentException, IllegalStateException {
        EventAdmin eventAdmin = this.osgiEventAdmin;
        this.assertValidArgument(event);
        this.assertValidState(eventAdmin);
        this.postAsOSGiEvent(eventAdmin, event);
    }

    private void postAsOSGiEvent(@Nullable EventAdmin eventAdmin, Event event) throws IllegalStateException {
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>(3);
            ((Dictionary)properties).put(TYPE, event.getType());
            ((Dictionary)properties).put(PAYLOAD, event.getPayload());
            ((Dictionary)properties).put(TOPIC, event.getTopic());
            String string = event.getSource();
            if (string instanceof String) {
                String source = string;
                ((Dictionary)properties).put(SOURCE, source);
            }
            eventAdmin.postEvent(new org.osgi.service.event.Event("openhab", properties));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot post the event via the event bus. Error message: " + e.getMessage(), e);
        }
    }

    private void assertValidArgument(Event event) throws IllegalArgumentException {
        String errorMsg = "The %s of the 'event' argument must not be null or empty.";
        String value = event.getType();
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(String.format(errorMsg, TYPE));
        }
        value = event.getPayload();
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(String.format(errorMsg, PAYLOAD));
        }
        value = event.getTopic();
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(String.format(errorMsg, TOPIC));
        }
    }

    private void assertValidState(@Nullable EventAdmin eventAdmin) throws IllegalStateException {
        if (eventAdmin == null) {
            throw new IllegalStateException("The event bus module is not available!");
        }
    }
}

