/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.minidns.cache.LruCache;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnsqueryresult.SynthesizedCachedDnsQueryResult;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class ExtendedLruCache
extends LruCache {
    public ExtendedLruCache() {
        this(512);
    }

    public ExtendedLruCache(int capacity) {
        super(capacity);
    }

    public ExtendedLruCache(int capacity, long maxTTL) {
        super(capacity, maxTTL);
    }

    @Override
    protected void putNormalized(DnsMessage q, DnsQueryResult result) {
        super.putNormalized(q, result);
        DnsMessage message = result.response;
        HashMap<DnsMessage, List<Record<? extends Data>>> extraCaches = new HashMap<DnsMessage, List<Record<? extends Data>>>(message.additionalSection.size());
        this.gather(extraCaches, q, message.answerSection, null);
        this.gather(extraCaches, q, message.authoritySection, null);
        this.gather(extraCaches, q, message.additionalSection, null);
        this.putExtraCaches(result, extraCaches);
    }

    @Override
    public void offer(DnsMessage query, DnsQueryResult result, DnsName authoritativeZone) {
        DnsMessage reply = result.response;
        assert (!reply.authoritativeAnswer);
        HashMap<DnsMessage, List<Record<? extends Data>>> extraCaches = new HashMap<DnsMessage, List<Record<? extends Data>>>(reply.additionalSection.size());
        this.gather(extraCaches, query, reply.authoritySection, authoritativeZone);
        this.gather(extraCaches, query, reply.additionalSection, authoritativeZone);
        this.putExtraCaches(result, extraCaches);
    }

    private void gather(Map<DnsMessage, List<Record<? extends Data>>> extraCaches, DnsMessage q, List<Record<? extends Data>> records, DnsName authoritativeZone) {
        for (Record<? extends Data> extraRecord : records) {
            DnsMessage.Builder additionalRecordQuestionBuilder;
            if (!this.shouldGather(extraRecord, q.getQuestion(), authoritativeZone) || (additionalRecordQuestionBuilder = extraRecord.getQuestionMessage()) == null) continue;
            additionalRecordQuestionBuilder.copyFlagsFrom(q);
            additionalRecordQuestionBuilder.setAdditionalResourceRecords(q.additionalSection);
            DnsMessage additionalRecordQuestion = additionalRecordQuestionBuilder.build();
            if (additionalRecordQuestion.equals(q)) continue;
            List<Record<? extends Data>> additionalRecords = extraCaches.get(additionalRecordQuestion);
            if (additionalRecords == null) {
                additionalRecords = new ArrayList<Record<? extends Data>>();
                extraCaches.put(additionalRecordQuestion, additionalRecords);
            }
            additionalRecords.add(extraRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putExtraCaches(DnsQueryResult synthesynthesizationSource, Map<DnsMessage, List<Record<? extends Data>>> extraCaches) {
        DnsMessage reply = synthesynthesizationSource.response;
        for (Map.Entry<DnsMessage, List<Record<? extends Data>>> entry : extraCaches.entrySet()) {
            DnsMessage question = entry.getKey();
            DnsMessage answer = reply.asBuilder().setQuestion(question.getQuestion()).setAuthoritativeAnswer(true).addAnswers((Collection<Record<? extends Data>>)entry.getValue()).build();
            SynthesizedCachedDnsQueryResult cachedDnsQueryResult = new SynthesizedCachedDnsQueryResult(question, answer, synthesynthesizationSource);
            ExtendedLruCache extendedLruCache = this;
            synchronized (extendedLruCache) {
                this.backend.put(question, cachedDnsQueryResult);
            }
        }
    }

    protected boolean shouldGather(Record<? extends Data> extraRecord, Question question, DnsName authoritativeZone) {
        boolean extraRecordIsChildOfQuestion = extraRecord.name.isChildOf(question.name);
        boolean extraRecordIsChildOfAuthoritativeZone = false;
        if (authoritativeZone != null) {
            extraRecordIsChildOfAuthoritativeZone = extraRecord.name.isChildOf(authoritativeZone);
        }
        return extraRecordIsChildOfQuestion || extraRecordIsChildOfAuthoritativeZone;
    }
}

